/*!
 *   ʐ䕔..
 *
 */
#include <QtGlobal>
#include <QMessageBox>
#include <QDateTime>
#include <QString>
#include <QVariant>
#include "screenControl.h"
#include "a2BCthread.h"

/*!
 *  RXgN^
 *
 */
screenControl::screenControl(Ui::a2BCMain *apForm, QWidget *parent)
  : QWidget(parent), mpForm(apForm), mpDB(0), mpModel(0), mpHttpConn(0), mpHttpMain(0)
{
	createClasses();
	initializeDatas();
    connectSignals();
}

/*!
 *  fXgN^
 *
 */
screenControl::~screenControl()
{
	deleteClasses();
}

/*!
 *  NX̐
 *
 */
void screenControl::createClasses(void)
{
	mpDB          = new screenData();
    mpTimer       = new a2BCthread();
	mpHttpMain    = new QHttp();
    mpIndexParser = new a2BCindexParser();
	mpHttpConn    = new a2BChttpConnection(mpHttpMain);
	mpModel       = new a2BCmodel(mpDB, mpHttpConn, mpIndexParser);

	return;
}

/*!
 *  NX̍폜
 *
 */
void screenControl::deleteClasses(void)
{
	if (mpDB != 0)
	{
		delete mpDB;
		mpDB = 0;
	}

	if (mpModel != 0)
	{
		delete mpModel;
		mpModel = 0;
	}
}

/*!
 *  f[^̏(Windowf[^̏)s
 *
 */
void screenControl::initializeDatas(void)
{
	// 擾URL
	QString data;
	data = mpDB->getBbsTableUrl();
	(mpForm->urlBbsTable)->setText(data);

	// XVt@C
	data = mpDB->getBbsTableFileName();
	(mpForm->lineEdit_File_bbsTable)->setText(data);

	// subject.txtXV
	Qt::CheckState checkState;
	checkState = mpDB->getUpdateSubjectTxt();
	(mpForm->chkGetSubjectTxt)->setCheckState(checkState);

	// datXǂ߂悤ɂ
	checkState = mpDB->getEnableDownThread();
	(mpForm->chkEnableDownThread)->setCheckState(checkState);

	// q̃XǗΏۂɂ
	checkState = mpDB->getAddThreadToIndex();
	(mpForm->chkAdjustInformation)->setCheckState(checkState);
	(mpForm->chkAdjustInformation)->setEnabled(false);
    (mpForm->chkAdjustInformation)->hide();

	// ꗗɃX擾uCɓvƂĒǉ
	checkState = mpDB->getAddToBbsTable();
	(mpForm->chkModifyBbsTable)->setCheckState(checkState);

    // XSčĎ擾
    checkState = mpDB->getDisableGetPart();
    (mpForm->chkGetAgainAll)->setCheckState(checkState);

    // G[XǗΏۂ͂
    checkState = mpDB->getRemoveErrorMessage();
    (mpForm->chkRemoveErrorThread)->setCheckState(checkState);

	// X擾Ԋu
	QVariant interval = mpDB->getReceiveInterval();
	(mpForm->getInterval)->setText(interval.toString());

	// {^Q̗L/ݒɂ
	(mpForm->pBtnSelectionBbsTable)->setEnabled(true);
	(mpForm->pBtnUpdateBbsTable)->setEnabled(false);
    (mpForm->executeUpdate)->setEnabled(false);
    (mpForm->executeCancel)->setEnabled(false);

    mpTimer->run();
	return;
}

/*!
 *  signalslotڑ
 *
 */
void screenControl::connectSignals(void)
{
    qDebug("screenControl::connectSignals()");

	// "Q"{^Ƃ̏
	connect(mpForm->pBtnSelectionBbsTable, SIGNAL(clicked()),
            this,                          SLOT(selection_bbsTableFile()));

	// "bbstable.html̍XV"{^Ƃ̏
	connect(mpForm->pBtnUpdateBbsTable, SIGNAL(clicked()),
            this,                       SLOT(select_updateBbsTableFile()));

	// s{^Ƃ̏
	connect(mpForm->executeUpdate, SIGNAL(clicked()),
            this,                  SLOT(executeUpdate()));
	
	// LZ{^̏
    connect(mpForm->executeCancel, SIGNAL(clicked()),
            this,                  SLOT(cancelUpdate()));

	// eLXgXVƂ̏ (t@C)
	connect(mpForm->lineEdit_File_bbsTable, SIGNAL(editingFinished()),
            this,                           SLOT(changed_bbsTableFile()));

	// eLXgXVƂ̏ (URL)
	connect(mpForm->urlBbsTable, SIGNAL(editingFinished()),
            this,                SLOT(changed_bbsTableUrl()));

	// eLXgXV̏(擾Ԋu)
	connect(mpForm->getInterval, SIGNAL(editingFinished()),
            this,                SLOT(changed_interval()));

	// \bZ[W̎M
	connect(mpModel, SIGNAL(updateMessage(const QString &)),
            this,    SLOT(updateMessage(const QString &)));

    // ^C}ݒ
    connect(mpModel, SIGNAL(setTimer(int, unsigned long)),
            mpTimer, SLOT(setTimer(int, unsigned long)));

    // ^CAEg̎M
    connect(mpTimer, SIGNAL(timeout(int)),
            mpModel, SLOT(receiveTimeout(int)));

    // O擾̊Jn
    connect(mpModel, SIGNAL(startedUpdate()),
            this,    SLOT(startedUpdate()));

    // O擾̏I
    connect(mpModel, SIGNAL(completedUpdate()),
            this,    SLOT(completedUpdate()));

	// ʐMԍXV̕
	connect(mpHttpConn, SIGNAL(updateMessage(const QString &)),
            this,    SLOT(updateMessage(const QString &)));

	// ʐMI̕
	connect(mpHttpConn, SIGNAL(completedCommunication(int, QString &)),
            this,    SLOT(completedCommunication(int, QString &)));

    // ʐMI̕
    connect(this,    SIGNAL(completedCommunication(int)),
            mpModel,  SLOT(completedCommunication(int)));

    // ̒ʐMJn...
    connect(this,    SIGNAL(nextCommunication()),
            mpModel,  SLOT(nextCommunication()));

	// 
    connect(mpHttpMain, SIGNAL(requestFinished(int, bool)),
            mpHttpConn,   SLOT(requestFinished(int, bool)));

	// 
    connect(mpHttpMain, SIGNAL(done(bool)),
            mpHttpConn,   SLOT(done(bool)));

    // 
    connect(mpHttpMain, SIGNAL(readyRead(const QHttpResponseHeader &)),
            mpHttpConn,   SLOT(readyRead(const QHttpResponseHeader &)));
    return;
}

/*!
 *  "Q..."{^Ƃ̏
 *
 */
void screenControl::selection_bbsTableFile()
{
    qDebug("screenControl::selection_bbsTableFile()");

	QString fileName = mpDB->getBbsTableFileName();
	bool result = mpModel->selection_bbsTableFile(fileName);
	if (result == true)
	{
		// w肵t@Cݒ肷
		(mpForm->lineEdit_File_bbsTable)->setText(fileName);
		mpDB->setBbsTableFileName(fileName);
	}
	if (fileName.contains("bbstable.html") == false)
	{
		// {^Q̗L/ݒɂ
		(mpForm->pBtnSelectionBbsTable)->setEnabled(true);
		(mpForm->pBtnUpdateBbsTable)->setEnabled(false);
		(mpForm->executeUpdate)->setEnabled(false);
		(mpForm->executeCancel)->setEnabled(false);
	}
	else
	{
		// {^Q̗L/ݒɂ
		(mpForm->pBtnSelectionBbsTable)->setEnabled(true);
		(mpForm->pBtnUpdateBbsTable)->setEnabled(true);
		(mpForm->executeUpdate)->setEnabled(true);
		(mpForm->executeCancel)->setEnabled(false);
	}
	return;
}

/*!
 *  "bbstable.html̍XV" {^Ƃ̏
 *
 */
void screenControl::select_updateBbsTableFile()
{
	// ʏԂ֔f
	updateFormData();

    // XVt@C̊mF
	QString fileName = mpDB->getBbsTableFileName();
	if (fileName.contains("bbstable.html") == false)
	{
		// t@Cbbstable.htmlw肳ĂȂꍇ
		QMessageBox mb("a2BC", tr("Invalid FileName"),
		               QMessageBox::Information,
			           QMessageBox::Ok | QMessageBox::Default,
				       QMessageBox::NoButton,
					   QMessageBox::NoButton);
		mb.exec();
		return;
	}

	// 擾URLmF
	QString url = mpDB->getBbsTableUrl();
	if (url.contains("bbstable.html") == false)
	{
		// URLbbstable.htmlw肳ĂȂꍇ
		QMessageBox mb("a2BC", tr("Invalid URL"),
		               QMessageBox::Information,
			           QMessageBox::Ok | QMessageBox::Default,
				       QMessageBox::NoButton,
					   QMessageBox::NoButton);
		mb.exec();
		return;
	}

	// bbstable.html̍XVs邩mF
	QString information = tr("Updates bbstable.html") + "\n    file name : " + fileName;
	information = information + "\n    " + "URL         : " + url + "\n\n";
	information = information + tr("Are you OK?");

    QMessageBox mb(tr("get bbstable.html"), information,
                   QMessageBox::Information,
                   QMessageBox::Ok | QMessageBox::Default,
                   QMessageBox::Cancel | QMessageBox::Escape,
				   QMessageBox::NoButton);
    mb.setButtonText(QMessageBox::Ok, tr("OK"));
    mb.setButtonText(QMessageBox::Cancel, tr("Cancel"));
    switch(mb.exec())
	{
      case QMessageBox::Ok:
        // bbstable.html̍XVs
		mpModel->update_bbsTableFile(fileName, url);
        break;

	  case QMessageBox::Cancel:
	  default:
        // ɏI
        break;
    }
	return;
}

/*!
 *   usv{^ꂽƂ̏
 *
 */
void screenControl::executeUpdate()
{
	updateFormData();

	// a2Bgpbbstable.html̃t@Co^Ă邩mF
	QString fileName = mpDB->getBbsTableFileName();
	if (fileName.contains("bbstable.html") == false)
	{
		// t@Cbbstable.htmlw肳ĂȂꍇ
		QMessageBox mb("a2BC", tr("Invalid FileName"),
		               QMessageBox::Information,
			           QMessageBox::Ok | QMessageBox::Default,
				       QMessageBox::NoButton,
					   QMessageBox::NoButton);
		mb.exec();
		return;
	}

    // VmFs (mFOŎsmF)
    mpModel->update_a2B_datas();

#if 0
	// VmF̍XVs邩mF
	QString information = tr("Updates a2B datas, are you ready?");

    QMessageBox mb(tr("update a2B data"), information,
                   QMessageBox::Information,
                   QMessageBox::Ok | QMessageBox::Default,
                   QMessageBox::Cancel | QMessageBox::Escape,
				   QMessageBox::NoButton);
    mb.setButtonText(QMessageBox::Ok, tr("OK"));
    mb.setButtonText(QMessageBox::Cancel, tr("Cancel"));
    switch(mb.exec())
	{
      case QMessageBox::Ok:
		// LZ{^Lɂ
		(mpForm->executeCancel)->setEnabled(true);

		// VmFs
        mpModel->update_a2B_datas();
        break;

	  case QMessageBox::Cancel:
	  default:
        // ɏI
        break;
    }
#endif
	return;
}

/*!
 *   uLZv{^ꂽƂ̏
 *
 */
void screenControl::cancelUpdate()
{
	return;
}

/*!
 *   bbstable.html̃t@CXVꂽƂ
 *
 */
void screenControl::changed_bbsTableFile()
{
	QString fileName = (mpForm->lineEdit_File_bbsTable)->text();
	mpDB->setBbsTableFileName(fileName);
	if (fileName.contains("bbstable.html") == false)
	{
		// {^Q̗L/ݒɂ
		(mpForm->pBtnSelectionBbsTable)->setEnabled(true);
		(mpForm->pBtnUpdateBbsTable)->setEnabled(false);
		(mpForm->executeUpdate)->setEnabled(false);
		(mpForm->executeCancel)->setEnabled(false);
	}
	else
	{
		// {^Q̗L/ݒɂ
		(mpForm->pBtnSelectionBbsTable)->setEnabled(true);
		(mpForm->pBtnUpdateBbsTable)->setEnabled(true);
		(mpForm->executeUpdate)->setEnabled(true);
		(mpForm->executeCancel)->setEnabled(false);
	}
	return;
}

/*!
 *   bbstable.htmlURLf[^XVꂽƂ
 *
 */
void screenControl::changed_bbsTableUrl()
{
	mpDB->setBbsTableUrl((mpForm->urlBbsTable)->text());
	return;
}

/*!
 *   擾C^[o̒lXVꂽƂ
 *
 */
void screenControl::changed_interval()
{
	QVariant interval = (mpForm->getInterval)->text();
	mpDB->setReceiveInterval(interval.toInt());

	interval = mpDB->getReceiveInterval();
	(mpForm->getInterval)->setText(interval.toString());

	return;
}

/*!
 *   bZ[W̕\XV
 *
 */
void screenControl::updateMessage(const QString &arMessage)
{
    QDateTime time = QDateTime::currentDateTime();
    QString message = time.toString("MM/dd hh:mm:ss") + " " + arMessage + "\n";
	(mpForm->informData)->insertPlainText(message);
	return;
}

/*!
 *   HTTPʐM̏I(R[obN)
 *
 */
void screenControl::completedCommunication(int error, QString &arMessage)
{
    // ~{^̖
    (mpForm->executeCancel)->setEnabled(false);

    // bZ[W̕\
	QString message;
	if (error < 0)
	{
		// G[I
		message = tr("Error Http Communication : ") + arMessage;
	}
	else
	{
		// I
		message = tr("Completed Http Communication : ") + arMessage;
	}

	// ~{^̖
	(mpForm->executeCancel)->setEnabled(false);

	// bZ[W̍XV...
	updateMessage(message);

    // ʐM̃VOis
    emit completedCommunication(error);

	return;
}

/*!
 *   ʂ̃`FbNԁAURLAt@Cɔf
 *
 */
void screenControl::updateFormData(void)
{
	mpDB->setBbsTableUrl((mpForm->urlBbsTable)->text());
	mpDB->setBbsTableFileName((mpForm->lineEdit_File_bbsTable)->text());
	mpDB->setUpdateSubjectTxt((mpForm->chkGetSubjectTxt)->checkState());
	mpDB->setEnableDownThread((mpForm->chkEnableDownThread)->checkState());
	mpDB->setAddThreadToIndex((mpForm->chkAdjustInformation)->checkState());
	mpDB->setAddToBbsTable((mpForm->chkModifyBbsTable)->checkState());
    mpDB->setDisableGetPart((mpForm->chkGetAgainAll)->checkState());
    mpDB->setRemoveErrorMessage((mpForm->chkRemoveErrorThread)->checkState());

	QVariant interval = (mpForm->getInterval)->text();
	mpDB->setReceiveInterval(interval.toInt());
	return;
}

/*!
 *   O擾Jn̏
 * 
 */
void screenControl::startedUpdate()
{
    // s{^̖
    (mpForm->executeUpdate)->setEnabled(false);

    // ~{^̗L
    (mpForm->executeCancel)->setEnabled(true);
   
}

/*!
 *   O擾Ȉ
 * 
 */
void screenControl::completedUpdate()
{
    // s{^̗L
    (mpForm->executeUpdate)->setEnabled(true);

    // ~{^̖
    (mpForm->executeCancel)->setEnabled(false);    
}

/*
 *  a2BC : a2B Connectivity
 *  Copyright (C) 2006- NNsi Project
 *  (see a2BC-src.txt for detail.)
 */
