/*============================================================================*
 *  FILE: 
 *     nnshmain.c
 *
 *  Description: 
 *     Main routines for NNsh. 
 *
 *===========================================================================*/
#define THRMNG_C
#include "local.h"

static Err get_subject_info(NNshSubjectDatabase *mesInfo,  UInt16 *selTHR);
static Err get_message_Info(NNshSubjectDatabase *mesInfo,  UInt16 *selTHR, 
                            NNshBoardDatabase   *bbsInfo,  UInt16 *selBBS);
static Boolean set_SearchTitleString     (void);
static Boolean search_NextTitle          (Int16 direction);
static Boolean display_message           (void);
static Boolean get_all_message           (void);
static Boolean update_message            (void);
static Boolean update_getall_message     (void);
static Boolean delete_notreceived_message(Boolean update);
static Boolean delete_message            (void);
static Boolean get_subject_txt           (void);
static Boolean popEvt_ThreadMain         (EventType *event);
static Boolean keyDownEvt_ThreadMain     (EventType *event);
static Boolean ctlSelEvt_ThreadMain      (EventType *event);
static Boolean ctlRepEvt_ThreadMain      (EventType *event);
static Boolean menuEvt_ThreadMain        (EventType *event);

static Boolean rctPointEvt_ThreadMain(EventType *event,
                                      FormType *frm, RectangleType *rect);

extern void    Initialize_NNshSetting(FormType *frm);
extern void    Effect_NNshSetting    (FormType *frm);
extern Boolean Handler_NNshSetting   (EventType *event);
extern Boolean Handler_JumpSelection(EventType *event);

/*-------------------------------------------------------------------------*/
/*   Function : setMultiPurposeSwitch                                      */
/*                                          ړIXCb`ɏf[^ݒ */
/*-------------------------------------------------------------------------*/
static void setMultiPurposeSwitch(FormType *frm, UInt16 itemID, UInt16 btnID)
{
    UInt16       data;
    ControlType *ctlP;

    // ړIXCb`ɐݒ肳ꂽڂɂ킹ăf[^擾
    switch (itemID & (NNSH_SWITCHUSAGE_FUNCMASK))
    {
      case NNSH_SWITCHUSAGE_GETPART:
        // ꊇ/
        data = NNshParam->enablePartGet;
        break;

      case NNSH_SWITCHUSAGE_HANZEN:
        // p/Sp
        data = NNshParam->convertHanZen;
        break;

      case NNSH_SWITCHUSAGE_USEPROXY:
        // proxygp
        data = NNshParam->useProxy;
        break;

      case NNSH_SWITCHUSAGE_CONFIRM:
        // mFȗ
        data = NNshParam->confirmationDisable;
        break;

      case NNSH_SWITCHUSAGE_SUBJECT:
        // ꗗS擾
        data = NNshParam->getAllThread;
        break;

      case NNSH_SWITCHUSAGE_TITLEDISP:
        // `惂[h
        data = NNshParam->useSonyTinyFontTitle;
        break;

      case NNSH_SWITCHUSAGE_MSGNUMBER:
        // ꗗɔԍ
        data = NNshParam->printNofMessage;
        break;

      case NNSH_SWITCHUSAGE_NOUSE:
      default:
        // gpȂ(`FbN{bNX̉ʕ\Ȃ)
        ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, btnID));
        CtlSetValue  (ctlP, 0);
        CtlSetEnabled(ctlP, false);
        CtlSetUsable (ctlP, false);
        return;
        break;
    }
    // ݒlʂɔf
    SetControlValue(frm, btnID, &data);

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : updateMultiPurposeSwitch                                   */
/*                                                  ړI{^ꂽ */
/*-------------------------------------------------------------------------*/
static Boolean updateMultiPurposeSwitch(UInt16 paramID, UInt16 btnID)
{
    Boolean ret;
    UInt16  data;
    Char    *ptr;

    // f[^̏
    ret = false;
    data = 0;
    ptr  = "";

    // ݒ肳ꂽf[^擾
    UpdateParameter(FrmGetActiveForm(), btnID, &data);
    switch (paramID & (NNSH_SWITCHUSAGE_FUNCMASK))
    {
      case NNSH_SWITCHUSAGE_GETPART:
        // ꊇ/
        NNshParam->enablePartGet = data;
        ptr = MSG_PARTGET_MODE;
        break;

      case NNSH_SWITCHUSAGE_HANZEN:
        // p/Sp
        NNshParam->convertHanZen = data;
        ptr = MSG_HANZEN_MODE;
        ret = true;
        break;

      case NNSH_SWITCHUSAGE_USEPROXY:
        // proxygp
        NNshParam->useProxy = data;
        ptr = MSG_USEPROXY_MODE;
        break;

      case NNSH_SWITCHUSAGE_CONFIRM:
        // mFȗ
        NNshParam->confirmationDisable = data;
        ptr = MSG_OMITCONFIRM_MODE;
        break;

      case NNSH_SWITCHUSAGE_SUBJECT:
        // ꗗS擾
        NNshParam->getAllThread = data;
        ptr = MSG_GETALLSUBJECT_MODE;
        break;

      case NNSH_SWITCHUSAGE_TITLEDISP:
        // `惂[h
        NNshParam->useSonyTinyFontTitle = data;
        ptr = MSG_GRAPHIC_DRAW_MODE;
        ret = true;
        break;

      case NNSH_SWITCHUSAGE_MSGNUMBER:
        // ꗗɔԍ
        NNshParam->printNofMessage = data;
        ptr = MSG_SHOWMESSAGENUM_MODE;
        ret = true;
        break;

      case NNSH_SWITCHUSAGE_NOUSE:
      default:
        // gpȂ
        return (false);
        break;
    }
    if (data == 0)
    {
        // ݒƂʒm
        NNsh_InformMessage(ALTID_INFO, ptr, MSG_RESET_SUFFIX, 0);
    }
    else
    {
        // ݒ肵Ƃʒm
        NNsh_InformMessage(ALTID_INFO, ptr, MSG_SET_SUFFIX, 0);
    }
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :   open_menu                                                */
/*                                                 NNsiƎ̃j[\  */
/*-------------------------------------------------------------------------*/
static Boolean open_menu(void)
{
    FormType    *frm;
    ControlType *ctlP;
    EventType   *dummyEvent;
    Char      *ptr, listPtr[NNSH_ITEMLEN_JUMPLIST*(NNSH_JUMPSEL_NUMLIST + 1)];
    UInt16    btnId, savedParam, jumpList[NNSH_JUMPSEL_NUMLIST + 1], itemCnt;
    UInt16    msgAttribute, selTHR;

    // Xg̍쐬
    MemSet(listPtr, sizeof(listPtr), 0x00);
    MemSet(jumpList, sizeof(jumpList), 0x00);
    ptr = listPtr;
    itemCnt = 0;

    // BBSI
    StrCopy(ptr, NNSH_JUMPMSG_OPENBBS);
    ptr = ptr + sizeof(NNSH_JUMPMSG_OPENBBS);
    jumpList[itemCnt] = NNSH_JUMPSEL_OPENBBS;
    itemCnt++;

    // j[J
    if (NNshParam->addMenuTitle != 0)
    {
        StrCopy(ptr, NNSH_JUMPMSG_OPENMENU);
        ptr = ptr + sizeof(NNSH_JUMPMSG_OPENMENU);
        jumpList[itemCnt] = NNSH_JUMPSEL_OPENMENU;
        itemCnt++;
    }

    // ؒf
    StrCopy(ptr, NNSH_JUMPMSG_DISCONNECT);
    ptr = ptr + sizeof(NNSH_JUMPMSG_DISCONNECT);
    jumpList[itemCnt] = NNSH_JUMPSEL_DISCONNECT;
    itemCnt++;

    // VmF
    StrCopy(ptr, NNSH_JUMPMSG_OPENNEW);
    ptr = ptr + sizeof(NNSH_JUMPMSG_OPENNEW);
    jumpList[itemCnt] = NNSH_JUMPSEL_OPENNEW;
    itemCnt++;

    // ꗗ擾
    StrCopy(ptr, NNSH_JUMPMSG_OPENLIST);
    ptr = ptr + sizeof(NNSH_JUMPMSG_OPENLIST);
    jumpList[itemCnt] = NNSH_JUMPSEL_OPENLIST;
    itemCnt++;

    // X擾
    StrCopy(ptr, NNSH_JUMPMSG_OPENGET);
    ptr = ptr + sizeof(NNSH_JUMPMSG_OPENGET);
    jumpList[itemCnt] = NNSH_JUMPSEL_OPENGET;
    itemCnt++;

    // XQ
    StrCopy(ptr, NNSH_JUMPMSG_OPENMES);
    ptr = ptr + sizeof(NNSH_JUMPMSG_OPENMES);
    jumpList[itemCnt] = NNSH_JUMPSEL_OPENMES;
    itemCnt++;

    // QƐpփRs[
    if (NNshParam->addMenuCopyMsg != 0)
    {
        StrCopy(ptr, NNSH_JUMPMSG_COPYMSG);
        ptr = ptr + sizeof(NNSH_JUMPMSG_COPYMSG);
        jumpList[itemCnt] = NNSH_JUMPSEL_COPYMSG;
        itemCnt++;
    }

    // X
    StrCopy(ptr, NNSH_JUMPMSG_OPENINFO);
    ptr = ptr + sizeof(NNSH_JUMPMSG_OPENINFO);
    jumpList[itemCnt] = NNSH_JUMPSEL_OPENINFO;
    itemCnt++;

    // X폜
    if (NNshParam->addMenuDeleteMsg != 0)
    {
        StrCopy(ptr, NNSH_JUMPMSG_DELMSG);
        ptr = ptr + sizeof(NNSH_JUMPMSG_DELMSG);
        jumpList[itemCnt] = NNSH_JUMPSEL_DELMSG;
        itemCnt++;
    }

    // `惂[hύX
    if (NNshParam->addMenuGraphTitle != 0)
    {
        StrCopy(ptr, NNSH_JUMPMSG_GRAPHMODE);
        ptr = ptr + sizeof(NNSH_JUMPMSG_GRAPHMODE);
        jumpList[itemCnt] = NNSH_JUMPSEL_GRAPHMODE;
        itemCnt++;
    }

    // ړIXCb`P
    if (NNshParam->addMenuMultiSW1 != 0)
    {
        StrCopy(ptr, NNSH_JUMPMSG_MULTISW1);
        ptr = ptr + sizeof(NNSH_JUMPMSG_MULTISW1);
        jumpList[itemCnt] = NNSH_JUMPSEL_MULTISW1;
        itemCnt++;
    }

    // ړIXCb`Q
    if (NNshParam->addMenuMultiSW2 != 0)
    {
        StrCopy(ptr, NNSH_JUMPMSG_MULTISW2);
        ptr = ptr + sizeof(NNSH_JUMPMSG_MULTISW2);
        jumpList[itemCnt] = NNSH_JUMPSEL_MULTISW2;
        itemCnt++;
    }

    // IEBhE\
    btnId = NNshWinSelectionWindow(listPtr, itemCnt);
    if (btnId != BTNID_JUMPCANCEL)
    {
        // IXgԍj[ԍ̕ϊ
        btnId = jumpList[NNshGlobal->jumpSelection];
        switch (btnId)
        {
          case NNSH_JUMPSEL_OPENBBS:
            // BBSꗗI(|bvAbv)
            frm  = FrmGetActiveForm();
            ctlP = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,POPTRID_BBSINFO));
            CtlHitControl(ctlP);
            break;

          case NNSH_JUMPSEL_OPENMENU:
            // j[J
            // (_~[ō㕔penDownEvent𐶐)
            dummyEvent = &(NNshGlobal->dummyEvent);
            MemSet(dummyEvent, sizeof(EventType), 0x00);
            dummyEvent->eType    = penDownEvent;
            dummyEvent->penDown  = true;
            dummyEvent->tapCount = 1;
            dummyEvent->screenX  = 5;
            dummyEvent->screenY  = 5;
            EvtAddEventToQueue(dummyEvent);
            break;

          case NNSH_JUMPSEL_DISCONNECT:
            // ؒf
            savedParam = NNshParam->confirmationDisable;
            NNshParam->confirmationDisable = 1;
            NNshNet_LineHangup();
            NNshParam->confirmationDisable = savedParam;
            break;

          case NNSH_JUMPSEL_OPENNEW:
            // VmF
            (void) update_newarrival_message();
            break;

          case NNSH_JUMPSEL_OPENLIST:
            // ꗗXV
            (void) get_subject_txt();
            break;

          case NNSH_JUMPSEL_OPENGET:
            // bZ[W擾(擾/S擾͎f)
            (void) update_getall_message();
            break;

          case NNSH_JUMPSEL_OPENMES:
            // XQ
            (void) display_message();
            break;

          case NNSH_JUMPSEL_OPENINFO:
            // X\
            selTHR = convertListIndexToMsgIndex(NNshParam->selectedTitleItem);
            (void) DisplayMessageInformations(selTHR, &msgAttribute);
            break;

          case NNSH_JUMPSEL_COPYMSG:
            // QƐpփRs[
            if (copy_to_readOnly() == true)
            {
                if (NNshParam->copyDelReadOnly != 0)
                {
                    // Rs[ƂARs[t@C폜
                    (void) delete_message();
                }
            }
            break;

          case NNSH_JUMPSEL_DELMSG:
            // X폜
            (void) delete_message();
            break;

          case NNSH_JUMPSEL_GRAPHMODE:
            // `惂[hύX
            if (NNshParam->useSonyTinyFontTitle == 0)
            {
                NNshParam->useSonyTinyFontTitle = 1;
            }
            else
            {
                NNshParam->useSonyTinyFontTitle = 0;
            }
            // Xꗗ̕\XV
            Update_Thread_List(NNshParam->lastBBS, 
                               NNshParam->selectedTitleItem,
                               NNSH_STEP_REDRAW);
            return (true);
            break;

          case NNSH_JUMPSEL_MULTISW1:
            // ړIXCb`PƂɂ
            frm  = FrmGetActiveForm();
            ctlP = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,CHKID_SELECT_GETMODE));
            btnId = CtlGetValue(ctlP);
            btnId = (btnId == 0) ? 1 : 0;
            CtlSetValue(ctlP, btnId);
            CtlHitControl(ctlP);
            break;

          case NNSH_JUMPSEL_MULTISW2:
            // ړIXCb`QƂɂ
            frm  = FrmGetActiveForm();
            ctlP = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,CHKID_SELECT_MULTIPURPOSE));
            btnId = CtlGetValue(ctlP);
            btnId = (btnId == 0) ? 1 : 0;
            CtlSetValue(ctlP, btnId);
            CtlHitControl(ctlP);
            break;

          default:
            // Ȃ
            break;
        }
    }
    // Xꗗʂĕ\
    NNsi_RedrawThreadList();
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function : NNshMain_Close                                             */
/*                                                      ꗗʂ̃N[Y */
/*-------------------------------------------------------------------------*/
static void NNshMain_Close(UInt16 nextFormID)
{
#if 0
    UInt16 savedParam;

    if (NNshParam->autoDeleteNotYet != 0)
    {
        // ړɖ擾X폜
        savedParam = NNshParam->confirmationDisable;
        NNshParam->confirmationDisable = 1;
        delete_notreceived_message(false);
        NNshParam->confirmationDisable = savedParam;
    }
#endif

    // X^Cg\폜
    ClearMsgTitleInfo();

    // ʂ̉ʂJ
    FrmEraseForm(FrmGetActiveForm());
    FrmGotoForm(nextFormID);

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   copy_to_readOnly                                         */
/*                                  Ot@CQƐpOɃRs[ */
/*-------------------------------------------------------------------------*/
static Boolean copy_to_readOnly(void)
{
    Err                  ret;
    UInt16               selM, selBBS, butID;
    NNshSubjectDatabase  mesInfo;
    NNshBoardDatabase    bbsInfo;
    Char                *fileName, *orgName, *area;

    // {@\́AVFSpł|\(VFSȊO͏sȂ)
    if ((NNshParam->useVFS & NNSH_VFS_ENABLE) == 0)
    {
        NNsh_ErrorMessage(ALTID_WARN, MSG_ONLYVFS_FEATURE, "", 0);
        return (false);
    }

    // obt@̊m
    fileName = MemPtrNew(MAXLENGTH_FILENAME);
    if (fileName == NULL)
    {
        return (false);
    }
    orgName  = MemPtrNew(MAXLENGTH_FILENAME);
    if (orgName == NULL)
    {
        MemPtrFree(fileName);
        return (false);
    }

    // X擾
    ret = get_message_Info(&mesInfo, &selM, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        goto FUNC_END;
    }
    if (mesInfo.state == NNSH_SUBJSTATUS_NOT_YET)
    {
        //  X擾̂߁ARs[͍sȂ
        NNsh_InformMessage(ALTID_WARN, MSG_NOTGET_MESSAGE,
                           mesInfo.threadTitle, 0);
        ret = ~errNone;
        goto FUNC_END;
    }

    // Rs[fBNg쐬
    MemSet (fileName, MAXLENGTH_FILENAME, 0x00);

    // Ox[XfBNgt
    area = NULL;
    if (NNshGlobal->logPrefixH != 0)
    {
        area = MemHandleLock(NNshGlobal->logPrefixH);
    }
    if (area == NULL)
    {
        StrCopy(fileName, LOGDATAFILE_PREFIX);
    }
    else
    {
        StrCopy(fileName, area);
        MemHandleUnlock(NNshGlobal->logPrefixH);
    }
    StrCat (fileName, mesInfo.boardNick);
    fileName[StrLen(fileName) - 1] = '\0';
    (void) CreateDir_NNsh(fileName);

    // Rs[t@C쐬
    StrCat (fileName, "/");
    StrCat (fileName, mesInfo.threadFileName);

    // Rs[t@C쐬
    MemSet (orgName, MAXLENGTH_FILENAME, 0x00);
    StrCopy(orgName, mesInfo.boardNick);
    StrCat (orgName, mesInfo.threadFileName);

    // t@C{ɃRs[邩mF
    butID = NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_CONFIRM_COPY,
                                mesInfo.threadTitle, 0);
    if (butID != 0)
    {
        // CancelI(Ȃ)
        ret = ~errNone;
        goto FUNC_END;
    }

    // Rs[̎{
    NNsh_DebugMessage(ALTID_INFO, "Dest :",   fileName, 0);
    NNsh_DebugMessage(ALTID_INFO, "Source :", orgName, 0);
    Show_BusyForm(MSG_COPY_IN_PROGRESS);

    if (mesInfo.msgState == FILEMGR_STATE_OPENED_STREAM)
    {
        // Palm{̂VFS̎QƐpOփRs[
        ret = CopyFile_NNsh(fileName, orgName, NNSH_VFS_DISABLE);
    }
    else
    {
        // VFS̃OVFS̎QƐpOփRs[
        ret = CopyFile_NNsh(fileName, orgName, NNSH_VFS_ENABLE);
    }
    Hide_BusyForm(false);
    if (ret != errNone)
    {
        // t@CRs[ɎsB
        (void) DeleteFile_NNsh(fileName, NNSH_VFS_ENABLE);

        // Rs[Ɏs|\
        NNsh_ErrorMessage(ALTID_ERROR, MSG_FAILURE_COPY, fileName, ret);
        goto FUNC_END;
    }

    // Rs[ʒm
    NNsh_InformMessage(ALTID_INFO, MSG_INFORM_COPYEND, "", 0);

FUNC_END:
    MemPtrFree(orgName);
    MemPtrFree(fileName);
    if (ret != errNone)
    {
        return (false);
    }
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   set_SearchTitleString                                    */
/*                                                X^C̐ݒ */
/*-------------------------------------------------------------------------*/
static Boolean set_SearchTitleString(void)
{
    Boolean       ret = false;
    Char         *ptr = NULL;

    // ̈̎擾
    if (NNshGlobal->searchTitleH == 0)
    {
        NNshGlobal->searchTitleH = MemHandleNew(BUFSIZE);
        if (NNshGlobal->searchTitleH == 0)
        {
            return (false);
        }
        ptr = MemHandleLock(NNshGlobal->searchTitleH);
        if (ptr != NULL)
        {
            MemSet(ptr, BUFSIZE, 0x00);
        }
    }
    else
    {
        ptr = MemHandleLock(NNshGlobal->searchTitleH);
    }
    if (ptr == NULL)
    {
        // ̈擾s
        MemHandleFree(NNshGlobal->searchTitleH);
        NNshGlobal->searchTitleH = 0;
        return (false);
    }

    // ̓EBhEJAf[^l
    ret = DataInputDialog(NNSH_INPUTWIN_SEARCH,
                          ptr, BUFSIZE, NNSH_DIALOG_USE_SEARCH);

    MemHandleUnlock(NNshGlobal->searchTitleH);

    // Xꗗʂĕ\
    NNsi_RedrawThreadList();
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :   isValidRecordForSearchTitle                              */
/*                  X^C{Ă悢Xǂ̃`FbN */
/*-------------------------------------------------------------------------*/
static Boolean isValidRecordForSearchTitle(UInt16  selBBS, Char *bbsName,
                                           NNshSubjectDatabase  *mesInfo)
{
    // Xg`FbN
    switch (selBBS)
    {
      case NNSH_SELBBS_FAVORITE:
        if ((mesInfo->msgAttribute & NNSH_MSGATTR_FAVOR) < NNshParam->displayFavorLevel)
        {
            // uCɓvł͂Ȃ
            return (false);
        }
        break;

      case NNSH_SELBBS_GETALL:
        if (mesInfo->state == NNSH_SUBJSTATUS_NOT_YET)
        {
            // 擾ςݑSĂ̂Ƃ͖擾̃Xł͂Ȃꍇ
            return (false);
        }
        break;

      case NNSH_SELBBS_NOTREAD:
        if ((mesInfo->state != NNSH_SUBJSTATUS_NEW)&&
            (mesInfo->state != NNSH_SUBJSTATUS_UPDATE)&&
            (mesInfo->state != NNSH_SUBJSTATUS_REMAIN))
        {
            // ǂXł͂Ȃ
            return (false);
        }
        break;

      default:
        if (StrCompare(bbsName, mesInfo->boardNick) != 0)
        {
            // X̏vȂ
            return (false);
        }
        break;
    }
    // sX
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   search_NextTitle                                         */
/*                                                        X^C */
/*-------------------------------------------------------------------------*/
static Boolean search_NextTitle(Int16 direction)
{
    Err                  ret;
    Char                 msg[BUFSIZE], match1[BUFSIZE], match2[MAX_THREADNAME];
    Char                *ptr;
    UInt16               selMES, selBBS, index, loop, end;
    Int16                step;
    DmOpenRef            dbRef;
    NNshSubjectDatabase  mesInfo;
    NNshBoardDatabase    bbsInfo;

    // 񂪊mۍς݂mF
    if (NNshGlobal->searchTitleH == 0)
    {
        return (false);
    }

    // 񂪐ݒς݂̏ꍇɂ́A̕擾
    ptr = MemHandleLock(NNshGlobal->searchTitleH);
    if (ptr == NULL)
    {
        return (false);
    }

    // (J[\ʒu)̃bZ[W擾
    ret = get_message_Info(&mesInfo, &selMES, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        goto FUNC_END;
    }

    // X̎{(\)
    MemSet (msg, sizeof(msg), 0x00);
    StrCopy(msg, MSG_SEARCHING_TITLE);
    StrCat (msg, ptr);
    Show_BusyForm(msg);

    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    if (direction == NNSH_SEARCH_FORWARD)
    {
        // tH[hw
        GetDBCount_NNsh(dbRef, &end);
        end  = 0;
        step = -1;
    }
    else
    {
        // obN[hw
        GetDBCount_NNsh(dbRef, &end);
        end--;
        step = 1;
    }

    // 啶ʂȂꍇɂ́Aɕϊ
    MemSet(match1, sizeof(match1), 0x00);
    if (NNshParam->searchCaseless != 0)
    {
        (void) StrToLower(match1, ptr);
    }
    else
    {
        (void) StrCopy(match1, ptr);
    }

    // JnR[hԍ擾
    index = convertListIndexToMsgIndex(selMES);
    if (ret != errNone)
    {
        // R[h̎擾ɎsAs\
        goto FUNC_END;
    }
    // JnR[hԍ""猟{悤
    index = index + step;

    // ̎
    for (loop = index; loop != end; loop = loop + step)
    {
        // GetRecord_NNsh()Ń[NAĂ邽ߕsv
        // MemSet(&tmpDb, sizeof(NNshSubjectDatabase), 0x00);
        GetRecord_NNsh(dbRef, loop, sizeof(NNshSubjectDatabase), &mesInfo);

        // rɍvXǂ̃`FbN
        if (isValidRecordForSearchTitle(selBBS, bbsInfo.boardNick, &mesInfo) ==
            false)
        {
            // rKv̂ȂXAɂ
            continue;
	}

        //  w肳ꂽƃ}b`邩mF
        MemSet(match2, sizeof(match2), 0x00);
        if (NNshParam->searchCaseless != 0)
        {
            // X^Cɕϊ
            (void) StrToLower(match2, mesInfo.threadTitle);
        }
        else
        {
            (void) StrCopy(match2, mesInfo.threadTitle);
        }

        if (StrStr(match2, match1) != NULL)
        {
            CloseDatabase_NNsh(dbRef);
            Hide_BusyForm(false);

            // Xꗗ̕\ӏύX
            NNshParam->startTitleRec = loop;
            NNshParam->endTitleRec   = loop;
            Update_Thread_List(selBBS, 0, NNSH_STEP_REDRAW);
            MemHandleUnlock(NNshGlobal->searchTitleH);
            return (true);
        }
    }
    CloseDatabase_NNsh(dbRef);
    Hide_BusyForm(false);

FUNC_END:
    // Ɏs
    NNsh_InformMessage(ALTID_WARN, MSG_NOTFOUND_TITLE, ptr, 0);
    MemHandleUnlock(NNshGlobal->searchTitleH);

    // XXg̍XV(SELMES)
    Update_Thread_List(selBBS, NNshParam->selectedTitleItem, NNSH_STEP_REDRAW);

    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   get_subject_info                                         */
/*                                                   bZ[W̎擾  */
/*-------------------------------------------------------------------------*/
static Err get_subject_info(NNshSubjectDatabase *mesInfo,  UInt16 *selTHR)
{
    Err ret;

    if (NNshGlobal->nofTitleItems == 0)
    {
        // R[h񂪑݂Ȃ
        return (~errNone);
    }

    // bZ[W̏
    *selTHR                    = NNshParam->selectedTitleItem;
    NNshParam->openThreadIndex = *selTHR;

    // XgԍXindexɕϊ
    NNshParam->openMsgIndex    = convertListIndexToMsgIndex(*selTHR);

    // X擾
    ret = Get_Subject_Database(NNshParam->openMsgIndex, mesInfo);
    if (ret != errNone)
    {
        // R[h̎擾Ɏs
        NNsh_DebugMessage(ALTID_ERROR, "Get_Subject_Database()", "", ret);
        MemSet(mesInfo, sizeof(NNshSubjectDatabase), 0x00);
    }
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :   get_message_Info                                         */
/*                                                   bZ[W̎擾  */
/*-------------------------------------------------------------------------*/
static Err get_message_Info(NNshSubjectDatabase *mesInfo,  UInt16 *selTHR, 
                            NNshBoardDatabase   *bbsInfo,  UInt16 *selBBS)
{
    Err        ret;
    FormType  *frm;
    ListType  *lstP;
    UInt16     dummy;

    *selBBS = 0;

    // X擾
    ret = get_subject_info(mesInfo, selTHR);
    if (ret != errNone)
    {
        return (~errNone);
    }

    // IĂBBS̃Xgԍ擾
    frm     = FrmGetActiveForm();
    lstP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_BBSINFO));
    *selBBS = LstGetSelection(lstP);

    // IꂽBBS̃XgԍŁABBS̃[h𔻒f
    if ((*selBBS == NNSH_SELBBS_FAVORITE)||
        (*selBBS == NNSH_SELBBS_GETALL)||
        (*selBBS == NNSH_SELBBS_NOTREAD))
    {
        // Cɓ/XS擾/ǂModéAboardNickgBBS擾
        ret = Get_BBS_Database(mesInfo->boardNick, bbsInfo, &dummy);
    }
    else
    {
        // BBS̃XgԍABBS擾
        ret = Get_BBS_Info(*selBBS, bbsInfo);
    }
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :   display_message                                          */
/*                                                        bZ[W̕\ */
/*-------------------------------------------------------------------------*/
static Boolean display_message(void)
{
    Err                  ret;
    UInt16               selM, butID, selBBS;
    NNshSubjectDatabase  subjInfo;
    NNshBoardDatabase    bbsInfo;

    // X擾
    ret = get_message_Info(&subjInfo, &selM, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        return (false);
    }

    // X擾̂ƂA擾̎|xAX擾邩mFB
    if (subjInfo.state == NNSH_SUBJSTATUS_NOT_YET)
    {
        butID = NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_NOT_YET_SUBJECT, 
                                    MSG_CONFIRM_GETALLMSG, 0);
        if (butID != 0)
        {
            // CancelI(Ȃ)
            return (true);
        }
        // X擾
        if (get_all_message() == false)
        {
            // Xꗗʂĕ\
            NNsi_RedrawThreadList();
            return (false);
        }
        // Xf[^擾łƂ́Aʂ\ɑJڂB
    }

    // BBS(Ō)QƂƂɕύX(CɓΉ)
    NNshParam->lastBBS = selBBS;

    // QƉʂI[v
    NNshMain_Close(FRMID_MESSAGE);

    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   get_all_message                                          */
/*                                                     bZ[WS擾  */
/*-------------------------------------------------------------------------*/
static Boolean get_all_message(void)
{
    Boolean             err = false;
    Err                 ret;
    Char                url[BUFSIZE], *ptr;
    UInt16              butID, selMES, selBBS, index;
    NNshSubjectDatabase mesInfo;
    NNshBoardDatabase   bbsInfo;

    // ݂̃bZ[W擾
    ret = get_message_Info(&mesInfo, &selMES, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        return (false);
    }

    // OFFLINEXIꂽꍇAXVs\
    if (StrCompare(mesInfo.boardNick, OFFLINE_THREAD_NICK) == 0)
    {
        NNsh_InformMessage(ALTID_WARN, MSG_CANNOT_UPDATE,
                           mesInfo.threadTitle, 0);
        return (false);
    }

    // XXXg̏ʂɂ邩`FbN
    if (Check_same_thread(selMES, &mesInfo, NULL, &butID) == errNone)
    {
        //  XꍇADB̕sh~邽߁Ax\
        // f[^̎擾sȂB
        NNsh_InformMessage(ALTID_WARN, MSG_THREADLIST_ALREADY,
                           mesInfo.threadTitle, 0);
        return (false);
    }

    if (mesInfo.state != NNSH_SUBJSTATUS_NOT_YET)
    {
        // Ɏ擾ς݁AbZ[Wŏ擾邪A{ɂ̊mF
        butID = NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_GET_ALREADY, 
                                    MSG_CONFIRM_GETALLMSG, 0);
        if (butID != 0)
        {
            // LZ
            NNsh_InformMessage(ALTID_INFO, MSG_ABORT_INFO, "", 0);
            return (false);
        }
    }
    ////////////  bZ[WS擾̏  ///////////

    /** (VFS)fBNg쐬 **/
    (void) CreateDir_NNsh(mesInfo.boardNick);

    // bZ[W擾̍쐬
    MemSet (url, sizeof(url), 0x00);
    StrCopy(url, bbsInfo.boardURL);
    switch (bbsInfo.bbsType)
    {
      case NNSH_BBSTYPE_MACHIBBS:
        // ܂BBSf[^擾(HTMLǂ)
        StrCat (url, "bbs/read.pl?BBS=");
        StrCat (url, mesInfo.boardNick);
        // boardNick̖ɂ '/'폜
        if (url[StrLen(url) - 1] == '/')
        {
            url[StrLen(url) - 1] = '\0';
        } 
        StrCat (url, "&KEY=");
        StrCat (url, mesInfo.threadFileName);
        ptr = &url[StrLen(url) - 1];
        // threadFileName̊gq폜
        while (*ptr != '.')
        {
            ptr--;
        }
        *ptr = '\0';
        NNsh_DebugMessage(ALTID_INFO, "MACHI BBS URL:", url, 0);
        break;

      case NNSH_BBSTYPE_2ch:
      default:
        // 2chf[^擾(datǂ)
        StrCat (url, "dat/");
        StrCat (url, mesInfo.threadFileName);
        break;
    }

    // XgԍXindexɕϊ
    index = convertListIndexToMsgIndex(selMES);

    // O擾ыL^
    ret = Get_AllMessage(url, bbsInfo.boardNick, mesInfo.threadFileName,
                         index, (UInt16) bbsInfo.bbsType);

    // 擾I̕\(DEBUGIvVL̂)
    NNsh_DebugMessage(ALTID_INFO, MSG_GET_MESSAGE_END,
                      mesInfo.threadTitle, ret);

    // XXg̍XV(SELMES)
    err = Update_Thread_List(selBBS,
                             NNshParam->selectedTitleItem,
                             NNSH_STEP_REDRAW);

    // NNsiݒŁAu擾X\vɃ`FbNĂꍇ́Aʕ\
    if ((ret == errNone)&&(NNshParam->openAutomatic != 0))
    {
        // X\B
        display_message();
        err = false;
    }
    return (err);
}

/*-------------------------------------------------------------------------*/
/*   Function :   update_message                                           */
/*                                                     bZ[W擾  */
/*-------------------------------------------------------------------------*/
static Boolean update_message(void)
{
    Boolean             err;
    Err                 ret;
    Char                url[BUFSIZE], *ptr;
    UInt16              butID, selBBS, selMES, index;
    NNshSubjectDatabase mesInfo;
    NNshBoardDatabase   bbsInfo;

    // ݂̃bZ[W擾
    ret = get_message_Info(&mesInfo, &selMES, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        return (false);
    }

    // OFFLINEXIꂽꍇAXVs\
    if (StrCompare(mesInfo.boardNick, OFFLINE_THREAD_NICK) == 0)
    {
        NNsh_InformMessage(ALTID_WARN, MSG_CANNOT_UPDATE,
                           mesInfo.threadTitle, 0);
        return (false);
    }

    //  Palm{̂ɃO邪AVFSgpݒɂȂĂꍇɂ́A
    // XVłȂ|\
    if ((((NNshParam->useVFS & NNSH_VFS_ENABLE) != 0)&&
        (mesInfo.msgState == FILEMGR_STATE_OPENED_STREAM))||
        (((NNshParam->useVFS & NNSH_VFS_ENABLE) == 0)&&
         (mesInfo.msgState == FILEMGR_STATE_OPENED_VFS)))
    {
        NNsh_InformMessage(ALTID_WARN, MSG_CANNOT_UPDATE_LOG,
                           mesInfo.threadTitle, 0);
        return (false);
    }

    //  VFSɃO邪AVFSgpݒɂȂĂȂꍇɂ́A
    // XVłȂ|\
    if ((((NNshParam->useVFS & NNSH_VFS_ENABLE) != 0)&&
        (mesInfo.msgState == FILEMGR_STATE_OPENED_STREAM))||
        (((NNshParam->useVFS & NNSH_VFS_ENABLE) == 0)&&
         (mesInfo.msgState == FILEMGR_STATE_OPENED_VFS)))
    {
        NNsh_InformMessage(ALTID_WARN, MSG_CANNOT_UPDATE_LOG,
                           mesInfo.threadTitle, 0);
        return (false);
    }

    if (mesInfo.state == NNSH_SUBJSTATUS_NOT_YET)
    {
        // 擾IA܂擾ĂȂB(S擾邩mF)
        butID = NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_NOT_YET_SUBJECT, 
                                    MSG_CONFIRM_GETALLMSG, 0);
        if (butID != 0)
        {
            // CancelI(Ȃ)
            return (true);
        }
        // X(S)擾
        return (get_all_message());
    }

    ////////////  bZ[W擾̏  ///////////

    /** (VFS)fBNg쐬 **/
    (void) CreateDir_NNsh(mesInfo.boardNick);

    // bZ[W擾̍쐬
    MemSet (url, sizeof(url), 0x00);
    StrCopy(url, bbsInfo.boardURL);
    switch (bbsInfo.bbsType)
    {
      case NNSH_BBSTYPE_MACHIBBS:
        // ܂BBSf[^擾(HTMLǂ)
        StrCat (url, "bbs/read.pl?BBS=");
        StrCat (url, mesInfo.boardNick);
        // boardNick̖ɂ '/'폜
        if (url[StrLen(url) - 1] == '/')
        {
            url[StrLen(url) - 1] = '\0';
        }
        StrCat (url, "&KEY=");
        StrCat (url, mesInfo.threadFileName);
        ptr = &url[StrLen(url) - 1];
        // threadFileName̊gq폜
        while (*ptr != '.')
        {
            ptr--;
        }
        *ptr = '\0';
        NNsh_DebugMessage(ALTID_INFO, "MACHI BBS URL:", url, 0);
        break;

      case NNSH_BBSTYPE_2ch:
      default:
        // 2chf[^擾(datǂ)
        StrCat (url, "dat/");
        StrCat (url, mesInfo.threadFileName);
        break;
    }

    // XgԍXindexɕϊ
    index = convertListIndexToMsgIndex(selMES);

    // O̎擾ыL^(ǋL)
    ret = Get_PartMessage(url, bbsInfo.boardNick, &mesInfo, index);

    // 擾I̕\(DEBUGIvVL̂)
    NNsh_DebugMessage(ALTID_INFO, MSG_GET_PARTMESSAGE_END,
                      mesInfo.threadTitle, ret);

    // XXg̍XV(SELMES)
    err = Update_Thread_List(selBBS, 
                             NNshParam->selectedTitleItem,
                             NNSH_STEP_REDRAW);

    // NNsiݒŁAu擾X\vɃ`FbNĂꍇ́Aʕ\
    if ((ret == errNone)&&(NNshParam->openAutomatic != 0))
    {
        // X\B
        display_message();
        err = true;
    }

    return (err);
}

/*-------------------------------------------------------------------------*/
/*   Function :   modify_title                                             */
/*                                                      X^Cg̕ύX */
/*-------------------------------------------------------------------------*/
static Boolean modify_title(void)
{
    Err                 ret;
    Char                newName[MAX_THREADNAME], logBuf[BUFSIZE];
    UInt16              selBBS, selTHR, butID, index;
    NNshSubjectDatabase mesInfo;
    NNshBoardDatabase   bbsInfo;

    // ݂̃bZ[W擾
    ret = get_message_Info(&mesInfo, &selTHR, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        return (false);
    }

    // lƂČ݂̃^CgRs[
    MemSet(newName, sizeof(newName), 0x00);
    StrNCopy(newName, mesInfo.threadTitle, MAX_THREADNAME);

    // ̓EBhEJAf[^l
    ret = DataInputDialog(NNSH_INPUTWIN_MODIFYTITLE, newName, sizeof(newName),
                          NNSH_DIALOG_USE_MODIFYTITLE);
    if (ret == true)
    {
        MemSet(logBuf, sizeof(logBuf), 0x00);
        StrCopy(logBuf, MSG_DIALOG_MODIFYTITLE);
        StrCat (logBuf, mesInfo.threadTitle);
        StrCat (logBuf, MSG_DIALOG_MODIFYTITLE2);

        // {ɃX^CgύX邩mF
        butID = NNsh_ConfirmMessage(ALTID_CONFIRM, logBuf, newName, 0);
        if (butID == 0)
        {
            // ^CgXV
            MemSet  (mesInfo.threadTitle, MAX_THREADNAME, 0x00);
            StrNCopy(mesInfo.threadTitle, newName, MAX_THREADNAME);
            index = convertListIndexToMsgIndex(selTHR);
            ret =  update_subject_database(index, &mesInfo);
            if (ret != errNone)
            {
                NNsh_InformMessage(ALTID_WARN, "Update failure", " ret:", ret);
            }
            else
            {
                Update_Thread_List(selBBS, 
                                   NNshParam->selectedTitleItem, 
                                   NNSH_STEP_REDRAW);
            }
            return (true);
        }
    }
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   launch_WebBrowser                                        */
/*                                                  WebBrowserŃXJ */
/*-------------------------------------------------------------------------*/
static Boolean launch_WebBrowser(void)
{
    Err                 ret;
    Char                logBuf[BIGBUF], *ptr;
    UInt16              selBBS, selTHR;
    NNshSubjectDatabase mesInfo;
    NNshBoardDatabase   bbsInfo;

    // ݂̃bZ[W擾
    ret = get_message_Info(&mesInfo, &selTHR, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        return (false);
    }

    // XbZ[WURL\z
    MemSet (logBuf, sizeof(logBuf), 0x00);
    if (bbsInfo.bbsType == NNSH_BBSTYPE_MACHIBBS)
    {
        // ܂aar̂tqko͂
        StrCat (logBuf, bbsInfo.boardURL);
        StrCat (logBuf, "bbs/read.pl?BBS=");
        StrCat (logBuf, mesInfo.boardNick);
        // boardNick̖ɂ '/'폜
        if (logBuf[StrLen(logBuf) - 1] == '/')
        {
            logBuf[StrLen(logBuf) - 1] = '\0';
        } 
        StrCat (logBuf, "&KEY=");
        StrCat (logBuf, mesInfo.threadFileName);

    }
    else
    {
        // 2cĥtqko͂
        StrCat (logBuf, bbsInfo.boardURL);

        // 2chURLɂ́A{[h܂܂Ă̂ŁA̕B
        ptr = logBuf + StrLen(logBuf) - 2;
        while (*ptr != '/')
        {
            ptr--;
        }
        *ptr = '\0';
        StrCat (logBuf, "/test/read.cgi/");
        StrCat (logBuf, bbsInfo.boardNick);
        StrCat (logBuf, mesInfo.threadFileName);
    }
    // ".dat"  ".cgi " ͍폜
    ptr = logBuf + StrLen(logBuf) - 1;
    while (*ptr != '.')
    {
        ptr--;
    }
    *ptr = '\0';

    // WebBrowserŊJƂAŐVTOJ悤ɂ
    if (NNshParam->browseMesNum != 0)
    {
        if (mesInfo.bbsType == NNSH_BBSTYPE_MACHIBBS)
        {
            StrCat(logBuf, "&LAST=");
        }
        else
        {
            StrCat(logBuf, "/l");
        }
        NUMCATI(logBuf, NNshParam->browseMesNum);
    }

    // \XURLfobO\
    NNsh_DebugMessage(ALTID_INFO, "OPEN URL :", logBuf, 0);

    // NetFrontN(NNsiIɋN)
    (void) WebBrowserCommand(NNshGlobal->browserCreator, false, 0, 
                             NNshGlobal->browserLaunchCode, logBuf, NULL);
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   checkIfNewArrivalIsValid                               */
/*                                        VbZ[W擾ۂ̃`FbN */
/*-------------------------------------------------------------------------*/
static Err checkIfNewArrivalIsValid(UInt16  selBBS, Char *bbsName,
                                    NNshSubjectDatabase  *mesInfo)
{
    if (mesInfo->state == NNSH_SUBJSTATUS_NOT_YET)
    {
        // bZ[W擾ȂA擾{Ȃ
        return (~errNone);
    }
    if (mesInfo->bbsType == NNSH_BBSTYPE_MACHIBBS)
    {
        // ^Cv "܂BBS" ȂA擾{Ȃ
        return (~errNone);
    }
#ifdef USE_STRSTR
    if (StrCompare(mesInfo->boardNick, OFFLINE_THREAD_NICK) == 0)
#else
    if ((mesInfo->boardNick[0]  == '!')&&
        (mesInfo->boardNick[1]  == 'G')&&
        (mesInfo->boardNick[2]  == 'i')&&
        (mesInfo->boardNick[3]  == 'k')&&
        (mesInfo->boardNick[4]  == 'o')&&
        (mesInfo->boardNick[5]  == 'S')&&
        (mesInfo->boardNick[6]  == 'h')&&
        (mesInfo->boardNick[7]  == 'i')&&
        (mesInfo->boardNick[8]  == 'p')&&
        (mesInfo->boardNick[9]  == 'p')&&
        (mesInfo->boardNick[10] == 'o'))
#endif
    {
        // QƐpOȂA擾{Ȃ
        return (~errNone);
    }
    if (mesInfo->maxLoc >= NNSH_MESSAGE_LIMIT)
    {
        // 擾(ő)bZ[WɓBĂȂA擾{Ȃ
        return (~errNone);
    }

    // ʂ̃`FbN
    switch (selBBS)
    {
      case NNSH_SELBBS_FAVORITE:
        if ((mesInfo->msgAttribute & NNSH_MSGATTR_FAVOR) < NNshParam->displayFavorLevel)
        {
            // uCɓvł͂Ȃ
            return (~errNone);
        }
        break;

      case NNSH_SELBBS_GETALL:
        // 擾ςݑSĂ̂Ƃ͑S
        break;

      case NNSH_SELBBS_NOTREAD:
        if ((mesInfo->state != NNSH_SUBJSTATUS_NEW)&&
            (mesInfo->state != NNSH_SUBJSTATUS_UPDATE)&&
            (mesInfo->state != NNSH_SUBJSTATUS_REMAIN))
        {
            // ǂXł͂Ȃ
            return (~errNone);
        }
        break;

      default:
        if (StrCompare(bbsName, mesInfo->boardNick) != 0)
        {
            // X̏Ⴄ
            return (~errNone);
        }
        break;
    }
    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   update_newarrival_message                                */
/*                                                  VbZ[W擾 */
/*-------------------------------------------------------------------------*/
static Boolean update_newarrival_message(void)
{
    Err                  ret = ~errNone;
    Boolean              penState;
    UInt16               selBBS, loop, savedParam, count, x, y, dummy;
    Char                *url, *bbsLbl, logMsg[MINIBUF];
    FormType            *frm;
    ListType            *lstP;
    ControlType         *ctlP;
    MemHandle            mesH;
    DmOpenRef            dbRef;
    NNshBoardDatabase   *bbsInfo;
    NNshSubjectDatabase *mesInfo, *mesRead;

    // [N̈̊m(3)
    url = MemPtrNew(BUFSIZE);
    if (url == NULL)
    {
        return (false);
    }
    bbsInfo = MemPtrNew(sizeof(NNshBoardDatabase));
    if (bbsInfo == NULL)
    {
        MemPtrFree(url);
        return (false);
    }
    mesInfo = MemPtrNew(sizeof(NNshSubjectDatabase));
    if (bbsInfo == NULL)
    {
        MemPtrFree(url);
        MemPtrFree(bbsInfo);
        return (false);
    }

    // mۂ[N̈
    MemSet(url,     BUFSIZE,                     0x00);
    MemSet(bbsInfo, sizeof(NNshBoardDatabase),   0x00);

    // IĂBBS̃Xgԍ擾
    frm     = FrmGetActiveForm();
    lstP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_BBSINFO));
    selBBS  = LstGetSelection(lstP);

    if (selBBS == NNSH_SELBBS_NOTREAD)
    {
        // ǂɂƂAVmF^úAp[^擾
        selBBS = NNshParam->newArrivalNotRead;

        // Xg͖ǂ\Ă邯ǁABBS\^uύX
        LstSetSelection(lstP, selBBS);

        // BBS\^uύX
        NNshParam->lastBBS = selBBS;
        bbsLbl = NNshGlobal->bbsTitles;
        for (x = 0; x < NNshParam->lastBBS; x++)
        {
            bbsLbl = bbsLbl + StrLen(bbsLbl) + 1;
        }
        ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, POPTRID_BBSINFO));
        CtlSetLabel(ctlP, bbsLbl);
    }

    switch (selBBS)
    {
      case NNSH_SELBBS_FAVORITE:
      case NNSH_SELBBS_GETALL:
      case NNSH_SELBBS_NOTREAD:
        // 
        break;

      case NNSH_SELBBS_OFFLINE:
        // OFFLINEXIĂꍇ́AXVs\
        NNsh_InformMessage(ALTID_WARN, MSG_CANNOT_UPDATE, "", 0);
        goto FUNC_END;
        break;

      default:
        // BBS̃XgԍABBS擾
        ret = Get_BBS_Info(selBBS, bbsInfo);
        if (ret != errNone)
        {
            // BBSɎ擾sAI
            goto FUNC_END;
        }
        break;
    }

    /////////////////  bZ[W擾̏  ////////////////

    // "X"\
    Show_BusyForm(MSG_SEARCHING_TITLE);

    // VbZ[WmF́AmFbZ[Wu\ȂvݒɂB
    savedParam = NNshParam->confirmationDisable;
    NNshParam->confirmationDisable = 1;

    // SX擾
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    GetDBCount_NNsh(dbRef, &count);

    // VmF
    for (loop = count; loop > 0; loop--)
    {
        // 悻̌c茏\
        if ((loop % 10) == 0)
        {
            StrCopy(logMsg, MSG_SEARCHING_TITLE MSG_SEARCHING_LEFT);
            NUMCATI(logMsg, loop);
            SetMsg_BusyForm(logMsg);
        }

        // Xf[^擾
        GetRecordReadOnly_NNsh(dbRef, (loop - 1), &mesH, (void **) &mesRead);
        switch (selBBS)
        {
          case NNSH_SELBBS_FAVORITE:
          case NNSH_SELBBS_GETALL:
          case NNSH_SELBBS_NOTREAD:
            // BBS擾 
            ret = Get_BBS_Database(mesRead->boardNick, bbsInfo, &dummy);
            if (ret != errNone)
            {
                // BBSɎ擾sAf`FbNւ
                goto NEXT_STEP;
            }
            break;

          default:
            // 
            break;
        }

        // VbZ[W擾Xǂ`FbN
        if (checkIfNewArrivalIsValid(selBBS, bbsInfo->boardNick, mesRead) != 
                                                                       errNone)
        {
            // VmF{Xł͂ȂAf`FbNւ
            ReleaseRecordReadOnly_NNsh(dbRef, mesH);
            goto NEXT_STEP;
        }

        //  Palm{̂ɃO邪AVFSgpݒɂȂĂꍇɂ́A
        // XVłȂ(f`FbNւ)
        if ((((NNshParam->useVFS & NNSH_VFS_ENABLE) != 0)&&
            (mesRead->msgState == FILEMGR_STATE_OPENED_STREAM))||
            (((NNshParam->useVFS & NNSH_VFS_ENABLE) == 0)&&
             (mesRead->msgState == FILEMGR_STATE_OPENED_VFS)))
        {
            ReleaseRecordReadOnly_NNsh(dbRef, mesH);
            goto NEXT_STEP;
        }

        // f[^x[Xx
        ReleaseRecordReadOnly_NNsh(dbRef, mesH);
        CloseDatabase_NNsh(dbRef);
        Get_Subject_Database((loop - 1), mesInfo);

        // bZ[W擾̍쐬
        MemSet (url, BUFSIZE, 0x00);
        StrCopy(url, bbsInfo->boardURL);
        StrCat (url, "dat/");
        StrCat (url, mesInfo->threadFileName);

        // ꎞIBUSYEBhE
        Hide_BusyForm(false);

        // O̎擾ыL^(ǋL)
        ret = Get_PartMessage(url, bbsInfo->boardNick, mesInfo, (loop - 1));

        // O擾ʂDebug\
        NNsh_DebugMessage(ALTID_INFO, mesInfo->threadTitle, "\nResult:", ret);

        // BUSYEBhE𕜊
        Show_BusyForm(MSG_SEARCHING_TITLE);

        // f[^x[XēxJ
        OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);

        //  O擾~ꂽ or vIG[ɂ
        // VbZ[W̊mF𒆎~B
        if (ret == ~errNone)
        {
            // mFbZ[Wȗ̃p[^ɖ߂
            NNshParam->confirmationDisable = savedParam;

            // 𒆎~|Aʕ\
            NNsh_InformMessage(ALTID_INFO, 
                               MSG_ABORT_MESSAGE, 
                               MSG_NOTCHECK_RECORDS, loop);
            break;
        }

NEXT_STEP:
        // y̏ԂE(ʃ^bvĂ邩mF)
        EvtGetPen(&x, &y, &penState);
        if (penState == true)
        {
            // y_EĂA~邩mFs
            if (NNsh_ErrorMessage(ALTID_CONFIRM,
                                  MSG_CONFIRM_ABORT_GET, 
                                  MSG_NOTCHECK_RECORDS, loop) == 0)
            {
                // OKꂽAbreak
                break;
            }
        }
    }
    CloseDatabase_NNsh(dbRef);
    Hide_BusyForm(false);

    // mFbZ[Wȗ̃p[^ɖ߂
    NNshParam->confirmationDisable = savedParam;

    // uVmFvɖǈꗗ\
    if (NNshParam->autoOpenNotRead != 0)
    {
        // IĂBBS̃XgԍύX
        selBBS = NNSH_SELBBS_NOTREAD;

        frm    = FrmGetActiveForm();
        lstP   = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_BBSINFO));
        LstSetSelection(lstP, selBBS);

        // BBS\^uύX
        NNshParam->lastBBS = selBBS;
        bbsLbl = NNshGlobal->bbsTitles;
        for (x = 0; x < NNshParam->lastBBS; x++)
        {
            bbsLbl = bbsLbl + StrLen(bbsLbl) + 1;
        }
        ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, POPTRID_BBSINFO));
        CtlSetLabel(ctlP, bbsLbl);
    }

FUNC_END:
    // ֐̏I
    MemPtrFree(url);
    MemPtrFree(bbsInfo);
    MemPtrFree(mesInfo);

    if (NNshParam->disconnArrivalEnd != 0)
    {
        // uVmFvIɉؒf
        savedParam = NNshParam->confirmationDisable;
        NNshParam->confirmationDisable = 1;
        NNshNet_LineHangup();
        NNshParam->confirmationDisable = savedParam;
    }

    // XgXV
    Update_Thread_List(selBBS, 0, NNSH_STEP_UPDATE);

    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   update_getall_message                                    */
/*                                     bZ[W擾("XV" {^p) */
/*-------------------------------------------------------------------------*/
static Boolean update_getall_message(void)
{
    Err                 ret;
    UInt16              selMES, selBBS;
    NNshSubjectDatabase mesInfo;
    NNshBoardDatabase   bbsInfo;

    // bZ[WԂ擾
    ret = get_message_Info(&mesInfo, &selMES, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        return (false);
    }

    // bZ[WԂɂāAANVύX
    if (mesInfo.state == NNSH_SUBJSTATUS_NOT_YET)
    {
        // 擾ȂS擾
        (void) get_all_message();
        goto RETR;
    }

    // 擾ς݂Ȃ獷擾
    (void) update_message();
RETR:
    // Xꗗʂĕ\
    NNsi_RedrawThreadList();
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   delete_notreceived_message                               */
/*                                                    MX폜 */
/*-------------------------------------------------------------------------*/
Boolean delete_notreceived_message(Boolean update)
{
    Err                   ret;
    UInt16                selMES, selBBS, cnt;
    NNshSubjectDatabase   mesInfo;
#if 0
    FormType             *frm;
    ListType             *lstP;

    // IĂBBS̃Xgԍ擾
    frm    = FrmGetActiveForm();
    lstP   = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_BBSINFO));
    selBBS = LstGetSelection(lstP);
#else
    selBBS = NNshParam->lastBBS;
#endif

    // uCɓvꗗ́A폜łȂB
    if ((selBBS == NNSH_SELBBS_FAVORITE)||
        (selBBS == NNSH_SELBBS_GETALL)||
        (selBBS == NNSH_SELBBS_NOTREAD))
    {
        NNsh_InformMessage(ALTID_WARN, MSG_CANNOTDELETE_FAVOR,"", 0);
        return (false);    
    }

    // X̎擾
    ret = get_subject_info(&mesInfo, &selMES);
    if (ret != errNone)
    {
        return (false);
    }

    // 擾̃X폜
    (void) DeleteSubjectList(mesInfo.boardNick, NNSH_SUBJSTATUS_NOT_YET, &cnt);

    // Ẍ݂ʒu菬ꍇɂ́ÃXɃJ[\킹
    if (selMES >= cnt)
    {
        selMES = cnt - 1;    
    }

    if (update == false)
    {
        // ʕ\XVȂꍇ
        return (true);
    }

    // XgXV(selBBS)
    return (Update_Thread_List(selBBS, 0, NNSH_STEP_UPDATE));
}

/*-------------------------------------------------------------------------*/
/*   Function :   delete_message                                           */
/*                                                           X폜  */
/*-------------------------------------------------------------------------*/
Boolean delete_message(void)
{
    Err                 ret;
    UInt16              selMES, selBBS, butID, index;
    Char                fileName[MAXLENGTH_FILENAME], *area;
    DmOpenRef           dbRef;
    NNshSubjectDatabase mesInfo;
    NNshBoardDatabase   bbsInfo;

    // bZ[W擾
    ret = get_message_Info(&mesInfo, &selMES, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        return (false);
    }

    // X{ɍ폜邩mF
    butID = NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_DELETE_MSGCONFIRM, 
                                mesInfo.threadTitle, 0);
    if (butID != 0)
    {
        // 폜LZ
        return (false);
    }

    // XDB̃I[v
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    if (dbRef == 0)
    {
        // G[
        return (~errNone);
    }

    // Xt@C({̂̃Ot@C)폜
    MemSet (fileName, sizeof(fileName), 0x00);
    if (selBBS != NNSH_SELBBS_OFFLINE)
    {
        // OFFLINEÔƂ́AboardNicktȂ
        StrCopy(fileName, mesInfo.boardNick);
    }
    else
    {
        // OFFLINEXVFSɊi[Ăꍇɂ́AfBNgtB
        if ((NNshParam->useVFS & NNSH_VFS_USEOFFLINE) != 0)
        {
            // Ox[XfBNg擾
            if ((NNshGlobal->logPrefixH == 0)||
                ((area = MemHandleLock(NNshGlobal->logPrefixH)) == NULL))
            {
                StrCopy(fileName, LOGDATAFILE_PREFIX);
            }
            else
            {
                StrCopy(fileName, area);
                MemHandleUnlock(NNshGlobal->logPrefixH);
            }

            GetSubDirectoryName(mesInfo.dirIndex, &fileName[StrLen(fileName)]);
        }
    }
    StrCat (fileName, mesInfo.threadFileName);

    if (mesInfo.msgState == FILEMGR_STATE_OPENED_STREAM)
    {
        // Palm{̏̃O폜
        ret = DeleteFile_NNsh(fileName, NNSH_VFS_DISABLE);
    }
    else
    {
        // VFS̃O폜
        ret = DeleteFile_NNsh(fileName, NNSH_VFS_ENABLE);
    }
    if((ret != errNone)&&(ret != fileErrNotFound)&&(ret != vfsErrFileNotFound))
    {
        NNsh_InformMessage(ALTID_ERROR, "File Delete: ", fileName, ret);
    }

    // XgԍXindexɕϊ
    index = convertListIndexToMsgIndex(selMES);

    // XCfbNXt@C폜ăN[Y
    (void) DeleteRecordIDX_NNsh(dbRef, index);
    CloseDatabase_NNsh(dbRef);

    // XꗗDBXVƂɂ
    NNshGlobal->updateDatabaseInfo = 
                ((NNshGlobal->updateDatabaseInfo) | (NNSH_DB_UPDATE_SUBJECT));

    return (Update_Thread_List(selBBS, selMES, NNSH_STEP_REDRAW));
}

/*-------------------------------------------------------------------------*/
/*   Function :   get_subject_txt                                          */
/*                                      Xꗗ(subject.txt)擾  */
/*-------------------------------------------------------------------------*/
static Boolean get_subject_txt(void)
{
    Err       ret;
    UInt16    selBBS;
    FormType *frm;
    ListType *lstP;

    frm  = FrmGetActiveForm();
    lstP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_BBSINFO)); 
    selBBS  = LstGetSelection(lstP);

    switch (selBBS)
    {
      case NNSH_SELBBS_FAVORITE:
      case NNSH_SELBBS_GETALL:
      case NNSH_SELBBS_NOTREAD:
        // "Cɓ"A"擾ςݑS"A"ǂ"\ɂ́A󂯕tȂB
        return (false);
        break;

      case NNSH_SELBBS_OFFLINE:
        // ItCX̌s
        create_offline_database();
        FrmDrawForm(frm);
        Update_Thread_List(selBBS, 0, NNSH_STEP_UPDATE);
        break;

      default:
        // Xꗗ擾
        ret = NNsh_GetSubjectList(selBBS);
        if (ret == errNone)
        {  
            // Xꗗ̎擾ɐƂ́AXꗗĕ\
            FrmDrawForm(frm);
            Update_Thread_List(selBBS, 0, NNSH_STEP_UPDATE);
        }
        break;
    }
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   popEvt_ThreadMain                                        */
/*                                          XgICxg[` */
/*-------------------------------------------------------------------------*/
static Boolean popEvt_ThreadMain(EventType *event)
{
    UInt16 savedParam;
    switch (event->data.popSelect.listID)
    {
      case LSTID_BBSINFO:
        if (NNshParam->autoDeleteNotYet != 0)
        {
            // ړɖ擾X폜
            savedParam = NNshParam->confirmationDisable;
            NNshParam->confirmationDisable = 1;
            delete_notreceived_message(false);
            NNshParam->confirmationDisable = savedParam;
        }

        // LSTID_BBSINFOpopSelectEventȂAXXV
        NNshParam->lastBBS = event->data.popSelect.selection;
        (void) Update_Thread_List(NNshParam->lastBBS, 0, NNSH_STEP_UPDATE);
        break;

      default:
        break;
    }
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   rctPointEvt_ThreadMain                                   */
/*                                              X^bvƂ̏ */
/*-------------------------------------------------------------------------*/
static Boolean rctPointEvt_ThreadMain(EventType *event,
                                      FormType *frm, RectangleType *rect)
{
    Coord  locY;
    UInt16 fontID, nlines, fontHeight, selItem;

    // IACe肷
    if (NNshParam->useSonyTinyFontTitle == 0)
    {
        fontID = NNshParam->currentFont;
    }
    else
    {
        fontID = NNshParam->sonyHRFontTitle;
    }
    NNsi_UpdateRectangle(rect, NNshParam->useSonyTinyFontTitle,
                         &fontID, &fontHeight, &nlines);

#ifdef USE_CLIE
    if (NNshGlobal->hrRef != 0)
    {
        locY = (event->screenY * 2) - rect->topLeft.y;
    }
    else
#endif
    {
#ifdef USE_HIGHDENSITY
        // 𑜓xɂ킹ĕ`̈̍擾
        switch (NNshGlobal->os5HighDensity)
        {
          case kDensityDouble:
            locY = (event->screenY * 2) - rect->topLeft.y;
            break;

          case kDensityTriple:
            locY = (event->screenY * 3) - rect->topLeft.y;
            break;

          case kDensityQuadruple:
            locY = (event->screenY * 4) - rect->topLeft.y;
            break;

          case kDensityOneAndAHalf:
            locY = (event->screenY * 3 / 2) - rect->topLeft.y;
            break;

          case kDensityLow:
          default:
            locY = event->screenY - rect->topLeft.y;
            break;
        }
#else
        locY = event->screenY - rect->topLeft.y;
#endif // #ifdef USE_HIGHDENSITY
    }
    selItem = locY / fontHeight;

    // ͈͊ȎIꍇAȂ
    if (selItem >= NNshGlobal->nofTitleItems)
    {
        return (true);
    }

    if (selItem == NNshParam->selectedTitleItem)
    {
        // _u^bvoAXJƂ
        return (display_message());
    }

    // IACeړ
    NNsi_WinUpdateList(selItem,
                       NNshParam->selectedTitleItem, 
                       NNshGlobal->msgTitleIndex,
                       nlines, rect, fontHeight);
    NNshParam->selectedTitleItem = selItem;
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   keyDownEvt_ThreadMain                                    */
/*                                                        L[͎̏ */
/*-------------------------------------------------------------------------*/
static Boolean keyDownEvt_ThreadMain(EventType *event)
{
    Boolean        ret = false;
    FormType      *frm;
    RectangleType  dimF;
    UInt16         fontID, nlines, fontHeight, selItem, keyCode;
    UInt16         msgAttribute, selTHR;

    // ݂̃XgIuWFNg擾
    frm  = FrmGetActiveForm();
    FrmGetObjectBounds(frm, FrmGetObjectIndex(frm, GADID_MESSAGE_LIST), &dimF);
    if (NNshParam->useSonyTinyFontTitle == 0)
    {
        fontID = NNshParam->currentFont;
    }
    else
    {
        fontID = NNshParam->sonyHRFontTitle;
    }
    NNsi_UpdateRectangle(&dimF, NNshParam->useSonyTinyFontTitle,
                         &fontID, &fontHeight, &nlines);

    // tungsten T 5way navigator (281AӁI)
    if (event->data.keyDown.chr == vchrNavChange)
    {
        keyCode = KeyConvertFiveWayToJogChara(event);
    }
    else
    {
        keyCode = event->data.keyDown.chr;
    }

    switch (keyCode)
    {
      // uv(WO_C)̏
      case vchrPageDown:
      case vchrJogDown:
      case vchrTrgJogDown:
        selItem = NNshParam->selectedTitleItem + 1; 
        if (selItem < NNshGlobal->nofTitleItems)
        {
            // Xꗗ̕\(`)
            NNsi_WinUpdateList(selItem,
                               NNshParam->selectedTitleItem,
                               NNshGlobal->msgTitleIndex,
                               nlines,
                               &dimF,
                               fontHeight);
            NNshParam->selectedTitleItem = selItem;
        }
        else
	{
            switch (NNshParam->titleDispState)
            {
              case NNSH_DISP_ALL:
              case NNSH_DISP_LOWERLIMIT:
              case NNSH_DISP_NOTHING:
                break;
              case NNSH_DISP_UPPERLIMIT:
              case NNSH_DISP_HALFWAY:
              default:
                // y[W\
                Update_Thread_List(NNshParam->lastBBS, 0, NNSH_STEP_PAGEUP);
                break;
            }
        }
        ret = true;
        break;

      // uv(WO_C)̏
      case vchrPageUp:
      case vchrJogUp:
      case vchrTrgJogUp:
        if (NNshParam->selectedTitleItem != 0)
        {
            selItem = NNshParam->selectedTitleItem - 1;

            // Xꗗ̕\(`)
            NNsi_WinUpdateList(selItem,
                               NNshParam->selectedTitleItem,
                               NNshGlobal->msgTitleIndex,
                               nlines,
                               &dimF,
                               fontHeight);
            NNshParam->selectedTitleItem = selItem;
        }
        else
	{
            switch (NNshParam->titleDispState)
            {
              case NNSH_DISP_ALL:
              case NNSH_DISP_UPPERLIMIT:
              case NNSH_DISP_NOTHING:
                break;
              case NNSH_DISP_LOWERLIMIT:
              case NNSH_DISP_HALFWAY:
              default:
                // Oy[W\
                Update_Thread_List(NNshParam->lastBBS,
                                   NNSH_ITEM_LASTITEM,
                                   NNSH_STEP_PAGEDOWN);
            }
        }
        ret = true;
        break;

      case chrCapital_T:  // TL[̓
      case chrSmall_T:
        // Xg̐擪\
        Update_Thread_List(NNshParam->lastBBS, 0, NNSH_STEP_UPDATE);
        break;

      case chrCapital_B:    // BL[̓
      case chrSmall_B:
        // X^Cg̖ֈړ(_~[ňُf[^𑗂荞)
        NNshParam->startTitleRec = NNSH_ITEM_LASTITEM;
        Update_Thread_List(NNshParam->lastBBS, 
                           NNSH_ITEM_LASTITEM,
                           NNSH_STEP_PAGEDOWN);
        break;

      // WO_C()̏(1y[W)
      case vchrJogPushedUp:
        // ꎞԂ(])ݒ肷
#ifdef USE_CLIE
        NNshGlobal->tempStatus = NNSH_TEMPTYPE_PUSHEDJOGUP;
#endif
        /** not break!!  **/

      case chrRecordSeparator:   // J[\L[()̏
      case chrCapital_P:         // PL[̓
      case chrSmall_P:           // pL[̓
        switch (NNshParam->titleDispState)
        {
          case NNSH_DISP_ALL:
          case NNSH_DISP_UPPERLIMIT:
          case NNSH_DISP_NOTHING:
            break;
          case NNSH_DISP_LOWERLIMIT:
          case NNSH_DISP_HALFWAY:
          default:
            // Oy[W\
            Update_Thread_List(NNshParam->lastBBS, 0, NNSH_STEP_PAGEDOWN);
            break;
        }
        break;

      // WO_C()̏(1y[W)
      case vchrJogPushedDown:
        // ꎞԂ(])ݒ肷
#ifdef USE_CLIE
        NNshGlobal->tempStatus = NNSH_TEMPTYPE_PUSHEDJOGDOWN;
#endif
        /** not break!!  **/

      case chrUnitSeparator:  // J[\L[()̏
      case chrCapital_N:      // NL[̓
      case chrSmall_N:        // nL[̓
        switch (NNshParam->titleDispState)
        {
          case NNSH_DISP_ALL:
          case NNSH_DISP_LOWERLIMIT:
          case NNSH_DISP_NOTHING:
            break;
          case NNSH_DISP_UPPERLIMIT:
          case NNSH_DISP_HALFWAY:
          default:
            // y[W\
            Update_Thread_List(NNshParam->lastBBS, 0, NNSH_STEP_PAGEUP);
            break;
        }
        break;

      // JOG PushȈ(XgI)
      case vchrJogRelease:
#ifdef USE_CLIE
        if (NNshGlobal->tempStatus == NNSH_TEMPTYPE_CLEARSTATE)
        {
            if (NNshParam->jogPushBtnAsMenu != 0)
            {
                // j[J
                return (open_menu());
            }
            // XQ
            return (display_message());
        }
        // ꎞԂNA
        NNshGlobal->tempStatus = NNSH_TEMPTYPE_CLEARSTATE;
#endif
        break;

      // obN{^/ESCL[/BSL[̏
      case vchrJogBack:
      case chrBackspace:
      case chrEscape:
        if (NNshParam->jogBackBtnAsMenu != 0)
        {
            // j[J
            return (open_menu());
        }
        else
        {
            // X\
            selTHR = convertListIndexToMsgIndex(NNshParam->selectedTitleItem);
            (void) DisplayMessageInformations(selTHR, &msgAttribute);
        }
        break;

      // HandEra JOG PushI/EnterL[͎̏(XgI)
      case chrCarriageReturn:
      case chrLineFeed:
        if (NNshParam->jogPushBtnAsMenu != 0)
        {
            // j[J
            return (open_menu());
        }
        // XQ
        return (display_message());
        break;

      // Xy[XL[
      case chrSpace:
        // VMSGmF
        return (update_newarrival_message());

      case chrCapital_J:
      case chrSmall_J:
        // XԎw̃bZ[W擾
        Get_MessageFromMesNum(&ret);
        if (ret == true)
        {
            // BBSꗗĂ
            MEMFREE_PTR(NNshGlobal->bbsTitles);

            // gpBBSꗗ̍XV
            (void) Create_BBS_INDEX(&(NNshGlobal->bbsTitles), &nlines);
            if (nlines < NNshParam->lastBBS)
            {
                NNshParam->lastBBS = 0;
            }
        }
        Update_Thread_List(NNshParam->lastBBS, 0, NNSH_STEP_UPDATE);
        return (true);
        break;

      // QL[
      case chrCapital_Q:
      case chrSmall_Q:
        // ؒf
        NNshNet_LineHangup();
        break;

      default:
        // ̑
        break;
    }
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :   ctlSelEvt_ThreadMain                                     */
/*                                                      {^̏ */
/*-------------------------------------------------------------------------*/
static Boolean ctlSelEvt_ThreadMain(EventType *event)
{
    switch (event->data.ctlSelect.controlID)
    {
      case BTNID_MSGCHK:
        // VMSGmF
        return (update_newarrival_message());
        break;

      case BTNID_OPEN_THREAD:
        // XQ
        return (display_message());
        break;

      case BTNID_UPDATE_THREAD:
        // bZ[W擾(擾/S擾͎f)
        return (update_getall_message());
        break;

      case BTNID_LIST_THREAD:
        // VKX擾(SUBJECT.TXT擾)
        return (get_subject_txt());
        break;

      case BTNID_DELETE_THREAD:
        // X폜
        return (delete_message());
        break;

      case BTNID_DISCONNECT:
        // ؒf
        NNshNet_LineHangup();
        return (true);
        break;

      case CHKID_SELECT_GETMODE:
        // ړIXCb`P̐ݒXV
        if (updateMultiPurposeSwitch(NNshParam->usageOfTitleMultiSwitch1,
                                     CHKID_SELECT_GETMODE) == true)
        {
            // ʍXVKvȃp[^XVꂽꍇ
            // Xꗗ̕\XV
            Update_Thread_List(NNshParam->lastBBS, 
                               NNshParam->selectedTitleItem,
                               NNSH_STEP_REDRAW);
        }
        break;

      case CHKID_SELECT_MULTIPURPOSE:
        // ړIXCb`Q̐ݒXV
        if (updateMultiPurposeSwitch(NNshParam->usageOfTitleMultiSwitch2,
                                     CHKID_SELECT_MULTIPURPOSE) == true)
        {
            // ʍXVKvȃp[^XVꂽꍇ
            // Xꗗ̕\XV
            Update_Thread_List(NNshParam->lastBBS, 
                               NNshParam->selectedTitleItem,
                               NNSH_STEP_REDRAW);
        }
        break;
  
      default:
        // ̑
        return (false);
        break;
    }

    // Xꗗʂĕ\
    NNsi_RedrawThreadList();
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   ctlRepEvt_ThreadMain                                     */
/*                                              s[g{^̏ */
/*-------------------------------------------------------------------------*/
static Boolean ctlRepEvt_ThreadMain(EventType *event)
{
    switch (event->data.ctlRepeat.controlID)
    {
      case BTNID_LISTPREV:
        // Py[Wֈړ
        return (Update_Thread_List(NNshParam->lastBBS, 0, NNSH_STEP_PAGEDOWN));
        break;

      case BTNID_LISTNEXT:
        // Py[Wֈړ
        return (Update_Thread_List(NNshParam->lastBBS, 0, NNSH_STEP_PAGEUP));
        break;
  
      default:
        // ̑
        break;
    }
    return (false);
}

/*=========================================================================*/
/*   Function :   Handler_ThreadMain                                       */
/*                                          XǗʗpCxgnh */
/*=========================================================================*/
Boolean Handler_ThreadMain(EventType *event)
{
    Boolean        ret;
    FormType      *frm;
    RectangleType  dimF;

    ret = false;
    switch (event->eType)
    {
      case keyDownEvent:
        return (keyDownEvt_ThreadMain(event));
        break;

      case fldEnterEvent:
        break;

      case ctlSelectEvent:
        return (ctlSelEvt_ThreadMain(event));
        break;

      case ctlRepeatEvent:
        return (ctlRepEvt_ThreadMain(event));
        break;

      case frmOpenEvent:
        break;

      case popSelectEvent:
        return (popEvt_ThreadMain(event));
        break;

      case lstSelectEvent:
        break;

      case lstEnterEvent:
        break;

      case lstExitEvent:
        break;

      case menuEvent:
        (void) menuEvt_ThreadMain(event);
        return (true);
        break;

#ifdef USE_HANDERA
      case displayExtentChangedEvent :
        if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
        {
            frm = FrmGetActiveForm();
            HandEraResizeForm(frm);
            FrmDrawForm(frm);
        }
        break;
#endif  // #ifdef USE_HANDERA

      case menuOpenEvent:
        break;

      case sclRepeatEvent:
        break;

      case sclExitEvent:
        break;

      case penDownEvent:
        frm = FrmGetActiveForm();
        FrmGetObjectBounds(frm, 
                           FrmGetObjectIndex(frm, GADID_MESSAGE_LIST), &dimF);
        if (RctPtInRectangle(event->screenX, event->screenY, &dimF))
        {
	    // Gadget^bv
            return (rctPointEvt_ThreadMain(event, frm, &dimF));
        }
        else
        {
            return (false);
        }
        break;

      default:
        break;
    }
    return (ret);
}

/*=========================================================================*/
/*   Function :   OpenForm_ThreadMain                                      */
/*                                         XǗʂJƂ̏  */
/*=========================================================================*/
void OpenForm_ThreadMain(FormType *frm)
{
    Err          ret;
    UInt16       lp;
    Char        *bbsLbl;
    ControlType *ctlP;

    // I[vAItCX̌
    if ((NNshParam->offChkLaunch != 0)&&(NNshGlobal->bbsTitles == NULL))
    {
        create_offline_database();
    }

    // BBSꗗ̍쐬(ꗗȂ΁ABBSꗗ擾悤)
    ret = Create_BBS_INDEX(&(NNshGlobal->bbsTitles), &lp);
    if (ret != errNone)
    {
        // 쐬sAtH[͍XVȂAUʂ`悷
        FrmDrawForm(FrmGetActiveForm());
        return;
    }

    // NNshParam->lastBBS(OIĂBBS)ςȂƂ(ꗗ̐擪ɂ)
    if (lp < NNshParam->lastBBS)
    {
        NNshParam->lastBBS = 0;
    }

    // BBSꗗ̃XgԂ𔽉fB
    NNshWinSetListItems(frm, LSTID_BBSINFO, NNshGlobal->bbsTitles, lp,
                        NNshParam->lastBBS, &(NNshGlobal->bbsTitleH));

    // |bvAbvgK̃x(XgԂɍ킹)XV
    bbsLbl = NNshGlobal->bbsTitles;
    for (lp = 0; lp < NNshParam->lastBBS; lp++)
    {
        bbsLbl = bbsLbl + StrLen(bbsLbl) + 1;
    }
    if (bbsLbl != NULL)
    {
        ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, POPTRID_BBSINFO));
        CtlSetLabel(ctlP, bbsLbl);
    }

    // ړIXCb`P̏ݒʂɔf
    setMultiPurposeSwitch(frm, NNshParam->usageOfTitleMultiSwitch1,
                          CHKID_SELECT_GETMODE);

    // ړIXCb`Q̏ݒʂɔf
    setMultiPurposeSwitch(frm, NNshParam->usageOfTitleMultiSwitch2,
                          CHKID_SELECT_MULTIPURPOSE);

    // Xꗗ̕\XV
    Update_Thread_List(NNshParam->lastBBS, 
                       NNshParam->selectedTitleItem,
                       NNSH_STEP_REDRAW);

    // JtH[IDݒ肷(ݒ蒆ɂ́AlastFrmID͕ύXȂ)
    if ((NNshParam->useBookmark != 0)&&(NNshParam->bookMsgNumber != 0))
    {
        // ݒ蒆Ȃ̂ŁAȂ
    }
    else
    {
        NNshParam->lastFrmID = FRMID_THREAD;
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   menuEvt_ThreadMain                                       */
/*                                      XǗʗpj[[` */
/*-------------------------------------------------------------------------*/
static Boolean menuEvt_ThreadMain(EventType *event)
{
    Boolean             err = false;
    FormType           *frm;
    ListType           *lstP;
    Char               *buffer;
    UInt16              selB;
    UInt16              msgAttribute, selTHR;
#ifdef USE_HANDERA
    VgaScreenModeType   handEraScreenMode;     // XN[[h
    VgaRotateModeType   handEraRotateMode;     // ][h
#endif

    frm  = FrmGetActiveForm();
    switch (event->data.menu.itemID)
    {
      // o[W̕\( FrmCustomAlert() Ăяo)
      case MNUID_SHOW_VERSION:
        buffer = MemPtrNew(BUFSIZE);
        if (buffer == NULL)
        {
            return (false);
        }
        MemSet (buffer, BUFSIZE, 0x00);
        StrCopy(buffer, "NNsi\n");
        StrCat (buffer, SOFT_VERSION);
        StrCat (buffer, "\n");
        StrCat (buffer, SOFT_REVISION);
        StrCat (buffer, "\n(");
        StrCat (buffer, SOFT_DATE);
#ifdef SMALL
        StrCat (buffer, ", OS31NNsi.prc");
#endif
#ifdef STD
        StrCat (buffer, ", NNsiSTD.prc");
#endif
#ifdef OFFLINE_DEBUG
        StrCat (buffer, "[OFFLINE DEBUG]");
#endif
        FrmCustomAlert(ALTID_INFO, buffer, ")", "");
        MemPtrFree(buffer);
        buffer = NULL;
        break;

        // NNsiݒʂJ
      case MNUID_CONFIG_NNSH:
        NNshMain_Close(FRMID_CONFIG_NNSH);
        return (false);
        break;

        // NNsiݒ-2ʂJ
      case MNUID_NNSI_SETTING2:
        NNshMain_Close(FRMID_NNSI_SETTING2);
        return (false);
        break;

        // NNsiݒ-3ʂJ
      case MNUID_NNSI_SETTING3:
        NNshMain_Close(FRMID_NNSI_SETTING3);
        return (false);
        break;

        // NNsiݒ-4ʂJ
      case MNUID_NNSI_SETTING4:
        NNshMain_Close(FRMID_NNSI_SETTING4);
        return (false);
        break;

        // NNsiݒ-5ʂJ
      case MNUID_NNSI_SETTING5:
        NNshMain_Close(FRMID_NNSI_SETTING5);
        return (false);
        break;

        // NNsiݒ-6ʂJ
      case MNUID_NNSI_SETTING6:
        NNshMain_Close(FRMID_NNSI_SETTING6);
        return (false);
        break;

        // NNsiݒ-7ʂJ
      case MNUID_NNSI_SETTING7:
        NNshMain_Close(FRMID_NNSI_SETTING7);
        return (false);
        break;

        // ؒf
      case MNUID_NET_DISCONN:
        NNshNet_LineHangup();
        return (true);
        break;

        // VbZ[WmF
      case MNUID_UPDATE_CHECK:
        return (update_newarrival_message());
        break;

        // XV(擾)
      case MNUID_UPDATE_BBS:
        err = GetBBSList(NNshParam->bbs_URL);
        if (err == false)
        {
            break;
        }
        /** not break; (ĎgpIs) **/

        // gpIʂJ
      case MNUID_SELECT_BBS:
        NNshMain_Close(FRMID_MANAGEBBS);
        return (false);
        break;

        // Xꗗ擾(SUBJECT.TXT擾)
      case MNUID_GET_NEWMESSAGE:
        return (get_subject_txt());
        break;

        // X
      case MNUID_INFO_MESSAGE:
        if (NNshGlobal->nofTitleItems != 0)
        {
            selTHR = convertListIndexToMsgIndex(NNshParam->selectedTitleItem);
            (void) DisplayMessageInformations(selTHR, &msgAttribute);
        }
        break;

        // X^CgύX
      case MNUID_MODIFY_TITLE:
        return (modify_title());
        break;

        // 擾X폜
      case MNUID_DEL_THREADLIST:
        return (delete_notreceived_message(true));
        break;

        // X폜
      case MNUID_DELETE_MESSAGE:
        err = delete_message();
        break;

        // bZ[WS擾(Ď擾)
      case MNUID_GET_ALLMESSAGE:
        get_all_message();
        return (true);
        break;

        // bZ[W擾
      case MNUID_UPDATE_MESSAGE:
        update_message();
        return (true);
        break;

        // XQ
      case MNUID_OPEN_MESSAGE:
        return (display_message());
        break;

        // `惂[hύX
      case MNUID_FONT_MODE:
        if (NNshParam->useSonyTinyFontTitle == 0)
        {
            // nC][h֕ύX
            NNshParam->useSonyTinyFontTitle = 1;
        }
        else
        {
            // ʏ`惂[h֕ύX
            NNshParam->useSonyTinyFontTitle = 0;
        }
        // `惂[hύX̕\́AXgč쐬ĕ\
        lstP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_BBSINFO));
        selB = LstGetSelection(lstP);
        Update_Thread_List(selB,
                           NNshParam->selectedTitleItem, NNSH_STEP_REDRAW);
        return (true);
        break;

        // tHgύX
      case MNUID_FONT:
        // tHgID̑I
        if (NNshParam->useSonyTinyFontTitle == 0)
        {
            // ʏ`惂[hptHg̕ύX
            NNshParam->currentFont = FontSelect(NNshParam->currentFont);
        }
        else
        {
            // nC][hptHg̕ύX
            NNshParam->sonyHRFontTitle =
                                        FontSelect(NNshParam->sonyHRFontTitle);
        }

        // tHgύX̕\́AXgč쐬ĕ\
        lstP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_BBSINFO));
        selB = LstGetSelection(lstP);
        Update_Thread_List(selB,
                           NNshParam->selectedTitleItem, NNSH_STEP_REDRAW);
        return (true);
        break;

#ifdef USE_HANDERA
        // HandEra ʉ] //
      case MNUID_HANDERA_ROTATE:
        if(NNshGlobal->device == NNSH_DEVICE_HANDERA)
        {
            VgaGetScreenMode(&handEraScreenMode, &handEraRotateMode);
            VgaSetScreenMode(screenMode1To1,
                             VgaRotateSelect(handEraRotateMode));
            HandEraResizeForm(frm);
            FrmDrawForm(frm);
        }
        else
        {
            // "݃T|[gĂ܂" \s
            NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "", 0);
        }
        break;
#endif  // #ifdef USE_HANDERA

      case MNUID_GET_MESSAGENUM:
        // XԎw̃bZ[W擾
        Get_MessageFromMesNum(&err);
        if (err == true)
        {
            // BBSꗗĂ
            MEMFREE_PTR(NNshGlobal->bbsTitles);

            // gpBBSꗗ̍XV
            (void) Create_BBS_INDEX(&(NNshGlobal->bbsTitles), &selB);
            if (selB < NNshParam->lastBBS)
            {
                NNshParam->lastBBS = 0;
            }
        }
        Update_Thread_List(NNshParam->lastBBS, 0, NNSH_STEP_UPDATE);
        return (true);
        break;

      case MNUID_SEARCH_TITLE:
        // ^Cg(̐ݒ)
        err = set_SearchTitleString();
        if (err != true)
        {
            // 񂪐ݒ肳Ȃ(I) 
            err = true;
            break;
        }
        // not break! (ăX^Cs!)
      case MNUID_SEARCH_NEXT:
        // X^C()
        (void) search_NextTitle(NNSH_SEARCH_FORWARD);
        err = true;
        break;

      case MNUID_SEARCH_PREV:
        // X^C(O)
        (void) search_NextTitle(NNSH_SEARCH_BACKWARD);
        err = true;
        break;

      case MNUID_MOVE_TOP:
        // X^Cg̐擪ֈړ
        Update_Thread_List(NNshParam->lastBBS, 0, NNSH_STEP_UPDATE);
        return (true);
        break;

      case MNUID_MOVE_BOTTOM:
        // X^Cg̖ֈړ(_~[ňُf[^𑗂荞)
        NNshParam->startTitleRec = NNSH_ITEM_LASTITEM;
        Update_Thread_List(NNshParam->lastBBS, 
                           NNSH_ITEM_LASTITEM,
                           NNSH_STEP_PAGEDOWN);
        return (true);
        break;

      case MNUID_COPY_READONLY:
        // XQƐpOփRs[
        err = copy_to_readOnly();
        if ((err == true)&&(NNshParam->copyDelReadOnly != 0))
        {
            // Rs[ƂARs[t@C폜
            err = delete_message();
        }
        break;

      case MNUID_OS5_LAUNCH_WEB:
        if (NNshGlobal->browserCreator != 0)
        {
            // WebBrowserŊJ
            launch_WebBrowser();
        }
        else
        {
            // "݃T|[gĂ܂" \s
            NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "", 0);
        }
        break;

      case MNUID_BACKUP_DATABASE:
        if (((NNshParam->useVFS) & (NNSH_VFS_ENABLE)) == NNSH_VFS_ENABLE)
        {
            // DBVFSɃobNAbv
            BackupDBtoVFS(NNSH_ENABLE);
        }
        else
        {
             // "݃T|[gĂ܂" \s
             NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "", 0);
        }
        break;

      case MNUID_NET_CONFIG:
        // lbg[NݒJ
        OpenNetworkPreferences();
        break;

      case MNUID_SORT_SUBJECT:
        // X̐s
        Show_BusyForm(MSG_SORTING_WAIT);
        SortSubjectList();
        Hide_BusyForm(false);

        // X^Cg̐擪ֈړ
        Update_Thread_List(NNshParam->lastBBS, 0, NNSH_STEP_UPDATE);
        return (true);
        break;

      default:
        // ̑(肦Ȃ)
        break;
    }

    // Xꗗʂĕ\
    NNsi_RedrawThreadList();
    return (err);
}

/*=========================================================================*/
/*   Function : NNsi_RedrawThreadList                                      */
/*                                                    Xꗗʂĕ` */
/*=========================================================================*/
void NNsi_RedrawThreadList(void)
{
    FormType      *frm;
    RectangleType  dimF;
    UInt16         fontID, fontHeight, nlines;

    if (FrmGetActiveFormID() == FRMID_THREAD)
    {
        frm = FrmGetActiveForm();
        FrmDrawForm(frm);
        FrmGetObjectBounds(frm,
                           FrmGetObjectIndex(frm, GADID_MESSAGE_LIST), 
                           &dimF);
        if (NNshParam->useSonyTinyFontTitle == 0)
        {
            fontID = NNshParam->currentFont;
        }
        else
        {
            fontID = NNshParam->sonyHRFontTitle;
        }
        NNsi_UpdateRectangle(&dimF, NNshParam->useSonyTinyFontTitle,
                             &fontID, &fontHeight, &nlines);
        NNsi_WinDrawList(NNshParam->selectedTitleItem, 
                         NNshGlobal->msgTitleIndex, nlines,
                         &dimF, fontHeight);
    }
    return;
}
