/*============================================================================*
 *  FILE: 
 *     httpMgr.c
 *
 *  Description: 
 *     HTTPR~jP[V}l[W
 *===========================================================================*/
#define  HTTPMGR_C
#include "local.h"

/*-------------------------------------------------------------------------*/
/*   Function :   http_divideHostName                                      */
/*                                               URLzXg𒊏o */
/*-------------------------------------------------------------------------*/
static void NNshHttp_divideHostName(Char *url, Char *host, Char **loc)
{
    Char *start;

    // zXg̍ŏƍŌ̏ꏊ߂("://"  "/" Ɉ͂܂Ă钆g)
    start = StrStr(url, "://");
    start = start + StrLen("://");
#ifdef USE_STRSTR
    *loc  = StrStr(start, "/");
    // "/" Ȃꍇɂ́As̍ŌォRs[
    if (*loc == NULL)
#else
    *loc = start;
    while ((*(*loc) != '/')&&(*(*loc) != '\0'))
    {
        (*loc)++;
    }
    if (*(*loc) == '\0')
#endif
    {
        *loc = start + StrLen(url);
        StrNCopy(host, start, StrLen(url));
    }
    else
    {
        // zXg𒊏o
        StrNCopy(host, start, (*loc - start));
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   http_createPostMsg                                       */
/*                                            HTTPMbZ[W쐬 */
/*-------------------------------------------------------------------------*/
static Err NNshHttp_createPostMsg(UInt16 type, Char *url, Char *host,
                                  Char *cookie, Char *appendData,
                                  Char *buffer, UInt32 bufSize)
{
    NNshFileRef sendRef;
    UInt32      dataSize, readSize;
    Char       *loc, *buf, *ptr;
    Err         ret;

    // t@C瑗M郁bZ[WǂݏoB
    dataSize = 0;
    readSize = 0;
    buf      = NULL;

    // Mt@Cf[^擾
    ret = OpenFile_NNsh(FILE_SENDMSG, 
                        (NNSH_FILEMODE_READONLY|NNSH_FILEMODE_TEMPFILE),
                        &sendRef);
    if (ret != errNone)
    {
        return (ret);
    }
    (void) GetFileSize_NNsh(&sendRef, &readSize);
    buf = (Char *) MemPtrNew(readSize + 8);
    if (buf == NULL)
    {
        return (~errNone);
    }
    MemSet(buf, (readSize + 8), 0x00);
    (void) ReadFile_NNsh (&sendRef, 0, readSize, buf, &dataSize);
    (void) CloseFile_NNsh(&sendRef);

    // URLzXgƃt@Cɕ
    loc = NULL;
    NNshHttp_divideHostName(url, host, &loc);

    // tf[^TCYmF
    if (appendData != NULL)
    {
        readSize = StrLen(appendData);
    }
    else
    {
        readSize = 0;
    }

    // HTTP̃wb_쐬(܂BBSΉ)
    switch (type)
    {
      case HTTP_SENDTYPE_POST_SHITARABAJBBS:
        StrCopy(buffer, "POST ");

        // RefererzXg̎̕(JeS?)؂o
        ptr = buffer + StrLen(buffer) + 1;
        StrCat (buffer, loc);
        for (; ((*ptr != '/')&&(*ptr != '\0')); ptr++);
        *ptr = '\0';

        StrCat (buffer, "/bbs/write.cgi HTTP/1.0\r\nHost: ");
        StrCat (buffer,  host);
        break;

      case HTTP_SENDTYPE_POST_MACHIBBS:
        StrCopy(buffer, "POST /bbs/write.cgi HTTP/1.0\r\nHost: ");
        StrCat (buffer,  host);
        break;

      case HTTP_SENDTYPE_POST_SHITARABA:
        StrCopy(buffer, "POST /cgi-bin/bbs.cgi HTTP/1.0\r\n"
                "Host: cgi.shitaraba.com");
        StrCopy(host, "cgi.shitaraba.com");
        break;
      case HTTP_SENDTYPE_POST_OTHERBBS:
        StrCopy(buffer, "POST ");
        StrCat (buffer, loc);
        StrCat (buffer, "../test/bbs.cgi HTTP/1.0\r\nHost: ");
        StrCat (buffer,  host);
        NNsh_DebugMessage(ALTID_INFO, "POST:", buffer, 0);
        break;

      case HTTP_SENDTYPE_POST:
      default:
        StrCopy(buffer, "POST /test/bbs.cgi HTTP/1.0\r\nHost: ");
        StrCat (buffer,  host);
        break;
    }
    StrCat (buffer,  "\r\nAccept: text/html, */*\r\nReferer: ");
    StrCat (buffer,  url);
    StrCat (buffer,  "\r\nUser-Agent: Monazilla/1.00  NNsi/1.2(" SOFT_REVISION
            ")\r\nContent-Length: ");
    StrIToA(&buffer[StrLen(buffer)], (dataSize + readSize + 2));
    StrCat (buffer, "\r\nPragma: no-cache"
            "\r\nCookie: NAME=; Mail=");
    if (cookie != NULL)
    {
        StrCat (buffer, "; ");
        StrCat (buffer, cookie);
    }
    StrCat (buffer, "\r\n\r\n");

    // f[^obt@ɃRs[邩mF
    if (bufSize >= (StrLen(buffer) + dataSize + readSize + 2))
    {
        // f[^̃Rs[
        StrCat (buffer, buf);
        if (appendData != NULL)
        {
            StrCat (buffer, appendData);
        }
        StrCat (buffer, "\r\n");
        ret = errNone;
    }
    else
    {
        // obt@TCYI[ot[
        ret = (~errNone - 1);
    }
    MemPtrFree(buf);
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :   http_createGetMsg                                        */
/*                                            HTTPMbZ[W쐬 */
/*-------------------------------------------------------------------------*/
static void NNshHttp_createGetMsg(UInt16 type, Char *url, Char *host,
                                  UInt32 getRange, UInt32 endRange,
                                  Char *buffer, Char *proxy)
{
    Char *loc;

    // URLzXgƃt@Cɕ
    loc = NULL;
    NNshHttp_divideHostName(url, host, &loc);
    if (loc == NULL)
    {
        loc = "/";
    }

    // f[^Mpobt@ɃbZ[WLڂ
    StrCopy(buffer, "GET ");
    if ((proxy != NULL)&&(*proxy != '\0'))
    {
        StrCat (buffer,  url);
    }
    else
    {
        StrCat (buffer,  loc);
    }
    StrCat (buffer,  " HTTP/1.1\r\nHOST: ");
    StrCat (buffer,  host);
    StrCat (buffer,  "\r\nACCEPT: text/html, */*\r\nUser-Agent: ");
    if (type !=  HTTP_SENDTYPE_GET_NOTMONA)
    {
        StrCat (buffer, "Monazilla/1.00  ");
    }
    StrCat (buffer,  "NNsi/1.2(" SOFT_REVISION
                     ")\r\nACCEPT-ENCODING: identity"
                     "\r\nACCEPT-LANGUAGE: ja, en");
    if (getRange != HTTP_RANGE_OMIT)
    {
        StrCat(buffer, "\r\nRANGE: bytes=");
        StrIToA(&buffer[StrLen(buffer)], getRange);
        StrCat(buffer, "-");
    }
    if (endRange != HTTP_RANGE_OMIT)
    {
        StrIToA(&buffer[StrLen(buffer)], endRange);
    }
    StrCat(buffer, "\r\nConnection: close");
    StrCat(buffer, "\r\nPRAGMA: no-cache\r\n\r\n");

    return;
}

/*=========================================================================*/
/*   Function :   NNshHttp_commMain                                        */
/*                                                 HTTPf[^](GET)v */
/*                                            (Mf[^recv.txtɋL^) */
/*=========================================================================*/
Err NNshHttp_commMain(UInt16 type, Char *url, Char *cookie, Char *appendData,
                      UInt32 range, UInt32 endRange, UInt16 port, Char *proxy,
                      Char   *message)
{
#ifdef OFFLINE_DEBUG

    Char logMes[BUFSIZE];

    // Oo͂āAʐMӂB
    MemSet (logMes, sizeof(logMes), 0x00);
    StrCopy(logMes, "\n<< This is OFFLINE DEBUG, NOT CONNECT >>\n");
    if (range != HTTP_RANGE_OMIT)
    {
        StrCat (logMes, "Range:");
        NUMCATI(logMes, range);
        StrCat (logMes, "-");
    }
    if (endRange != HTTP_RANGE_OMIT)
    {
        NUMCATI(logMes, endRange);
    }
    StrCat (logMes, " PORT:");
    NUMCATI(logMes, port);

    if ((proxy != NULL)&&(*proxy != '\0'))
    {
       StrCat (logMes, " (proxy:");
       StrCat (logMes, proxy);
       StrCat (logMes, ")");
    }
    if ((message != NULL)&&(*message != '\0'))
    {
       StrCat (logMes, "[");
       StrCat (logMes, message);
       StrCat (logMes, "]");
    }
    NNsh_InformMessage(ALTID_INFO, url, logMes, 0);

    return (errNone);
#else   // #ifdef OFFLINE_DEBUG

    Err             ret, err;
    Char           *bufPtr, host[MAX_URL], logBuf[MINIBUF];
    UInt16          dataSize, autoOffTime;
    UInt32          writeSize, totalSize;
    NetSocketRef    socketRef;
    NNshFileRef     fileRef;
    FormType       *frm;

    // (ꎞ)Mobt@̊m
    bufPtr = MemPtrNew(NNshParam->bufferSize + MARGIN);
    if (bufPtr == NULL)
    {
        // ̈̊mێsI
        NNsh_DebugMessage(ALTID_ERROR, "HTTP(temp)", "MemPtrNew(), size:",
                          NNshParam->bufferSize + MARGIN);
        return (~errNone);
    }
    MemSet(bufPtr, (NNshParam->bufferSize + MARGIN), 0x00);

    // MpbZ[W̍쐬ƂtqkzXg擾
    MemSet(host, sizeof(host), 0x00);
    switch (type)
    {
      case HTTP_SENDTYPE_POST:
      case HTTP_SENDTYPE_POST_MACHIBBS:
      case HTTP_SENDTYPE_POST_SHITARABA:
      case HTTP_SENDTYPE_POST_SHITARABAJBBS:
      case HTTP_SENDTYPE_POST_OTHERBBS:
        ret = NNshHttp_createPostMsg(type, url, host, cookie, appendData, 
                                     bufPtr, NNshParam->bufferSize);
        if (ret != errNone)
        {
            NNsh_DebugMessage(ALTID_ERROR, "createPostMsg()", "", ret);
            MemPtrFree(bufPtr);
            return (ret);
        }
        break;

      default:
        // HTTP_SENDTYPE_GET
        NNshHttp_createGetMsg(type, url, host, range, endRange, bufPtr, proxy);
        break;
    }

    // Proxyݒ肳Ă΁A擾zXgoverride
    if ((proxy != NULL)&&(*proxy != '\0'))
    {
        MemSet(host, sizeof(host), 0x00);
        StrNCopy(host, proxy, (MAX_URL - 1));
    }

    // lbgCuI[vĂȂƂ̓I[vB
    ret = NNshNet_open(&(NNshGlobal->netRef));
    if (ret != errNone)
    {
        // I[vs
        NNsh_DebugMessage(ALTID_ERROR, "failure ", "net_open()", ret);
        NNshGlobal->netRef = 0;
        MemPtrFree(bufPtr);
        return (ret);
    }

    // p[^ݒ肳ĂƂ́Aʂĕ`悷
    if (NNshParam->redrawAfterConnect != 0)
    {
        frm  = FrmGetActiveForm();
        FrmEraseForm(frm);
        NNsi_FrmDrawForm(frm, true);
    }

    // dnee^C}𖳌ɂ
    autoOffTime = SysSetAutoOffTime(0);
    (void) EvtResetAutoOffTimer();

    // BUSY\
    MemSet (logBuf, sizeof(logBuf), 0x00);
    StrCopy(logBuf, MSG_CONNECTING_TO);
    StrCat (logBuf, host);
    if ((message != NULL)&&(*message != '\0'))
    {
        // \bZ[WɎw肳ĂꍇA𖖔ɕt
        // (̕\bZ[ẂAƂ肠zXg֐ڑƂ̂ݕt)
        StrCat(logBuf, message);
    }
    Show_BusyForm(logBuf);

    // (HTTP)zXg֐ڑ
    ret = NNshNet_connect(&socketRef, NNshGlobal->netRef, host, port);
    if (ret != errNone)
    {
        // ڑɎs
        Hide_BusyForm(false);
        NNsh_DebugMessage(ALTID_ERROR,"connection failure HOST:", host, ret);
        MemPtrFree(bufPtr);
        NNshNet_close(NNshGlobal->netRef);

        // dOFF^C}𕜋
        (void) SysSetAutoOffTime(autoOffTime);
        (void) EvtResetAutoOffTimer();

        return (NNSH_ERRORCODE_FAILURECONNECT);
    }

    // HTTPvbZ[W̑M
    SetMsg_BusyForm(MSG_BUSY_SENDING);
    NNshNet_write(NNshGlobal->netRef, socketRef, StrLen(bufPtr), bufPtr);

    // HTTPf[^̎M(Mf[^FILE_RECVMSGɏo)
    SetMsg_BusyForm(MSG_BUSY_WAITREPLY);
    MemSet(&fileRef, sizeof(fileRef), 0x00);
    ret = OpenFile_NNsh(FILE_RECVMSG,
                        (NNSH_FILEMODE_READWRITE|NNSH_FILEMODE_TEMPFILE),
                        &fileRef);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "OpenFile_NNsh() ", " ret:", ret);
    }

    dataSize  = 0;
    totalSize = 0;
    ret       = errNone;
    while (ret == errNone)
    {
        dataSize = 0;
        // (ꎞ)Mobt@̃NA
        MemSet(bufPtr, NNshParam->bufferSize, 0x00);
        ret = NNshNet_read(NNshGlobal->netRef, socketRef,
                           NNshParam->bufferSize, bufPtr, &dataSize);
        if (ret != errNone)
        {
            break;
        }
        if (dataSize == 0)
        {
            break;
        }
        totalSize = totalSize + dataSize;
        MemSet (logBuf, sizeof(logBuf), 0x00);
        StrCopy(logBuf, MSG_BUSY_RECV_WAIT);
        NUMCATI(logBuf, totalSize);
        StrCat (logBuf, MSG_BUSY_RECV_BYTES);
        SetMsg_BusyForm(logBuf);
        err = AppendFile_NNsh(&fileRef,dataSize, bufPtr, &writeSize);
        if (err != errNone)
        {
            NNsh_DebugMessage(ALTID_ERROR, "AppendFile() ", " ret:", err);
        }
        if (writeSize == 0)
        {
            NNsh_DebugMessage(ALTID_ERROR, "AppendFile() ", 
                              " write size == 0", writeSize);
        }
    }
    err = AppendFile_NNsh(&fileRef,dataSize, bufPtr, &writeSize);
    if (err != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "AppendFile(end) ", " ret:", err);
    }
    err = CloseFile_NNsh (&fileRef);
    if (err != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "CloseFile() ", " ret:", err);
    }
    (void) MemPtrFree(bufPtr);


    // Mf[^TCY̕\
    MemSet (logBuf, sizeof(logBuf), 0x00);
    StrCopy(logBuf, MSG_BUSY_RECV_END);
    NUMCATI(logBuf, totalSize);
    StrCat (logBuf, MSG_BUSY_RECV_BYTES);
    SetMsg_BusyForm(logBuf);

    // zXgڑ؂ABUSYEBhE폜B
    NNshNet_disconnect(NNshGlobal->netRef, socketRef);
    NNshNet_close(NNshGlobal->netRef);
    Hide_BusyForm(false);

    // dOFF^C}𕜋
    (void) SysSetAutoOffTime(autoOffTime);
    (void) EvtResetAutoOffTimer();

    return (ret);

#endif     // #ifdef OFFLINE_DEBUG
}
