/*============================================================================*
 *  FILE: 
 *     inoutXML.c
 *
 *  Description: 
 *     NNsĩp[^o(XML`)
 *
 *===========================================================================*/
#define  INOUTXML_C
#include "local.h"

#ifdef USE_XML_OUTPUT
#include "xmldefs.h"

/*=========================================================================*/
/*   Function :   Output_NNsiSet_XML                                       */
/*                                         NNsiݒXML`ŏo͂鏈 */
/*=========================================================================*/
Err Output_NNsiSet_XML(Char *fileName)
{
  // NNsiݒ̍\(NNshSavedPref)Ƃ̉̃e[uĂKvB
  NNsiXMLItems *ptr, NNsiItem[] =
  {
    {SETITEM__handleName,             NNSISETFILE_TYPE_CHAR,   BUFSIZE,         &(NNshParam->handleName[0])}, 
    {SETITEM__bbs_URL,                NNSISETFILE_TYPE_CHAR,   MAX_URL,         &(NNshParam->bbs_URL[0])}, 
    {SETITEM__proxyURL,               NNSISETFILE_TYPE_CHAR,   MAX_URL,         &(NNshParam->proxyURL)}, 
    {SETITEM__netTimeout,             NNSISETFILE_TYPE_INT32,  sizeof(Int32),   &(NNshParam->netTimeout)}, 
    {SETITEM__getAllThread,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->getAllThread)}, 
    {SETITEM__confirmationDisable,    NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->confirmationDisable)}, 
    {SETITEM__openAutomatic,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->openAutomatic)}, 
    {SETITEM__writeAlwaysSage,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->writeAlwaysSage)}, 
    {SETITEM__useBookmark,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useBookmark)}, 
    {SETITEM__searchCaseless,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->searchCaseless)}, 
    {SETITEM__offChkLaunch,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->offChkLaunch)}, 
    {SETITEM__disableUnderline,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->disableUnderline)}, 
    {SETITEM__debugMessageON,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->debugMessageON)}, 
    {SETITEM__printNofMessage,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->printNofMessage)}, 
    {SETITEM__boldMessageNum,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->boldMessageNum)}, 
    {SETITEM__useVFS,                 NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useVFS)}, 
    {SETITEM__bufferSize,             NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->bufferSize)}, 
    {SETITEM__partGetSize,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->partGetSize)}, 
    {SETITEM__enablePartGet,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->enablePartGet)}, 
    {SETITEM__lastFrmID,              NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->lastFrmID)}, 
    {SETITEM__lastBBS,                NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->lastBBS)}, 
    {SETITEM__openMsgIndex,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->openMsgIndex)}, 
    {SETITEM__bookMsgIndex,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->bookMsgIndex)}, 
    {SETITEM__notCursor,              NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->notCursor)}, 
    {SETITEM__bookMsgNumber,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->bookMsgNumber)}, 
    {SETITEM__openThreadIndex,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->openThreadIndex)}, 
    {SETITEM__useFixedHandle,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useFixedHandle)}, 
    {SETITEM__disconnectNNsiEnd,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->disconnectNNsiEnd)}, 
    {SETITEM__useProxy,               NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useProxy)}, 
    {SETITEM__proxyPort,              NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->proxyPort)}, 
    {SETITEM__useCookieWrite,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useCookieWrite)}, 
    {SETITEM__copyDelReadOnly,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->copyDelReadOnly)}, 
    {SETITEM__vfsUseCompactFlash,     NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->vfsUseCompactFlash)}, 
    {SETITEM__vfsOnAutomatic,         NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->vfsOnAutomatic)}, 
    {SETITEM__currentFont,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->currentFont)}, 
    {SETITEM__notListReadOnly,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->notListReadOnly)}, 
    {SETITEM__redrawAfterConnect,     NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->redrawAfterConnect)}, 
    {SETITEM__insertReplyNum,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->insertReplyNum)}, 
    {SETITEM__useARMlet,              NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useARMlet)}, 
    {SETITEM__sonyHRFont,             NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->sonyHRFont)}, 
    {SETITEM__sonyHRFontTitle,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->sonyHRFontTitle)}, 
    {SETITEM__useSonyTinyFont,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useSonyTinyFont)}, 
    {SETITEM__useSonyTinyFontTitle,   NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useSonyTinyFontTitle)}, 
    {SETITEM__notOpenSilkWrite,       NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->notOpenSilkWrite)}, 
    {SETITEM__notAutoFocus,           NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->notAutoFocus)}, 
    {SETITEM__writeBufferSize,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->writeBufferSize)}, 
    {SETITEM__browseMesNum,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->browseMesNum)}, 
    {SETITEM__disconnArrivalEnd,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->disconnArrivalEnd)}, 
    {SETITEM__autoBeep,               NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->autoBeep)}, 
    {SETITEM__autoOpenNotRead,        NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->autoOpenNotRead)}, 
    {SETITEM__addReturnToList,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addReturnToList)}, 
    {SETITEM__jogBackBtnFeature,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->ttlFtr.jogBack)}, 
    {SETITEM__notUseSilk,             NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->notUseSilk)}, 
    {SETITEM__writeSequence2,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->writeSequence2)}, 
    {SETITEM__startTitleRec,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->startTitleRec)}, 
    {SETITEM__endTitleRec,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->endTitleRec)}, 
    {SETITEM__currentSelectRec,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->currentSelectRec)}, 
    {SETITEM__selectedTitleItem,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->selectedTitleItem)}, 
    {SETITEM__titleDispState,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->titleDispState)}, 
    {SETITEM__jogPushBtnFeature,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->ttlFtr.jogPush)}, 
    {SETITEM__convertHanZen,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->convertHanZen)},
    {SETITEM__addLineDisconn,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addLineDisconn)}, 
    {SETITEM__addLineGetPart,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addLineGetPart)}, 
    {SETITEM__addJumpTopMsg,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addJumpTopMsg)}, 
    {SETITEM__addJumpBottomMsg,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addJumpBottomMsg)}, 
    {SETITEM__addMenuSelAndWeb,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuSelAndWeb)}, 
    {SETITEM__addMenuMsg,             NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuMsg)}, 
    {SETITEM__addMenuBackRtnMsg,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuBackRtnMsg)}, 
    {SETITEM__addMenuGraphView,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuGraphView)}, 
    {SETITEM__addMenuFavorite,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuFavorite)}, 
    {SETITEM__addMenuOutputMemo,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuOutputMemo)}, 
    {SETITEM__addBtOnOff,             NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->addBtOnOff)}, 
    {SETITEM__addMenuTitle,           NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->addMenuTitle)}, 
    {SETITEM__addMenuDeleteMsg,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuDeleteMsg)}, 
    {SETITEM__addMenuCopyMsg,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuCopyMsg)}, 
    {SETITEM__addMenuGetMode,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuGetMode)}, 
    {SETITEM__addMenuGraphTitle,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuGraphTitle)}, 
    {SETITEM__addMenuMultiSW1,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuMultiSW1)}, 
    {SETITEM__addMenuMultiSW2,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuMultiSW2)}, 
    {SETITEM__addMenuNNsiEnd,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuNNsiEnd)}, 
    {SETITEM__addMenuDirSelect,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuDirSelect)},
    {SETITEM__disableSonyHR,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->disableSonyHR)}, 
    {SETITEM__useColor,               NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useColor)}, 
    {SETITEM__colorError,             NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorError)}, 
    {SETITEM__colorOver,              NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorOver)}, 
    {SETITEM__colorNotYet,            NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorNotYet)}, 
    {SETITEM__colorNew,               NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorNew)}, 
    {SETITEM__colorUpdate,            NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorUpdate)}, 
    {SETITEM__colorRemain,            NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorRemain)}, 
    {SETITEM__colorAlready,           NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorAlready)}, 
    {SETITEM__colorUnknown,           NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorUnknown)}, 
    {SETITEM__colorBackGround,        NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorBackGround)}, 
    {SETITEM__colorButton,            NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorButton)}, 
    {SETITEM__colorViewFG,            NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorViewFG)}, 
    {SETITEM__colorViewBG,            NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorViewBG)},
    {SETITEM__rawDisplayMode,         NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->rawDisplayMode)}, 
    {SETITEM__notDelOffline,          NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->notDelOffline)}, 
    {SETITEM__notFocusNumField,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->notFocusNumField)}, 
    {SETITEM__disableUnderlineWrite,  NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->disableUnderlineWrite)}, 
    {SETITEM__usageOfTitleMultiSwitch1,NNSISETFILE_TYPE_UINT16,sizeof(UInt16),  &(NNshParam->usageOfTitleMultiSwitch1)}, 
    {SETITEM__usageOfTitleMultiSwitch2,NNSISETFILE_TYPE_UINT16,sizeof(UInt16),  &(NNshParam->usageOfTitleMultiSwitch2)}, 
    {SETITEM__autoDeleteNotYet,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->autoDeleteNotYet)}, 
    {SETITEM__notCheckBBSURL,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->notCheckBBSURL)}, 
    {SETITEM__displayFavorLevel,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->displayFavorLevel)}, 
    {SETITEM__newArrivalNotRead,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->newArrivalNotRead)}, 
    {SETITEM__getReserveFeature,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->getReserveFeature)}, 
    {SETITEM__searchStrMessage,       NNSISETFILE_TYPE_CHAR, MAX_SEARCH_STRING, &(NNshParam->searchStrMessage[0])}, 
    {SETITEM__searchMode,             NNSISETFILE_TYPE_UINT32, sizeof(UInt32),  &(NNshParam->searchMode)}, 
    {SETITEM__bbsOverwrite,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->bbsOverwrite)}, 
    {SETITEM__useImodeURL,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useImodeURL)}, 
    {SETITEM__nofRetry,               NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->nofRetry)}, 
    {SETITEM__autoUpdateGetError,     NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->autoUpdateGetError)}, 
    {SETITEM__dispBottom,             NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->dispBottom)}, 
    {SETITEM__blockDispMode,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->blockDispMode)}, 
    {SETITEM__multiBtn1Feature,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->multiBtn1Feature)}, 
    {SETITEM__multiBtn1Caption,       NNSISETFILE_TYPE_CHAR,   MAX_CAPTION,     &(NNshParam->multiBtn1Caption[0])}, 
    {SETITEM__multiBtn2Feature,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->multiBtn2Feature)}, 
    {SETITEM__multiBtn2Caption,       NNSISETFILE_TYPE_CHAR,   MAX_CAPTION,     &(NNshParam->multiBtn2Caption[0])}, 
    {SETITEM__multiBtn3Feature,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->multiBtn3Feature)}, 
    {SETITEM__multiBtn3Caption,       NNSISETFILE_TYPE_CHAR,   MAX_CAPTION,     &(NNshParam->multiBtn3Caption[0])}, 
    {SETITEM__multiBtn4Feature,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->multiBtn4Feature)}, 
    {SETITEM__multiBtn4Caption,       NNSISETFILE_TYPE_CHAR,   MAX_CAPTION,     &(NNshParam->multiBtn4Caption[0])}, 
    {SETITEM__multiBtn5Feature,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->multiBtn5Feature)}, 
    {SETITEM__multiBtn5Caption,       NNSISETFILE_TYPE_CHAR,   MAX_CAPTION,     &(NNshParam->multiBtn5Caption[0])}, 
    {SETITEM__multiBtn6Feature,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->multiBtn6Feature)}, 
    {SETITEM__multiBtn6Caption,       NNSISETFILE_TYPE_CHAR,   MAX_CAPTION,     &(NNshParam->multiBtn6Caption[0])}, 
    {SETITEM__multiBtnUpFeature,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->ttlFtr.up)},  
    {SETITEM__multiBtnDownFeature,    NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->ttlFtr.down)},  
    {SETITEM__multiBtnHKey1Feature,   NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->ttlFtr.key1)},  
    {SETITEM__multiBtnHKey2Feature,   NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->ttlFtr.key2)},  
    {SETITEM__multiBtnHKey3Feature,   NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->ttlFtr.key3)},  
    {SETITEM__multiBtnHKey4Feature,   NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->ttlFtr.key4)},  
    {SETITEM__multiBtnCapture,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->ttlFtr.clieCapture)},  
    {SETITEM__multiBtnLeftFeature,    NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->ttlFtr.left)},  
    {SETITEM__multiBtnRightFeature,   NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->ttlFtr.right)},  
    {SETITEM__useHardKeyControl,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useHardKeyControl)},
    {SETITEM__checkDuplicateThread,   NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->checkDuplicateThread)}, 
    {SETITEM__hideMessage,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->hideMessage)}, 
    {SETITEM__hideWord1,              NNSISETFILE_TYPE_CHAR,   HIDEBUFSIZE,      &(NNshParam->hideWord1[0])}, 
    {SETITEM__hideWord2,              NNSISETFILE_TYPE_CHAR,   HIDEBUFSIZE,      &(NNshParam->hideWord2[0])}, 
    {SETITEM__CS1tabName,             NNSISETFILE_TYPE_CHAR,   MAX_BOARDNAME,    &(NNshParam->custom1.tabName[0])}, 
    {SETITEM__CS1newArrival,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom1.newArrival)}, 
    {SETITEM__CS1getList,             NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom1.getList)}, 
    {SETITEM__CS1condition,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom1.condition)}, 
    {SETITEM__CS1boardNick,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom1.boardNick)}, 
    {SETITEM__CS1boardCondition,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom1.boardCondition)}, 
    {SETITEM__CS1threadLevel,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom1.threadLevel)}, 
    {SETITEM__CS1threadStatus,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom1.threadStatus)},
    {SETITEM__CS1threadCreate,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom1.threadCreate)}, 
    {SETITEM__CS1stringSet,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom1.stringSet)}, 
    {SETITEM__CS1string1,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom1.string1[0])}, 
    {SETITEM__CS1string2,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom1.string2[0])}, 
    {SETITEM__CS1string3,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom1.string3[0])}, 
    {SETITEM__CS2tabName,             NNSISETFILE_TYPE_CHAR,   MAX_BOARDNAME,    &(NNshParam->custom2.tabName[0])}, 
    {SETITEM__CS2newArrival,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom2.newArrival)}, 
    {SETITEM__CS2getList,             NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom2.getList)}, 
    {SETITEM__CS2condition,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom2.condition)}, 
    {SETITEM__CS2boardNick,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom2.boardNick)}, 
    {SETITEM__CS2boardCondition,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom2.boardCondition)}, 
    {SETITEM__CS2threadLevel,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom2.threadLevel)}, 
    {SETITEM__CS2threadStatus,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom2.threadStatus)}, 
    {SETITEM__CS2threadCreate,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom2.threadCreate)}, 
    {SETITEM__CS2stringSet,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom2.stringSet)}, 
    {SETITEM__CS2string1,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom2.string1[0])}, 
    {SETITEM__CS2string2,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom2.string2[0])}, 
    {SETITEM__CS2string3,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom2.string3[0])}, 
    {SETITEM__CS3tabName,             NNSISETFILE_TYPE_CHAR,   MAX_BOARDNAME,    &(NNshParam->custom3.tabName[0])}, 
    {SETITEM__CS3newArrival,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom3.newArrival)}, 
    {SETITEM__CS3getList,             NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom3.getList)}, 
    {SETITEM__CS3condition,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom3.condition)}, 
    {SETITEM__CS3boardNick,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom3.boardNick)}, 
    {SETITEM__CS3boardCondition,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom3.boardCondition)}, 
    {SETITEM__CS3threadLevel,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom3.threadLevel)}, 
    {SETITEM__CS3threadStatus,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom3.threadStatus)},
    {SETITEM__CS3threadCreate,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom3.threadCreate)}, 
    {SETITEM__CS3stringSet,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom3.stringSet)}, 
    {SETITEM__CS3string1,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom3.string1[0])}, 
    {SETITEM__CS3string2,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom3.string2[0])}, 
    {SETITEM__CS3string3,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom3.string3[0])}, 
    {SETITEM__CS4tabName,             NNSISETFILE_TYPE_CHAR,   MAX_BOARDNAME,    &(NNshParam->custom4.tabName[0])}, 
    {SETITEM__CS4newArrival,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom4.newArrival)}, 
    {SETITEM__CS4getList,             NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom4.getList)}, 
    {SETITEM__CS4condition,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom4.condition)}, 
    {SETITEM__CS4boardNick,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom4.boardNick)}, 
    {SETITEM__CS4boardCondition,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom4.boardCondition)}, 
    {SETITEM__CS4threadLevel,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom4.threadLevel)}, 
    {SETITEM__CS4threadStatus,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom4.threadStatus)},
    {SETITEM__CS4threadCreate,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom4.threadCreate)}, 
    {SETITEM__CS4stringSet,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom4.stringSet)}, 
    {SETITEM__CS4string1,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom4.string1[0])}, 
    {SETITEM__CS4string2,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom4.string2[0])}, 
    {SETITEM__CS4string3,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom4.string3[0])}, 
    {SETITEM__CS5tabName,             NNSISETFILE_TYPE_CHAR,   MAX_BOARDNAME,    &(NNshParam->custom5.tabName[0])}, 
    {SETITEM__CS5newArrival,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom5.newArrival)}, 
    {SETITEM__CS5getList,             NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom5.getList)}, 
    {SETITEM__CS5condition,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom5.condition)}, 
    {SETITEM__CS5boardNick,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom5.boardNick)}, 
    {SETITEM__CS5boardCondition,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom5.boardCondition)}, 
    {SETITEM__CS5threadLevel,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom5.threadLevel)}, 
    {SETITEM__CS5threadStatus,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom5.threadStatus)},
    {SETITEM__CS5threadCreate,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom5.threadCreate)}, 
    {SETITEM__CS5stringSet,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom5.stringSet)}, 
    {SETITEM__CS5string1,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom5.string1[0])}, 
    {SETITEM__CS5string2,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom5.string2[0])}, 
    {SETITEM__CS5string3,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom5.string3[0])}, 
    {SETITEM__writeJogPushDisable,    NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->writeJogPushDisable)}, 
    {SETITEM__autostartMacro      ,   NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->autostartMacro)}, 
    {SETITEM__enableNewArrivalHtml,   NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->enableNewArrivalHtml)}, 
    {SETITEM__useRegularExpression,   NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useRegularExpression)}, 
    {SETITEM__vfsOnNotDBCheck,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->vfsOnNotDBCheck)}, 
    {SETITEM__writeMessageAutoSave,   NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->writeMessageAutoSave)}, 
    {SETITEM__useHardKey1,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useKey.key1)},  
    {SETITEM__useHardKey2,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useKey.key2)},  
    {SETITEM__useHardKey3,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useKey.key3)},  
    {SETITEM__useHardKey4,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useKey.key4)},  
    {SETITEM__useClieCapture,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useKey.clieCapture)},  
    {SETITEM__useLeftBtn,             NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useKey.left)},  
    {SETITEM__useRightBtn,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useKey.right)},  
    {SETITEM__addMenuDeviceInfo,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuDeviceInfo)},
    {SETITEM__addDeviceInfo,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addDeviceInfo)},
    {SETITEM__useViewHardKey1,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewFtr.key1)},
    {SETITEM__useViewHardKey2,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewFtr.key2)},
    {SETITEM__useViewHardKey3,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewFtr.key3)},
    {SETITEM__useViewHardKey4,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewFtr.key4)},
    {SETITEM__useViewClieCapture,     NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewFtr.clieCapture)},
    {SETITEM__useViewUp,              NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewFtr.up)},
    {SETITEM__useViewDown,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewFtr.down)},
    {SETITEM__useViewLeft,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewFtr.left)},
    {SETITEM__useViewRight,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewFtr.right)},
    {SETITEM__useViewJogPush,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewFtr.jogPush)}, 
    {SETITEM__useViewJogBack,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewFtr.jogBack)},
    {SETITEM__readOnlySelection,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->readOnlySelection)},
    {SETITEM__use_DAplugin,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->use_DAplugin)},
    {SETITEM__listAndUpdate,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->listAndUpdate)},
    {SETITEM__msgNumLimit,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->msgNumLimit)},
    {SETITEM__notUseTsPatch,          NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->notUseTsPatch)},
    {SETITEM__getROLogLevel,          NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->getROLogLevel)},
    {SETITEM__viewMultiBtnFeature,    NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewMultiBtnFeature)},
    {SETITEM__viewSearchStrHeader,    NNSISETFILE_TYPE_CHAR,   SEARCH_HEADLEN,   &(NNshParam->viewSearchStrHeader[0])},
    {SETITEM__enableSearchStrHeader,  NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->enableSearchStrHeader)},
    {SETITEM__viewTitleSelFeature,    NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewTitleSelFeature)},
    {"", 0, 0, 0}
  };
  Err          ret;
  UInt32       temp;
  UInt16       len, mod;
  Char        *buffer;
  NNshFileRef  fileRefW;

    // ̈̍쐬
    len    = NNSH_WORKBUF_DEFAULT + MARGIN;
    buffer = MemPtrNew(len);
    if (buffer == NULL)
    {
        // ̈mێs
        NNsh_DebugMessage(ALTID_ERROR, MSG_MEMORY_ALLOC_FAIL, " size:", len);
        return (~errNone);
    }
    MemSet(buffer, len, 0x00);

    // Ƀt@C݂ꍇ͈U폜ĂI[vB
    ret = OpenFile_NNsh(fileName, NNSH_FILEMODE_CREATE, &fileRefW);
    if (ret != errNone)
    {
        NNsh_InformMessage(ALTID_ERROR, MSG_WRITEFILE_OPENFAIL, fileName, ret);
        MEMFREE_PTR(buffer);
        return (~errNone);
    }

    // t@Co͒̕\
    Show_BusyForm(MSG_OUTPUT_XML_WAIT);

    // wlkwb_o
    MemSet (buffer, len, 0x00);
    StrCopy(buffer, NNSISETFILE_HEAD);

    // DOCTYPE錾Al[Xy[Xo
    StrCat(buffer, NNSISETFILE_DTD_URI NNSISETFILE_NNSI_NS_B);

    // [gGgo͊Jn
    StrCat (buffer, NNSISETFILE_NNSISET_B);
    NUMCATI(buffer, DBVERSION_XML_SETTING);
    StrCat (buffer, "\">\n");

    ptr = NNsiItem;
    while (ptr->itemName[0] != '\0')
    {
        // eACȅo
        StrCat (buffer, "    ");
        StrCat (buffer, NNSISETFILE_ITEM_BEGIN);
        StrCat (buffer, ptr->itemName);
        StrCat (buffer, NNSISETFILE_ATTR_TYPE);
        switch (ptr->itemType)
        {
          case NNSISETFILE_TYPE_CHAR:
            // ̏o
            StrCat (buffer, "\"" NNSISETFILE_ITEMTYPE_CHAR "[");
            NUMCATI(buffer, ptr->length);
            StrCat (buffer, "]\">\n      " NNSISETFILE_VALTAG_BEGIN);
            StrCat (buffer, "\"");
            StrCat (buffer, (Char *) ptr->value);
            StrCat (buffer, "\"");
            break;
          case NNSISETFILE_TYPE_UINT8:
            StrCat (buffer, NNSISETFILE_ITEMTYPE_UINT8 ">\n      " NNSISETFILE_VALTAG_BEGIN);
            temp = *((UInt8 *) ptr->value); 
            NUMCATI(buffer, temp);
            break;

          case NNSISETFILE_TYPE_INT16:
            StrCat (buffer, NNSISETFILE_ITEMTYPE_INT16 ">\n      " NNSISETFILE_VALTAG_BEGIN);
            temp = *((Int16 *) ptr->value); 
            NUMCATI(buffer, temp);
            break;

          case NNSISETFILE_TYPE_INT32:
            StrCat (buffer, NNSISETFILE_ITEMTYPE_INT32 ">\n      " NNSISETFILE_VALTAG_BEGIN);
            temp = *((Int32 *) ptr->value); 
            NUMCATI(buffer, temp);
            break;

          case NNSISETFILE_TYPE_UINT32:
            StrCat (buffer, NNSISETFILE_ITEMTYPE_UINT32 ">\n      " NNSISETFILE_VALTAG_BEGIN);
            temp = *((UInt32 *) ptr->value); 
            NUMCATI(buffer, temp);
            break;

          case NNSISETFILE_TYPE_UINT16:
          default:
            StrCat (buffer, NNSISETFILE_ITEMTYPE_UINT16 ">\n      " NNSISETFILE_VALTAG_BEGIN);
            temp = *((UInt16 *) ptr->value); 
            NUMCATI(buffer, temp);
            break;
        }
        StrCat (buffer, NNSISETFILE_VALTAG_END);
        StrCat (buffer, NNSISETFILE_ITEM_END);
        ptr++;
    }

    // [gGgo͏I
    StrCat(buffer, NNSISETFILE_NNSISET_E "\n" NNSISETFILE_NNSI_NS_E);
    mod = StrLen(buffer) % 2;
    if (mod != 0)
    {
        StrCat(buffer, "\n");
    }
    else
    {
        StrCat(buffer, " \n");
    }

    // wlk`̃f[^"ꊇ"o͂B
    ret = AppendFile_NNsh(&fileRefW, StrLen(buffer), buffer, &temp);
    if (ret != errNone)
    {
        // o͎sI
        goto FUNC_END;
    }

FUNC_END:
    CloseFile_NNsh(&fileRefW);
    MEMFREE_PTR(buffer);

    Hide_BusyForm(false);
    return (ret);
}

/*=========================================================================*/
/*   Function :  Input_NNsiSet_XML                                         */
/*                                         XML`NNsiݒ͂鏈 */
/*=========================================================================*/
Err Input_NNsiSet_XML(Char *fileName)
{
  // NNsiݒ̍\(NNshSavedPref)Ƃ̉̃e[uĂKvB
  NNsiXMLItems *ptr, NNsiItem[] =
  {
    {SETITEM__handleName,             NNSISETFILE_TYPE_CHAR,   BUFSIZE,         &(NNshParam->handleName[0])}, 
    {SETITEM__bbs_URL,                NNSISETFILE_TYPE_CHAR,   MAX_URL,         &(NNshParam->bbs_URL[0])}, 
    {SETITEM__proxyURL,               NNSISETFILE_TYPE_CHAR,   MAX_URL,         &(NNshParam->proxyURL)}, 
    {SETITEM__netTimeout,             NNSISETFILE_TYPE_INT32,  sizeof(Int32),   &(NNshParam->netTimeout)}, 
    {SETITEM__getAllThread,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->getAllThread)}, 
    {SETITEM__confirmationDisable,    NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->confirmationDisable)}, 
    {SETITEM__openAutomatic,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->openAutomatic)}, 
    {SETITEM__writeAlwaysSage,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->writeAlwaysSage)}, 
    {SETITEM__useBookmark,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useBookmark)}, 
    {SETITEM__searchCaseless,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->searchCaseless)}, 
    {SETITEM__offChkLaunch,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->offChkLaunch)}, 
    {SETITEM__disableUnderline,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->disableUnderline)}, 
    {SETITEM__debugMessageON,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->debugMessageON)}, 
    {SETITEM__printNofMessage,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->printNofMessage)}, 
    {SETITEM__boldMessageNum,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->boldMessageNum)}, 
    {SETITEM__useVFS,                 NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useVFS)}, 
    {SETITEM__bufferSize,             NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->bufferSize)}, 
    {SETITEM__partGetSize,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->partGetSize)}, 
    {SETITEM__enablePartGet,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->enablePartGet)}, 
    {SETITEM__lastFrmID,              NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->lastFrmID)}, 
    {SETITEM__lastBBS,                NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->lastBBS)}, 
    {SETITEM__openMsgIndex,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->openMsgIndex)}, 
    {SETITEM__bookMsgIndex,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->bookMsgIndex)}, 
    {SETITEM__notCursor,              NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->notCursor)}, 
    {SETITEM__bookMsgNumber,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->bookMsgNumber)}, 
    {SETITEM__openThreadIndex,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->openThreadIndex)}, 
    {SETITEM__useFixedHandle,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useFixedHandle)}, 
    {SETITEM__disconnectNNsiEnd,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->disconnectNNsiEnd)}, 
    {SETITEM__useProxy,               NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useProxy)}, 
    {SETITEM__proxyPort,              NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->proxyPort)}, 
    {SETITEM__useCookieWrite,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useCookieWrite)}, 
    {SETITEM__copyDelReadOnly,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->copyDelReadOnly)}, 
    {SETITEM__vfsUseCompactFlash,     NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->vfsUseCompactFlash)}, 
    {SETITEM__vfsOnAutomatic,         NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->vfsOnAutomatic)}, 
    {SETITEM__currentFont,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->currentFont)}, 
    {SETITEM__notListReadOnly,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->notListReadOnly)}, 
    {SETITEM__redrawAfterConnect,     NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->redrawAfterConnect)}, 
    {SETITEM__insertReplyNum,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->insertReplyNum)}, 
    {SETITEM__useARMlet,              NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useARMlet)}, 
    {SETITEM__sonyHRFont,             NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->sonyHRFont)}, 
    {SETITEM__sonyHRFontTitle,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->sonyHRFontTitle)}, 
    {SETITEM__useSonyTinyFont,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useSonyTinyFont)}, 
    {SETITEM__useSonyTinyFontTitle,   NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useSonyTinyFontTitle)}, 
    {SETITEM__notOpenSilkWrite,       NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->notOpenSilkWrite)}, 
    {SETITEM__notAutoFocus,           NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->notAutoFocus)}, 
    {SETITEM__writeBufferSize,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->writeBufferSize)}, 
    {SETITEM__browseMesNum,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->browseMesNum)}, 
    {SETITEM__disconnArrivalEnd,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->disconnArrivalEnd)}, 
    {SETITEM__autoBeep,               NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->autoBeep)}, 
    {SETITEM__autoOpenNotRead,        NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->autoOpenNotRead)}, 
    {SETITEM__addReturnToList,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addReturnToList)}, 
    {SETITEM__jogBackBtnFeature,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->ttlFtr.jogBack)}, 
    {SETITEM__notUseSilk,             NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->notUseSilk)}, 
    {SETITEM__writeSequence2,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->writeSequence2)}, 
    {SETITEM__startTitleRec,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->startTitleRec)}, 
    {SETITEM__endTitleRec,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->endTitleRec)}, 
    {SETITEM__currentSelectRec,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->currentSelectRec)}, 
    {SETITEM__selectedTitleItem,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->selectedTitleItem)}, 
    {SETITEM__titleDispState,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->titleDispState)}, 
    {SETITEM__jogPushBtnFeature,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->ttlFtr.jogPush)}, 
    {SETITEM__convertHanZen,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->convertHanZen)},
    {SETITEM__addLineDisconn,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addLineDisconn)}, 
    {SETITEM__addLineGetPart,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addLineGetPart)}, 
    {SETITEM__addJumpTopMsg,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addJumpTopMsg)}, 
    {SETITEM__addJumpBottomMsg,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addJumpBottomMsg)}, 
    {SETITEM__addMenuSelAndWeb,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuSelAndWeb)}, 
    {SETITEM__addMenuMsg,             NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuMsg)}, 
    {SETITEM__addMenuBackRtnMsg,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuBackRtnMsg)}, 
    {SETITEM__addMenuGraphView,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuGraphView)}, 
    {SETITEM__addMenuFavorite,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuFavorite)}, 
    {SETITEM__addMenuOutputMemo,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuOutputMemo)}, 
    {SETITEM__addBtOnOff,             NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->addBtOnOff)}, 
    {SETITEM__addMenuTitle,           NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->addMenuTitle)}, 
    {SETITEM__addMenuDeleteMsg,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuDeleteMsg)}, 
    {SETITEM__addMenuCopyMsg,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuCopyMsg)}, 
    {SETITEM__addMenuGetMode,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuGetMode)}, 
    {SETITEM__addMenuGraphTitle,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuGraphTitle)}, 
    {SETITEM__addMenuMultiSW1,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuMultiSW1)}, 
    {SETITEM__addMenuMultiSW2,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuMultiSW2)}, 
    {SETITEM__addMenuDirSelect,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuDirSelect)},
    {SETITEM__addMenuNNsiEnd,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuNNsiEnd)}, 
    {SETITEM__disableSonyHR,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->disableSonyHR)}, 
    {SETITEM__useColor,               NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useColor)}, 
    {SETITEM__colorError,             NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorError)}, 
    {SETITEM__colorOver,              NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorOver)}, 
    {SETITEM__colorNotYet,            NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorNotYet)}, 
    {SETITEM__colorNew,               NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorNew)}, 
    {SETITEM__colorUpdate,            NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorUpdate)}, 
    {SETITEM__colorRemain,            NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorRemain)}, 
    {SETITEM__colorAlready,           NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorAlready)}, 
    {SETITEM__colorUnknown,           NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorUnknown)}, 
    {SETITEM__colorBackGround,        NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorBackGround)}, 
    {SETITEM__colorButton,            NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorButton)}, 
    {SETITEM__colorViewFG,            NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorViewFG)}, 
    {SETITEM__colorViewBG,            NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->colorViewBG)},
    {SETITEM__rawDisplayMode,         NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->rawDisplayMode)}, 
    {SETITEM__notDelOffline,          NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->notDelOffline)}, 
    {SETITEM__notFocusNumField,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->notFocusNumField)}, 
    {SETITEM__disableUnderlineWrite,  NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->disableUnderlineWrite)}, 
    {SETITEM__usageOfTitleMultiSwitch1,NNSISETFILE_TYPE_UINT16,sizeof(UInt16),  &(NNshParam->usageOfTitleMultiSwitch1)}, 
    {SETITEM__usageOfTitleMultiSwitch2,NNSISETFILE_TYPE_UINT16,sizeof(UInt16),  &(NNshParam->usageOfTitleMultiSwitch2)}, 
    {SETITEM__autoDeleteNotYet,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->autoDeleteNotYet)}, 
    {SETITEM__notCheckBBSURL,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->notCheckBBSURL)}, 
    {SETITEM__displayFavorLevel,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->displayFavorLevel)}, 
    {SETITEM__newArrivalNotRead,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->newArrivalNotRead)}, 
    {SETITEM__getReserveFeature,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->getReserveFeature)}, 
    {SETITEM__searchStrMessage,       NNSISETFILE_TYPE_CHAR, MAX_SEARCH_STRING, &(NNshParam->searchStrMessage[0])}, 
    {SETITEM__searchMode,             NNSISETFILE_TYPE_UINT32, sizeof(UInt32),  &(NNshParam->searchMode)}, 
    {SETITEM__bbsOverwrite,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->bbsOverwrite)}, 
    {SETITEM__useImodeURL,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useImodeURL)}, 
    {SETITEM__nofRetry,               NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->nofRetry)}, 
    {SETITEM__autoUpdateGetError,     NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->autoUpdateGetError)}, 
    {SETITEM__dispBottom,             NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->dispBottom)}, 
    {SETITEM__blockDispMode,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->blockDispMode)}, 
    {SETITEM__multiBtn1Feature,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->multiBtn1Feature)}, 
    {SETITEM__multiBtn1Caption,       NNSISETFILE_TYPE_CHAR,   MAX_CAPTION,     &(NNshParam->multiBtn1Caption[0])}, 
    {SETITEM__multiBtn2Feature,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->multiBtn2Feature)}, 
    {SETITEM__multiBtn2Caption,       NNSISETFILE_TYPE_CHAR,   MAX_CAPTION,     &(NNshParam->multiBtn2Caption[0])}, 
    {SETITEM__multiBtn3Feature,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->multiBtn3Feature)}, 
    {SETITEM__multiBtn3Caption,       NNSISETFILE_TYPE_CHAR,   MAX_CAPTION,     &(NNshParam->multiBtn3Caption[0])}, 
    {SETITEM__multiBtn4Feature,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->multiBtn4Feature)}, 
    {SETITEM__multiBtn4Caption,       NNSISETFILE_TYPE_CHAR,   MAX_CAPTION,     &(NNshParam->multiBtn4Caption[0])}, 
    {SETITEM__multiBtn5Feature,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->multiBtn5Feature)}, 
    {SETITEM__multiBtn5Caption,       NNSISETFILE_TYPE_CHAR,   MAX_CAPTION,     &(NNshParam->multiBtn5Caption[0])}, 
    {SETITEM__multiBtn6Feature,       NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->multiBtn6Feature)}, 
    {SETITEM__multiBtn6Caption,       NNSISETFILE_TYPE_CHAR,   MAX_CAPTION,     &(NNshParam->multiBtn6Caption[0])}, 
    {SETITEM__multiBtnUpFeature,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->ttlFtr.up)},  
    {SETITEM__multiBtnDownFeature,    NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->ttlFtr.down)},  
    {SETITEM__multiBtnHKey1Feature,   NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->ttlFtr.key1)},  
    {SETITEM__multiBtnHKey2Feature,   NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->ttlFtr.key2)},  
    {SETITEM__multiBtnHKey3Feature,   NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->ttlFtr.key3)},  
    {SETITEM__multiBtnHKey4Feature,   NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->ttlFtr.key4)},  
    {SETITEM__multiBtnCapture,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->ttlFtr.clieCapture)},  
    {SETITEM__multiBtnLeftFeature,    NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->ttlFtr.left)},  
    {SETITEM__multiBtnRightFeature,   NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->ttlFtr.right)},  
    {SETITEM__useHardKeyControl,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useHardKeyControl)},
    {SETITEM__checkDuplicateThread,   NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->checkDuplicateThread)}, 
    {SETITEM__hideMessage,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->hideMessage)}, 
    {SETITEM__hideWord1,              NNSISETFILE_TYPE_CHAR,   HIDEBUFSIZE,     &(NNshParam->hideWord1[0])}, 
    {SETITEM__hideWord2,              NNSISETFILE_TYPE_CHAR,   HIDEBUFSIZE,     &(NNshParam->hideWord2[0])}, 
    {SETITEM__CS1tabName,             NNSISETFILE_TYPE_CHAR,   MAX_BOARDNAME,   &(NNshParam->custom1.tabName[0])}, 
    {SETITEM__CS1newArrival,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom1.newArrival)}, 
    {SETITEM__CS1getList,             NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom1.getList)}, 
    {SETITEM__CS1condition,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom1.condition)}, 
    {SETITEM__CS1boardNick,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom1.boardNick)}, 
    {SETITEM__CS1boardCondition,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom1.boardCondition)}, 
    {SETITEM__CS1threadLevel,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom1.threadLevel)}, 
    {SETITEM__CS1threadStatus,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom1.threadStatus)}, 
    {SETITEM__CS1stringSet,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom1.stringSet)}, 
    {SETITEM__CS1string1,             NNSISETFILE_TYPE_CHAR,   MINIBUF,         &(NNshParam->custom1.string1[0])}, 
    {SETITEM__CS1string2,             NNSISETFILE_TYPE_CHAR,   MINIBUF,         &(NNshParam->custom1.string2[0])}, 
    {SETITEM__CS1string3,             NNSISETFILE_TYPE_CHAR,   MINIBUF,         &(NNshParam->custom1.string3[0])}, 
    {SETITEM__CS2tabName,             NNSISETFILE_TYPE_CHAR,   MAX_BOARDNAME,   &(NNshParam->custom2.tabName[0])}, 
    {SETITEM__CS2newArrival,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom2.newArrival)}, 
    {SETITEM__CS2getList,             NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom2.getList)}, 
    {SETITEM__CS2condition,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom2.condition)}, 
    {SETITEM__CS2boardNick,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom2.boardNick)}, 
    {SETITEM__CS2boardCondition,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom2.boardCondition)}, 
    {SETITEM__CS2threadLevel,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom2.threadLevel)}, 
    {SETITEM__CS2threadStatus,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom2.threadStatus)}, 
    {SETITEM__CS2stringSet,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom2.stringSet)}, 
    {SETITEM__CS2string1,             NNSISETFILE_TYPE_CHAR,   MINIBUF,         &(NNshParam->custom2.string1[0])}, 
    {SETITEM__CS2string2,             NNSISETFILE_TYPE_CHAR,   MINIBUF,         &(NNshParam->custom2.string2[0])}, 
    {SETITEM__CS2string3,             NNSISETFILE_TYPE_CHAR,   MINIBUF,         &(NNshParam->custom2.string3[0])}, 
    {SETITEM__CS3tabName,             NNSISETFILE_TYPE_CHAR,   MAX_BOARDNAME,    &(NNshParam->custom3.tabName[0])}, 
    {SETITEM__CS3newArrival,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom3.newArrival)}, 
    {SETITEM__CS3getList,             NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom3.getList)}, 
    {SETITEM__CS3condition,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom3.condition)}, 
    {SETITEM__CS3boardNick,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom3.boardNick)}, 
    {SETITEM__CS3boardCondition,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom3.boardCondition)}, 
    {SETITEM__CS3threadLevel,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom3.threadLevel)}, 
    {SETITEM__CS3threadStatus,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom3.threadStatus)},
    {SETITEM__CS3threadCreate,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom3.threadCreate)}, 
    {SETITEM__CS3stringSet,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom3.stringSet)}, 
    {SETITEM__CS3string1,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom3.string1[0])}, 
    {SETITEM__CS3string2,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom3.string2[0])}, 
    {SETITEM__CS3string3,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom3.string3[0])}, 
    {SETITEM__CS4tabName,             NNSISETFILE_TYPE_CHAR,   MAX_BOARDNAME,    &(NNshParam->custom4.tabName[0])}, 
    {SETITEM__CS4newArrival,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom4.newArrival)}, 
    {SETITEM__CS4getList,             NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom4.getList)}, 
    {SETITEM__CS4condition,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom4.condition)}, 
    {SETITEM__CS4boardNick,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom4.boardNick)}, 
    {SETITEM__CS4boardCondition,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom4.boardCondition)}, 
    {SETITEM__CS4threadLevel,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom4.threadLevel)}, 
    {SETITEM__CS4threadStatus,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom4.threadStatus)},
    {SETITEM__CS4threadCreate,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom4.threadCreate)}, 
    {SETITEM__CS4stringSet,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom4.stringSet)}, 
    {SETITEM__CS4string1,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom4.string1[0])}, 
    {SETITEM__CS4string2,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom4.string2[0])}, 
    {SETITEM__CS4string3,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom4.string3[0])}, 
    {SETITEM__CS5tabName,             NNSISETFILE_TYPE_CHAR,   MAX_BOARDNAME,    &(NNshParam->custom5.tabName[0])}, 
    {SETITEM__CS5newArrival,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom5.newArrival)}, 
    {SETITEM__CS5getList,             NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom5.getList)}, 
    {SETITEM__CS5condition,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom5.condition)}, 
    {SETITEM__CS5boardNick,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom5.boardNick)}, 
    {SETITEM__CS5boardCondition,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom5.boardCondition)}, 
    {SETITEM__CS5threadLevel,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom5.threadLevel)}, 
    {SETITEM__CS5threadStatus,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom5.threadStatus)},
    {SETITEM__CS5threadCreate,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom5.threadCreate)}, 
    {SETITEM__CS5stringSet,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->custom5.stringSet)}, 
    {SETITEM__CS5string1,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom5.string1[0])}, 
    {SETITEM__CS5string2,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom5.string2[0])}, 
    {SETITEM__CS5string3,             NNSISETFILE_TYPE_CHAR,   MINIBUF,          &(NNshParam->custom5.string3[0])}, 
    {SETITEM__writeJogPushDisable,    NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->writeJogPushDisable)}, 
    {SETITEM__autostartMacro      ,   NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->autostartMacro)}, 
    {SETITEM__enableNewArrivalHtml,   NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->enableNewArrivalHtml)}, 
    {SETITEM__useRegularExpression,   NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useRegularExpression)}, 
    {SETITEM__vfsOnNotDBCheck,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->vfsOnNotDBCheck)}, 
    {SETITEM__writeMessageAutoSave,   NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->writeMessageAutoSave)}, 
    {SETITEM__useHardKey1,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useKey.key1)},  
    {SETITEM__useHardKey2,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useKey.key2)},  
    {SETITEM__useHardKey3,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useKey.key3)},  
    {SETITEM__useHardKey4,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useKey.key4)},  
    {SETITEM__useClieCapture,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useKey.clieCapture)},  
    {SETITEM__useLeftBtn,             NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useKey.left)},  
    {SETITEM__useRightBtn,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->useKey.right)},  
    {SETITEM__addMenuDeviceInfo,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addMenuDeviceInfo)},
    {SETITEM__addDeviceInfo,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->addDeviceInfo)},
    {SETITEM__useViewHardKey1,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewFtr.key1)},
    {SETITEM__useViewHardKey2,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewFtr.key2)},
    {SETITEM__useViewHardKey3,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewFtr.key3)},
    {SETITEM__useViewHardKey4,        NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewFtr.key4)},
    {SETITEM__useViewClieCapture,     NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewFtr.clieCapture)},
    {SETITEM__useViewUp,              NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewFtr.up)},
    {SETITEM__useViewDown,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewFtr.down)},
    {SETITEM__useViewLeft,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewFtr.left)},
    {SETITEM__useViewRight,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewFtr.right)},
    {SETITEM__useViewJogPush,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewFtr.jogPush)}, 
    {SETITEM__useViewJogBack,         NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewFtr.jogBack)},
    {SETITEM__readOnlySelection,      NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->readOnlySelection)},
    {SETITEM__use_DAplugin,           NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->use_DAplugin)},
    {SETITEM__listAndUpdate,          NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->listAndUpdate)},
    {SETITEM__msgNumLimit,            NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->msgNumLimit)},
    {SETITEM__notUseTsPatch,          NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->notUseTsPatch)},
    {SETITEM__getROLogLevel,          NNSISETFILE_TYPE_UINT8,  sizeof(UInt8),   &(NNshParam->getROLogLevel)},
    {SETITEM__viewMultiBtnFeature,    NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewMultiBtnFeature)},
    {SETITEM__viewSearchStrHeader,    NNSISETFILE_TYPE_CHAR,   SEARCH_HEADLEN,   &(NNshParam->viewSearchStrHeader[0])},
    {SETITEM__enableSearchStrHeader,  NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->enableSearchStrHeader)},
    {SETITEM__viewTitleSelFeature,    NNSISETFILE_TYPE_UINT16, sizeof(UInt16),  &(NNshParam->viewTitleSelFeature)},
    {"", 0, 0, 0}
  };
  Err          ret;
  Int32        mod;
  UInt32       temp, fileSize;
  UInt16       len;
  Char        *buffer, *tempBuf, *area, *start, *end, *loc;
  NNshFileRef  fileRefR;

  // ̈̍쐬
  len    = BIGBUF + MARGIN;
  tempBuf = MemPtrNew(len);
  if (tempBuf == NULL)
  {
        // ̈mێs
        NNsh_DebugMessage(ALTID_ERROR, MSG_MEMORY_ALLOC_FAIL, " size:", len);
        return (~errNone);
  }
  MemSet(tempBuf, len, 0x00);

  // ǂݍ݃t@C̃I[v
  ret = OpenFile_NNsh(fileName, (NNSH_FILEMODE_READONLY), &fileRefR);
  if (ret != errNone)
  {
      NNsh_InformMessage(ALTID_ERROR, MSG_READFILE_OPENFAIL, fileName, ret);
      MEMFREE_PTR(tempBuf);
      return (~errNone);
  }

  // ǂݍރt@CTCY̊mF
  ret = GetFileSize_NNsh(&fileRefR, &fileSize);
  if (ret != errNone)
  {
      NNsh_InformMessage(ALTID_ERROR, MSG_READFILE_OPENFAIL, fileName, ret);
      MEMFREE_PTR(tempBuf);
      return (~errNone);
  }

  // ǂݍރt@CTCYɂ킹ė̈mۂB
  buffer = MemPtrNew(fileSize + MARGIN);
  if (buffer == NULL)
  { 
        // ̈mێs
        NNsh_DebugMessage(ALTID_ERROR, MSG_MEMORY_ALLOC_FAIL, " size:", fileSize + MARGIN);
        CloseFile_NNsh(&fileRefR);
        MEMFREE_PTR(tempBuf);
        return (~errNone);
  }
  MemSet(buffer, (fileSize + MARGIN), 0x00);

  // t@Co͒̕\
  Show_BusyForm(MSG_INPUT_XML_WAIT);

  // t@Cꊇœǂݏo
  ret = ReadFile_NNsh(&fileRefR, 0, fileSize, buffer, &temp);
  CloseFile_NNsh(&fileRefR);
  if (ret != errNone)
  {
      NNsh_InformMessage(ALTID_ERROR, MSG_NNSISET_READFAIL, "", ret);
      MEMFREE_PTR(buffer);
      MEMFREE_PTR(tempBuf);
      Hide_BusyForm(false);
      return (~errNone);
  }

  // vfTă[v
  ptr = NNsiItem;
  while (ptr->itemName[0] != '\0')
  {
      MemSet (tempBuf, len, 0x00);
      StrCopy(tempBuf, NNSISETFILE_ITEM_BEGIN);
      StrCat (tempBuf, ptr->itemName);
      area = StrStr(buffer, tempBuf);
      if (area != NULL)
      {
          // ACeI
          area = area + StrLen(tempBuf);
          start = StrStr(area, NNSISETFILE_VALTAG_BEGIN);
          if (start != NULL)
          {
              start = start + StrLen(NNSISETFILE_VALTAG_BEGIN);
              end   = StrStr(start, NNSISETFILE_VALTAG_END);
              if (end != NULL)
              {
                  // f[^t@Cobt@ЂςĂ
                  loc = tempBuf;
                  for (area  = start, loc = tempBuf; area != end; area++)
                  {
                      *loc = *area;
                      loc++;
                  }
                  *loc = '\0';

                  // f[^̊i[^ɂ킹ăf[^\̃oɃRs[ 
                  switch (ptr->itemType)
                  {
                      case NNSISETFILE_TYPE_CHAR:
                        while (*start != '\"')
                        {
                            start++;
                        }
                        start++;
                        loc = (Char *) ptr->value;
                        MemSet  (loc, ptr->length, 0x00);
                        StrNCopy(loc, start, (end - start));
                        end = loc + StrLen(loc);
                        while ((end > (Char *) ptr->value)&&(*end != '\"'))
                        {
                            end--;
                        }
                        *end = '\0';
                        break;

                      case NNSISETFILE_TYPE_UINT8:
                        while ((*start < '0')||(*start > '9'))
                        {
                            start++;
                        }
                        mod = StrAToI(start);
                        *((UInt8 *) ptr->value) = (UInt8) mod;
                        break;

                      case NNSISETFILE_TYPE_INT16:
                        while ((*start < '0')||(*start > '9'))
                        {
                            start++;
                        }
                        mod = StrAToI(start);
                        *((Int16 *) ptr->value) = (Int16) mod;
                        break;

                      case NNSISETFILE_TYPE_INT32:
                        while ((*start < '0')||(*start > '9'))
                        {
                            start++;
                        }
                        mod = StrAToI(start);
                        *((Int32 *) ptr->value) = (Int32) mod;
                        break;

                      case NNSISETFILE_TYPE_UINT32:
                        while ((*start < '0')||(*start > '9'))
                        {
                            start++;
                        }
                        mod = StrAToI(start);
                        *((UInt32 *) ptr->value) = (UInt32) mod;
                        break;

                      case NNSISETFILE_TYPE_UINT16:
                      default:
                        while ((*start < '0')||(*start > '9'))
                        {
                            start++;
                        }
                        mod = StrAToI(start);
                        *((UInt16 *) ptr->value) = (UInt16) mod;
                        break;
                  }
              }  
          }
      }
      ptr++;
  }
  Hide_BusyForm(false);

  return (ret);
}
#endif // #ifdef USE_XML_OUTPUT
