/*============================================================================*
 *  FILE: 
 *     subjmgr.c
 *
 *  Description: 
 *     Xꗗ擾Tu
 *===========================================================================*/
#define  SUBJMGR_C
#include "local.h"

/*=========================================================================*/
/*   Function :   DeleteSubjectList                                        */
/*                                                  YXꗗ폜 */
/*=========================================================================*/
Err DeleteSubjectList(Char *boardNick, UInt16 delState, UInt16 *thrCnt)
{
    UInt16              cnt, loop;
    DmOpenRef           dbRef;
    NNshSubjectDatabase tmpDb;
    Char                fileName[MAXLENGTH_FILENAME];

    // DBI[v
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    if (dbRef == 0)
    {
        // G[
        return (~errNone);
    }
    GetDBCount_NNsh(dbRef, &cnt);

    Show_BusyForm(MSG_DELETE_LIST_WAIT);
    *thrCnt  = 0;

    // GetRecord_NNsh ̕Ԃlp鎖ō
    // 炢Ȃ͂AÔ߁AP񏉊
    MemSet(&tmpDb, sizeof(NNshSubjectDatabase), 0x00);
    
    for (loop = cnt; loop > 0; loop--)
    {
        if (GetRecord_NNsh(dbRef, (loop - 1), sizeof(NNshSubjectDatabase), &tmpDb) == errNone)
        {
            // w肳ꂽBoardID烌R[h폜
            if ((delState == NNSH_SUBJSTATUS_UNKNOWN)||
                (StrCompare(tmpDb.boardNick, boardNick) == 0))
            {
                //  X擾\񂳂ĂȂāAǃf[^ or 
                // S폜w폜
                if ((delState == NNSH_SUBJSTATUS_DELETE)||
                    (((tmpDb.msgAttribute & NNSH_MSGATTR_GETRESERVE) == 0)&&
                     (tmpDb.state == NNSH_SUBJSTATUS_NOT_YET)))
                {
                    // f[^t@C΁A킹č폜
                    if (tmpDb.state != NNSH_SUBJSTATUS_NOT_YET)
                    {
                        MemSet (fileName, sizeof(fileName), 0x00);
                        StrCopy(fileName, tmpDb.boardNick);
                        StrCat (fileName, tmpDb.threadFileName);
                        (void) DeleteFile_NNsh(fileName, NNSH_VFS_ENABLE);
                    }
                    (void) DeleteRecordIDX_NNsh(dbRef, (loop - 1));
                }
                else
                {
                    // 폜ȂƂ́AJEgAbv
                    (*thrCnt)++;
                }
            }
        }
    }
    Hide_BusyForm(true);
    CloseDatabase_NNsh(dbRef);

    // XꗗDBXVƂɂ
    NNshGlobal->updateDatabaseInfo = 
                ((NNshGlobal->updateDatabaseInfo) | (NNSH_DB_UPDATE_SUBJECT));
    return (errNone);
}

/*==========================================================================*/
/*  SortSubjectList : SUBJECTf[^x[X\[g㏑               */
/*                                                                          */
/*==========================================================================*/
void SortSubjectList(void)
{
    DmOpenRef            dbRef;

    // XǗDBI[vA\[g
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    QsortRecord_NNsh(dbRef, NNSH_KEYTYPE_SUBJECT, 0);
    CloseDatabase_NNsh(dbRef);

    // XꗗDBXVƂɂ
    NNshGlobal->updateDatabaseInfo = 
                ((NNshGlobal->updateDatabaseInfo) | (NNSH_DB_UPDATE_SUBJECT));

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :  entryNotExistSubject                                      */
/*                                        X^Cg݂ȂΓo^ */
/*-------------------------------------------------------------------------*/
static void entryNotExistSubject(DmOpenRef dbRef, NNshSubjectDatabase *subjDb)
{
    UInt16               loop, nofRecords;
    MemHandle            recH;
    NNshSubjectDatabase *chkDb;

    // o^ς݃R[hl
    GetDBCount_NNsh(dbRef, &nofRecords);

    // o^ς݂S()`FbN
    for (loop = 0; loop < nofRecords; loop++)
    {
        (void) GetRecordReadOnly_NNsh(dbRef, loop, &recH, (void **) &chkDb);

        // o^ς݂ǂ`FbN 
        if (StrCompare(chkDb->threadFileName, subjDb->threadFileName) == 0)
        {
            if (StrCompare(chkDb->boardNick, subjDb->boardNick) == 0)
            {
                // {[ht@Cƃ{[hjbNl[Ałɓo^ς
                ReleaseRecordReadOnly_NNsh(dbRef, recH);
                return;
            }
        }
        ReleaseRecordReadOnly_NNsh(dbRef, recH);
    }

    // Xo^ĂȂAR[hVKo^
    (void) EntryRecord_NNsh(dbRef, sizeof(NNshSubjectDatabase), subjDb);
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   parse_SubjectList                                        */
/*                                                    XꗗDB荞 */
/*-------------------------------------------------------------------------*/
static Err parse_SubjectList(Char *buffer, UInt32 readSize, UInt16 bbsType,
                             Char *boardNick, UInt16 *cnt)
{
    UInt16              size, len, sepaLen;
    Char               *ptr, *dataEnd, *dataSepa, *ppp, *src, *dst;
    Char               *fieldSeparator, *titleBuf;
    DmOpenRef           dbRef, threadDbRef;
    NNshSubjectDatabase tmpDb;
    MemHandle           threadListH = NULL;
    Char                *threadListP;
    Boolean             haveThreadList = false;
    UInt16              threadNum, checkDuplicateMethod, mesNum;
    
    titleBuf = MemPtrNew(BUFSIZE + MARGIN);
    if (titleBuf == NULL)
    {
        // ^Cgobt@i[̈mێs
        return (~errNone);
    }

    // BBS^CvɂāAtB[hZp[^I
    switch (bbsType)
    {
      case NNSH_BBSTYPE_MACHIBBS:
      case NNSH_BBSTYPE_SHITARABAJBBS_OLD:
      case NNSH_BBSTYPE_SHITARABAJBBS_RAW:
        // ܂BBS ܂ @JBBS
        fieldSeparator = NNSH_FIELD_SEPARATOR_MACHI;
        break;

      case NNSH_BBSTYPE_SHITARABA:
      case NNSH_BBSTYPE_2ch:
      case NNSH_BBSTYPE_OTHERBBS:
      default:
        // Q˂ ܂ 
        fieldSeparator = NNSH_FIELD_SEPARATOR;
        break;
    }
    sepaLen = StrLen(fieldSeparator);

    // X̂̉߃C(HTTPwb_ǂݔ΂)
    ptr = StrStr(buffer, NNSH_HTTP_HEADER_ENDTOKEN);
    if (ptr == NULL)
    {
        // f[^ُ
        NNsh_InformMessage(ALTID_ERROR, "ERR>Wrong data(not found separator,",
                           NNSH_HTTP_HEADER_ENDTOKEN, 0);
        MemPtrFree(titleBuf);
        return (~errNone);
    }
    ptr = ptr + 4;   // 4́A"\x0d\x0a\x0d\0a"

    // uXgo^v̕\s
    Show_BusyForm(MSG_THREADLIST_CREATE);

    // DBI[v
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    if (dbRef == 0)
    {
        // G[
        MemPtrFree(titleBuf);
        return (~errNone);
    }

    checkDuplicateMethod = NNSH_DUP_NOCHECK;
    if (NNshParam->checkDuplicateThread != 0)
    {
        // X̏d`FbN̏ꍇ...
        // X̃Xg擾
        haveThreadList = 
                GetExistRecordList(dbRef, boardNick, &threadListH, &threadNum);
        if (haveThreadList == false)
        {
            // o^ς݂cãR[hmF
            if (threadNum != 0)
            {
                //  sAxȂĂd`FbN邩ǂ
                // mF߂郁bZ[W\
                if (NNsh_ErrorMessage(ALTID_CONFIRM, MSG_SELECT_DUPLICATE_METHOD, "", 0) == 0)
                {
                    // xȂĂAd`FbN(ᑬd`FbN
                    checkDuplicateMethod = NNSH_DUP_CHECK_SLOW;
                }
                else
                {
                    // xȂ邽߁Ad`FbNȂ
                    checkDuplicateMethod = NNSH_DUP_NOCHECK;
                }
            }
            else
            {
                // DBɂPf[^Ȃ߁Ad`FbNȂ
                checkDuplicateMethod = NNSH_DUP_NOCHECK;
            }
        }
        else 
        {
            // d`FbN̎{
            checkDuplicateMethod = NNSH_DUP_CHECK_HIGH;
        }
    }

    // X^Co^ĂAo^ƓɐVmFH
    if (NNshParam->listAndUpdate != 0)
    {
        // XԎw擾pDBI[vĂ
        OpenDatabase_NNsh(DBNAME_GETRESERVE,DBVERSION_GETRESERVE, &threadDbRef);
    }
    else
    {
        threadDbRef = 0;
    }

    *cnt = 0;
    while (ptr < buffer + readSize)
    {
        //  R[hf[^̖iNNSH_RECORD_SEPARATOR == "\x0a"j
        dataEnd = ptr;
        while ((*dataEnd != '\x0a')&&(*dataEnd != '\0'))
        {
            dataEnd++;
        }
        if (*dataEnd == '\0')
        {
            // f[^IA[v𔲂
            dataEnd = NULL;
            break;
        }

        // tB[h̃Zp[^
        dataSepa = StrStr(ptr, fieldSeparator);
        if ((dataSepa == NULL)||(dataSepa > dataEnd))
        {
            // f[^ُA[v𔲂
            break;
        }

        // Xi[𒊏o
        MemSet  (&tmpDb, sizeof(tmpDb), 0x00);

        // BBS^CvPʂŃXAX^CAt@Ci[
        switch (bbsType)
        {
          case NNSH_BBSTYPE_SHITARABA:
            // X(΂ƃX̊i[@ႤA)
            ppp = StrStr(dataSepa, fieldSeparator);
            ppp = ppp + StrLen(fieldSeparator);
            ppp = StrStr(ppp, fieldSeparator);
            if (ppp != NULL)
            {
                *ppp = '\0';
                ppp = ppp + StrLen(fieldSeparator);
            }
            while ((dataEnd > ppp)&&(*ppp < '0')&&(*ppp > '9'))
            {
                ppp++;
            }
            tmpDb.maxLoc = (UInt16) StrAToI(ppp);

            // Xt@C
            StrNCopy(tmpDb.threadFileName, ptr, (dataSepa - ptr));
            size = ((dataEnd - (dataSepa + 2)) > MAX_THREADNAME) ? 
                             (MAX_THREADNAME - 1) : (dataEnd - (dataSepa + 2));

            // ΂subject.txtɂ͊gqĂȂ̂ŁAŕt
            StrCat(tmpDb.threadFileName, ".dat");

            // X^CgiEUCR[hSHIFT JISR[hɕϊj
            MemSet  (titleBuf, (BUFSIZE + MARGIN), 0x00);
            StrNCopy(titleBuf, (dataSepa + sepaLen), size);
            src = titleBuf;
            dst = tmpDb.threadTitle;
            while (*src != '\0')
            {
                if (ConvertEUCtoSJ(dst, src, &len) == true)
                {
                    src = src + 2;
                    dst = dst + len;
                }
                else
                {
                    *dst = *src;
                    dst++;
                    src++;
                }
            }
            break;

          case NNSH_BBSTYPE_SHITARABAJBBS_OLD:
          case NNSH_BBSTYPE_SHITARABAJBBS_RAW:
            /** Xi[폜(łxȂȁ[) **/
            ppp = dataEnd;
            while (*ppp != ')')
            {
                ppp--;
            }
            *ppp = '\0';
            while (*ppp != '(')
            {
                ppp--;
            }
            *ppp = '\0';
            tmpDb.maxLoc = (UInt16) StrAToI(ppp + 1);

            // t@C
            StrNCopy(tmpDb.threadFileName, ptr, (dataSepa - ptr));
            size = ((dataEnd - (dataSepa + 2)) > MAX_THREADNAME) ? 
                             (MAX_THREADNAME - 1) : (dataEnd - (dataSepa + 2));

            // X^Cg(EUCR[hꍇ́ASHIFT JISɕϊ)
            MemSet(titleBuf, (BUFSIZE + MARGIN), 0x00);
            StrNCopy(titleBuf, (dataSepa + sepaLen), size);
            src = titleBuf;
            dst = tmpDb.threadTitle;
            while (*src != '\0')
            {
                if (ConvertEUCtoSJ(dst, src, &len) == true)
                {
                    src = src + 2;
                    dst = dst + len;
                }
                else
                {
                    *dst = *src;
                    dst++;
                    src++;
                }
            }
            break;

          case NNSH_BBSTYPE_MACHIBBS:
          case NNSH_BBSTYPE_2ch:
          case NNSH_BBSTYPE_OTHERBBS:
          default:
            /** Xi[폜(łxȂȁ[) **/
            ppp = dataEnd;
            while (*ppp != ')')
            {
                ppp--;
            }
            *ppp = '\0';
            while (*ppp != '(')
            {
                ppp--;
            }
            *ppp = '\0';
            tmpDb.maxLoc = (UInt16) StrAToI(ppp + 1);

            // t@C
            StrNCopy(tmpDb.threadFileName, ptr, (dataSepa - ptr));
            size = ((dataEnd - (dataSepa + 2)) > MAX_THREADNAME) ? 
                             (MAX_THREADNAME - 1) : (dataEnd - (dataSepa + 2));

            // X^CgiSHIFT JISR[hꍇ́Â܂܊i[j
            StrNCopy(tmpDb.threadTitle, (dataSepa + sepaLen), size);
            break;
        }

        // X^CgꗗBBS TYPEi[B
        tmpDb.bbsType = (UInt8) bbsType; 
        StrCopy (tmpDb.boardNick, boardNick);

        // d`FbN̎{
        switch(checkDuplicateMethod)
        {
          case NNSH_DUP_CHECK_SLOW:
            // d`FbN{(ᑬ)AX^C݂ȂΓo^
            (void) entryNotExistSubject(dbRef, &tmpDb);
            break;

          case NNSH_DUP_CHECK_HIGH:
            // d`FbN(){
            threadListP = MemHandleLock(threadListH);
            ppp = StrStr(threadListP, tmpDb.threadFileName);
            if(ppp == NULL)
            {
                // X^Co^AVKo^
                (void)
                  EntryRecord_NNsh(dbRef, sizeof(NNshSubjectDatabase), &tmpDb);
            }
            else
            {
                // X^Co^ĂAo^ƓɐVmFH
                if (NNshParam->listAndUpdate != 0)
                {
                    // o^ƍ̃X`FbN
                    mesNum = StrAToI(ppp + StrLen(tmpDb.threadFileName));
                    if ((mesNum != 0)&&(mesNum != tmpDb.maxLoc))
                    {
                        // VmF{XI(XԒo)
                        MemSet (titleBuf, (BUFSIZE + MARGIN), 0x00);
                        StrCopy(titleBuf, tmpDb.boardNick);
                        StrCat (titleBuf, tmpDb.threadFileName);
                        ppp = titleBuf + StrLen(titleBuf);
                        while ((ppp > titleBuf)&&(*ppp != '.'))
                        {
                            ppp--;
                        }
                        if (ppp != titleBuf)
                        {
                            *ppp = '\0';
                        }             
                        if (threadDbRef != 0)
                        {
                            // XԎw擾\caɃGg
                            (void) EntryRecord_NNsh(threadDbRef, BUFSIZE, titleBuf);
                        }
                    }                    
                }
            }
            MemHandleUnlock(threadListH);
            break;

          case NNSH_DUP_NOCHECK:
          default:
            // d`FbN͍s킸AX^C(VK)o^
            (void)EntryRecord_NNsh(dbRef, sizeof(NNshSubjectDatabase), &tmpDb);
            break;
        }

        // f[^̐擪ֈړ
        ptr = dataEnd + 1;
        (*cnt)++;
    }
    // dmFpĂꍇÄJB
    if (haveThreadList != false)
    {
        MemHandleFree(threadListH);
    }
    Hide_BusyForm(true);
    CloseDatabase_NNsh(dbRef);

    // XꗗDBXVƂɂ
    NNshGlobal->updateDatabaseInfo = 
                ((NNshGlobal->updateDatabaseInfo) | (NNSH_DB_UPDATE_SUBJECT));

    // XԎw擾caI[vĂƂɂ̓N[Y
    if (threadDbRef != 0)
    {
        CloseDatabase_NNsh(threadDbRef);
    }

    MemPtrFree(titleBuf);
    return (errNone);
}

/*=========================================================================*/
/*   Function :   convertListIndexToMsgIndex                               */
/*                                   XgԍXindexԍɕϊ */
/*=========================================================================*/
UInt16 convertListIndexToMsgIndex(UInt16 listIdx)
{
    // XgԍDB̃R[hԍɕϊĉ
    return (NNshGlobal->msgListIndex[listIdx]);
}

/*=========================================================================*/
/*   Function :   NNsh_GetSubjectList                                      */
/*                                                         Xꗗ̎擾  */
/*=========================================================================*/
Err NNsh_GetSubjectList(UInt16 index)
{
    Err                 ret;
    UInt16              cnt, cnt2;
    UInt32              fileSize, readSize;
    Char                getURL[MAX_URL + MAX_URL], *buffer;
    NNshFileRef         fileRef;
    NNshBoardDatabase   bbsData;

    // BBS-DBBBS擾
    ret = Get_BBS_Info(index, &bbsData);
    if (ret != errNone)
    {
        // G[
        NNsh_DebugMessage(ALTID_ERROR,  "Get_BBS_Info() ", "", ret);
        return (ret);
    }

    // f[^擾̐ݒ
    MemSet (getURL, sizeof(getURL), 0x00);
    StrCopy(getURL, bbsData.boardURL);
    switch (bbsData.bbsType)
    {
      case NNSH_BBSTYPE_SHITARABAJBBS_OLD:
      case NNSH_BBSTYPE_SHITARABAJBBS_RAW:
      case NNSH_BBSTYPE_MACHIBBS:
        // @JBBS/܂BBŜƂ́ABoardNickt
        StrCat(getURL, bbsData.boardNick);
        break;

      case NNSH_BBSTYPE_SHITARABA:
        // ΂̂Ƃ́Abbs/BoardNickt
        StrCat(getURL, "bbs/");
        StrCat(getURL, bbsData.boardNick);
        break;

      case NNSH_BBSTYPE_2ch:
      case NNSH_BBSTYPE_OTHERBBS:
      default:
        // Q˂̎́AȂɂȂ
        break;
    }
    StrCat (getURL, FILE_THREADLIST);

    // fobO\
    NNsh_DebugMessage(ALTID_INFO, bbsData.boardNick, getURL, 0);

    // zXgXꗗf[^擾
    if (NNshParam->getAllThread == HTTP_GETSUBJECT_PART)
    {
        // ꕔ擾
        ret = NNshHttp_comm(HTTP_SENDTYPE_GET, getURL, NULL, NULL,
                            HTTP_GETSUBJECT_START, HTTP_GETSUBJECT_LEN, NULL);
    }
    else
    {
        // S擾
        ret = NNshHttp_comm(HTTP_SENDTYPE_GET, getURL, NULL, NULL,
                            HTTP_RANGE_OMIT, HTTP_RANGE_OMIT, NULL);
    }
    if (ret != errNone)
    {
        // (^CAEgȊO)ʐMG[
        if (ret != netErrTimeout)
        {
            NNsh_InformMessage(ALTID_ERROR,MSG_ERROR_HTTP_COMM, "[SUBJ]", ret);
            return (ret);
        }

        // ʐM^CAEg(MĂƂ܂ŁAIɉ߂s)
        NNsh_InformMessage(ALTID_ERROR, MSG_OCCUR_TIMEOUT, "[SUBJ]", ret);
    }

    // f[^x[XA(擾)Xf[^𖢓ǂ̂̂̂ݏ
    DeleteSubjectList(bbsData.boardNick, NNSH_SUBJSTATUS_NOT_YET, &cnt);

    ////////// Xꗗ̉ /////////

    // Mf[^i[pobt@̊l
    buffer = (Char *) MemPtrNew(NNshParam->bufferSize + MARGIN);
    if (buffer == NULL)
    {
        NNsh_InformMessage(ALTID_ERROR,
                           "MemPtrNew()", " size:", NNshParam->bufferSize);
        return (~errNone);
    }
    MemSet(buffer, (NNshParam->bufferSize + MARGIN), 0x00);

    OpenFile_NNsh(FILE_RECVMSG, 
                  (NNSH_FILEMODE_READONLY|NNSH_FILEMODE_TEMPFILE),
                  &fileRef);
    GetFileSize_NNsh(&fileRef, &fileSize);
    if (fileSize > NNshParam->bufferSize)
    {
        // Xꗗ傫Ƃ(obt@TCY)ۂ߂
        fileSize = NNshParam->bufferSize;
    }

    // Xꗗ̓ǂ݂
    ret = ReadFile_NNsh(&fileRef, 0, fileSize, buffer, &readSize);
    CloseFile_NNsh(&fileRef);
    if ((ret != errNone)&&(ret != vfsErrFileEOF)&&(ret != fileErrEOF))
    {        
        // t@Cǂ݂݃G[
        NNsh_InformMessage(ALTID_ERROR, "ReadFile_NNsh :", FILE_RECVMSG, ret);
    }
    else
    {
        // f[^x[X̍XV(X̓o^)
        ret = parse_SubjectList(buffer, readSize, 
                                bbsData.bbsType, bbsData.boardNick, &cnt2);
        cnt = cnt + cnt2;
    }
    MemPtrFree(buffer);
    return (ret);   
}

/*=========================================================================*/
/*   Function :   Check_same_thread                                        */
/*                                      XDBɊ܂܂Ă邩ׂ */
/*=========================================================================*/
Err Check_same_thread(UInt16 selMES, NNshSubjectDatabase *data, 
                      NNshSubjectDatabase *matchedData, UInt16 *idx)
{
    Err                  err = ~errNone;
    Int16                step;
    UInt16               lp, index, count;
    DmOpenRef            dbRef;
    NNshSubjectDatabase *subj;

    // 擾f[^x[X̏i[̈m
    subj = MemPtrNew(sizeof(NNshSubjectDatabase));
    if (subj == NULL)
    {
        NNsh_DebugMessage(ALTID_INFO, "MemPtrNew()", "", 
                          sizeof(NNshSubjectDatabase));
        return (~errNone);
    }

    // udX̃`FbN...v\
    Show_BusyForm(MSG_CHECK_SAME_THREAD);

    // XǗDBI[v
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    if (dbRef == 0)
    {
        // DBI[vs(肦Ȃ͂...)
        goto FUNC_END;
    }
    GetDBCount_NNsh(dbRef, &count);

    // 擾\̔ԍ擾
    if (selMES != NNSH_NOTENTRY_THREAD)
    {
        index = convertListIndexToMsgIndex(selMES);
        step  = 1;
        lp    = index + 1;
    }
    else
    {
        index = count;
        step  = -1;
        lp    = count - 1;
    }
    *idx  = index;

    // dXǂ
    for (;((lp >= 0)&&(lp < count)); lp = lp + step)
    {
        // Xf[^擾
        if ((GetRecord_NNsh(dbRef, lp,
                            sizeof(NNshSubjectDatabase), subj)) != errNone)
        {
            // G[
            err = ~errNone;
            break;
        }
        if ((StrCompare(subj->boardNick,      data->boardNick)      == 0)&&
            (StrCompare(subj->threadFileName, data->threadFileName) == 0))
        {
            // ̃X݂I
            err  = errNone;
            if (matchedData != NULL)
            {
                // Yf[^Rs[ĉ
                MemSet(matchedData, sizeof(NNshSubjectDatabase), 0x00);
                StrCopy(matchedData->threadFileName, subj->threadFileName);
                StrCopy(matchedData->threadTitle,    subj->threadTitle);
                StrCopy(matchedData->boardNick,      subj->boardNick);
                matchedData->dirIndex     = subj->dirIndex;
                matchedData->reserved     = subj->reserved;
                matchedData->state        = subj->state;
                matchedData->msgAttribute = subj->msgAttribute;
                matchedData->msgState     = subj->msgState;
                matchedData->bbsType      = subj->bbsType;
                matchedData->maxLoc       = subj->maxLoc;
                matchedData->currentLoc   = subj->currentLoc;
                matchedData->fileSize     = subj->fileSize;
            }
            *idx = lp;
            break;
        }
    }
    CloseDatabase_NNsh(dbRef);

    // udX̃`FbN...v\
    Hide_BusyForm(false);

FUNC_END:
    MemPtrFree(subj);
    return (err);
}

/*=========================================================================*/
/*   Function :   GetSubjectIndex                                          */
/*                                        Xhc̃CfbNXԍ擾 */
/*=========================================================================*/
Err GetSubjectIndex(Char *boardNick, Char *threadFileName, UInt16 *index)
{
    Err                 err = ~errNone;
    NNshSubjectDatabase subj;
    DmOpenRef           dbRef;
    Int16               lp;
    UInt16              count;

    // XǗDBI[v
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    if (dbRef == 0)
    {
        // DBI[vs(肦Ȃ͂...)
        return (~errNone - 10);
    }
    GetDBCount_NNsh(dbRef, &count);

    // X݂邩mF
    for (lp = (count - 1); lp >= 0; lp--)
    {
        // Xf[^擾
        if ((GetRecord_NNsh(dbRef, lp,
                            sizeof(NNshSubjectDatabase), &subj)) != errNone)
        {
            // G[
            err = ~errNone;
            break;
        }
        if ((StrCompare(subj.boardNick,      boardNick)      == 0)&&
            (StrCompare(subj.threadFileName, threadFileName) == 0))
        {
            // X݂I
            err    = errNone;
            *index = lp;
            break;
        }
    }
    CloseDatabase_NNsh(dbRef);
    return (err);
}


/*=========================================================================*/
/*   Function : CheckIfCustomTabIsValid                                    */
/*                                              [U^uL`FbN */
/*=========================================================================*/
Boolean CheckIfCustomTabIsValid(Char *bbsName, NNshSubjectDatabase *subjP,
                                NNshCustomTab *customTab)
{
    Boolean subRet, ret;
    UInt16  condition, thLevel, favorLvl, status;
    UInt32  currentTime, thrTime;

    ret = true;

    if ((customTab->condition & NNSH_CONDITION_NOTREADONLY) != 0)
    {
        // QƐpO͏Oꍇ
#ifdef USE_STRSTR
        if (!(StrCompare(subjP->boardNick, OFFLINE_THREAD_NICK)))
#else
        if ((subjP->boardNick[0]  == '!')&&
            (subjP->boardNick[1]  == 'G'))
#endif
        {
            // QƐpOꍇ(珜O)
            return (false);
        }
    }

    // SĈv or ǂꂩv ̏擾
    condition = (customTab->condition & NNSH_CONDITION_ALL);

    ////////////////////////////////////////////////////////////
    // ݒ̊mF
    ////////////////////////////////////////////////////////////
    if ((customTab->boardCondition != 0)&&(bbsName != NULL))
    {
        status = customTab->boardCondition - 1;
        switch (status)
        {
          case NNSH_BOARD_ELSE:
            // vȂ(ȊO)
            if ((StrCompare(bbsName, subjP->boardNick)) == 0)
            {
                // vAO
                ret = false;
                goto CHECK_LEVEL;
            }
            break;

          case NNSH_BOARD_MATCH:
          default:
            // v()
            if ((StrCompare(bbsName, subjP->boardNick)) != 0)
            {
                // vȂAO
                ret = false;
                goto CHECK_LEVEL;
            }
            break;
        }
        if (condition == NNSH_CONDITION_OR)
        {
            return (true);
        }
    }

CHECK_LEVEL:
    ////////////////////////////////////////////////////////////
    // Xx̊mF
    ////////////////////////////////////////////////////////////
    status = 
      (customTab->threadLevel & NNSH_THREADCOND_MASK) >> NNSH_THREADCOND_SHIFT;
    if (status != 0)
    {
        favorLvl  = (subjP->msgAttribute & NNSH_MSGATTR_FAVOR);
        thLevel   = customTab->threadLevel & NNSH_THREADLEVEL_MASK;

        status--;
        switch (status)
        {
          case NNSH_THREADLEVEL_LOWER:
            // ȉ
            if (favorLvl > thLevel)
            {
                // x傫ΏO
                ret = false;
                goto CHECK_LOGLOC;
            }
            break;
          case NNSH_THREADLEVEL_ELSE:
            // ȊO
            if (favorLvl == thLevel)
            {
                // xȂΏO
                ret = false;
                goto CHECK_LOGLOC;
            }
            break;
          case NNSH_THREADLEVEL_MATCH:
            // v
            if (favorLvl != thLevel)
            {
                // x珜O
                ret = false;
                goto CHECK_LOGLOC;
            }
            break;
          case NNSH_THREADLEVEL_UPPER:
          default:
            // ȏ
            if (favorLvl < thLevel)
            {
                // xΏO
                ret = false;
                goto CHECK_LOGLOC;
            }
            break;
        }
        if (condition == NNSH_CONDITION_OR)
        {
            // "ǂꂩv" ̎
            return (true);
        }
    }

CHECK_LOGLOC:
    ////////////////////////////////////////////////////////////
    // OʒůmF
    ////////////////////////////////////////////////////////////
    status = (customTab->condition & NNSH_CONDITION_LOGLOC_ALL);
    if (status != 0)
    {
        if ((status == NNSH_CONDITION_LOGLOC_PALM)&&
            (subjP->msgState != FILEMGR_STATE_OPENED_STREAM))
        {
            // Ot@CPalmfoCXɑ݂ȂƂ
            ret = false;
            goto CHECK_GETERR;
        }
        else if ((status == NNSH_CONDITION_LOGLOC_VFS)&&
                 (subjP->msgState != FILEMGR_STATE_OPENED_VFS))
        {
            // Ot@Cuerɑ݂ȂƂ
            ret = false;
            goto CHECK_GETERR;
        }
        if (condition == NNSH_CONDITION_OR)
        {
            // "ǂꂩv" ̎
            return (true);
        }
    }

CHECK_GETERR:
    ////////////////////////////////////////////////////////////
    // 擾G[̊mF
    ////////////////////////////////////////////////////////////
    status = (customTab->condition & NNSH_CONDITION_GETERR_ALL);
    if (status != 0)
    {
        if ((status == NNSH_CONDITION_GETERR_NONE)&&
            ((subjP->msgAttribute & NNSH_MSGATTR_ERROR) != 0))
        {
            // G[Ԃ̂Ƃ
            ret = false;
            goto CHECK_GETRESERVE;
        }
        else if ((status == NNSH_CONDITION_GETERR_ERROR)&&
                 ((subjP->msgAttribute & NNSH_MSGATTR_ERROR) == 0))
        {
            // G[ԂłȂƂ
            ret = false;
            goto CHECK_GETRESERVE;
        }
        if (condition == NNSH_CONDITION_OR)
        {
            // "ǂꂩv" ̎
            return (true);
        }
    }

CHECK_GETRESERVE:
    ////////////////////////////////////////////////////////////
    // 擾ۗԂ̊mF
    ////////////////////////////////////////////////////////////
    status = (customTab->condition & NNSH_CONDITION_GETRSV_ALL);
    if (status != 0)
    {
        if ((status == NNSH_CONDITION_GETRSV_RSV)&&
            (subjP->msgAttribute & NNSH_MSGATTR_GETRESERVE) != NNSH_MSGATTR_GETRESERVE)
        {
            // 擾ۗ
            ret = false;
            goto CHECK_STATUS;
        }
        else if ((status == NNSH_CONDITION_GETRSV_NONE)&&
                 (subjP->msgAttribute & NNSH_MSGATTR_GETRESERVE) != 0)
        {
            // 擾ۗ
            ret = false;
            goto CHECK_STATUS;
        }
        if (condition == NNSH_CONDITION_OR)
        {
            // "ǂꂩv" ̎
            return (true);
        }
    }

CHECK_STATUS:
    ////////////////////////////////////////////////////////////
    // XԂ̊mF
    ////////////////////////////////////////////////////////////
    if (customTab->threadStatus != 0)
    {
        subRet = true;

        // VK擾X
        if ((((customTab->threadStatus >> NNSH_SUBJSTATUS_NEW) & 1)!= 0)&&
            (subjP->state == NNSH_SUBJSTATUS_NEW))
        {
            goto CHECK_THREADSTATUS;
        }

        // XVX
        if ((((customTab->threadStatus >> NNSH_SUBJSTATUS_UPDATE) & 1)!= 0)&&
            (subjP->state == NNSH_SUBJSTATUS_UPDATE))
        {
            goto CHECK_THREADSTATUS;
        }

        // ǂX
        if ((((customTab->threadStatus >> NNSH_SUBJSTATUS_REMAIN) & 1)!= 0)&&
            (subjP->state == NNSH_SUBJSTATUS_REMAIN))
        {
            goto CHECK_THREADSTATUS;
        }

        // ǃX
        if ((((customTab->threadStatus >> NNSH_SUBJSTATUS_ALREADY) & 1)!= 0)&&
            (subjP->state == NNSH_SUBJSTATUS_ALREADY))
        {
            goto CHECK_THREADSTATUS;
        }

        // ő𒴂X
        if (((customTab->threadStatus >> NNSH_SUBJSTATUS_OVER) & 1)!= 0)
        {
            if ((subjP->maxLoc > NNSH_MESSAGE_LIMIT)&&
                (subjP->state == NNSH_SUBJSTATUS_ALREADY))
            {
                goto CHECK_THREADSTATUS;
            }
        }

        // ܂擾ĂȂX
        if ((((customTab->threadStatus >> NNSH_SUBJSTATUS_NOT_YET) & 1)!= 0)&&
            (subjP->state == NNSH_SUBJSTATUS_NOT_YET))
        {
            goto CHECK_THREADSTATUS;
        }

        // 擾G[H
        if ((((customTab->threadStatus >> NNSH_SUBJSTATUS_GETERROR) & 1)!= 0)&&
            ((subjP->msgAttribute & NNSH_MSGATTR_ERROR) != 0))
        {
            goto CHECK_THREADSTATUS;
        }

        // ̑X
        if ((((customTab->threadStatus >> NNSH_SUBJSTATUS_UNKNOWN) & 1)!= 0)&&
            (subjP->state == NNSH_SUBJSTATUS_UNKNOWN))
        {
            goto CHECK_THREADSTATUS;
        }

        subRet = false;

CHECK_THREADSTATUS:
        if (subRet == true)
        {
            if (condition == NNSH_CONDITION_OR)
            {
                // "ǂꂩv" ̎
                return (true);
            }
        }
        else
        {
            ret = false;
        }
    }

    // XĂȓ̃`FbN
    if (customTab->threadCreate != 0)
    {
        // `FbN̎擾
        currentTime = TimGetSeconds()
                             - TIME_CONVERT_1904_1970
                             - StrAToI(subjP->threadFileName);
        thrTime = customTab->threadCreate;
        thrTime = thrTime * 60 * 60 * 24;
        if (currentTime < thrTime)
        {
                // nȓɗXƔF
            // NNsh_DebugMessage(ALTID_INFO, "Time:", "", currentTime);
            if (condition == NNSH_CONDITION_OR)
            {
                // "ǂꂩv" ̎
                return (true);
            }
        }
        else
        {
            ret = false;
        }
    }

    ////////////////////////////////////////////////////////////
    // ̃`FbN
    ////////////////////////////////////////////////////////////
    if ((customTab->stringSet & NNSH_STRING_SELECTION) != 0)
    {
        status = customTab->stringSet & NNSH_STRING_SETMASK;
        subRet = true;

        // ̃`FbN
        if (customTab->string1[0] != '\0')
        {
            if (StrStr(subjP->threadTitle, customTab->string1) != NULL)
            {
                if (status == NNSH_CONDITION_OR)
                {
                    // "ǂꂩv" ̎
                    goto CHECK_STRINGSET;
                }
            }
            else
            {
                    subRet = false;
            }
        }

        // ̃`FbN
        if (customTab->string2[0] != '\0')
        {
            if (StrStr(subjP->threadTitle, customTab->string2) != NULL)
            {
                if (status == NNSH_CONDITION_OR)
                {
                    // "ǂꂩv" ̎
                    subRet = true;
                    goto CHECK_STRINGSET;
                }
            }
            else
            {
                    subRet = false;
            }
        }

        // ̃`FbN
        if (customTab->string3[0] != '\0')
        {
            if (StrStr(subjP->threadTitle, customTab->string3) != NULL)
            {
                if (status == NNSH_CONDITION_OR)
                {
                    // "ǂꂩv" ̎
                    subRet = true;
                    goto CHECK_STRINGSET;
                }
            }
            else
            {
                subRet = false;
            }
        }
        
CHECK_STRINGSET:
        if (subRet == true)
        {
            if (condition == NNSH_CONDITION_OR)
            {
                // "ǂꂩv" ̎
                return (true);
            }
        }
        else
        {
            ret = false;
        }
    }
    return (ret);
}
