/*============================================================================*
 *  FILE: 
 *     sslv2.c
 *
 *  Description: 
 *     SSL v2ʐMp
 *
 *===========================================================================*/
#define SSLV2_C
#include "local.h"

#ifdef USE_SSL
#ifdef USE_SSL_V2

/*=========================================================================*/
/*   Function : NNshSSLv2_Open                                             */
/*                                                          NNshSSL v2 */
/*=========================================================================*/
Err NNshSSLv2_Open(NNshSSLv2Ref **sslRef)
{
    NNsh_DebugMessage(ALTID_INFO, "NNshSSLv2_Open()", " ", 0);

    *sslRef = MemPtrNew(sizeof(NNshSSLv2Ref) + MARGIN);
    if (*sslRef == NULL)    
    {
        // ̈mێsAAAG[
        NNsh_DebugMessage(ALTID_ERROR, "NNshSSLv2_Open()",
                          " size:", (sizeof(NNshSSLv2Ref) + MARGIN));
        return (~errNone);
    }
    MemSet(*sslRef, (sizeof(NNshSSLv2Ref) + MARGIN), 0x00);

    // V[PXԍ(...Ȃ񂩈ႤA킹...)
    (*sslRef)->seqNum = 1;

    // obt@̊mۂƏ
    (*sslRef)->buffer = MemPtrNew(NNSHSSL2_MAX_RECORD_LENGTH_3_BYTE_HEADER + MARGIN);
    if ((*sslRef)->buffer == NULL)
    {
        // Mpobt@mۂłȂÄJ
        MEMFREE_PTR(*sslRef);
        return (~errNone);
    }
    MemSet((*sslRef)->buffer, (NNSHSSL2_MAX_RECORD_LENGTH_3_BYTE_HEADER + MARGIN), 0x00);

    return (errNone); 
}

/*=========================================================================*/
/*   Function : NNshSSLv2_Close                                            */
/*                                                          NNshSSL v2I */
/*=========================================================================*/
Err NNshSSLv2_Close(NNshSSLv2Ref **sslRef)
{
    NNsh_DebugMessage(ALTID_INFO, "NNshSSLv2_Close()", " ", 0);

    if (*sslRef != NULL)
    {
        MEMFREE_PTR((*sslRef)->connectionId);
        MEMFREE_PTR((*sslRef)->serverPublicKey);
        MEMFREE_PTR((*sslRef)->buffer);

        MEMFREE_PTR(*sslRef);
    }
    return (errNone); 
}

/*=========================================================================*/
/*   Function : NNshSSLv2_Connect                                          */
/*                                                          NNshSSL v2ڑ */
/*=========================================================================*/
Err NNshSSLv2_Connect(NNshSSLv2Ref *sslRef, NetSocketRef socketRef, UInt16 netRef)
{
    Err     ret;

    NNsh_DebugMessage(ALTID_INFO, "NNshSSLv2_Connect()", " ", 0);

    // SSLgpݒłȂ([N̈悪mۂĂȂ)I
    if (sslRef == NULL)
    {
        return (~errNone);
    }

    // ë/ϐ̏
    ret = errNone;
    sslRef->netRef    = netRef;
    sslRef->socketRef = socketRef;
    sslRef->state     = NNSHSSL_STATE_BEFORE;
    ret               = errNone;
    while (ret == errNone)
    {
        switch (sslRef->state)
        {
          case NNSHSSL_STATE_BEFORE:
          case NNSHSSL_STATE_CONNECT:
          case ((NNSHSSL_STATE_BEFORE)|(NNSHSSL_STATE_CONNECT)):
          case ((NNSHSSL_STATE_OK)|(NNSHSSL_STATE_CONNECT)):
            sslRef->state = SSL2_ST_SEND_CLIENT_HELLO;
            break;

          case SSL2_ST_SEND_CLIENT_HELLO:
            // Client Hello̐ƑM
            client_hello_NNshSSLv2(sslRef);
            ret = NNshNet_write(netRef, socketRef, sslRef->bufLen, sslRef->buffer);
            if (ret != errNone)
            {
                NNsh_DebugMessage(ALTID_INFO, "NNshNet_write():CLIENT HELLO", " ret:", ret);
                break;
            }
            NNsh_DebugMessage(ALTID_INFO, "CLIENT HELLO", " ", 0);
            sslRef->state = SSL2_ST_GET_SERVER_HELLO;
            break;

          case SSL2_ST_GET_SERVER_HELLO:
            // Server Hello̎擾ƓemF(vgRT|[gĂ邩H)
            ret = NNshNet_read(netRef, socketRef, 
                               (NNSHSSL2_MAX_RECORD_LENGTH_3_BYTE_HEADER + MARGIN),
                               sslRef->buffer, &(sslRef->bufLen));
            if (ret != errNone)
            {
                NNsh_DebugMessage(ALTID_INFO, "NNshNet_read():SEVER HELLO", " ret:", ret);
                break;
            }
            ret = get_server_hello_NNshSSLv2(sslRef);
            if (ret != errNone)
            {
                NNsh_DebugMessage(ALTID_INFO, "get server hello", " ret:", ret);
                break;
            }
            sslRef->state = SSL2_ST_SEND_CLIENT_MASTER_KEY;
            NNsh_DebugMessage(ALTID_INFO, "SERVER HELLO", " ", 0);
            break;

          case SSL2_ST_SEND_CLIENT_MASTER_KEY:
            (void) client_master_key_NNshSSLv2(sslRef);
            ret = NNshNet_write(netRef, socketRef, sslRef->bufLen, sslRef->buffer);
            if (ret != errNone)
            {
                NNsh_DebugMessage(ALTID_INFO, "NNshNet_write():client master key", " ret:", ret);
                break;
            }
            sslRef->state = SSL2_ST_CREATE_ENCRYPTION_KEY;
            NNsh_DebugMessage(ALTID_INFO, "CLIENT MASTER KEY", " ", 0);
            break;

          case SSL2_ST_CREATE_ENCRYPTION_KEY:
            (void) create_encryption_key_NNshSSLv2(sslRef);
            sslRef->state = SSL2_ST_GET_SERVER_VERIFY;
            break;

          case SSL2_ST_GET_SERVER_VERIFY:
            // Server Hello̎擾ƓemF(vgRT|[gĂ邩H)
            ret = NNshNet_read(netRef, socketRef, 
                               (NNSHSSL2_MAX_RECORD_LENGTH_3_BYTE_HEADER + MARGIN),
                               sslRef->buffer, &(sslRef->bufLen));
            if (ret != errNone)
            {
                NNsh_DebugMessage(ALTID_INFO, "NNshNet_read:SERVER VERIFY", " ret:", ret);
                break;
            }
            ret = get_server_verify_NNshSSLv2(sslRef);
            if (ret != errNone)
            {
                NNsh_DebugMessage(ALTID_INFO, "get server verify", " ret:", ret);
                break;
            }
            sslRef->state = SSL2_ST_SEND_CLIENT_FINISHED;
            NNsh_DebugMessage(ALTID_INFO, "SERVER VERIFY", " ", 0);
            break;

          case SSL2_ST_SEND_CLIENT_FINISHED:
            (void) client_finished_NNshSSLv2(sslRef);
            ret = NNshNet_write(netRef, socketRef, sslRef->bufLen, sslRef->buffer);
            if (ret != errNone)
            {
                NNsh_DebugMessage(ALTID_INFO, "NNshNet_write():client finished", " ret:", ret);
                break;
            }
            sslRef->state = SSL2_ST_GET_SERVER_FINISHED;
            NNsh_DebugMessage(ALTID_INFO, "CLIENT FINISHED", " ", 0);
            break;

          case SSL2_ST_GET_SERVER_FINISHED:
            ret = NNshNet_read(netRef, socketRef, 
                               (NNSHSSL2_MAX_RECORD_LENGTH_3_BYTE_HEADER + MARGIN),
                               sslRef->buffer, &(sslRef->bufLen));
            if (ret != errNone)
            {
                NNsh_DebugMessage(ALTID_INFO, "NNshNet_read:SERVER FINISHED", " ret:", ret);
                break;
            }
            ret = get_server_finished_NNshSSLv2(sslRef);
            if (ret != errNone)
            {
                NNsh_DebugMessage(ALTID_INFO, "get server finished", " ret:", ret);
                break;
            }
            sslRef->state = SSL2_ST_START_ENCRYPTION;
            NNsh_DebugMessage(ALTID_INFO, "SERVER FINISHED", " ", 0);
            break;

          case SSL2_ST_START_ENCRYPTION:
            // ÍʐM...
            NNsh_DebugMessage(ALTID_INFO, "<< SSL HANDSHAKE DONE >>", " ", 0);
            goto FUNC_END;
            break;

          default:
            NNsh_DebugMessage(ALTID_INFO, "default", " ret:", ret);
            ret = ~errNone;
            break;
        }
    }   // while (ret == errNone)

FUNC_END:
    // nhVF[NII
    return (ret);
}

/*=========================================================================*/
/*   Function : NNshSSLv2_Disconnect                                       */
/*                                                          NNshSSL v2ؒf */
/*=========================================================================*/
Err NNshSSLv2_Disconnect(NNshSSLv2Ref *sslRef)
{
    // ɉȂ
    return (errNone);
}

/*==========================================================================*/
/*  Function : NNshSSLv2_Read                                               */
/*                                                       NNshSSL v2ǂݏo */
/*==========================================================================*/
Err NNshSSLv2_Read(NNshSSLv2Ref *sslRef, UInt16 size, void *data, UInt16 *readSize)
{
    Err     ret;
    UInt8  *ptr;
    UInt16 *slen, len;

    // SSLgpݒłȂ([N̈悪mۂĂȂ)I
    *readSize = 0;
    if (sslRef == NULL)
    {
        return (~errNone);
    }

    // f[^ǂݍ
    ret = NNshNet_read(sslRef->netRef, sslRef->socketRef, 
                       (NNSHSSL2_MAX_RECORD_LENGTH_3_BYTE_HEADER + MARGIN),
                       sslRef->buffer, &(sslRef->bufLen));
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "NNshSSLv2_Read():read", " ", ret);
        return (ret);
    }
    if (sslRef->bufLen < MARGIN)
    {
        // MsiMf[^Ȃ̂Ƃĉj
        return (errNone);
    }

    // ȂɃbZ[W͑傫Ȃ̂Ɖ肷(2oCgwb_Ɖ)
    slen = (UInt16 *) sslRef->buffer;
    len  = ((0x7fff)&(*slen));
    if (size < len)
    {
        // őf[^𒴂Ăꍇɂ́A^ꂽobt@TCYŊۂ߂
        len = size;
    }

    // f[^̐擪ptrɐݒ
    ptr  = (UInt8 *) (slen + 1);

    // {fBۂƕ...
    client_decode_NNshSSLv2(sslRef, len, ptr, data);

    // hashL[f[^OɊ񂹂
    ptr = data;
    MemMove(ptr, &ptr[SSL2_MD5_HASH_LENGTH], (len - SSL2_MD5_HASH_LENGTH));

    *readSize = len - SSL2_MD5_HASH_LENGTH;

    // Mf[^\Ă݂
    NNsh_DebugMessage(ALTID_INFO, "NNshSSLv2_Read() ", data, *readSize);
    return (errNone);
}

/*==========================================================================*/
/*  Function : NNshSSLv2_Write                                              */
/*                                                       NNshSSL v2 */
/*==========================================================================*/
Err NNshSSLv2_Write(NNshSSLv2Ref *sslRef, UInt16 size, void *data)
{
    Err ret;

    // Mf[^\Ă݂...
    NNsh_DebugMessage(ALTID_INFO, "NNshSSLv2_Write() ", data, size);

    // SSLgpݒłȂ([N̈悪mۂĂȂ)I
    if (sslRef == NULL)
    {
        return (~errNone);
    }

    // Íf[^쐬
    client_encode_NNshSSLv2(sslRef, size, data);
    if (sslRef->bufLen == 0)
    {
        NNsh_DebugMessage(ALTID_INFO, "encode length is wrong ", "", 0);
        return (~errNone);
    }
    NNsh_DebugMessage(ALTID_INFO, "SEND DATA ", " size:", sslRef->bufLen);

    // bZ[W𑗐M
    ret = NNshNet_write(sslRef->netRef, sslRef->socketRef,
                        sslRef->bufLen, sslRef->buffer);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "NNshSSLv2_Write()", " ", ret);
    }
    return (ret);
}

/*--------------------------------------------------------------------------*/
/*  Function : client_hello_NNshSSLv2                                       */
/*                                                  SSL v2 client helloM */
/*--------------------------------------------------------------------------*/
static void client_hello_NNshSSLv2(NNshSSLv2Ref *sslRef)
{
    UInt8   *ptr;
    UInt16  *size, loc, cnt;

    // Client Hellõf[^쐬
    loc  = 0;
    size = (UInt16 *) sslRef->buffer;
    ptr  = (UInt8 *) (size + 1);

    /* data type */
    ptr[loc] = SSL2_MT_CLIENT_HELLO;
    loc++;
    
    /* protocol version(high) */
    ptr[loc] = SSL2_VERSION_MAJOR;
    loc++;
    
    /* protocol version(low) */
    ptr[loc] = SSL2_VERSION_MINOR;
    loc++;

    /** Cipher Spec. length **/ // Cipher Spec.́APLɂ...
    ptr[loc] = 0x00;
    loc++;
    ptr[loc] = 0x03;
    loc++;

    /** session ID length **/
    ptr[loc] = 0x00;
    loc++;
    ptr[loc] = 0x00;
    loc++;

    /** challenge length **/
    ptr[loc] = 0x00;
    loc++;
    ptr[loc] = SSL2_CHALLENGE_LENGTH;
    loc++;
    
    /** Cipher spec. **/
    // SSL_RC4_128_WITH_MD5(0x010080)Lɂ
    ptr[loc] = 0x01;
    loc++;
    ptr[loc] = 0x00;
    loc++;
    ptr[loc] = 0x80;
    loc++;

    /** challenge string **/
    // `W̐A16oCgA炢Ȑ...
    for (cnt = 0; cnt < SSL2_CHALLENGE_LENGTH; cnt++)
    {
        ptr[loc] = (0xff & SysRandom(TimGetTicks() * (cnt + 1)))|(0x20);
        sslRef->challenge[cnt] = ptr[loc];
        loc++;
    }

    *size = 0x8000 | loc;
    sslRef->bufLen = loc + sizeof(UInt16);

    return;
}

/*--------------------------------------------------------------------------*/
/*  Function : get_server_hello_NNshSSLv2                                   */
/*                                                  SSL v2 Server helloM */
/*--------------------------------------------------------------------------*/
static Err get_server_hello_NNshSSLv2(NNshSSLv2Ref *sslRef)
{
    UInt16 dataLen, sslVer, certLen, ciphLen, connLen, tmp, len;
    UInt8  mesType, certType, sessId, *ptr, *base;

    ptr    = sslRef->buffer;
    dataLen = 0x7ffff & *((UInt16 *) sslRef->buffer);    
    ptr = ptr + 2;

    mesType = *ptr;
    ptr++;

    sessId  = *ptr;
    ptr++;

    certType = *ptr;
    ptr++;

    tmp      = (*ptr) << 8;
    ptr++;

    sslVer  = tmp + *ptr;
    ptr++;

    tmp      = (*ptr) << 8;
    ptr++;

    certLen = tmp + *ptr;
    ptr++;

    tmp      = (*ptr) << 8;
    ptr++;
    
    ciphLen = tmp + *ptr;
    ptr++;

    if (ciphLen == 0)
    {
        // T|[gÍvȂAG[IB
        return (~errNone);
    }

    tmp      = (*ptr) << 8;
    ptr++;

    connLen = *ptr;
    ptr++;

    // ؖf[^(server_sertificate)
    base = ptr;
    while (ptr < base + certLen)
    {
        // T[ǒJ(OiKɁAOBJ IDENTIFIERT)
        if ((*ptr == 0x06)&&(*(ptr + 1) == 0x03)&&(*(ptr + 2) == 0x55)&&
            (*(ptr + 3) == 0x04)&&(*(ptr + 4) == 0x03))
        {
            // "X.520 id-at, commonName"
            ptr = ptr + 4 + 1 + 1;
            len = *ptr;  // f[^oCg擾Alenɑ
            // ӁFOXoCg͂PoCgƏɉ肵Ă
            ptr++;
            ptr = ptr + len;
            
            // ́A0x06 (Object Identifier)܂œǂݔ΂
            while (*ptr != 0x06)
            {
                if (ptr >= base + certLen)
                {
                    // f[^ȂȂAI
                    goto END_CERT;
                }
                ptr++;
            }

            if ((*ptr == 0x06)&&(*(ptr + 1) == 0x09)&&(*(ptr + 2) == 0x2a)&&
                (*(ptr + 3) == 0x86)&&(*(ptr + 4) == 0x48)&&(*(ptr + 5) == 0x86)&&
                (*(ptr + 6) == 0xf7)&&(*(ptr + 7) == 0x0d)&&(*(ptr + 8) == 0x01)&&
                (*(ptr + 9) == 0x01)&&(*(ptr + 10) == 0x01)&&(*(ptr + 11) == 0x05)&&
                (*(ptr + 12) == 0x00))
            {
                // (PKCS #1, rsaEncryption) 
                ptr = ptr + 13;
                if ((*ptr == 0x03)&&(*(ptr + 1) == 0x81))
                {
                    // ӁFOXoCgPoCgAgprbgȂƉ
                    while ((*ptr != 0x02)||(*(ptr + 1) != 0x81))
                    {
                        if (ptr >= base + certLen)
                        {
                            // f[^ȂȂAI
                            goto END_CERT;
                        }
                        ptr++;
                    }
                    // ӁFOXoCgPoCgAgprbgȂƉ
                    sslRef->serverPublicLen = *(ptr + 2) - 1;

                    ptr = ptr + 3 + 1;
                    sslRef->serverPublicKey = 
                                 MemPtrNew(sslRef->serverPublicLen + MARGIN);
                    if (sslRef->serverPublicKey == NULL)
                    {
                        // f[^̈̊mێsAI
                        break;
                    }
                    // T[oPublicKey擾
                    MemSet(sslRef->serverPublicKey, 
                           (sslRef->serverPublicLen + MARGIN), 0x00);
                    MemMove(sslRef->serverPublicKey, ptr, sslRef->serverPublicLen);
                    break;
                }
            }
        }
        ptr++;
    }
END_CERT:
    ptr = base + certLen;
    
    ptr = ptr + ciphLen;

    // ZbVIDf[^(connection-Id?)
    MEMFREE_PTR(sslRef->connectionId);
    sslRef->connectionId = MemPtrNew(connLen + MARGIN);
    if (sslRef->connectionId == NULL)
    {
        return (~errNone);
    }
    MemSet (sslRef->connectionId, (connLen + MARGIN), 0x00);
    MemMove(sslRef->connectionId, ptr, connLen);
    sslRef->connectionIdLen = connLen;

    ptr = ptr + connLen;

    return (errNone);
}

/*--------------------------------------------------------------------------*/
/*  Function : client_master_key_NNshSSLv2                                  */
/*                                  SSL v2 client master key Mf[^쐬 */
/*--------------------------------------------------------------------------*/
static Err client_master_key_NNshSSLv2(NNshSSLv2Ref *sslRef)
{
    UInt8   *ptr, *keyPtr;
    UInt16  *size, loc, lp;

    // Client Hellõf[^쐬
    loc  = 0;
    size = (UInt16 *) sslRef->buffer;
    ptr  = (UInt8 *) (size + 1);

    /** key  **/
    ptr[loc] = SSL2_MT_CLIENT_MASTER_KEY;
    loc++;
    
    /** Cipher spec. **/
    // SSL_RC4_128_WITH_MD5(0x010080)Lɂ
    ptr[loc] = 0x01;
    loc++;
    ptr[loc] = 0x00;
    loc++;
    ptr[loc] = 0x80;
    loc++;

    // clear key data length == 0
    ptr[loc] = 0x00;
    loc++;
    ptr[loc] = 0x00;
    loc++;

    // encrypted data length(Ƃœ)
    keyPtr = &ptr[loc];
    loc++;
    loc++;

    // key argument length == 0
    ptr[loc] = 0x00;
    loc++;
    ptr[loc] = 0x00;
    loc++;

    // master keyT[ǒJňÍ
    MemMove(sslRef->clientMasterKey, "NNsi_for_PalmOS_(SSLv2FakeConn.)", SSL2_MASTERKEY_LENGTH);
    lp = StrLen(sslRef->clientMasterKey);
    lp = NNshPublicEncryptRsa(lp, sslRef->clientMasterKey, &ptr[loc], sslRef);

    // Í̒i[
    *keyPtr       = (0xff00 & lp) >> 8;
    *(keyPtr + 1) = (0x00ff & lp);

    loc = loc + lp;

    *size = 0x8000 | loc;
    sslRef->bufLen = loc + sizeof(UInt16);

    return (errNone);
}

/*--------------------------------------------------------------------------*/
/*  Function : create_encryption_key_NNshSSLv2                              */
/*                                     f[^ǂݏp̈ÍL[𐶐 */
/*--------------------------------------------------------------------------*/
static Err create_encryption_key_NNshSSLv2(NNshSSLv2Ref *sslRef)
{
    UInt16 loc;
    UInt8 *buf;

    loc = SSL2_MASTERKEY_LENGTH + 1 + SSL2_CHALLENGE_LENGTH + sslRef->connectionIdLen;
    buf = MemPtrNew(loc + MARGIN);
    if (buf == NULL)
    {
        // memory allocation failure...
        return (~errNone);
    }
    MemSet(buf, (loc + MARGIN), 0x00);

    // f[^̑O
    MemSet(&(sslRef->digest),  sizeof(sslRef->digest), 0x00);
    MemSet(&(sslRef->PADDING), sizeof(sslRef->PADDING), 0x00);
    sslRef->PADDING[0] = 0x80;

    // MD5hashlvZā@CLIENT-READ-KEY߂
    MD5Init  (&(sslRef->context));
    MD5Update(&(sslRef->context), sslRef->clientMasterKey, SSL2_MASTERKEY_LENGTH);
    MD5Update(&(sslRef->context), "0", 1);
    MD5Update(&(sslRef->context), sslRef->challenge, SSL2_CHALLENGE_LENGTH);
    MD5Update(&(sslRef->context), sslRef->connectionId, sslRef->connectionIdLen);
    MD5Final (sslRef->digest, &(sslRef->context), sslRef->PADDING);
    MemMove  (sslRef->clientReadKey, sslRef->digest, SSL2_MD5_HASH_LENGTH);

    // f[^̑O()
    MemSet(&(sslRef->digest),  sizeof(sslRef->digest), 0x00);
    MemSet(&(sslRef->PADDING), sizeof(sslRef->PADDING), 0x00);
    sslRef->PADDING[0] = 0x80;

    // MD5hashlvZā@CLIENT-WRITE-KEY߂
    MD5Init  (&(sslRef->context));
    MD5Update(&(sslRef->context), sslRef->clientMasterKey, SSL2_MASTERKEY_LENGTH);
    MD5Update(&(sslRef->context), "1", 1);
    MD5Update(&(sslRef->context), sslRef->challenge, SSL2_CHALLENGE_LENGTH);
    MD5Update(&(sslRef->context), sslRef->connectionId, sslRef->connectionIdLen);
    MD5Final (sslRef->digest, &(sslRef->context), sslRef->PADDING);
    MemMove  (sslRef->clientWriteKey, sslRef->digest, SSL2_MD5_HASH_LENGTH);

    // mۂ̈̊J
    MEMFREE_PTR(buf);

    // ǂ݃L[
    MemSet(&(sslRef->workReadKey), sizeof(RC4_KEY), 0x00);
    RC4_SetKey(&(sslRef->workReadKey), SSL2_RWKEY_LENGTH, sslRef->clientReadKey);

    // L[
    MemSet(&(sslRef->workWriteKey), sizeof(RC4_KEY), 0x00);
    RC4_SetKey(&(sslRef->workWriteKey), SSL2_RWKEY_LENGTH, sslRef->clientWriteKey);

    return (errNone);
}

/*--------------------------------------------------------------------------*/
/*  Function : client_finished_NNshSSLv2                                    */
/*                                 lSVG[VĨbZ[W(client) */
/*--------------------------------------------------------------------------*/
static Err client_finished_NNshSSLv2(NNshSSLv2Ref *sslRef)
{
    UInt8   *ptr;

    // [Nobt@m
    ptr = MemPtrNew((sslRef->connectionIdLen + 1) + MARGIN);
    if (ptr == NULL)
    {
        return (~errNone);
    }
    MemSet(ptr, ((sslRef->connectionIdLen + 1) + MARGIN), 0x00);
    
    // Mf[^obt@ɃRs[
    *ptr = SSL2_MT_CLIENT_FINISHED;
    MemMove((ptr + 1), sslRef->connectionId, sslRef->connectionIdLen);

    // Client Finished̃f[^쐬
    client_encode_NNshSSLv2(sslRef, (sslRef->connectionIdLen + 1), ptr);

    // [Nobt@
    MEMFREE_PTR(ptr);

    return (errNone);
}

/*--------------------------------------------------------------------------*/
/*  Function : get_server_verify_NNshSSLv2                                  */
/*                                            SSL v2 serverR[ȟ */
/*--------------------------------------------------------------------------*/
static Err get_server_verify_NNshSSLv2(NNshSSLv2Ref *sslRef)
{
    Int16    match;
    UInt16  *size, len;
    UInt8   *ptr,  *workP;

    // ̈mۂ
    workP = MemPtrNew(SSL2_CHALLENGE_LENGTH + SSL2_MD5_HASH_LENGTH + MARGIN);
    if (workP == NULL)
    {
        return (~errNone);
    }
    MemSet(workP, (SSL2_CHALLENGE_LENGTH + SSL2_MD5_HASH_LENGTH + MARGIN), 0x00);

    // 
    size = (UInt16 *) sslRef->buffer;
    len  = ((0x7fff)&(*size));

    ptr  = (UInt8 *) (size + 1);


    // {fBۂƕ...
    client_decode_NNshSSLv2(sslRef, len, ptr, workP);

    // HASHľ؂͍sȂ
    ptr = workP + SSL2_MD5_HASH_LENGTH;

    // V[PXR[h̊mF
    if (*ptr != SSL2_MT_SERVER_VERIFY)
    {
        NNsh_DebugMessage(ALTID_INFO, "server verify[NG:CODE]", " id:", *ptr);
        MEMFREE_PTR(workP);
        return (~errNone);
    }

    // CHALLENGE̊mF
    match = MemCmp((ptr + 1), sslRef->challenge, SSL2_CHALLENGE_LENGTH);
    if (match != 0)
    {
        NNsh_DebugMessage(ALTID_INFO, "message does not match challenge str.",
                          " ", 0);
        MEMFREE_PTR(workP);
        return (~errNone);
    }
    MEMFREE_PTR(workP);
    return (errNone);
}

/*--------------------------------------------------------------------------*/
/*  Function : get_server_finished_NNshSSLv2                                */
/*                                 lSVG[VĨbZ[W(server) */
/*--------------------------------------------------------------------------*/
static Err get_server_finished_NNshSSLv2(NNshSSLv2Ref *sslRef)
{
    UInt16  *size, len;
    UInt8   *ptr,  *workP;

    // 
    workP = MemPtrNew(SSL2_MAX_SSL_SESSION_ID_LENGTH + SSL2_MD5_HASH_LENGTH + MARGIN);
    if (workP == NULL)
    {
        // ̈mێs
        return (~errNone + 10);
    }
    MemSet(workP, (SSL2_MAX_SSL_SESSION_ID_LENGTH + SSL2_MD5_HASH_LENGTH + MARGIN), 0x00);

    size = (UInt16 *) sslRef->buffer;
    len  = ((0x7fff)&(*size));

    ptr  = (UInt8 *) (size + 1);

    // {fBۂƕ...
    client_decode_NNshSSLv2(sslRef, len, ptr, workP);

    // HASHľ؂͍sȂ
    ptr = workP + SSL2_MD5_HASH_LENGTH;

    // V[PXR[h̊mF
    if (*ptr != SSL2_MT_SERVER_FINISHED)
    {
        NNsh_DebugMessage(ALTID_INFO, "server finished[NG]", " RX:", *ptr);
        OutputHexStringDebug("DECODED  DATA :", workP, len);
        return (~errNone);
    }

    // {ȂAŃZbVĊJp̃ZbVIDEKv邪ȗ

    MEMFREE_PTR(workP);
    return (errNone);
}

/*--------------------------------------------------------------------------*/
/*  Function : client_encode_NNshSSLv2                                      */
/*                                                 Mf[^̈Ís */
/*--------------------------------------------------------------------------*/
static void client_encode_NNshSSLv2(NNshSSLv2Ref *sslRef, UInt16 dataLen, Char *data)
{
    UInt8   *ptr, *orgPtr;
    UInt16  *size, lp;

    // Client Finished̃f[^쐬
    size  = (UInt16 *) sslRef->buffer;
    ptr   = (UInt8 *) (size + 1);
    *size = 0;

    orgPtr = MemPtrNew(SSL2_MD5_HASH_LENGTH + dataLen + MARGIN);
    if (orgPtr == NULL)
    {
        // ̈mێsAI
        NNsh_DebugMessage(ALTID_INFO, "memory alloc. failure"," size:",
                          (SSL2_MD5_HASH_LENGTH + dataLen + MARGIN));
        sslRef->bufLen = 0;
        return;
    }
    MemSet(orgPtr, (SSL2_MD5_HASH_LENGTH + dataLen + MARGIN), 0x00);

    // f[^̑O
    MemSet(&(sslRef->digest),  sizeof(sslRef->digest), 0x00);
    MemSet(&(sslRef->PADDING), sizeof(sslRef->PADDING), 0x00);
    sslRef->PADDING[0] = 0x80;

    // MD5hashlvZ MAC߂
    sslRef->seqNum++;
    MD5Init  (&(sslRef->context));
    MD5Update(&(sslRef->context), sslRef->clientWriteKey, SSL2_RWKEY_LENGTH);
    MD5Update(&(sslRef->context), data, dataLen);
    MD5Update(&(sslRef->context), (UInt8 *) &(sslRef->seqNum), sizeof(UInt32));
    MD5Final (sslRef->digest, &(sslRef->context), sslRef->PADDING);
    MemMove  (orgPtr, sslRef->digest, SSL2_MD5_HASH_LENGTH);

    // bZ[W{fBRs[
    MemMove  ((orgPtr + SSL2_MD5_HASH_LENGTH), data, dataLen);

    // {fBۂƈÍ...
    for (lp = 0; lp < (dataLen + SSL2_MD5_HASH_LENGTH); lp++)
    {
        // 1oCgÂÍ...
        RC4_Calculate(&(sslRef->workWriteKey), 1, &orgPtr[lp], &ptr[lp]);
    }
    MEMFREE_PTR(orgPtr);
    *size = 0x8000 | (SSL2_MD5_HASH_LENGTH + dataLen);
    sslRef->bufLen = (SSL2_MD5_HASH_LENGTH + dataLen) + sizeof(UInt16);

    return;
}

/*--------------------------------------------------------------------------*/
/*  Function : client_decode_NNshSSLv2                                      */
/*                                                   Mf[^̕s */
/*--------------------------------------------------------------------------*/
static void client_decode_NNshSSLv2(NNshSSLv2Ref *sslRef, UInt16 size, UInt8 *from, UInt8 *to)
{
    UInt16 lp;

    for (lp = 0; lp < size; lp++)
    {
        // 1oCgÂ...
        RC4_Calculate(&(sslRef->workReadKey), 1, &from[lp], &to[lp]);
    }
    return;
}

#endif  //#ifdef USE_SSL_V2
#endif  //#ifdef USE_SSL
