/*============================================================================*
 *  FILE: 
 *     sections.h
 *
 *  Description: 
 *     Multi-segment definitions.
 *
 *===========================================================================*/
#include <PalmOS.h>
#include <PalmCompatibility.h>

#define EDIT_SECTION   __attribute__ ((section ("editfns")))
#define EDIT_SECTION2  __attribute__ ((section ("editfns2")))
#define EDIT_SECTION3  __attribute__ ((section ("editfns3")))
#define EDIT_SECTION4  __attribute__ ((section ("editfns4")))
#define EDIT_SECTION5  __attribute__ ((section ("editfns5")))
#define EDIT_SECTION6  __attribute__ ((section ("editfns6")))
#define EDIT_SECTION7  __attribute__ ((section ("editfns7")))
#define EDIT_SECTION8  __attribute__ ((section ("editfns8")))
#define EDIT_SECTION9  __attribute__ ((section ("editfns9")))

/***** skeleton.c *****/
UInt32 PilotMain(UInt16 cmd, void *cmdPBP, UInt16 launchFlags);

/***** main.c *****/
#ifdef MAIN_C
static Boolean MyApplicationHandleEvent(EventType *event);
static UInt16  MyStartApplication(void);
static void    MyStopApplication(void);
#endif

/***** bbsmng.c *****/
#ifdef BBSMNG_C
static UInt16  getBoardURL(Char *url, Char *nick, Char *top, Char *bottom)          EDIT_SECTION5;
static void    parseBoard(DmOpenRef dbRef, Char *top, UInt32 *readSize)             EDIT_SECTION5;
static void    updateBoardList(void)                                                EDIT_SECTION5;
static Err     searchBBSTitle(Char *title, UInt16 direction, UInt16 *recNum)        EDIT_SECTION5;
static void entryBBSRecord(UInt16 recNum)                                           EDIT_SECTION5;
static void    closeForm_SelectBBS(void)                                            EDIT_SECTION5;
static void    setBBSListItem(void)                                                 EDIT_SECTION5;
static void    setAllBBS_Selection(UInt16 value)                                    EDIT_SECTION5;
static Boolean detail_SelectBBS(void)                                               EDIT_SECTION5;
static Boolean ctlSelEvt_SelectBBS(EventType *event)                                EDIT_SECTION5;
static Int16   ctlRepEvt_SelectBBS(EventType *event)                                EDIT_SECTION5;
static Int16   keyDownEvt_SelectBBS(EventType *event)                               EDIT_SECTION5;
static void    set_Selection_Info(UInt16 pageNum)                                   EDIT_SECTION5;
static void    display_BBS_Selection(UInt16 pageNum, Int16  selection)              EDIT_SECTION5;
#endif

Boolean GetBBSList(Char *url)                                                    EDIT_SECTION4;
Boolean Handler_SelectBBS(EventType *event)                                      EDIT_SECTION4;
void    OpenForm_SelectBBS(FormType *frm)                                        EDIT_SECTION4;
Err     Get_BBS_Info(UInt16 selBBS, NNshBoardDatabase *bbsInfo)                  EDIT_SECTION4;
Err     Update_BBS_Info(UInt16 selBBS, NNshBoardDatabase *bbsInfo)               EDIT_SECTION5;
Err     Get_BBS_Database(Char *boardNick, NNshBoardDatabase *bbs, UInt16 *index) EDIT_SECTION5;
Err     Update_BBS_Database(UInt16 index, NNshBoardDatabase *bbs)                EDIT_SECTION5;
Err     Create_BBS_INDEX(Char **bdLst, UInt16 *cnt)                              EDIT_SECTION5;


/***** msgwrite.c *****/
#ifdef MSGWRITE_C
static void     setBBSNameAndTime(UInt16 bbsType, Char *boardNick, Char *buffer, UInt16 bufSize)             EDIT_SECTION5;
static void     setFormParameters(Char *nick, Char *buffer, UInt16 bufSize, Char *tempArea, UInt16 areaSize, Char *defSubmit) EDIT_SECTION5;
static void     returnToMessageView(void)                                                                    EDIT_SECTION5;
static Boolean  menuEvt_WriteMessage(EventType *event)                                                       EDIT_SECTION5;
static void     checkCheckBoxUpdate(UInt16 chkId)                                                           EDIT_SECTION5;
static Boolean  selEvt_Control_WriteMessage(EventType *event)                                                EDIT_SECTION5;
static Boolean  selEvt_KeyDown_WriteMessage(EventType *event)                                                EDIT_SECTION5;
static Boolean  sclRepEvt_WriteMessage(EventType *event)                                                     EDIT_SECTION5;
static Boolean  fldChgEvt_WriteMessage(EventType *event)                                                     EDIT_SECTION5;
static Char    *checkWriteReply(Char *buffer, UInt32 bufSize, UInt32 command, UInt16 bbsType, Err *ret)      EDIT_SECTION5;
static Err      threadWrite_Message(void)                                                                   EDIT_SECTION5;
static Err      create_outputMessageFile(FormType *diagFrm, Char *buffer,UInt32 bufSize, Char *boardNick, 
                                         Char *key, UInt16 bbsType)                                          EDIT_SECTION5;
static void    outputTextField(FormType *frm, UInt16 fldID, Char *buf, UInt16 size, UInt16 bbsType, NNshFileRef *fileRef) EDIT_SECTION5;

#ifdef USE_NEWTHREAD_FEATURE
  static Err      execute_newThread       (FormType *frm)    EDIT_SECTION5;
  static Boolean  sclRepEvt_newThread     (EventType *event) EDIT_SECTION5;
  static Boolean  selEvt_Control_newThread(EventType *event) EDIT_SECTION5;
  static Boolean  selEvt_KeyDown_newThread(EventType *event) EDIT_SECTION5;
#endif

#endif
Boolean          Handler_WriteMessage (EventType *event)                                                      EDIT_SECTION5;
void            OpenForm_WriteMessage(FormType *frm)                                                         EDIT_SECTION5;
void            SaveWritingMessage (void)                                                                    EDIT_SECTION5;

Boolean          Handler_newThread    (EventType *event)                                                      EDIT_SECTION5;
void            OpenForm_newThread   (FormType *frm)                                                         EDIT_SECTION5;

#ifdef SUBJMGR_C
static void entryNotExistSubject(DmOpenRef dbRef, NNshSubjectDatabase *subjDb) EDIT_SECTION4;
static Err parse_SubjectList(Char *buffer, UInt32 readSize, UInt16 bbsType,
                             Char *boardNick, UInt16 *cnt) EDIT_SECTION4;
#endif
Err DeleteSubjectList(Char *boardNick, UInt16 delState, UInt16 *thrCnt)                                      EDIT_SECTION4;
void SortSubjectList(void) EDIT_SECTION4;

UInt16 convertListIndexToMsgIndex(UInt16 listIdx)                                                            EDIT_SECTION4;
Err NNsh_GetSubjectList(UInt16 index)                                                                        EDIT_SECTION4;
Err Check_same_thread(UInt16 selMES,NNshSubjectDatabase *data,NNshSubjectDatabase *matchedData,UInt16 *idx)  EDIT_SECTION4;
Err GetSubjectIndex(Char *boardNick, Char *threadFileName, UInt16 *index)                                    EDIT_SECTION4;
Boolean CheckIfCustomTabIsValid(Char                *bbsName,
                                NNshSubjectDatabase *mesInfo,
                                NNshCustomTab       *custom) EDIT_SECTION4;
                             
#ifdef OFFLINE_C
static Err checkOfflineEntryAvailable(DmOpenRef dbRef, UInt16 *recNum,
                                      UInt16 nofItems, UInt16 *recList,
                                      Char *threadFileName, UInt16 msgState,
                                      UInt16 offset) EDIT_SECTION2;
static Err getOfflineThreadRecords(UInt16 *nofItems, UInt16 **offThread) EDIT_SECTION2;
static Char *getThreadTitle(Char *msgP, UInt32 *size) EDIT_SECTION2;

static void setVFSOfflineThreadInfo(DmOpenRef dbRef, DmOpenRef dirDBRef,
                                    UInt16 nofItems, UInt16 *recList,
                                    UInt16 depth, UInt16 index, Char *dirName,
                                    NNshSubjectDatabase *subDb, UInt16 *cnt) EDIT_SECTION2;
#endif
Err create_offline_database(void) EDIT_SECTION2;
Err SetThreadInformation(Char *fileName, UInt16 fileMode, UInt16 *kanjiCode,
                         NNshSubjectDatabase *subDB) EDIT_SECTION2;
Err setOfflineLogDir(Char *fileName) EDIT_SECTION2;







                              


////////////////////////// 
















Err NNshHttp_commMain(UInt16 type, Char *url, Char *cookie, Char *appendData,
                      UInt32 range, UInt32 endRange, UInt16 port, Char *proxy,
                      Char *message, UInt16 sslMode) EDIT_SECTION7;
Boolean ctlSelEvt_DispMessage(EventType *event) EDIT_SECTION6;
Boolean menuEvt_DispMessage(EventType *event) EDIT_SECTION6;
Boolean Handler_NNshMessage(EventType *event) EDIT_SECTION;
Err OpenForm_NNshMessage(FormType *frm) EDIT_SECTION;
Err GetSubDirectoryName(UInt16 index, Char *dirName) EDIT_SECTION8;
void UpdateFieldRegion(void) EDIT_SECTION4;

Err Get_Subject_Database(UInt16 index, NNshSubjectDatabase *subjDB) EDIT_SECTION4;
Err MoveMessageToReadOnly(UInt16 index) EDIT_SECTION6;
Err CreateMessageThreadIndex(NNshMessageIndex *index, UInt32 *nofMsg,
                             UInt32 *msgOffset, UInt16 bbsType) EDIT_SECTION;
Err update_subject_database(UInt16 index, NNshSubjectDatabase *subjDB) EDIT_SECTION2;
Err Get_AllMessage(Char *url, Char *boardNick, Char *file, UInt16 idxMES,
                   UInt16 bbsType) EDIT_SECTION6;
Err Get_PartMessage(Char *url, Char *boardNick, NNshSubjectDatabase *mesDB, 
                    UInt16 idxMES, Char *message) EDIT_SECTION6;
Err MoveSubject_BBS(Char *dest, Char *src)           EDIT_SECTION3;
void MarkMessageIndex(UInt16 index, UInt16 favor)    EDIT_SECTION3;
Boolean Get_MessageFromMesNum(Boolean *updateBBS, UInt16 *recNum, Boolean useClipboard) EDIT_SECTION2;
Boolean GetThreadDataFromMesNum(Boolean *updateBBS, Char *buf, UInt16 bufLen, UInt16 *recNum) EDIT_SECTION2;
Err CreateThreadURL(UInt16 urlType, Char *url, UInt16 bufSize, 
                    NNshBoardDatabase *bbsInfo, NNshSubjectDatabase *mesInfo) EDIT_SECTION2;
void CreateThreadBrowserURL(UInt16 urlType, Char *url, NNshBoardDatabase *bbsInfo, NNshSubjectDatabase *mesInfo) EDIT_SECTION4;
Boolean Handler_MessageInfo(EventType *event)        EDIT_SECTION2;
Err DisplayMessageInformations(UInt16 msgIndex, UInt16 *msgAttribute) EDIT_SECTION4;
     
Err OpenFile_NNsh(Char *fileName, UInt16 fileMode, NNshFileRef *fileRef) EDIT_SECTION;
Err GetFileSize_NNsh(NNshFileRef *fileRef, UInt32 *fileSize) EDIT_SECTION;
Err ReadFile_NNsh(NNshFileRef *fileRef, UInt32 offset, UInt32 size, 
                  void *ptr, UInt32 *readSize) EDIT_SECTION;
Err CloseFile_NNsh(NNshFileRef *fileRef) EDIT_SECTION;
Err CheckFileSpace_NNsh(UInt16 fileMode, UInt32 size) EDIT_SECTION;

void NNsi_FrmDrawForm(FormType *frm, Boolean redraw) EDIT_SECTION;
void NNsi_UpdateRectangle(RectangleType *dimF, UInt16 fontType, UInt16 *fontID, 
                          UInt16 *fontHeight, UInt16 *nlines) EDIT_SECTION;

void NNshWinViewUpdateScrollBar(UInt16 fldID, UInt16 sclID) EDIT_SECTION;
Boolean NNshWinViewPageScroll(UInt16 fldID, UInt16 sclID, 
                              UInt16 lines, WinDirectionType direction) EDIT_SECTION5;
void NNsh_UpDownButtonControl(FormType *frm, UInt16 btnState, UInt16 upBtnID, UInt16 downBtnID) EDIT_SECTION5;
void NNsi_WinDrawList(UInt16 pointIndex, Char *titleIndex[], UInt16 listItems,
                      RectangleType *dimF, UInt16 height) EDIT_SECTION;
void NNsi_WinUpdateList(UInt16 pointIndex, UInt16 prevIndex,
                        Char *titleIndex[], UInt16 listItems,
                        RectangleType *dimF, UInt16 height) EDIT_SECTION;
void NNsi_RedrawThreadList(void)  EDIT_SECTION;

#ifdef USE_COLOR
Boolean NNsiWinDrawColorLine(Char *str, UInt16 lineLen, Coord x, Coord y) EDIT_SECTION9;
#endif

Boolean Update_Thread_List(UInt16 bbsIdx, UInt16 selItem, UInt16 step) EDIT_SECTION;

Err GetPartMessage_NNsh(Char *url, Char *boardNick,
                        NNshSubjectDatabase *mesDB, UInt16 idxMES) EDIT_SECTION4;
Err MoveLogMessage(UInt16 index) EDIT_SECTION2;
Boolean ExecuteAction(UInt16 funcID) EDIT_SECTION2;
UInt16  Show_tab_info(Boolean disp)  EDIT_SECTION8;

#ifdef THRMNG_C
static void    change_handera_rotate(void)  EDIT_SECTION2;
static void    updateSelectionItem(Int16 direction) EDIT_SECTION2;
static void    change_list_font(void)       EDIT_SECTION2;
static void    change_graph_mode(void)      EDIT_SECTION2;
static void    setMultiPurposeSwitch(FormType *frm, UInt16 itemID, UInt16 btnID) EDIT_SECTION2;
static Boolean updateMultiPurposeSwitch(UInt16 paramID, UInt16 btnID) EDIT_SECTION2;
static Boolean launch_WebBrowser(void)        EDIT_SECTION2;
static void NNshMain_Close(UInt16 nextFormID) EDIT_SECTION2;
static void moveSelectionTab(UInt16 selBBS)   EDIT_SECTION2;
static Boolean readonly_dir_selection(void)   EDIT_SECTION2;
static Boolean open_menu(void)                EDIT_SECTION2;
static Boolean modify_title(void) EDIT_SECTION2;
static Boolean copy_to_readOnly(void) EDIT_SECTION2;
static Boolean set_SearchTitleString(void) EDIT_SECTION2;
static Boolean search_NextTitle(Int16 direction) EDIT_SECTION2;
static Err get_subject_info(NNshSubjectDatabase *mesInfo,  UInt16 *selTHR) EDIT_SECTION2;
static Err get_message_Info(NNshSubjectDatabase *mesInfo,  UInt16 *selTHR, 
                            NNshBoardDatabase   *bbsInfo,  UInt16 *selBBS) EDIT_SECTION2;
static Boolean newThread_message(void) EDIT_SECTION2;
static Boolean display_message(void) EDIT_SECTION2;
static Boolean get_all_message(void) EDIT_SECTION2;
static Boolean update_message(void) EDIT_SECTION2;
static Boolean update_newarrival_message(UInt16 command) EDIT_SECTION2;
static Boolean update_getall_message(void) EDIT_SECTION2;
static Boolean get_subject_txt(void) EDIT_SECTION2;
static Boolean rctPointEvt_ThreadMain(EventType *event, FormType *frm, RectangleType *rect) EDIT_SECTION2;
static Boolean popEvt_ThreadMain(EventType *event) EDIT_SECTION2;
static Boolean keyDownEvt_ThreadMain(EventType *event) EDIT_SECTION2;
static Boolean ctlSelEvt_ThreadMain(EventType *event) EDIT_SECTION2;
static Boolean menuEvt_ThreadMain(EventType *event) EDIT_SECTION2;
static Boolean move_log_location(void)              EDIT_SECTION2;
static Boolean move_log_directory(void)              EDIT_SECTION2;
static UInt16  select_readonly_directory(UInt16 orgDir) EDIT_SECTION2;
#ifdef USE_LOGCHARGE
static void   openURL(void) EDIT_SECTION6;
#endif
#endif

#ifdef MSGMGR_C
static void checkLogChargeThread(Char *fileName, NNshGetLogDatabase *dbData, UInt32 *tokenId) EDIT_SECTION6;
static Err createThreadIndexSub_HTML(Char   *buffer, UInt32 size,
                           UInt32 offset, UInt32 *nofMsg, UInt32 *msgOffset,
                           Char *fileName, UInt16 kanjiCode, UInt16 *status,
                           UInt32 tokenId) EDIT_SECTION6;
static Err createThreadIndexSub_MachiBBS(Char   *buffer, UInt32 size,
                           UInt32 offset, UInt32 *nofMsg, UInt32 *msgOffset,
                           UInt16 type, Char *start, Char *end) EDIT_SECTION6;
static Err getLastMessageNumShitaraba(UInt16 *resNum) EDIT_SECTION8;
static void message_entryDatabase(UInt16 idxMES,UInt32 fileSize,UInt16 bbsType) EDIT_SECTION2;
static Err message_entryMessage(Char *targetFile, UInt32 *dataSize, UInt16 bbsType) EDIT_SECTION2;
static Err message_appendMessage(Char *targetFile, NNshSubjectDatabase *mesDB) EDIT_SECTION2;
#endif
#ifdef MSGVIEW_C
static Boolean pickupAnchor(NNshMessageIndex *idxP, Char *buffer, UInt16 size) EDIT_SECTION3;
static Boolean pickupAnchorURL(NNshMessageIndex *idxP, Char *buffer, UInt16 size) EDIT_SECTION3;
static void checkHideMessage(Char *buffer) EDIT_SECTION3;
static void setFavoriteLabel(FormType *frm, UInt16 attribute)              EDIT_SECTION3;
static void outputMemoPad(void)                                            EDIT_SECTION3;
static void openWebBrowser(UInt16 confirmation, Char *buffer, UInt16 size) EDIT_SECTION3;
static void jumpPrevious(void) EDIT_SECTION3;
static void jumpEdge(Boolean loc) EDIT_SECTION3;
static void parseMessage(Char *buf, Char *source, UInt32 size, UInt16 *nofJmp, UInt16 *jmpBuf, UInt16 kanjiCode, Boolean setJumpFlag) EDIT_SECTION3;
static void changeFont(void) EDIT_SECTION3;
static void displayMessageSub(UInt16 bbsType, Char *topP, UInt32 mesNum,
                              UInt32 offset,  UInt32 size, Char *buf, Boolean setJumpMsg) EDIT_SECTION3;
static Err displayMessage(NNshMessageIndex *idxP, UInt16 isBottom) EDIT_SECTION3;
static Boolean moveMessageNext(Boolean chkScroll) EDIT_SECTION3;
static Boolean moveMessagePrev(Boolean chkScroll, UInt16 dispLoc) EDIT_SECTION3;
static Boolean jumpMessage(FormType *frm,NNshMessageIndex *idxP) EDIT_SECTION3;
static Boolean sclRepEvt_DispMessage(EventType *event) EDIT_SECTION3;
static Boolean selEvt_KeyDown_DispMessage(EventType *event) EDIT_SECTION3;
static Err PartReceiveMessage_View(void) EDIT_SECTION3;
static void NNsh_Search_Message(UInt16 type, Char *str, Boolean flag) EDIT_SECTION3;
static Err NNsh_Get_MessageToBuf(NNshMessageIndex *idxP, UInt16 msg, UInt16 type, Boolean flag) EDIT_SECTION3;
static void getViewDataString(Char *buffer, Char *headerStr, UInt16 bufSize) EDIT_SECTION3;
static Boolean executeViewAction(UInt16 funcID) EDIT_SECTION3;
#endif
void ReadMessage_Close(UInt16 nextFormID) EDIT_SECTION3;

// BUSY FORMs
void SetMsg_BusyForm(Char *msg)      EDIT_SECTION4;
void Show_BusyForm  (Char *msg)      EDIT_SECTION4;
void Hide_BusyForm  (Boolean redraw) EDIT_SECTION4;

// DIALOGs
UInt16 NNsh_DialogMessage(UInt16 level, UInt16 altID, Char *mes1, Char *mes2, UInt32 num) EDIT_SECTION4;
Boolean NNsh_MenuEvt_Edit(EventType *event)     EDIT_SECTION4;
Boolean Handler_DialogAction(EventType *event)  EDIT_SECTION4;
Boolean Handler_IDpwAction(EventType *event)    EDIT_SECTION4;
Boolean Handler_JumpSelection(EventType *event) EDIT_SECTION4;
Boolean Handler_ViewLineAction(EventType *event) EDIT_SECTION4;
UInt16 NNshWinSelectionWindow(UInt16 frmId, Char *listItemP, UInt16 nofItems, UInt16 selection) EDIT_SECTION4;
void PrepareDialog_NNsh(UInt16 formID, FormType **diagFrm, Boolean silk) EDIT_SECTION4;
void PrologueDialog_NNsh(FormType *prevFrm, FormType *diagFrm, Boolean silk) EDIT_SECTION4;
void NNsi_putLine(FormType *frm, UInt16 command) EDIT_SECTION4;
void OutputHexStringDebug(Char *msg, Char *data, UInt16 len) EDIT_SECTION7;

// Backup/Restore Databases
Err  BackupDatabaseToVFS_NNsh   (Char *dbName) EDIT_SECTION4;
Err  RestoreDatabaseFromVFS_NNsh(Char *dbName) EDIT_SECTION4;
void BackupDBtoVFS(UInt16 backupAllDB) EDIT_SECTION4;
Err  RestoreDBtoVFS(Boolean forceRead) EDIT_SECTION4;

#ifdef HTTPMGR_C
static Err NNshHttp_createPostMsg(UInt16 type, Char *url, Char *host,
                                   Char *extendUserAgent, Char *cookie, 
                                   Char *appendData, UInt16 *portNo,
                                   Char *buffer, UInt32 bufSize) EDIT_SECTION7;

static void NNshHttp_divideHostName(Char *url, Char *host, Char **loc, UInt16 *portNo) EDIT_SECTION7;
static void NNshHttp_createGetMsg(UInt16 type, Char *url, Char *host,
                                   Char *extendUserAgent, UInt16 *portNo,
                                   UInt32 getRange, UInt32 endRange, 
                                   Char *buffer, Char *proxy) EDIT_SECTION7;
#endif

// HTTP connection
Err NNshHttp_comm(UInt16 type, Char *url, Char *cookie, Char *appendData,
                  UInt32 range, UInt32 endRange, Char *message) EDIT_SECTION4;
// Hang up line
void NNshNet_LineHangup(void) EDIT_SECTION4;

void NNshNet_TraceBitSet(UInt16 netRef, UInt32 traceBits)                              EDIT_SECTION3;
void NNshNet_CheckHostAlive(UInt16 netRef, Char *name, UInt16 count, Char *resultMsg)  EDIT_SECTION3;
void NNshNet_GetNetIFInfo(UInt16 netRef, Char *buffer)                                 EDIT_SECTION3;

// Launch Web Browser
Err WebBrowserCommand(UInt32 creator, UInt16 subLaunch, 
                      UInt16 flags, UInt16 cmd, 
                      Char *parameterP, UInt16 paramSize,
                      UInt32 *resultP) EDIT_SECTION;
// Launch Network Preferences screen
void OpenNetworkPreferences(void) EDIT_SECTION4;

#ifdef USE_BT_CONTROL
// Bluetooth control
void OpenBluetoothPreferences(Boolean val) EDIT_SECTION4;
#endif

#ifdef NNSHSET_C
static void clearFeatureList(void) EDIT_SECTION4;
static void closeForm_NNsiSettings(UInt16 nextFormID) EDIT_SECTION4;
static Err createFeatureListStrings(NNshWordList **lst, UInt16 strRscId) EDIT_SECTION4;

static Boolean keyDownEvt_NNshSetting(EventType *event) EDIT_SECTION4;
static Boolean setTitleHardKey(Char *title, UInt16 data, UInt16 mask, NNshHardkeyControl *info) EDIT_SECTION4;
static Boolean selectOmitDialog(void)  EDIT_SECTION4;

static Err effect_NNshSetting(FormType *frm) EDIT_SECTION4;
static Err effectNNsiSetting2(FormType *frm) EDIT_SECTION4;
static Err effectNNsiSetting3(FormType *frm) EDIT_SECTION4;
static Err effectNNsiSetting4(FormType *frm) EDIT_SECTION4;
static Err effectNNsiSetting5(FormType *frm) EDIT_SECTION4;
static Err effectNNsiSetting6(FormType *frm) EDIT_SECTION4;
static Err effectNNsiSetting7(FormType *frm) EDIT_SECTION4;
static Err effectNNsiSetting8(FormType *frm) EDIT_SECTION4;
static Err effectNNsiSetting9(FormType *frm) EDIT_SECTION4;
static Err effectNNsiSettingA(FormType *frm) EDIT_SECTION4;
static Err effect_FavorTabSet(FormType *frm, NNshCustomTab *custom) EDIT_SECTION4;
static void closeForm_FavorTabSet(UInt16 nextForm) EDIT_SECTION4;
#ifdef USE_COLOR
Boolean Handler_setViewColorDetail(EventType *event) EDIT_SECTION9;
static Boolean setViewColorDetail(void) EDIT_SECTION9;
#endif
static Boolean effectNGwordInput(FormType *frm) EDIT_SECTION6;
static Boolean displayNGwordInfo(FormType *frm, NNshNGwordDatabase *dbData) EDIT_SECTION6;
#endif
Boolean Handler_NGwordInput(EventType *event) EDIT_SECTION6;
Boolean SetNGword3(void)                      EDIT_SECTION6;
#ifdef USE_LOGCHARGE
Boolean SetLogGetURL(void)                    EDIT_SECTION4;
Boolean Handler_LogGetURL(EventType *event)    EDIT_SECTION4;
#endif
Boolean Handler_NNshSetting(EventType *event) EDIT_SECTION9;
Err     OpenForm_FavorTabSet(FormType *frm)   EDIT_SECTION;
Boolean Handler_FavorTabSet(EventType *event) EDIT_SECTION;
#ifdef MSGLIST_C
static void copyThreadTitleString(Char  *dest, Char *src, UInt16 length,
                                  UInt16 state, UInt16 msgNumber) EDIT_SECTION3;
static Err AllocMsgTitleInfo(UInt16 nofItems) EDIT_SECTION3;
static Err create_TitleList(UInt16 bbsIndex, UInt16 areaCount, Char *buffer,
                             Int16 step) EDIT_SECTION3;
#ifdef USE_COLOR
void NNsi_SetTitleColor(UInt16 status) EDIT_SECTION3;
#endif
#endif
Boolean CheckDispList(UInt16 bbsIndex, NNshSubjectDatabase *subjP, NNshBoardDatabase *bdP) EDIT_SECTION3;

Boolean ConvertHanZen (UInt8 *dst, UInt8 *ptr) EDIT_SECTION3;
Boolean ConvertJIStoSJ(UInt8 *dst, UInt8 *ptr) EDIT_SECTION3;
Boolean ConvertSJtoJIS(UInt8 *dst, UInt8 *ptr) EDIT_SECTION3;
Boolean ConvertEUCtoSJ(UInt8 *dst, UInt8 *ptr, UInt16 *copyByte) EDIT_SECTION3;
Boolean ConvertSJtoEUC(UInt8 *dst, UInt8 *ptr, UInt16 *copyByte, UInt16 *parseByte) EDIT_SECTION3;
void    StrCopyEUC(Char *dst, Char *src)     EDIT_SECTION3;
void    StrCopySJ (Char *dst, Char *src)     EDIT_SECTION3;
void    StrCopyJIStoSJ(Char *dst, Char *src) EDIT_SECTION3;
void    StrNCopyHanZen(Char *dest, Char *src, UInt16 length) EDIT_SECTION3;

Char *StrCatURLencode(Char *dst, Char *src) EDIT_SECTION3;

Err     SendToLocalMemopad(Char *title, Char *data) EDIT_SECTION3;
Boolean DataInputDialog  (Char *title, Char *area,   UInt16 size, UInt16 usage, void *valueP) EDIT_SECTION3;
Boolean DataInputPassword(Char *title, Char *id, UInt16 idSize, Char *pw, UInt16 pwSize, Char *info) EDIT_SECTION3;
Boolean DataViewForm(Char *title, UInt16 nofLine, Char **dataLine) EDIT_SECTION3;

void    ShowVersion_NNsh   (void) EDIT_SECTION6;
void    ShowDeviceInfo_NNsh(void) EDIT_SECTION7;
Err      SeparateWordList(Char *string, NNshWordList *wordList) EDIT_SECTION3;
void    ReleaseWordList(NNshWordList *wordList) EDIT_SECTION3;
UInt32   GetOSFreeMem(UInt32 *totalMemoryP, UInt32 *dynamicMemoryP) EDIT_SECTION7;
Boolean LaunchResource_NNsh(UInt32 type, UInt32 creator, DmResType resType, DmResID resID) EDIT_SECTION3;
Boolean CheckInstalledResource_NNsh(UInt32 type, UInt32 creator)  EDIT_SECTION3;

/*** DATABASE ACCESSING FUNCTIONS ***/
void OpenDatabase_NNsh (Char *dbName, UInt16 chkVersion, DmOpenRef *dbRef) EDIT_SECTION;
void CloseDatabase_NNsh(DmOpenRef dbRef) EDIT_SECTION;
void QsortRecord_NNsh  (DmOpenRef dbRef, UInt16 keyType, UInt16 offset) EDIT_SECTION;
void IsortRecord_NNsh  (DmOpenRef dbRef, UInt16 keyType, UInt16 offset) EDIT_SECTION;
void GetDBCount_NNsh   (DmOpenRef dbRef, UInt16 *count) EDIT_SECTION;
Err  GetDBInfo_NNsh(Char *dbName, NNshDBInfo *info)     EDIT_SECTION;
Err  EntryRecord_NNsh  (DmOpenRef dbRef, UInt16 size,  void *recordData) EDIT_SECTION;
Err  GetRecord_NNsh    (DmOpenRef dbRef, UInt16 index, UInt16 size, void *matchedData) EDIT_SECTION;
Err GetRecordReadOnly_NNsh(DmOpenRef dbRef, UInt16 index,
                           MemHandle *dataH, void **record) EDIT_SECTION;
Err ReleaseRecordReadOnly_NNsh(DmOpenRef dbRef, MemHandle dataH) EDIT_SECTION;
Err GetRecordID_NNsh(DmOpenRef dbRef, UInt16 index, UInt32 *recId) EDIT_SECTION;
Err  UpdateRecord_NNsh (DmOpenRef dbRef, UInt16 index, UInt16 size, void *updateData) EDIT_SECTION;
Err  IsExistRecord_NNsh(DmOpenRef dbRef, void *target, UInt16 keyType, UInt16 offset, UInt16 *index) EDIT_SECTION;
Err  SearchRecord_NNsh (DmOpenRef dbRef, void *target, UInt16 keyType, UInt16 offset, UInt16 size, void *matchedData, UInt16 *index) EDIT_SECTION;
Err  DeleteRecord_NNsh (DmOpenRef dbRef, void *target, UInt16 keyType, UInt16 offset) EDIT_SECTION;
Err  DeleteRecordIDX_NNsh(DmOpenRef dbRef, UInt16 index) EDIT_SECTION;
Boolean GetExistRecordList(DmOpenRef dbRef, Char *boardNick, MemHandle *listH, UInt16 *threadNum) EDIT_SECTION;

/*** FILE(FileStream/VFS) ACCESSING FUNCTIONS ***/
Err DeleteFile_NNsh (Char *fileName, UInt16 location) EDIT_SECTION5;
Err CreateFile_NNsh (Char *fileName) EDIT_SECTION5;
Err RenameFile_NNsh (Char *oldFileName, Char *newFileName) EDIT_SECTION5;
Err CreateDir_NNsh  (Char *dirName) EDIT_SECTION5;
Err CloseFile_NNsh  (NNshFileRef *fileRef) EDIT_SECTION;
Err CopyFile_NNsh   (Char *destFile, Char *sourceFile, UInt16 location) EDIT_SECTION6;
Err OpenFile_NNsh   (Char *fileName, UInt16 fileMode, NNshFileRef *fileRef) EDIT_SECTION;
Err GetFileSize_NNsh(NNshFileRef *fileRef, UInt32 *fileSize) EDIT_SECTION;
Err ReadFile_NNsh   (NNshFileRef *fileRef, UInt32 offset, UInt32 size, void *ptr, UInt32 *readSize) EDIT_SECTION;
Err WriteFile_NNsh  (NNshFileRef *fileRef, UInt32 offset, UInt32 size, void *ptr, UInt32 *writeSize) EDIT_SECTION;
Err AppendFile_NNsh (NNshFileRef *fileRef, UInt32 size, void *ptr, UInt32 *writeSize) EDIT_SECTION;
Err AppendFileAsURLEncode_NNsh(NNshFileRef *fileRef, UInt32 size, void *ptr, UInt32 *writeSize) EDIT_SECTION;

#ifdef USE_XML_OUTPUT
Err Output_NNsiSet_XML(Char *fileName) EDIT_SECTION6;
Err Input_NNsiSet_XML (Char *fileName) EDIT_SECTION6;
#endif

/**** LOG CHARGE FUNCTIONS ***/
#ifdef USE_LOGCHARGE
#ifdef GETLOG_C
    static Err getLogFileList(Char *fileName, Char *baseURL, UInt32 tokenId, UInt16 *urlCnt, Char **listArray, Char **urlList) EDIT_SECTION5;
    static Boolean effectLogGetURL(FormType *frm) EDIT_SECTION5;
    static Boolean displayLogDataInfo(FormType *frm, NNshGetLogDatabase *dbData) EDIT_SECTION5;
    static Boolean effectLogToken(FormType *frm) EDIT_SECTION5;
    static Boolean displayLogToken(FormType *frm, UInt16 recNum) EDIT_SECTION5;
#endif
Boolean Handler_setLogToken(EventType *event) EDIT_SECTION5;
Boolean SetLogCharge_LogToken(UInt16 recNum) EDIT_SECTION5;
Err     GetLogToken(UInt32 key, NNshLogTokenDatabase *record) EDIT_SECTION5;
UInt16  ConvertTokenListNum(UInt32 key) EDIT_SECTION5;
UInt16  GetLogTokenLabelList(NNshWordList *wordList, UInt32 **idList) EDIT_SECTION5;
UInt16  SelectLogToken(UInt32 *selection) EDIT_SECTION5;

Err ReadOnlyLogDataPickup(NNshGetLogDatabase *dbData, Char *url, Char *fileName, UInt16 recNum, UInt16 depth, UInt16 number) EDIT_SECTION5;
Err GetReadOnlyLogData_NNsh(void) EDIT_SECTION5;
#endif  // #ifdef USE_LOGCHARGE


#ifdef USE_SSL
Err ProceedOysterLogin(void) EDIT_SECTION7;

Err NNshSSL_open (UInt16 sslMode, UInt16 *netRef, UInt16 *sslRef, SslLib **template, SslContext **context) EDIT_SECTION7;
Err NNshSSL_close(UInt16 sslMode, UInt16  netRef, UInt16  sslRef, SslLib  *template, SslContext  *context) EDIT_SECTION7;

Err NNshSSL_connect   (UInt16 sslMode, UInt16 sslRef, SslContext *context, NetSocketRef *socketRef, UInt16 netRef, Char *hostName, UInt16 port) EDIT_SECTION7;
Err NNshSSL_disconnect(UInt16 sslMode, UInt16 sslRef, SslContext *context, NetSocketRef  socketRef, UInt16 netRef) EDIT_SECTION7;

Err NNshSSL_write(UInt16 sslMode, UInt16  netRef, NetSocketRef socketRef, UInt16 sslRef, SslContext *context, UInt16 size, void *data)           EDIT_SECTION7;
Err NNshSSL_read (UInt16 sslMode, UInt16  netRef, NetSocketRef socketRef, UInt16 sslRef, SslContext *context, UInt16 size, void *data, UInt16 *readSize) EDIT_SECTION7;
Err NNshSSL_flush(UInt16 sslMode, UInt16  sslRef, SslContext *context) EDIT_SECTION7;

Int32 NNshSSL_callbackFunc(SslCallback *callbackStruct, Int32 command, Int32 flavor, void *info) EDIT_SECTION;

#ifdef USE_SSL_V2
Err NNshSSLv2_Open      (NNshSSLv2Ref **sslRef) EDIT_SECTION7;
Err NNshSSLv2_Close     (NNshSSLv2Ref **sslRef) EDIT_SECTION7;
Err NNshSSLv2_Connect   (NNshSSLv2Ref *sslRef, NetSocketRef socketRef, UInt16 netRef) EDIT_SECTION7;
Err NNshSSLv2_Disconnect(NNshSSLv2Ref *sslRef)  EDIT_SECTION7;
Err NNshSSLv2_Read      (NNshSSLv2Ref *sslRef, UInt16 size, void *data, UInt16 *readSize) EDIT_SECTION7;
Err NNshSSLv2_Write     (NNshSSLv2Ref *sslRef, UInt16 size, void *data) EDIT_SECTION7;

#ifdef SSLV2_C
static void client_hello_NNshSSLv2     (NNshSSLv2Ref *sslRef) EDIT_SECTION7;
static Err   get_server_hello_NNshSSLv2 (NNshSSLv2Ref *sslRef) EDIT_SECTION7;
static Err   get_server_verify_NNshSSLv2(NNshSSLv2Ref *sslRef) EDIT_SECTION7;
static Err   get_server_finished_NNshSSLv2(NNshSSLv2Ref *sslRef) EDIT_SECTION7;
static Err   client_master_key_NNshSSLv2(NNshSSLv2Ref *sslRef) EDIT_SECTION7;
static Err   create_encryption_key_NNshSSLv2(NNshSSLv2Ref *sslRef) EDIT_SECTION7;
static Err   client_finished_NNshSSLv2  (NNshSSLv2Ref *sslRef) EDIT_SECTION7;
static void client_encode_NNshSSLv2(NNshSSLv2Ref *sslRef, UInt16 dataLen, Char *data) EDIT_SECTION7;
static void client_decode_NNshSSLv2(NNshSSLv2Ref *sslRef, UInt16 size, UInt8 *from, UInt8 *to) EDIT_SECTION7;
#endif // #ifdef SSLV2_C

void CalcMD5(Char *string, UInt32 stringLen, Char *buffer, UInt32 *bufLen, NNshSSLv2Ref *sslRef) EDIT_SECTION7;
void MD5Final (UInt8 digest[16], MD5_CTX *context, UInt8 *PADDING) EDIT_SECTION7;
void MD5Update(MD5_CTX *context, UInt8 *input, UInt16 inputLen) EDIT_SECTION7;
void MD5Init  (MD5_CTX *context) EDIT_SECTION7;

void RC4_SetKey(RC4_KEY *key, UInt16 len, UInt8 *data) EDIT_SECTION7;
void RC4_Calculate(RC4_KEY *key, UInt32 len, Char *indata, Char *outdata) EDIT_SECTION7;

#ifdef SSLV2MD5_C
static void MD5sub_Decode(UInt32 *output, UInt8 *input, UInt16 len) EDIT_SECTION7;
static void MD5sub_Encode(UInt8 *output, UInt32 *input, UInt16 len) EDIT_SECTION7;
static void MD5Transform (UInt32 state[4], UInt8 block[64]) EDIT_SECTION7;
static void MD5_memcpy(UInt8 *output, UInt8 *input, UInt16 len) EDIT_SECTION7;
#endif // #ifdef SSLV2MD5_C

UInt16 NNshPublicEncryptRsa(UInt16 flen, UInt8 *from, UInt8 *to, NNshSSLv2Ref *sslRef) EDIT_SECTION7;
#ifdef SSLV2RSA_C
#endif // #ifdef SSLV2RSA_C

#endif // #ifdef USE_SSL_V2
#endif // #ifdef USE_SSL

#ifdef USE_MACRO
#ifdef MACRO_C
static UInt16 *macroSelectGR(NNshMacroRecord *lineData, UInt16 *gr) EDIT_SECTION8;
static void   macroDataOperation(NNshMacroRecord *lineData, UInt16 *gr, Boolean setter) EDIT_SECTION8;
static void   outputMacroLog(DmOpenRef dbRefW, UInt8 level, UInt16 code, Char *data) EDIT_SECTION8;
static Boolean checkMacroCommandAvailable(UInt16 command, UInt16 halt) EDIT_SECTION8;
static UInt16  setSourceDataDisplay(Char *buffer, NNshMacroRecord *lineData) EDIT_SECTION8;
static void   setExecFuncDataDisplay(Char *buffer, UInt16 command) EDIT_SECTION8;
#endif

void NNsi_ExecuteMacroMain(Char *macroDBName, UInt16 macroDBVersion) EDIT_SECTION8;
void NNsi_MacroDataEdit   (Char *macroDBName, UInt16 macroDBVersion) EDIT_SECTION8;
void NNsi_MacroDataView   (Char *macroDBName, UInt16 macroDBVersion) EDIT_SECTION8;
void NNsi_MacroExecLogView(Char *macroDBName, UInt16 macroDBVersion) EDIT_SECTION8;
#endif

#ifdef USE_PIN_DIA
Err  VgaFormModify_DIA(FormType *frmP, VgaFormModifyType_DIA type) EDIT_SECTION6;
void VgaFormRotate_DIA(void) EDIT_SECTION6;
#endif
