
/////////////////////////////////////////////
///// NOA からの継承値 /////////////////////////

// NOA 組込みの場合は patientId() などを直接取得できるが
// 外付けツールにも出来るようあえて以下の仕組みを使う

function _noa(){
    if (window.opener.name == "noa"){
        return window.opener;
    } else if (window.opener.name == "tools"){
        return window.top.noa;
    } else if (window.top.noa){
        return window.top.noa;
    } else {
        alert("ERROR *** tools.js: window.opener としての NOA が見つかりません");
        return null;
    }
}

function openChart(patientId, kanjiName){
    _noa().openChart(patientId, kanjiName);
}

///// NOA からの継承値 /////////////////////////
//////////////////////////////////////////////


function gotAcceptanceList(answer){
    // alert("gotAcceptanceList->"+answer); //##
    var obj = JSON.parse(answer);
    //alert("gotAcceptanceList->"+encodeObject(obj)); //##
    
    showList(obj);
}
function getAcceptanceList(){
    // 本日の受診者と、それ以後の予約者のリストをサーバへリクエスト
    NRGetAcceptanceList(todayAndTime(), gotAcceptanceList);
}

/*
var _panel;
function showList(obj){
    // 受診者リストを表示
    var elm = window.top.noa.document.getElementById("_confirm");
    _panel = elm;
	elm.innerHTML = "";
	elm.style.visibility = "visible";
	elm.style.left = 10; // 表示するx座標
	elm.style.top = 30; // 表示するy座標
	setFloatPanel(elm);
    
    var div = newDIV(elm, "");
    div.style.background = "#ccf";
    div.style.border = "thin solid #44f";
    
    // TITLE
	var tbl = newTABLE(div, "/bookingTable");
    var tr = newTR(tbl, "", "");
    tr.style.fontSize = "9pt";
    var td = newTD(tr, "/bookingTitle", "受付年月日");
    td.style.width = "140px";
    var td = newTD(tr, "/bookingTitle", "カルテID");
    td.style.width = "70px";
    var td = newTD(tr, "/bookingTitle", "氏名");
    td.style.width = "150px";
    
    var dv = newDIV(div, "");
	dv.style.height = "200px";
	dv.style.overflow = "auto";
    var tbl = newTABLE(dv, "/bookingTable");
    
    // RECORDS
    for (num in obj){
        var rec = obj[num];
        
        var tr = newTR(tbl, "", "");
        setChangeColor(tr, '#fff', '#77f');
        var action = "opneLogChart('" + rec.patientId + "','" + rec.kanjiName + "')"
        tr.setAttribute("onclick", action);
        var td = newTD(tr, "/bookingColumn", rec.entryDate);
        td.style.width = "140px";
        var td = newTD(tr, "/bookingColumn", rec.patientId + ""); // 数値だと表示されない
        td.style.width = "70px";
        var td = newTD(tr, "/bookingColumn", rec.kanjiName);
        td.style.paddingRight = "20px";
        td.style.width = "150px";
    }
    
    // FOOOTER
    var dv = newDIV(div, "");
    dv.style.background = "#55f";
    dv.style.textAlign = "right";
    dv.style.padding = "2px 5px";
    var bt = newDIV(dv, "/closeButton");
    bt.innerHTML = "X";
    bt.setAttribute("onclick", "closeFloatPanel()");
}
 */

function showList(obj){
    // 受診者リストを表示
	var elm = document.getElementById("body");
    elm.innerHTML = "";
    var div = newDIV(elm, "tableBase");
    var tbl = newTABLE(div, "bookingTable");
    tbl.style.fontSize = "9pt";
    
    // TITLE
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "/titleCol", "受付日時");
    td.style.width = "150px";
    var td = newTD(tr, "/titleCol", "カルテID");
    td.style.width = "80px";
    var td = newTD(tr, "/titleCol", "氏名");
    
    // CONTENTS
    for (num in obj){
        var rec = obj[num];
        var pid = rec.patientId;
        var name = rec.kanjiName;
        var tr = newTR(tbl, "", "");
        var td = newTD(tr, "", rec.entryDate);
        /* === リクエストによっては復活
         if (addPageStatus())
         var action = "openChart('" + pid + "','" + name + "','addPage')";
         else
         */
        var action = "openChart('" + pid + "','" + name + "')";
        td.setAttribute("onclick", action);
        if (rec.reserved * 1 > 0)
            td.setAttribute("class", "reserved");
        else if (rec.endTime && rec.endTime.toString().length)
            td.setAttribute("class", "finished");
        else
            td.setAttribute("class", "accepted");
        var td = newTD(tr, "/dataRow", rec.patientId);
        var td = newTD(tr, "", rec.kanjiName);
    }
    
    // FOOTER
    var div = newDIV(elm, "footer");
    // check box
    //    var sp = newSPAN(div, "");
    // version
    var sp = newSPAN(div, "");
    sp.style.float = "right";
    sp.style.paddingRight = "5px";
    sp.innerHTML = version();
}

function initBookingList(){
	var elm = document.getElementById("base");
    elm.innerHTML = "";
    
    // BODY
    var div = newDIV(elm, "body");

    getAcceptanceList();
}

function version(){
	return "Ver.121030";
}
