<?php
    
    function decodeSTRING($val){
        // #, &, +  < > などが URI 送信で化けるため encode して送られたものを decode
        $array = explode("%x0;", $val);
        $val = implode("#", $array);
        $array = explode("%x1;", $val);
        $val = implode("&", $array);
        $array = explode("%x2;", $val);
        $val = implode("+", $array);
        $array = explode("%x3;", $val);
        $val = implode("<", $array);
        $array = explode("%x4;", $val);
        $val = implode(">", $array);
        $array = explode("%x5;", $val);
        $val = implode(" ", $array);
        $array = explode("%x6;", $val);
        $val = implode("\n", $array);
        $array = explode("%x7;", $val);
        $val = implode("\"", $array);
        $array = explode("%x8;", $val);
        $val = implode("$", $array);
        $array = explode("%x9;", $val);
        $val = implode("\'", $array);
        return $val;
    }
    
    function leftBrackets(){
        // $leftBrackets = "\^\[\^" では誤作動
        //	return "\^\[\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        return "^[^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function rightBrackets(){
        return "^]^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        //	return "\^\]\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function decodeObject($buff){
        // "key(value)" 形式の文字列を OBJECT に decode して返す
        $obj = array();
        //	echo "decodeObject ===\n$buff\n"; //##
        for ($p=$begin=$nest=0, $len=strlen($buff); $p < $len; $p++){
            $ch = substr($buff, $p, 1);
            if (strcmp($ch, "(") == 0){
                if ($nest == 0){
                    $key = trim(substr($buff, $begin, $p - $begin)); // key 終端
                    $begin = $p + 1; // value 開始位置
                }
                $nest++;
            } else if (strcmp($ch, ")") == 0){
                if (--$nest == 0){
                    if ($nest == 0){
                        // value 終端 ( trim しない )
                        $value = substr($buff,$begin,$p-$begin);
                        $begin = $p + 1; // key 開始位置
                    }
                    if (ereg(")", $value)){ // まだ入れ子になっているなら
                        $obj[$key] = decodeObject($value);
                    } else {
                        // 特定文字を "(", ")" へ戻す
                        $array = explode(leftBrackets(), $value);
                        $value = join("(", $array);
                        $array = explode(rightBrackets(), $value);
                        $value = join(")", $array);
                        
                        $obj[$key] = $value;
                    }
                    //echo "$key{".$obj[$key]."}\n"; //##
                }
            }
        }
        return $obj;
    }
    
    function getDir($dir){
        // $dir 内のファイルをリストアップ
        $results = array();
        $array = array();
        $files = scandir($dir);
        for ($i=0,$count=count($files); $i < $count; $i++){
            $filename = $files[$i];
            if ($filename == ".") continue;
            if ($filename == "..") continue;
            if (strlen($filename) == 0) continue;
            $array[] = $filename;
        }
        rsort($array); // 逆順にソート
        $results['path'] = $dir;
		$results['files'] = $array;
        
        return $results;
    }
	
    
    // DB を開く
    // ### セキュリティーを保つには、以下のファイルを外からアクセスできない 
    // ### directory に置き、以下の cfg.php の pass をそこへ変更
    require_once('../XNOA/cfg.php');
    
    $dbc = mysql_connect($db['host'], $db['user'], $db['pwd']);
    $db_select=mysql_select_db($db['dbname']);
    mysql_query("set names utf8");
    
    $command = $_GET['command']; $command=htmlspecialchars($command);
    $value = $_GET['value']; $value=htmlspecialchars($value);
    $value = decodeSTRING($value);
    
    if ($command == "GET_DIRECTORY"){
        $args = decodeObject($value);
        $patientId = $args['patientId'];

        $dir = "../NOA_ARCHIVE/$patientId/Insurance";
        $results = getDir($dir);
        //rsort($results); // 逆順にソート
		echo "<SEPARATOR>";
		echo json_encode($results);
    } else {
        echo "<p>key( $command ) is wrong *****</p>";
    }
    
?>