
var _currentUser;
function setCurrentUser(user){
    _currentUser = user;
}
function currentUser(){
    return _currentUser;
}
function userKanjiName(){
    return noa().userKanjiName(_currentUser);
}

var _toolMenuObj;
function setToolMenuObj(obj){
    _toolMenuObj = obj;
}
function toolMenuObj(){
    // ツール・メニュー・オブジェクト
    // [{"id":"0","label":"検索","url":"search^[^^]^",,,},,,]
    if (!_toolMenuObj || (_toolMenuObj.length == 0)){
        // _toolMenuObj が空ならテンプレートを用いる
        _toolMenuObj = noa().menuTemplate();
        
        for (num in _toolMenuObj){
            var cell = _toolMenuObj[num];
            
            // menuTemplate() には id がないので num を id として cell に記憶
            // 新たに menuCell が追加される場合は最大 id が振られる
            cell.id = num;
        }
    }
    
    return _toolMenuObj;
}

//////////////////////////////////
///// Ajax ///////////////////////

function gotToolMenu(answer){
    // 読み込んだデータを toolMenuObj() へセット
    //alert(answer); //##
    var obj = JSON.parse(answer);
    //alert(encodeObject(obj)); //##
    
    setToolMenuObj(obj);
    
    showToolLayout();
}
function getToolMenu(user){
    // TOOL MENU 構造をサーバへリクエスト
    NRGetToolMenu(user, gotToolMenu);
}

///// Ajax ///////////////////////
//////////////////////////////////


//////////////////////////////////////////////
///// ARCHIVE TOOL MENU //////////////////////

function gotToolMenuArchives(answer){
    var obj = JSON.parse(answer);
    var path = obj.path; // "../Users/ohashi/TOOL_MENU"
    var filenames = obj.files; // ["20120905164838.txt","20120905163836.txt"]
    
    showBackup(filenames);
}
function getToolMenuArchives(){
    // TOOL MENU のアーカイブファイル・リストをサーバへリクエスト
    var elm = document.getElementById("workArea");
    if (elm.innerHTML.length){ // toggle 式に開閉
        elm.innerHTML = "";
        return;
    }
    
    NRGetArchiveFiles(currentUser(), "TOOL_MENU", gotToolMenuArchives);
}

function gotBackup(answer){
    // 読み込んだアーカイブを toolMenuObj() へセット
    //alert("gotBackup->"+answer); //##
    var obj = JSON.parse(answer);
    setToolMenuObj(obj);
    
    var array = new Array();
    // 全ての cell.number を打ち直す：更新 CELL の number が以前と変わらない場合は
    // その CELL だけの更新でもよいのだが、工場出荷状態の場合、更新 CELL 以外の CELL が
    // DB に保存されないという問題があるので常に全部を更新する。
    var records = toolMenuObj();
    for (num in records){
        var oldCell = records[num];
        var newCell = new Object();
        
        // oldCell 属性を newCell にコピー
        for (key in oldCell)
            newCell[key] = oldCell[key];
        
        // 整列順序:number を打ち直す
        newCell.number = num;
        array[num] = newCell;
    }
    //alert("gotBackup array->"+array); //##
    
    // バックアップで更新された toolMenuObj() をサーバへ保存
    NRPutToolMenu(currentUser(), array, replacedMenuCell);
}
function getBackup(){
    // TOOL MENU のアーカイブファイルをサーバへリクエスト
    var filename = document.getElementById("fileNamePop").value;
    NRGetArchiveFile(currentUser(), "TOOL_MENU", filename, gotBackup);
}

function removedArchiveFile(answer){
    //alert(answer); //##
    document.getElementById("workArea").innerHTML = ""; // 削除しないと toggle
    getToolMenuArchives();
}
function removeArchiveFile(){
    // アーカイブ・ファイルを削除
    var filename = document.getElementById("fileNamePop").value;
    if (confirm(filename+" を削除していいですか"))
        NRRemoveArchiveFile(currentUser(), "TOOL_MENU", filename, removedArchiveFile);
}

function removedScrapFiles(answer){
    //alert(answer);
    var array = JSON.parse(answer);
    
    _initDebug(true); //##
    for (num in array){
        _debug(array[num]); //##
    }
}
function removeScrapFiles(){
    // サーバに残る削除済みファイルを全部削除
    if (confirm("確実にゴミ箱を空にしていいですか"))
        NRRemoveScraps(currentUser(), "TOOL_MENU", removedScrapFiles);
}

function showBackup(filenames){
    // バックアップ操作ペーンを開く
    var elm = document.getElementById("workArea");
    elm.innerHTML = "";
    
    var div = newDIV(elm, "");
    div.style.fontSize = "9pt";
    div.style.fontFamily = "arial, Helvetica";
    div.style.padding = "15px 15px";
    div.style.background = "#ffd";
    div.style.border = "thin solid #833";
    div.style.color = "#833"; // brown

    var dv = newDIV(div, "");
    dv.style.marginBottom = "5px";
    var sp = newSPAN(dv, "removeLogIcon");
    sp.style.marginRight = "5px";
    setInfoTip("removeLogIcon", "右で選択されたバックアップ・ファイルを削除"); // HELP
    var img = newIMAGE(sp, "", "./remove-field.png", "X");
    img.style.height = "11px";
    img.setAttribute("onclick", "removeArchiveFile()");
    
    // ファイル名が _ で始まる削除済みファイルを抜いたものをポップアップ表示
    var array = new Array();
    for (num in filenames){
        var name = filenames[num];
        if (name.charAt(0) == "_") continue;
        
        array.push(name);
    }
    var pm = makePopupMenu(dv, "fileNamePop", array, "");
    setInfoTip("fileNamePop", "過去のバックアップ・ファイル"); // HELP
    
    var bt = newBUTTON(dv, "", "から復元");
    bt.setAttribute("onclick", "getBackup()");
    
    var dv = newDIV(div, "");
    dv.style.marginBottom = "5px";
    var sp = newSPAN(dv, "removeAllIcon");
    sp.style.marginRight = "5px";
    setInfoTip("removeAllIcon", "サーバに残る削除済みファイルを全部削除"); // HELP
    var img = newIMAGE(sp, "", "./remove-field.png", "X");
    img.style.height = "11px";
    img.setAttribute("onclick", "removeScrapFiles()");
    var sp = newSPAN(dv, "");
    sp.innerHTML = "削除され不可視状態のファイルを全部削除";
    
    // 工場出荷状態へ戻す
    var dv = newDIV(div, "");
    dv.innerHTML = "ツール・メニューを ";
    var bt = newBUTTON(dv, "", "工場出荷状態に戻す");
    bt.setAttribute("onclick", "originalToolLayout()");
    
    // ページ末尾にジャンプ
    var pos = getPosition(bt.parentNode.parentNode);
    window.scroll(0, pos.y);
}

///// ARCHIVE TOOL MENU //////////////////////
//////////////////////////////////////////////



var _currentMenuCell;
function menuCellClicked(type, num){
    // メニュー・カスタマイズ用セルがクリックされた
    if (_currentMenuCell){
        if (_currentMenuCell.num == num){
            // 編集画面を閉じる
            _currentMenuCell = null;
            menuCell(type, num);
        } else {
            alert("他の「編集中メニュー」を閉じてから開いてください");
        }
    } else {
        // menuCell を編集モードにする
        _currentMenuCell = new Object();
        _currentMenuCell.type = type;
        _currentMenuCell.num = num;
        
        menuCell(type, num, true);
    }
}

function addMenuCell(type, num){
    // num の次行に新しい menuCell を挿入
    var newNum = (num * 1) + 1;
    
    // new CELL を toolMenuObj() に登録
    var array = toolMenuObj();
    var cell = new Object();
    cell.menuType = type;
    cell.label = "new label";
    cell.url = "" + newNum;  //### TEST
    cell.id = maxId(array);
    cell.isNew = true;
    array.splice(newNum, 0, cell);
    setToolMenuObj(array); // toolMenuObj() は 明示的セットの要あり
    
    // toolMenuObj に新しい menuCell を挿入し menuCell 編集画面を再描画
    showToolLayout();
    
    function maxId(array){
        // 現存する cell の最大 id を返す
        var max = 0;
        for (num in array){
            var cell = array[num];
            if (cell.id * 1 > max) max = cell.id * 1;
        }
        return max + 1;
    }
}

function redrawTooLayout(answer){
    // menuLayout を再表示
    var obj = JSON.parse(answer);
    
    noa().setMenuStructure(obj);
    openToolLayout();
}
function removedMenuCell(answer){
    // menuCell レイアウト編集画面を再表示
    //alert(answer); //##
    
    NRGetToolMenu(currentUser(), redrawTooLayout);
}
function removeMenuCell(id, label){
    // type, num の menuCell を削除
    if (confirm(id + ": " + label + "を削除していいですか")){
        // id の menuCell をサーバから削除
        // ##### id の不整合があるために削除できない？ #####
        NRRemoveToolMenu(currentUser(), label, removedMenuCell);
    }
}

function cancelMenuCell(type, num){
    // menuCell 編集パネルを閉じる
    _currentMenuCell = null;
    menuCell(type, num);
}

function replacedMenuCell(answer){
    //alert(answer); // ”メニュー構造を保存しました” のメッセージ
    _currentMenuCell = null;
    
    // layoutArray() を再読み込みするためブラウザーをリロード
    noa().window.location.reload(true);
}
function replaceMenuCell(type, num){
    // menuCell の内容を編集したものに置換
    _initDebug(false); //##
    
    var cell = toolMenuObj()[num];
    cell.menuType = type * 1;
    cell.label = document.getElementById("labelF").value;
    cell.url = document.getElementById("urlF").value;
    var elm = document.getElementById("iconF");
    cell.icon = (elm) ? elm.value : "";
    var elm = document.getElementById("infoTipF");
    cell.editor = (elm) ? elm.value : "";
    cell.subTitle = (document.getElementById("isSubTitleCheck").checked) ? "1" : "";
    var elm = document.getElementById("windowCheck");
    cell.window = (elm && elm.checked) ? "1" : "";
    var elm = document.getElementById("disabledCheck");
    cell.disabled = (elm && elm.checked) ? "1" : "";
    cell.id = document.getElementById("idNode").innerHTML;
    cell.number = num;
    
    _debug("<p>Edit CELL ->"+ encodeObject(cell)+"</p>"); //##
    
    var array = new Array();
    // 全ての cell.number を打ち直す：更新 CELL の number が以前と変わらない場合は
    // その CELL だけの更新でもよいのだが、工場出荷状態の場合、更新 CELL 以外の CELL が
    // DB に保存されないという問題があるので常に全部を更新する。
    var records = toolMenuObj();
    for (num in records){
        var oldCell = records[num];
        var newCell = new Object();
        
        // oldCell 属性を newCell にコピー
        for (key in oldCell)
            newCell[key] = oldCell[key];
        
        // 整列順序:number を打ち直す
        newCell.number = num;
        array[num] = newCell;
        _debug(newCell.label+"-> "+encodeObject(newCell)); //##
    }
    
    NRPutToolMenu(currentUser(), array, replacedMenuCell);
}

function menuCell(type, num, isActive){
    // menu 属性入力ペーンを生成
    var cell = toolMenuObj()[num];
    var isSubTitle = (cell.subTitle && (cell.subTitle * 1)) ? true : false;
    var isDefaultMenu = (cell.fix && (cell.fix * 1)) ? true : false;
    
    var div = document.getElementById(num + ".row");
    div.innerHTML = "";
    if (isSubTitle)
        div.setAttribute("class", "subMenuType");
    else
        div.setAttribute("class", "menuType");
    
    var tbl = newTABLE(div, "base-table");
    tbl.style.fontSize = "10pt";
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "", "");
    td.style.width = "25px";
    td.style.verticalAlign = "top";
    // 追加アイコン
    var sp = newSPAN(td, "addMenuIcon");
    sp.style.paddingLeft = "5px";
    sp.style.paddingRight = "5px";
    setInfoTip("addMenuIcon", "次行に新規メニューを追加"); // HELP　うまく作動しない
    var img = newIMAGE(sp, "", "./add-field.png", "X");
    img.style.height = "12px";
    img.setAttribute("onclick", "addMenuCell('"+type+"','"+num+"')");
    var td = newTD(tr, "", "");
    var dv = newDIV(td, "");
    
    if (isActive){ // 編集モードの menuCell
        // LABEL
        var sp = newSPAN(dv, "");
        sp.style.paddingRight = "5px";
        sp.innerHTML = "LABEL";
        sp.setAttribute("onclick", "menuCellClicked('"+type+"','"+num+"')");
        setChangeColor(sp, '#000', (isSubTitle) ? '#fe5' : '#ffd');
        var sp = newSPAN(dv, "");
        var fd = newFIELD(sp, "labelF", "", 20, cell.label);
        if (! isDefaultMenu){
            // 固定メニュー以外なら削除アイコンを表示
            var sp = newSPAN(dv, "removeMenuIcon");
            sp.style.paddingLeft = "5px";
            sp.style.paddingRight = "5px";
            setInfoTip("removeMenuIcon", "このメニューを削除"); // HELP　うまく作動しない
            var img = newIMAGE(sp, "", "./remove-field.png", "X");
            img.style.height = "11px";
            var action = "removeMenuCell('"+cell.id+"','"+cell.label+"')";
            img.setAttribute("onclick", action);
        }
        // URL
        var dv = newDIV(td, "");
        var fd = newFIELD(dv, "urlF", "URL", 40, (cell.url) ? cell.url : "");
        // 別ウインドー・アイコン
        if (!isSubTitle){
            // アイコン指定
            var dv = newDIV(td, "");
            var fd = newFIELD(dv, "iconF", "ICON", 30, (cell.icon) ? cell.icon : "");
            // infoTip
            var dv = newDIV(td, "");
            var fd = newFIELD(dv, "infoTipF", "HELP", 40, (cell.editor) ? cell.editor : "");
            // 非表示チェックボックス
            var dv = newDIV(td, "");
            var status = (cell.disabled * 1) ? 1 : 0;
            var cb = newCHECKBOX(dv, "disabledCheck", "非表示", status);
            // 別ウインドー・チェックボックス
            var dv = newDIV(td, "");
            var status = (cell.window * 1) ? 1 : 0;
            var cb = newCHECKBOX(dv, "windowCheck", "別ウインドーとして表示", status);
        }
        // サブ・タイトル か メニューかの設定チェック
        var dv = newDIV(td, "");
        var cb = newCHECKBOX(dv, "isSubTitleCheck", "サブ・タイトル", isSubTitle);
        // default の固定メニュー
        var dv = newDIV(td, "");
        var cb = newCHECKBOX(dv, "", "default menu", (isDefaultMenu) ? 1 : 0);
        cb.setAttribute("disabled", "true");
        
        // FOOTER
        var dv = newDIV(td, "");
        dv.style.color = "#888";
        dv.style.textAlign = "right";
        // cell.id
        var sp = newSPAN(dv, "");
        sp.innerHTML = "id: ";
        var sp = newSPAN(dv, "idNode");
        sp.innerHTML = cell.id;
        sp.style.paddingRight = "10px";
        // とりやめボタン
        var bt = newBUTTON(dv, "", "とりやめ");
        bt.setAttribute("onclick", "cancelMenuCell('"+type+"','"+num+"')");
        // 確定ボタン
        var bt = newBUTTON(dv, "", "確定");
        bt.setAttribute("onclick", "replaceMenuCell('"+type+"','"+num+"')");
    } else { // 参照モードの menuCell
        td.style.color = (cell.disabled * 1) ? "#aaa" : "#000";
        // LABEL
        var sp = newSPAN(dv, "");
        sp.style.paddingRight = "5px";
        sp.innerHTML = cell.label;
        sp.setAttribute("onclick", "menuCellClicked('"+type+"','"+num+"')");
        setChangeColor(sp, '#000', (isSubTitle) ? '#fe5' : '#ffd');
        
        // 削除アイコン
        if (! isDefaultMenu){
            // 固定メニュー以外なら削除アイコンを表示
            var sp = newSPAN(dv, "removeMenuIcon2");
            sp.style.paddingLeft = "5px";
            sp.style.paddingRight = "5px";
            setInfoTip("removeMenuIcon2", "このメニューを削除"); // HELP
            var img = newIMAGE(sp, "", "./remove-field.png", "X");
            img.style.height = "11px";
            var action = "removeMenuCell('"+cell.id+"','"+cell.label+"')";
            img.setAttribute("onclick", action);
        }
        // URL
        if (cell.url && !isSubTitle){
            var dv = newDIV(td, "");
            dv.style.paddingLeft = "5px";
            dv.innerHTML = cell.url;
        }
    }
}

function doneOriginalToolLayout(answer){
    //alert(answer);
    
    // layoutArray() を再読み込みするためブラウザーをリロード
    noa().window.location.reload(true);
}
function originalToolLayout(){
    if (confirm("メニュー構造を工場出荷状態に戻していいですか"))
        NRRemoveToolMenu(currentUser(), null, doneOriginalToolLayout);
}

function toolMenuEditorHelp(){
	window.open("./toolMenuEditorHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function showToolLayout(){
    // ツールのレイアウトの編集画面を表示
	var elm = document.getElementById("base");
	elm.innerHTML = "";
    
    ///// TITLE AREA ////////////////////////////
    var div = newDIV(elm, "yellow-bar");
    var tbl = newTABLE(div, "base-table");
    tbl.style.fontSize = "10pt";
    tbl.style.color = "#666";
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "left-side", "");
    var sp = newSPAN(td, "toolEditorInfo");
    sp.innerHTML = "TOOL MENU 編集パネル";
    setInfoTip("toolEditorInfo", "NOA へ周辺ツールを組込むことができます"); // HELP
    var td = newTD(tr, "right-side", "");
    td.style.width = "20px";
    var img = newIMAGE(td, "", "./Help.png", "X");
    img.style.height = "18px";
    img.setAttribute("onclick", "toolMenuEditorHelp()");
    
    ///// WORK AREA /////////////////////////////
    var div = newDIV(elm, "");
    div.style.fontSize = "10pt";
    
    // MAIN TOOL BAR
    var dv = newDIV(div, "separate-bar");
    var sp = newSPAN(dv, "");
    sp.style.paddingRight = "3px";
    var img = newIMAGE(sp, "", "./add-field.png", "X");
    img.style.height = "12px";
    img.setAttribute("onclick", "addMenuCell('"+_main+"','"+(-1)+"')");
    var sp = newSPAN(dv, "");
    sp.style.paddingLeft = "10px";
    sp.innerHTML = "NOA ヘッダーに組込む";
    
    var obj = toolMenuObj();
    for (num in obj){
        var cell = obj[num];
        if (cell.menuType == _main){
            var dv = newDIV(div, num + ".row");
            menuCell(_main, num);
        }
    }
    
    // PAGE TOOL BAR
    var dv = newDIV(div, "separate-bar");
    var sp = newSPAN(dv, "");
    sp.style.paddingRight = "3px";
    var img = newIMAGE(sp, "", "./add-field.png", "X");
    img.style.height = "12px";
    img.setAttribute("onclick", "addMenuCell('"+_page+"','"+(-1)+"')");
    var sp = newSPAN(dv, "");
    sp.style.paddingLeft = "10px";
    sp.innerHTML = "ページ・ヘッダーに組込む";
    
    for (num in obj){
        var cell = obj[num];
        if (cell.menuType == _page){
            var dv = newDIV(div, num + ".row");
            menuCell(_page, num);
        }
    }
    
    // TOOL BAR
    var dv = newDIV(div, "separate-bar");
    var sp = newSPAN(dv, "");
    sp.style.paddingRight = "3px";
    var img = newIMAGE(sp, "", "./add-field.png", "X");
    img.style.height = "12px";
    img.setAttribute("onclick", "addMenuCell('"+_tool+"','"+(-1)+"')");
    var sp = newSPAN(dv, "");
    sp.style.paddingLeft = "10px";
    sp.innerHTML = "ツール・エリアの TOOL MENU に組込む";
    
    for (num in obj){
        var cell = obj[num];
        if (cell.menuType == _tool){
            var dv = newDIV(div, num + ".row");
            menuCell(_tool, num);
        }
    }
    
    // FOOTER
    var dv = newDIV(div, "yellow-bar");
    dv.style.fontSize = "9pt";
    dv.style.textAlign = "right";
    dv.style.paddingRight = "10px";
    var a = newA(dv, "TOOL MENU のバックアップ", "#", "");
    a.setAttribute("onclick", "getToolMenuArchives()");
    
    // WORK AREA
    var dv = newDIV(elm, "workArea");
}

function readToolMenu(){
    // TOOL MENU 構造を読み込む
    var kanjiName = document.getElementById("userPop").value;
    var user = noa().loginNameForkanjiName(kanjiName);
    
    setCurrentUser(user);
    
    // TOOL MENU 構造をサーバへリクエスト
    getToolMenu(user);
}

function openToolLayout(){
    // 初期設定パネルを開く前にユーザ・セレクターで対象ユーザを特定
    var elm = document.getElementById("base");
    elm.innerHTML = "";
    
    var div = newDIV(elm, "yellow-bar");
    div.style.height = "25px";
    div.style.fontSize = "9pt";
    div.style.paddingLeft = "10px";
    
    // ユーザ名選択ポップアップ
    var owner = noa().owner();
    var kanjiName = noa().userKanjiName(owner);
    var pu = makePopupMenu(div, "userPop", noa().userKanjiNames(), kanjiName);
    
    var sp = newSPAN(div, "tip-left");
    sp.innerHTML = "の TOOL MENU 設定を";
    
    // LOAD BUTTON
    var bt = newBUTTON(div, "", " 読 込 ");
    bt.setAttribute("onclick", "readToolMenu()");
}



