
////////////////////////////////
///// NOA へ問い合わせて得る値 /////

function _noa(){
	// window.opener が NOA なら NOA を返す
    if (window.opener && (window.opener.name == "noa")){
        return window.opener;
    } else if (window.opener && (window.opener.name == "tools")){
        return window.top.noa;
    } else if (window.opener && (window.top.noa)){
        return window.top.noa;
    } else {
        //alert("親として NOA が見つかりません");
        return null;
    }
}

function patientId(){
	if (_noa()){
        return (_noa().noaType() == "NOA8G")
            ? _noa().patient_id() : _noa().patientId();
	} else
		return "";
}

function anotherId(){
	if (_noa()){
		var aid = _noa().valueForTag("PatientTable.anotherId");
		return (aid) ? aid : "";
	} else
		return "";
}

function patientKanjiName(){
	if (_noa())
		return _noa().valueForTag("NameSection.patientKanjiName");
	else 
		return "";
}

var _owner;
function setOwner(name){
	_owner = name;
}
function owner(){
	if (_owner)
		return _owner;
	else if (_noa()){
		setOwner(_noa().owner());
		return _noa().owner();
	} else
		return "";
}

///// NOA へ問い合わせて得る値 /////
////////////////////////////////

var _records;
function setRecords(obj){
	_records = obj;
}
function records(){
	return _records;
}
function recordForId(pid){
	// pid の含まれるレコードを返す
	for (num in _records){
		var rec = _records[num];
		if (rec.patientId == pid)
			return rec;
	}
	return null;
}

/////////////////////////////////////////////
///// neuron.js を介したサーバとの通信 ///////////

function gotRemind(answer){
	// リマインダーの内容をサーバから受け取る
	//alert("=== gotRemind\n"+answer); //##
	
	// CONTENTS
	var obj = eval('(' + answer + ')');

    setRecords(obj);
	showRemind();
}
function getRemind(){
	// リマインダーの内容をリクエスト
	var pid = "";
	NRgetRemind(pid, 0, owner(), gotRemind);
}

function puttedRemind(answer){
	// リマインダーの内容をサーバから受け取る
	//alert("=== puttedRemind\n"+answer); //##
	closeFloatPanel();
	getRemind();
}
function addRecord(pid){
	// pid のデータをサーバへ書き込む
	var memo = document.getElementById("memo").value;
	
	NRputRemind(pid, 0, owner(), memo, puttedRemind);
}

function deleteRemind(pid){
	// pid のデータをサーバから削除
	var name = recordForId(pid).patientKanjiName;
	
	if (confirm(pid + " " + name + " のレコードを削除していいですか")){
		// 空データを送れば削除になる
		NRputRemind(pid, 0, owner(), "", puttedRemind);
	}
}

///// neuron.js を介したサーバとの通信 ///////////
/////////////////////////////////////////////


function showEditPanel(pid){
	// pid の編集パネルを開く
	var name = "";
	var value = "";
	var date = "";
	var rec = recordForId(pid);
    
	if (rec){
		name = rec.patientKanjiName;
		value = rec.dataString;
		date = " ( " + rec.updateTime + " )";
	} else if (pid == patientId()){
		name = patientKanjiName();
	}

	// データ編集パネルを生成
	var elm = document.getElementById("_floatPanel");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "base-table");
	
	var tr = newTR(tbl, "", "");
	tr.style.fontSize = "10pt";
	var td = newTD(tr, "", pid + " " + name + date);
	td.style.textAlign = "center";
	
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	var ta = newTEXTAREA(td, "memo", 50, 10, value);
	
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
    td.style.textAlign = "right";
	var bt = newBUTTON(td, "", "確定");
	bt.setAttribute("onclick", "addRecord('" + pid + "')");
	
	var x = 5;
	var y = 5;
	openFloatPanel(tbl, x, y, "編集パネル");
    
    ta.focus();
}

function newRecord(){
	// 新規レコードを追加
	if (! _owner){
		var owner = prompt("owner を入力してください", "");
		if (owner.length > 0)
			setOwner(owner);
		else
			return;
	}
	
	var pid = prompt("覚書の対象となる「カルテID」", patientId());
	if (pid.length){
		showEditPanel(pid);
	}
}

function showRemind(){
	// remind のコンテンツを表示
	var elm = document.getElementById("historyArea");
	elm.innerHTML = "";
    
	var obj = records();
	if (obj){
		for (num in obj){
			var rec = obj[num];
            
            var dl = newDL(elm, "/row");
            
            // 患者情報
			var dt = newDT(dl, "");
            var header = newDIV(dt, "/header");
			header.setAttribute("onclick","showEditPanel('" + rec.patientId + "')");
            
            var dv = newDIV(header, "/patientInfo");
            dv.innerHTML = rec.patientId + " " + rec.patientKanjiName;
            
            var dv = newDIV(header, "/updateTime");
            dv.innerHTML = rec.updateTime + " ";
            
			var im = newIMAGE(dv, "", "./remove-field.png", "?");
			im.style.height = "11px";
			im.style.verticalAlign = "top";
			im.setAttribute("onclick", "deleteRemind('" + rec.patientId + "')");
            
            // コメント
            var dd = newDD(dt, "/clearBoth");
            var dv = newDIV(dd, "/comment");
            dv.innerHTML = rec.dataString;
		}
	}
}

function help(){
	// 別途ヘルプをパネル表示
	window.open("./reminderHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initReminder(){
	var elm = document.getElementById("base");
    
    // === HEADER =================
    var div = newDIV(elm, "title-bar");
    var dv = newDIV(div, "left-side");
    dv.innerHTML = "リマインダー";
    var dv = newDIV(div, "right-side");
	var im = newIMAGE(dv, "", "./Help.png", "?");
	im.setAttribute("onclick", "help()");
	im.style.height = "16px";
    
	// === リスト表示エリア ==========
    var div = newDIV(elm, "historyArea");
    
    // === FOOTER =================
    var div = newDIV(elm, "title-bar");
    var dv = newDIV(div, "left-side");
    var bt = newDIV(dv, "accessLog/greenButton");
    bt.innerHTML = "新規メモ";
    bt.style.position = "relative";
    bt.style.top = "2px"; // ボタン位置調整
    bt.setAttribute("onclick", "newRecord()");
    var dv = newDIV(div, "right-side");
    dv.innerHTML = version();

	// 過去の伝票を検索しリストアップ
	getRemind();
}

function version(){
	return "Ver.121111";
}
