
var _debug_mode;
function _initDebug(status){
    // デバッグ・メッセージ領域をクリア
    document.getElementById("_debug").innerHTML = "";
    _debug_mode = (status) ? true : false;
}
function _isDebugMode(){
    return _debug_mode;
}
function _debug(st){
    // メッセージ領域に st を追加表示
    
    // ### debug message を出さないようにするにはこの行を生かす ###
    if (!_debug_mode) return;
    
    if (st == "_CLEAR_"){
        // メッセージ領域を初期化
        document.getElementById("_debug").innerHTML = "";
    } else {
        var elm = document.getElementById("_debug");
        var buff = elm.innerHTML;
        elm.innerHTML = buff + st + "<br/>";
    }
}

var _offsetX;
var _offsetY;
var _cursorLocked;
function cursorLock(){ // mouse down
	_cursorLocked = true;
}
function cursorUnlock(){ // mouse up
	_cursorLocked = false;
}
function getMouseXY(evt){
	// マウスでパネルのタイトルを掴み移動させる
	// Firefox ではうまく動作しない
	if (_cursorLocked){ // mouse down
		var elm = document.getElementById("_confirm");
		elm.style.left = evt.clientX - _offsetX; // 表示するx座標
		elm.style.top = evt.clientY - _offsetY; // 表示するy座標
	} else { // mouse up
		// layerX layerY は Firefox のみの独自規格で、他のブラウザーは
		// offsetX offsetY だが、最近は Safari でも layerX layerY が動く
		// Firefox では evt.x evt.y は動かない
		_offsetX = evt.layerX;
		_offsetY = evt.layerY;
	}
}

function closeConfirm(){
	// 確認パネルを閉じる
	var elm = document.getElementById("_confirm");
	elm.style.visibility = "hidden";
	// マウス・イベントが横取りされないようワークスペース外に押し出しておく
	// ## サイズ変更や disabled などやってみたが、不具合が出る
	elm.style.top = 1000;
	window.onmousemove = false; // マウス制御を解除しておく
}
function openConfirm(x, y, title, buff, bottonLabel){
	// 確認パネルを開く
	// ## あらかじめ base に _confirm エレメントの埋め込みが必要
	window.onmousemove = getMouseXY;
	var elm = document.getElementById("_confirm");
	elm.style.left = x; // 表示するx座標
	elm.style.top = y; // 表示するy座標
	elm.style.visibility = "visible";
	elm.style.fontFamily = "arial, Helvetica";
	elm.innerHTML = "";
	
	var tbl = newTABLE(elm, "");
	tbl.style.border = "thin solid #888";
//	tbl.style.backgroundColor = "#fff";
	
	var tr = newTR(tbl, "", ""); // header
	tr.style.backgroundColor = "#ec9";
	tr.style.color = "#000";
	tr.setAttribute("onmousedown", "cursorLock()");
	tr.setAttribute("onmouseup", "cursorUnlock()");
	var td = newTD(tr, "", "");
	td.style.fontSize = "10pt";
	td.style.height = "23px";
	td.style.paddingTop = "3px";
	td.style.paddingLeft = "5px";
	var im = newIMAGE(td, "icon", "./close.png", "?");
	im.setAttribute("onclick", "closeConfirm()");
    im.style.height = "12px";
	im.style.position = "relative";
	im.style.top = "1px";
    var sp = newSPAN(td, "");
    sp.style.paddingLeft = "5px";
    sp.innerHTML = title;
	
	var tr = newTR(tbl, "", ""); // contents
	var td = newTD(tr, "_conrirmContets", "");
	td.innerHTML = buff;
	if (bottonLabel.length){
		var tr = newTR(tbl, "", ""); // controls
	//	tr.style.backgroundColor = "#ccc";
		var td = newTD(tr, "", "");
		td.style.padding = "0px 5px";
		td.style.textAlign = "right";
		// ボタンのアクションは _confirmButton を元に外部から与える
		var bt = newBUTTON(td, "_confirmButton", bottonLabel);
	}
}

function openInfo(x, y){
	// 確認パネルを開く
	// ## あらかじめ base に _confirm エレメントの埋め込みが必要
	window.onmousemove = getMouseXY;
	var elm = document.getElementById("_confirm");
	elm.style.left = x; // 表示するx座標
	elm.style.top = y; // 表示するy座標
	elm.style.visibility = "visible";
	elm.style.fontFamily = "arial, Helvetica";
	elm.style.backgroundColor = "#fff";
	elm.innerHTML = "";
	
	var tbl = newTABLE(elm, "");
	tbl.style.border = "thin solid #888";
	tbl.setAttribute("onmousedown", "cursorLock()");
	tbl.setAttribute("onmouseup", "cursorUnlock()");
	
	var tr = newTR(tbl, "", ""); // contents
	var td = newTD(tr, "_conrirmContets", "");
}

function newTABLE(elm, id){
	// elm の下に TABLE を生成して返す
	var tbl = document.createElement('TABLE');
	if (id.length) tbl.setAttribute("ID", id);
	elm.appendChild(tbl); 
	return tbl;
}

function newTEXT(elm, value){
	// elm の下に TEXT を生成して返す
	var tx = document.createTextNode(value);
	elm.appendChild(tx); 
	return tx;
}

function newTR(elm, id, label){
	// elm の下に <TR></TR> を生成して返す
	var tr = document.createElement('TR');
	if (id.length) tr.setAttribute("ID", id);
	elm.appendChild(tr); 
	if (label == null) label = "";
	if (label.length){
		var td = document.createElement('TD');
		tr.appendChild(td); 
		var tx = document.createTextNode(label);
		td.appendChild(tx); 
	}
	return tr;
}	

function newTD(elm, id, label){
	// elm の下に <TD></TD> を生成して返す
	var td = document.createElement('TD');
	if (id.length) td.setAttribute("ID", id);
	if (label == null) label = "";
	if (label.length){
		var tx = document.createTextNode(label);
		td.appendChild(tx); 
	}
	elm.appendChild(td); 
	return td;
}	

function newDIV(elm, id){
	// elm の下に DIV を生成して返す
	var dv = document.createElement('DIV');
	if (id.length) dv.setAttribute("ID", id);
	elm.appendChild(dv); 
	return dv;
}	

function newFIELD(elm, id, label, size, value){
	// 入力フィールドを生成
	if (label.length){
		newTEXT(elm, label);
	}
	var ip = document.createElement('INPUT');
	ip.setAttribute("TYPE", "text");
	if (id.length) ip.setAttribute("ID", id);
	ip.setAttribute("SIZE", size);
	ip.setAttribute("VALUE", value);
	elm.appendChild(ip); 
	
	return ip;
}

function newTEXTAREA(elm, id, cols, rows, value){
	// TEXTAREAを生成
	var ip = document.createElement('TEXTAREA');
	if (id.length) ip.setAttribute("id", id);
	ip.setAttribute("id", id);
	ip.setAttribute("COLS", cols);
	ip.setAttribute("ROWS", rows);
	elm.appendChild(ip); 
	var tx = document.createTextNode(value);
	ip.appendChild(tx); 
	
	return ip;
}

function newHIDDEN(elm, id, value){
	var ip = document.createElement('INPUT');
	elm.appendChild(ip); 
	ip.setAttribute("TYPE", "hidden");
	ip.setAttribute("VALUE", value);
	if (id.length) ip.setAttribute("ID", id);
	
	return ip;
}

function newBUTTON(elm, id, label){
	// ボタンを生成
	var ip = document.createElement('INPUT');
	ip.setAttribute("TYPE", "button");
	ip.setAttribute("VALUE", label);
	if (id.length) ip.setAttribute("ID", id);
	elm.appendChild(ip); 
	
	return ip;
}

function newSPAN(elm, id){
	// elm の下に span を生成して返す
	var sp = document.createElement('span');
	if (id.length) sp.setAttribute("id", id);
	elm.appendChild(sp); 
	return sp;
}	

function newA(elm, label, href, target){
	var a = document.createElement('A');
	elm.appendChild(a); 
	a.href=href;
	if (target.length) a.target=target;
	newTEXT(a, label);
	
	return a;
}

function makePopupMenu(elm, id, array, selectedItem){
	var sl = document.createElement('SELECT');
	sl.setAttribute("ID", id);
	elm.appendChild(sl);
	
	var count = array.length;
	for (var i=0; i < count; i++){
		var title = array[i];
		var op = document.createElement('OPTION');
		tx = document.createTextNode(title); 
		op.appendChild(tx); 
		op.setAttribute("value",title); 
		sl.appendChild(op); 
		if (title == selectedItem){
			// op.setAttribute("selected"); -- FireFox では動かない
			op.setAttribute("selected", true);
		}
	}
	return sl;
}

function newIMAGE(elm, id, src, alt){
    var img = document.createElement('IMG');
	elm.appendChild(img); 
	img.setAttribute("ID", id);
	img.setAttribute("SRC", src);
	img.setAttribute("ALT", alt);
	
	return img;
}


