
///////////////////////////////////////
///// NOA へ問い合わせて得る値 /////////////

function noa(){
    if (window.opener.name == "noa"){
        return window.opener;
    } else if (window.top.noa){
        return window.top.noa;
    } else {
        alert("ERROR *** window.opener としての NOA が見つかりません");
        return null;
    }
}

function patientId(){
	return (noa().noaType() == "NOA8G") ? noa().patient_id() : noa().patientId();
}

function patientName(){
	return noa().valueForTag("NameSection.patientKanjiName");
}

function owner(){
	return noa().owner();
}

///// NOA へ問い合わせて得る値 /////////////
///////////////////////////////////////


var _separator=',';

var _records;
var _templateNames;
function setRecords(obj){
	// テンプレート object の入った配列を記憶
	//alert("setRecords->"+encodeObject(obj)); //##
    
	_records = obj;
	_templateNames = [""];
	for (menuItem in obj){
		_templateNames.push(menuItem);
	}	
}
function records(){
    return _records;
}
function recordForKey(menuItem){
	// menuItem に対応するオブジェクトを返す
	// array = [owner, value, public, freq]
    if (!_records) return null;
        
	var obj = _records[menuItem];
	return (obj) ? obj : null;
}
function freqForKey(menuItem){
	// menuItem に対応するオブジェクトを返す
	// array = [owner, value, public, freq]
    if (!_records) return 0;
    
	var obj = _records[menuItem];
	return (obj) ? obj.freq : 0;
}
function templateNames(){
	// テンプレート名の配列を返す
	return _templateNames;
}

var _labels;
function setLabels(value){
	_labels = value.split(",");
}
function labels(){
    // マトリックス表示のタイトルになるラベルの配列
	return _labels;
}

///////////////////////////
/// Ajax による処理 /////////

function savedTemplate(answer){
	//alert("savedTemplate:"+answer);
	var obj = eval('(' + answer + ')');
	//alert(encodeObject(obj)); //##
    
	closeConfirm();
	getTemplates();
}
function saveTemplate(){
	var name = trim(document.getElementById("templateF").value);
	if (name.length == 0){
		alert("テンプレート名が設定されていません");
		return;
	}
	var buff = trim(document.getElementById("labelF").value);
	if (buff.length == 0){
		alert("ラベル名が指定されていません");
		return;
	}
	
	// label 区切りを改行からカンマに変換してサーバに送る
	var array = buff.split('\n');
	var items = array.join(_separator);
    
	// これらの値を DB に記憶
	var freq = freqForKey(name);
    
    //alert("saveTemplate->"+name+"->"+freq+"=>"+items); //##
    
	NRPutMenu(owner(),"PICKUP",name,freq,items,savedTemplate);
}

function __gotTemplates(answer){
	// サーバが返してきた JSON を解析
	var obj = JSON.parse(answer);
	alert("gotTemplates->"+encodeObject(obj)); //##
		  
	var records = new Array();
	var array = obj.menuItems;
	for (num in array){
		var ary = array[num];
		var label = ary[4];
		records[label] = ary; //obj[label];
	}
	setRecords(records);		// records を記憶
	showMenuPopup();
}
function gotTemplates(answer){
	// サーバが返してきた JSON を解析
	var objects = JSON.parse(answer);
	//alert("gotTemplates->"+encodeObject(objects)); //##
    
	var records = new Array();
	var array = objects;
	for (num in array){
		var rec = array[num];
		records[rec.menu] = rec;
	}
	setRecords(records);		// records を記憶
	showMenuPopup();
}
function getTemplates(){
	// メニューをサーバから読み込み
	NRGetMenu(owner(), "PICKUP", gotTemplates);
}

function incrementFrequency(tag, menuItem, value){
	// 選択されたメニューの頻度を１つ増やす
	// ### menuItem が MenuTable に存在しない場合 menuItem の新規登録も行う
	NRPutMenu(owner(),tag,menuItem ,"","","",value,showFrequency);
}

var _menuItem;
function gotRecordsForKeys(answer){
	// サーバが返してきた JSON を解析
	//alert(answer); //##
	var obj = eval('(' + answer + ')');

	showMatrix(obj);
	
	// _menuItem の頻度をインクリメント
	NRPutMenu(owner(),"PICKUP",_menuItem,"","",NRNoAction);
}
function getRecordsForKeys(item, keys){
	// kyes を含むすべてのレコードをサーバへリクエスト
	// keys は配列ではなく文字列のままサーバへ送る
	//alert("getRecordsForKeys: "+keys); //##
	
	_menuItem = item;
	NRGetRecordsForKeys(patientId(),owner(),keys,gotRecordsForKeys);
}

function removedTemplate(answer){
	// サーバが返してきた JSON を解析
	//alert(answer); //##
	var obj = eval('(' + answer + ')');
	//alert(encodeObject(obj)); //##
	closeConfirm();
	getTemplates();
}
function removeTemplate(){
	var menuItem = document.getElementById("templatePopup").value;
	if (confirm(menuItem + " のテンプレートを削除していいですか")){
		NRRemoveMenu(owner(), "PICKUP", menuItem, removedTemplate);
	}
}

/// Ajax による処理 /////////
///////////////////////////


///////////////////////////////////
/// localStorage による処理 /////////

function getWindowSize(windowName){
	// DocMaker のウインドー位置とサイズをサーバへリクエスト
    var st = window.localStorage["pickupWindowSize"];
    if (!st) return;
    
    var array = st.split(",");
    var x = array[0] * 1;
    var y = array[1] * 1;
    var w = array[2] * 1;
    var h = array[3] * 1;
    // resize を先にしておかないと元が大きいサイズだった場合 moveTo しよう
    // としてもウインドー境界の制限で移動できない場合がある
    window.resizeTo(w, h);
    window.moveTo(x, y);
}

function putWindowSize(){
	// DocMaker のウインドー位置とサイズをサーバへ記憶
    var array = new Array();
	array.push(window.screenLeft);
	array.push(window.screenTop - 22);
	array.push(window.outerWidth);
	array.push(window.outerHeight);
    
    window.localStorage["pickupWindowSize"] = array.join(",");
    
    showFadeoutInfo("message", "window サイズと位置を記憶しました", 1000);
}

function putSelectedItem(item){
    // 選択された item を localStorage に記憶
    window.localStorage["pickupItem"] = item;
}
function getSelectedItem(){
    return window.localStorage["pickupItem"];
}

/// localStorage による処理 /////////
///////////////////////////////////


var _recObj;
function CSV(){
	// CSV で出力する
	var buff = "";
	
	// タイトル行
	buff += '"' + "受診日" + '"';
	buff += ',"' + "時刻" + '"';
	var array = labels();
	for (var i=0,ct=array.length; i < ct; i++){
		buff += ',"' + array[i] + '"';
	}
	buff += '\n';

	// データ行
	var rows = 0;
	for (date in _recObj){
		var rec = _recObj[date];
		var array = date.split(" "); // "2009-07-27 07:03:45"
		buff += '"' + array[0] + '"'; // "2009-07-27"
		buff += ',"' + array[1] + '"'; // "07:03:45"
		var array = labels();
		for (var i=0,ct=array.length; i < ct; i++){
			var key = array[i] + "(";
			// レコード中に key があるかどうか探す
			var ary = rec.split(key);
			if (ary.length > 1){
				// key にマッチするものがあれば value をピックアップ
				var st = ary[1];
				var ary2 = st.split(")");
				var value = (ary2.length > 1) ? ary2[0] : "";
			} else
				var value = "";
			buff += ',"' + value + '"';
		}
		buff += '\n';
	}
	
	// CSV 表示用ウインドーを開く
	var elm = document.getElementById("_confirm");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "bodyTable");
	tbl.style.backgroundColor = "#ffc";
	
	// テンプレート名
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	var fd = newTEXTAREA(td, "", "80", "20", buff);
	
	// テンプレート名
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "＊ この CSV を Exel などで表示してください");
	
	// ### openFloatPanel() の style は opener:NOA のライブラリーが使われる
	openFloatPanel(tbl, 5, 5, "CSV 出力");
}

function showMatrix(obj){
	// 選択されたテンプレートに基づきデータをリストアップ
	var elm = document.getElementById("dataArea");
	elm.innerHTML = "";
	if (!obj) return;
	_recObj = obj;
	
    // タイトル行
	var tbl = newTABLE(elm, "bodyTable");
	var tr = newTR(tbl, "title", "");
	var td = newTD(tr, "", "受診日");
	var array = labels();
	var cols = array.length;
	for (var i=0,ct=cols; i < ct; i++){
		var label = array[i];
		var td = newTD(tr, "", label);
	}
	
	// データ行
	var rows = 0;
	for (date in obj){
		var rec = obj[date];
		var tr = newTR(tbl, "record", ""); rows++;
		var td = newTD(tr, "date", date);
		var array = labels();
		for (var i=0,ct=array.length; i < ct; i++){
			var key = array[i] + "(";
			// レコード中に key があるかどうか探す
			var ary = rec.split(key);
			if (ary.length > 1){
				// key にマッチするものがあれば value をピックアップ
				var tailOfLeft = ary[0].substr(ary[0].length - 1);
				if ((tailOfLeft == "(") || (tailOfLeft == ")")){
					// key が全体一致していることが確認された
					var st = ary[1];
					var ary2 = st.split(")");
					var value = (ary2.length > 1) ? ary2[0] : "";
				} else {
					// key の末尾が部分一致している場合はデータなし
					var value = "";
				}
			} else
				var value = "";
			var td = newTD(tr, "data", value);
		}
	}
	if (rows == 0) return;
	
	// コントロール行
	var tr = newTR(tbl, "record", "");
	var td = newTD(tr, "controls", rows + " records　");
	td.setAttribute("colspan", cols + 1);
    td.style.padding= "2px 10px";
	var bt = newBUTTON(td, "", "CSV で出力");
	bt.setAttribute("onclick", "CSV()");
}

function clickedTemplate(){
	// テンプレート・ポップアップが選択された
	var item = document.getElementById("itemPop").value;
	if (item.length == 0){
		showMatrix(null);
		return;
	}
    
    // 選択された item を localStorage に記憶
    putSelectedItem(item);
    
    // マトリックス表示のタイトルになるラベル配列を記憶
    var rec = recordForKey(item);
    setLabels(rec.value);
	
	// 選択されたテンプレートに基づきデータをリストアップ
	// ラベル群は配列ではなく文字列のままサーバへ送る
	getRecordsForKeys(item, rec.value);
}
function showMenuPopup(){
	// テンプレートのポップアップメニューを生成
	var elm = document.getElementById("popupArea");
	elm.innerHTML = "";
    var item = getSelectedItem(); // localStorage に記憶された item
	var pu = makePopupMenu(elm, "itemPop", templateNames(), item);
	pu.setAttribute("onchange", "clickedTemplate()");
    
    // 選択された item に該当するデータを表示
    clickedTemplate();
}

function help(){
	window.open("./pickupHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initPickup(){
	//alert("pickup"); //##
	var elm = document.getElementById("base");
	
	// header
    var div = newDIV(elm, "tool-header");
    var dv = newDIV(div, "left-side");
    dv.innerHTML = "Pickup";
    dv.fontSize = "10pt";
    var dv = newDIV(div, "right-side");
	var img = newIMAGE(dv, "icon", "zoomfit.png", "zoom");
	img.setAttribute("onclick","putWindowSize()");
	img.style.height = "16px";
	var tx = newTEXT(dv, " ");
	var im = newIMAGE(dv, "", "./Help.png", "?");
	im.setAttribute("onclick", "help()");
	im.style.height = "18px";

	// カルテID・氏名
    var div = newDIV(elm, "tool-bar");
    div.style.paddingBottom = "5px";
    var dv = newDIV(div, "left-side");
	var sp = newSPAN(dv, "");
	sp.innerHTML = patientId();
    sp.style.paddingRight = "10px";
	var sp = newSPAN(dv, "");
	sp.innerHTML = patientName();
    sp.style.paddingRight = "10px";

    // ポップアップ・メニュー
    var dv = newDIV(div, "right-side");
	var sp = newSPAN(dv, "popupArea");
	
	// データ表示エリア
    var div = newDIV(elm, "dataArea");
	
	// footer
    var div = newDIV(elm, "tool-footer");
    var dv = newDIV(div, "left-side");
    dv.innerHTML = version();
    dv.style.position = "relative";
    dv.style.top = "2px";
    var dv = newDIV(div, "right-side");
	var im = newIMAGE(dv, "", "./hammer.png", "?");
	im.setAttribute("onclick", "showEditor()");
	im.style.height = "15px";
    im.style.position = "relative";
    im.style.top = "2px";

	// ウインドー・サイズをサーバから読み込みサイズ調整
    getWindowSize();

	// ポップアップメニューを読み込み、カルテデータをセット
	getTemplates();
}

function version(){
	return "Ver.121203";
}
