

/////////////////////////
///// カルテからの継承値 ///

function noa(){
    if (window.opener.name == "noa"){
        return window.opener;
    } else if (window.opener.name == "tools"){
        return window.top.noa;
    } else if (window.top.noa){
        return window.top.noa;
    } else {
        alert("ERROR *** panelEditor: window.opener としての NOA が見つかりません");
        return null;
    }
}

function owner(){
    return noa().owner();
}

function patient_id(){
    return noa().patient_id();
}

function patientKanjiName(){
    return noa().patientKanjiName();
}

function currentDate(){
    return noa().currentDate();
}

function currentTag(){
    return noa().currentTag();
}

function editorId(){
    return noa().editorId();
}

function cellFor(dateTime, tag){
    return noa().cellFor(dateTime, tag);
}

function cellForId(id){
    return noa().cellForId(id);
}

function fieldForTag(tag){
    return noa().fieldForTag(tag);
}

function timeLimit(){
    return noa().timeLimit();
}

function setCell(dateTime, tag, value){
    return noa().setCell(dateTime, tag, value);
}

function setCellToStructure(dateTime, tag, cell){
    noa().setCellToStructure(dateTime, tag, cell);
}

function setCellColor(elm, cell){
    noa().setCellColor(elm, cell);
}

function menus(){
    return noa().menus();
}

function openChart(patientId, patientName){
    noa().openChart(patientId, patientName);
}

function kickPageHeader(){
    // do nothing
}

function layoutArray(){
    return noa().layoutArray();
}

function isReadOnly(){
    return noa().isReadOnly();
}

function openCellPreference(){
    // PanelCellEditor を抜けるので editorId を初期化する必要あり
    noa().setEditorId(null);
    noa().openCellPreference();
}

///// カルテからの継承値 ///
/////////////////////////

function showMap(address){
	// eid のフィールドに表示された住所で Google Maps を開く
	var href = 'http://maps.google.co.jp/?hl=ja&q='+encodeURI(address);
	var win = window.open(href,"maps","scrollbars=yes");
	win.focus();
}

/////////////////////////////////////////////////
///// CELL EDITOR ///////////////////////////////

function removeValue(){
    // 編集内容を空にする
    var elm = document.getElementById(editorId() + ".text");
    elm.value = " ";
    elm.focus();
}

function insertMenuItem(item){
    // メニューの選択内容が変更された
    
    // フィールドの種類により item をモディファイ
    // ProgressSection.treatment などの場合は年月日をつける
	// ## item 自体を変更すると最後の incrementFrequency() で
	// ## 新規登録されてしまうので menuItem に名称を変え使用する
    var menuItem = modifyItem(currentTag(), item);

    if (menuItem == "...その他"){
        addMenu();
        return;
    }
    
	// 選択されたアイテムを文中に挿入
    var elm = document.getElementById(editorId() + ".text"); // 文章
    var html = elm.value;  // ## CellEditor とは違って innerHTML ではない ##
    var field = noa().fieldForTag(currentTag());
    
	if (pureSize(html) == 0){ // 入力先が空欄の場合
		elm.value = menuItem;
	} else {
		switch (field.menuAction * 1){ // insert position
			case _menu_to_tail_: // 0: 文末へ追加
				elm.value = html + " " + menuItem;
				break;
			case _menu_to_last_row_: // 1: 最終行へ追加
				elm.value = html + "<br>" + menuItem;
				break;
			default: // 2 _menu_replace_: 置換
				elm.value = menuItem;
				break;
		}
	}
    elm.focus();
    
    // 使用されたメニュー項目の頻度を increment
    noa().incrementFrequency(currentTag(), item, "");
    
    // "１回のみ選択" であれば保存して次のフィールドへジャンプ
    if (field.buttonType * 1 > 0)
        saveAndJumpEditor(currentTag());


    function pureSize(html){
        // HTML をプレーンテキストにした trim サイズ を返す
        var doc = htmlForValue(html); // "<br>" を "\n" へ変換
        doc = convertSTRING(doc, "&nbsp;", "");
        
        return trim(doc).length;
    }
}
function popupChanged(elm){
    // ポップアップ・メニューが選択された
    // ポップアップメニューが選択された
    var item = elm.value;
    
    insertMenuItem(item);
}

function putAddress(){
    // 住所メニューの町村が選択された時、メニューの都道府県を入力欄へ転記
    var tag = "AddressSection.address";
    var prefecture = document.getElementById("prefPop").value;
    var city = document.getElementById("cityPop").value;
    var village = document.getElementById("villagePop").value;
    
    if (isSame(village, "...その他")){
		village = window.prompt("町村名(のみ)を入力してください", "");
		if (village.length == 0) return;
        
        // 町村を登録
        // 選択アイテムが存在しなければ登録、存在すれば頻度をインクリメント
        NRPutMenu(owner(), city, village, 1, "", gotVILLAGE);
	} else {
        // 選択されたアイテムを文中に挿入
        var elm = document.getElementById(editorId() + ".text"); // 文章
        elm.value = prefecture + " " + city + " " + village + " ";
        elm.focus();
        // HTML5：選択された欄の文末にカーソルを置く
        var sel = window.getSelection();
        sel.collapseToEnd();
    }
}

function dateChanged(answer){
    // newDatePopUp() の操作で返される '2012-07-15' のような answer
    var elm = document.getElementById(editorId() + ".text"); // 文章
    
    // まだ elm が生成されたいないうちに動作することがある
    if (elm) elm.value = answer;
}

function focusPressed(){
    // 絞り込みフィールドでキーが押される度に実行
    var elm = document.getElementById("menuPopArea");
    elm.innerHTML = "";
    
    var key = document.getElementById("focusF").value;
    var pu = makePopupMenu(elm, "menuPop", noa().menuItems(menus(), key), "");
    pu.setAttribute("onchange", "popupChanged(this)");
}

function recoverCellView(tag){
    // エディターを閉じた後、元の表示に戻す
    var cell = cellFor(currentDate(), tag);
    showCellValue(cell, cell.tag);
    
    /*
    var elm = document.getElementById(tag);
    elm.innerHTML = cell.htmlValue;
    elm.style.paddingLeft = "5px";
    
    // address の場合 yellow のことがあるので反転を元へもどしておく
 //   noa().resetColor(elm, "#000", "#fff");
     */
    
    noa().setEditorId(null);
}

function closePanelCellEditor(tag, needSave, nextTag){
    // cellEditor を閉じる
    var cell = cellFor(currentDate(), tag);
    _nextTag = nextTag; // 次に開くべきエディターの tag: null の場合もある

    if (needSave){
        // 内容に変更あれば Editor 内容をサーバへ保存
        var val = document.getElementById(editorId() + ".text").value;
        val = noa().seeAsNOAFormat(val);
        var originalVal = noa().seeAsNOAFormat(cell.htmlValue);
        if (originalVal != val){ // データが編集された
            // 変更内容をサーバへ送る：savedEditor() でサーバから結果を CELL へ書き戻す
            var container = new Object();
            container[cell.tag] = val; // 編集されたデータ

            var limit = noa().timeLimit();
            IFPutPage(owner(),patient_id(),currentDate(),limit,container,savedEditor);
            return;
        }
    }
   
    // Editor を削除し、元の表示に戻す
    recoverCellView(tag);
    
    // 次に開くべきエディターがあれば開く
    if (_nextTag){
        getPanelCellEditor(_nextTag['tag']);
    }
}
function openPanelCellEditor(tag){
    // panelEditor の cellEditor を開く
	var elm = document.getElementById(tag);
    elm.innerHTML = "";
    elm.style.padding = "0px 0px";
    var p = newP(elm, "");
    p.setAttribute("class", "editor-pane");
    p.style.width = "250px"; // 固定にしないとフレームをはみ出してしまう
    
    var div = newDIV(p, "");
    // REMOVE ICON
    var sp = newSPAN(div, "removeFieldTip");
    sp.style.paddingRight = "8px";
    setInfoTip("removeFieldTip", "空欄にする"); // HELP
    var img = newIMAGE(sp, "", "./remove-field.png", "X");
    img.style.height = "12px";
    img.setAttribute("onclick", "removeValue()");
    // CLEAR ICON
    var sp = newSPAN(div, "clearFieldTip");
    sp.style.paddingRight = "8px";
    setInfoTip("clearFieldTip", "前回記述が透けて見えるようにする"); // HELP
    var img = newIMAGE(sp, "", "./selection.png", "X");
    img.style.height = "12px";
    //    img.setAttribute("onclick", "clearValue()");
    // PREFERENCE ICON
    var sp = newSPAN(div, "fieldPrefTip");
    setInfoTip("fieldPrefTip", "初期設定"); // HELP
    var img = newIMAGE(sp, "", "./hammer.png", "X");
    img.style.height = "15px";
    img.setAttribute("onclick", "openCellPreference()");
    // HELP ICON
    var sp = newSPAN(div, "helpTip");
    sp.style.paddingLeft = "5px";
    setInfoTip("helpTip", "HELP"); // HELP
    var img = newIMAGE(sp, "", "./info.png", "X");
    img.style.height = "16px";
    img.setAttribute("onclick", "cellEditorHelp()");
    
    var div = newDIV(p, "");
    // ポップアップ・メニュー
    var cell = cellFor(currentDate(), tag);
    var field = noa().fieldForTag(tag);
    switch (field.menuType * 1){
        case _address_:
            // ### menus() に挿入すると menus() が変化してしまうのでコピー作成
            var items = new Array();
            for (num in menus()) items.push(menus()[num]);
            
            var value = cell.trimValue;
            var addressArray = value.split(" ");
            var prefecture = addressArray[0];
            
            // 都道府県ポップメニュー・エリア
            var span = newSPAN(div, "addressPopArea");
            span.innerHTML = "";
            var sp = newSPAN(span, "_prefecture");
            var popup = makePopupMenu(sp, "prefPop", items, prefecture);
            // 都道府県 が変更されたら 市区 のメニューを取り寄せる
            popup.setAttribute("onchange", "getCITY(this)");
            
            // 市区・町村ポップアップメニュー・エリア
            var sp = newSPAN(span, "_shiku");
            var sp = newSPAN(span, "_chouson");
            getCITY(popup);
            break;
        case _date_:
            var yy = "";
            var mm = "";
            var dd = "";
            var value = cell.trimValue;
            if (value && value.length){
                var dateArray = value.split("-");
                yy = dateArray[0];
                mm = (dateArray.length > 1) ? dateArray[1] : "";
                dd = (dateArray.length > 2) ? dateArray[2] : "";
            }
            // 年月日ボタン表示エリア
            var sp = newSPAN(div, "");
            var cid = editorId() + ".hidden"; // 隠しフィールドの ID
            newDatePopUp(sp, cid, "平成", yy, mm, dd, false, dateChanged);
            break;
        case _panel_:
            var span = newSPAN(div, "panelMenuArea"); // パネル表示エリア
            span.innerHTML = "";
            for (num in menus()){
                var item = menus()[num];
                var sp = newDIV(span, "/blueButton");
                sp.innerHTML = item;
                sp.setAttribute("onclick", "insertMenuItem('" + item + "')");
            }
            break;
        case _rotary_:
            // ポップアップ・メニュー
            var sp = newSPAN(div, "menuPopArea");
            sp.style.paddingRight = "3px";
            var pu = makePopupMenu(sp, "menuPop", menus(), "");
            pu.setAttribute("onchange", "popupChanged(this)");
            // 絞り込み
            var fd = newFIELD(div, "focusF", "", 10, "");
            fd.setAttribute("onkeyup", "focusPressed()");
            var bt = newBUTTON(div, "", "絞込");
            bt.setAttribute("onclick", "focusPressed()");
            break;
        case _none_:
        case _calendar_:
        default:
            break;
    }
    
    // 入力欄
    var div = newDIV(p, "");
    var cell = cellFor(currentDate(), tag);
    switch (field.fieldType * 1){
        case 0: // FIELD type
            var fd = newFIELD(div, tag+".text", "", 45, cell.trimValue);
            fd.setAttribute("onkeyup", "checkReturnKey('" + tag + "')");
            break;
        case 1: // TEXT type
            var fd = newTEXTAREA(div, tag+".text", 32, 5, cell.trimValue);
            fd.setAttribute("onkeyup", "checkReturnKey('" + tag + "')");
            break;
    }
    // 入力欄の末尾にカーソル移動
    fd.setSelectionRange(fd.value.length, fd.value.length);
    
    // ボタン
    var div = newDIV(p, "");
    div.style.textAlign = "right";
    var bt = newBUTTON(div, "", "とりやめ");
    bt.setAttribute("onclick", "closePanelCellEditor('" + tag + "')");
    div.style.textAlign = "right";
    var bt = newBUTTON(div, "", "確定");
    bt.setAttribute("onclick", "saveAndJumpEditor('" + tag + "')");
    
    // セル編集ペーンがスクロール・アウトしないようにする
    var pos = getPosition(bt);
    if (pos.y > window.innerHeight - 50) window.scroll(0, pos.y + 50);
}

function checkReturnKey(tag){
    // CTRL-j が入力されたら saveJumpEditor() を実行
    //alert("checkReturnKey->"+tag);
    if (! arrowKeyJump()) return;
    
    // 13:return 16:shift 17:ctrl 18:alt
    // 37:left-arrow 38:up-arrow 39:right-arrow 40:down-arrow
    // 74:ctrl-j 78:ctrl-n
    // 91:command-left 93:command-right
    //if (window.event.keyCode == 13){ // return-key 漢字変換で反応してしまう
    if (window.event.ctrlKey){
        //alert("window.event.keyCode->"+window.event.keyCode); //##
        if (window.event.keyCode == 74){ // CTRL-J
            saveAndJumpEditor(tag);
        }
    }

    //if (window.event.keyCode == 39) // right-arrow
    //    saveAndJumpEditor(tag);
}

//var _textForEdit;
var _nextTag;
function savedEditor(answer){
    // サーバへ保存された内容を確認のため再表示
    // ### 内容が編集されていなければ保存作業は行わない ###
    //alert("savedEditor->"+answer); //##
    var obj = JSON.parse(answer);
    
    // CELL 内容を書き戻す
    var cell = noa().setCell(obj.entryDate, currentTag(), obj[currentTag()]);
    
    noa().setCellToStructure(obj.entryDate, currentTag(), cell);
    
    // Editor を削除し、元の表示に戻す
    recoverCellView(currentTag());
    
    // 次に開くべきエディターがあれば開く
    if (_nextTag){
        getPanelCellEditor(_nextTag['tag']);
    }
}
function saveAndJumpEditor(tag){
    // 内容を保存し次のエディターへジャンプ
    if (editorId()){
        var nextTag = noa().nextTagFor(tag, _basic);
        
        var nextTagObj = null;
        if (nextTag)
            nextTagObj = { "date":currentDate(), "tag":nextTag };
        
        // 開いているエディター内容を保存し閉じ次のエディターへジャンプ
        closePanelCellEditor(tag, true, nextTagObj);
    }
}

///// CELL EDITOR ///////////////////////////////
/////////////////////////////////////////////////



function gotMenu(answer){
    // メニュー属性をサーバから受け取り CELL に設定
    // obj=[{"menu":"下腹痛","value":"","public":"","freq":"55","menu":"下腹痛"},,,]
    // obj は freq で降順ソートされている
    // メニューデータ obj は記憶せず使い捨て
    //alert("gotMenu->"+answer); //##
    
    var obj = JSON.parse(answer);
    
    var menus = [""];
    for (num in obj){
        var rec = obj[num];
        menus.push(rec.menu)
    }
    menus.push("...その他");
    //alert("gotMenu->"+encodeObject(menus)); //##
    
    noa().setMenus(menus); // メニューを記憶
    
    openPanelCellEditor(noa().currentTag());
}
function getPanelCellEditor(tag){
    // ラベルのクリックで起動：エディターを開く
    var el = document.getElementById("_alerm");
    if (el.style.visibility == "visible"){
        // すでに警告パネルが開いているなら警告パネルを閉じるだけで終了
        closeWarm();
        return;
    }
    
    // disabled の CELL ならエディターを開かない
    var cell = fieldForTag(tag);
    if (cell.disabled * 1 == 1){
        alert("「 "+ cell.label + " 」は変更できません");
        return;
    }

    // 編集不可チェックが入っていればアラート
    if (isReadOnly()){
		var action = "closeWarmAndRemoveCheck('" + tag + "')";
        var elm = document.getElementById("_body");
        var h =  elm.clientHeight;
        var elm = document.getElementById("currentDateTD");
        var w = elm.innerWidth;
        var pos = getPosition(elm); // dom.js

        openWarm(pos.x, pos.y, h, w, action);
        return;
    }
    
    var eid = editorId();
    if (eid){
        if (isPanelEditor(eid)){
            // eid が panelEditor のものだったので、それを閉じる
            closePanelCellEditor(eid, true);
            
            // 開いたのがすでに開いているエディターと同じものなら、閉じただけで終了
            if (eid == tag) return;
        } else {
            // CellEditor が開いていたなら閉じる
            noa().closeEditor(eid, true);
        }
    }
    
    noa().setEditorId(tag);
    noa().setCurrentTag(tag);
    
    // setCurrentTag() はあくまでも "AddressSection.address"
    if (tag == "AddressSection.address") tag = "都道府県";
    
    // if (readOnly){ openWarm(nodeId, action); }

    NRGetMenu(owner(), tag, gotMenu);
    
    function isPanelEditor(pid){
        // pid が PanelEditor の ID なら true を返す
        var array = pid.split("_");
        
        _debug("isPanelEditor->"+encodeObject(array)); //##
        
        return (array.length == 1) ? true : false;
    }
}

function closeWarmAndRemoveCheck(tag){
    // 警告バネルを閉じ、編集不可のチェックをはずす
    closeWarm(); // 警告パネルを閉じる
    
    noa().removeCheck(); // 編集不可のチェックをはずす
    noa().setEditorId(tag);
    noa().setCurrentTag(tag);
    
    // setCurrentTag() はあくまでも "AddressSection.address"
    if (tag == "AddressSection.address") tag = "都道府県";
    
    NRGetMenu(owner(), tag, gotMenu);
}

function openPanelEditor(){
    // 基本情報編集ペーンを開く
    var date = currentDate();

    // 年月日ラベルがクリックされ PanelEditor が開かれたら
    // PanelEditor で開いていたエディターがあっても close status にする
    setEditorId(null);
    
    // 編集ペーンを開く
	var elm = document.getElementById("_body");
    elm.innerHTML = "";
    elm.style.backgroundColor = (isToday()) ? "#fff" : "#eee";
	var tbl = newTABLE(elm, "base-table");
    tbl.style.fontSize = "9pt";
    tbl.style.marginLeft = "5px";

    var tr = newTR(tbl, "", "");
    tr.style.paddingTop = "3px";
    var td = newTD(tr, "label", "受診年月日");
    td.style.paddingLeft = "5px";
    td.style.width = "70px";
    var td = newTD(tr, "currentDateTD/basicValue", currentDate());

    var array = noa().layoutArray(_basic);
    for (num in array){
        var rec = array[num];
        
        if (rec.hitAndRun * 1) continue; // 非表示セル

        var cell = cellFor(date, rec.tag);
        if (cell && cell.hitAndRun) continue; // 非表示セル
        
        var tr = newTR(tbl, "", "");
        
        // === LABEL ================
        var td = newTD(tr, "label/basicLabel", (rec.label) ? rec.label : rec.tag);
        // openEditor() は cellEditor.js のものが使われる
        td.setAttribute("onclick", "getPanelCellEditor('"+rec.tag+"')");
        
        // === VALUE ================
        var td = newTD(tr, rec.tag, "");
        showCellValue(cell); // CELL の VALUE を表示
    }
}

function showCellValue(cell){
    // CELL の VALUE を表示
    var elm = document.getElementById(cell.tag);
    elm.innerHTML = "";
    elm.setAttribute("class", "basicValue");
    elm.style.paddingLeft = "5px"; // 再度指定しないと正確に機能しない
    var p = newP(elm, (cell) ? cell.trimValue : "***");
    
    // cell 属性に文字色・背景色があるなら着色
    var obj1 = noa().fieldForTag(cell.tag);
    if (obj1){
        if (obj1.bgcolor) p.style.backgroundColor = obj1.bgcolor;
        if (obj1.color) p.style.color = obj1.color;
    }
    
    // 住所欄ならクリックで Google map を開く
    if (cell.tag == "AddressSection.address"){
        // クリックで「Google maps」を開く
        p.setAttribute("class", "showMapElement");
        p.setAttribute("onclick", "showMap('" + cell.trimValue + "')");
    }
}

function openInsurance(){
    // 保険情報編集ツールを開く
    noa().setEditorId(null);
    window.open("insurance.php", "tools");
}

function expandProblem(){
    // problemList を展開する
	var elm = document.getElementById("arrowArea");
    elm.innerHTML = "";
    elm.setAttribute("onclick", "foldProblem()");
    elm.style.padding = "0 2px 5px 2px";
    elm.style.position = "relative";
    elm.style.top = "2px";
	var img = newIMAGE(elm, "", "./arrowDown.png", "?");
	img.style.height = "15px";
    img.setAttribute("class", "expandIcon");
	document.getElementById("problemListArea").style.display = "block"; // 表示
    
    var label = document.getElementById("problemLabel");
    label.style.position = "relative";
    label.style.top = "-1px";
}
function foldProblem(){
    // problemList を折畳む
	var elm = document.getElementById("arrowArea");
    elm.innerHTML = "";
    elm.style.padding = "0 0";
    elm.style.position = "relative";
    elm.style.bottom = "-2px";
    elm.setAttribute("onclick", "expandProblem()");
	var img = newIMAGE(elm, "", "./arrowLeft.png", "?");
	img.style.height = "8px";
    img.setAttribute("class", "expandIcon");
	document.getElementById("problemListArea").style.display = "none"; // 非表示
    
    var label = document.getElementById("problemLabel");
    label.style.position = "relative";
    label.style.top = "4px";
}

function panelEditorHelp(){
    // HELP を開く
	window.open("./panelEditorHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initPanelEditor(){
	var elm = document.getElementById("base");
    elm.innerHTML = "";
    
    // === PROBLEM LIST ==================
    var div = newDIV(elm, "tool-header");
    // --- LEFT SIDE ---
    var dv = newDIV(div, "/left-side");
    dv.style.marginTop = "2px";
    // ARROW ICON
    var sp = newSPAN(dv, "arrowArea");
    // TITLE
    var sp = newSPAN(dv, "problemLabel/titleLabel");
    sp.innerHTML = "PROBLEM LIST";
    // --- RIGHT SIDE ---
    var dv = newDIV(div, "/right-side2");
    dv.style.width = "40px";
    // HELP ICON
	var img = newIMAGE(dv, "", "./Help.png", "?");
	img.style.height = "18px";
    img.setAttribute("onclick", "problemListHelp()");
    img.style.position = "relative";
    img.style.top = "2px";

    // === problemList area ===
    var div = newDIV(elm, "problemListArea");
    showProblemList("problemListArea"); // problemList.js
    // problemList を表示した後、矢印アイコンに action 設定
    expandProblem();

	// === BASIC INFO ======================
	// === HEADER ===
    var div = newDIV(elm, "tool-header");
    div.style.padding = "5px 0 4px 0px";
    // --- LEFT SIDE ---
    var dv = newDIV(div, "/left-side");
    var dv = newDIV(div, "/titleLabel");
    dv.innerHTML = "基本情報";
    var dv = newDIV(div, "/greenButton");
    dv.innerHTML = "保険情報";
    dv.setAttribute("onclick", "openInsurance()");
    // --- RIGHT SIDE ---
	var dv = newDIV(div, "/right-side2");
    dv.style.width = "20px";
    // HELP ICON
	var img = newIMAGE(dv, "", "./Help.png", "?");
	img.style.height = "18px";
    img.setAttribute("onclick", "panelEditorHelp()");

	// === BODY ===
    var div = newDIV(elm, "_body");
    	
	// === FOOTER ===
    var div = newDIV(elm, "tool-footer");
    div.innerHTML = pe_version();
    div.style.padding = "5px 0 0 10px";

	// === MESSAGE ===
    var div = newDIV(elm, "message");
    
    openPanelEditor();
}

function pe_version(){
    return "Ver.121123";
}

