<?php
	
    function decodeSTRING($val){
        // #, &, +  < > などが URI 送信で化けるため encode して送られたものを decode
        $array = explode("%x0;", $val);
        $val = implode("#", $array);
        $array = explode("%x1;", $val);
        $val = implode("&", $array);
        $array = explode("%x2;", $val);
        $val = implode("+", $array);
        $array = explode("%x3;", $val);
        $val = implode("<", $array);
        $array = explode("%x4;", $val);
        $val = implode(">", $array);
        $array = explode("%x5;", $val);
        $val = implode(" ", $array);
        $array = explode("%x6;", $val);
        $val = implode("\n", $array);
        $array = explode("%x7;", $val);
        $val = implode("\"", $array);
        $array = explode("%x8;", $val);
        $val = implode("$", $array);
        $array = explode("%x9;", $val);
        $val = implode("'", $array);
        /*
        $array = explode("%xa;", $val);
        $val = implode("(", $array);
        $array = explode("%xb;", $val);
        $val = implode(")", $array);
        */
        return $val;
    }

    function leftBrackets(){
        // $leftBrackets = "\^\[\^" では誤作動
        //	return "\^\[\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        return "^[^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function rightBrackets(){
        return "^]^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        //	return "\^\]\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function decodeObject($buff){
        // "key(value)" 形式の文字列を OBJECT に decode して返す
        $obj = array();
        //	echo "decodeObject ===\n$buff\n"; //##
        for ($p=$begin=$nest=0, $len=strlen($buff); $p < $len; $p++){
            $ch = substr($buff, $p, 1);
            if (strcmp($ch, "(") == 0){
                if ($nest == 0){
                    $key = trim(substr($buff, $begin, $p - $begin)); // key 終端
                    $begin = $p + 1; // value 開始位置
                }
                $nest++;
            } else if (strcmp($ch, ")") == 0){
                if (--$nest == 0){
                    if ($nest == 0){
                        // value 終端 ( trim しない )
                        $value = substr($buff,$begin,$p-$begin);
                        $begin = $p + 1; // key 開始位置
                    }
                    if (ereg(")", $value)){ // まだ入れ子になっているなら
                        $obj[$key] = decodeObject($value);
                    } else {
                        // 特定文字を "(", ")" へ戻す
                        $array = explode(leftBrackets(), $value);
                        $value = join("(", $array);
                        $array = explode(rightBrackets(), $value);
                        $value = join(")", $array);
                        
                        $obj[$key] = $value;
                    }
                    //echo "$key{".$obj[$key]."}\n"; //##
                }
            }
        }
        return $obj;
    }

    function encodeDoubleQuotation($value){
        $array = explode('"', $value);
        // " を ' に置換
        return join("'", $array); 
    }
    
    ///////////////////////////////////////////////////////////////
    ///// バージョンアップした DB との互換性チェック //////////////////////
    // ### 古いバージョンの DB 構造を更新する目的なので 2011 年には廃止予定 ###
    // ### ProgressSection 以外にも freq フィールドを追加する　　　　　　###
    
    function hasField($_dbname, $_tablename, $_fieldname){
        // $db_name 中に $_tablename があれば 1 を、なければ 0 を返す
        $result = mysql_query("SHOW COLUMNS FROM $_tablename");
        if ($result) {
            if (mysql_num_rows($result) > 0) {
                while ($row = mysql_fetch_assoc($result)) {
                    $fieldname = $row['Field'];
                    //echo "$_tablename ..... $fieldname \n";
                    if (strcmp($fieldname, $_fieldname) == 0) return TRUE;
                }
            }
        } else
            echo 'Could not run query: ' . mysql_error();
        return FALSE;
    }
	
    function addField($_tablename, $_fieldname){
        // $_tablename に $_fieldname を追加
        $sql = "ALTER TABLE `$_tablename`
		ADD `$_fieldname` int(11) AFTER `updateTime`";
        echo "$sql ======\n"; //##
        $result = mysql_query($sql);
    }
	
    function checkAllFields($_fieldname){
        // カルテデータを収納するテーブル全てについて
        // $_fieldname の有無をチェックし、存在しなければ追加
        if (! hasField('NOA', 'AddressSection', $_fieldname))
            addField('AddressSection', $_fieldname);
        if (! hasField('NOA', 'BasicSection', $_fieldname))
            addField('BasicSection', $_fieldname);
        if (! hasField('NOA', 'HealthInsurance', $_fieldname))
            addField('HealthInsurance', $_fieldname);
        if (! hasField('NOA', 'MalitalSection', $_fieldname))
            addField('MalitalSection', $_fieldname);
        if (! hasField('NOA', 'NameSection', $_fieldname))
            addField('NameSection', $_fieldname);
        if (! hasField('NOA', 'ProgressSection', $_fieldname))
            addField('ProgressSection', $_fieldname);
        if (! hasField('NOA', 'PublicInsurance', $_fieldname))
            addField('PublicInsurance', $_fieldname);
        if (! hasField('NOA', 'UniversalSection', $_fieldname))
            addField('UniversalSection', $_fieldname);
    }
    
    function checkPatientTable(){
        // PatientTable に public フィールドが存在しなければ追加
        if (! hasField('NOA', 'PatientTable', 'receiptId')){
            $sql = "ALTER TABLE `PatientTable`
            ADD `receiptId` VARCHAR(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL AFTER `anotherId`";
            echo "$sql ======\n"; //##
            $result = mysql_query($sql);
        }
    }
	
    function checkMenuTable(){
        // MenuTable に template フィールドが存在しなければ追加
        if (! hasField('NOA', 'MenuTable', 'template')){
            $sql = "ALTER TABLE `MenuTable` ADD `template` VARCHAR(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL AFTER `menu`";
            echo "$sql ======\n"; //##
            $result = mysql_query($sql);
        }
        // MenuTable に public フィールドが存在しなければ追加
        if (! hasField('NOA', 'MenuTable', 'public')){
            $sql = "ALTER TABLE `MenuTable`
            ADD `public` int(8) AFTER `value`";
            echo "$sql ======\n"; //##
            $result = mysql_query($sql);
        }
    }
    
    function checkFieldTable(){
        // FieldTable に以下に該当するフィールドが存在しなければ追加
        if (! hasField('NOA', 'FieldTable', 'script')){
            $sql = "ALTER TABLE `FieldTable`
            ADD `script` VARCHAR(512) CHARACTER SET utf8 COLLATE utf8_general_ci NULL AFTER `fieldType`";
            echo "$sql ======\n"; //##
            $result = mysql_query($sql);
        }
        if (! hasField('NOA', 'FieldTable', 'editor')){
            $sql = "ALTER TABLE `FieldTable`
            ADD `editor` VARCHAR(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL AFTER `fieldType`";
            echo "$sql ======\n"; //##
            $result = mysql_query($sql);
        }
        if (! hasField('NOA', 'FieldTable', 'disabled')){
            $sql = "ALTER TABLE `FieldTable`
            ADD `disabled` INT AFTER `fieldType`";
            echo "$sql ======\n"; //##
            $result = mysql_query($sql);
        }
        if (! hasField('NOA', 'FieldTable', 'bgcolor')){
            $sql = "ALTER TABLE `FieldTable`
            ADD `bgcolor` VARCHAR(8) NULL AFTER `fieldType`";
            echo "$sql ======\n"; //##
            $result = mysql_query($sql);
        }
        if (! hasField('NOA', 'FieldTable', 'color')){
            $sql = "ALTER TABLE `FieldTable`
            ADD `color` VARCHAR(8) NULL AFTER `fieldType`";
            echo "$sql ======\n"; //##
            $result = mysql_query($sql);
        }
        if (! hasField('NOA', 'FieldTable', 'fontFamily')){
            $sql = "ALTER TABLE `FieldTable`
            ADD `fontFamily` VARCHAR(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL AFTER `fieldType`";
            echo "$sql ======\n"; //##
            $result = mysql_query($sql);
        }
        if (! hasField('NOA', 'FieldTable', 'fontSize')){
            $sql = "ALTER TABLE `FieldTable`
            ADD `fontSize` INT AFTER `fieldType`";
            echo "$sql ======\n"; //##
            $result = mysql_query($sql);
        }
        if (! hasField('NOA', 'FieldTable', 'study')){
            $sql = "ALTER TABLE `FieldTable`
            ADD `study` INT AFTER `fieldType`";
            echo "$sql ======\n"; //##
            $result = mysql_query($sql);
        }
        if (! hasField('NOA', 'FieldTable', 'hitAndRun')){
            $sql = "ALTER TABLE `FieldTable`
            ADD `hitAndRun` INT AFTER `menuAction`";
            echo "$sql ======\n"; //##
            $result = mysql_query($sql);
        }
        if (! hasField('NOA', 'FieldTable', 'numbering')){
            $sql = "ALTER TABLE `FieldTable`
            ADD `numbering` INT AFTER `fieldType`";
            echo "$sql ======\n"; //##
            $result = mysql_query($sql);
        }
        if (! hasField('NOA', 'FieldTable', 'direction')){
            $sql = "ALTER TABLE `FieldTable`
            ADD `direction` VARCHAR(8) AFTER `fieldType`";
            echo "$sql ======\n"; //##
            $result = mysql_query($sql);
        }
        if (! hasField('NOA', 'FieldTable', 'label')){
            $sql = "ALTER TABLE `FieldTable`
            ADD `label` VARCHAR(16) CHARACTER SET utf8 COLLATE utf8_general_ci NULL AFTER `fieldType`";
            echo "$sql ======\n"; //##
            $result = mysql_query($sql);
        }
        if (! hasField('NOA', 'FieldTable', 'id')){
            $sql = "ALTER TABLE `FieldTable`
            ADD `id` VARCHAR(32) NOT NULL AFTER `fieldType`";
            echo "$sql ======\n"; //##
            $result = mysql_query($sql);
        }
    }
    
    function checkFrontTable(){
        // FrontTable に以下に該当するフィールドが存在しなければ追加
        if (! hasField('NOA', 'FrontTable', 'anotherId')){
            $sql = "ALTER TABLE `FrontTable`
            ADD `anotherId` VARCHAR(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL AFTER `patientId`";
            echo "$sql ======\n"; //##
            $result = mysql_query($sql);
        }
    }
	
    function checkPriceList(){
        // PriceList に以下に該当するフィールドが存在しなければ追加
        if (! hasField('NOA', 'PriceList', 'generic')){
            $sql = "ALTER TABLE `PriceList` 
            ADD `generic` VARCHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL AFTER `name`";
            echo "$sql ======\n"; //##
            $result = mysql_query($sql);
        }
    }
	
    function checkUserTable(){
        // UserTable に以下に該当するフィールドが存在しなければ追加
        if (hasField('NOA', 'UserTable', 'userCode')){
            $sql = "ALTER TABLE `UserTable` 
            MODIFY `userCode` VARCHAR(8) CHARACTER SET utf8 COLLATE utf8_general_ci NULL";
            echo "$sql ======\n"; //##
            $result = mysql_query($sql);
        }
        if (hasField('NOA', 'UserTable', 'sectionCode')){
            $sql = "ALTER TABLE `UserTable` 
            MODIFY `sectionCode` VARCHAR(8) CHARACTER SET utf8 COLLATE utf8_general_ci NULL";
            echo "$sql ======\n"; //##
            $result = mysql_query($sql);
        }
    }
    
    function checkDatabseStructure(){
        // DB 構造をチェック、必要なら新しい構造に調整
        echo "checkDatabseStructure ===== begin \n";
        checkAllFields('freq');
        checkPatientTable();
        checkMenuTable();
        checkFieldTable();
        checkFrontTable();
        checkPriceList();
        checkUserTable();
        echo "checkDatabseStructure ===== end \n\n";
    }
    
    ///// バージョンアップした DB との互換性チェック /////
    //////////////////////////////////////////////
    
	function nameSectionWithPatientId($patientId){
        $sql = "SELECT * FROM `NameSection`
        WHERE `patientId`='$patientId'
        ORDER BY `entryDate` DESC";
        $result=mysql_query($sql);
        
        while ($row=mysql_fetch_array($result)){
            if (strlen($row['patientKanjiName']) > 0)
                return $row;
        }
        return "???";
    }

	function patientTableWithPatientId($patientId){
        $sql = "SELECT * FROM `PatientTable`
        WHERE `patientId`='$patientId'
        ORDER BY `updateTime`";
        $result=mysql_query($sql);
        $row=mysql_fetch_array($result);
        return $row;
    }
    
    function tableFieldArray($value){
        // $value: "AddressSection.address,BasicSection.bloodtype,,,"
        $struct = array();
        $array = explode(",", $value);
        for ($i=0,$count=count($array); $i < $count; $i++){
            $tag = $array[$i];
            $array2 = explode(".", $tag);
            
            $table = $array2[0];
            $field = $array2[1];
            $struct[$table][] = $field; // 配列の実体を生成
        }
        return $struct;
    }
	
    function getValues($owner, $values, $pid, $date, $update, $table, $fields, $removeList, $removedOnly){
        // $pid $table に一致し $date 以前直近の $feilds 値を $values に入れて返す
        // $removeList に存在する entryDate のレコードはスキップ
        echo "getValues entryDate($date) updateTime($update) ===\n"; //##
        if (strcmp($table, "HospitalTable") == 0){
            for ($f=0,$ct=count($fields); $f < $ct; $f++){
                $key = $fields[$f];
                $sql = "SELECT * FROM `HospitalTable` WHERE `key`='$key'";
                echo "=====\n $sql \n";
                $result=mysql_query($sql);
                $row=mysql_fetch_array($result);
                $tag = "$table.$key";
                $value = $row['value'];
                $values[$tag] = $value;
                //echo "$tag($value) =====\n";
            }
        } else if (strcmp($table, "PatientTable") == 0){
            $fcount = count($fields);
            $sql = "SELECT * FROM `PatientTable` WHERE `patientId`='$pid'";
            echo "=====\n $sql \n";
            $result=mysql_query($sql);
            $row=mysql_fetch_array($result);
            while (list($key, $value) = each ($row)){
                // 該当レコードの各フィールド・データをピックアップ
                if ('0' <= $key && $key <= '99') continue;
                
                for ($f=0; $f < $fcount; $f++){
                    if (strcmp($key, $fields[$f]) != 0) continue;
                    $tag = "$table.$key";
                    if ($values[$tag]) continue; // タグ値がすでにピックアップされている
                    
                    if ($removedOnly){
                        // PatientTable は修正がほとんどないので
                        // 修正は上書きされ、修正前レコードは存在しない
                        continue;
                    }
                    $values[$tag] = $value;
                    echo $row['entryDate']."^".$row['updateTime']." $tag($value)\n";
                    // $values 値が全部埋まれば終了
                    if ($found++ == $fcount) return $values;
                }
            }
        } else if (strcmp($table, "FrontTable") == 0){
            $beginDate = substr($date,0,10)." 00:00:00";
            $endDate = substr($date,0,10)." 23:59:59";
            $sql = "SELECT * FROM `FrontTable`
            WHERE `patientId`='$pid' AND `entryDate`>='$beginDate' AND `entryDate`<='$endDate' ORDER BY `entryDate` DESC";
            echo "===\n $sql \n"; //##
            $result=mysql_query($sql);
            
            $fcount = count($fields);
            if (mysql_num_rows ($result) > 0){
                // レコードがあれば　$fieldArray に該当する値をピックアップ
                $row=mysql_fetch_array($result);
                for ($f=0; $f < $fcount; $f++){
                    $fname = $fields[$f];
                    $tag = "$table.$fname";
                    $values[$tag] = $row[$fname];
                }
            } else {
                for ($f=0; $f < $fcount; $f++){
                    $fname = $fields[$f];
                    $tag = "$table.$fname";
                    $values[$tag] = "* FRONT 実施計画なし *";
                }
            }
        } else if (strcmp($table, "UniversalSection") == 0){
            // 検索条件に一致した値を $values に取り込む
            if (strlen($update) > 0){
                if ($removedOnly){
                    // # freq が 1 のレコードは削除されたレコード
                    $sql = "SELECT * FROM `UniversalSection` WHERE `patientId`='$pid' AND `entryDate`='$date' AND `updateTime`='$update' AND `owner`='$owner' AND `freq`='1'";
                } else {
                    $sql = "SELECT * FROM `UniversalSection` WHERE `patientId`='$pid' AND `entryDate`='$date' AND `owner`='$owner' AND `updateTime`='$update' AND (`freq` IS NULL OR `freq`<1)";
                }
            } else {
                if ($removedOnly){
                    // # freq が 1 のレコードは削除されたレコード
                    $sql = "SELECT * FROM `UniversalSection` WHERE `patientId`='$pid' AND `entryDate`<='$date' AND `owner`='$owner' AND `freq`='1' ORDER BY `entryDate` DESC, `updateTime` DESC";
                } else {
                    $sql = "SELECT * FROM `UniversalSection` WHERE `patientId`='$pid' AND `entryDate`<='$date' AND `owner`='$owner' AND (`freq` IS NULL OR `freq`<1) ORDER BY `entryDate` DESC, `updateTime` DESC";
                }
            }
            echo "=====\n $sql \n";
            $fcount = count($fields);
            $result=mysql_query($sql);
            for ($i=$found=0; $row=mysql_fetch_array($result); $i++){
                // $removeList に存在する entryDate はスキップ
//                if ($removeList[$row['entryDate']]) continue;
                
                $fname = $row['field'];
                $value = $row['dataString'];
                if ($value == null) continue;
                //if (strlen($value) == 0) continue;
                for ($f=0; $f < $fcount; $f++){
                    $key = $fields[$f];
                    if (strcmp($fname, $key) != 0) continue;
                    
                    $tag = "$table.$key";
                    if ($values[$tag] == null){ // タグに相当する値がまだ埋まっていない
                        
                        // entryDate が完全一致しなければ過去データと判断
                        if (strcmp($row['entryDate'],$date) == 0) // 当日データ
                            $values[$tag] = $value;
                        else // 過去のデータ
                            $values[$tag] = "<PAST>$value</PAST>";
                        // $values 値が全部埋まれば終了
                        if ($found++ == $fcount) return $values;
                        //echo "$tag($value) =====\n";
                    }
                }
            }
        } else {
            // 検索条件に一致した値を $values に取り込む
            // 以上のテーブル以外では $owner を特定せず他オーナーのものも読み出せる
            // InsViewer や FRONT の Viewer で必要になる
            if (strlen($update) > 0){
                // updateTime 指定されていれば entryDate, updateTime に完全合致の
                // レコードをピンポイントで探す
                if ($removedOnly){
                    // # freq が 1 のレコードは削除されたレコード
                    $sql = "SELECT * FROM `$table` WHERE `patientId`='$pid' AND `entryDate`='$date' AND `updateTime`='$update' AND `freq`='1'";
                } else {
                    $sql = "SELECT * FROM `$table` WHERE `patientId`='$pid' AND `entryDate`='$date' AND `updateTime`='$update' AND (`freq` IS NULL OR `freq`<1)";
                }
            } else {
                // updateTime 指定されていなければ entryDate 以前直近で
                // 一番最近更新されたレコードを探す
                if ($removedOnly){
                    // # freq が 1 のレコードは削除されたレコード
                    $sql = "SELECT * FROM `$table` WHERE `patientId`='$pid' AND `entryDate`<='$date' AND `freq`='1'
                    ORDER BY `entryDate` DESC, `updateTime` DESC";
                } else {
                    $sql = "SELECT * FROM `$table` WHERE `patientId`='$pid' AND `entryDate`<='$date' AND (`freq` IS NULL OR `freq`<1) ORDER BY `entryDate` DESC, `updateTime` DESC";
                }
            }
            echo "=====\n $sql \n";
            $result=mysql_query($sql);
            $fcount = count($fields);
            for ($i=$found=0; $row=mysql_fetch_array($result); $i++){
                // $removeList に存在する entryDate はスキップ
                echo $row['entryDate']."^".$row['updateTime']." ...\n";
//                if ($removeList[$row['entryDate']]) continue;
                
                while (list($key, $value) = each ($row)){
                    // 該当レコードの各フィールド・データをピックアップ
                    if ($value == null) continue;
                    for ($f=0; $f < $fcount; $f++){
                        if (strcmp($key, $fields[$f]) != 0) continue;
                        
                        $tag = "$table.$key";
                        if ($values[$tag] == null){ // タグ値がまだピックアップされてない
                            // entryDate が完全一致しなければ過去データと判断
                            if (strcmp($row['entryDate'],$date) >= 0)
                                $values[$tag] = $value;
                            else // 過去のデータ
                                $values[$tag] = "<PAST>$value</PAST>";
                            
                            // $values 値が全部埋まれば終了
                            if ($found++ == $fcount) return $values;
                            echo $row['entryDate']."^".$row['updateTime']." $tag($value) =====\n";
                        }
                    }
                }
            }
        }
        
        // 埋まっていない $fields があれば空データを入れる
        for ($f=0; $f < $fcount; $f++){
            $key = $fields[$f];
            $tag = "$table.$key";
            if ($values[$tag] == null){ // タグ相当値がまだ埋まっていない
                $values[$tag] = "";
            }
        }
        
        return $values;
    }
	
    function getMenuItems($tag, $owner){
        // MENU EDITOR 用メニュー・リストを返す (public と owner を merge したもの）
        $array1 = get_MenuItems($tag, "public");
        $array2 = get_MenuItems($tag, $owner);
        
        // 両方の配列を連結：array_merge() がうまく機能しないため自作
        // 重複を避けるため一旦オブジェクトとして統合
        $array = array();
        for ($c=0,$cct=count($array1); $c < $cct; $c++){
            $obj = $array1[$c];
            $menuItem = $obj['menu'];
            $template = ($obj['template']) ? $obj['template'] : "";
            $array[$menuItem][$template] = $obj;
        }
        for ($c=0,$cct=count($array2); $c < $cct; $c++){
            $obj = $array2[$c];
            $menuItem = $obj['menu'];
            $template = ($obj['template']) ? $obj['template'] : "";
            $array[$menuItem][$template] = $obj;
        }

        $results = array();
        foreach ($array as $item=>$records){
            foreach ($records as $template=>$obj){
                $results[] = $obj;
            }
        }
        
        return $results;
    }
    function get_MenuItems($tag, $owner){
        // MENU EDITOR 用メニュー・リストを返す (owner のもののみ）
        // $tag $owner
        echo "##### getMenuItems #####\n"; //##

        // $tag が GROUP MENU タイプかどうかを調べる
        $isGroupType = FALSE;
        $sql = "SELECT * FROM `FieldTable` WHERE `owner`='$owner' AND `tag`='$tag' AND `direction`='CELL'";
        $result=mysql_query($sql);
        echo "$sql \n"; //###

        if ($row=mysql_fetch_array($result)){
            // _group_ type ### lib.js での定数宣言と整合性をとる必要あり
            if ($row['menuType'] * 1 == 3) $isGroupType = TRUE;
        }

        ///// FieldTable に格納されたデータを返す /////
        $array = array();
        if ($isGroupType){
            $sql = "SELECT * FROM `ProgressSection` WHERE `patientId`='GroupMenu' AND `owner`='$owner' ORDER BY `freq` DESC";
            $result=mysql_query($sql);
            echo "$sql ========\n"; //##
            while ($row=mysql_fetch_array($result)){
                // GroupMenu の場合はパラメータを他のメニューに合わせる
                $ary = array();
                $ary['owner'] = $row['owner'];
                $ary['freq'] = $row['freq'];
                $ary['menu'] = $row['subject'];
                $ary['ProgressSection.subject'] = $row['subject']; // あえて重複
                $ary['ProgressSection.object'] = $row['object'];
                $ary['ProgressSection.examination'] = $row['examination'];
                $ary['ProgressSection.prescription'] = $row['prescription'];
                $ary['ProgressSection.disease'] = $row['disease'];
                $ary['ProgressSection.treatment'] = $row['treatment'];
                $ary['ProgressSection.assessment'] = $row['assessment'];
                $ary['ProgressSection.plan'] = $row['plan'];
                $menuItems[] = $ary;
            }
        } else {
            // MenuTable の $tag に一致した内容を返す
            $sql = "SELECT * FROM `MenuTable` WHERE `tag`='$tag' AND `owner`='$owner' ORDER BY `freq` DESC";
            $result=mysql_query($sql);
            echo "$sql ========\n"; //##
            while ($row=mysql_fetch_array($result)){
                $ary = array();
                $ary['owner'] = $row['owner'];
                $ary['tag'] = $row['tag'];
                $ary['template'] = $row['template'];
                $ary['value'] = $row['value'];
                $ary['public'] = $row['public'];
                $ary['freq'] = $row['freq'];
                $ary['menu'] = $row['menu'];
                $menuItems[] = $ary;
                echo $row['tag']."-> ".$row['menu']."\n"; //##
            }
        }

        return $menuItems;
    }
    
    function getLayout($owner){
        // $owner の NOA レイアウトを返す
        $sql = "SELECT * FROM `FieldTable` WHERE `owner`='$owner' AND `direction`='CELL' ORDER BY `numbering`";
        $result=mysql_query($sql);
        echo "$sql \n"; //###
        
        $recs = array();
        while ($row=mysql_fetch_array($result)){
            $rec = array();
            $rec['tag'] = $row['tag']; // 必要
            $rec['buttonType'] = $row['buttonType'];
            $rec['menuType'] = $row['menuType'];
            $rec['menuAction'] = $row['menuAction'];
            $rec['hitAndRun'] = $row['hitAndRun'];
            $rec['fieldType'] = $row['fieldType'];
            // direction は「FieldTable 検索専用キー: CELL」固定なので使わない
            $rec['disabled'] = $row['disabled'];
            $rec['editor'] = $row['editor'];
            $rec['id'] = $row['id'];
            $rec['script'] = $row['script'];
            $rec['bgcolor'] = $row['bgcolor'];
            $rec['label'] = $row['label'];
            $rec['numbering'] = $row['numbering']; // LAYOUT で使う
            $rec['study'] = $row['study'];
            $rec['fontSize'] = $row['fontSize'];
            $rec['fontFamily'] = $row['fontFamily'];
            $rec['color'] = $row['color'];
            $tag = $row['tag'];
            $recs[$tag] = $rec;
        }
        return $recs;
    }

    function getUserList(){
        // ユーザのリストを返す
        $sql = "SELECT * FROM `UserTable`";
        echo "$sql \n"; //##
        $array = array();
        $result=mysql_query($sql);
        if (mysql_num_rows ($result) > 0){
            while ($row=mysql_fetch_array($result)){
                $logname = $row['loginName'];
                $array[$logname] = $row['kanjiName'];
                echo "$logname -> ".$row['kanjiName']."\n"; //##
            }
        }
        return $array;
    }
	
    function getUser($loginName){
        $sql = "SELECT * FROM `UserTable` WHERE `loginName`='$loginName'";
        echo "===== getUser\n $sql \n";
        $result=mysql_query($sql);
        if (mysql_num_rows ($result) > 0){
            while ($row = mysql_fetch_assoc($result)){ // 連想配列で取り出す
                if (strcmp($row['loginName'], $loginName) == 0){
                    echo "--- $row \n";
                    return $row;
                }
            }
        }
        return null;
    }
    
    function getHospital($hid){
        $sql = "SELECT * FROM `HospitalTable` WHERE `hospitalId`='$hid'";
        echo "===== getHospital\n $sql \n";
        $array = array();
        $result=mysql_query($sql);
        while ($row=mysql_fetch_assoc($result)){ // 連想配列でレコードを取り出す
            $key = $row['key'];
            $value = $row['value'];
            $array[$key] = $value;
            echo "  $key -> $value \n"; //##
        }
        echo "\n\n";
        
        return $array;
    }
	
    function getHospitalNames(){
        // $array に 施設名と hospitalId の対象テーブルを挿入
        $array = array();
        $sql = "SELECT * FROM `HospitalTable` WHERE `key`='施設名'";
        echo "=== getHospitalNames\n $sql \n";
        $result=mysql_query($sql);
        while ($row=mysql_fetch_array($result)){
            $hospitalId = $row['hospitalId'];
            $name = $row['value'];
            $array[$name] = $hospitalId;
        }
        return $array;
    }
    
    function timestamp(){
        // 現在のタイムスタンプを返す updateTime に使う
        return date("Y-m-d H:i:s",time());
    }
	
    function shiftDateTime($dateTime, $interval){
        // 日付:$dateTime を $interval 秒後へずらした日付を返す
        // 日付は "yyyy-mm-dd hr:mn:sc" 形式
        // $interval は「秒数」
        // ## $interval が空だと 10 年前までの記録を修正可能
        $array = explode(" ", $dateTime);
        list($year, $month, $day) = explode("-", $array[0]);
        list($hour, $min, $sec) = explode(":", $array[1]);
        $date = mktime($hour, $min, $sec, $month, $day, $year);
        
        // $interval が空なら、いつでも訂正可能にするため２０年後の日時を返す
        // ## ２０年以上ずらすと PHP の仕様のためか過去の 1900 年代に戻ってしまう
        if (strlen($interval) == 0)
            $date = mktime($hour, $min, $sec, $month, $day, $year + 20);
        else
            $date += ($interval * 1); // 時刻を $interval 秒後にずらす
        
        $yyyy = date("Y", $date);
        
        //echo "interval($interval) $year --> $yyyy \n";
        
        $mm = date("m", $date);
        $dd = date("d", $date);
        $hr = date("H", $date);
        $mn = date("i", $date);
        $sc = date("s", $date);
        
        // この日時を過ぎていなければ直接訂正可能、過ぎていれば新しいページで上書き
        return "$yyyy-$mm-$dd $hr:$mn:$sc";;	
    }
    
    function isEditableRecord($table, $field, $pid, $entryDate, $timeLimit){
        // entryDate + timeLimit（秒数）を越えていなければ 1 越えていれば 0 を返す
        // ## updateTime + timeLimit という考え方もあるが
        // ## entryDate を基準にする方が修正により厳密に対応でき
        // ## 編集後「timeLimit 越えなければ、完全にページ削除」できてしまうこともない
        // ## $timeLimit が "" だと 20 年前までの記録を修正可能 ##
        echo "=== isEditableRecord() \n";
        echo " timeLimit($timeLimit)\n";
        echo " entryDateTime($entryDate) \n";
        
        $datetime = shiftDateTime($entryDate, $timeLimit);
        $isEditable = (strcmp(timeStamp(), $datetime) < 0) ? 1 : 0;
        
        echo " timeStamp(".timeStamp().")\n";
        echo " --> isEditable($isEditable) \n";
        
        if ($isEditable){
            // 編集可能なレコードがあれば、その rowid を取得
            if (strcmp($table, "UniversalSection") == 0){
                $sql = "SELECT * FROM `$table`
                WHERE `patientId`='$pid' AND `entryDate`<='$entryDate' 
                AND `field`='$field' AND (`freq` IS NULL OR `freq`<1)
                ORDER BY `entryDate` DESC,`updateTime` DESC";
            } else {
                $sql = "SELECT * FROM `$table`
                WHERE `patientId`='$pid' AND `entryDate`<='$entryDate' 
                AND (`freq` IS NULL OR `freq`<1)
                ORDER BY `entryDate` DESC,`updateTime` DESC";
            }
            echo "check target record:\n $sql \n";
            $result=mysql_query($sql);
            $row=mysql_fetch_array($result);
            if ($row && (strcmp($entryDate, $row['entryDate']) == 0)){
                echo " --> 編集可能時刻 $datetime 以内なので直接修正 OK\n";
                return "1:".$row['rowid'];
            } else {
                echo " --> 編集可能時刻以内の $entryDate ページがないので直接修正 NO\n";
                return "0:";
            }
        } else {
            echo " --> 編集可能時刻 $datetime を過ぎており直接修正 NO\n";
            return "0:";
        }
    }
	
    function entryDateArray($patientId, $entryDate){
        // entryDate,削除マーク,num を有するオブジェクトの入った array を返す
        // ## 表示は新しい日付順だが、古い日付から event をピックアップする必要のある
        // ## 場合があるので、古い日付からサーチし、ピックアップ処理後 rsort() で順序
        // ## を反転する。updateTime については最新のもののみをピックアップするので 
        //    DESC で逆順に検索
        // # freq が 1 のレコードは削除されたレコード
        
        $sql = "SELECT * FROM `ProgressSection` 
        WHERE `patientId`='$patientId' AND (`freq` IS NULL OR `freq`<1)
        ORDER BY `entryDate`,`updateTime` DESC";
        $result=mysql_query($sql);
        echo "====== entryDateArray\n $sql \n";//###
        $array = array();
        $key = "";
        $num = 0;
        $isKeyMode = FALSE;
        if (mysql_num_rows ($result) > 0){
            $entryDate = ""; // これがないと１ページだけのカルテで誤動作
            while ($row=mysql_fetch_array($result)){
                // freq が 1 のレコードは削除か変更前のものなのでスキップ
                //echo $row['entryDate']." -> freq(".$row['freq'].") \n";//###
                //if ($row['freq'] > 0) continue;
                
                // 重複した entryDate をスキップ -- DISTINCT ではうまくいかない
                if (strcmp($entryDate, $row['entryDate']) == 0) continue;
                $entryDate = $row['entryDate'];
                
                // ## subject 中に開始タグを見つけたらカウント・モード($keyをもつ)になる
                $subj = $row['subject'];
                $obj = array();
                $obj['entryDate'] = $row['entryDate'];
                $obj['subject'] = substr($row['subject'], 0, 50);
                if (isRemovedPage($row)){ // 削除されたページ
                    // このページは日付ポップアップメニューには表示されるが REMOVE
                    // が付いているため、カレンダーには受診日としてマークされない
                    $obj['status'] = "REMOVED"; // 削除マーク
                    $array[] = $obj;
                } else if (strlen($subj) == 0){ // Subject が空のため前頁が透けて見える
                    $array[] = $obj;
                } else { // subject に key 存在せず
                    $array[] = $obj;
                    $isKeyMode = FALSE; // カウント・キーの記憶を削除
                }
            }
        }
        
        // 予約日をピックアップ
        $sql = "SELECT * FROM `FrontTable`
        WHERE `patientId`='$patientId'
        AND `entryDate`>'$entryDate'";
        echo "====== entryDateArray\n $sql \n";//###
        $result=mysql_query($sql);
        if (mysql_num_rows ($result) > 0){
            while ($row=mysql_fetch_array($result)){
                $obj = array();
                $obj['entryDate'] = $row['entryDate'];
                $obj['status'] = "RESERVED";
                $array[] = $obj;
            }
        }
        
        usort($array, "compareDateArray"); // 逆順にソート
        
        echo "====== usort end <br>";//###
        
        return $array;
    }

	function isRemovedPage($row){
        // 削除されたページかどうかを返す
        // pageHeader に "EMOVED" の文字があれば削除されたページと判断
        // ## strpos() が確実に０以上になるよう "REMOVED" でなく "EMOVED"
        if ($row['freq'] > 0) return TRUE;
        return (strpos($row['pageHeader'], "EMOVED") > 0) ? TRUE : FALSE;
    }
	
    function isPatientId($st){
        // $st が カルテID 形式でなければ FALSE を返す
        if (strlen($st) != 8) return FALSE;
        
        $month = substr($st, 0, 2);
        if ($month * 1 < 1) return FALSE;
        if ($month * 1 > 12) return FALSE;
        
        return TRUE;
    }
	
    function find($tag, $pid, $from, $to, $uniqueId, $key){
        // 条件にマッチした結果を返す
        $fromDateTime = "$from 00:00:00";
        $toDateTime = "$to 23:59:59";
        $tags = explode(".", $tag);
        $table = $tags[0];
        $field = $tags[1];
        $uniq = (strlen($uniqueId) > 0) ? TRUE : FALSE; // patientId 重複を避けるモード
        $pidArray = array();
        if (strcmp($table, "UniversalSection") == 0){
            $pidst =  (strlen($pid) > 0) ? "`patientId`='$pid' AND" : "";
            $query = "SELECT * FROM `UniversalSection`"
			." WHERE $pidst"
			." `field`='$field' AND"
			." `entryDate`>='$fromDateTime' AND"
			." `entryDate`<='$toDateTime' AND"
			." (`freq` IS NULL OR `freq`<1) AND"
			." `dataString` LIKE '%$key%'"
			." ORDER BY `entryDate` DESC, `updateTime` DESC";
            $result=mysql_query($query);
            echo "$query ===== \n";//###
            $array = array();
            while ($row=mysql_fetch_array($result)){
                // $rec[entryDate] = {'patientId'=$pid,'value'=$value} 形式で返す
                $rec = array();
                $_pid = $row['patientId'];
                if ((strlen($uniq) > 0) && $pidArray[$_pid]) continue;
                
                $rec['pid'] = $_pid;
                $namrow = nameSectionWithPatientId($_pid);
                $rec['name'] = $namrow['patientKanjiName'];
                $rec['value'] = $row['dataString'];
                // $row['entryDate'] だけでは、同じ entryDate の patient は
                // unique にしか $array に登録されないので、枝番号を追加する
                $date = $row['entryDate']." ".$i;
                $array[$date] = $rec;
                $pidArray[$_pid] = TRUE;
            }
            return $array;
        } else if (strcmp($table, "PatientTable") == 0){
            $pidst =  (strlen($pid) > 0) ? "`patientId`='$pid' AND" : "";
            $query = "SELECT * FROM `PatientTable`"
            ." WHERE $pidst"
            ." `entryDate`>='$fromDateTime' AND"
            ." `entryDate`<='$toDateTime' AND"
            ." `$field` LIKE '%$key%'"
            ." ORDER BY `entryDate` DESC, `updateTime` DESC";
            $result=mysql_query($query);
            echo "$query ===== \n";//###
            $array = array();
            while ($row=mysql_fetch_array($result)){
                // $rec[entryDate] = { 'patientId' = $pid, 'value' = $value } 形式で返す
                $rec = array();
                $_pid = $row['patientId'];
                if ((strlen($uniq) > 0) && $pidArray[$_pid]) continue;
                if (! isPatientId($_pid)) continue;
                
                $rec['pid'] = $_pid;
                $namrow = nameSectionWithPatientId($_pid);
                $rec['name'] = $namrow['patientKanjiName'];
                $rec['value'] = $row[$field];
                // $row['entryDate'] だけでは、同じ entryDate の patient は
                // unique にしか $array に登録されないので、枝番号を追加する
                $date = $row['entryDate']." ".$i;
                $array[$date] = $rec;
                $pidArray[$_pid] = TRUE;
            }
            return $array;
        } else {
            $pidst =  (strlen($pid) > 0) ? "`patientId`='$pid' AND" : "";
            $query = "SELECT * FROM `$table`"
			." WHERE $pidst"
			." `entryDate`>='$fromDateTime' AND"
			." `entryDate`<='$toDateTime' AND"
			." (`freq` IS NULL OR `freq`<1) AND"
			." `$field` LIKE '%$key%'"
			." ORDER BY `entryDate` DESC, `updateTime` DESC";
            $result=mysql_query($query);
            echo "$query ===== \n";//###
            $array = array();
            while ($row=mysql_fetch_array($result)){
                // $rec[entryDate] = { 'patientId' = $pid, 'value' = $value } 形式で返す
                $rec = array();
                $_pid = $row['patientId'];
                if ((strlen($uniq) > 0) && $pidArray[$_pid]) continue;
                if (! isPatientId($_pid)) continue;
                
                $rec['pid'] = $_pid;
                $namrow = nameSectionWithPatientId($_pid);
                $rec['name'] = $namrow['patientKanjiName'];
                $rec['value'] = $row[$field];
                // $row['entryDate'] だけでは、同じ entryDate の patient は
                // unique にしか $array に登録されないので、枝番号を追加する
                $date = $row['entryDate']." ".$i;
                $array[$date] = $rec;
                $pidArray[$_pid] = TRUE;
            }
            return $array;
        }
    }

    function layoutTags($owner){
        // $owner の LAOUT に含まれる table.field の配列を返す
        $tagArray = array();
        $tagArray["PatientTable.patientId"] = "カルテID"; // LAYOUT にないので追加
        $tagArray["ProgressSection.pageHeader"] = "PageHeader"; 

        $sql = "SELECT * FROM `FieldTable` WHERE `owner`='$owner' AND `direction`='CELL' ORDER BY `numbering`";
        $result=mysql_query($sql);
        echo "$sql \n"; //###
        
        while ($row=mysql_fetch_array($result)){
            $tagArray[$row['tag']] = $row['label'];
        }
        return $tagArray;
    }
    
    function getArchiveValue($patientId, $table, $field){
        // $tableAndField 内の DB値のリストを返す
        $sql = "SELECT * FROM `$table` WHERE `patientId`='$patientId' ORDER BY `entryDate` DESC";
        $result=mysql_query($sql);
        
        $array = array();
        while ($row=mysql_fetch_array($result)){
            if ((strcmp($patientId != "GroupMenu") != 0) && (strcmp($table, "PatientTable") != 0) && $row['freq'] && ($row['freq'] > 0)) continue; // 削除されたレコードはスキップ
            
            $edate = $row['entryDate'];
            $udate = $row['updateTime'];
            $array2 = (count($array[$edate]) == 0) ? array() : $array[$edate];
            if (strcmp($table, "UniversalSection") == 0){
                $key = $row['field'];
                $value = $row['dataString'];
                if (strcmp($key, $field) == 0){
                    if (strlen($value) > 0){
                        // field にマッチした value が存在したら
                        $array2[$udate] = $value;
                        $array[$edate] = $array2;
                    }
                }
            } else {
                $value = $row[$field];
                if (strlen($value) > 0){
                    // field にマッチした value が存在したら
                    // ## $value に " が入っていると JSON にした後
                    // ## eval() する時にエラーになるので encode しておく
                    // ## JSON を eval() した後に decode を忘れぬこと
                    $value = encodeDoubleQuotation($value);
                    $array2[$udate] = $value;
                    $array[$edate] = $array2;
                }
            }
        }
        return $array;
    }
    function archive($patientId, $array){
        // $array 中の table に対するコンテンツを添えた JSON を返す
        $results = array();
        foreach ($array as $tag=>$kanjiName){
            $tags = explode(".", $tag);
            if (count($tags) > 1){
                $table = $tags[0];
                $field = $tags[1];
                
                $contents = getArchiveValue($patientId, $table, $field);
                $results[$tag] = $contents;
            }
        }
        return json_encode($results);
    }

    function archiveDirForToolMenu($owner, $folder){
        // $dir が無ければ作成
        $dir = "../Users"; // /NOA の場合
        if (! file_exists($dir)){
            // $dir が無ければ作成
            echo "($dir) is not exist, so I'll make directory. \n"; //##
            mkdir($dir);
        }
        $dir = "$dir/$owner";
        if (! file_exists($dir)){
            // $dir が無ければ作成
            echo "($dir) is not exist, so I'll make directory. \n"; //##
            mkdir($dir);
        }
        $dir = "$dir/$folder";
        if (! file_exists($dir)){
            // $dir が無ければ作成
            echo "($dir) is not exist, so I'll make directory. \n"; //##
            mkdir($dir);
        }

        return $dir;
    }
    
    function archivedFile($patientId){
        // $dir が無ければ作成
        $dir = "../NOA_ARCHIVE"; // /NOA の場合
        //$dir = "../../NOA_ARCHIVE"; // /test/NOA の場合
        if (! file_exists($dir)){
            // $dir が無ければ作成
            echo "($dir) is not exist, so I'll make directory. \n"; //##
            mkdir($dir);
        }
        return "$dir/$patientId.txt";
    }
	
    function save($patientId, $buff){
        $filename = archivedFile($patientId);
        
        if (!$handle = fopen($filename, 'w')) {
            // $filenameを書き出しモードでオープン
            echo "Cannot open file ($filename)";
            return FALSE;
        }
        
        if (fwrite($handle, $buff) === FALSE) {
            // オープンしたファイルに$buffを書き込む
            echo "Cannot write to file ($filename)";
            return FALSE;
        } else {
            echo "Saved $patientId to file ($filename)";
            fclose($handle);
            return TRUE;
        }
    }
	
	function patientArrayAt($entryDate){
		// $entryDate の受診者の patientId を配列で返す
		$beginDate = substr($entryDate,0,10)." 00:00:00";
		$endDate = substr($entryDate,0,10)." 23:59:59";
		
		$sql = "SELECT * FROM `FrontTable` WHERE `entryDate`>='$beginDate' AND `entryDate`<='$endDate'";
		echo "===\n $sql \n"; //##
		
		$array = array();
		$result=mysql_query($sql);
		if (mysql_num_rows ($result) > 0){
			// 該当するレコードの patientId をピックアップ
			while ($row=mysql_fetch_array($result)){
				$pid = $row['patientId'];
				$array[$pid] = $row['kanjiName'];
			}
		}
		return $array;
	}

    function getPostIt($pid, $edate, $owner){
        // PostIt の内容を返す
        $sql = "SELECT * FROM `UniversalSection`
        WHERE `patientId`='$pid' AND `owner`='$owner'
        AND `entryDate`<='$edate' AND `field`='postit'
        ORDER BY `entryDate` DESC";
        echo "===\n $sql \n";
        $result=mysql_query($sql);
        
        $array = array();
        $row=mysql_fetch_array($result);
        if ($row){
            $array['value'] = $row['dataString'];
            $array['type'] = $row['type'];
            $array['entryDate'] = $row['entryDate'];
            $array['updateTime'] = $row['updateTime'];
            
            //if ($row['type'] * 1 == 2) break; // expired なら終了 -- error になる
        }
        return $array;
    }

	function rowOfPatientId($_pid){
        // テーブル中にすでに $_pid があれば 1 を、なければ 0 を返す
        $sql = "SELECT * FROM `PatientTable` WHERE `patientId`='$_pid'";
        $result=mysql_query($sql);
        $row=mysql_fetch_array($result);
        if (mysql_num_rows ($result) > 0)
            return $row;
        else
            return null;
    }
    
    function getDir($dir){
        // $dir 内のファイルをリストアップ
        // ##### $dir は HTTP ではなく FILE-SYSTEM の PATH を示す #####
        $files = scandir($dir, 1); // 逆順にソート
        $count=count($files);
        echo "dir($dir) count($count)\n";
        
        for ($i=0; $i < $count; $i++){
            $filename = $files[$i];
            echo "-- ($filename)\n"; //###
            if ($filename == ".") continue;
            if ($filename == "..") continue;
            if (strlen($filename) == 0) continue;
            echo "-- file ($filename)\n"; //###
            
            $array[] = $filename;
        }
        
        $results = array();
        $results['path'] = $dir;
		$results['files'] = $array;
        
        return $results;
    }
    
    function valForWebNOA($val){
        // $val 中の "<BR/>"(NOA2JSON で変換された) を "\n" に戻す操作を行っておく
        $array = explode("<BR/>", $val);
        return join("\n", $array);
    }
    function valueForNOA($table, $field, $val){
        // CocoaNOA データを WebNOA データへ変換
        $tag = "$table.$field";
        if (strcmp($tag, "PatientTable.sex") == 0){
            if (strcmp($val, "f") == 0)
                return "女";
            else if (strcmp($val, "m") == 0)
                return "男";
        }
        else if (strcmp($tag, "PatientTable.birthDate") == 0){
            $array = explode(" ", $val);
            return join(" ", array_slice($array, 0, 1));
        }
        return $val;
    }
    function putRecord($patientId, $tag, $entryDate, $updateTime, $val, $owner){
        // 完全に一致するものがなければ、このレコードを挿入
        // $val 中の "<BR/>"(NOA2JSON で変換された) を "\n" に戻す操作を行っておく
        $val = valForWebNOA($val);
        $tags = explode(".", $tag);
        $table = $tags[0];
        $field = $tags[1];
        
        if (strcmp($table, "UniversalSection") == 0){
            $sql = "SELECT * FROM `$table`
            WHERE `patientId`='$patientId' AND `field`='$field'
            AND `entryDate`='$entryDate' AND `updateTime`='$updateTime'";
            $result=mysql_query($sql);
            if (mysql_num_rows ($result) > 0){ // 同じID・フィールド・日付・更新時のデータが存在した
                $row=mysql_fetch_array($result);
                if (strcmp($row['dataString'], $val) <> 0){ // データが異なった
                    $sql="UPDATE `$table` SET `field`='$field',`dataString`='$val'
                    WHERE `rowid`=".$row['rowid'];
                    echo "$sql \n"; // message
                    mysql_query($sql);
                }
            } else { // 同じID・フィールド・日付・更新時のデータが存在しなかった
                $sql = "INSERT INTO `$table`
                (`patientId`,`field`,`dataString`,`entryDate`,`updateTime`,`owner`)
                VALUES ('$patientId','$field','$val','$entryDate','$updateTime','$owner')";
                echo "$sql \n"; // message
                mysql_query($sql);
            }
        } else if (strcmp($table, "PatientTable") == 0){
            $sql = "SELECT * FROM `$table` WHERE `patientId`='$patientId'";
            $result=mysql_query($sql);
            $val = valueForNOA($table, $field, $val); // CocoaNOA データを WebNOA へ変換
            if (mysql_num_rows ($result) > 0){ // 同じ patientId のデータが存在した
                $row=mysql_fetch_array($result);
                if (strcmp($row[$field], $val) <> 0){ // データが異なった
                    // PatientTable のレコードは patientId ごとに唯一なので
                    // もし同じ patientId が存在した場合は最新のデータを優先する
                    if (strcmp($row['entryDate'], $entryDate) <= 0){
                        // 日付を比較して $entryDate より古いか同じものなら上書き
                        // entryDate も上書きすると後で別フィールドが比較できなくなってしまう
                        $sql="UPDATE `$table`
                        SET `$field`='$val',`updateTime`='$updateTime'
                        WHERE `rowid`=".$row['rowid'];
                        echo "$sql \n"; // message
                        mysql_query($sql);
                    }
                }
            } else { // 同じ patientId のデータが存在しなかった
                $sql = "INSERT INTO `$table`
                (`patientId`,`$field`,`entryDate`,`updateTime`)
                VALUES ('$patientId','$val','$entryDate','$updateTime')";
                echo "$sql \n"; // message
                mysql_query($sql);
            }
        } else {
            $sql = "SELECT * FROM `$table` WHERE `patientId`='$patientId'
            AND `entryDate`='$entryDate' AND `updateTime`='$updateTime'";
            echo "$sql \n"; // message
            
            $result=mysql_query($sql);
            if (mysql_num_rows ($result) > 0){ // 同じID・日付・更新時のデータが存在した
                $row=mysql_fetch_array($result);
                if (strcmp($row[$field], $val) <> 0){ // データが異なった
                    $sql="UPDATE `$table` 
                    SET `$field`='$val',`updateTime`='$updateTime' 
                    WHERE `rowid`=".$row['rowid'];
                    echo "$sql \n"; // message
                    mysql_query($sql);
                }
            } else { // 同じID・日付・更新時のデータが存在しなかった
                $sql = "INSERT INTO `$table` 
                (`patientId`,`$field`,`entryDate`,`updateTime`,`owner`)
                VALUES ('$patientId','$val','$entryDate','$updateTime','$owner')";
                echo "$sql \n"; // message
                mysql_query($sql);
            }
        }
    }
    
    function putTimeStamp(){
        // データ更新のタイムスタンプを記憶
        $timestamp = date("Y-m-d H:i:s",time());
        $sql = "SELECT `rowid` FROM `FrontTable` WHERE `patientId`='STAMP'";
        $result=mysql_query($sql);
        if (mysql_num_rows ($result) > 0){	// STAMP が存在した
            $row=mysql_fetch_array($result);
            $sql = "UPDATE `FrontTable` SET `updateTime`='$timestamp' WHERE `patientId`='STAMP'";
        } else {							// STAMP が存在しなかった
            $sql = "INSERT INTO `FrontTable` (`patientId`, `updateTime` ) VALUES ('STAMP', '$timestamp')";
        }
        mysql_query($sql);
    }
    function getTimeStamp($from, $to, $timeStamp, $apps){
        // ### args が変更されたので以下を変更のこと ########
        
        // タイムスタンプと同じものがあれば "same" なければ、旧スタンプを返す
        // $apps はサーバにリクエストを送ったアプリケーション
        $sql = "SELECT * FROM `FrontTable` WHERE `patientId`='STAMP'";
        $result=mysql_query($sql);
        if (mysql_num_rows ($result) > 0){	// タイムスタンプが存在した
            $row=mysql_fetch_array($result);
            $updateTime = $row['updateTime'];
            $from = $row['owner']; // メッセージの送付元
            $to = $row['anotherId']; // メッセージの送付先
            $message = $row['plan']; // 送付メッセージ
            $sender = $row['kanjiName']; // リクエストを送ったアプリケーション
            //$receiver = $row['mishuu']; // リクエストを送ったアプリケーション
            
            // タイムスタンプが同じなら "same" を返す
            if ($updateTime == $entryDate)
                return "same";
            else if ($sender == $apps) // メッセージ・パネルを表示
                return "$updateTime^$from^$to^$sender^$receiver^$message";
            else // FRONT を再描画
                return $updateTime;
        } else { // タイムスタンプが存在しなかった
            return "empty";
        }
    }
	
    function recordsForKeys($patientId, $owner, $st){
        // kyes を含むすべてのレコードを返す
        $keys = explode(",", $st); // セパレータ "," はクライアントとの約束ごと
        $keyCount = count($keys);
        
        // keys は配列ではなくセパレータで区切られた文字列
        $sql = "SELECT * FROM `ProgressSection` WHERE `patientId`='$patientId' ORDER BY `entryDate` DESC";
        echo "$sql -----\n"; //##
        $result=mysql_query($sql);
        
        $array = array();
        while ($row=mysql_fetch_array($result)){
            if (isRemovedPage($row)) continue; // 削除されたレコードはスキップ
            
            $date = $row['entryDate'];
            $objc = $row['object'];
            $exam = $row['examination'];
            $ln = $objc.$exam; // object と examination 両方を検索対象にする
            for ($i=0; $i < $keyCount; $i++){
                $key = $keys[$i]."(";
                if (strpos($ln, $key) !== FALSE){
                    $array[$date] = $ln;
                    break;
                }
            }
        }
        
        return $array;
    }
    
    function isInScopeOf($from, $filename, $to){
        // $filename が $from と $to の範囲内なら true を返す
        
        // $from,$to: "2012-06-05 15:58:00" を "20120605" 形式にする
        $array = explode(" ", $from);
        $ymd = explode("-", $array[0]);
        $fromSt = join("", $ymd);
        
        $array = explode(" ", $to);
        $ymd = explode("-", $array[0]);
        $toSt = join("", $ymd);
        
        // $filename: "10135100_20120316091412.JPG" を "20120316" 形式にする
        $array = explode("_", $filename);
        $st = (count($array) < 3) ? $array[1] : $array[2];
        $fnSt = substr($st, 0, 8);
        
        echo "$filename -- $fromSt | $fnSt | $toSt <br>";
        
        if ($fnSt * 1 < $fromSt * 1) return false;
        if ($toSt * 1 < $fnSt * 1) return false;
        echo "==> hit <br>";
        
        return true;
    }
    
    function getAccessLog($owner, $reverse){
        // owner のアクセス・ログを返す
        $sql = "SELECT * FROM `BasicSection` WHERE `drinking`='ACCESS_LOG' AND `owner`='$owner'";
        $result=mysql_query($sql);
        echo "$sql \n";
        
        // pid が key となるので日付でソートしても意味が無い
        $records = array();
        while ($row=mysql_fetch_array($result)){
            $rec = array();
            $pid = $row['patientId'];
            $rec['date'] = $row['updateTime'];
            $rec['name'] = $row['bloodtype'];
            $rec['rowid'] = $row['rowid'];
            $records[$pid] = $rec;
        }
        
        // date でソートするための配列を作る
        $array = array();
        foreach ($records as $pid=>$rec){
            $date = $rec['date'];
            $rec['pid'] = $pid;
            $array[$date] = $rec;
        }
        if ($reverse * 1 > 0)
            asort($array); // ソート
        else
            arsort($array); // 逆順にソート
        
        return $array;
    }
    function putAccessLog($patientId, $owner, $limit){
        // アクセス・ログにも patientId を記憶: BasicSection に記憶
        // ## 日時を entryDate に格納すると BasicSection データとして表示されてしまうので
        // ## entryDate は空白とし updateTime に日時を格納
        // ## 目印のため 'drinking' に 'ACCESS_LOG' を格納
        $records = getAccessLog($owner);
        $namrow = nameSectionWithPatientId($patientId);
        $patientName = $namrow['patientKanjiName'];
        $updateTime = timestamp();
        
        // $recrds 内の $patientId の有無を調べ、最終レコード $rec を得る
        $found = 0;
        foreach ($records as $date=>$rec){
            echo $rec['pid']." -- $patientId \n"; //##
            if ($rec['pid'] == $patientId)
                $found = 1; // $lastRowId を得るため、ここで break しない
            $lastRowId = $rec['rowid'];
        }
        echo "putAccessLog count:".count($records)." found:$found \n"; //##
        
        if ($found > 0){
            // $patientId が過去ログに存在したので $updateTime のみ更新
            $sql = "UPDATE `BasicSection` SET `updateTime`='$updateTime' WHERE `drinking`='ACCESS_LOG' AND `patientId`='$patientId' AND `owner`='$owner'";
        } else if (count($records) >= $limit){
            // 最終レコード $lastRowId のレコードを指定されたデータと置換する
            $sql = "UPDATE `BasicSection` SET `patientId`='$patientId',`bloodType`='$patientName',`updateTime`='$updateTime' WHERE `rowid`='$lastRowId'";
        } else {
            $sql = "INSERT INTO `BasicSection` (`patientId`,`drinking`,`bloodType`,`updateTime`,`owner`) VALUES ('$patientId','ACCESS_LOG','$patientName','$updateTime','$owner')";
        }
        $result=mysql_query($sql);
        echo "$sql \n";
    }
    function removeAccessLog($patientId, $owner){
        $sql = "DELETE FROM `BasicSection` WHERE `patientId`='$patientId' AND `owner`='$owner'";
        echo "$sql ========\n"; //###
        mysql_query($sql);
        
        return getAccessLog($owner);
    }

    function insScanDate($patientId){
        // patientId の保険証を最後にスキャンした日付を返す
        $results = array();
        $array = array();
        $dir = "../NOA_ARCHIVE/$patientId/Insurance";
        $files = scandir($dir);
        for ($i=0,$count=count($files); $i < $count; $i++){
            $filename = $files[$i];
            if ($filename == ".") continue;
            if ($filename == "..") continue;
            
            // 行頭に "_" のついた削除済みファイルは無視
            if (substr($filename, 0, 1) == "_") continue;
            
            if (strlen($filename) == 0) continue;
            $array[] = $filename; // filename="03234202_20120113165123.JPG" 形式
        }
        rsort($array); // 逆順にソート
        $results['path'] = $dir;
		$results['filename'] = $array[0]; // 直近のファイル名
        return $results;
    }
    






    
    $command = $_GET['command']; $command=htmlspecialchars($command);
    $value = $_GET['value']; $value=htmlspecialchars($value);
    $value = decodeSTRING($value); 
    
    // DB を開いて該当レコードを読み込む
    // ### セキュリティーを保つには、以下のファイルを外からアクセスできない 
    // ### directory に置き、以下の cfg.php の pass をそこへ変更
    require_once('cfg.php');
    
    $dbc = mysql_connect($db['host'], $db['user'], $db['pwd']);
    $db_select=mysql_select_db($db['dbname']);
    mysql_query("set names utf8");

    
    if (strcmp($command,"GET_PATIENTS") == 0){
        // カルテID、氏名、ふりがななどでカルテを検索
        
        $args = decodeObject($value);
        $key = $args['key'];
        $val = $args['val'];
        echo "key($key) val($val) \n"; //return; //###
        
        if (strcmp($key, "id") == 0){
            // カルテID による検索
            $sql = "SELECT * FROM `PatientTable`
            WHERE `patientId` LIKE '$val%'
            ORDER BY `patientId`";
            $result=mysql_query($sql);
            echo "$sql \n"; //return; //###
            $records = array();
            while ($row=mysql_fetch_array($result)){
                $nameRow = nameSectionWithPatientId($row['patientId']);
                $row['patientKanjiName'] = $nameRow['patientKanjiName'];
                $row['patientRomajiName'] = $nameRow['patientRomajiName'];
                $records[] = $row;
            }
            echo "<SEPARATOR>";
            echo json_encode($records);
        } else if (strcmp($key, "anotherId") == 0){ // anotherId による検索
            $sql = "SELECT * FROM `PatientTable`
            WHERE `anotherId` LIKE '$val%'
            ORDER BY `anotherId`";
            $result=mysql_query($sql);
            echo "$sql \n"; //###
            $records = array();
            while ($row=mysql_fetch_array($result)){
                $nameRow = nameSectionWithPatientId($row['patientId']);
                $row['patientKanjiName'] = $nameRow['patientKanjiName'];
                $row['patientRomajiName'] = $nameRow['patientRomajiName'];
                $records[] = $row;
            }
            // 重複した patientId のものをユニークにする
            $rec = array();
            while (list($pid, $ary) = each ($records)) $rec[] = $ary;
            echo "<SEPARATOR>";
            echo json_encode($rec);
        } else if (strcmp($key, "kana") == 0){ // ローマ字による検索
            $sql = "SELECT * FROM `NameSection`
            WHERE `patientRomajiName` LIKE '%$val%'
            ORDER BY `patientId`";
            $result=mysql_query($sql);
            echo "$sql \n"; //###
            $records = array();
            while ($row=mysql_fetch_array($result)){
                $patientrow = patientTableWithPatientId($row['patientId']);
                $row['lastVisitDate'] = $patientrow['lastVisitDate'];
                $records[$row['patientId']] = $row;
            }
            // 重複した patientId のものをユニークにする
            $rec = array();
            while (list($pid, $ary) = each ($records)) $rec[] = $ary;
            echo "<SEPARATOR>";
            echo json_encode($rec);
        } else { // 漢字による検索
            // 姓名の間に空白がある場合、スペースが半角でも全角でも検索する
            $array = explode(" ", $val); // 半角スペースが存在するか
            if (count($array) == 1)
                $array = explode("　", $val); // 全角スペースが存在するか
            if (count($array) > 1){
                $sei = $array[0];
                $mei = $array[1];
                $sql = "SELECT * FROM `NameSection`
                WHERE `patientKanjiName` LIKE '%$sei%'
                AND `patientKanjiName` LIKE '%$mei%'
                ORDER BY `patientId`";
            } else {
                $sql = "SELECT * FROM `NameSection`
                WHERE `patientKanjiName` LIKE '%$val%'
                ORDER BY `patientId`";
            }
            
            $result=mysql_query($sql);
            echo "$sql \n"; //###
            $records = array();
            while ($row=mysql_fetch_array($result)){
                $patientrow = patientTableWithPatientId($row['patientId']);
                $row['lastVisitDate'] = $patientrow['lastVisitDate'];
                $records[$row['patientId']] = $row;
            }
            // 重複した patientId のものをユニークにする
            $rec = array();
            while (list($pid, $ary) = each ($records)) $rec[] = $ary;
            echo "<SEPARATOR>";
            echo json_encode($rec);
        } 
    } else if (strcmp($command,"GET_LAYOUT") == 0){
        // NOA のレイアウトをサーバから取得：layou.js で使う
        // NOA 立ち上げ時は GET_ALL_CELL_ATTRIBUTES でユーザや施設情報とともに取得

        // DB 構造をチェック、必要なら新しい構造に調整
        checkDatabseStructure();

        $args = decodeObject($value); // client 側との約束ごと
        $owner = $args['owner'];
        
        $layout = getLayout($owner);
        echo "<SEPARATOR>";
        echo json_encode($layout);
    } else if (strcmp($command,"GET_ALL_CELL_ATTRIBUTES") == 0){
        // label に値の有るレコードのオブジェクトを返す
        $args = decodeObject($value); // client 側との約束ごと
        $owner = $args['owner'];
        
        // UserTable, HospitalTable の値も同梱して返す
        $layout = getLayout($owner);
        $userList = getUserList();
        $userInfo = getUser($owner); // echo するので separator より前で処理
        $hospitalId = $userInfo['hospitalId'];
        $hospitalInfo = getHospital($hospitalId);
        echo "<SEPARATOR>";
        $records = array();
        $records['records'] = $layout;
        $records['userList'] = $userList;
        $records['userInfo'] = $userInfo;
        $records['hospitalInfo'] = $hospitalInfo;
        echo json_encode($records);
    } else if (strcmp($command,"SET_CELL_ATTRIBUTES") == 0){
        // CELL 属性を保存
        $args = decodeObject($value);
        
        // === Ror FieldTable ===
        $owner = $args['owner'];
        $id = $args['id']; // _progress, _basic, _insurance：LAYOUT 編集で扱う
        $tag = $args['tag'];
        $buttonType = $args['buttonType'];
        $fieldType = $args['fieldType'];
        $menuType = $args['menuType'];	
        $menuAction = $args['menuAction'];
        $label = $args['label'];		
        $hitAndRun = $args['hitAndRun']; // 表示・非表示：LAYOUT 編集で扱う
        $numbering = $args['numbering']; // CELL の表示順：LAYOUT 編集で扱う
        $study = $args['study'];
        $fontSize = $args['fontSize'];	
        $fontFamily = $args['fontFamily'];	
        $color = $args['color'];			
        $bgcolor = $args['bgcolor'];
        $direction = 'CELL';
        $disabled = $args['disabled'];		
        $script = $args['script'];			
        $editor = $args['editor'];
		
        // === For ProgressSection ===
        $subject = $args['ProgressSection.subject'];	
        $object = $args['ProgressSection.object'];	
        $examination = $args['ProgressSection.examination'];	
        $prescription = $args['ProgressSection.prescription'];	
        $disease = $args['ProgressSection.disease'];	
        $treatment = $args['ProgressSection.treatment'];	
        $assessment = $args['ProgressSection.assessment'];	
        $plan = $args['ProgressSection.plan'];	
        $updateTime = timestamp();
        
        // FieldTable をアップデート
        $sql = "SELECT * FROM `FieldTable` WHERE `tag`='$tag' AND `direction`='CELL' AND `owner`='$owner'";
        echo "$sql ========\n"; //###
        $result=mysql_query($sql);
        
        // 該当するデータがあれば更新、なければ追加
        if (mysql_num_rows ($result) > 0){
            $row=mysql_fetch_array($result);
            $rowid = $row['rowid'];
            $sql = "UPDATE `FieldTable` SET 
            `buttonType`='$buttonType'
            ,`fieldType`='$fieldType'
            ,`menuType`='$menuType'
            ,`menuAction`='$menuAction'
            ,`label`='$label'
            ,`numbering`='$numbering'
            ,`study`='$study'
            ,`fontSize`='$fontSize'
            ,`fontFamily`='$fontFamily'
            ,`color`='$color'
            ,`bgcolor`='$bgcolor'
            ,`direction`='CELL'
            ,`disabled`='$disabled'
            ,`id`='$id'
            ,`script`='$script'
            ,`editor`='$editor'
            ,`updateTime`='$updateTime'
            WHERE `rowid`='$rowid'";
        } else {
            $sql = "INSERT INTO `FieldTable` 
            ( `tag`,`buttonType`,`fieldType`,`menuType`,`menuAction`,`label`,`numbering`,`study`,`fontSize`,`fontFamily`,`color`,`bgcolor`,`direction`,`disabled`,`script`,`editor`,`id`,`updateTime`,`owner`)
            VALUES ( '$tag',0,'$fieldType','$menuType','$menuAction','$label','$numbering','$study','$fontSize'
                    ,'$fontFamily','$color','$bgcolor','CELL','$disabled','$script'
                    ,'$editor','$id','$updateTime','$owner')";
        }
        echo "$sql ========\n\n"; //###
        mysql_query($sql);

        if ($subject){ // GROUP MENU があれば
            // ProgressSection をアップデート：GROUP MENU 用
            $sql = "SELECT `subject` FROM `ProgressSection` WHERE `patientId`='GroupMenu' AND `subject`='$subject' AND `owner`='$owner'";
            echo "$sql ========\n"; //###
            $result=mysql_query($sql);
            
            // 該当するデータがあれば更新、なければ追加
            if (mysql_num_rows ($result) > 0){
                $sql = "UPDATE `ProgressSection` SET 
                `object`='$object'
                ,`examination`='$examination'
                ,`prescription`='$prescription'
                ,`disease`='$disease'
                ,`treatment`='$treatment'
                ,`assessment`='$assessment'
                ,`plan`='$plan'
                ,`updateTime`='$updateTime'
                WHERE `patientId`='GroupMenu' AND `subject`='$subject' AND `owner`='$owner'";
            } else {
                $sql = "INSERT INTO `ProgressSection` 
                ( `patientId`,`subject`,`object`,`examination`,`prescription`,`disease`
                 ,`treatment`,`assessment`,`plan`,`freq`,`updateTime`,`owner`)
                VALUES ( 'GroupMenu',’$subject’,'$object','$examination','$prescription','$disease','$treatment','$assessment','$plan','$freq','$updateTime','$owner')";
            }
            echo "$sql ========\n\n"; //###
            mysql_query($sql);
        }

        // 変更結果を返す
        echo "<SEPARATOR>";
        echo "SET_CELL_ATTRIBUTES: $tag のデータは更新されました";
    } else if (strcmp($command,"PUT_MENU") == 0){
        // tag, onwer に該当するメニュー・リストを DB へ保存
        // address.js form.js で使う
        // IN: tag owner menuItem val menuAction freq
        // OUT: array["menuAcion"]=val, array[menuItem]="freq:val",,,
        $args = decodeObject($value);
        $tag = $args['tag'];
        $owner = $args['owner'];
        $menuItem = $args['menuItem'];
        $menuItem = decodeSTRING($menuItem);
        $freq = $args['freq'];
        $val = $args['val'];
        $dateTime = timeStamp();
        
        if (strlen($menuItem)){
            // MenuTable をアップデート
            // ### tag(メニュー名称)は他人とダブルことはできない
            $sql = "SELECT * FROM `MenuTable` WHERE `tag`='$tag' AND `menu`='$menuItem' AND `template` IS NULL  AND `owner`='$owner'";
            echo "$sql ========\n"; //###
            $result=mysql_query($sql);
            if (mysql_num_rows ($result) > 0){	// 同じ menuItem が存在した
                $row=mysql_fetch_array($result);
                $rowid = $row['rowid'];
                // menuItem は同じなので freq のみ更新
                if (strlen($freq) == 0) $freq = $row['freq'] + 1; // 頻度インクリメント
                $_val = (strlen($val) > 0) ? ",`value`='$val'" : "";
                
                $sql = "UPDATE `MenuTable` 
                SET `freq`='$freq',`updateTime`='$dateTime' $_val 
                WHERE `tag`='$tag' AND `menu`='$menuItem' 
				AND `owner`='$owner'";
            } else { // 同じ menuItem が存在しなかった
                if (strlen($freq) == 0) $freq = 0;
                $sql = "INSERT INTO `MenuTable` 
                ( `tag`,`freq`,`menu`,`value`,`updateTime`,`owner` )
                VALUES ( '$tag','$freq','$menuItem','$val','$dateTime','$owner')";
            }
            echo "$sql ========\n"; //###
            mysql_query($sql);
        }
        
        // 変更結果を返す
        $array = getMenuItems($tag, $owner);
        echo "<SEPARATOR>";
        echo json_encode($array);
    } else if (strcmp($command,"PUT_MENU_TEMPLATE") == 0){
        // tag, onwer に該当するメニュー・リストを DB へ保存
        // address.js form.js で使う
        // IN: tag owner menuItem val menuAction freq
        // OUT: array["menuAcion"]=val, array[menuItem]="freq:val",,,
        $args = decodeObject($value);
        $tag = $args['tag'];
        $owner = $args['owner'];
        $menuItem = $args['menuItem'];
        $menuItem = decodeSTRING($menuItem);
        $tempName = $args['tempName'];
        $tempName = decodeSTRING($tempName);
        $freq = $args['freq'];
        $val = $args['val'];
        $dateTime = timeStamp();
        
        if (strlen($menuItem)){
            // MenuTable をアップデート
            // ### tag(メニュー名称)は他人とダブルことはできない
            $sql = "SELECT * FROM `MenuTable` WHERE `tag`='$tag' AND `menu`='$menuItem' AND `template`='$tempName' AND `owner`='$owner'";
            echo "$sql ========\n"; //###
            $result=mysql_query($sql);
            if (mysql_num_rows ($result) > 0){	// 同じ menuItem が存在した
                $row=mysql_fetch_array($result);
                $rowid = $row['rowid'];
                // menuItem は同じなので freq のみ更新
                if (strlen($freq) == 0) $freq = $row['freq'] + 1; // 頻度インクリメント
                $_val = (strlen($val) > 0) ? ",`value`='$val'" : "";
                
                $sql = "UPDATE `MenuTable` SET `freq`='$freq',`updateTime`='$dateTime' $_val WHERE `rowid`='$rowid'";
            } else { // 同じ menuItem が存在しなかった
                if (strlen($freq) == 0) $freq = 0;
                $sql = "INSERT INTO `MenuTable`
                ( `tag`,`freq`,`menu`,`template`,`value`,`updateTime`,`owner` )
                VALUES ( '$tag','$freq','$menuItem','$tempName','$val','$dateTime','$owner')";
            }
            echo "$sql ========\n"; //###
            mysql_query($sql);
        }
        
        // 変更結果を返す
        $array = getMenuItems($tag, $owner);
        echo "<SEPARATOR>";
        echo json_encode($array);
    } else if (strcmp($command,"REMOVE_MENU") == 0){
        // メニューを削除
        // menuItem 末尾が % なら like 検索でマッチするものを削除
        $args = decodeObject($value);
        $tag = $args['tag'];
        $owner = $args['owner'];
        $menuItem = $args['menuItem'];
        $menuItem = decodeSTRING($menuItem);
        
        $lastMenuItem = substr($menuItem, -1);
        if (strcmp($lastMenuItem, "%") == 0)
            $cond = "`menu`LIKE'$menuItem'";
        else 
            $cond = "`menu`='$menuItem'";
        
        $sql = "DELETE FROM `MenuTable` 
        WHERE `tag`='$tag' AND `owner`='$owner' AND $cond";
        echo "$sql ========\n"; //###
        mysql_query($sql);
        
        // 変更結果を返す
        $array = getMenuItems($tag, $owner);
        echo "<SEPARATOR>";
        echo json_encode($array);
    } else if (strcmp($command,"PUT_GROUP_MENU") == 0){
        // とりあえずは GROUP MENU の頻度更新のみ
        $args = decodeObject($value);
        $owner = $args['owner'];
        $freq = $args['freq'];
        $menuItem = decodeSTRING($args['menuItem']);
        $subject = decodeSTRING($args['ProgressSection.subject']);
        $object = decodeSTRING($args['ProgressSection.object']);
        $assessment = decodeSTRING($args['ProgressSection.assessment']);
        $plan = decodeSTRING($args['ProgressSection.plan']);
        $disease= decodeSTRING($args['ProgressSection.disease']);
        $examination = decodeSTRING($args['ProgressSection.examination']);
        $prescription = decodeSTRING($args['ProgressSection.prescription']);
        $treatment = decodeSTRING($args['ProgressSection.treatment']);
        $updateTime = timestamp();
        
        if (strcmp($freq, "-1") == 0){
            // $freq が 負数 ならその $menuItem の削除命令となる
            $sql = "DELETE FROM `ProgressSection` WHERE `patientId`='GroupMenu' AND `subject`='$menuItem' AND `owner`='$owner'";
            echo "$sql ========\n"; //###
            $result=mysql_query($sql);
            echo "<SEPARATOR>";
            echo "groupMenu: $menuItem are removed...";
        } else {
            $sql = "SELECT * FROM `ProgressSection` WHERE `patientId`='GroupMenu' AND `subject`='$menuItem' AND `owner`='$owner'";
            echo "$sql ========\n"; //###
            $result=mysql_query($sql);
            
            // 該当するデータがあれば更新、なければ追加
            if ($row=mysql_fetch_array($result)){
                if (strlen($freq) == 0) {
                    // $freq == "" なら頻度のインクリメントのみ行う
                    $freq = $row['freq'] + 1; // 頻度インクリメント
                    $sql = "UPDATE `ProgressSection`  
                    SET `freq`='$freq',`updateTime`='$updateTime'
                    WHERE `patientId`='GroupMenu' AND `subject`='$menuItem' AND `owner`='$owner'";
                } else {
                    $sql = "UPDATE `ProgressSection` SET 
                    `object`='$object'
                    ,`examination`='$examination'
                    ,`prescription`='$prescription'
                    ,`disease`='$disease'
                    ,`treatment`='$treatment'
                    ,`assessment`='$assessment'
                    ,`plan`='$plan'
                    ,`freq`='$freq'
                    ,`updateTime`='$updateTime'
                    WHERE `patientId`='GroupMenu' AND `subject`='$menuItem' AND `owner`='$owner'";
                }
            } else {
                $sql = "INSERT INTO `ProgressSection` 
                ( `patientId`,`subject`,`object`,`examination`,`prescription`,`disease`
                 ,`treatment`,`assessment`,`plan`,`freq`,`updateTime`,`owner`)
                VALUES ( 'GroupMenu','$subject','$object','$examination','$prescription','$disease','$treatment','$assessment','$plan','$freq','$updateTime','$owner')";
            }
            
            echo "$sql ========\n\n"; //###
            mysql_query($sql);
            echo "<SEPARATOR>";
            echo $freq;
        }
    } else if (strcmp($command,"GET_MENU") == 0){
        // tag, onwer に該当するメニュー・リストを返す
        $args = decodeObject($value); // client 側との約束ごと
        $array = getMenuItems($args['tag'], $args['owner']);
        echo "<SEPARATOR>";
        echo json_encode($array);
    } else if (strcmp($command,"GET_FRONT_PATIENTS") == 0){
        // FRONT の本日の受診者リストをサーバへリクエスト
        $args = decodeObject($value); // client 側との約束ごと
        $entryDate = $args['entryDate'];
		$beginDate = substr($entryDate,0,10)." 00:00:00";
		$endDate = substr($entryDate,0,10)." 23:59:59";
		
		$sql = "SELECT * FROM `FrontTable` WHERE `entryDate`>='$beginDate' AND `entryDate`<='$endDate' ORDER BY `entryDate` DESC";
		echo "===\n $sql \n"; //##
		
		// $entryDate の受診者の patientId を配列で返す
		$array = array();
		$result=mysql_query($sql);
        // 該当するレコードの patientId をピックアップ
        while ($row=mysql_fetch_array($result)){
            $rec = array();
            $rec['patientId'] = $row['patientId'];
            $rec['name'] = $row['kanjiName'];
            $rec['endTime'] = $row['endTime'];
            $edate = $row['entryDate'];
            $array[$edate] = $rec;
        }
        echo "<SEPARATOR>";
        echo json_encode($array);
    } else if (strcmp($command,"GET_PROGRESS_SECTION") == 0){
        // $patientId の ProgressSection データを全て返す
        // 同時にアクセス・ログにも patientId を記憶
        $args = decodeObject($value);
        $owner = $args['owner']; // putAccessLog() で使用
        $patientId = $args['patientId'];
        $sql = "SELECT * FROM `ProgressSection` WHERE `patientId`='$patientId' AND (`freq` IS NULL OR `freq`<1) ORDER BY `entryDate` DESC";
        echo "$sql \n"; //###
        $result=mysql_query($sql);
        // 受診日毎の ProgressSection 
        $recs = array();
        while ($row=mysql_fetch_array($result)){
            $date = $row['entryDate'];
            echo "$date \n"; //###
            // 同じ entryDate の別レコードで一部フィールドだけ更新されることがあるので
            // 以下のような処理で一部フィールドだけの更新に対応
            if ($row['pageHeader']) 
                $recs[$date]['pageHeader'] = $row['pageHeader'];
            if (!$recs[$date]['pageHeader']) $recs[$date]['pageHeader'] = "";
            
            if ($row['subject']) 
                $recs[$date]['subject'] = $row['subject'];
            if (!$recs[$date]['subject']) $recs[$date]['subject'] = "";
            if ($row['object']) 
                $recs[$date]['object'] = $row['object'];
            if (!$recs[$date]['object']) $recs[$date]['object'] = "";
            if ($row['examination']) 
                $recs[$date]['examination'] = $row['examination'];
            if (!$recs[$date]['examination']) $recs[$date]['examination'] = "";
            if ($row['prescription']) 
                $recs[$date]['prescription'] = $row['prescription'];
            if (!$recs[$date]['prescription']) $recs[$date]['prescription'] = "";
            if ($row['disease']) 
                $recs[$date]['disease'] = $row['disease'];
            if (!$recs[$date]['disease']) $recs[$date]['disease'] = "";
            if ($row['treatment']) 
                $recs[$date]['treatment'] = $row['treatment'];
            if (!$recs[$date]['treatment']) $recs[$date]['treatment'] = "";
            if ($row['assessment']) 
                $recs[$date]['assessment'] = $row['assessment'];
            if (!$recs[$date]['assessment']) $recs[$date]['assessment'] = "";
            if ($row['plan']) 
                $recs[$date]['plan'] = $row['plan'];
            if (!$recs[$date]['plan']) $recs[$date]['plan'] = "";
            
            $recs[$date]['owner'] = $row['owner'];
        }
        
        // アクセス・ログにも patientId を記憶
        $limit = 200; // $limit の数しかアクセス・ログを記憶しない
        putAccessLog($patientId, $owner, $limit);

        echo "<SEPARATOR>";
        echo json_encode($recs);
    } else if (strcmp($command,"GET_PAGE") == 0){
        // ページに表示される "CELL の table,field 名" の配列を入れたリクエストを受け
        // 夫々の CELL にデータを入れて返す
        // IN: patientId entryDate owner "tag,tag,tag,,"
        // OUT: [{tag=value},{tag=val},,] 形式で tag に該当するデータを返す
        $args = decodeObject($value);
        // client 側との約束ごと
        $pid = $args['patientId'];
        $edate = $args['entryDate'];
        $udate = $args['updateTime'];
        $owner = $args['owner'];
        $tagArray = $args['tagArray']; // "table.field,table.field,,,"

        // ProgressSection.pageHeader に "REMOVED" が入ったページのリストを作成
//        $rlist = removedList($pid);
        
        // DB アクセス能率化のため、テーブルごとに field をまとめておく
        $struct = tableFieldArray($tagArray);
        
        // $cells: {"table.field":"value",,,} のような CELL 単位のオブジェクトを生成
        $cells = array();
        while (list($table, $fields) = each ($struct)){
            // テーブルごとに query をかける
            $cells = getValues($owner, $cells, $pid, $edate, $udate, $table, $fields, "",FALSE);
        }

        // PostIt データを追加
        // ## この場合の value は単なる文字列ではなく、以下のようなオブジェクト
        // $array['value'] = $row['dataString'];
        // $array['type'] = $row['type'];
        // $array['entryDate'] = $row['entryDate'];
        // $array['updateTime'] = $row['updateTime'];
        $postItArray = getPostIt($pid, $edate, $owner);
        if (count($postItArray) > 0)
            $cells["UniversalSection.postIt"] = $postItArray;
       
        echo "<SEPARATOR>";
        // レイアウト構造と受診履歴を返す
        echo json_encode($cells);
    } else if (strcmp($command,"ADD_PAGE") == 0){
        // entryDate の入った空レコードを ProgressSection に挿入
        // IN: patientId entryDate owner
        // OUT: [entryDate.num,entryDate.num,,] の配列を返す
        //      num は [...治療:開始] 形式のカウント回数が入る
        $args = decodeObject($value);
        $patientId = $args['patientId'];
        $entryDate = $args['entryDate'];
        $owner = $args['owner'];
        
        // ProgressSection 内で patientId に一致し entryDate 直近のレコードを探す
        // entryDate と同じ年月日のレコードが存在するかどうかチェック
        $sql = "SELECT * FROM `ProgressSection`
        WHERE `patientId`='$patientId' AND `entryDate`<='$entryDate'
        ORDER BY `entryDate` DESC, `updateTime` DESC";
        echo "$sql -----\n"; //##
        $result=mysql_query($sql);
        $edate = substr($entryDate, 0, 10);
        //echo "<p>entryDate: $entryDate -> edate($edate) </p>"; //##
        while ($row=mysql_fetch_array($result)){
            $date = substr($row['entryDate'], 0, 10);
            //echo "<p>row: '".$row['entryDate']."' -> date($date) -----</p>"; //##
            if (strcmp($date, $edate) < 0){
                echo "<p>*** 挿入位置以前の $date がありました</P>";
                break; // 挿入したいページより以前のレコードはスキャン不要
            }
        }
        
        // entryDate のレコードを ProgressSession へ新たに追加
        $updateTime = timestamp();
        $sql = "INSERT INTO `ProgressSection` 
        ( `patientId`, `entryDate`, `updateTime`, `owner` )
        VALUES ('$patientId','$entryDate','$updateTime','$owner')";
        echo "$sql ==================\n";
        mysql_query($sql);
        
        // lastVisitDate(最終受診日)を PatientTable に記録する
        $sql = "UPDATE `PatientTable` 
        SET `lastVisitDate`='$entryDate',`updateTime`='$updateTime'
        WHERE `patientId`='$patientId'";
        echo "$sql ==================\n";
        mysql_query($sql);
        
        // 更新された受診履歴を返す
        $arroy = entryDateArray($patientId, $entryDate);
        echo "<SEPARATOR>";
        echo json_encode($arroy);
    } else if (strcmp($command,"REMOVE_PAGE") == 0){
        // 当日のページを全部削除
        // IN: patientId entryDate owner
        // OUT: 終了したら "<SEPARATOR>" -- 余り意味がないがとりあえず
        $args = decodeObject($value);
        $patientId = $args['patientId'];
        $entryDate = $args['entryDate'];
        $timeLimit = $args['timeLimit'];
        $owner = $args['owner'];
        
        // timeLimit 以内の ProgressSection レコードの有無をチェック
        $status = isEditableRecord("ProgressSection", "",
								   $patientId, $entryDate, $timeLimit);
        $where = "`patientId`='$patientId' AND `entryDate`='$entryDate'";
        $array = explode(":", $status);
        if ($array[0] * 1 > 0){
            // ProgressSection の更新が編集可能制限時間 timeLimit 以内だった
            // entryDate のレコード全てを削除
            $sql = "DELETE FROM `AddressSection` WHERE $where"; 
            echo "===\n $sql \n";
            mysql_query($sql);
            $sql = "DELETE FROM `BasicSection` WHERE $where"; 
            echo "===\n $sql \n";
            mysql_query($sql);
            $sql = "DELETE FROM `HealthInsurance` WHERE $where"; 
            echo "===\n $sql \n";
            mysql_query($sql);
            $sql = "DELETE FROM `MalitalSection` WHERE $where"; 
            echo "===\n $sql \n";
            mysql_query($sql);
            $sql = "DELETE FROM `NameSection` WHERE $where"; 
            echo "===\n $sql \n";
            mysql_query($sql);
            $sql = "DELETE FROM `ProgressSection` WHERE $where"; 
            echo "===\n $sql \n";
            mysql_query($sql);
            $sql = "DELETE FROM `PublicInsurance` WHERE $where"; 
            echo "===\n $sql \n";
            mysql_query($sql);
            $sql = "DELETE FROM `UniversalSection` WHERE $where"; 
            echo "===\n $sql \n";
            mysql_query($sql);
        } else {
            // 編集可能制限時間 timeLimit 以上経過しているのでレコード削除不可
            // すべてのセクションの同じ entryDate のレコードを対象に ######
            // freq に削除マークとして 1 を入れる
            $sql = "UPDATE `ProgressSection` 
			SET `freq`='1',`updateTime`='$updateTime'
			WHERE $where";
            echo "===\n $sql \n";
            mysql_query($sql);
        }
        $array['patientId'] = $patientId;
        echo "<SEPARATOR>";
        echo json_encode($arroy);
    } else if (strcmp($command,"PUT_PAGE") == 0){
        // value に含まれる "tagname"="value" で DB を更新
        // IN: patientId entryDate owner [tag:value,tag:value,,]
        // OUT: debug 用メッセージのみで、特になし
        $args = decodeObject($value);
        // client 側との約束ごと
        $owner = $args['owner'];
        $patientId = $args['patientId'];
        // この entryDate 以前のものを境として「修正」か「追加」かを決定する
        $entryDate = $args['entryDate'];
        // entryDate から timeLimit秒 過ぎるまでは直接修正可能
        // それを過ぎると新しいページを追加し上書きする形になる
        $timeLimit = $args['timeLimit'];
        $updateTime = timestamp();
        
        // "ProgressSection.Subject"="some thing" の配列をスキャンして
        // $sections['ProgressSection']['Subject']='腹痛';
        // $sections['ProgressSection']['Object']='特記所見なし'';
        // のような Section Table の配列として記憶
        $sections = array(); // Section Table を入れる配列
        $updateValues = array(); // 更新リクエストを入れる配列
        foreach ($args as $key=>$val){
            if (strcmp($key, "owner") == 0) continue; // tag 以外は無視
            if (strcmp($key, "patientId") == 0) continue; // tag 以外は無視
            if (strcmp($key, "entryDate") == 0) continue; // tag 以外は無視
            if (strcmp($key, "timeLimit") == 0) continue; // tag 以外は無視
            
            // 上記以外は "HealthInsurance.bangou" 形式の tag のはず
            $ary = explode(".", $key);
            $table = $ary[0]; // table = "HealthInsurance"
            if (count($ary) > 1){
                $field = $ary[1]; // field = "bangou"
                
                // $val が null の場合、処理時に認識されないので別途 $updateValues で記憶
                $sections[$table][$field] = $val;
                $updateValues[$table][$field] = "hasValue";
            } else {
                // "HealthInsurance" のように field 指定がされていない場合は「削除」を表す
                $sections[$table] = null;
            }
        }
		
        // $sections 中のテーブルごとに DB 処理
        foreach ($sections as $sectionName=>$fieldArray){
            echo ("# foreach --- $sectionName($fieldArray)---\n"); //##
            if ($fieldArray == null){
                // "PublicInsurance:" のように　table 指定だけで
                // field 指定がされていなければそのテーブルの該当レコードを削除
                // ## page そのものがなくなるので pageHeader の更新は不要
                $sql = "DELETE FROM `$sectionName`
                WHERE `patientId`='$patientId' AND `entryDate`='$entryDate'";
                mysql_query($sql); // $sql 実行 ####
                echo "===\n $sql \n"; //##
            } else if  (strcmp($sectionName, "PatientTable") == 0){
                // PatientTable の場合は別処理
                $farray = array();
                foreach ($fieldArray as $fieldName=>$value){
                    $farray[] = "`$fieldName`='$value'";
                }
                $fst = join(",", $farray);
                $sql = "UPDATE `PatientTable` 
                SET $fst,`updateTime`='$updateTime'
                WHERE `patientId`='$patientId'";
                mysql_query($sql); // $sql 実行 ####
                echo "===\n $sql \n"; //##
            } else if  (strcmp($sectionName, "FrontTable") == 0){
                // FrontTable について
                // $patientId,($entryDate の年月日部分) に一致するレコードを探す
                $beginDate = substr($entryDate,0,10)." 00:00:00";
                $endDate = substr($entryDate,0,10)." 23:59:59";
                $sql = "SELECT * FROM `FrontTable`
                WHERE `patientId`='$patientId'
                AND `entryDate`>='$beginDate' AND `entryDate`<='$endDate'";
                echo "===\n $sql \n"; //##
                $result=mysql_query($sql);
                // レコードがあれば　$fieldArray 内のものをアップデート
                if (mysql_num_rows ($result) > 0){
                    // 該当するレコードの rowid をピックアップ
                    $row=mysql_fetch_array($result);
                    $rowid = $row['rowid'];
                    
                    // field 名のカンマ区切り文字列を作成
                    $farray = array();
                    foreach ($fieldArray as $fieldName=>$value){
                        $farray[] = "`$fieldName`='$value'";
                    }
                    $fst = join(",", $farray);
                    
                    // fieldArray に該当するデータをアップデート
                    $sql = "UPDATE `FrontTable` 
                    SET $fst,`updateTime`='$updateTime'
                    WHERE `rowid`='$rowid'";
                    mysql_query($sql); // $sql 実行 ####
                    echo "===\n $sql \n"; //##
                    putTimeStamp(); // FRONT 画面を更新
                }
            } else if  (strcmp($sectionName, "UniversalSection") == 0){
                foreach ($fieldArray as $fieldName=>$value){
                    $status = isEditableRecord($sectionName, $fieldName,
                                               $patientId, $entryDate, $timeLimit);
                    $array = explode(":", $status); // $status = "1:rowid" 形式
                    $rowid = (count($array) > 1) ? $array[1] : null;
                    if ($array[0] * 1 > 0){ // 当日のページを UPDATE
                        // ## rowid でなく patientId,entryDate で UPDATE すると
                        // ## 該当するほかの updateTime のものも全て変更されてしまう
                        $sql = "UPDATE `$sectionName` 
                        SET `field`='$fieldName',`dataString`='$value'
                        ,`updateTime`='$updateTime',`owner`='$owner'".
                        " WHERE `rowid`='$rowid'";
                        mysql_query($sql); // $sql 実行 ####
                        echo "===\n $sql \n"; //##
                    } else {
                        // 在来の当日ページがあれば削除マーク(freq=1)をつける
                        $sql = "UPDATE `$sectionName` 
                        SET `freq`='1',`updateTime`='$updateTime'
                        ,`owner`='$owner'
                        WHERE `patientId`='$patientId'
                        AND `field`='$fieldName'
                        AND `entryDate`='$entryDate' 
                        AND (`freq` IS NULL OR `freq`<1)";
                        echo "===\n $sql \n"; //##
                        $result=mysql_query($sql);
                        
                        // 当日のページを作成して追加
                        $sql = "INSERT INTO `$sectionName` 
                        (`patientId`,`type`,`field`,`dataString`
                         ,`entryDate`,`updateTime`,`owner`)
                        VALUES ('$patientId','0','$fieldName','$value'
                                ,'$entryDate','$updateTime','$owner')";
                        mysql_query($sql); // $sql 実行 ####
                        echo "===\n $sql \n"; //##
                    }
                }
            } else {
                $status = isEditableRecord($sectionName, "", $patientId, 
                                           $entryDate, $timeLimit);
                $array = explode(":", $status); // $status = "1:rowid" 形式
                if ($array[0] * 1 > 0){ // 当日のページを UPDATE
                    $farray = array();
                    foreach ($fieldArray as $fieldName=>$value){
                        $farray[] = "`$fieldName`='$value'";
                    }
                    $fst = join(",", $farray);
                    // ## rowid でなく patientId,entryDate で UPDATE すると
                    // ## 該当するほかの updateTime のものも全て変更されてしまう
                    $rowid = (count($array) > 1) ? $array[1] : null;
                    $sql = "UPDATE `$sectionName`
                    SET $fst,`updateTime`='$updateTime',`owner`='$owner'
                    WHERE `rowid`='$rowid'";
                    mysql_query($sql); // $sql 実行 ####
                    echo "===\n $sql \n"; //##
                } else {
                    // 削除マークをつける前に、在来のレコードを取得しておく
                    $sql = "SELECT * FROM `$sectionName`
                    WHERE `patientId`='$patientId'
                    AND `entryDate`='$entryDate' AND (`freq` IS NULL OR `freq`<1)";
                    echo "===\n $sql \n"; //##
                    $result=mysql_query($sql);
                    $old_row=mysql_fetch_array($result);
                    
                    // 在来の当日ページに削除マーク(freq=1)をつける
                    $sql = "UPDATE `$sectionName` 
                    SET `freq`='1',`updateTime`='$updateTime',`owner`='$owner'".
                    " WHERE `patientId`='$patientId'
                    AND `entryDate`='$entryDate' AND (`freq` IS NULL OR `freq`<1)";
                    echo "===\n $sql \n"; //##
                    $result=mysql_query($sql); // query 成功
                    
                    // 在来レコード $old_row を $fieldArray 内容とマージ
                    $farray = array(); // フィールド名の配列
                    $varray = array(); // フィールド・データの配列
                    if ($old_row){
                        while (list($fieldName, $value) = each ($old_row)){
                            if ('0' <= $fieldName && $fieldName <= '99') continue;
                            if (strcmp($fieldName, 'patientId') == 0) continue;
                            if (strcmp($fieldName, 'entryDate') == 0) continue;
                            if (strcmp($fieldName, 'updateTime') == 0) continue;
                            if (strcmp($fieldName, 'owner') == 0) continue;
                            if (strcmp($fieldName, 'rowid') == 0) continue;
                            $farray[] = "`$fieldName`";
                            // $fieldArray に存在しないフィールドは、在来データのまま
                            // $updateValues[$sectionName][$fieldName] が存在する時だけ上書き
                            if (strlen($updateValues[$sectionName][$fieldName]) > 0)
                                $value = $fieldArray[$fieldName];
                            $varray[] = "'$value'";
                        }
                    } else {
                        while (list($fieldName, $value) = each ($fieldArray)){
                            $farray[] = "`$fieldName`";
                            $varray[] = "'$value'";
                        }
                    }
                    
                    // マージしておいたレコードを当日ページとして追加
                    $fst = join(",", $farray); // フィールド名をカンマ区切りに展開
                    $vst = join(",", $varray); // フィールド・データをカンマ区切りに展開
                    $sql = "INSERT INTO `$sectionName`
                    ($fst,`patientId`,`entryDate`,`updateTime`,`owner`) 
                    VALUES ($vst,'$patientId','$entryDate',
                            '$updateTime','$owner')";
                    mysql_query($sql); // $sql 実行 ####
                    echo "===\n $sql \n"; //##
                }
            }
        }
        
        // $patientId, $entryDate, freq IS NULL のレコードが
        // あれば pageHeader 更新、なければ新たに追加
        $st = "Recorded at ... $updateTime ( by $owner )";
        $sql = "SELECT * FROM `ProgressSection` 
        WHERE `patientId`='$patientId' 
        AND `entryDate`='$entryDate' AND (`freq` IS NULL OR `freq`<1)";
        echo "$sql --- check pageHeader\n"; //###
        $result=mysql_query($sql);
        if ($row=mysql_fetch_array($result)){
            $rowid = $row['rowid'];
            $sql = "UPDATE `ProgressSection` 
            SET `pageHeader`='$st' 
            WHERE `rowid`='$rowid'";
        } else {
            $sql = "INSERT INTO `ProgressSection`
            (`patientId`,`pageHeader`,`entryDate`,`updateTime`,`owner`) 
            VALUES ('$patientId','$st','$entryDate','$updateTime','$owner')";
        }
        echo "----- update pageHeader \n $sql \n"; //##
        $result=mysql_query($sql);
        
        echo "<SEPARATOR>";
        echo json_encode($args);
    } else if (strcmp($command,"GET_GROUP_MENU_ITEMS") == 0){
        // グループ・メニューのテンプレートを返す
        $args = decodeObject($value);
        // client 側との約束ごと
        $owner = $args['owner'];
        $menuItem = $args['menuItem'];
        
        // $itemName に対応する各フィールド・データを取得
        $sql = "SELECT * FROM `ProgressSection`
        WHERE `patientId`='GroupMenu' AND `subject`='$menuItem' 
        AND `owner`='$owner'";
        echo "===\n $sql \n";
        $result=mysql_query($sql);
        if (mysql_num_rows ($result) == 0){
            echo "\n=== Template for ($owner) not found ===\n$sql\n";
            // owner のデータが無かったので public のものを探す
            $sql = "SELECT * FROM `ProgressSection`
            WHERE `patientId`='GroupMenu' AND `subject`='$menuItem' 
            AND `owner`='public'";
            echo "===\n $sql \n";
            $result=mysql_query($sql);
            if (mysql_num_rows ($result) == 0){
                echo "\n=== Template for (public) not found ===\n$sql\n";
            } else {
                $row=mysql_fetch_array($result);
                echo "<SEPARATOR>";
                echo json_encode($row);
            }
        } else {
            $row=mysql_fetch_array($result);
            // グループメニューの頻度をインクリメント
            $rowid = $row['rowid'];
            $freq = $row['freq'] + 1;
            $sql = "UPDATE `ProgressSection` 
			SET `freq`='$freq', `updateTime`='".timeStamp().
			"' WHERE `rowid` = $rowid";
            echo "===\n $sql \n";
            mysql_query($sql);
            
            echo "<SEPARATOR>";
            echo json_encode($row);
        }
    } else if (strcmp($command,"PUT_ARCHIVE") == 0){
        // $patientId のデータをアーカイブし保存
        $args = decodeObject($value);
        $owner = $args['owner'];
        $patientId = $args['patientId'];
        
        // $owner のレイアウトに存在する tag の配列を得る
        $tagArray = layoutTags($owner);

        // $patientId のカルテをアーカイブ
        $buff = archive($patientId, $tagArray);
        if (save($patientId, $buff)){
            echo "<SEPARATOR>";
            echo $buff;
        } else
            echo "$patientId cannot save";
    } else if (strcmp($command,"PUT_ALL_ARCHIVE") == 0){
        // $entryDate の全受診者データをアーカイブし保存
        $args = decodeObject($value);
        $owner = $args['owner'];
        $entryDate = $args['entryDate'];
        
        // $owner のレイアウトに存在する tag の配列を得る
        $tagArray = layoutTags($owner);
        
        // $entryDate の受診者すべてをアーカイブ
        $pidArray = patientArrayAt($entryDate);
        echo "<SEPARATOR>";
        echo "$entryDate の全カルテをバックアップしました ---<br/>";
        foreach ($pidArray as $patientId=>$kanjiName){
            $buff = archive($patientId, $tagArray);
            if (save($patientId, $buff)){
                echo "$patientId $kanjiName </br>";
            } else
                echo "$patientId $kanjiName *** cannot archived</br>";
        }
    } else if (strcmp($command,"GET_ARCHIVE") == 0){
        // tag=table.field のリストに対応するコンテンツを DB から get し JSON 形式で返す
        $args = decodeObject($value); // client 側との約束ごと
        $patientId = $args['patientId'];
        $filename = archivedFile($patientId); // $patientId に対応するアーカイブファイル
        
        echo "GET_ARCHIVE filename ($filename)\n";
        
        $handle = @fopen($filename, "r");
        if ($handle) {
            echo "<SEPARATOR>";
            while (!feof($handle)) {
                $buffer = fgets($handle, 4096);
                // ## ブラウザーの設定により好みのコードに変更可
                //$buffer = mb_convert_encoding($buffer, "SJIS", "UTF-8");
                echo "$buffer";
            }
            fclose($handle);
        }
        else
            echo "ERROR: *** $patientId のデータはみつかりません";
    } else if (strcmp($command,"FIND") == 0){
        // 条件検索: ChartFinder から使われる
        $args = decodeObject($value);
        $tag = $args['tag'];
        $patientId = $args['patientId'];
        $searchKey = $args['searchKey'];
        $from = $args['from']; // 検索開始対象年月日
        $to = $args['to']; // 検索終了対象年月日
        $unique = $args['unique']; // 同じ patientId の複数レコード回答を許可・不許可
        
        // 検索結果 を JSON 形式で返す
        $results = find($tag, $patientId, $from, $to, $unique, $searchKey);
        echo "<SEPARATOR>";
        echo json_encode($results);
    } else if (strcmp($command,"GET_HEALTHINSURANCE_WITH_KEY") == 0){
        // 保険者番号に一致する保険者名・電話番号を検索
        // args = $value："HealthInsurance.ownerNumber_|_保険者番号"
        // $value に相当するデータを返す
        $args = decodeObject($value);
        // client 側との約束ごと
        $ownerNumber = $args['HealthInsurance.ownerNumber'];
        
        // HealthInsurance の ownerNumber が value に該当するレコードを探し
        // その "保険者名, 電話番号, 種別" を返す
        $sql = "SELECT * FROM `HealthInsurance` WHERE `ownerNumber` LIKE '$ownerNumber%' ORDER BY `updateTime` DESC";
        $result=mysql_query($sql);
        $row=mysql_fetch_array($result);
        $array = array(); // $array を初期化
        if ($row){
            $array['ownerNumber'] = $row['ownerNumber'];
            $array['ownerName'] = $row['ownerName'];
            $array['ownerPhone'] = $row['ownerPhone'];
            $array['shubetsu'] = $row['shubetsu'];
        } else {
            // 一致する 保険者番号 のレコードが見つからなかった
            $array['ownerNumber'] = $value;
            $array['ownerName'] = "";
            $array['ownerPhone'] = "";
            $array['shubetsu'] = "";
            $array[''] = "HealthInsurance.ownerNumber<SEP>$value";
            $array[''] = "HealthInsurance.ownerName<SEP>";
            $array[''] = "HealthInsurance.ownerPhone<SEP>";
            $array[''] = "HealthInsurance.shubetsu<SEP>";
        }
        echo "<SEPARATOR>";
        echo json_encode($array);
    } else if (strcmp($command,"LOGIN") == 0){
        // IN: loginName passwd
        // OUT: $row(ユーザ・レコード) no-password error-message
        $args = decodeObject($value);
        $loginName = $args['loginName'];
        $passwd = $args['passwd'];
        
//        echo "logname($loginName) pwd($passwd)\n"; return; //##
        
        if (strlen($loginName) == 0){
            echo "<SEPARATOR>";
            echo "ERROR: userName が入っていません";
            return;
        } else if (strlen($passwd) == 0){
            echo "<SEPARATOR>";
            echo "ERROR: password が入っていません";
            return;
        } else if (($row = getUser($loginName)) == null){
            // <SEPARATOR> がないなら error を示す
            echo "<SEPARATOR>";
            echo "ERROR: $loginName は登録されたユーザではありません";
            return;
        }
        
        if (strlen($row['identifier']) == 0){
            // <SEPARATOR> の後が何もないなら passwd が設定されていないので
            // passwd を入力させる
            echo "<SEPARATOR>";
        } else if (strcmp($row['identifier'], md5($passwd)) == 0){
            // 暗号化してから DB 値と比較する
            // <SEPARATOR> の後に文字があれば成功を示す
            $array = getHospitalNames(); // $array[hospitalName] = hospitalId
            $row['hospitalTable'] = $array;
            echo "<SEPARATOR>";
            echo json_encode($row);
        } else {
            echo "<SEPARATOR>";
            echo "ERROR: password が違っています";
        }
    } else if (strcmp($command,"PUT_LAYOUT") == 0){
        // LAYOUT 属性を FieldTable へ保存
        $recs = decodeObject($value);
        $direction = "CELL";
        $freq = 0; // 自動 numbering する
       
		foreach($recs as $num=>$rec){
            $owner = $rec['owner'];
            $tag = $rec['tag'];
            $hitAndRun = $rec['hitAndRun'];
            $disabled = $rec['disabled'];
            $label = $rec['label'];
            $id = $rec['id']; // 数値だと、第７世代 NOA の CELL_ID とカブる
            
            $sql = "SELECT * FROM `FieldTable` WHERE `owner`='$owner' AND `direction`='CELL' AND `tag`='$tag'";
            //echo "----- $sql \n"; //##
            
            $result=mysql_query($sql);
            if ($row=mysql_fetch_array($result)){
                $rowid = $row['rowid'];
                $sql = "UPDATE `FieldTable` SET `hitAndRun`='$hitAndRun',`disabled`='$disabled',`label`='$label',`numbering`='$freq',`id`='$id' WHERE `rowid`='$rowid'";
            } else {
                $sql = "INSERT INTO `FieldTable` (`owner`,`tag`,`hitAndRun`,`direction`,`disabled`,`id`,`label`,`numbering`) VALUES ('$owner','$tag','$hitAndRun','CELL','$disabled','$id','$label','$freq')";
            }
            echo "----- $sql \n"; //##
            $result=mysql_query($sql);
            $freq += 1;
		}
 
        echo "<SEPARATOR>";
        echo "ラベル順序を保存しました";
    } else if (strcmp($command,"REMOVE_TAG_LABEL") == 0){
        $args = decodeObject($value);
        $owner = $args['owner'];
        $direction = "CELL";
        
        $sql = "DELETE FROM `FieldTable` WHERE `owner`='$owner' AND `direction`='$direction'";
        echo "----- $sql \n"; //##
        $result=mysql_query($sql);
        
        echo "<SEPARATOR>";
        echo "レイアウトを工場出荷状態に戻しました";
    } else if (strcmp($command,"REMOVE_TOOL_MENU") == 0){
        //  ツール・メニューの項目を削除
        $args = decodeObject($value);
        $owner = $args['owner'];
        $label = $args['label'];
        $tag = "TOOL_MENU";
        
        if ($label){
            $sql = "DELETE FROM `FieldTable` WHERE `tag`='$tag' AND `owner`='$owner' AND `label`='$label'";
        } else {
            $sql = "DELETE FROM `FieldTable` WHERE `tag`='$tag' AND `owner`='$owner'";
        }
        echo "----- $sql \n"; //##
        $result=mysql_query($sql);
        
        echo "<SEPARATOR>";
        if ($label)
            echo "$label を削除しました";
        else
            echo "メニュー構造を工場出荷状態に戻しました";
    } else if (strcmp($command,"GET_TOOL_MENU") == 0){
        $args = decodeObject($value);
        $owner = $args['owner'];
        $tag = "TOOL_MENU";
        
        $sql = "SELECT * FROM `FieldTable` WHERE `tag`='$tag' AND `owner`='$owner' ORDER BY `numbering`";
        echo "----- $sql \n"; //##
        $result=mysql_query($sql);
        
        $array = array();
        while ($row=mysql_fetch_array($result)){
            $rec = array();
            $rec['window'] = $row['buttonType'];
            $rec['menuType'] = $row['menuType'];
            $rec['fix'] = $row['menuAction'];
            $rec['subTitle'] = $row['fieldType'];
            $rec['disabled'] = $row['disabled'];
            $rec['editor'] = $row['editor'];
            $rec['id'] = $row['id'];
            $rec['url'] = $row['script'];
            $rec['label'] = $row['label'];
            $rec['icon'] = $row['fontFamily'];
            $array[] = $rec;
        }
        
        echo "<SEPARATOR>";
        echo json_encode($array);
    } else if (strcmp($command,"GET_ARCHIVE_FILE") == 0){
        // JSON 形式で保存された配列データを読み出す
        // ##### PUT_ARCHIVE_FILE は postServer.php で実施 #####
        $args = decodeObject($value);
        $owner = $args['owner']; // 先頭に owner が埋め込まれている
        $folder = $args['folder'];
        $filename = $args['filename'];
        $dir = archiveDirForToolMenu($owner, $folder);
        $path = "$dir/$filename";
        
		echo "<SEPARATOR>";
        $json = file_get_contents($path);
        echo $json;
    } else if (strcmp($command,"GET_ARCHIVE_FILES") == 0){
        // TOOL MENU や LAYOUT のアーカイブを取得
        $args = decodeObject($value);
        $owner = $args['owner']; // 先頭に owner が埋め込まれている
        $folder = $args['folder'];
        $dir = archiveDirForToolMenu($owner, $folder);
        
        $results = getDir($dir);
        //rsort($results); // 逆順にソート
		echo "<SEPARATOR>";
		echo json_encode($results);
    } else if (strcmp($command,"REMOVE_ARCHIVE_FILE") == 0){
        $args = decodeObject($value);
        $owner = $args['owner']; 
        $folder = $args['folder'];
        $filename = $args['filename'];
        $dir = archiveDirForToolMenu($owner, $folder);
        $oldPath = "$dir/$filename";
        $newPath = "$dir/_$filename";
        
        // ファイル名の頭に削除マーク "_" を付ける
        rename($oldPath, $newPath);
        
		echo "<SEPARATOR>";
		echo "$filename を削除しました";
    } else if (strcmp($command,"REMOVE_SCRAPS") == 0){
        // folder 下の '_' で始まるファイル名のファイルを全部削除
        $args = decodeObject($value);
        $owner = $args['owner'];
        $folder = $args['folder'];
        $dir = archiveDirForToolMenu($owner, $folder);
        echo "dir($dir)"; //##
        
        $results = getDir($dir);
        $path = $results['path']; // ここでは使わない
        $files = $results['files'];

        foreach($files as $num=>$filename){
            $pos = strpos($filename, "_");
            if (($pos !== FALSE) && ($pos == 0)){
                // ファイル名の行頭が '_' なら削除
                $fullPath = "$path/$filename";
                unlink($fullPath);
            }
        }
        
		echo "<SEPARATOR>";
		echo "削除済みファイルをすべて完全に削除しました";
    } else if (strcmp($command,"SET_PASSWD") == 0){
        // パスワードを設定・保存
        $args = decodeObject($value);
        $loginName = $args['loginName'];
        $passwd = $args['passwd'];
        
        $sql = "SELECT * FROM `UserTable` WHERE `loginName`='$loginName'";
        echo "$sql ===== \n"; //##
        $result=mysql_query($sql);
        if (mysql_num_rows ($result) > 0){
            $pwd = md5($passwd); // passwd を暗号化する
            $updateTime = timestamp();
            $sql = "UPDATE `UserTable` 
			SET `identifier`='$pwd', `updateTime`='$updateTime'
			WHERE `loginName`='$loginName'";
            echo "$sql -----\n";
            $result=mysql_query($sql);
            echo "<SEPARATOR>";
            echo "パスワードが設定されました\n";
        } else {
            echo "<SEPARATOR>"; 
            echo "ERROR *** パスワードが設定できませんでした\n";
        }
    } else if (strcmp($command,"PUT_POST_IT") == 0){
        // 付箋を登録/削除
        // $val が "" の場合、レコードは削除される
        $args = decodeObject($value);
        $patientId = $args['patientId'];
        $entryDate = $args['entryDate'];
        $field = "postIt";
        $type = $args['type'];
        $val = decodeSTRING($args['val']);
        $owner = $args['owner'];
        
        // timeLimit 以内の ProgressSection レコードの有無をチェック
        if (strlen($val) == 0){
            // val が空の場合は entryDate のレコードを実際に削除
            // PostIt パネルで「削除」にチェックを入れただけなら type が expired になるだけ
            $sql = "DELETE FROM `UniversalSection` WHERE `patientId`='$patientId' AND `entryDate`='$entryDate' AND `field`='$field' AND `owner`='$owner'";
            mysql_query($sql); 
            echo "===\n $sql \n"; //##
            
            echo "<SEPARATOR>";
            // 付箋を削除した場合は空データ
        } else {
            $sql = "SELECT * FROM `UniversalSection` WHERE `patientId`='$patientId' AND `field`='$field' AND `entryDate`='$entryDate'";
            echo "===\n $sql \n"; //##
            $result=mysql_query($sql);
            
            if (mysql_num_rows ($result) > 0){
                // dataString を更新
                $row=mysql_fetch_array($result);
                $rowid = $row['rowid'];
                
                $sql = "UPDATE `UniversalSection`
                SET `dataString`='$val'
                ,`type`='$type'
                ,`owner`='$owner'
                WHERE `rowid`='$rowid'";
                echo "===\n $sql \n";
                mysql_query($sql);
            } else {
                $sql = "INSERT INTO `UniversalSection` 
                (`patientId`,`field`,`dataString`,`type`
                 ,`entryDate`,`owner`)
                VALUES ('$patientId','$field','$val','$type'
                        ,'$entryDate','$owner')";
                mysql_query($sql);
                echo "===\n $sql \n"; //##
            }
            
            $array = getPostIt($patientId, $entryDate, $owner);
            echo "<SEPARATOR>";
            echo json_encode($array);
        }
    } else if (strcmp($command,"PUT_NEW_PATIENT") == 0){
        $args = decodeObject($value);
        $patientId = $args['patientId'];
        $anotherId = $args['anotherId'];
        $receiptId = $args['receiptId'];
        $entryDate = $args['entryDate'];
        $owner = $args['owner'];
        $birthDate = $args['birthDate'];
        $deathDate = "";
        $sex = $args['sex'];
        $kanjiName = $args['kanjiName'];
        $kanaName = $args['kanaName'];
        $romajiName = $args['romajiName'];
        
        $row = rowOfPatientId($patientId);
        if ($row){
            echo "<SEPARATOR>";
            echo "ERROR *** $patientId はすでに登録されています";
        } else if ($patientId <> "") {
            $sql = "INSERT INTO `PatientTable` (`patientId`,`anotherId`,`receiptId`
            ,`sex`,`birthDate` ,`deathDate` ,`entryDate`)
            VALUES ('$patientId','$anotherId','$receiptId','$sex'
                    ,'$birthDate','$deathDate','$entryDate');";
            echo "SQL:\n $sql ----\n"; //##
            mysql_query($sql);
            $sql = "INSERT INTO `NameSection` (`patientId`
            ,`patientKanjiName`,`patientKanaName`,`patientRomajiName`
            ,`entryDate`,`updateTime`,`owner`) 
            VALUES ('$patientId'
                    ,'$kanjiName', '$kanaName', '$romajiName',
                    '$entryDate','".timeStamp()."','$owner');";
            echo "SQL:\n $sql ----\n"; //##
            mysql_query($sql);
            
            echo "<SEPARATOR>";
            echo "$patientId $kanjiName を登録しました";
        }
    } else if (strcmp($command,"GET_INSURANCE") == 0){
        // patientId, currentDate に相当する保険証画像イメージがあればその URLリスト を返す
        $args = decodeObject($value);
        $patientId = $args['patientId'];
        
        // ##### $dir は HTTP ではなく FILE-SYSTEM の PATH を示す #####
        $dir = "../NOA_ARCHIVE/$patientId/Insurance/";
        $results = getDir($dir);
        echo "<SEPARATOR>";
        echo json_encode($results);
    } else if (strcmp($command,"GET_CONDITIONAL_PATIENT") == 0){
        // lvdSearch/NOAManager から呼ばれる
        $args = decodeObject($value);
        $from = $args['fromDate'];
        $to = $args['toDate'];
        
        $sql = "SELECT * FROM `PatientTable` WHERE `lastVisitDate` > '$from' AND `lastVisitDate` < '$to' ORDER BY `patientId`";
        $result=mysql_query($sql);
        echo "$sql ========== <br>\n";
        
        $records = array();
        $count = 0;
        while ($row=mysql_fetch_array($result)){
            $pid = $row['patientId'];
            $lvd = $row['lastVisitDate'];
            
            // $pid のカルテについて指定期間以後に受診しているものはスキップ
            $sql2 = "SELECT * FROM `ProgressSection` WHERE `patientId`=$pid AND `entryDate` > '$to'";
            $result2=mysql_query($sql2);
            if ($row2=mysql_fetch_array($result2)){
                echo " $pid $lvd -> entryDate: ".$row2['entryDate']." <br>\n";
                continue;
            }
            
            echo "$pid $lvd <br>\n";
            
            $rec = array();
            $namrow = nameSectionWithPatientId($pid);
            $rec['name'] = $namrow['patientKanjiName'];
            $rec['lvd'] = $row['lastVisitDate'];
            $records[$pid] = $rec;
            $count++;
        }
        
        echo "<SEPARATOR>";
        echo json_encode($records);
    } else if (strcmp($command,"REMOVE_RECORDS_FOR_TAG") == 0){
        // UniversalSection から owner, tag の全レコードを削除
        $args = decodeObject($value);
        $owner = $args['owner'];
        $tag = $args['tag'];
        $array = explode(".", $tag);
        $field = $array[1];
        
        // LAYOUT テーブルから owner, tag のレコードを削除
        $sql = "DELETE FROM `FieldTable` WHERE `tag`='$tag' AND `owner`='$owner' AND `direction`='CELL'";
        echo "----- $sql \n"; //##
        $result=mysql_query($sql);
        
        // UniversalSection から owner, field のレコードを削除
        $sql = "DELETE FROM `UniversalSection` WHERE `field`='$field' AND `owner`='$owner'";
        echo "----- $sql \n"; //##
        $result=mysql_query($sql);
        
        echo "<SEPARATOR>";
        echo "UniversalSection から $owner, $field のデータ全てを削除しました";
    } else if (strcmp($command,"GET_VALUE_API") == 0){
        // 現在開かれているカルテから tag に該当するデータを返す
        $args = decodeObject($value);
        $owner = $args['owner'];
        $patientId = $args['patientId'];
        $entryDate = $args['currentDate'];
        $hospitalId = $args['hospitalId'];
        $st = $args['tags']; // "table.field,table.field,,," 型式
        $tags = explode(",", $st);
        
        $records = array();
        foreach ($tags as &$tag) {
            $array = explode(".", $tag);
            $table = $array[0];
            $field = (count($array) > 1) ? $array[1] : "";
            
            if (strcmp($table, "HospitalTable") == 0){
                $sql = "SELECT * FROM `HospitalTable` WHERE `hospitalId`='$hospitalId' AND `key`='$field'";
                echo "$sql ========\n"; //###
                $result=mysql_query($sql);
                
                $row=mysql_fetch_array($result);
                $rec = array();
                $rec['entryDate'] = $row['entryDate'];
                $rec['owner'] = $row['owner'];
                $rec['entryDate'] = $row['entryDate'];
                $rec['value'] = $row['value'];
            } else if (strcmp($table, "ProgressSection") == 0){
                $sql = "SELECT * FROM `ProgressSection` WHERE `patientId`='$patientId' AND `entryDate`<='$entryDate' AND `owner`='$owner' AND (`freq` IS NULL OR `freq`<1) ORDER BY `entryDate` DESC";
                echo "$sql ========\n"; //###
                $result=mysql_query($sql);
                
                while ($row=mysql_fetch_array($result)){
                    $rec = array();
                    $rec['entryDate'] = $row['entryDate'];
                    $rec['owner'] = $row['owner'];
                    $rec['entryDate'] = $row['entryDate'];
                    $rec['value'] = $row[$field];
                    if (strlen($rec['value']) > 0) break;
                }
            } else {
                $sql = "SELECT * FROM `$table` WHERE `patientId`='$patientId' AND `entryDate`<='$entryDate' AND `owner`='$owner' ORDER BY `entryDate` DESC";
                echo "$sql ========\n"; //###
                $result=mysql_query($sql);
                
                if (mysql_num_rows ($result) == 0){
                    // オーナーのものがなければ他オーナーのものを探す
                    $sql = "SELECT * FROM `$table` WHERE `patientId`='$patientId' AND `entryDate`<='$entryDate' ORDER BY `entryDate` DESC";
                    echo "$sql ========\n"; //###
                    $result=mysql_query($sql);
                }
                $row=mysql_fetch_array($result);
                $rec = array();
                $rec['entryDate'] = $row['entryDate'];
                $rec['owner'] = $row['owner'];
                $rec['entryDate'] = $row['entryDate'];
                $rec['value'] = $row[$field];
            }
            
            echo $rec['entryDate']."(".$rec['owner'].")".$rec[$field]."\n"; //##
            $records[$tag] = $rec;
        }

        echo "<SEPARATOR>";
        echo json_encode($records);
    } else if (strcmp($command,"PUT_VALUE_API") == 0){
        // 現在開かれているカルテから tag に該当するデータを返す
        $args = decodeObject($value);
        $owner = $args['owner'];
        $patientId = $args['patientId'];
        $entryDate = $args['currentDate'];
        $value = $args['value'];
        $tag = $args['tag'];
        $array = explode(".", $tag);
        $table = $array[0];
        $field = (count($array) > 1) ? $array[1] : "";
        
        if (strcmp($table, "ProgressSection") == 0){
            $sql = "SELECT * FROM `ProgressSection` WHERE `patientId`='$patientId' AND `entryDate`='$entryDate' AND `owner`='$owner' AND (`freq` IS NULL OR `freq`<1) ORDER BY `entryDate` DESC";
            echo "$sql ========\n"; //###
            $result=mysql_query($sql);
            
            $row=mysql_fetch_array($result);
            if ($row){
                $rowid = $row['rowid'];
                $sql = "UPDATE `ProgressSection` SET `$field`='$value' WHERE `rowid`='$rowid'";
                echo "===\n $sql \n";
                mysql_query($sql);
            } else {
                /*
                $updateTime = date("Y-m-d H:i:s",time());
                $sql = "INSERT INTO `ProgressSection` ( `patientId`,`$field`,`entryDate`,`updateTime`,`owner`) VALUES ( '$patientId',’$value',’$entryDate','$updateTime','$owner')";
                 */
            }
        }
        echo "<SEPARATOR>";
    } else if (strcmp($command,"MERGE_ARCHIVE") == 0){
        // アーカイブ・データを DB へマージ
        $args = decodeObject($value);
        $patientId = $args['patientId'];
        $owner = $args['owner'];
        $tag = $args['tag'];
        $entryDate = $args['entryDate'];
        $updateTime = $args['updateTime'];
        $val = $args['val'];
        
        echo "<SEPARATOR>";
        putRecord($patientId, $tag, $entryDate, $updateTime, $val, $owner);
    } else if (strcmp($command,"GET_FRONT_ACCEPTANCE") == 0){
        // NOA の polling で呼ばれる
        $args = decodeObject($value);
        $dateTime = $args['dateTime']; // 以前チェックされた日付
        
        // entryDate が $dateTime と同じデータを検索
		$sql = "SELECT * FROM `FrontTable` WHERE `entryDate`>'$dateTime 00:00:00' AND  `entryDate`<='$dateTime 23:59:59' ORDER BY `entryDate` DESC";
        echo "GET_FRONT_ACCEPTANCE:\n $sql \n"; //##
        
        $result=mysql_query($sql);
        $array = array();
        while ($row=mysql_fetch_array($result)){
            $rec = array();
			$rec['entryDate'] = $row['entryDate'];
			$rec['patientId'] = $row['patientId'];
			$rec['anotherId'] = $row['anotherId'];
			$rec['kanjiName'] = $row['kanjiName'];
			$rec['updateTime'] = $row['updateTime'];
			$rec['endTime'] = $row['endTime'];
            $array[] = $rec;
        }
        $records['records'] = $array;

        // メッセージの入ったレコードをサーチ
        $sql = "SELECT * FROM `FrontTable` WHERE `patientId`='MESSAGE'";
        $result=mysql_query($sql);
        
        echo "GET_MESSAGE:\n"; //##

        $array = array();
        while ($row=mysql_fetch_array($result)){
            $rec = array();
            $rec['sender'] = $row['owner'];
            $rec['receiver'] = $row['mishuu'];
            $rec['message'] = $row['plan'];
            $rec['docId'] = $row['rowid'];
            $rec['updateTime'] = $row['updateTime'];
            $array[] = $rec;
            
            echo $row['plan']."\n"; //##
        }
        $records['message'] = $array;

        // entryDate が $dateTime と同じ年月日のレコードの配列を返す
        echo "<SEPARATOR>";
        echo json_encode($records);
    } else if (strcmp($command,"GET_ACCEPTANCE_LIST") == 0){
        // 本日の受診者と、それ以後の予約者のリストを返す
        $args = decodeObject($value);
        $dateTime = $args['dateTime'];
        $date = substr($dateTime, 0, 10);
        
        // entryDate が $dateTime と同じデータを検索
		$sql = "SELECT * FROM `FrontTable` WHERE `entryDate`>'$date 00:00:00' ORDER BY `entryDate`";
        echo "GET_ACCEPTANCE_LIST:\n $sql \n"; //##
        
        $result=mysql_query($sql);
        $array = array();
        while ($row=mysql_fetch_array($result)){
            $rec = array();
			$rec['entryDate'] = $row['entryDate'];
			$rec['patientId'] = $row['patientId'];
			$rec['anotherId'] = $row['anotherId'];
			$rec['kanjiName'] = $row['kanjiName'];
			$rec['insFee'] = $row['insFee'];
			$rec['ownFee'] = $row['ownFee'];
			$rec['endTime'] = $row['endTime'];
			$rec['reserved'] = ($row['entryDate'] > $row['updateTime']) ? "1" : "0";
            $pid = trim($row['patientId']); // patientId に空白がついていることあり
            $obj = insScanDate($pid);
            $rec['scanDataPath'] = $obj["path"];
            $rec['scanDateTime'] = $obj["filename"];
            $recs[$dateAndId] = $rec;
            $array[] = $rec;
        }
        
        echo "<SEPARATOR>";
        echo json_encode($array);
    } else if (strcmp($command,"GET_MESSAGE_FROM_FRONT") == 0){
        // FrontTable から timeStamp やメッセージを取り出す
        $args = decodeObject($value);
        $from = $args['from'];
        $fto = $args['to'];
        $timeStamp = $args['timeStamp'];
        $apps = $args['application']; // このコマンドを送った元のアプリケーション
        $answer = getTimeStamp($from, $to, $timeStamp, $apps);
        echo "<SEPARATOR>";
        echo $answer;
    } else if (strcmp($command,"PUT_MESSAGE") == 0){
        // receiver へメッセージを伝える
        $args = decodeObject($value);
        $sender = $args['sender'];
        $receiver = $args['receiver'];
        $message = $args['message'];
        $docId = $args['docId'];
        $updateTime = date("Y-m-d H:i:s",time());
        echo "$value ------------ \n"; //###
        
        if (strlen($docId) > 0){
            // documentId が指定されているので、そのレコードを更新
            $sql = "SELECT * FROM `FrontTable` WHERE `rowid`='$docId'";
            $result=mysql_query($sql);
            
            $row=mysql_fetch_array($result);
            if ($row && (strcmp($row['patientId'],'MESSAGE') == 0)){ // MESSAGE が存在した
                $sql = "UPDATE `FrontTable` SET `plan`='$message',`mishuu`='$receiver',`owner`='$sender',`updateTime`='$updateTime' WHERE `rowid`='$docId'";
            }
        } else {
            // documentId が指定されていないので新規レコードを追加
            $sql = "INSERT INTO `FrontTable` (`patientId`,`owner`,`mishuu`,`plan`,`updateTime`) VALUES ('MESSAGE',  '$sender','$receiver','$message','$updateTime')";
        }
        echo "$sql ------------ \n"; //###
        mysql_query($sql);
        
        // timeStamp を記憶する
        putTimeStamp();
        
        echo "<SEPARATOR>";
        echo "$updateTime \nメッセージを $receiver へ送りました";
    } else if (strcmp($command,"REMOVE_MESSAGE") == 0){
        $args = decodeObject($value);
        $rowid = $args['docId'];

        $sql = "DELETE FROM `FrontTable` WHERE `rowid`='$rowid'";
        echo "$sql ========\n"; //###
        mysql_query($sql);
        
        // 変更結果を返す
        echo "<SEPARATOR>";
        echo "メッセージを削除しました";
    } else if (strcmp($command,"_GET_DAILY") == 0){ //### TEST ########
        // FRONT 日計表レコードを返す
        // Messenger 専用だが、いずれ FRONT もこちらを使う
        $args = decodeObject($value);
        $owner = $args['owner'];
        $entryDate = $args['entryDate'];
        $timeStamp = $args['timeStamp'];
        $apps = $args['application']; // このコマンドを送った元のアプリケーション
        $min = substr($entryDate, 0, 10)." 00:00:00";
        $max = substr($entryDate, 0, 10)." 23:59:59";
        
        // "タイムスタンプ^送信元^メッセージ" を渡す
        // 以前と変わっていなければ "same"
        $results = array();
        $results['timeStamp'] = getTimeStamp($apps, $timeStamp);
        $results['sortOrder'] = "1"; // getSortOrder($owner); // #########
        
        if (strlen($args['timeZone'])){
            $array = explode("-", $args['timeZone']);
            $hh = substr($array[0], 0, 2);
            $mm = substr($array[0], 2, 2);
            $fromTime = "$hh:$mm:00";
            $hh = substr($array[1], 0, 2);
            $mm = substr($array[1], 2, 2);
            $toTime = "$hh:$mm:00";
        } else {
            $fromTime = "";
            $toTime = "";
        }
        
        // 日計表のデータを渡す
        if ($results['sortOrder'] == "1"){
            $sql = "SELECT * FROM `FrontTable`
            WHERE `entryDate`<='$max' AND `entryDate`>='$min'
            ORDER BY `entryDate` DESC";
        } else {
            $sql = "SELECT * FROM `FrontTable`
            WHERE `entryDate`<='$max' AND `entryDate`>='$min'
            ORDER BY `entryDate`";
        }
        echo "GET_DAILY:\n $sql \n"; //##
        $result=mysql_query($sql);
        
        $recs = array();
        while ($row=mysql_fetch_array($result)){
            $rec = array();
            
            // ### STAMP があれば取得して $results に入れる ###
            $unpaidDate = "";
            $unpaid = 0;
            // $row['mishuu'] は "2009-01-30 19:16:00,3650" のような形式
            $mishuu = $row['mishuu'];
            if ($mishuu && (strlen($mishuu) > 0)){
                $array = explode(",", $mishuu);
                if (count($array) > 1){
                    $unpaidDate = $array[0];
                    $unpaid = $array[1] * 1;
                }
            }

            $dateAndId = $row['entryDate']."^".$row['patientId'];
            $rec['entryDate'] = $row['entryDate'];
            $rec['userCode'] = $row['userCode'];
            $rec['groupCode'] = $row['groupCode'];
            $rec['inOut'] = $row['inOut'];
            $rec['newPatient'] = $row['newPatient'];
            $rec['point'] = $row['point'];
            $rec['insFee'] = $row['insFee'];
            $rec['ownFee'] = $row['ownFee'];
            $rec['mishuu'] = $unpaid;
            $rec['receive'] = $row['receive'];
            $rec['patientId'] = $row['patientId'];
            $rec['anotherId'] = $row['anotherId'];
            $rec['kanjiName'] = $row['kanjiName'];
            $rec['plan'] = $row['plan'];
            $rec['beginTime'] = $row['beginTime'];
            $rec['endTime'] = $row['endTime'];
            $rec['checkOutTime'] = $row['checkOutTime'];
            $rec['updateTime'] = $row['updateTime'];
            $rec['owner'] = $row['owner'];
            $rec['unpaidDate'] = $unpaidDate; // 追加
            /*  ### TEST ではとりあえずスキップ #######
            // 保険証を最後にスキャンした日付
            $obj = insScanDate($row['patientId']);
            $rec['scanDataPath'] = $obj["path"];
            $rec['scanDateTime'] = $obj["filename"];
             */
            $recs[$dateAndId] = $rec;
        }
        
        if (count($recs) > 0)
            $results['records'] = $recs;
        
        echo "<SEPARATOR>";
        echo json_encode($results);
    } else if (strcmp($command,"GET_RECORDS_FOR_KEYS") == 0){
        // $keys に含まれるキー群を含むすべてのレコードを返す
        $args = decodeObject($value);
        // client 側との約束ごと
        $pid = $args['patientId'];
        $owner = $args['owner'];
        $keys = $args['keys']; // separator で区切られたラベル名群の文字列
        echo "pid($pid) owner($owner) keys($keys)\n"; //return; //###
        
        $records = recordsForKeys($pid, $owner, $keys);
        echo "<SEPARATOR>";
        echo json_encode($records);
    } else if (strcmp($command,"PUT_REMINDER") == 0){
        $args = decodeObject($value);
        $patientId = $args['patientId'];
        $owner = $args['owner'];
        $type = $args['type'];
        $val = $args['dataString'];
        $now = timeStamp();
        
        if (strlen($val) == 0){
            $sql = "DELETE FROM `UniversalSection`
            WHERE `patientId`='$patientId' AND `field`='_REMINDER_'
            AND `type`='$type' AND `owner`='$owner'";
            echo "===\n $sql \n";
            mysql_query($sql);
            echo "<SEPARATOR>";
            return;
        }
        
        $sql = "SELECT * FROM `UniversalSection`
        WHERE `patientId`='$patientId' AND `field`='_REMINDER_'
        AND `type`='$type' AND `owner`='$owner'";
        echo "===\n $sql \n"; //##
        $result=mysql_query($sql);
        
        if (mysql_num_rows ($result) > 0){
            // dataString を更新
            $row=mysql_fetch_array($result);
            $rowid = $row['rowid'];
            
            $sql = "UPDATE `UniversalSection`
            SET `dataString`='$val'
            ,`updateTime`='$now'
            WHERE `rowid`='$rowid'";
        } else {
            $sql = "INSERT INTO `UniversalSection`
            (`patientId`,`field`,`dataString`,`type`
             ,`entryDate`,`updateTime`,`owner`)
            VALUES ('$patientId','_REMINDER_','$val','$type'
                    ,'$now','$now','$owner')";
        }
        echo "===\n $sql \n";
        mysql_query($sql);
        echo "<SEPARATOR>";
    } else if (strcmp($command,"GET_REMINDER") == 0){
        $args = decodeObject($value);
        $patientId = $args['patientId'];
        $owner = $args['owner'];
        $type = $args['type'];
        
        if (strlen($patientId) == 0){
            $sql = "SELECT * FROM `UniversalSection` WHERE `field`='_REMINDER_' AND `type`='$type' AND `owner`='$owner' ORDER BY `updateTime` DESC";
        } else {
            $sql = "SELECT * FROM `UniversalSection` WHERE `field`='_REMINDER_' AND `patientId`='$patientId' AND `type`='$type' AND `owner`='$owner' ORDER BY `updateTime` DESC";
        }
        echo "$sql ------------ \n"; //###
        
        mysql_query($sql);
        $result=mysql_query($sql);
        $records = array();
        while ($row=mysql_fetch_array($result)){
            $rec = array(); 
            $rec['patientId'] = $row['patientId'];
            $rec['updateTime'] = $row['updateTime'];
            $rec['dataString'] = $row['dataString'];
            $nameRow = nameSectionWithPatientId($row['patientId']);
            $rec['patientKanjiName'] = $nameRow['patientKanjiName'];
            $records[] = $rec;
        }
        echo "<SEPARATOR>";
        echo json_encode($records);
    } else if (strcmp($command,"GET_TABLE_RECORDS") == 0){
        // patientId
        // 各テーブルごとの patientId のレコード数を返す
        $args = decodeObject($value);
        $patientId = $args['patientId'];
        
        echo "<SEPARATOR>";
        $results = array();
        $results["patientId"] = $patientId;
        $sum = 0;
        
        $sql = "SELECT * FROM `NameSection` WHERE `patientId`='$patientId'";
        $result=mysql_query($sql);
        $count = mysql_num_rows($result); $sum += $count;
        $results["NameSection"] = $count;
        $sql = "SELECT * FROM `AddressSection` WHERE `patientId`='$patientId'";
        $result=mysql_query($sql);
        $count = mysql_num_rows($result); $sum += $count;
        $results["AddressSection"] = $count;
        $sql = "SELECT * FROM `BasicSection` WHERE `patientId`='$patientId'";
        $result=mysql_query($sql);
        $count = mysql_num_rows($result); $sum += $count;
        $results["BasicSection"] = $count;
        $sql = "SELECT * FROM `MalitalSection` WHERE `patientId`='$patientId'";
        $result=mysql_query($sql);
        $count = mysql_num_rows($result); $sum += $count;
        $results["MalitalSection"] = $count;
        $sql = "SELECT * FROM `HealthInsurance` WHERE `patientId`='$patientId'";
        $result=mysql_query($sql);
        $count = mysql_num_rows($result); $sum += $count;
        $results["HealthInsurance"] = $count;
        $sql = "SELECT * FROM `PublicInsurance` WHERE `patientId`='$patientId'";
        $result=mysql_query($sql);
        $count = mysql_num_rows($result); $sum += $count;
        $results["PublicInsurance"] = $count;
        $sql = "SELECT * FROM `ProgressSection` WHERE `patientId`='$patientId'";
        $result=mysql_query($sql);
        $count = mysql_num_rows($result); $sum += $count;
        $results["ProgressSection"] = $count;
        $sql = "SELECT * FROM `UniversalSection` WHERE `patientId`='$patientId'";
        $result=mysql_query($sql);
        $count = mysql_num_rows($result); $sum += $count;
        $results["UniversalSection"] = $count;
        $sql = "SELECT * FROM `PatientTable` WHERE `patientId`='$patientId'";
        $result=mysql_query($sql);
        $count = mysql_num_rows($result); $sum += $count;
        $results["PatientTable"] = $count;
        $results["sum"] = $sum;
        
        echo json_encode($results);
    } else if (strcmp($command,"REMOVE_TABLE_RECORDS") == 0){
        // patientId, table のレコードをすべて削除
        $args = decodeObject($value);
        // client 側との約束ごと
        $table = $args['table'];
        $patientId = $args['patientId'];
        
        if (strcmp($table, "ALL") == 0){
            $sql = "DELETE FROM `NameSection` WHERE `patientId`='$patientId'";
            echo "$sql ----\n"; //##
            mysql_query($sql);
            $sql = "DELETE FROM `AddressSection` WHERE `patientId`='$patientId'";
            echo "$sql ----\n"; //##
            mysql_query($sql);
            $sql = "DELETE FROM `BasicSection` WHERE `patientId`='$patientId'";
            echo "$sql ----\n"; //##
            mysql_query($sql);
            $sql = "DELETE FROM `MalitalSection` WHERE `patientId`='$patientId'";
            echo "$sql ----\n"; //##
            mysql_query($sql);
            $sql = "DELETE FROM `HealthInsurance` WHERE `patientId`='$patientId'";
            echo "$sql ----\n"; //##
            mysql_query($sql);
            $sql = "DELETE FROM `PublicInsurance` WHERE `patientId`='$patientId'";
            echo "$sql ----\n"; //##
            mysql_query($sql);
            $sql = "DELETE FROM `ProgressSection` WHERE `patientId`='$patientId'";
            echo "$sql ----\n"; //##
            mysql_query($sql);
            $sql = "DELETE FROM `UniversalSection` WHERE `patientId`='$patientId'";
            echo "$sql ----\n"; //##
            mysql_query($sql);
            $sql = "DELETE FROM `PatientTable` WHERE `patientId`='$patientId'";
            echo "$sql ----\n"; //##
            mysql_query($sql);
        } else {
            $sql = "DELETE FROM `$table` WHERE `patientId`='$patientId'";
            echo "$sql ----\n"; //##
            mysql_query($sql);
            $sql = "SELECT * FROM `$table` WHERE `patientId`='$patientId'";
            echo "$sql ----\n"; //##
            $result=mysql_query($sql);
        }
        
        echo "<SEPARATOR>";
        echo $patientId;
    } else if (strcmp($command,"GET_CONDITIONAL_INS_FILES") == 0){
        // fileCleaner/NOAManager から呼ばれる
        $args = decodeObject($value);
        $from = $args['fromDate'];
        $to = $args['toDate'];
        
        $sql = "SELECT * FROM `PatientTable` ORDER BY `patientId`";
        $result=mysql_query($sql);
        echo "$sql ========== <br>\n";
        
        $records = array();
        while ($row=mysql_fetch_array($result)){
            $patientId = $row['patientId'];
            $dir = "../NOA_ARCHIVE/$patientId/Insurance";
            $files = scandir($dir);
            echo "$patientId <br>\n";

            $array = array();
            for ($i=$num=0, $count=count($files); $i < $count; $i++){
                $filename = $files[$i];
                if ($filename == ".") continue;
                if ($filename == "..") continue;
                // 行頭に "_" のついた削除済みファイルは無視
                //if (substr($filename, 0, 1) == "_") continue;
                if (strlen($filename) == 0) continue;
                echo "-- $filename <br>\n";

                if (! isInScopeOf($from, $filename, $to)) continue;
                
                $array[] = $filename; // filename="03234202_20120113165123.JPG" 形式
                $num++;
            }
            if ($num == 0) continue; // 保険証画像がなければスキップ
            
            $rec = array();
            $rec['pid'] = $patientId;
            $namrow = nameSectionWithPatientId($patientId);
            $rec['name'] = $namrow['patientKanjiName'];
            $rec['files'] = $array;
            
            $records[$patientId] = $rec;
        }
        
        echo "-----  <br>\n"; 
        
        echo "<SEPARATOR>";
        echo json_encode($records);
    } else if (strcmp($command,"GET_INS_IMAGE") == 0){
        // fileCleaner/NOAManager から呼ばれる
        $args = decodeObject($value);
        $filename = $args['filename'];
        $array = explode("_", $filename);
        $patientId = (count($array) < 3) ? $array[0] : $array[1];
        $path = "../NOA_ARCHIVE/$patientId/Insurance/$filename";
        echo "<SEPARATOR>";
        echo $path;
    } else if (strcmp($command,"REMOVE_INS_IMAGE") == 0){
        // fileCleaner/NOAManager から呼ばれる
        $dir = "../NOA_GARBAGE";
        if (! file_exists($dir)){
            echo "($dir) is not exist, so I'll make directory. <br>\n"; //##
            mkdir($dir);
        }
        $dir = "../NOA_GARBAGE/Insurance";
        if (! file_exists($dir)){
            echo "($dir) is not exist, so I'll make directory. <br>\n"; //##
            mkdir($dir);
        }
        
        $args = decodeObject($value);
        $files = $args['files'];
        $array = explode(",", $files);
        
        echo "files($files)\n"; //##
       
        for ($i=$num=0,$ct=count($array); $i < $ct; $i++){
            $filename = $array[$i];
            echo "filename($filename)\n"; //##
            
            $ary = explode("_", $filename);
            $patientId = (count($ary) < 3) ? $ary[0] : $ary[1];
            $path = "../NOA_ARCHIVE/$patientId/Insurance/$filename";
            $newpath = "$dir/$filename";
            echo "path($path) new($newpath)\n"; //##
            if (rename($path, $newpath)){
                echo "$newpath へ移動しました<br>";
                $num++;
            }
        }
        echo "<SEPARATOR>";
        echo "指定された画像ファイル $num 個を $dir へ移動しました<br>";
        echo "管理者権限でこのフォルダー中のファイルを本格的に削除してください";
    } else if (strcmp($command,"GET_MESSAGE_MENU") == 0){
        // $owner のメッセンジャー用メッセージ・メニューとユーザ・リストを返す
        $args = decodeObject($value);
        $owner = $args['owner'];

        // メッセージ・メニューを取得
        $sql = "SELECT * FROM `MenuTable` WHERE `tag`='MESSAGE_MENU' AND `owner`='$owner' ORDER BY `freq`";
        echo "$sql \n"; //##
        $result=mysql_query($sql);
        
        $records = array();
        $array = array();
        while ($row=mysql_fetch_array($result)){
            $rec = array();
            $rec['menu'] = $row['menu'];
            $rec['freq'] = $row['freq'];
            $array[$row['menu']] = $rec;
        }
        $records['messageMenu'] = $array;
        
        // ユーザ・リストを取得
        $sql = "SELECT * FROM `UserTable`";
        echo "$sql \n"; //##
        $array = array();
        $result=mysql_query($sql);
        while ($row=mysql_fetch_array($result)){
            $logname = $row['loginName'];
            $array[$logname] = $row['kanjiName'];
        }
        $records['userList'] = $array;
        
        echo "<SEPARATOR>";
        echo json_encode($records);
    } else if (strcmp($command,"GET_BOOKING") == 0){
        // dateTime 以後の patientId の受診日を返す
        $args = decodeObject($value);
        $patientId = $args['patientId'];
        $dateTime = $args['dateTime'];
        
        // 予約日をピックアップ
        $sql = "SELECT * FROM `FrontTable` WHERE `patientId`='$patientId' AND `entryDate`>'$dateTime' ORDER BY `entryDate` DESC";
        echo "====== GET_BOOKING\n $sql \n";//###
        $result=mysql_query($sql);
        
        $results = array();
        while ($row=mysql_fetch_array($result)){
            $results[] = $row['entryDate'];
        }
        
        echo "<SEPARATOR>";
        echo json_encode($results);
    } else if (strcmp($command,"GET_ACCESS_LOG") == 0){
        // owner のアクセス・ログを取り出し返す
        $args = decodeObject($value);
        $owner = $args['owner'];
        $reverse = $args['reverse'];
        
        $results = getAccessLog($owner, $reverse);
        
        echo "<SEPARATOR>";
        echo json_encode($results);
    } else if (strcmp($command,"REMOVE_ACCESS_LOG") == 0){
        $args = decodeObject($value);
        $owner = $args['owner'];
        $patientId = $args['patientId'];
        
        $results = removeAccessLog($patientId, $owner);
        
        echo "<SEPARATOR>";
        echo json_encode($results);
    } else {
        echo "*** unknown command: $command ***";
    }
    
?>
