
/////////////////////////////////////////////
///// NOA からの継承値 /////////////////////////

// NOA 組込みの場合は patient_id() などを直接取得できるが
// 外付けツールにも出来るようあえて以下の仕組みを使う

function noa(){
    if (window.opener.name == "noa")
        return window.opener;
    else {
        alert("ERROR *** vin.js: window.opener としての NOA が見つかりません");
        return null;
    }
}

///// NOA からの継承値 /////////////////////////
/////////////////////////////////////////////


var _itemArray; // = new Array(); // Global 変数
var _groupCode; // = new Array(); // Global 変数

function initItemArray(){
	_itemArray = new Array();
}
function addItemArray(item){
	_itemArray.push(item);
}
function removeItemArray(number){
	for (var i=_itemArray.length-1; i >= 0; i--){
		var _item = _itemArray[i];
		if (number == _item.number) _itemArray.splice(i, 1);
	}
}
function countOfItemArray(){
	return _itemArray.length;
}
function itemAtIndexOf(ix){
	// itemArray の ix 番目の item を返す
	return (ix < _itemArray.length) ? _itemArray[ix] : null;
}
function itemWithId(number){
	// number を ID とする item を返す
	var count = _itemArray.length;
	for (var i=0; i < count; i++){
		var item = _itemArray[i];
		if (item.number == number) return item;
	}
	return null;
}

var _currentRecords; // = new Array(); // Global 変数
function setCurrentRecords(ln){
	// 現在選択されているレコードの値を記憶
	_currentRecords = ln;
}
function currentRecords(){
	return _currentRecords;
}

function groupCode(){
	// 診療行為のコード番号を返す
	return _groupCode;
}
function setGroupCode(code){
	// 診療行為の種類が選択された
	if (_groupCode){
		var elm = document.getElementById("item:"+_groupCode);
		elm.style.backgroundColor="#bfe";
		elm.style.color="#000";
	}
	
	_groupCode = code;
	var elm = document.getElementById("item:"+code);
	elm.style.backgroundColor="#00f";
	elm.style.color="#ffa";
	
	getItemList(code);
}

//////////////////////////////////
///// HospitalTable からの継承値 ///

var _round; // Global 変数
var _ownRate; // Global 変数

function setHospitalInfo(values){
	// values = "5_|_20"
	var array = values.split("_|_");
	if (array.length > 1){
		_round = array[0] * 1;
		_ownRate = array[1] * 1;
	}
	else
		alert("setHospitalInfo Error: "+ values);
}

function marume(val){
	return Math.floor((val + _round) / 10) * 10;
}

function ownRate(){
	// 自費料金を計算するための点数への掛け率
	return _ownRate;
}

///// HospitalTable からの継承値 ///
//////////////////////////////////



/////////////////////////
///// カルテからの継承値 ///

function container(){
	// vinServer へ渡すための変数パッケージ
	var obj = new Object();
	obj['owner'] = noa().owner();
	obj['patientId'] = noa().patient_id();
	obj['entryDate'] = noa().currentDate();
	obj['age'] = ageOfTheMoon();
	var elm = document.getElementById("timeZone");
	obj['timeZone'] = (elm) ? elm.value : "";
    
	return obj;
	
	function ageOfTheMoon(){
		// patientId と本日の年月日から年齢を計算して返す
		var pid = noa().patient_id();
		var yy = pid.substr(4,2) * 1;
		var yyyy = (yy > 25) ? 1900 + yy : 2000 + yy;
		var mm = pid.substr(0,2) * 1;
		var dd = pid.substr(2,2) * 1;
		var birthDate = yyyy + "-" + mm + "-" + dd;
        
		return ageAtDate(birthDate, noa().currentDate());
	}
}

function args(){
	// patientId, ageOfTheMoon
	// を vinServer へ渡すための変数パッケージ
	var array = new Array();
	array[0] = noa().owner();
	array[1] = noa().patient_id();
	array[2] = noa().currentDate();
	array[3] = ageOfTheMoon();
	var elm = document.getElementById("timeZone");
	array[4] = (elm) ? elm.value : "";
	return "&args=" + array.join("_|_");
	
	function ageOfTheMoon(){
		// patientId と本日の年月日から年齢を計算して返す
		var pid = noa().patient_id();
		var yy = pid.substr(4,2) * 1;
		var yyyy = (yy > 25) ? 1900 + yy : 2000 + yy;
		var mm = pid.substr(0,2) * 1;
		var dd = pid.substr(2,2) * 1;
		var birthDate = yyyy + "-" + mm + "-" + dd;

		return ageAtDate(birthDate, noa().currentDate());
	}
}

///// カルテからの継承値 ///
/////////////////////////


///////////////////////////////////////
///// レコードの文字列化はここで管理     ///
///// vin.php 側では newItem() で管理 ///

function archives(){
	// itemArray を文字列に変換して返す
	var count = countOfItemArray();
	if (count == 0) return "";
	
	var array = new Array();
	for (var i=0; i < count; i++){
		var item = itemAtIndexOf(i);
		if (item.code % 10 == 9) continue; // 自動付加行はスキップ
		if (item.code * 1 == 13) continue; // 自動付加行はスキップ
		array.push(encodeItem(item));
	}
	return array.join("\n");
}

function encodeItem(item){
	// item を "1_|_21_|_pill_|_低用量ピル_|_28_|_Tab_|_53.0_|_0" に変換して返す
	var array = new Array();
	
	array.push(item.isOwn);
	array.push(item.code);
	array.push(item.alias);
	array.push(item.name);
	var dose = (item.dose * 1 > 0) ? item.dose : 1;
	array.push(dose); // item.standard の位置を使う
	array.push(item.unitName);
	array.push(item.freq);
	array.push(item.point); // 空データの場合はサーバ側で PriceList から補完
	array.push(item.isMix);
	
	return array.join("_|_");
}

function codeName(code){
    // ### vinServer.js の codeName() と同じであること ###
    switch (code * 1){
        case 11: return "初診";
        case 12: return "再診";
        case 13: return "診他";
        case 21: return "内服";
        case 22: return "屯服";
        case 23: return "外用";
        case 29: return "薬加";
        case 31: return "皮注";
        case 32: return "静注";
        case 33: return "点滴";
        case 41: return "処置";
        case 48: return "処薬";
        case 51: return "手術";
        case 52: return "麻酔";
        case 58: return "手薬";
        case 60: return "検査";
        case 69: return "判断";
        case 70: return "画像";
        case 80: return "其他";
        case 90: return "入院";
        case 91: return "入他";
        default: return "";
    }
}
function newRow(obj){
    // "外用[ホーリンV錠 (2 錠)] 220 x 2 自費" のような形式の一行を生成
    var own = (obj.isOwn * 1) ? " 自費" : "";

    if (obj.code *1 == 99)
        return obj.name;
    else {
        var freq = (obj.freq * 1 > 1) ? " x " + obj.freq : "";
        var name = codeName(obj.code);
        
        // 単位がある場合は (単位数 単位) を表示
        var doseUnit = (obj.unitName.length > 0)
            ? "(" + obj.dose + " " + obj.unitName + ")" : "";
        
        return name + "[" + obj.name + doseUnit + "] " + obj.point + freq + own;
    }
}

function newItem(ln){
	// アイテム属性を記憶した Item Class を生成し itemArray に保存
	//alert("newItem:"+ln); //##
	var array = ln.split("_|_");
	if (array.length < 8){
		if (array.length > 1){
			message = "Item のフィールド数が足りません ("+ln+")";
			document.getElementById("message").innerHTML = message;
		}
		return null;
	} 
	
	var item = new Object();
	var number = countOfItemArray();
	addItemArray(item); // number を取り出した後で実行すること
    
	item.origin = ln;
	item.number = number; // item の ID (必ずしも itemArray 中の順番ではない)
	item.subItems = new Array();
	item.isOwn = array[0];
	item.code = array[1];
	item.alias = array[2];
	item.name = array[3];
	item.dose = array[4];
	item.standard = array[4];
    if ((item.standard.length == 0) || (item.standard * 1 == 0))
        item.standard = 1;
	item.unitName = trim(array[5]);
	item.freq = array[6];
	item.point = array[7]; // 空データの場合は calc() 時にサーバ側で PriceList から補完
	item.isMix = array[8];
	item.editable = 0;

	return item;
}

///// レコードの文字列化はここで管理 ///
///////////////////////////////////

///////////////////////////////////
/// localStorage による処理 /////////

function setVinTouchAndGo(elm){
    // 確定保存のチェック状態を記憶
    window.localStorage["vinTouchAndGo"] = (elm.checked) ? "1" : "0";
}
function isVinTouchAndGo(){
    var status = window.localStorage["vinTouchAndGo"];
    
    return (status && status * 1) ? true : false;
}

/// localStorage による処理 /////////
///////////////////////////////////

///////////////////////////////////
///// Ajax による処理 ///////////////

function savedTemplate(){
	// テンプレートが保存された後の処理
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
			alert(array[1]);
			// どういう訳かこのままではテンプレート更新が反映されないので reload
			window.location.reload(true); // 強制的にページを再表示
		}
		document.getElementById("message").innerHTML = "";
	}
	else 
		document.getElementById("message").innerHTML = "Loading...";
}
function saveTemplate(){
	var itemName = document.getElementById("itemSelector").value;
	var title = document.getElementById("templateName").value;
	if (title.length == 0){
		alert("テンプレート名を入れてから登録してください");
		return;
	} else if (isSame(itemName, title)){
		if (!confirm("同名テンプレートを上書きしていいですか？")) return;
	}
	
	// 現在表示されているレコード・セットをテンプレートとして登録
	xmlHttpObject = createXMLHttpRequest(savedTemplate);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var st = "./vinServer.php?command=PUT_TREATMENT_GROUP"
		+ "&alias="+title
		+ "&value="+archives()
		+ args();
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function getTimeZone(csv){
	// ",,0000,0600,深夜\n,,0900,1200,時間内" 形式を解析して時間区分を返す
	// csv = ",,0000,0600,深夜\n,,2200,2400,深夜\n,日,0000,2400,休日";
	//alert("getTimeZone ---\n"+csv); //##
	var year = noa().currentDate().substr(0, 4);
	var month = noa().currentDate().substr(5, 2);
	var day = noa().currentDate().substr(8, 2);
	var date = new Date(year, month - 1, day);
	var d = date.getDay();
	var week = weeks()[d];
	var weekNum = Math.ceil(day / 7);
	var hour = noa().currentDate().substr(11, 2);
	var min = noa().currentDate().substr(14, 2);
	var time = hour + min;
	
	// 指定した日時の時間区分をチェックする
	var array = decodeCSV(csv);
	for (var row=0,ct=array.length; row < ct; row++){
		var obj = array[row];
		var result = timeZone(obj,weekNum,week,time);
		if (result.length > 0){
			return result;
		}
	}
	return "時間外";
	
	function timeZone(obj,weekNum,week,time){
		// 時間区分を返す
		if (obj.num)
			if (obj.num != weekNum) return "";
		if (obj.week)
			if (obj.week != week) return "";
		if (obj.from > time)
			return "";
		if (obj.to < time)
			return "";
		return obj.timeZone;
	}
	
	function decodeCSV(csv){
		// csv を conditions オブジェクトへ変換
		var results = new Array();
		var array = csv.split("^");
		for (var row=0,rows=array.length; row < rows; row++){
			var ln = trim(array[row]);
			var ary = ln.split(",");
			if (ary.length == 5){
				var obj = new Object();
				obj.weekNum = ary[0];
				obj.week = ary[1];
				obj.from = ary[2];
				obj.to = ary[3];
				obj.timeZone = ary[4];
				results.push(obj);
			}
		}
		
		if (results.length == 0){
			// csv に解析できるものがなければ default 条件を生成定
			var obj = new Array();
			obj.from = "0000";
			obj.to = "0600";
			obj.timeZone = "深夜";
			results.push(obj);
			
			var obj = new Array();
			obj.from = "2200";
			obj.to = "2400";
			obj.timeZone = "深夜";
			results.push(obj);
			
			var obj = new Array();
			obj.week = "日";
			obj.from = "0000";
			obj.to = "2400";
			obj.timeZone = "休日";
			results.push(obj);
			
			var obj = new Array();
			obj.from = "0900";
			obj.to = "1200";
			obj.timeZone = "時間内";
			results.push(obj);
		}
		
		return results;
	}
}

/////////////////////////////////////////////////////////////
///// Ajax: VIN は独立して動くので LOGIC:neuron.js の部分を内部に持つ

function putHeader(){
	// サーバから返されたヘッダー部分を表示
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("putHeader:"+value); //##

		var array = value.split("<SEPARATOR>");
		if (array.length >= 4){
			initItemArray();
			
			// 診療行為マトリックスを表示
			setItemMatrix(array[1]);
			
			// 診療時間帯ポップアップメニューを表示
			var timeZone = getTimeZone(array[2]); //## とりあえず
			setTimeZonePopup(timeZone); //## とりあえず
			
			// hospitalTable などから施設固有値を得る
			setHospitalInfo(array[3]);
                        
			// カルテが記憶していた診療行為セットを itemArray にセット
			var buff = array[4];
			if (buff.length){
				var records = buff.split("\n");
				var count = records.length;
				for (var i=0; i < count; i++){
					var ln = records[i];
					// この中の point はカルテの treatment フィールドから
					// 読み出されたものなので point * dose 処理がされている
					// ln:静注[ピドキサール注１０ｍｇ(1 管) 混注] 6 
					if (ln.length > 0) newItem(ln);
				}
				showItemList();
			}
		}

		document.getElementById("message").innerHTML = "";
	}
	else 
		document.getElementById("message").innerHTML = "Loading...";
	
	function setItemMatrix(jsonString){
		// 診療行為マトリックスを生成
		var elm = document.getElementById("matrixArea");
		var obj = JSON.parse(jsonString);
        var ul = newUL(elm, "");
        ul.setAttribute("class", "listMembers");
		for (key in obj){
			var code = obj[key];
            var li = newLI(ul, key);
            li.setAttribute("id", "item:"+code);
            li.setAttribute("class", "blueButton");
			var action = "setGroupCode('" + code + "')";
			li.setAttribute("onclick", action);
		}
	}
	
	function setTimeZonePopup(currentTimeZone){
		// 診療行為ポップアップメニューを生成
		var array = ["時間内","時間外","休日","深夜"];
		var elm = document.getElementById("timeZoneArea");
		var pu = makePopupMenu(elm, "timeZone", array, currentTimeZone);
	}
}
function getHeader(){
	// onload で起動されるアクション：サーバにヘッダー部分の生成を依頼し表示
	xmlHttpObject = createXMLHttpRequest(putHeader);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var st = "./vinServer.php?command=GET_HEADER"
		+ "&value=" + encodeObject(container());
        
		//alert("getHeader:\n"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

///// Ajax: VIN は独立して動くので LOGIC:neuron.js の部分を内部に持つ
/////////////////////////////////////////////////////////////



var _items;
function setItems(array){
	_items = array;
}
function items(){
	return _items;
}

var _aliases;
function setAliases(array){
	_aliases = array;
}
function aliasForTitle(title){
	return _aliases[title];
}

function putItemList(){
	// アイテムリストを表示する
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
			var elm = document.getElementById("itemSelectorArea");
			elm.innerHTML = "";
			
			// "itemSelectorArea" の上にポップアップメニュー生成
			var items = new Array();
			var aliases = new Array();
			var item = "";
            //alert("putItemList->"+array[1]); //##
            
			var obj = JSON.parse(array[1]);
			// obj は {"再診料":"saishin",,} のようなオブジェクトの配列
			for (title in obj){
				var value = obj[title];
                if (title.length ==0) continue;
                
				items.push(title);  // title:"再診料"
				aliases[title] = value; // value:"saishin"
				if (isSame(value, "shoshin")) 
					item = title;
				else if (isSame(value, "saishin")) 
					item = title;
			}
			items.splice(0, 0, "");
			items.push("...その他");
			setItems(items);
			setAliases(aliases);
			
            //alert("putItemList->"+encodeObject(items)); //##
            
			// item 選択ポップアップを表示
			var pu = makePopupMenu(elm, "itemSelector", items, item);
			pu.setAttribute("onchange", "itemSelected()");
			itemSelected();
			
			// 絞り込みフィールドを生成
			makeForcusOnArea();
			
			document.getElementById("message").innerHTML = "";
		}
	}
	else 
		document.getElementById("message").innerHTML = "Loading...";
}
function getItemList(num){
	// 診療行為マトリックスの選択で起動され、該当アイテムリストをリクエスト
	xmlHttpObject = createXMLHttpRequest(putItemList);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var st = "./vinServer.php?command=GET_CHILD_SELECTOR&value="+num;
		//alert("getItemList->"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function putItem(){
	// 選択されたアイテムの入力欄を再描画
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
			// array[1] = "_|_21_|_pill_|_低用量ピル_|_28_|_Tab_|_53_|_0"
			// 一括テンプレートの場合は "\n" で区切られた複数レコード
			var records = array[1].split("\n");
			var count = records.length;
			
			// ここでは選択されたアイテムに対するレコードをサーバの PriceList から得たもの
			// なので point * dose 処理がされていない。従って point は全て空にしておく。
			// 空 point だと calc() の時に PriceList の点数で補完される。
			records = pointToEmpty(records);
			
			// code に応じて「数量」「頻度」入力欄を表示
			// records[0] = "1_|_21_|_pill_|_低用量ピル_|_28_|_Tab_|_1060_|_0" 形式
			setCurrentRecords(records);
			showDoseAndFreqField(records[0]);
			
			document.getElementById("message").innerHTML = "";
		} else
			document.getElementById("message").innerHTML = value;
	} else 
		document.getElementById("message").innerHTML = "Loading...";
}
function getItem(){
	// itemSelector（薬剤名など）が選択された時に作動
	xmlHttpObject = createXMLHttpRequest(putItem);
	
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var isOwn = (document.getElementById("isOwn").checked) ? 1 : 0;
		var item = document.getElementById("itemSelector").value;
		var st = "./vinServer.php?command=GET_ITEM"
		+ "&isOwn="+isOwn
		+ "&code="+groupCode()
		+ "&alias="+aliasForTitle(item)
		+ "&args="+args();
		
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function putResultOfCalc(){
	// 選択されたアイテムを追加しアイテム・リストを再表示
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		
		var array = value.split("<SEPARATOR>");
        var rows = new Array();
		if (array.length > 1){
			initItemArray();
			var records = array[1].split("\n");
            for (num in records){
				var ln = records[num];
				if (ln.length > 0) {
                    var obj = newItem(ln);
                    if (obj) rows.push(newRow(obj)); // NOA 形式の一行
                }
			}
		}
        // VIN の内容を再表示
		showItemList();
        
        // 「領収書」ボタンを表示
        showBillButton();

        // NOA へ結果を返送
        var status = document.getElementById("touchAndGoCheck").checked;
		noa().gotValueFromTool(rows.join("<br>"), status);
        
		document.getElementById("message").innerHTML = "";
	}
	else 
		document.getElementById("message").innerHTML = "Loading...";
}
function calc(){
	// アイテム・リストの計算を vinServer へリクエスト
	// サーバ側で計算結果を FRONT へ転送
	var today = todayAndTime().substr(0, 10);
	var pageDay = noa().currentDate().substr(0, 10);
	if (isSame(today, pageDay) == 0){
		if (!confirm("本日のページではありません。書き換えていいですか？")) 
			return;
	}
	
	xmlHttpObject = createXMLHttpRequest(putResultOfCalc);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		// buff は itemArray() を encodeItem() で文字列にしたもの
		// これをサーバへ送って計算を依頼する
		var buff = archives(); 
		if (buff.length == 0){
			if (confirm("本日も前回と同じ診療行為ですか？")) buff = "";
			else buff = " ";
		}
		var st = "./vinServer.php?command=CALC"
		+ "&value=" + buff
		+ args();
        
        //alert("calc->"+st); //##
		
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

///// Ajax による処理 ///////////////
///////////////////////////////////

function forcusOn(){
	// key に一致するメニューだけを表示
	var key = document.getElementById("focusOnF").value;
	
	// key を含むメニューのみに絞り込む
	// ## items() はメニュー表示内容なので alias も保持しておき
	// ## alias も検索対象にできるようにする
	var menuItems = new Array();
	var array = items();
	for (num in array){
		var name = array[num]; // 診療行為の実名
        var alias = aliasForTitle(name); // 実名に対応する alias
        
        // 実名か alias に部分一致したものだけを menuItems に取り込む
		if (alias && (alias.indexOf(key) >= 0)){
			menuItems.push(name);
		} else if (name.indexOf(key) >= 0){
			menuItems.push(name);
        }
	}
	
	// ポップアップメニューを表示
	var elm = document.getElementById("itemSelectorArea");
	elm.innerHTML = "";

	var pu = makePopupMenu(elm, "itemSelector", menuItems, "");
	pu.setAttribute("onchange", "itemSelected()");
	itemSelected();
}
function makeForcusOnArea(){
	// アイテムを絞り込みを行うフィールドを生成
	var elm = document.getElementById("focusOnArea");
	elm.innerHTML = " 絞込 ";
	var fd = newFIELD(elm, "focusOnF", "", 20, "");
	fd.focus();
	//fd.setAttribute("onchange", "forcusOn()");
	fd.setAttribute("onkeyup", "forcusOn()");
}

function putGlobal(answer){
	// globalList.js から返されるレスポンス
	var obj = decodeObject(answer);
	
	//alert("putGlobal:"+obj.name); //##
	
	// records[0] = "1_|_21_|_pill_|_低用量ピル_|_28_|_Tab_|_1060_|_0" 形式
	var isOwn = (document.getElementById("isOwn").checked) ? 1 : 0;
	var alias = "";
	var array = new Array();
	array.push(isOwn);
	array.push(groupCode());
	array.push(alias);
	array.push(obj.name);
	array.push(""); // standard
	array.push(obj.unitName);
	array.push("0"); // freq
	array.push(obj.point);
	var st = array.join("_|_");
	
	// currentRecords に加える
	var records = new Array();
	records.push(st);
	setCurrentRecords(records);

	// 選択されたレコード名を表示
	var elm = document.getElementById("itemSelectorArea");
	elm.innerHTML = obj.name; //st;

	showDoseAndFreqField(st);
	
	// itemSelector がアクティブの時のみ挿入ボタンを表示
	showItemAddButton();
	
}
function itemSelected(){
	// itemSelector（薬剤名など）が選択された時に作動
	
	// ポップアップメニューに表示されたアイテムを default テンプレート名として表示
	var itemName = document.getElementById("itemSelector").value;
	if (itemName == ""){
		hideItemAddButton();
		return;
	} else if (itemName == "...その他"){
		// グローバル辞書からの選択パネルを表示
		// ### globalList からのメッセージは putGlobal() で受ける
		var url = "./globalList.php?code=" + groupCode();
		window.open(url, "globalList"
					, "scrollbars=yes,width=900,height=500");
		return;
	}
	
	// itemSelector がアクティブの時のみ挿入ボタンを表示
	showItemAddButton();

	var fd = document.getElementById("templateName");
	if (fd) fd.value = itemName;
	
	getItem();
}

function pointToEmpty(records){
	// record 中の point を全て空にする。
	// 空 point だと calc() の時に PriceList の点数で補完される。
	for (var i=0, count=records.length; i < count; i++){
		// "0_|_21_|_adona30mg_|_アドナ30mg_|_3_|_Tab_|_1_|_12.9_|_0" 形式のレコード
		var ln = records[i];
		var array = ln.split("_|_");
		array[7] = ""; // point を空にする
		records[i] = array.join("_|_");
	}
	return records;
}

function showDoseAndFreqField(rec){
	// 数量・頻度入力欄を表示
	// rec: "1_|_21_|_pill_|_低用量ピル_|_28_|_Tab_|_1_|_1060_|_0" 形式のレコード
	// から default 値を表示
	var elm = document.getElementById("doseAndFreqArea");
	elm.innerHTML = "";

	var code = groupCode() * 1;
	if (code == 0) return; // 一括メニュー
	
	var array = rec.split("_|_"); 
	var dose = array[4];
	var unitName = array[5];
	switch (code){
		case 21: case 22: case 23:
			showDose(elm, dose, unitName);
			showFeq(elm, code);
			break;
		case 31: case 32: case 33:
			showDose(elm, dose, unitName);
			var cb = newCHECKBOX(elm, "isMix", "を混注の追加薬剤として ", 0);
			break;
	}
	
	function showDose(elm, dose, unitName){
		var fd = newFIELD(elm, "dose", "", 3, dose);
		var tx = newTEXT(elm, unitName);
	}

	function showFeq(elm, code){
		var freq = 5; // ５日分に決め打ち
		var fd = newFIELD(elm, "freq", "", 2, freq);
		var tx = newTEXT(elm, freqName(code));
	}
}

function freqName(code){
	if (code == 23)
		return "回";
	else
		return "日";
}

function showItemList(){
	// アイテム・リストを表示
	var elm = document.getElementById("result");
	elm.innerHTML = "";
	
	// タイトル
	var tbl = newTABLE(elm, "base-table");
	var tr = newTR(tbl, "", "");
    tr.style.color = "#888";
    tr.style.fontSize = "10pt";
	var td = newTD(tr, "title_code", "");
    setInfoTip("title_code", "以下の行を一括消去"); // HELP
    var img = newIMAGE(td, "icon", "./remove-field.png", "remove");
	img.setAttribute("onclick", "clearItems()");
	img.style.height = "12px";
	img.style.position = "relative";
	img.style.bottom = "1px";
    img.style.marginLeft = "2px";
	var td = newTD(tr, "vin-col", "診 療 行 為");
    td.style.paddingBottom = "5px";
	var td = newTD(tr, "vin-col", "数量");
    td.style.paddingBottom = "5px";
	var td = newTD(tr, "vin-col", "点数");
    td.style.paddingBottom = "5px";
	var td = newTD(tr, "vin-col", "頻度");
    td.style.paddingBottom = "5px";

	// 診療行為コンテンツ
	var count = countOfItemArray();
	var sumItem;
	if (count > 0){
		// 既存のアイテムがあった場合
		for (var i=0; i < count; i++){
			var item = itemAtIndexOf(i);
			if (item.code == "0")
				continue;
			if (item.code == "99")
				sumItem = item;
			else { 
				// 自費か健保かにより背景色を変える
				var trId = (item.isOwn > 0) ? "jihi" : "record";
				var tr = newTR(tbl, trId, "");
				
				// コード
				var td = newTD(tr, "", "");
                td.style.paddingLeft = "5px";
				var a = newA(td, item.code, "#", "");
				var action = "removeItem('" + item.number + "')";
				a.setAttribute("onclick", action);
				
				// 診療行為（自動付加のものは背景色を変える）
				var tdId = ((item.code % 10 == 9) || (item.code * 1 == 13))
				? "subRecord" : "";
				var td = newTD(tr, "", "");
                var sp = newSPAN(td, tdId);
                sp.innerHTML = item.name;
                // コード種別ごとに背景色を変える
                switch (item.code * 1){
                    case 41: case 48: sp.setAttribute("class", "shochi"); break;
                    case 60: sp.setAttribute("class", "kensa"); break;
                }
                
				// 数量・単位
				var td = newTD(tr, "", "");
				if ((item.code != 60) && (item.unitName.length)){
                    var ary = item.unitName.split(" ");
                    var tx = newTEXT(td, item.dose + " " + item.unitName);
                }
				
				// 数量 x 点数（ここに表示されるものは、薬価 * 数量なので注意）
				var td = newTD(tr, "pointArea_" + item.number, "");
				td.setAttribute("align", "right");
				// 混注の行に色をつける
				td.style.backgroundColor = (item.isMix > 0) 
					? "#ddd" : "#fff";
				// addItem() で PriceList を元に挿入されたものは空 point
				// calc() や getHeader() で取り込まれたものは point * dose 処理済み
				var tx = newTEXT(td, item.point);
				
				// 頻度
				var td = newTD(tr, "freqF", "");
                td.style.paddingRight = "5px";
				var fname = freqName(item.code * 1);
				if (item.freq * 1 > 1)
					var tx = newTEXT(td, item.freq + " " + fname);
			}
		}
	}
	// 合計
	if (sumItem){
		// 合計についてはフォーマットが異なり item.name の中に入っている
		// "_|_99_|__|_合計[健保(686 x 3 = 2050)自費(5400)] 7450_|__|__|__|_"
		var tr = newTR(tbl, "sum", "");
		var td = newTD(tr, "", sumItem.name);
		td.setAttribute("colspan", "5");
	}
	
	// 絞込みフィールドをフォーカス
	var fd = document.getElementById("focusOnF");
	if (fd) fd.focus();
    
    // 診療行為に変更が加えられたので「集計」されるまで「領収書」ボタンを表示しない
    hideBillButton();
}

function clearItems(){
	// アイテム・リストをクリアする
	initItemArray();
	showItemList();
}

function removeItem(number){
	var item = itemWithId(number);
	// if (!confirm(item.name + "を削除します")) return;
	
	removeItemArray(number);
	showItemList();
}

function hideItemAddButton(){
	document.getElementById("itemAddButtonArea").innerHTML = "";
}
function showItemAddButton(){
	var sp = document.getElementById("itemAddButtonArea");
	sp.innerHTML = "";
    sp.style.marginLeft = "5px";
	var bt = newDIV(sp, "/whiteButton");
    bt.innerHTML = "挿入";
	bt.setAttribute("onclick","addItem()");
}
function addItem(){
	// 選択・編集されたアイテムを診療行為リストに追加する
	// "1_|_21_|_pill_|_低用量ピル_|_28_|_Tab_|_1_|_1060_|_日分_|_" 形式のレコード
	// これを元に item オブジェクトを生成し currentItem に記憶
	var records = currentRecords();

	if (records.length == 1){
		// 一括メニューでない場合
		var array = records[0].split("_|_");
		array[0] = (document.getElementById("isOwn").checked) ? 1 : 0;
		var elm = document.getElementById("dose");
		array[4] = (elm) ? elm.value : "1";
		var elm = document.getElementById("freq");
		array[6] = (elm) ? elm.value : "1";
		// array[7] = ""; // まだ point は計算処理されていないので見せない
		var elm = document.getElementById("isMix");
		array[8] = (elm && elm.checked) ? 1 : 0;
		records[0] = array.join("_|_");
        
        //alert("addItem->"+records[0]); //##
	}
	
	for (var i=0,count=records.length; i < count; i++){
		// 一括メニュー(約束処方)の場合は、診療行為に複数を追加する
		var ln = records[i];
		var item = newItem(ln);
	}
	
	showItemList();
}

/////////////////////////////////////////////////////////////
/////// テンプレート編集ペーン //////////////////////////////////

function closeTEmplateEditor(){
	document.getElementById("templateArea").innerHTML = "";
}

function openTemplateEditor(){
	// テンプレート編集ペーンを開く
	var elm = document.getElementById("templateArea");
	if (elm.innerHTML.length > 0){
		elm.innerHTML = "";
		return;
	}
    
    var frame = newDIV(elm, "templateFrame");

    // HEADER
    var div = newDIV(frame, "");
    var dv = newDIV(div, "left-side");
	dv.innerHTML = "上記セットを一括入力へ登録";
    var dv = newDIV(div, "right-side");
	var im = newIMAGE(dv,"icon","./close.png","close");
	im.setAttribute("onclick", "closeTEmplateEditor()");

    var div = newDIV(frame, "");
    div.style.clear = "both";
    div.style.paddingBottom = "5px";
	// 約束処方名入力（一括メニューが開いていればそのメニュー・アイテムを default 表示）
	var gcode = groupCode() * 1;
	var popup = document.getElementById("itemSelector");
	var menuItem = (popup && (gcode == 0)) ? popup.value : "";
    var dv = newDIV(div, "");
    dv.style.paddingLeft = "10px";
	var fd = newFIELD(dv, "templateName", "一括名", 20, menuItem);
    fd.focus();
	var bt = newDIV(dv, "/whiteButton");
    bt.innerHTML = "登録";
	bt.setAttribute("onclick", "saveTemplate()");
}

/////// テンプレート編集ペーン //////////////////////////////////
/////////////////////////////////////////////////////////////

function showBillButton(){
    // 「領収書」ボタンを表示
	var elm = document.getElementById("billButtonArea");
    elm.innerHTML = "";
	var bt = newDIV(elm, "/whiteButton");
    bt.innerHTML = "領収書";
	bt.setAttribute("onclick","printBill()");
}
function hideBillButton(){
    // 「領収書」ボタンを削除
	var elm = document.getElementById("billButtonArea");
    elm.innerHTML = "";
}

function printBill(){
    // 領収明細書を発行
	var obj = new Object();
    obj.currentDate = noa().currentDate();
    obj.publishedDate = today();
    obj.patientId = noa().patient_id();
    obj.patientName = noa().patientKanjiName();
    obj.insuranceClass = _valueForTag("HealthInsurance.shubetsu");
    obj.paymentRatio = _valueForTag("HealthInsurance.paymentRatio");
    var st = _valueForTag("PatientTable.unpaid"); // "timeStamp,unpaid" 形式
    var array = st.split(",");
    obj.unpaidFee = (array.length > 1) ? array[1] : "0";
    obj.discountRatio = _valueForTag("HealthInsurance.discountRatio");

    // VIN の医事計算レコードをスキャン
    var point = 0;
    var ownFee = 0;
    var count = countOfItemArray();
	if (count > 0){
        obj.ins = new Object();
        obj.own = new Object();
        for (var i=0; i < count; i++){
            var item = itemAtIndexOf(i);
            var code = Math.floor(item.code / 10) * 10; // "12" を "10" にする
            var freq = (item.freq) ? item.freq : 1;
            if (item.isOwn > 0){
                if (!obj.own[code]) obj.own[code] = 0;
                // code 毎の自費点数を加算
                obj.own[code] += item.point * freq;
                ownFee += item.point * freq;
            } else {
                if (!obj.ins[code]) obj.ins[code] = 0;
                // code 毎の健保点数を加算
                obj.ins[code] += item.point * freq;
                point += item.point * freq;
            }
        }
    }
    obj.round = noa().hospitalInfoForKey("まるめ係数") * 1;
    obj.point = point;
    obj.insFee = point * obj.paymentRatio + obj.round;
    obj.insFee = Math.floor(obj.insFee / 10) * 10;
    obj.ownFee = ownFee;
    obj.ownRate = noa().hospitalInfoForKey("自費係数") * 1;
    obj.hospitalAddress = noa().hospitalInfoForKey("住所");
    obj.hospitalName = noa().hospitalInfoForKey("施設名");
    obj.hospitalPhone = noa().hospitalInfoForKey("電話番号");

	var url = "./printBill.php?value=" + JSON.stringify(obj);
    
    //alert(url); return; //##
	
	window.open(url, "BILL", "width=650,height=800,dependent=yes");
    
    function _valueForTag(tag){
        return noa().valueForTag(tag);
    }
}

function openPliceList(){
    // PriceList を開く
	window.open("../NOAManager/priceList.php?mode=NOA","PriceList");
}

function vinHelp(){
	var win = window.open("./vinHelp.html","Help"
						  ,"width=450,height=700,scrollbars=yes,resizable=yes");
	win.focus();
}

function initVin(){
	var elm = document.getElementById("base");
	
    // === HEADER ============================
    var div = newDIV(elm, "tool-header");
    var dv = newDIV(div, "/left-side");
    dv.innerHTML = "診療入力";
    dv.style.fontSize = "10pt";
    var dv = newDIV(div, "/right-side2");
	var im = newIMAGE(dv, "", "./Help.png", "?");
	im.setAttribute("onclick", "vinHelp()");
	im.setAttribute("verticalAlign", "middle");
	im.style.height = "16px";

	// --- 診療マトリックス表示・エリア ---------------
    var div = newDIV(elm, "matrixArea");

	// --- 時間帯・自費チェックボックス ---------------
    var div = newDIV(elm, "controlBox");
    var tbl = newTABLE(div, "base-table");
	tbl.style.fontSize = "8pt";
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	var cb = newCHECKBOX(td, "isOwn", "自費 ", 0);
	var js = newSPAN(td, "timeZoneArea");
	// 絞り込みボタン・エリア
	var sp = newSPAN(td, "focusOnArea");
	// 処置内容選択エリア
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "itemSelectorArea", "");
	td.style.padding = "0px 5px";
	// 診療行為名・挿入ボタン
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	td.style.padding = "0px 5px";
	var sp = newSPAN(td, "doseAndFreqArea");
	var sp = newSPAN(td, "itemAddButtonArea");
    
	// --- 診療行為表示・エリア：診療行為行を列記するエリア
    var div = newDIV(elm, "result");
	
    // === FOOTER =====================
    var div = newDIV(elm, "vin-footer");
    div.style.height = "25px";
    var dv = newDIV(div, "/left-side");
    dv.style.marginTop = "3px";
	var bt = newDIV(dv, "/whiteButton");
    bt.innerHTML = "集 計";
	bt.setAttribute("onclick","calc()");
    var sp = newSPAN(dv, "billButtonArea");
    var cb = newCHECKBOX(dv, "touchAndGoCheck", " 確定保存", isVinTouchAndGo());
    cb.setAttribute("onchange", "setVinTouchAndGo(this)");
    var dv = newDIV(div, "/right-side");
    dv.style.width = "30%";
    dv.innerHTML = version();
    dv.style.marginTop = "7px";

	// アンカー・エリア
	var div = newDIV(elm, "anchor");
    div.style.paddingTop = "5px";
    var ul = newUL(div, "");
    ul.setAttribute("class", "listMembers");
    var li = newLI(ul, "PriceList 編集");
    li.setAttribute("class", "listMember");
	li.setAttribute("onclick", "openPliceList()"); 
    var li = newLI(ul, "テンプレートへ登録");
    li.setAttribute("class", "listMember");
	li.setAttribute("onclick", "openTemplateEditor()");
    
	// --- テンプレート登録時にテンプレート名入力欄を表示するためのエリア
    var div = newDIV(elm, "templateArea");
	
	getHeader();
}

function version(){
	return "Ver.130112";
}


