
/////////////////////////
///// カルテからの継承値 ///

function noa(){
    if (window.opener.name == "noa"){
        return window.opener;
    } else if (window.opener.name == "tools"){
        return window.top.noa;
    } else if (window.top.noa){
        return window.top.noa;
    } else {
        alert("ERROR *** cellPreference.js: window.opener としての NOA が見つかりません");
        return null;
    }
}

function tag(){
    // panelEditor から起動する場合は URL パラメータ渡し
    var val = document.getElementById("_tag").value;
    return (val) ? val : noa().currentTag();
}

// owner(), tag() などは他とカブりエラーになるので noa().owner() のような使い方

///// カルテからの継承値 ///
/////////////////////////


function editors(){
    // ### 専用エディターが増えたらここに追加する ###
    return {"伝票":"openForm","処方":"openPrescriptionEditor","医事計算":"openVinEditor"};
}
function editorNames(){
	// editor の日本語名称の配列を返す
    // return ["","伝票","処方","医事計算"];
    // ### cellEditor.js で for (key in array) を実行すると window 認識がおかしくなる
    var array = allKeys(editors());
    array.splice(0,0,"");
    
    return array;
}
function nameForEditor(editor){
	// editor に対応する日本語名称を返す
    // ### cellEditor.js で for (key in array) を実行すると window 認識がおかしくなる
    return keyForValueIn(editors(), editor);
}
function editorForName(name){
	// 日本語名称に対応する editor を返す
	var editor = editors()[name];
    
	return (editor) ? editor : "";
}


////////////////////////////////
/// neuron.js による処理 /////////

function savedCellEditor(answer){
    // CELL 属性がサーバに保存されたことを返すだけで answer は利用されない
    //alert("savedCellEditor->"+answer); //##
    alert("ブラウザー画面の再読込で変更が反映されます");
    
    closeAttributeEditor();
    
    // NOA の CELL フィールド属性をサーバから再読み込み
    // ### これでは駄目：サーバから再読込されていない ###
    // noa().NRGetCellUserHospitalInfo(noa().owner(), alert);
}
function saveCellEditor(){
    // CELL 属性をサーバへ保存：MenuTable の更新は行わない
    var obj = editorObject();

    //alert("saveCellEditor-> "+encodeObject(obj)); return; //##
    
	NRPutCellAttributes(noa().owner(),
						obj.tag,
						obj.buttonType, // monoSelection
						obj.menuType, 
						obj.menuAction,
						obj.hitAndRun,
						obj.fieldType, 
						obj.disabled,
						obj.editor,
                        obj.id,
						obj.script,
						obj.bgcolor,
						obj.label,
						obj.numbering,
						obj.study,
						obj.fontSize,
						obj.fontFamily,
						obj.color,
                        obj.groupMenu,
						savedCellEditor);
}

function editorObject(){
    // CELL Editor の設定値を入れたオブジェクトを返す
    
    // tag に相当するレイアウト属性を得ておく
    var cell = noa().fieldForTag(tag());
    
    var obj = new Object();
    obj.tag = tag();
    obj.buttonType = (document.getElementById("monoSelection").checked) ? "1" : "0";
    obj.menuType = menuTypeForItem(document.getElementById("menuType").value);
    obj.menuAction = menuActionForItem(document.getElementById("menuAction").value);
    obj.hitAndRun = cell.hitAndRun; // 表示/非表示：Layout.js で扱う
    obj.fieldType = fieldTypeForItem(document.getElementById("fieldType").value);
    // direction --- サーバ側で固定値 "CELL" が入る
    obj.disabled = (document.getElementById("disabled").checked) ? "1" : "0";
    obj.editor = document.getElementById("editorF").value;
    obj.id = modeForTag(tag()); // 'P','B','I' いずれかを入れなければならない
    obj.script = document.getElementById("scriptArea").innerHTML;
    obj.bgcolor = colorCode('bgcolor');
    obj.label = document.getElementById("labelF").value;
    obj.numbering = cell.numbering; // -- CELL 表示順位：Layout.js で扱う
    obj.study = (document.getElementById("study").checked) ? "1" : "0";
    obj.fontSize = document.getElementById("fontSizeF").value;
    obj.fontFamily = document.getElementById("fontFamilyF").value;
    obj.color = colorCode('color');

    //alert("editorObject-> "+encodeObject(obj)); //##
    
    return obj;
    
    
    function menuTypeForItem(item){
        // item に対する menuAction 番号を返す
        var types = menuTypes(); // lib.js
        for(num in types){
            if (item == types[num]) return num;
        }
        return 0;
    }
    
    function menuActionForItem(item){
        // item に対する menuAction 番号を返す
        var items = menuPositions(); // lib.js
        for(num in items){
            if (item == items[num]) return num;
        }
        return 0;
    }

    function fieldTypeForItem(item){
        // item に対する menuAction 番号を返す
        var types = fieldTypes(); // lib.js
        for(num in types){
            if (item == types[num]) return num;
        }
        return 0;
    }
    
    function colorCode(type){
        var color = "";
        var id = (type == 'color') ? 'colorBox' : 'bgcolorBox';
        if (document.getElementById(id).checked){
            var red = document.getElementById(type+".R").value;
            var green = document.getElementById(type+".G").value;
            var blue = document.getElementById(type+".B").value;
            var color = "#" + red + green + blue;
        }
        
        return (color.length == 4) ? color : "";
    }
}

function setGroupMenuEditor(answer){
    // GROUP MENU 属性を再表示
    //alert(answer); //##
    document.getElementById("freqF").value = answer * 1;
}

function freqAreChanged(elm){
    // 頻度が変更されるとリアルタイムにサーバを更新
    var item = document.getElementById("menuItem").value;
    var freq = elm.value;
    
	// 変更されたメニューの頻度をサーバへ保存：_group_ なら頻度の保存先を換える
    var owner = noa().owner();
    var mtype = document.getElementById("menuType").value;
    
    if (mtype == menuTypes()[_group_])
        NRPutGroupMenu(owner, item, freq, null, setGroupMenuEditor);
    else
        NRPutMenu(owner, tag(), item, freq, "", openAttributeEditor);
}

function removedMenu(answer){
    var obj = JSON.parse(answer);
    //alert("removedMenu->"+encodeObject(obj)); //##
    
    // メニューを再生成
    var menus = new Array();
    for (num in obj){
        var rec = obj[num];
        menus.push(rec.menu);
    }
    
    // ポップアップ・メニューを再描画
    var sp = document.getElementById("menuItemArea");
    sp.innerHTML = "";
    var pu = makePopupMenu(sp, "menuItem", menus, "");
    pu.setAttribute("onchange", "showMenuFreq()");
    showMenuFreq();
    
    // CellEditor も再描画
    noa().setEditorId(null);
    noa().openEditor(noa().currentDate(), tag());
}
function removeMenu(label){
    // メニューが削除されるとリアルタイムにサーバを更新
    var type = document.getElementById("menuType").value;
    if (indexOfArray(menuTypes(), type) == _group_){
        removeGroupMenu();
        return;
    }
    
    if (! label){
        var aTag = tag();
        var item = document.getElementById("menuItem").value;
    } else if (label == "都道府県"){
        var aTag = label;
        var item = document.getElementById(label).value;
    } else if (label == "市区"){
        var aTag = document.getElementById("都道府県").value;
        var item = selectedMenuItem();
    } else if (label == "町村"){
        var aTag = document.getElementById("cityPop").value;
        var item = selectedMenuItem();
    }
    
    if (confirm(item + " を削除しますか")) {
        NRRemoveMenu(noa().owner(), aTag, item, removedMenu);
    }
}

function removedGroupMenu(answer){
//    alert(answer); //##
    // CellEditor も再描画
    noa().setEditorId(null);
    noa().openEditor(noa().currentDate(), tag());
}
function removeGroupMenu(){
    // GROUP MENU 項目を削除
    var item = document.getElementById("menuItem").value;
    if (confirm(item + " を削除しますか")) {
        // ３番目の引数 freq が "-1" なら削除になる
        NRPutGroupMenu(noa().owner(), item, "-1", null, removedGroupMenu);
    }
}

/// neuron.js による処理 /////////
////////////////////////////////


function help(){
	// ヘルプパネルを表示
    window.open("./cellPrefHelp.html","Help"
                ,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function showInfo(){
    // CELL 属性の IN/OUT 対照表を表示
	var elm = document.getElementById("_debug");
	if (elm.innerHTML.length > 0){
		elm.innerHTML = "";
	} else {
        elm.innerHTML = "";
        var tbl = newTABLE(elm, "base-table");
        tbl.style.fontSize = "9pt";
        tbl.style.color = "#00f";
        
        // TITLE
        var tr = newTR(tbl, "", "")
        var td = newTD(tr, "", "属性");
        var td = newTD(tr, "", "サーバ値");
        var td = newTD(tr, "", "エディター値");
        
        // LIST 
        var inObj = noa().fieldForTag(tag());
        var outObj = editorObject();
        
        //alert("outObj: "+encodeObject(outObj)); //##
        
        for (key in inObj){
            var tr = newTR(tbl, "", "")
            var td = newTD(tr, "", key);
            var td = newTD(tr, "", inObj[key]);
            var td = newTD(tr, "", outObj[key]);
        }
        
        // GROUP MENU 属性の表示
        if (outObj.groupMenu){
            var tr = newTR(tbl, "", "")
            var td = newTD(tr, "", "--- グループメニュー ---");
            td.setAttribute("colspan", "3");
            
            // TITLE
            var tr = newTR(tbl, "", "")
            var td = newTD(tr, "", "属性");
            var td = newTD(tr, "", "サーバ値");
            var td = newTD(tr, "", "エディター値");
            
            var gobj = outObj.groupMenu;
            var item = document.getElementById("menuItem").value;
            for (tag in gobj){
                var tr = newTR(tbl, "", "")
                var td = newTD(tr, "", tag);
                var td = newTD(tr, "", oldSubMenu(item, tag));
                var td = newTD(tr, "", gobj[tag]);
            }
        }
        var pos = getPosition(td);
        window.scroll(0, pos.y);
	}
    
    function oldSubMenu(title, tag){
        // title に付随するグループメニュー・アイテムを返す
        for (num in _menuArray){
            var rec = _menuArray[num];
            if (rec.menu == title){
                return rec[tag];
            }
        }
        return "";
    }
}

function showMenuFreq(){
    // メニュー項目が変更されたらその頻度を表示
	var item = document.getElementById("menuItem").value;
	document.getElementById("freqF").value = freqForItem(item);
    
    // グループ編集パネルが開いていたら閉じる
	var elm = document.getElementById("groupEditorArea");
    if (elm) elm.innerHTML = "";
}

function setSampleColor(){
    // 設定された文字色と背景色を表示
    var elm = document.getElementById("tagArea");
    // 文字色
    var code = colorOf('color');
    elm.style.color = (code) ? code : "#000";
    
    // 背景色
    var code = colorOf('bgcolor');
    elm.style.backgroundColor = (code) ? code : "#fff";
    
    function colorOf(type){
        // CELL 文字色の設定値を返す
        var id = (type == 'color') ? 'colorBox' : 'bgcolorBox';
        var elm = document.getElementById(id);
        
        if (elm && elm.checked){
            // colorBox は生成されていても bgcolorBox は生成前のことがある
            var red = document.getElementById(type+".R").value;
            var green = document.getElementById(type+".G").value;
            var blue = document.getElementById(type+".B").value;
            var color = "#" + red + green + blue;
            
            return (color.length == 4) ? color : null;
        } else
            return null;
    }
}

function showColorPop(elm, type, color){
    // 三原色を設定するポップアップ・メニューを生成
    var colors = ["","0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F"];
    var red = "";
    var green = "";
    var blue = "";
    if (color){
        red = color.substr(1,1);
        green = color.substr(2,1);
        blue = color.substr(3,1);
    }
    elm.innerHTML = "";
    var pu = makePopupMenu(elm, type+".R", colors, red);
    pu.setAttribute("onchange", "setSampleColor()");
    var pu = makePopupMenu(elm, type+".G", colors, green);
    pu.setAttribute("onchange", "setSampleColor()");
    var pu = makePopupMenu(elm, type+".B", colors, blue);
    pu.setAttribute("onchange", "setSampleColor()");
}

function checkedColorBox(elm, color){
    // 着色チェックボックスが変更された
    var sp = document.getElementById("colorPopArea");
    if (elm.checked) 
        showColorPop(sp, 'color', color);
    else 
        sp.innerHTML = "";
    setSampleColor();
}
function checkedBGColorBox(elm, color){
    // 着色チェックボックスが変更された
    var sp = document.getElementById("bgcolorPopArea");
    if (elm.checked) 
        showColorPop(sp, 'bgcolor', color);
    else 
        sp.innerHTML = "";
    setSampleColor();
}

function changedMenuType(){
    // メニュー形式が変更された：グループメニューなら専用エディターを表示
    var type = document.getElementById("menuType").value;
    var elm = document.getElementById("groupEditorButtonArea");
    
    if (!elm){
        return;
    } else if (indexOfArray(menuTypes(), type) == _group_){ // lib.js
        // グループ・メニュー編集ボタンを生成
        elm.innerHTML = "";
        var td = newTD(elm, "", "");
        var td = newTD(elm, "", "");
        var bt = newBUTTON(td, "", "グループ・メニューを編集");
        bt.setAttribute("onclick", "openGroupMenuEditor()"); // groupMenuEditor.js
    } else {
        elm.innerHTML = "";
        // 頻度フィールド
        var td = newTD(elm, "", "");
        var td = newTD(elm, "", "");
        var fd = newFIELD(td, "freqF", "頻度", 3, "");
        fd.setAttribute("onchange", "freqAreChanged(this)");
        showMenuFreq();
    }
}

function editorSelected(elm){
    // Editor 種類のポップアップ・メニューが選択された
    document.getElementById("editorF").value = editorForName(elm.value);
}

var _menuArray;
function closeAttributeEditor(){
	// EDITOR TOOL 全体を閉じ PanelEditor を開く
    noa().doOpenBasicEditor();
}
function freqForItem(menuItem){
    // item に対する頻度を返す
    for (num in _menuArray){
        var obj = _menuArray[num];
        if (obj.menu == menuItem) return obj.freq;
    }
    return "";
}
function openAttributeEditor(answer){
    // CELL 属性を表示
    _menuArray = JSON.parse(answer);
    // _menuArray=[{"menu":"下腹痛","value":"","public":"","freq":"55"},,,]
    // _menuArray は freq で降順ソートされている
    var menus = new Array();
    for (num in _menuArray){
        var rec = _menuArray[num];
        if (rec.menu.length)
            menus.push(rec.menu);
    }

    var elm = document.getElementById("bodyArea");
    elm.innerHTML = "";
    
	var tbl = newTABLE(elm, "base-table");
    tbl.style.backgroundColor = "#ffa";
    tbl.style.fontSize = "10pt";
    
    var obj = noa().fieldForTag(tag()); // フィールド属性を知るオブジェクト
    //alert(tag()+" openAttributeEditor->"+encodeObject(obj)); //##
    
    makeLine(tbl, "ラベル名", obj);
    makeLine(tbl, "tag", tag());
    
    makeSUbTitle(tbl, "メニューの設定");
    makeLine(tbl, "形式", obj);
    makeLine(tbl, "メニュー項目", menus);
    
    // Group Menu EDitor 表示エリア
    var tr = newTR(tbl, "groupEditorButtonArea", "");
    var tr = newTR(tbl, "groupEditorArea", "");
    tr.style.border = "thin solid #aaa";
    tr.style.backgroundColor = "#fe5";
    changedMenuType();
    
    makeLine(tbl, "頻度学習", obj);
    makeLine(tbl, "メニュー選択", obj);
    makeLine(tbl, "挿入位置", obj);
    
    makeSUbTitle(tbl, "入力欄の設定");
    makeLine(tbl, "入力欄", obj);
    makeLine(tbl, "Font Size", obj);
    makeLine(tbl, "Font Family", obj);
    makeLine(tbl, "書込み", obj); // super user がレイアウト設定で行うが、ここに表示はする
    makeLine(tbl, "文字色", obj);
    makeLine(tbl, "背景色", obj);
    
    makeSUbTitle(tbl, "専用エディターの設定");
    makeLine(tbl, "Editor", obj);
    makeLine(tbl, "Script", obj);
    
    makeSUbTitle(tbl, "その他の属性");
    makeLine(tbl, "id", obj);
    makeLine(tbl, "numbering", obj);
    makeLine(tbl, "hitAndRun", obj);

    function makeLine(tbl, label, obj){
        // 一行分のラベル・バリューを生成
        var tr = newTR(tbl, "", "");
        var td = newTD(tr, "", label);
        td.style.width = "110px";
        td.style.paddingLeft = "5px";
        td.style.verticalAlign = "top";
        
        var td = newTD(tr, "", "");
        if (label == "ラベル名"){
            var fd = newFIELD(td, "labelF", "", 20, obj.label);
        } else if (label == "tag"){
            var sp = newSPAN(td, "tagArea");
            sp.innerHTML = obj;
        } else if (label == "形式"){
            var types = menuTypes(); // lib.js
            var mtype = 0;
            if (obj.menuType && (obj.menuType * 1 < types.length)){
                mtype = obj.menuType * 1;
            }
            var pu = makePopupMenu(td, "menuType", types, types[mtype]);
            pu.setAttribute("onchange", "changedMenuType()");
            var sp = newSPAN(td, "");
            sp.innerHTML = " タイプ";
        } else if (label == "メニュー項目"){
            var sp = newSPAN(td, "menuItemArea");
            var pu = makePopupMenu(sp, "menuItem", obj, "");
            pu.setAttribute("onchange", "showMenuFreq()");
            
            // 削除アイコン
            var sp = newSPAN(td, "removeMenuTip");
            sp.style.paddingLeft = "5px";
            sp.setAttribute("onclick", "removeMenu()");
            var img = newIMAGE(sp, "", "./remove-field.png", "X");
            img.style.verticalAlign = "middle";
            img.style.height = "12px";
            setInfoTip("removeMenuTip", "選択されたメニュー項目を削除"); // HELP
            
            // 頻度フィールドかグループ・メニュー編集ボタンを表示
            changedMenuType();
        } else if (label == "頻度学習"){
            var status = (obj.study * 1) ? 1 : 0;
            var cb = newCHECKBOX(td, "study", "頻度学習をする", status);
        } else if (label == "メニュー選択"){
            var status = (obj.buttonType * 1) ? 1 : 0; // monoSelection
            var cb = newCHECKBOX(td, "monoSelection", "１回のみ選択", status);
        } else if (label == "挿入位置"){
            var items = menuPositions(); // lib.js
            var item = items[obj.menuAction]
            makePopupMenu(td, "menuAction", items, item);
        } else if (label == "入力欄"){
            var types = fieldTypes(); // lib.js
            var ftype = (obj.fieldType && (obj.fieldType * 1 > 0)) ? 1 : 0;
            var pu = makePopupMenu(td, "fieldType", types, types[ftype]);
            var tx = newTEXT(td, " タイプ");
        } else if (label == "Font Size"){
            var font = (obj.fontSize) ? obj.fontSize : "";
            var ip = newFIELD(td, "fontSizeF", "", 3, font);
            var tx = newTEXT(td, " pt");
        } else if (label == "Font Family"){
            var fsize = (obj.fontFamily * 1) ? obj.fontFamily : "";
            var ip = newFIELD(td, "fontFamilyF", "", 20, fsize);
        } else if (label == "書込み"){
            var status = (obj.disabled && (obj.disabled * 1 > 0)) ? 1 : 0;
            var cb = newCHECKBOX(td, "disabled", "不可", status);
            // 以下は上の disabled とは別でチェックボックスを操作できないようにする
            // 書込み不可はレイアウト設定で super user のみが実行できる
            // しかしサーバへの書き戻しでこの項目の status が必要なので一応ここに記憶しておく
            cb.setAttribute("disabled");
        } else if (label == "文字色"){
            var status = (obj.color && obj.color.length) ? 1 : 0;
            var cb = newCHECKBOX(td, "colorBox", "着色", status);
            cb.setAttribute("onchange", "checkedColorBox(this,'"+obj.color+"')");
            var sp = newSPAN(td, "colorPopArea");
            if (status) {
                showColorPop(sp, 'color', obj.color);
                setSampleColor();
            }
        } else if (label == "背景色"){
            var status = (obj.bgcolor && obj.bgcolor.length) ? 1 : 0;
            var cb = newCHECKBOX(td, "bgcolorBox", "着色", status);
            cb.setAttribute("onchange", "checkedBGColorBox(this,'"+obj.bgcolor+"')");
            var sp = newSPAN(td, "bgcolorPopArea");
            if (status) {
                showColorPop(sp, 'bgcolor', obj.bgcolor);
                setSampleColor();
            }
        } else if (label == "Editor"){
            var editor = (obj.editor) ? obj.editor : "";
            var title = nameForEditor(editor);
            var pu = makePopupMenu(td, "", editorNames(), title);
            pu.setAttribute("onchange", "editorSelected(this)");
            var fd = newFIELD(td, "editorF", "", 20, editor);
        } else if (label == "Script"){
            var sp = newSPAN(td, "scriptArea");
            sp.innerHTML = obj.script;
        } else if (label == "id"){
            var sp = newSPAN(td, "idArea");
            sp.innerHTML = obj.id;
        } else if (label == "numbering"){
            var sp = newSPAN(td, "numberingArea");
            sp.innerHTML = obj.numbering;
        } else if (label == "hitAndRun"){
            var sp = newSPAN(td, "hitAndRunArea");
            sp.innerHTML = obj.hitAndRun;
        }
    }
    
    function makeSUbTitle(tbl, label){
        // サブタイトルを生成
        var tr = newTR(tbl, "yellow-bar", "");
        var td = newTD(tr, "", label);
        td.setAttribute("colspan", "2");
        td.style.textAlign = "center";
    }
}

function initCellPreference(){
    // CELL の初期設定ツールを開く
    var base = window.top.tools.document.getElementById("base");
	base.innerHTML = "";

    // === HEADER ===========================
    var div = newDIV(base, "yellow-bar");
    // -- LEFT SIDE --
    var dv = newDIV(div, "/left-side");
	var im = newIMAGE(dv, "icon", "./close.png", "?");
    im.style.height = "12px";
	im.setAttribute("onclick", "closeAttributeEditor()");
	var sp = newSPAN(dv, "");
    sp.style.paddingLeft = "5px";
    sp.innerHTML = "CELL 属性編集パネル";
    // -- RIGHT SIDE --
    var dv = newDIV(div, "/right-side2");
	var im = newIMAGE(dv, "", "./Help.png", "?");
	im.setAttribute("onclick", "help()");
	im.style.height = "18px";
	im.style.verticalAlign = "bottom";
    
	// body
    var div = newDIV(base, "bodyArea");

    // === FOOTER ===========================
    var div = newDIV(base, "yellow-bar");
    // -- LEFT SIDE --
    var dv = newDIV(div, "/left-side");
    dv.innerHTML = cp_version();
    // -- RIGHT SIDE --
    var dv = newDIV(div, "/right-side2");
	var bt = newDIV(dv, "/whiteButton");
    bt.innerHTML = "確定";
    bt.setAttribute("onclick", "saveCellEditor()");
    
    NRGetMenu(noa().owner(), tag(), openAttributeEditor);
}

function cp_version(){
    return "Ver.120908";
}