<?php

    function decodeSTRING($val){
        // #, &, +  < > などが URI 送信で化けるため encode して送られたものを decode
        $array = explode("%x0;", $val);
        $val = implode("#", $array);
        $array = explode("%x1;", $val);
        $val = implode("&", $array);
        $array = explode("%x2;", $val);
        $val = implode("+", $array);
        $array = explode("%x3;", $val);
        $val = implode("<", $array);
        $array = explode("%x4;", $val);
        $val = implode(">", $array);
        $array = explode("%x5;", $val);
        $val = implode(" ", $array);
        $array = explode("%x6;", $val);
        $val = implode("\n", $array);
        $array = explode("%x7;", $val);
        $val = implode("\"", $array);
        $array = explode("%x8;", $val);
        $val = implode("$", $array);
        $array = explode("%x9;", $val);
        $val = implode("\'", $array);
        return $val;
    }
    
    function leftBrackets(){
        // $leftBrackets = "\^\[\^" では誤作動
        //	return "\^\[\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        return "^[^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function rightBrackets(){
        return "^]^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        //	return "\^\]\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function decodeObject($buff){
        // "key(value)" 形式の文字列を OBJECT に decode して返す
        $obj = array();
        //	echo "decodeObject ===\n$buff\n"; //##
        for ($p=$begin=$nest=0, $len=strlen($buff); $p < $len; $p++){
            $ch = substr($buff, $p, 1);
            if (strcmp($ch, "(") == 0){
                if ($nest == 0){
                    $key = trim(substr($buff, $begin, $p - $begin)); // key 終端
                    $begin = $p + 1; // value 開始位置
                }
                $nest++;
            } else if (strcmp($ch, ")") == 0){
                if (--$nest == 0){
                    if ($nest == 0){
                        // value 終端 ( trim しない )
                        $value = substr($buff,$begin,$p-$begin);
                        $begin = $p + 1; // key 開始位置
                    }
                    if (ereg(")", $value)){ // まだ入れ子になっているなら
                        $obj[$key] = decodeObject($value);
                    } else {
                        // 特定文字を "(", ")" へ戻す
                        $array = explode(leftBrackets(), $value);
                        $value = join("(", $array);
                        $array = explode(rightBrackets(), $value);
                        $value = join(")", $array);
                        
                        $obj[$key] = $value;
                    }
                    //echo "$key{".$obj[$key]."}\n"; //##
                }
            }
        }
        return $obj;
    }
    
    function dirForOwnerAndFolder($owner, $folder){
        // $dir が無ければ作成
        $dir = "../Users"; // /NOA の場合
        if (! file_exists($dir)){
            // $dir が無ければ作成
            echo "($dir) is not exist, so I'll make directory. \n"; //##
            mkdir($dir);
        }
        $dir = "$dir/$owner";
        if (! file_exists($dir)){
            // $dir が無ければ作成
            echo "($dir) is not exist, so I'll make directory. \n"; //##
            mkdir($dir);
        }
        $dir = "$dir/$folder";
        if (! file_exists($dir)){
            // $dir が無ければ作成
            echo "($dir) is not exist, so I'll make directory. \n"; //##
            mkdir($dir);
        }
        
        return $dir;
    }
    
    function putArvhiveFile($owner, $folder, $array){
        $dir = dirForOwnerAndFolder($owner, $folder);
        $timestamp = date("YmdHi",time());
        $filename = "$dir/$timestamp.txt";
        $json = json_encode($array); // JSON に変換
        
        echo "<SEPARATOR>";
        if (!$handle = fopen($filename, 'w')) {
            // $filenameを書き出しモードでオープン
            echo "ERROR: Cannot open file ($filename)";
        } else {
            if (fwrite($handle, $json) === FALSE) {
                // オープンしたファイルに$buffを書き込む
                echo "ERROR: Cannot write to file ($filename)";
            } else {
                echo "ツール・メニュー構造を ($filename) に保存しました";
                fclose($handle);
            }
        }
    }
    
 
    
    /* ########################################
     ### 以下でも $_POST['key'] と同じに機能する ###
     if (isset($_REQUEST['key'])) {
         $key = $_REQUEST['key'];
     }
     ########################################## */
    
    $command = $_POST['command'];
    $owner = $_POST['owner'];
    $folder = $_POST['folder'];
    $value = $_POST['value'];

    $value = decodeSTRING($value);
    
    // DB を開いて該当レコードを読み込む
    // ### セキュリティーを保つには、以下のファイルを外からアクセスできない
    // ### directory に置き、以下の cfg.php の pass をそこへ変更
    require_once('cfg.php');
    
    $dbc = mysql_connect($db['host'], $db['user'], $db['pwd']);
    $db_select=mysql_select_db($db['dbname']);
    mysql_query("set names utf8");
    
    
    if (strcmp($command,"PUT_ARCHIVE_FILE") == 0){
        $array = decodeObject($value);
        putArvhiveFile($owner, $folder, $array);
    } else if (strcmp($command,"PUT_TOOL_MENU") == 0){
        // TOOL_MENU の配列を POST 型式で受け取りサーバへ保存
        $tag = "TOOL_MENU";
        $menuArray = decodeObject($value);
        
		foreach($menuArray as $num=>$rec){
            $id = $rec['id'];
            $menuType = $rec['menuType']; // _progress, _basic, _insurance
            $label = $rec['label'];
            $url = $rec['url']; $url = decodeSTRING($url);
            $win = $rec['window'];
            $fix = $rec['fix'];
            $sub = $rec['subTitle'];
            $dis = $rec['disabled'];
            $icon = $rec['icon'];
            $editor = $rec['editor']; // infoTip
            $number = $rec['number'];
            
            $sql = "SELECT * FROM `FieldTable` WHERE `tag`='$tag' AND `id`='$id' AND `owner`='$owner'";
            //echo "----- $sql \n"; //##
            $result=mysql_query($sql);
            
            if ($row=mysql_fetch_array($result)){
                $rowid = $row['rowid'];
                $sql = "UPDATE `FieldTable` SET `buttonType`='$win',`menuType`='$menuType',`menuAction`='$fix',`fieldType`='$sub',`disabled`='$dis',`editor`='$editor',`script`='$url',`label`='$label',`numbering`='$number',`fontFamily`='$icon' WHERE `rowid`='$rowid'";
            } else {
                // numbering はメニューの表示順を決めるので重複しないこと
                // 通常はクラインと側で numbering を調整して送ってくる
                $sql = "INSERT INTO `FieldTable` (`owner`,`tag`,`buttonType`,`menuType`,`menuAction`,`fieldType`,`disabled`,`editor`,`id`,`script`,`label`,`numbering`,`fontFamily`) VALUES ('$owner','$tag','$win','$menuType','$fix','$sub','$dis','$editor','$id','$url','$label','$number','$icon')";
            }
            echo "----- $sql \n"; //##
            $result=mysql_query($sql);
            
		}
        
        // ====== バックアップ・ファイルを保存 ========
        putArvhiveFile($owner, "TOOL_MENU", $menuArray);
        
        echo "<SEPARATOR>";
        echo "メニュー構造を保存しました";
    } else if (strcmp($command,"PUT_LAYOUT") == 0){
        // LAYOUT 属性を FieldTable へ保存
        $recs = decodeObject($value);
        $direction = "CELL";
        $freq = 0; // 自動 numbering する
        
		foreach($recs as $num=>$rec){
            // $owner は $recs に含まれず $_POST['owner'] から取得
            $tag = $rec['tag'];
            $buttonType = $rec['buttonType'];
            $menuType = $rec['menuType'];
            $menuAction = $rec['menuAction'];
            $hitAndRun = $rec['hitAndRun'];
            $fieldType = $rec['fieldType'];
            $direction = 'CELL'; // 第８世代 NOA 用識別子
            $disabled = $rec['disabled'];
            $editor = $rec['editor'];
            $id = $rec['id']; // 数値だと、第７世代 NOA の CELL_ID とカブる
            $script = $rec['script'];
            $bgcolor = $rec['bgcolor'];
            $label = $rec['label'];
            // numbering = $freq++;
            $study = $rec['study'];
            $fontSize = $rec['fontSize'];
            $fontFamily = $rec['fontFamily'];
            $color = $rec['color'];

            $sql = "SELECT * FROM `FieldTable` WHERE `owner`='$owner' AND `direction`='CELL' AND `tag`='$tag'";
            //echo "----- $sql \n"; //##

            echo "=== $num $label === \n"; //##

            $result=mysql_query($sql);
            if ($row=mysql_fetch_array($result)){
                $rowid = $row['rowid'];
                $sql = "UPDATE `FieldTable` SET `buttonType`='$buttonType',`menuType`='$menuType',`menuAction`='$menuAction',`hitAndRun`='$hitAndRun',`fieldType`='$fieldType',`disabled`='$disabled',`editor`='$editor',`id`='$id',`script`='$script',`bgcolor`='$bgcolor',`label`='$label',`numbering`='$freq',`study`='$study',`fontSize`='$fontSize',`fontFamily`='$fontFamily',`color`='$color' WHERE `rowid`='$rowid'";
            } else {
                $sql = "INSERT INTO `FieldTable` (`owner`,`tag`,`buttonType`,`menuType`,`menuAction`,`hitAndRun`,`fieldType`,`direction`,`disabled`,`editor`,`id`,`script`,`bgcolor`,`label`,`numbering`,`study`,`fontSize`,`fontFamily`,`color`) VALUES ('$owner','$tag','$buttonType','$menuType','$menuAction','$hitAndRun','$fieldType','$direction','$disabled','$editor','$id','$script','$bgcolor','$label','$freq','$study','$fontSize','$fontFamily','$color')";
            }
            echo "----- $sql \n"; //##
            $result=mysql_query($sql);
            $freq += 1;
		}
        
        echo "<SEPARATOR>";
        echo "ラベル順序を保存しました";
    } else {
        echo "<p>( $command ) is wrong command *****</p>";
    }
    
?>