
/////////////////////////////////////////////
///// NOA からの継承値 /////////////////////////

// NOA 組込みの場合は patientId() などを直接取得できるが
// 外付けツールにも出来るようあえて以下の仕組みを使う
function _noa(){
	// window.opener が NOA なら NOA を、そうでないなら null を返す
    if (window.opener && (window.opener.name == "noa")){
        return window.opener;
    } else if (window.opener && (window.opener.name == "tools")){
        return window.top.noa;
    } else if (window.top && (window.top.noa)){
        return window.top.noa;
    } else {
        //alert("親として NOA が見つかりません");
        return null;
    }
}

///// NOA からの継承値 /////////////////////////
//////////////////////////////////////////////


var _patientInfo;
function setPatientInfo(obj){
    _debug("setPatientInfo->"+encodeObject(obj)); //##
    
    _patientInfo = obj;
}
function patientInfo(pid){
    for (num in _patientInfo){
        var obj = _patientInfo[num];

        if (obj.patientId == pid){
            return obj;
        }
    }
    return null;
}

var _patientId;
function setPatientId(pid){
    _patientId = pid;
}
function patientId(){
    if (!_patientId){
        var pid = document.getElementById("_pid").value;
        if (pid && pid.length){
            // URL に添えてパラメータが送られた：FRONT から使われる
            _patientId = pid;
            document.getElementById("keyF").value = _patientId;
        } else {
            // NOA の patientId() を使う
            _patientId = (_noa().noaType() == "NOA8G")
                ? _noa().patient_id() : _noa().patientId();
        }
    }

    return _patientId;
}

var _imageObj;
function setImageObj(obj){
    // obj.files から "_" で始まるファイル名を除去
    // "_" で始まるファイル名は削除されたファイルを表す
    var files = obj.files;
    var array = new Array();
    for (num in files){
        var filename = files[num];
        if (filename.charAt(0) != "_")
            array.push(filename);
    }
    obj.files = array;
    _imageObj = obj;
    
    _debug("_imageObj->"+encodeObject(_imageObj)); //##
}
function imagePath(){
    return _imageObj.path;
}
function imageList(){
    return _imageObj.files;
}

var _tagetDate;
function setTargetDate(date){
    // 対象年月を受け取る
    _tagetDate = date;
}
function targetDate(){
    // 検索対象年月日を返す
    return _tagetDate;
}

var _image;
function setImage(img){
    _image = img;
}
function image(){
    return _image;
}

var _imageName;
function setImageName(name){
    _imageName = name;
}
function imageName(){
    return _imageName;
}

function isSafari(){
    // Safari かどうかを検証
    if (navigator.userAgent.indexOf("Safari") >= 0){
        if (navigator.userAgent.indexOf("Chrome") < 0){
            return true;
        }
    }
    return false;
}

function amplified(){
    // 拡大モードなら true を返す
    return document.getElementById("amplifyBox").checked;
}

///////////////////////////////////
/// localStorage による処理 /////////

function putWindowSize(){
	// DocMaker のウインドー位置とサイズを localStorage へ記憶
    var array = new Array();
	array.push(window.screenLeft); // x
	array.push(window.screenTop - 22); // y
	array.push(window.outerWidth); // w
	array.push(window.outerHeight); // h
    window.localStorage["InsViewerWindowSize"] = array.join(",");
    
    showFadeoutInfo("messageArea", "window のサイズと位置を記憶しました", 800);
}
function getWindowSize(){
	// DocMaker のウインドー位置とサイズを localStorage から取り出す
    var windowStatus = window.localStorage["InsViewerWindowSize"];
    if (windowStatus){
        var array = windowStatus.split(",");
        var x = array[0];
        var y = array[1];
        var w = array[2];
        var h = array[3];
		// resize を先にしておかないと元が大きいサイズだった場合 moveTo しよう
		// としてもウインドー境界の制限で移動できない場合がある
		window.resizeTo(w, h);
		window.moveTo(x, y);
    }
}

function putClipSize(){
	// DocMaker のウインドー位置とサイズを localStorage へ記憶
    var status = document.getElementById("expandBox").checked;
    window.localStorage["InsViewerClipSize"] = (status) ? "1" : "0";
    
    showFadeoutInfo("messageArea", "clipのサイズと位置を記憶しました", 800);
}
function getClipSize(){
	// DocMaker のウインドー位置とサイズを localStorage から取り出す
    var status = window.localStorage["InsViewerClipSize"];
    if (status * 1 > 0){ // A4サイズ
        setClipHeight(1500);
    }
}

function setInsViewerScale(val){
    // 縮小率の scale を localStorage へ記憶
    window.localStorage["insViewerScale"] = val;
}
function insViewerScale(){
    // 縮小率の scale を返す
    var val = window.localStorage["insViewerScale"];
    return (val) ? val * 1 : 1;
}

/// localStorage による処理 /////////
///////////////////////////////////

//////////////////////////////////////////////////////////
///// PREFERENCE /////////////////////////////////////////

function setDefaultScale(){
    var elm = document.getElementById("scaleF");
    var scale = elm.value;
    if (isDigit(scale))
        setInsViewerScale(scale);
    else {
        alert("数値を入力してください");
        elm.focus();
    }
}
function preference(){
    // 初期設定を表示
    var elm = document.getElementById("preferenceArea");
    if (elm.innerHTML.length > 0){
        elm.innerHTML = "";
        return;
    }
    
    elm.innerHTML = "";
    var sp = newSPAN(elm, "");
    sp.style.padding = "5px 5px";
    var val = insViewerScale();
    var fd = newFIELD(sp, "scaleF", "サイズ規定値", 5, val);
    fd.focus();
    var bt = newBUTTON(elm, "", "確定");
    bt.setAttribute("onclick", "setDefaultScale()");
}

///// PREFERENCE /////////////////////////////////////////
//////////////////////////////////////////////////////////


////////////////////////////////
/// neuron.js による処理 /////////

function gotPatientList(answer){
    //alert("gotPatientList->"+answer); //##
    
	var obj = JSON.parse(answer);
    if (obj){
        setPatientInfo(obj);
        showIdList(obj);
    }
}
function getPatientList(searchKey){
	// 検索キーにマッチしたカルテのリストを表示
	var elm = document.getElementById("dropArea");
    elm.style.display = "block"; // 表示する

	NRGetPatients(searchKey, gotPatientList);
}

function gotInsurance(answer){
    //alert("gotInsurance->"+answer); //##
	var obj = JSON.parse(answer);
    
    if (obj) showInsurance(obj);
}
function getInsurance(patientId, dateTime){
	// 保険証データをサーバから取得し表示
    // 最初の owner パラメータ省略しても PostIt データに影響するだけでここでは関係ない
    //alert("getInsurance->"+patientId+" date->"+dateTime); //##

    var owner = "";
	NRGetPage(owner, patientId, dateTime, "", tags(), gotInsurance);
	
	function tags(){
		// 保険証のDBタグをカンマ区切りの配列にして返す
		var array = new Array();
		array.push("HealthInsurance.shubetsu");
		array.push("HealthInsurance.kubun");
		array.push("HealthInsurance.paymentRatio");
		array.push("HealthInsurance.discountRatio");
		array.push("HealthInsurance.kigou");
		array.push("HealthInsurance.bangou");
		array.push("HealthInsurance.ownerNumber");
		array.push("HealthInsurance.ownerName");
		array.push("HealthInsurance.ownerPhone");
		array.push("HealthInsurance.confirmation");
		array.push("HealthInsurance.startDate");
		array.push("HealthInsurance.expiredDate");
		array.push("PublicInsurance.shubetsu");
		array.push("PublicInsurance.ownerName");
		array.push("PublicInsurance.ownerNumber");
		array.push("PublicInsurance.recipientNumber");
		array.push("PublicInsurance.paymentRatio");
		array.push("PublicInsurance.payment");
		array.push("PublicInsurance.startDate");
		array.push("PublicInsurance.expiredDate");
		return array.join(",");
	}
}

function gotFiles(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("gotFiles ===\n"+value);//##
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            var obj = JSON.parse(array[1]);
            if (obj){
                //alert(encodeObject(obj)); // JSON
                setImageObj(obj);
                showImageList();
            }
		}
		hideMessage("_message");
	} else 
		showMessage("_message", "サーバで処理中です ... ");
}
function getFiles(patientId){
    // patientId の保険証画像のリストをリクエスト
    setPatientId(patientId);
    
    _debug("getFiles->"+patientId); //##

	xmlHttpObject = createXMLHttpRequest(gotFiles);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		// サーバとの約束事
		var array = new Array();
		array["patientId"] = patientId;
		
		var st = "./server.php?command=GET_DIRECTORY"
		+ "&value=" + encodeObject(array);
		//alert(st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function savedData(){
    // データ保存後、画像一覧を表示
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("savedData ===\n"+value);//##
        
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            closeControlArea();
            
            // ポップアップ更新とともに再読込
            getFiles(patientId());
            
            // 画像がうまく現れない事があるので一定時間後に再描画
            //setTimeout( "redraw()", 5000 );

            // これを行うと画像が現れないことがある
            //showFadeoutInfo("messageArea", array[1], 800);
		}
	} 
}
function saveData(filename){
    // 画像をサーバへ名前をつけて保存：保険証アップロード
    if (! patientId()){
        alert("カルテが特定されていません。対象カルテを検索し氏名などを確認してから画像を取り込んでください");
        return;
    }
    
    //alert("saveData->"+filename); //##
    
	xmlHttpObject = createXMLHttpRequest(savedData);
	if (xmlHttpObject){
        // encodeURI は '&' をエンコードしてくれないのでこちら側でエンコード
        var can = canvas();
        var ctx = can.getContext("2d");
        var imgData = ctx.getImageData(0,0,clipWidth(),clipHeight());
        
        // クリッピングした画像を一時置きする canvas を生成
        var elm = document.getElementById("_tmp");
        elm.innerHTML = "";
        var tmpCan = newCANVAS(elm,"",clipWidth(),clipHeight(),null);
        var ctx2 = tmpCan.getContext("2d");
        ctx2.putImageData(imgData, 0, 0);
        
        var imageSrc = tmpCan.toDataURL();
        imageSrc = imageSrc.replace('data:image/png;base64,',''); // 頭の不要部分を削除

        var st = "command=PUT_IMAGE";
        st += "&patientId=" + patientId();
        st += "&filename=" + filename;
        st += "&value=" + encodeURI(encodeSTRING(imageSrc));

        xmlHttpObject.open("POST", "imageServer.php", true);         
        xmlHttpObject.setRequestHeader('Content-Type','application/x-www-form-urlencoded; charset=UTF-8');
		//alert("saveData ====\n"+st); //##
        xmlHttpObject.send(st);
	}
}

function removedImage(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
        
        showFadeoutInfo("messageArea", value, 800);

        // 画像を一旦消去し
        closeControlArea();
        clearDraw();
        // ポップアップ更新とともに再読込
        getFiles(patientId());
	} 
}
function removeImage(){
    // サーバ上の選択されたイメージに削除マークをつける
    var filename = document.getElementById("imgPop").value;
    if (! confirm(filename+" の画像を削除していいですか"))
        return;
    
	xmlHttpObject = createXMLHttpRequest(removedImage);
	if (xmlHttpObject){
        var st = "command=REMOVE_IMAGE";
        st += "&patientId=" + patientId();
        st += "&filename=" + filename;
        
        xmlHttpObject.open("POST", "imageServer.php", true);         
        xmlHttpObject.setRequestHeader('Content-Type','application/x-www-form-urlencoded; charset=UTF-8');
		//alert("removeImage ====\n"+st); //##
        xmlHttpObject.send(st);
	}
}

function foundMonthPatient(answer){
    //alert("foundMonthPatient->"+answer); //##
    
    var obj = JSON.parse(answer);
    //alert("->"+encodeObject(obj)); //##
    
    showMonthlyList(obj);
}
function findMonthPatient(){
    // 対象年月のカルテのリストをリクエスト
    var st = targetDate().substr(0, 8); // "2012-01-"
    var args = new Array();
    var fromDateTime = encodeSTRING(st + "01 00:00:00");
    var toDateTime = encodeSTRING(st + "31 23:59:59");

    NRGetVisitor(fromDateTime, toDateTime, foundMonthPatient);
}

/// neuron.js による処理 /////////
////////////////////////////////


function findPatient(){
    // 検索キーにより NOA データを検索
	var key = document.getElementById("keyF").value;
	if (key.length > 0)
		getPatientList(key);
}

var _path;
function showImage(popup){
    // 保険証イメージを表示
    var filename = imageList()[0];
    if (popup) filename = popup.value;
    var href = imagePath() + "/" + filename;

    var img = document.createElement("img");
    img.src = href;
    setImage(img);
    
    // redraw() による描画は showInsurance() で動作させること
    closeControlArea();
    
    if (popup){
        // popup に該当する日付の情報を開く 
        getInsurance(patientId(), dateTimeOf(filename));
    } else {
        getInsurance(patientId(), todayAndTime());
    }
    
    function dateTimeOf(filename){
        // 画像ファイル名から日付を解析して返す
        var year = filename.substr(9, 4);
        var month = filename.substr(13, 2);
        var day = filename.substr(15, 2);
        var hour = filename.substr(17, 2);
        var min = filename.substr(19, 2);
        var sec = filename.substr(21, 2);
        return year+"-"+month+"-"+day+" "+hour+":"+min+":"+sec;
    }
}

function showImageList(){
    // 保険証イメージのリストを表示
	var elm = document.getElementById("popupArea");
    elm.innerHTML = "";
    var sp = newSPAN(elm, "");
    sp.innerHTML = "保険証履歴";
    sp.style.padding = "0px 5px";
    
    // canvas の属性を初期値へ戻す
    initCanvasAttributes();
    
    var sp = newSPAN(elm, "");
    if (imageList() && imageList().length){
        var pu = makePopupMenu(sp, "imgPop", imageList(), "");
        pu.setAttribute("onchange", "showImage(this)");
        
        var bt = newBUTTON(sp, "", "削除");
        bt.setAttribute("onclick", "removeImage()");
        showImage(null);
    } else {
        clearDraw();
        var msg = patientId() + " の保険証の画像ファイルはありません";
        var color = "rgb(255,0,0)"; // red
        drawText(10, 20, msg, color);
        drawFrame();
        getInsurance(patientId(), todayAndTime());
    }
}

function showInsurance(obj){
    // 保険情報を表示
	var elm = document.getElementById("patientInfoArea");
    elm.innerHTML = "";

    // 患者情報
    var dv = newDIV(elm, "");
    dv.innerHTML = "";
    showData(dv, "ID", patientId());
    var info = patientInfo(patientId());
    showData(dv, "氏名", info.patientKanjiName, true);
    showData(dv, "最終受診日", info.lastVisitDate);
    showData(dv, "保険証確認", obj["HealthInsurance.confirmation"]);
    
    // NOA に記述された保険証情報
    var dv = newDIV(elm, "");
    dv.style.fontSize = "10pt";
    showData(dv, "種別", obj["HealthInsurance.shubetsu"]);
    showData(dv, "保険者番号", obj["HealthInsurance.ownerNumber"], true);
    showData(dv, "保険者名", obj["HealthInsurance.ownerName"]);
    //showData(dv, "保険者電話", obj["HealthInsurance.ownerPhone"]);
    showData(dv, "記号", obj["HealthInsurance.kigou"], true);
    showData(dv, "番号", obj["HealthInsurance.bangou"], true);
    showData(dv, "区分", obj["HealthInsurance.kubun"]);
    showData(dv, "負担割合", obj["HealthInsurance.paymentRatio"], true);
    //showData(dv, "交付日", obj["HealthInsurance.startDate"]);
    showData(dv, "有効期限", obj["HealthInsurance.expiredDate"]);
    
    var dv = newDIV(elm, "");
    dv.style.fontSize = "10pt";
    showData(dv, "公費名称", obj["PublicInsurance.ownerName"]);
    showData(dv, "負担番号", obj["PublicInsurance.ownerNumber"]);
    showData(dv, "受給番号", obj["PublicInsurance.recipientNumber"]);
    showData(dv, "負担割合", obj["PublicInsurance.paymentRatio"]);
    showData(dv, "負担額", obj["PublicInsurance.payment"]);
    //showData(dv, "交付日", obj["PublicInsurance.startDate"]);
    showData(dv, "有効期限", obj["PublicInsurance.expiredDate"]);
    
    var sp = newSPAN(dv, "");
    sp.style.padding = "0px 10px";
    var bt = newBUTTON(sp, "", "画像アップロード");
    bt.setAttribute("onclick", "showUploader()");
    
    // canvas へ描画
    if (imageList() && imageList().length){
        showSlider();
        redraw();
    }
    
    window.scroll(0,0);
    
        
    function showData(elm, label, val, bold){
        var div = newSPAN(elm, "");
        div.style.fontSize = "10pt";
        var sp = newSPAN(div, "");
        sp.style.padding = "0px 5px";
        sp.style.backgroundColor = "#bfb";
        sp.innerHTML = label;
        var sp = newSPAN(div, "");
        sp.innerHTML = pureValue(val);
        sp.style.paddingLeft = "2px";
        sp.style.paddingRight = "10px";
        if (bold){
            sp.style.fontSize = "12pt";
            sp.style.fontWeight = "bold";
            sp.style.color = "#f0d";
        }
    }
}

function showIdList(records){
    // 検索結果を表示
	var elm = document.getElementById("patientInfoArea");
    elm.innerHTML = "";
    
    _initDebug(false); //##
    
    clearDraw();
    
    if (records.length == 1){
        // 該当するものが１件のみの場合は次の処理へ直行
        var obj = records[0];
        getFiles(obj.patientId);
    } else {
        // 該当するものが複数の場合はリストから選択させる
        var tbl = newTABLE(elm, "baseTable");
        tbl.style.fontSize = "10pt";
        var tr = newTR(tbl, "titleBar", "");
        var td = newTD(tr, "center", "カルテ番号");
        var td = newTD(tr, "center", "氏名");
        var td = newTD(tr, "center", "最終受診日");
        
        var patientIdAndName;
        for (r in records){
            var rec = records[r];
            var kanji = (rec.patientKanjiName) ? rec.patientKanjiName : "";
            var lvd = (rec.lastVisitDate) ? rec.lastVisitDate : "";
            var tr = newTR(tbl, "record", "");
            var td = newTD(tr, "", rec.patientId);
            var action = "getFiles('" + rec.patientId + "')";
            td.setAttribute("onclick", action);
            setChangeColor(td, '#000', '#fff');
            var td = newTD(tr, "", kanji);
            var td = newTD(tr, "", lvd);
            if (! isVisitThisMonth(rec)) td.style.color = "#aaa";
        }
        var tr = newTR(tbl, "footer", "");
        var td = newTD(tr, "", "");
        var st = records.length + " 件みつかりました（グレー文字は対象月に未受診）";
        var td = newTD(tr, "footer", st);
        td.setAttribute("colspan", "2");
    }
    
    function isVisitThisMonth(rec){
        // 今月受診しているかどうかチェック
        var lvd = rec.lastVisitDate;
        if (!lvd) return false;
        return (lvd.substr(0, 7) >= targetDate().substr(0,7)) ? true : false;
    }
}

function showMonthlyList(records){
    // 検索結果を表示
	document.getElementById("popupArea").innerHTML = "";
	var elm = document.getElementById("dropArea");
    elm.style.display = "none"; // 表示しない

    clearDraw();
    closeSlider();
    hideFooter();
    
	var elm = document.getElementById("patientInfoArea");
    elm.innerHTML = "";

    // 該当するものが複数の場合はリストから選択させる
    var tbl = newTABLE(elm, "baseTable");
    tbl.style.fontSize = "10pt";
    var tr = newTR(tbl, "titleBar", "");
    var td = newTD(tr, "center", "カルテ番号");
    var td = newTD(tr, "center", "氏名");
    var td = newTD(tr, "center", "最終受診日");
    
    var patientIdAndName;
    var count = 0;
    for (pid in records){
        var rec = records[pid];
        
        var tr = newTR(tbl, "record", "");
        var td = newTD(tr, "", pid);
        var action = "getPatientList('" + pid + "')";
        td.setAttribute("onclick", action);
        setChangeColor(td, '#000', '#fff');
        var td = newTD(tr, "", rec.kanjiName);
        var td = newTD(tr, "", rec.entryDate);
        if (rec.hasInsImage * 1 == 0)
            td.style.color = "#aaa";
        count++;
    }
    
    var tr = newTR(tbl, "footer", "");
    var td = newTD(tr, "", "");
    var td = newTD(tr, "footer", count + " 件みつかりました");
    var td = newTD(tr, "", "（グレー文字は保険証の画像なし）");
}

function help(){
	window.open("./help.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function closeControlArea(){
    // 画像アップロード用エリアを閉じる
	document.getElementById("controlArea").innerHTML = "";
}
function showUploader(){
    // ファイルのアップロード用エリアを開く
	var elm = document.getElementById("controlArea");
    elm.innerHTML = "";
    
    // CLOSE ICON
    var dv = newDIV(elm, "");
    dv.style.paddingTop = "3px";
    dv.style.backgroundColor = "#ffc";
    var sp = newSPAN(dv, "");
    sp.style.padding = "3px 5px";
    var img = newIMAGE(sp, "", "./close.png", "close");
    img.setAttribute("onclick", "closeControlArea()");
    img.style.height = "12px";
    var sp = newSPAN(dv, "");
    sp.innerHTML = "Google Chrome の場合「アップロード」を使わず 画像イメージを下の枠内に drag & drop できます";
    sp.style.color = "#c30";
    sp.style.fontSize = "10pt";
    
    // FORM
    var dv = newDIV(elm, "");
    dv.style.backgroundColor = "#ffc";
    dv.style.paddingBottom = "3px";
	var fm = newFORM(dv, "uploadServer.php"); // submit で起動される URL
    fm.style.margin = 0;
    fm.style.padding = 0;

    // patientId 
	var fd = newFIELD(fm, "", "", "", patientId());
	fd.setAttribute("NAME", "patientId"); // form で送られるパラメータ
	fd.setAttribute("type", "hidden");

	// ファイル選択ボタン
	var dv = newDIV(fm, "file");
    dv.style.padding = "0px 5px";
	var ub = newUploadBUTTON(dv, "", "files[]");
    
	// ファイル・アップロード・ボタン
	var sb = newSubmitBUTTON(dv, "", "ファイルをアップロード");
}

var _scale = 1;
var _rotation = 0;
var _imageX = 0;
var _imageY = 0;
var _step = 5;
var _bigStep = 30;
function initCanvasAttributes(){
    // 初期値に戻す
    _scale = 1;
    _rotation = 0;
    _imageX = 0;
    _imageY = 0;
}
function rotateRight(){
    // イメージを時計方向へ回転
    _rotation += 90;
    redraw();
    
}
function rotateLeft(){
    // イメージを反時計方向へ回転
    _rotation -= 90;
    redraw();
}
function adjustScale(){
    // scale を規定値にする
    _scale = insViewerScale();
    document.getElementById("slideValueArea").innerHTML = _scale; // スケールを表示
    redraw();
}
function sliderChenged(elm){
    // スライダーが移動した
    _scale = elm.value;
    document.getElementById("slideValueArea").innerHTML = _scale; // スケールを表示
    redraw();
}
function moveLeft(){
    // 左へ移動
    if (window.event.shiftKey || amplified())
        _imageX -= _bigStep;
    else
        _imageX -= _step;
    redraw();
}
function moveRight(){
    // 左へ移動
    if (window.event.shiftKey || amplified())
        _imageX += _bigStep;
    else
        _imageX += _step;
    redraw();
}
function moveUp(){
    // 上へ移動
    if (window.event.shiftKey || amplified())
        _imageY -= _bigStep;
    else
        _imageY -= _step;
    redraw();
}
function moveDown(){
    // 下へ移動
    if (window.event.shiftKey || amplified())
        _imageY += _bigStep;
    else
        _imageY += _step;
    redraw();
}
function redraw(){
    // _scale _rotation を反映し再描画
    if (image()){
        var can = canvas();
        var ctx = can.getContext("2d");
        
        // 再描画前に今までのイメージを消去
        ctx.clearRect(0, 0, can.width, can.height);  
        
        // クリッピング領域で表示
        ctx.beginPath();
        ctx.moveTo(0,0);
        ctx.lineTo(clipWidth(), 0);
        ctx.lineTo(clipWidth(), clipHeight());
        ctx.lineTo(0, clipHeight());
        ctx.clip();
        
        ctx.save();
        
        // 回転準備として位置を移動
        var cx = clipWidth()/2;
        var cy = clipHeight()/2;
        ctx.translate(cx, cy); // x軸方向にcx、y軸方向にcy移動
        
        // 回転(値はラジアンで指定するため変換を行う)
        var rad = _rotation / 180 * Math.PI;
        ctx.rotate(rad); // 座標(0,0)を中心として時計回りにθ回転
        
        // Imageオブジェクトを、左上の角が座標(x,y)に来るように描画
        var x = -1 * cx + _imageX;
        var y = -1 * cy + _imageY;
        var w = image().width * _scale;
        var h = image().height * _scale;
        ctx.drawImage(image(), x, y, w, h);  
        
        ctx.restore();
    }
    
    // クリップ領域を青い枠で囲む
    drawFrame();
}

function closeSlider(){
    // slider 領域を閉じる
    var elm = document.getElementById("sliderArea");
    elm.innerHTML = "";
    elm.style.display = "none"; // 表示しない
}
function showSlider(isNewImage){
    // 拡大縮小用スライダーを表示
    var elm = document.getElementById("sliderArea");
    elm.innerHTML = "";
    elm.style.border = "2px solid #88f";
    elm.style.fontSize = "10pt";
    elm.style.paddingBottom = "3px";
    elm.style.width = clipWidth() - 4;
    elm.style.display = "block"; // 表示する

    // SCANNED DATE and TIME
    var popupElm = document.getElementById("imgPop");
    if (!popupElm || isNewImage){
        // ポップアップメニューがない場合は新規の画像なので
        // patientId とタイムスタンプから filename を生成
        var array = imageName().split(".");
        if (array.length <= 1){
            alert("filename: "+imageName+" has no SUFFIX");
            return null;
        }
        var suffix = array[array.length-1];
        var filename = patientId()+"_"+todayAndTimeId()+"."+suffix;
    } else {
        filename = popupElm.value;
    }
    var sp = newSPAN(elm, "");
    sp.innerHTML = selectedDateTime(filename);
    sp.style.fontWeight = "bold";
    sp.style.padding = "2px 5px";
    sp.style.color = "#fff";
    sp.style.backgroundColor = "#88c";
    sp.style.marginLeft = "3px";
    
    // SCALE SLIDER
    var sp = newSPAN(elm, "");
    sp.innerHTML = "サイズ";
    sp.style.padding = "0px 3px";
    sp.style.color = "#55a";
    // SLIDER
    var action = "sliderChenged(this)";
	var val = "1";
    var min = "0.35";
    var max = "2";
    var step = "0.01";
    var sl = newSlider(elm, "slider", step, val, max, min, action);
    
    // SLIDE VALUE
    var sp = newSPAN(elm, "slideValueArea");
    sp.style.padding = "0px 3px";
    sp.style.color = "#fff";
    sp.style.backgroundColor = "#88c";
    sp.innerHTML = "scale";
    sp.setAttribute("onclick", "adjustScale()");

    // ROTATE RIGHT
    var sp = newSPAN(elm, "");
    sp.style.padding = "0px 3px";
    var a = newA(sp, "時計方向", "#", "");
    a.setAttribute("onclick", "rotateRight()");
    
    // ROTATE LEFT
    var sp = newSPAN(elm, "");
    sp.style.padding = "0px 3px";
    var a = newA(sp, "反時計方向", "#", "");
    a.setAttribute("onclick", "rotateLeft()");
    
    // MOVE LEFT
    var sp = newSPAN(elm, "");
    sp.style.padding = "0px 3px";
    var a = newA(sp, "左", "#", "");
    a.setAttribute("onclick", "moveLeft()");
    // MOVE RIGHT
    var sp = newSPAN(elm, "");
    sp.style.padding = "0px 3px";
    var a = newA(sp, "右", "#", "");
    a.setAttribute("onclick", "moveRight()");
    
    // MOVE UP
    var sp = newSPAN(elm, "");
    sp.style.padding = "0px 3px";
    var a = newA(sp, "上", "#", "");
    a.setAttribute("onclick", "moveUp()");
    // MOVE DOWN
    var sp = newSPAN(elm, "");
    sp.style.padding = "0px 3px";
    var a = newA(sp, "下", "#", "");
    a.setAttribute("onclick", "moveDown()");
    
    // RELOAD
    var sp = newSPAN(elm, "");
    sp.style.padding = "0px 3px";
    var a = newA(sp, "再表示", "#", "");
    a.setAttribute("onclick", "redraw()");

    // OVERWRITE
    var sp = newSPAN(elm, "");
    sp.style.padding = "0px 3px";
    var bt = newBUTTON(sp, "", "保存");
    bt.setAttribute("onclick", "saveData('" + filename + "')");
    
    function selectedDateTime(filename){
        // 保険証履歴ポップアップの値から dateTime を解析して返す
        var yyyy = filename.substr(9, 4);
        var mm = filename.substr(13, 2);
        var dd = filename.substr(15, 2);
        var hr = filename.substr(17, 2);
        var mn = filename.substr(19, 2);
        var sc = filename.substr(21, 2);
        return yyyy+"-"+mm+"-"+dd+" "+hr+":"+mn+":"+sc;
    }
}

function drawText(x, y, text, color){
    // 文字を描く
    var can = canvas();
    var context = can.getContext("2d");
    context.font = "14px 'Times New Roman'";
    context.fillStyle = (color) ? color : "rgb(0,0,0)";
    context.fillText(text, x, y, 1);
}

// ### dragAndDrop ##########
var _canvas;
function setCanvas(cv){
    _canvas = cv;
}
function canvas(){
    return _canvas;
}
function FileDrop(e, can){
    // el にドロップされた画像を描画
    /*
     */

    var file = e.dataTransfer.files[0];
    if (!file) {
        alert('画像ファイルの実体がないのでドロップできません');
        return; // file の実体がないとドロップできない
    }
    
    if(!file.type.match(/image\/\w+/)){
        alert('画像ファイルしか受けつけられません');
        return;
    }
    
    setImageName(file.name);

    var img = document.createElement("img");
   
    if (isSafari()){
        alert('Safari は FileReader() 未対応です。\n「画像アップロード」ボタンを使うか Google Chrome をお使いください。');
        /*
        alert("e.dataTransfer->"+encodeObject(e.dataTransfer)); //##

        img.src = e.dataTransfer.types[0];
        setImage(img);

        _scale = 1;
        _rotation = 0;
        _imageX = 0;
        _imageY = 0;
        clearDraw();
        
        // クリッピング領域で表示
        var can = canvas();
        var ctx = can.getContext("2d");
       
        ctx.beginPath();
        ctx.moveTo(0,0);
        ctx.lineTo(clipWidth(), 0);
        ctx.lineTo(clipWidth(), clipHeight());
        ctx.lineTo(0, clipHeight());
        ctx.clip();
      
        ctx.drawImage(img, 0, 0);  
        
        // クリップ領域を青い枠で囲む
        drawFrame();
         */
        return;
    }

    var reader = new FileReader(); 
    reader.onload = function(e) {
        img.src = e.target.result;
    }
    setImage(img);
    
    // canvas へ描画
    img.onload = function() {
        _scale = 1;
        _rotation = 0;
        _imageX = 0;
        _imageY = 0;
        clearDraw();
        
        var ctx = can.getContext("2d");
        
        // クリッピング領域で表示
        ctx.beginPath();
        ctx.moveTo(0,0);
        ctx.lineTo(clipWidth(), 0);
        ctx.lineTo(clipWidth(), clipHeight());
        ctx.lineTo(0, clipHeight());
        ctx.clip();
        
        ctx.drawImage(img, 0, 0);  
        
        // クリップ領域を青い枠で囲む
        drawFrame();
    }
    
    reader.readAsDataURL(file);
    
    // 画像アップロード用コントロール・エリアを開く
    showSlider("newImage");
}
function clearDraw(){
    // イメージ画面をクリアー
    var can = canvas();
    var context = can.getContext("2d");
    context.clearRect(0, 0, can.width, can.height);

    return true;
}
// ### dragAndDrop ##########


var _clipWidth; // = 1000;
function setClipWidth(val){
    _clipWidth = val;
}
function clipWidth(){
    return (_clipWidth) ? _clipWidth * 1 : 1000;
}
var _clipHeight; // = 1000;
function setClipHeight(val){
    _clipHeight = val;
}
function clipHeight(){
    return (_clipHeight) ? _clipHeight * 1 : 700;
}

function changeClipSize(){
    // 「A4サイズ」チェックボックスが変更された
    putClipSize();
    window.location.reload();
}

var _canvasWidth = 3000;
function drawFrame(){
    // クリップ領域を青い枠で囲む
    var can = canvas();
    var context = can.getContext("2d");
    context.lineWidth = 5;
    context.strokeStyle = "blue";
    context.strokeRect(0, 0, clipWidth(), clipHeight());
    context.stroke();
}

function hideFooter(){
    // FOOTER を見えなくする
    var elm = document.getElementById("footerArea");
	elm.style.visibility = "hidden";
}

function initInsViewer(){
    getClipSize();
    
	var elm = document.getElementById("base");
    
    // HEADER
    var div = newDIV(elm, "tool-header");
    div.style.paddingBottom = "8px";
    // --- LEFT SIDE -------------
    var dv = newDIV(div, "left-side");
    dv.style.width = "600px";
    var sp = newSPAN(dv, "");
    sp.style.paddingLeft = "5px";
    sp.innerHTML = "保険証 検索対象";
    // DATE
    var sp = newSPAN(dv, "");
    var ary = today().split("-");
    var y = ary[0];
    var m = ary[1];
    var pu = newDatePopUp(sp, "targetYM", "", y, m, "1", true, setTargetDate);
    var sp = newSPAN(dv, "");
    var fd = newFIELD(sp, "keyF", "", 20, "");
    fd.setAttribute("onchange", "findPatient()");
    fd.focus();
    var bt = newBUTTON(sp, "", "検索");
    bt.setAttribute("onclick", "findPatient()");
    var bt = newBUTTON(sp, "", "当月");
    bt.setAttribute("onclick", "findMonthPatient()");
    // --- RIGHT SIDE -------------
    var dv = newDIV(div, "right-side");
    // HAMMER ICON
    var sp = newSPAN(dv, "");
	var img = newIMAGE(sp, "icon", "./hammer.png", "preference");
	img.setAttribute("onclick","preference()");
	img.style.height = "14px";
	img.style.position = "relative";
    img.style.top = "1px";
    var sp = newSPAN(dv, "preferenceArea"); // PREFERENCE AREA
    sp.style.marginRight = "10px";
    // ZOOM ICON
    var sp = newSPAN(dv, "");
    sp.style.marginRight = "10px";
	var img = newIMAGE(sp, "icon", "./zoomfit.png", "zoom");
	img.setAttribute("onclick","putWindowSize()");
	img.style.height = "16px";
	img.style.position = "relative";
    img.style.top = "3px";
    // HELP ICON
    var sp = newSPAN(dv, "");
    sp.style.paddingLeft = "5px";
	var img = newIMAGE(sp, "", "./Help.png", "?");
	img.style.height = "18px";
	img.style.position = "relative";
    img.style.top = "4px";
	img.setAttribute("onclick", "help()");
    
    var div = newDIV(elm, "");
    div.style.clear = "both"; //##
    
    var div = newDIV(elm, "tool-bar");
    div.style.paddingBottom = "8px";
    var dv = newDIV(div, "left-side");
    dv.style.width = "600px";
    // 画像ファイル・ポップアップ表示エリア
    var sp = newSPAN(dv, "popupArea");
    // CECK BOX
    var sp = newSPAN(dv, "");
    sp.style.padding = "0px 5px";
    var status = (clipHeight()*1 > 700) ? 1 : 0;
    var bx = newCHECKBOX(sp, "expandBox", "A4サイズ", status);
    bx.setAttribute("onchange", "changeClipSize()");
    // 拡大率
    var sp = newSPAN(dv, "");
    sp.style.padding = "0px 3px";
    var bx = newCHECKBOX(sp, "amplifyBox", "移動巾を増大", 1);
    // VERSION
    var dv = newDIV(div, "right-side");
	dv.style.position = "relative";
    dv.style.top = "5px";
    var sp = newSPAN(dv, "");
    sp.style.color = "#aaa";
    sp.style.paddingLeft = "10pt";
    sp.innerHTML = version();
    
    var div = newDIV(elm, "");
    div.style.clear = "both"; //##
    
    // 保険証の内容を表示
    var dv = newDIV(elm, "patientInfoArea");
    dv.style.padding = "5px";
    
    // アップロード用コントロール
    var dv = newDIV(elm, "controlArea");
    
    // メッセージ・エリア
    var dv = newDIV(elm, "messageArea");
    
    // スライダー・エリア
    var dv = newDIV(elm, "sliderArea");
    
    // イメージの表示・ドロップ用エリア
    // ### dragAndDrop ################
    var dv = newDIV(elm, "dropArea");
    var cv = newCANVAS(dv, "myCanvas", _canvasWidth, _canvasWidth, null);
    setCanvas(cv);
    
    cv.ondrop=function(e){
        FileDrop(e, cv);
        e.preventDefault();
    };
    
    cv.ondragover=function(e){
        e.preventDefault();
    };
    // ### dragAndDrop ################
    
	// ウインドー・サイズをサーバから読み込みサイズ調整
	getWindowSize();

    document.getElementById("keyF").value = patientId();
    getPatientList(patientId());

    // クリップ領域を青い枠で囲む
    drawFrame();
    window.scroll(0, 0);
}

function version(){
	return "Ver.130127";
}
