
function isDebug(){
    return (docMakerDebug()) ? true : false;
}

var _tags;
function tagArray(){
    // DocMaker で使用する DB タグの配列を返す
    if (!_tags){
        _tags = new Array();
        _tags.push("NameSection.patientKanjiName");
        _tags.push("PatientTable.sex");
        _tags.push("PatientTable.birthDate");
        _tags.push("AddressSection.address");
        _tags.push("AddressSection.phone");
        _tags.push("HospitalTable.住所");
        _tags.push("HospitalTable.電話番号");
        _tags.push("HospitalTable.FAX");
        _tags.push("HospitalTable.施設名");
        _tags.push("ProgressSection.object");
    }
    return _tags;
}

var _leftbrackets = "^[^"; // encode 中で使う '('
var _rightbrackets = "^]^"; // encode 中で使う ')'
function decodeObjectNoNest(layer, buff){
	// "key(value)" 形式の文字列を OBJECT に decode して返す
	// ### DocMaker 専用：文書(...) 内で第２層目までネストした decode を行う
	// ### 第２層目のコンテンツ すなわち第３層目には '(...)' が含まれている可能性あり
	// ### またそれ以上分解する必要もないので第３層目は decode せず 文字列そのまま表示
	var obj = new Object();
	var len = buff.length, begin, end;
	var key, value;
	for (var p=begin=nest=0; p < len; p++){
		var ch = buff.charAt(p);
		if (ch == '('){
			if (nest == 0){
				key = trim(buff.substring(begin, p)); // key 終端
				begin = p + 1; // value 開始位置
			}
			nest++;
		} else if (ch == ')'){
			if (--nest == 0){
				if (nest == 0){
					value = buff.substring(begin, p); // value 終端:trim しない
					begin = p + 1; // key 開始位置
				}
				
				if (value.indexOf(")") > 0){ // まだ入れ子になっているなら
					if (layer == 0){
						// 第１層目の "文書(...)" 内はネストする
						obj[key] = decodeObjectNoNest(layer+ 1, value);
					} else {
						// 第２層目では "contents(...)" 内などをネストしない
						obj[key] = value;
					}
				} else {
					// 特定文字を "(", ")" へ戻す
					value = convertSTRING(value, _leftbrackets, "(");
					value = convertSTRING(value, _rightbrackets, ")");
					
					obj[key] = value;
				}
			}
		}
	}
	return obj;
}

var _args;
function setArguments(val){
	if (val){
        _debug("setArguments->"+val); //##
        
		// val = "文書(...)value(some shing)" のような形式
		//alert("setArguments --\n"+val); //##
		
		// ### 通常の decodeObject() を使うと contents などの中にある '(...)' も
		// ### object としてデコードしてしまうので、ネストしないデコードを行う
		var obj = decodeObjectNoNest(0, val);
        _debug("obj->"+encodeObject(obj)); //##
        
		if (obj['文書']){
			// カルテへ添付されたアーカイブは「文書(...)」のように
			// 文書（）でくくられているので、中身の「...」だけを取り出す
			_args = obj['文書'];
		} else
			_args = obj;
        
        _debug("_args->"+_args); //##

	} else
		_args = new Object();
}
function args(){
	// アーカイブとしてカルテへ転写する内容
	return _args;
}

var _docNames;
function setDocNames(array){
	_docNames = array;
}
function docNames(){
	// 文書名の配列
	return _docNames;
}

var _adressees;
function setAddressees(array){
	_adressees = array;
}
function addressee(){
	// 宛名の配列
	return _adressees;
}

var _timeStampStatus;
function setTimeStampStatus(status){
	_timeStampStatus = status;
}
function timeStampStatus(){
	// 年月日を default で本日にするかどうか
	// 文書毎ではなく DocMaker の初期値として記憶される
	return (_timeStampStatus * 1 > 0) ? true : false;
}

/////////////////////////
///// カルテからの継承値 ///

///// NOA へ問い合わせて得る値 /////
function _noa(){
	// window.opener が NOA なら NOA を返す
    if (window.opener && (window.opener.name == "noa")){
        return window.opener;
    } else if (window.opener && (window.opener.name == "tools")){
        return window.top.noa;
    } else if (window.opener && (window.top.noa)){
        return window.top.noa;
    } else {
        alert("親としての NOA が見つかりません");
        return null;
    }
}

function owner(){
    // neuron.js で owner() 定義済みなのでカブらないようにする
	return _dogTagObj.owner;
}

function currentDate(){
    // neuron.js で currentDate() 定義済みなのでカブらないようにする
	return _dogTagObj.currentDate;
}

function hospId(){
    // neuron.js で hospitalId() 定義済みなのでカブらないようにする
	return _dogTagObj.hospitalId;
}

function patientKanjiName(){
    return _dogTagObj["NameSection.patientKanjiName"];
}
function sex(){
    return _dogTagObj["PatientTable.sex"];
}
function birthDate(){
    return _dogTagObj["PatientTable.birthDate"];
}
function patientAddress(){
    return _dogTagObj["AddressSection.address"];
}
function patientPhone(){
    return _dogTagObj["AddressSection.phone"];
}

function hospitalAddress(){
    return _dogTagObj["HospitalTable.住所"];
}
function hospitalPhone(){
    return _dogTagObj["HospitalTable.電話番号"];
}
function hospitalFAX(){
    return _dogTagObj["HospitalTable.FAX"];
}
function hospitalName(){
    return _dogTagObj["HospitalTable.施設名"];
}

///// カルテからの継承値 ///
/////////////////////////


///////////////////////////
/// Ajax による処理 /////////

var _dataObj;
var _dogTagObj;
function gotDogTag(answer){
    var obj = JSON.parse(answer);
    //alert("gotDogTag->"+encodeObject(obj)); //##
    for (tag in obj){
        var rec = obj[tag];
        _dogTagObj[tag] = rec.value;
    }
    _debug("_dogTagObj->"+encodeObject(_dogTagObj)); //##
    
//    var elm = document.getElementById("footerLeftArea");
//    elm.innerHTML = version() + " ( 取扱: " + _dogTagObj.owner + " )";
    
    // サーバからメニュー類のソースをもらった後、ポップアップメニューなどを生成
    getAddressAndDocumentMenu();
}
function getDogTag(){
    // NOA が周辺ツールを開いた時ブラウザーに記憶した認識情報を取り出す
    var val = window.localStorage["dogTag"];
    
    _debug("getDogTag->"+val); //##
    
    _dogTagObj = decodeObject(val);
    var owner = _dogTagObj.owner;
    var pid = _dogTagObj.patientId;
    var date = _dogTagObj.currentDate;
    var hid = _dogTagObj.hospitalId;
    
    NRGetValueAPI(owner, pid, date, hid, tagArray().join(","), gotDogTag);
}

function savedAsTemplate(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert(value); //##
		var ary = value.split("<SEPARATOR>");
		if (ary.length > 1){
            // 内容確認の infoTip を表示
			var elm = document.getElementById("_infoTip");
			elm.innerHTML = "";
			var tbl = newTABLE(elm, "");
			tbl.style.fontSize = "9pt";
			tbl.style.width = "500px";
			
			var tr = newTR(tbl, "", "");
			var td = newTD(tr, "", "");
			td.innerHTML = archivedStrings();
			td.style.borderBottom = "thin solid #a63"; // brown
			td.style.padding = "5px 2px";

			var tr = newTR(tbl, "", "");
			var td = newTD(tr, "", "");
			var docname = document.getElementById("documentName").value;
			var st = "文書名：<b>" + docname + "</b> がメニューにない場合、新しい";
			st += "「文書名と付随するテンプレート」として「文書名」メニューに登録されます";
			td.innerHTML = st;

			// 最上部に開いた infoTip が見えないことがあるので最上部へスクロールしておく
			window.scroll(0, 0); 
			showInfoTip(20, 40, tbl, 1200, "アーカイブされた内容");
		}
	}
}
function saveAsTemplate(){
	// 表示された書式をテンプレートとして登録（既存書式名なら頻度のみインクリメント）
	// 宛先をメニューに登録（宛先が既存なら頻度のみインクリメント）
	xmlHttpObject = createXMLHttpRequest(savedAsTemplate);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = owner();
		array["address"] = document.getElementById("addressee").value;
		array["documentName"] = document.getElementById("documentName").value;
		// 改行はサーバで <br/> へ置換され格納される
		array["contents"] = contents();
		
		var st = "./server.php?command=PUT_DOCUMENT"
		+ "&value="+encodeObject(array);
		//alert("saveAsTemplate ===\n"+st); //###
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}
function sendToNOA(){
	// 宛先をメニューに登録
	var bt = document.getElementById("submitButton");
	bt.style.display = "block"; // 表示する
	
	// その後、文書を印刷
	saveAsTemplate();

    // NOA へドキュメントのアーカイブを返送
    var st = "";
    if (!isSameDate(currentDate(), today()))
        st = "NOA は ** 過去のページ ** ですが、";

    if (confirm(st + "カルテ所見欄にこの文書を転記していいですか")){
        // CELL 内容を取り出す
        var tag = "ProgressSection.object";
        var cellVal = _dogTagObj[tag];
        cellVal = pureValue(cellVal);
        cellVal = convertSTRING(cellVal, "\n", "<br>");
        
        //　CELL 内容に archivedStrings() を追加
        if (trim(cellVal).length == 0)
            var result = archivedStrings();
        else 
            var result = cellVal + "<br>" + archivedStrings();
        
        // CELL エディターを開き result を表示
        _noa().putValueForTag(result, tag);
    }
}

function printPDF(){
    // 印刷
    // printDoc.php へ送るオブジェクトを生成
    var obj = new Object();
    obj.documentName = document.getElementById("documentName").value;
    obj.addressee = document.getElementById("addressee").value;
    obj.hasPatientInfo = (document.getElementById("hasPatientInfo").checked) 
    ? "on" : "";
    obj.isSmallFont = (document.getElementById("isSmallFont").checked) 
    ? "on" : "";;
    obj.patientName = document.getElementById("patientName").value;
    obj.sex = document.getElementById("sex").value;
    obj.age = document.getElementById("age").value;
    obj.birthDate = seireki(document.getElementById("birthDate").value);
    obj.patientAddress = document.getElementById("patientAddress").value;
    obj.patientPhone = document.getElementById("patientPhone").value;
    obj.greetings = document.getElementById("greetings").value;
    obj.contents = document.getElementById("contents").value;
    obj.timestamp = document.getElementById("timestamp").value;
    obj.hospitalName = hospitalName();
    obj.hospitalAddress = hospitalAddress();
    obj.hospitalPhone = hospitalPhone();
    obj.hospitalFAX = hospitalFAX();
    
    //alert(encodeObject(obj)); //##

    // printDoc.php へ送る
    var json = JSON.stringify(obj);

    //alert(encodeSTRING(json)); //##

    // # などのキャラクターが化けるので encodeSTRING() する
	var url = "/DocMaker/printDoc.php?value=" + encodeSTRING(json);
    
	//alert(url); //##
	
	window.open(url, "PDF", "dependent=yes");
}

function showOverWrite(){
	// テンプレート上書き結果を表示
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("showOverWrite ===\n"+value); //###
		var ary = value.split("<SEPARATOR>");
		if (ary.length > 1){
			var buff = ary[1];
			// alert(buff);

			// infoTip 表示
			var elm = document.getElementById("_infoTip");
			elm.innerHTML = "";
			var tbl = newTABLE(elm, "");
			tbl.style.fontSize = "9pt";
			var tr = newTR(tbl, "", "");
			var td = newTD(tr, "", ary[1]);
			td.style.padding = "5px 2px";
			td.innerHTML = "テンプレートは上書きされました<br/>"
			+ "ブラウザーを再表示するとメニューに反映されます";

			// 最上部に開いた infoTip が見えないことがあるので最上部へスクロールしておく
			window.scroll(0, 0); 
			showInfoTip(20, 40, tbl, 1000); // 1000 ミリ秒でフェードアウト
		}
	}
}
function overWriteTemplate(){
	// 表示されている書式をテンプレートとして登録
	var documentName = document.getElementById("documentName").value;
	if (documentName.length == 0){
		alert("文書名を入力してください");
		return;
	}
	if (!confirm("この内容でテンプレートを上書きしていいですか")) return;
	
	// 既存の書式があれば上書き
	xmlHttpObject = createXMLHttpRequest(showOverWrite);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = owner();
		array["documentName"] = documentName;
		array["contents"] = contents();

		var st = "./server.php?command=OVERWRITE_DOCUMENT"
		+ "&value="+encodeObject(array);
		//alert("overWriteTemplate ===\n"+st); //###
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function setTemplate(){
	// 各エレメントにデータ表示
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("setTemplate:\n"+value); //##
		var ary = value.split("<SEPARATOR>");
		if (ary.length > 1){
			document.getElementById("addressee").value = "";
			document.getElementById("greetings").value = "";
			var td = document.getElementById("patientInfoArea");
			setHasPatientInfo(true);
			document.getElementById("contents").value = "";
			var buff = trim(ary[1]);
			if (buff.length){
				buff = transferCR(buff); // 念のため
				//alert(buff); //##
				
				var obj = eval('(' + buff + ')');
				var greetings = obj['greetings'];
				greetings = transferToCR(greetings);
				document.getElementById("greetings").value = greetings;
				var td = document.getElementById("patientInfoArea");
				var status = (obj['haPatInfo'] && obj['haPatInfo'].length)
					? true : false;
				setHasPatientInfo(status);
				var contents = obj['contents'];
				contents = transferToCR(contents);
				document.getElementById("contents").value = contents;
			}
		} 
	} 
}
function getTemplate(documentName){
	// 選択された文書名に相当するテンプレートをサーバへリクエスト
	xmlHttpObject = createXMLHttpRequest(setTemplate);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		// tag, owner, target, value
		var array = new Array();
		array["owner"] = owner();
		array["documentName"] = document.getElementById("documentName").value;
		
		var st = "./server.php?command=GET_TEMPLATE"
		+ "&value="+encodeObject(array);
		//alert("getTemplate ===\n"+st); //###
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function gotMenu(){
	// 各エレメントにデータ表示
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("gotMenu ---\n"+value); //##
		var ary = value.split("<SEPARATOR>");
		if (ary.length > 1){
			var obj = eval('(' + ary[1] + ')');
			//alert("gotMenu ->"+encodeObject(obj)); //##
            _debug("gotMenu->"+encodeObject(obj)); //##
                        
			setAddressees(getKeys(obj.documentAddress));
			setDocNames(getKeys(obj.documentName));
			setTimeStampStatus(obj.timeStampStatus);
            
            makeDocumentSelector();
            makeAdresseeSelector();
            makePatientInfo();
            
            makeHospitalInfoArea();
		} 
	} 
	
	function getKeys(obj){
		// obj から key の配列を返す
		var array = [""];
		for (key in obj) array.push(key);
		return array;
	}
}
function getAddressAndDocumentMenu(){
	// 宛先メニューと文書メニューをサーバへリクエスト
	xmlHttpObject = createXMLHttpRequest(gotMenu);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var st = "./server.php?command=GET_MENU"
		+ "&owner=" + owner();
		//alert("getAddressAndDocumentMenu->"+st); //##

        _debug("getAddressAndDocumentMenu->"+st); //##

		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function removedAddressItem(){
	// 各エレメントにデータ表示
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("removedAddressItem ---\n"+value); //##
		var ary = value.split("<SEPARATOR>");
		if (ary.length > 1){
			// infoTip 表示
			var elm = document.getElementById("_infoTip");
			elm.innerHTML = "";
			var tbl = newTABLE(elm, "");
			tbl.style.fontSize = "9pt";
			var tr = newTR(tbl, "", "");
			var td = newTD(tr, "", ary[1]);
			td.style.padding = "5px 2px";
			td.innerHTML = ary[1] + " は削除されました<br/>"
			+ "ブラウザーを再表示するとメニューに反映されます";

			// 最上部に開いた infoTip が見えないことがあるので最上部へスクロールしておく
			window.scroll(0, 0); 
			showInfoTip(20, 40, tbl, 1000); // 1000 ミリ秒でフェードアウト
		}
	}
}
function removeAddressItem(){
	// 宛先の削除をサーバへリクエスト
	var item = document.getElementById("addressee").value;
	if (item.length == 0) return;
	
	if (confirm("「" + item + "」を宛名リストから削除して良いですか")){
		// item の削除をサーバへ登録依頼
		xmlHttpObject = createXMLHttpRequest(removedAddressItem);
		if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
			var array = new Array();
			array["tag"] = "UniversalSection.documentAddress";
			array["address"] = item;
			
			var st = "./server.php?command=REMOVE_MENU_ITEM"
			+ "&value="+encodeObject(array);
			//alert("removeAddressItem ===\n"+st); //###
			xmlHttpObject.open("GET", encodeURI(st), true);
			xmlHttpObject.send(null);
		}
	}
}

function removedDocumentItem(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("removedAddressItem ---\n"+value); //##
		var ary = value.split("<SEPARATOR>");
		if (ary.length > 1){
			// infoTip 表示
			var elm = document.getElementById("_infoTip");
			elm.innerHTML = "";
			var tbl = newTABLE(elm, "");
			tbl.style.fontSize = "9pt";
			var tr = newTR(tbl, "", "");
			var td = newTD(tr, "", ary[1]);
			td.style.padding = "5px 2px";
			td.innerHTML = ary[1] + " は削除されました<br/>"
			+ "ブラウザーを再表示するとメニューに反映されます";
			
			// 最上部に開いた infoTip が見えないことがあるので最上部へスクロールしておく
			window.scroll(0, 0); 
			showInfoTip(20, 40, tbl, 1000); // 1000 ミリ秒でフェードアウト
		}
	}
}
function removeDocumentItem(){
	// 文書の削除をサーバへリクエスト
	var item = document.getElementById("documentName").value;
	if (item.length == 0) return;
	
	if (confirm("「" + item + "」を文書リストから削除して良いですか")){
		// item の削除をサーバへ登録依頼
		xmlHttpObject = createXMLHttpRequest(removedDocumentItem);
		if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
			var array = new Array();
			array["tag"] = "UniversalSection.documentName";
			array["address"] = item;
			
			var st = "./server.php?command=REMOVE_MENU_ITEM"
			+ "&value="+encodeObject(array);
			//alert("removeDocumentItem ===\n"+st); //###
			xmlHttpObject.open("GET", encodeURI(st), true);
			xmlHttpObject.send(null);
		}
	}
}

function puttedTimeStampSetting(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("puttedTimeStampSetting ---\n"+value); //##
		var ary = value.split("<SEPARATOR>");
		if (ary.length > 1){
		}
	} 
}
function putTimeStampStatus(status){
	// タイムスタンプをカルテ日付にするか当日日付にするかの設定をサーバへ記憶
	xmlHttpObject = createXMLHttpRequest(puttedTimeStampSetting);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["menu"] = "DocMaker.timeStampStatus";
		array["owner"] = owner();
		array["val"] = status;
		
		var st = "./server.php?command=PUT_MENU"
		+ "&value="+encodeObject(array);
		//alert("putTimeStampStatus ===\n"+st); //###
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

/// Ajax による処理 /////////
///////////////////////////


////////////////////////////////////////////
/// localStorage ///////////////////////////

function getWindowSize(){
	// Booking のウインドー位置とサイズをサーバへリクエスト
    var size = window.localStorage["docMakerWindowSize"];
    
	// サーバから得られたサイズにウインドーを調整する
	if (size){
		var args = size.split(",");
		var x = args[0] * 1;
		var y = args[1];
		var w = args[2];
		var h = args[3];
		// resize を先にしておかないと元が大きいサイズだった場合 moveTo しよう
		// としてもウインドー境界の制限で移動できない場合がある
		window.resizeTo(w, h);
		window.moveTo(x, y);
        
        //alert("getWindowSize->"+size); //##
	}
}
function putWindowSize(){
	// Booking のウインドー位置とサイズをサーバへ記憶
	var x = window.screenLeft;
	var y = window.screenTop - 22;
	var w = window.outerWidth;
	var h = window.outerHeight;
    var array = [x, y, w, h];
    
    window.localStorage["docMakerWindowSize"] = array.join(",");
}

function setDocMakerDebug(elm){
    var status = (elm.checked) ? "1" : "";
    window.localStorage["docMakerDebug"] = status;
}
function docMakerDebug(){
    // デバッグ・ステータスを返す
    return (window.localStorage["docMakerDebug"]) ? 1 : 0;
}

function setFromAddress(){
    // メールの From アドレスを記憶
    window.localStorage["fromAddress"] = document.getElementById("from").value;
}
function fromAddress(){
    return (window.localStorage["fromAddress"]) ? window.localStorage["fromAddress"] : "";
}

/// localStorage ///////////////////////////
////////////////////////////////////////////


function contents(){
	// サーバへ送るデータ・パッケージを作成して返す
	// contents 中の改行は server.php で "<br/>" に置換されて DB に格納される
	var status = (document.getElementById("hasPatientInfo").checked) 
		? "on" : "";
	return "{"
	+ '"greetings":"' + document.getElementById("greetings").value + '",'
	+ '"haPatInfo":"' + status + '",'
	+ '"contents":"' + document.getElementById("contents").value + '"}';
}

function archivedData(){
	// サーバへ送るデータ・パッケージを作成して返す
	// contents 中の改行は server.php で "<br/>" に置換されて DB に格納される
	var json = "{"
	+ '"greetings":"' + document.getElementById("greetings").value + '",'
	+ '"haPatInfo":"' + document.getElementById("hasPatientInfo").value + '",'
	+ '"contents":"' + document.getElementById("contents").value + '"}';
	
	return document.getElementById("address").value + "_|_"
	+ document.getElementById("documentName").value + "_|_"
	+ json + "_|_";
}

function makePopupItems(){
	// addressPopup のコンテンツを作成
	var records = tableArray();
	var st = "<INPUT type=checkbox onclick=clickedBox(this) id=active checked>"
	+ "<select id=popup onclick=popupClicked(this)>";
	var i, count = records.length;
	for (i=0; i < count; i++){
		var recObj = records[i];
		var name = recObj.name;
		st += "<option value=\""+name+"\">"+name;
	}
	st += "</select>";
	st += " <font size=-2 color=blue onclick=man()><U>能書</U></font>";
	_isActive = 1;
	
	document.getElementById("addressPopup").innerHTML = st;
}

function addressClicked(){
	// 宛先ポップアップがクリックされた
	var selectedItem = document.getElementById("addresMenu").value;
	document.getElementById("addressee").value = selectedItem;
}

function docClicked(elm){
	// 文書ポップアップがクリックされた
	var selectedItem = elm.value;
	document.getElementById("documentName").value = selectedItem;
	// 選択された文書名に相当するテンプレートをサーバへリクエストし表示
	getTemplate(selectedItem);
}

function setHasPatientInfo(status){
	// 患者情報表示チェックボックスのステータスを設定
	var checkbox = document.getElementById("hasPatientInfo");
	checkbox.checked = status;
	togglePatientInfo(checkbox);
}
function togglePatientInfo(elm){
	// 患者情報表示チェックボックスのチェックにより toggle
	var td = document.getElementById("patientInfoArea");
	toggleView(td, elm.checked);
}

function checkToday(elm){
	// 本日の日付に設定がチェックされた
	var date = (elm.checked) ? today() : currentDate();
	var array = date.split(" ");
	date = yyyymmdd(date); // "2010-12-31 17:48:29" を "2010-12-31" にする
	document.getElementById("timestamp").value = wareki(date);

	// 設定をサーバへ記憶
	var status = (elm.checked) ? "1" : "0";
	putTimeStampStatus(status);
}

function removeArchive(){
	// アーカイブを読込む
	document.getElementById("output").value = "";
	document.getElementById("output").focus();
}

function archivedStrings(){
	// 文書をアーカイブして返す
	var obj = new Object();
	obj['documentName'] = document.getElementById("documentName").value;
	// ## 旧バージョンとの互換性のため adressee でなく address を使う ##
	obj['address'] = document.getElementById("addressee").value;
	var wareki = document.getElementById("timestamp").value;
	obj['entryDate'] = seireki(wareki);
	var status = document.getElementById("hasPatientInfo").checked;
	obj['hasPatientInfo'] = (status) ? "on" : "";
	if (status){
		obj['patientName'] = document.getElementById("patientName").value;
		obj['birthDate'] = seireki(document.getElementById("birthDate").value);
		obj['sex'] = document.getElementById("sex").value;
		obj['patientAddress'] = document.getElementById("patientAddress").value;
		obj['patientPhone'] = document.getElementById("patientPhone").value;
	}
	var st = document.getElementById("greetings").value;
	var array = st.split("\n");
	st = array.join("<br/>");
	obj['greetings'] = st;
	var st = document.getElementById("contents").value;
	var array = st.split("\n");
	st = array.join("<br/>");
	obj['contents'] = st;
	
	return "文書(" + encodeObject(obj) + ")";
}

function loadArchive(){
	// アーカイブを読込む
	setArguments(document.getElementById("output").value);
	// 各フィールドへ args() の値を埋め込む
	var obj = args();
	if (! obj) obj = new Object();
	
	// 文書選択
	var documentName = (obj.documentName) ? obj.documentName : "";
	document.getElementById("documentName").value = documentName;
	
	// 宛先情報
	var address = (obj.address) ? obj.address : "";
	document.getElementById("addressee").value = address;
	
	// 患者情報
	setHasPatientInfo(true);
	var val = (obj.patientName) ? obj.patientName : "";
	document.getElementById("patientName").value = val;
	var val = (obj.sex) ? obj.sex : "";
	document.getElementById("sex").value = val;
	var val = (obj.birthDate) ? obj.birthDate : "";
	document.getElementById("birthDate").value = wareki(val);
	//alert(val+"->"+age(val)); //##
	document.getElementById("age").value = age(val);
	var val = (obj.patientAddress) ? obj.patientAddress : "";
	document.getElementById("patientAddress").value = val;
	var val = (obj.patientPhone) ? obj.patientPhone : "";
	document.getElementById("patientPhone").value = val;
	
	// 挨拶文
	var greetings = (obj.greetings) ? obj.greetings : "";
	var lines = greetings.split("<br/>");
	greetings = lines.join("\n");
	document.getElementById("greetings").value = greetings;
	
	// 本文
	var contents = (obj.contents) ? obj.contents : "";
	var lines = contents.split("<br/>");
	contents = lines.join("\n");
	document.getElementById("contents").value = contents;
	
	// 日付欄
	var val = (obj.entryDate) ? obj.entryDate : currentDate();
	document.getElementById("timestamp").value = wareki(val);
	
	// 印刷ボタン:SubmitButton を消す
	var bt = document.getElementById("submitButton");
	bt.style.display = "none"; // 表示しない

	// アーカイブパネルを削除
	closeFloatPanel();
}

function sendMailDone(){
	// サーバから返された処理を実行
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		alert("=== 以下の文書がメールで発出されました ===\n"+value);//##
	} 
}
function sendMail(value){
    // buff をメールで送る
	xmlHttpObject = createXMLHttpRequest(sendMailDone);
	if (xmlHttpObject){
        // encodeURI は '&' をエンコードしてくれないのでこちら側でエンコード
        var from = document.getElementById("from").value;
        var to = document.getElementById("to").value;
        var subject = document.getElementById("subject").value;
        var contents = document.getElementById("mailContents").value;
        if (from.length == 0){ alert("From を記入してください"); return; }
        if (to.length == 0){ alert("To を記入してください"); return; }
        if (subject.length == 0){ alert("Subject を記入してください"); return; }
        if (contents.length == 0){ alert("メール本文を記入してください"); return; }
        
        // ### send() に与える文字列:st 全体をエンコードしては駄目 ###
        var st = "command=POST_MAIL"
        st += "&from=" + encodeSTRING(from)
        st += "&to=" + encodeSTRING(to)
        st += "&subject=" + encodeSTRING(subject)
        st += "&message=" + encodeSTRING(contents);
        
        //alert("sendMail ====\n"+st); return; //##
        
        xmlHttpObject.open("POST", "postServer.php", true);
        xmlHttpObject.setRequestHeader('Content-Type','application/x-www-form-urlencoded; charset=UTF-8');
        xmlHttpObject.send(st);
	}
}

function postMail(){
    // 文書をメールで送付
	var elm = document.getElementById("_floatPanel");
	if (elm.innerHTML.length){
		// パネルが既に表示されていればトグル式に閉じる
		closeFloatPanel();
		return;
	}
	
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "outputTable");
	tbl.style.backgroundColor = "#ff0";

    // FROM
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	td.style.paddingLeft = "10px";
    var from = "";
    var fd = newFIELD(td, "from", "From", 50, fromAddress());
    fd.setAttribute("onchange", "setFromAddress()");

    // TO
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	td.style.paddingLeft = "10px";
    var fd = newFIELD(td, "to", "To", 50, "");
    
    // SUBJECT
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	td.style.paddingLeft = "10px";
    var fd = newFIELD(td, "subject", "Subject", 70, "");
    
    // CONTENTS
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	td.style.paddingLeft = "10px";
	td.style.paddingBottom= "10px";
	var ta = newTEXTAREA(td, "mailContents", 70, 30, mailStrings());
	
    // 送信ボタン
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	td.style.textAlign = "right";
	td.style.paddingRight = "10px";
    var bt = newBUTTON(td, "", "メールで送信");
    bt.setAttribute("onclick", "sendMail()");
    
	// 最上部に開いた infoTip が見えないことがあるので最上部へスクロールしておく
	window.scroll(0, 0);
	openFloatPanel(tbl, 15, 65, "メール送信パネル");
    
    function mailStrings(){
        // 文書をメール型式にする
        var array = new Array();
        // セパレータ
        array.push(separator());
        // 文書名
        var docName = document.getElementById("documentName").value;
        var date = document.getElementById("timestamp").value;
        array.push( docName + "　" + date );
        array.push("");
        // 宛先
        var status = document.getElementById("hasPatientInfo").checked;
        if (status){
            array.push( "　氏名： " + document.getElementById("patientName").value );
            var st = "　生年月日： " + document.getElementById("birthDate").value;
            st += "　( 性別： " + document.getElementById("sex").value + " )";
            st += "　年齡 " + document.getElementById("age").value + " 歳";
            array.push( st );
            array.push( "　住所： " + document.getElementById("patientAddress").value );
            array.push("");
            array.push("");
        }
        var buff = array.join("\n");
        // 挨拶文
        buff += document.getElementById("greetings").value;
        buff += "\n\n";
        // 本文
        buff += document.getElementById("contents").value;
        buff += "\n\n";
        // 施設名
        buff += hospitalName() + "　" + hospitalAddress();
        buff += "\n";
        buff += "電話： " + hospitalPhone() + "　FAX: " + hospitalFAX();
        buff += "\n";
        // 医師名
        buff += "医師: " + _noa().userName();
        buff += "\n";
        // セパレータ
        buff += separator() + "\n";
        
        return buff;
        
        
        function separator(){
            var st = "";
            for (var i=0; i < 40; i++)
                st += "-";
            return st;
        }
    }
}

function showArchive(){
	// 文書のアーカイブを表示：トグル式
	var elm = document.getElementById("_floatPanel");
	if (elm.innerHTML.length){
		// パネルが既に表示されていればトグル式に閉じる
		closeFloatPanel();
		return;
	}
	
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "outputTable");
	tbl.style.backgroundColor = "#ff0";
	
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	td.style.paddingTop = "5px";
	td.style.paddingLeft = "10px";
	var tx = newTEXT(td, " 文書アーカイブ表示欄　");
	var bt = newBUTTON(td, "", "空欄");
	bt.setAttribute("onclick", "removeArchive()");
	var bt = newBUTTON(td, "", "平文型式にする");
	bt.setAttribute("onclick", "mailStyle()");
	var bt = newBUTTON(td, "", "文書へ復元");
	bt.setAttribute("onclick", "loadArchive()");
	
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	td.style.paddingLeft = "10px";
	td.style.paddingBottom= "10px";
	var ta = newTEXTAREA(td, "output", 70, 30, archivedStrings());
	
	// 最上部に開いた infoTip が見えないことがあるので最上部へスクロールしておく
	window.scroll(0, 0);
	openFloatPanel(tbl, 15, 65, "アーカイブ表示パネル");
}

function selectedAddress(elm){
    // 入力された文字列でメニュー内容を絞り込む
    var key = elm.value;
    var array = addressee();
    if (key){
        // key があればメニューを key を含むものに絞り込み
        var items = [""];
        for (num in array){
            // key を含むものに絞り込み
            var item = array[num];
            var ary = item.split(key);
            if ((item == key) || (ary.length > 1))
                items.push(item);
        }
    } else
        items = array;
    
    var sp = document.getElementById("addressPopupArea");
    sp.innerHTML = "";
    var address = (args().address) ? args().address : "";
    var pu = makePopupMenu(sp, "addresMenu", items, address);
    pu.setAttribute("onchange", "addressClicked()");
}

function makeDocumentSelector(){
    // 文書選択エリアを生成
    var elm = document.getElementById("headerArea");
    elm.innerHTML = "";

    var div = newDIV(elm, "tool-header");
    
    // -- LEFT ---
    var dv = newDIV(div, "left-side");
    // ラベル
    var sp = newSPAN(dv, "");
    sp.style.padding = "0 3px";
    sp.innerHTML = "文書名";
    // 文書選択ポップアップ
    var docName = (args().documentName) ? args().documentName : "";
    var pu = makePopupMenu(dv, "docMenu", docNames(), docName);
    pu.setAttribute("onchange", "docClicked(this)");
    // 文書名
    var fd = newFIELD(dv, "documentName", "", 30, docName);
    fd.setAttribute("NAME", "documentName"); // form で送られるパラメータ
    // 削除アンカー
    var sp = newSPAN(dv, "");
    sp.style.paddingLeft = "5px";
    var a = newA(sp, "メニューから削除", "#", "");
    a.setAttribute("onclick", "removeDocumentItem()");
    
    // -- RIGHT ---
    var dv = newDIV(div, "right-side");
    // ウインドー・サイズ記憶ボタン
    var img = newIMAGE(dv, "", "zoomfit.png", "zoom");
    img.style.width = "18px";
    img.setAttribute("onclick","putWindowSize()");
    var tx = newTEXT(dv, " ");
    // HELP
    var img = newIMAGE(dv, "", "Help.png", "Help");
    img.style.width = "19px";
    img.setAttribute("onclick","help('docMakerHelp.html')");
}

function makeAdresseeSelector(){
    // 宛先選択エリアを生成
    var items = addressee();
    
    var td = document.getElementById("addressArea");
    td.innerHTML = "";
    var tbl = newTABLE(td, "docTable");
    var tr = newTR(tbl,"","");
    
    var td = newTD(tr, "", "宛　先 ");
    var sp = newSPAN(td, "addressPopupArea");
    var address = (args().address) ? args().address : "";
    var pu = makePopupMenu(sp, "addresMenu", items, address);
    pu.setAttribute("onchange", "addressClicked()");
    
    var fd = newFIELD(td, "addressee", "", 30, address);
    fd.setAttribute("NAME", "addressee"); // form で送られるパラメータ
    fd.setAttribute("onchange", "selectedAddress(this)");
    
    var tx = newTEXT(td, "　");
    var a = newA(td, "メニューから削除", "#", "");
    a.setAttribute("onclick", "removeAddressItem()");
}

function makePatientInfo(){
    // 患者情報エリアの生成
    var elm = document.getElementById("patientArea");
    elm.innerHTML = "";
    var table = newTABLE(elm, "");
    table.style.width = "100%";
    
    var tr = newTR(table, "", "");
    var td = newTD(tr, "", "");
    td.style.fontSize = "9pt";
    var cb = newCHECKBOX(td, "hasPatientInfo", "患者情報表示", 1);
    cb.setAttribute("NAME", "hasPatientInfo"); // form で送られるパラメータ
    cb.setAttribute("onclick", "togglePatientInfo(this)");
    
    // 患者情報エリア
    var tr = newTR(table, "", "");
    var td = newTD(tr, "patientInfoArea", "");
    var tbl = newTABLE(td, "patientInfoTable");
    
    // 氏名
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "", "");
    var name = (patientKanjiName()) ? patientKanjiName() : "";
    var fd = newFIELD(td, "patientName", "氏名", 30, name);
    fd.setAttribute("NAME", "patientName"); // form で送られるパラメータ
    // 性別
    var sx = (sex()) ? sex() : "女";
    var fd = newFIELD(td, "sex", "性別", 4, sx);
    fd.setAttribute("NAME", "sex"); // form で送られるパラメータ
    // 生年月日は西暦で "2008-4-29" 形式のこと
    var bdate = wareki(birthDate());
    var fd = newFIELD(td, "birthDate", "生年月日", 15, bdate);
    fd.setAttribute("NAME", "birthDate"); // form で送られるパラメータ
    // 年令
    var array = birthDate().split("-");
    var anAge = age(array[0],array[1],array[2]);
    var fd = newFIELD(td, "age", "年齢", 3, anAge);
    fd.setAttribute("NAME", "age"); // form で送られるパラメータ
    // 患者住所
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "", "");
    var address = (patientAddress()) ? patientAddress() : "";
    var fd = newFIELD(td, "patientAddress", "住所", 75, address);
    fd.setAttribute("NAME", "patientAddress"); // form で送られるパラメータ
    // 患者電話
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "", "");
    var phone = (patientPhone()) ? patientPhone() : "";
    var fd = newFIELD(td, "patientPhone", "電話", 75, phone);
    fd.setAttribute("NAME", "patientPhone"); // form で送られるパラメータ
}

function makeHospitalInfoArea(){
    // 施設情報エリアの生成
    var elm = document.getElementById("hospitalInfoArea");
    elm.innerHTML = "";
    var table = newTABLE(elm, "");
    table.style.width = "100%";
    var tr = newTR(table, "", "");
    
    // 左エリア
    var dateStatus = timeStampStatus();
    _debug("makeHospitalInfoArea->"+dateStatus); //##
    
    var date = (dateStatus) ? todayAndTime() : currentDate();
    _debug("date->"+date); //##
    
    date = yyyymmdd(date);
    var td = newTD(tr, "", "");
    td.style.verticalAlign = "top";
    var htbl = newTABLE(td, "hospTable");
    htbl.style.fontSize = "11px";
    _debug("makeHospitalInfoArea->"+date); //##
    
    // 日付欄
    var tr2 = newTR(htbl, "", "");
    var td = newTD(tr2, "", "");
    td.style.verticalAlign = "top";
    var fd = newFIELD(td, "timestamp", "", 16, wareki(date));
    fd.setAttribute("NAME", "timestamp"); // form で送られるパラメータ
    var cb = newCHECKBOX(td, "dateCheckBox", "本日の日付に設定", dateStatus);
    cb.setAttribute("onchange","checkToday(this)");
    // フォント指定欄
    var tr2 = newTR(htbl, "", "");
    var td = newTD(tr2, "", "");
    td.style.verticalAlign = "top";
    var cb = newCHECKBOX(td, "isSmallFont", "小さいフォントサイズで印刷", 0);
    cb.setAttribute("NAME", "isSmallFont"); // form で送られるパラメータ
    
    // 右エリア
    var td = newTD(tr, "", "");
    var htbl = newTABLE(td, "hospTable");
    // 施設情報
    var tr = newTR(htbl, "", "");
    var td = newTD(tr, "", "");
    var fd = newFIELD(td, "", "", 40, hospitalName());
    fd.setAttribute("NAME", "hospitalName"); // form で送られるパラメータ
    fd.setAttribute("Readonly","true"); // form で送られるパラメータ
    fd.style.backgroundColor = "#aec";
    var tr = newTR(htbl, "", "");
    var td = newTD(tr, "", "");
    var fd = newFIELD(td, "", "", 40, hospitalAddress());
    fd.setAttribute("NAME", "hospitalAddress"); // form で送られるパラメータ
    fd.setAttribute("Readonly","true"); // form で送られるパラメータ
    fd.style.backgroundColor = "#aec";
    var tr = newTR(htbl, "", "");
    var td = newTD(tr, "", "");
    var fd = newFIELD(td, "", "", 40, "TEL: "+hospitalPhone());
    fd.setAttribute("NAME", "hospitalPhone"); // form で送られるパラメータ
    fd.setAttribute("Readonly","true"); // form で送られるパラメータ
    fd.style.backgroundColor = "#aec";
    var tr = newTR(htbl, "", "");
    var td = newTD(tr, "", "");
    var fd = newFIELD(td, "", "", 40, "FAX: "+hospitalFAX());
    fd.setAttribute("NAME", "hospitalFAX"); // form で送られるパラメータ
    fd.setAttribute("Readonly","true"); // form で送られるパラメータ
    fd.style.backgroundColor = "#aec";
}

function help(html){
	window.open(html,"Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initDocMaker(){
    // 画面を生成
    _initDebug(isDebug()); //##
    _debug("initDocMaker"); //##
    
    // ウインドー・サイズを localStorage から読み込みサイズ調整
    getWindowSize();
	setArguments("");
    
    var base = document.getElementById("base");
    
    // 文書選択エリア   
    var div = newDIV(base, "headerArea");

    // docMaker BODY
    var body = newDIV(base, "docBody");
    body.style.backgroundColor = "#aec";

    // 宛先選択エリア
    var div = newDIV(body, "addressArea");
    div.style.paddingLeft = "5px";
    
    // 患者情報
    var div = newDIV(body, "patientArea");
    
    // 文頭挨拶文
    var div = newDIV(body, "");
    div.innerHTML = "挨拶文";
    div.style.paddingLeft = "5px";
    var div = newDIV(body, "");
    var greetings = (args().greetings) ? args().greetings : "";
    var lines = greetings.split("<br/>");
    greetings = lines.join("\n");
    var ta = newTEXTAREA(div, "greetings", 77, 3, greetings);
    ta.setAttribute("NAME", "greetings"); // form で送られるパラメータ
    ta.style.fontFamily = "times, arial, Helvetica";
    ta.style.fontSize = "10pt";
    ta.style.padding = "5px";
    
    // 本文
    var div = newDIV(body, "");
    div.innerHTML = "本文";
    div.style.paddingLeft = "5px";
    var div = newDIV(body, "");
    var contents = (args().contents) ? args().contents : "";
    
    _debug("contents->"+contents); //##
    
    var lines = contents.split("<br/>");
    contents = lines.join("\n");
    var ta = newTEXTAREA(div, "contents", 77, 25, contents);
    ta.setAttribute("NAME", "contents"); // form で送られるパラメータ
    ta.style.fontFamily = "times, arial, Helvetica";
    ta.style.fontSize = "10pt";
    ta.style.padding = "5px";
    ta.focus();
    
    // 日付・施設情報エリア
    var div = newDIV(body, "");
    var addressTbl = newTABLE(div, "hospitalInfoTable");
    var tr = newTR(addressTbl, "", "");
    var td = newTD(tr, "hospitalInfoArea", "");
    
    // フッター・エリア
    var div = newDIV(base, "tool-footer");
    // --- LEFT SIDE ---------------
    var dv = newDIV(div, "left-side");
    dv.style.position = "relative";
    dv.style.bottom = "2px";
    var bt = newBUTTON(dv, "overWriteButton", "テンプレートへ登録");
    bt.setAttribute("onclick", "overWriteTemplate()");
    var bt = newBUTTON(dv, "", "アーカイブ");
    bt.setAttribute("onclick", "showArchive()");
    var bt = newBUTTON(dv, "", "メールで送付");
    bt.setAttribute("onclick", "postMail()");
    var bt = newBUTTON(dv, "", "カルテへ転記");
    bt.setAttribute("onclick", "sendToNOA()");
    // --- RIGHT SIDE ---------------
    var dv = newDIV(div, "right-side");
    dv.style.position = "relative";
    dv.style.bottom = "2px";
    var bt = newSubmitBUTTON(dv, "submitButton", " 印 刷 ");
    bt.style.display = "none"; // 初期状態では非表示にしておく
    bt.setAttribute("onclick", "printPDF()");
    
    // 欄外エリア
    var div = newDIV(base, "/debugBoxArea");
    // --- LEFT SIDE ---------------
    var dv = newDIV(div, "left-side");
    var sp = newSPAN(dv, "footerLeftArea");
    sp.innerHTML = version();
    sp.style.color = "#aaa";
    // --- LEFT SIDE ---------------
    var dv = newDIV(div, "right-side");
    var cb = newCHECKBOX(dv, "", "debug", docMakerDebug());
    cb.setAttribute("onchange", "setDocMakerDebug(this)");
    
    // 親ウインドーの認識票を読込み、それを元に必要なデータを親から取り寄せる
    getDogTag();
}

function version(){
	return "Ver.130224";
}

