
//////////////////////////////////////
///// Ajax ///////////////////////////

function NRGetChart(owner, patientId, receiver){
    // owner, patientId に関する全てのレコードを返す
    // 同時にアクセス・ログにも patientId を記憶
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = owner;
		array["patientId"] = patientId;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = "./server.php?command=GET_CHART"
		+"&value=" + encodeObject(array);
		
        //alert("NRGetChart ====\n"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

///// Ajax ///////////////////////////
//////////////////////////////////////


/////////////////////////////////////////////////////////////
///// SEARCH ////////////////////////////////////////////////

function jumpTo_key(keyPos){
    // テキスト中の次のキーへカーソル・ジャンプ
    if (overFlowHeight()){
        alert("初期設定で画面スクロール範囲が限定されている場合は次のページへジャンプできません");
        return;
    }
    
    if (_keyPos * 1 > (keyPos * 1 + 1)){
        var fieldId = _keyArray[(keyPos * 1 + 1)]; // 次のフィールド
        var elm = document.getElementById(fieldId);
        
        // 次のヒット・ページの先頭にジャンプ
        var pos = getPosition(elm.parentNode.parentNode);
        
        var y = ((pos.y - 50) > 0) ? pos.y - 50 : 0;
        window.scroll(0, y);
    } else {
        window.scroll(0, 0);
    }
}
function search_record(key){
    // 全レコードの ProgressSection 中を検索
    _keyPos = 0;
    _keyArray = new Array();
    var count = 0;
    
    var records = history();
    for (row in records){
        var entryDate = records[row];
        
        var array = layoutArray(_progress);
        for (num in array){
            var layoutObj = array[num];
            if (layoutObj.hitAndRun * 1) continue; // 非表示セルをスキップ
            
            var tag = layoutObj.tag;
            var val = cell_value(entryDate, tag);
            if (trim(val).length == 0) continue;
            
            val = htmlForValue(val);
            
            var elm = document.getElementById(cellId(entryDate, tag));
            var ary = val.split(key);
            if (ary.length > 1){
                var st = '<span style="background-color:#ff0">';
                st += key + '</span>';
                elm.innerHTML = ary.join(st);
                elm.setAttribute("onclick", "jumpTo_key('" + _keyPos + "')");
                
                // key にマッチした element の id を記憶
                _keyArray[_keyPos++] = entryDate + "_" + tag;
                
                // key に一致した回数をカウント
                count += (ary.length - 1);
            } else {
                elm.innerHTML = val;
            }
        }
    }
    return count;
}

///// SEARCH ////////////////////////////////////////////////
/////////////////////////////////////////////////////////////

function pageScroll_to(dateTime){
    // entryDate のページを画面上端にスクロール
    if (overFlowHeight()){
        alert("初期設定でスクロール範囲が限定されている場合はページ・ジャンプできません");
        return;
    }
    // page フレームの左上端位置が表示されるようスクロール
    var elm = document.getElementById(dateTime + ".contents");
    if (elm){
        var pos = getPosition(elm);
        
        // ページ・ヘッダーがきっかり画面の上端だと心理的にその上を見たい気持ちになるので
        // その上の部分も 170px ほど見えるようにする
        window.scroll(0, pos.y - 170);
        openPage(dateTime);
    } else {
        showFadeoutInfo("alertArea", dateTime + "の行は見つかりません", 800);
    }
}

function open_basic_ditor(date){
    // 基本情報エディターを開く
	window.open("_basicEditor.php", "tools");
}

function closePage(date){
    // ページを閉じる
    var elm = document.getElementById(currentDate() + ".pageFrame");
    elm.style.backgroundColor = "#ccc"; // 過去ページ
    
    var _oldDate = currentDate();
    setCurrentDate(date);
    show_page(_oldDate);
    
    // CELL エディターが開けるようにする
    setCurrentTag(null);
}
function openPage(date){
    // ページを開く
    closePage(date);
    var elm = document.getElementById(date + ".pageFrame");
    elm.style.backgroundColor = "#fff"; // 当日ページ
    
    show_page(date);
}

function show_page(date){
    // 1ページを生成
    // === CONTENTS ===========================
    var td = document.getElementById(date + ".contents");
    td.innerHTML = "";
    
    // === PAGE HEADER ========================
    if (isSameDate(date, currentDate()))
        show_page_header(td, date);
    
    // === FIELDS =============================
    var div = newDIV(td, "");
    var array = layoutArray(_progress);
    for (num in array){
        var rec = array[num];
        if (rec.hitAndRun * 1) continue; // 非表示セル
        
        //var cell = cellFor(date, rec.tag);
        //if (cell && cell.hitAndRun) continue; // 非表示セル
        
        var label = (rec.label) ? rec.label : rec.tag;
        show_cell(div, label, rec.tag, date);
    }

    open_basic_ditor(date);
    
    function show_page_header(elm, entryDate){
        // ページヘッダーを生成
        var elm = document.getElementById(entryDate + ".contents");
        td.innerHTML = "";

        var headerDIv = newDIV(elm, "/pageHeader");
        headerDIv.style.marginRight = "0";
        headerDIv.style.backgroundColor = "#bfd";
        headerDIv.style.borderBottom = "thin solid #ccc";
        
        // === LEFT SIDE ===
        var div = newDIV(headerDIv, "left-side");
        
        // 漢字氏名
        var sp = newSPAN(div, "");
        sp.style.fontSize = "12pt";
        var val = valueForStructure(currentDate(), "NameSection.patientKanjiName");
        sp.innerHTML = val.value;
        
        // かな氏名
        var val = valueForStructure(currentDate(), "NameSection.patientKanaName");
        if (val.value){
            // 他オーナーが登録したカルテを開く場合、自分で登録するまでフリガナは表示されない
            var sp = newSPAN(div, "");
            sp.style.paddingLeft = "10px";
            sp.style.fontFamily = "times, arial, Helvetica";
            sp.innerHTML =　"( " + val.value + " )";
        }
        
        // 診療日の年令
        var dateTime = "9999-12-31 00:00:00";
        var val = valueForStructure(dateTime, "PatientTable.birthDate");
        var birthDate = val.value; // 1942-03-23 型式
        var age = ageAtDate(birthDate, currentDate());
        var sp = newSPAN(div, "");
        sp.style.paddingLeft = "10px";
        sp.style.fontFamily = "times, arial, Helvetica";
        sp.innerHTML =　age + " 才";
         
        // 変更不可チェック
        var sp = newSPAN(div, "readOnlyCheckArea");
        sp.style.paddingLeft = "10px";
        if (isSameDate(entryDate, todayAndTime())){
            // 本日なら無条件に readOnly を否定
            setIsReadOnly(false, currentDate());
        } else {
            // 本日以外なら setIsReadOnly() の判断に任せる
            setIsReadOnly(isReadOnly(), currentDate());
            var num = (isReadOnly()) ? 1 : 0;
            var cb = newCHECKBOX(sp, "readOnlyCheck", "編集不可", num);
            cb.setAttribute("onchange", "clickedReadOnly(this)");
            cb.style.fontSize = "9pt";
        }
        
        // === RIRGHT SIDE ===
        var div = newDIV(headerDIv, "right-side");
        div.style.position = "relative";
        div.style.top = "3px";

        // ページ・メニューを表示
        var array = menuStructure();
        for (num in array){
            var cell = array[num];
            
            if (cell.menuType * 1 != _page) continue;
            if (cell.disabled * 1) continue;
            if (cell.subTitle * 1) continue;
            
            // メニュー項目を生成
            var sp = newSPAN(div, cell.id);
            sp.style.marginLeft = "15px";
            sp.style.fontSize = "10pt";
            // cell.editor に infoTip に表示する内容が入っている
            setInfoTip(cell.id, cell.editor); // HELP
            
            if (cell.icon){
                // ICON があれば ICON を表示
                var img = newIMAGE(sp, "", cell.icon, "icon");
                img.style.height = "15px";
                img.style.verticalAlign = "center";
                var action = "kickMenuCell('" + cell.url + "','" + cell.window +"')";
                img.setAttribute("onclick", action);
                img.setAttribute("class", "expandIcon");
            } else {
                // アンカー表示
                var a = newA(sp, cell.label, "#", "");
                if (cell.url){
                    var action = "kickMenuCell('" + cell.url + "','" + cell.window +"')";
                    a.setAttribute("onclick", action);
                }
            }
        }
        
        // currentDate の付箋があれば開く
        showPostIt(); // postIt.js
    }
    
    function show_cell(elm, label, tag, entryDate){
        // 標準 CELL を表示
        var obj = valueForStructure(entryDate, tag);
        var value = obj.value;
        var isPast = obj.isPast;
        var isCurrentPage = (isSameDate(entryDate, currentDate())) ? true : false;
        if (!isCurrentPage){
            // 本日以外のページでは空欄を表示しない
            if (!value || (trim(value).length == 0)) return;
        }
        
        // コンテンツのフレームを生成
        var tbl = newTABLE(elm, "base-table");
        tbl.style.borderBottom = "thin solid #bbb";
        tbl.style.fontSize = "10pt";
        var tr = newTR(tbl, "", "");
        
        // LABEL
        var td = newTD(tr, "/cellLabel", label);
        td.setAttribute("onclick", "open_editor('" + entryDate + "','" + tag + "')");
        if (isCurrentPage) td.style.backgroundColor = "#bfd";
        
        // VALUE
        var td = newTD(tr, entryDate + "_" + tag, ""); // 日付_タグ 形式
        show_cell_value(entryDate, tag);
    }
}

function show_cell_value(date, tag){
    // CELL の値を表示：CellEditor からも利用
    var td = document.getElementById(date + "_" + tag); // 日付_タグ 形式
    td.innerHTML = "";
    var obj = valueForStructure(date, tag);
    var isPast = obj.isPast;
    var value = (obj.value) ? htmlForValue(obj.value) : "";

    // td は cellEditor と共有するためコンテンツは div で操作
    var div = newDIV(td, "/cellValue");
    div.style.fontSize = cellFontSize()+"pt"; // 初期設定値
    var value = cell_value(date, tag);
    value = htmlForValue(value); 
    div.innerHTML = value;
    div.style.width = "400px"; // basicEditor でも使うので CSS で設定しない
    if (isPast && (date == currentDate()))
        div.style.backgroundColor = "#eff";
}

function show_pages(answer){
    // 全てのページを開く
    var obj = JSON.parse(answer);
    setNoaStructure(obj);
    setCurrentDate(null);
    //alert("show_pages->"+encodeObject(obj)); //##
    
    var elm = document.getElementById("noa-base");
    elm.innerHTML = "";
    var tbl = newTABLE(elm, "base-table");
    var _oldDate;
    var hasTodayPage = false;
    var hasRecord = false; // obj にレコードが存在するか否か
    for (num in obj.ProgressSection){
        var rec = obj.ProgressSection[num];
        var date = rec.date;
        
        // 重複する受診日はスキップ：古いカルテでは受診日が重複していることがある
        if (_oldDate == date) continue;
        _oldDate = date;
        
        if (currentDate() == null) setCurrentDate(date);

        // === PAGE FRAME ==========================
        var tr = newTR(tbl, date + ".pageFrame", "");
        tr.style.borderBottom = "thin solid #aaa";
        tr.style.verticalAlign = "top";
        if (isSameDate(date, currentDate()))
            tr.style.backgroundColor = "#fff"; // 当日ページ
        else
            tr.style.backgroundColor = "#ccc"; // 過去ページ
        
        // === DATE TIME ===========================
        var td = newTD(tr, "/dateLabel", "");
        td.setAttribute("onclick", "openPage('" + date + "')");
        var ary = date.split(" ");
        // === DATE ===
        var dv = newDIV(td, date + ".date");
        dv.innerHTML = ary[0];
        if (isSameDate(date, today())) hasTodayPage = true; // 本日のページが存在
        // === TIME and WEEK ===
        var dv = newDIV(td, "");
        dv.innerHTML = ary[1] + " " + weekOfDate(date);
        dv.style.fontSize = "10pt";
        dv.style.color = "#aaa";

        // === CONTENTS ===========================
        var td = newTD(tr, date + ".contents", "");
        show_page(date); 
        
        // ページが存在した
        hasRecord = true;
    }
    
    if (!hasRecord){
        // カルテに１頁もない場合は自動的に頁追加
        addPage(todayAndTime());
    } else if (_addPageFlag && !hasTodayPage){
        // ポップアップ・タグや受診履歴から開かれ、本日のページがない場合のみ
        addPage(todayAndTime());
    }
}

function open_chart(pid, name, addPageFlag){
	// patienId のカルテを開く
    setPatientId(pid); // patientId を記憶
    setPatientKanjiName(name); // name を記憶
    setCurrentBasicId(null); // 基本情報を表示するエリアの ID
    setEditorId(null); // エディターを閉じた状態にする
    _addPageFlag = (addPageFlag) ? true : false;
    
    // workArea を閉じる
    closeWorkArea();
    closeFloatPanel();
    
    // カルテを開く
    var elm = document.getElementById("pidArea");
    elm.innerHTML = pid.substr(0, 4) + "-" + pid.substr(4);
    setInfoTip("pidArea", "カルテ番号：drag & drop 可能"); // HELP
    
    // カルテID を drag and drop できるようにする
    elm.setAttribute("draggable", "true"); // HTML5: ドラッグ可能にする
    elm.setAttribute("ondragstart", "pid_dragstart(event,'" + pid + "')");
    
    NRGetChart(owner(), pid, show_pages);
}

function init_NOA(){
    setHospitalContainer(); // login.js から localStorage 渡しのパラメータを記憶
    
    var elm = document.getElementById("base");
    elm.innerHTML = "";
    
    // workArea
    var div = newDIV(elm, "workArea");
    // polling でゲットした受診者タブを表示
    var div = newDIV(elm, "pollingArea");
    // メッセージ退避エリア
    var div = newDIV(elm, "messageShelterArea");
    // alertArea
    var div = newDIV(elm, "alertArea");
    
    // === HEADER ===
    var div = newDIV(elm, "title-bar");
    // --- LEFT SIDE ---------------
    // カルテ検索アイコン
    var dv = newDIV(div, "left-side");
    var img = newIMAGE(dv, "addChartIcon", "search.png", "search");
    img.style.height = "18px";
    img.style.position = "relative";
    img.style.bottom = "2px";
    img.setAttribute("onclick", "getFrontList()");
    setInfoTip("addChartIcon", "カルテを検索して開く"); // HELP
    img.setAttribute("class", "expandIcon");
    // patientId
    var sp = newSPAN(dv, "pidArea");
    // --- RIGHT SIDE ---------------
    // 周辺ツール・アイコンを表示するエリア
    var dv = newDIV(div, "right-side");
    var dv = newDIV(dv, "toolIconArea");
    
    // === BODY ===
    var div = newDIV(elm, "noa-base/close-float");
    // 設定された高さを画面スクロール範囲とする
    var val = overFlowHeight();
    if (val >= 100){
        div.style.height = val + "px";
        div.style.overflow = "auto";
    }
    
    // === FOOTER ===
    var div = newDIV(elm, "title-bar");
    // LEFT-SIDE
    var dv = newDIV(div, "left-side");
    dv.innerHTML = hospitalName() + " ( 取扱者 " + userName() + " )";
    // RIGHT-SIDE
    var dv = newDIV(div, "version/right-side");
    dv.innerHTML = version();
    
    // FRONT での新規受付患者をチェック
    polling();
    
    // 初心者用に NOA ヘルプを表示
    if (showHelp() == 0) noaHelp();
    
    // TOOL MENU 構造をサーバへリクエスト
    NRGetToolMenu(owner(), gotToolMenuStructure);
}


