
/////////////////////////////////
///// NOA へ問い合わせて得る値 /////
function _noa(){
    if (window.opener && (window.opener.name == "noa")){
        return window.opener;
    } else if (window.opener && (window.opener.name == "tools")){
        return window.top.noa;
    } else if (window.opener && (window.top.noa)){
        return window.top.noa;
    } else {
        //alert("親として NOA が見つかりません");
        return null;
    }
}

function currentDate(){
    return (_noa() && _noa().currentDate())
    ? _noa().currentDate() : todayAndTime();
}

function elementId(){
    // ReproductiveHistory を読んだ NOA の CellEditor 記入欄の id を返す
    return _noa().editorId() + ".text";
}

function subject(){
    // NOA の subject 欄のデータを返す
    var elm = _noa().document.getElementById(elementId());
    if (elm){
        // NOA の CellEditor が開いている場合
        // valueForTag() を使うと編集結果が反映されない
        return elm.innerHTML;
    } else {
        // NOA の CellEditor が閉じている場合
        return _noa().valueForTag("ProgressSection.subject");
    }
}

function setCalendar(){
    // NOA から起動されていれば妊娠歴を自動設定
    _initDebug(false); //##
    _debug("setCalendar elementId->"+elementId()); //##
    
    if (!_noa()) return;
    
    var buff = subject();
    var year = 0;
    var month = 0;
    var day = 0;
    
    if (buff){
        var array = buff.split("lmp:");
        if (array.length > 1){
            var lmpSt = trim(array[1]);
            if (lmpSt.length >= 6){
                year = "20" + lmpSt.substr(0, 2);
                month = lmpSt.substr(2, 2);
                day = lmpSt.substr(4, 2);
            }
        }
    }
    
    _debug("lmp->"+year+"/"+month+"/"+day); //##
    
    // NOA から起動されたのでなければ何もせずに終了
    if (year * month * day == 0) return;
    
    
    // 最終月経のポップアップを設定
	var td = document.getElementById("lmpArea");
    td.innerHTML = "";
    newDatePopUp(td, "lmp", "", year*1, month*1, day*1, false, dateChanged);
    
    // 予定日を計算
    calc();

    // 計算された予定日を NOA の編集フィールドへ書戻す
    var array = buff.split("lmp:");
    var leftSt = array[0];
    
    _debug("- leftSt->"+leftSt); //##
    
    // "lmp:" から改行までの文字列を予定日変換文字列の対象とするので
    // 最終月経の後ろに文字があっても *** 予定日と置換 *** されてしまう
    var rightSt = array[1];
    rightSt = convertSTRING(rightSt, "<br>", "\n");
    var array2 = rightSt.split("\n");
    array2[0] = document.getElementById("result").innerHTML;
    rightSt = array2.join("\n");
    if (toString.call(elm) == "[object HTMLDivElement]")
        rightSt = convertSTRING(rightSt, "\n", "<br>");
    
    _debug("- rightSt->"+rightSt); //##
    
    var eid = elementId();
    var elm = _noa().document.getElementById(eid);
    if (toString.call(elm) == "[object HTMLDivElement]"){
        elm.innerHTML = pureValue(leftSt + rightSt);
    } else {
        elm.value = pureValue(leftSt + rightSt);
        _noa().fieldChanged(elementId(), false);
    }
}

///// NOA へ問い合わせて得る値 /////
/////////////////////////////////


var _calendarObject;
function setCalendarObject(obj){
    _calendarObject = obj;
}
function calendarObject(){
    return _calendarObject;
}

var _term;
function setTermDate(val){
    // 分娩予定日を記憶
    _term = val;
}
function termDate(){
    // 分娩予定日を "2011-08-28" 形式で返す
    return _term;
}

function lmp(){
	var lmp = document.getElementById("lmp").value;
    var array = lmp.split("-");
	return new Date(array[0], array[1] - 1, array[2]);
}

function now(){
	var today = document.getElementById("today").value;
    var array = today.split("-");
	return new Date(array[0], array[1] - 1, array[2]);
}

function term(lmp){
	var date = new Date();
	date.setTime(lmp.getTime() + (40 * 7 * 24 * 3600 * 1000));
    
	return date;
}

function calendar(lmpTime, nowTime){
    var records = new Array();
    
	// title
    var array = [" "," "];
	for (var d=0; d < 7; d++){
        array.push("　" + d + "d");
    }
    records.push(array);
	var tm = lmpTime;
    
	// calendar
    for (w=0; w < 43; w++){
        var array = new Array();
		if (w % 4 == 0)
            array.push((w / 4 + 1) + "m");
		else
            array.push("");
        array.push(w + "w");
		for (d=0; d < 7; d++){
			var mm = new Date(tm).getMonth() + 1;
			var dd = new Date(tm).getDate();
			if (dd == 1)
                array.push(mm + "/" + dd);
			else
                array.push(dd + "");
			tm += (24 * 3600 * 1000);
		}
        records.push(array);
	}
    
    // calendar オブジェクトを記憶
    setCalendarObject(records);
    
    // 作成した records をカレンダーとして表示
	var elm = document.getElementById("calendar");
	elm.innerHTML="";
	var tbl = newTABLE(elm, "calendarTable");
    
    for (row=0,rows=records.length; row < rows; row++){
        var tr = newTR(tbl, "", "");
        var record = records[row];
        for (col=0,cols=record.length; col < cols; col++){
            var td = newTD(tr, "cell", record[col]);
        }
        td.style.paddingRight = "10px";
    }
}

////////////////////////////////////////////////////////
///// DRAG and DROP ////////////////////////////////////

function f_dragstart(event){
    // ドラッグ開始時の処理
    var st = document.getElementById("lmp").value;
    var array = st.split("-");
    var lmp = "最終月経 " + array[0] + "年 " + array[1] + "月 " + array[2] + "日";
    
    var array = termDate().split("-");
    var term = "推定分娩予定日 " + array[0] + "年 " + array[1] + "月 " + array[2] + "日";
    
    var array = gestateWeekDay();
    var gw = "( 妊娠 " + array[0] + "週 " + array[1] + "日 )";
    
    // DataTransferオブジェクトに転送するデータをセット
    event.dataTransfer.setData("text", lmp + "\n" + term + " " + gw + "\n");
}

function f_dragover(event){
    // ドラッグ要素がドロップ要素に重なっている間の処理
    //　dragoverイベントをキャンセルして、ドロップ先の要素がドロップを受け付けるようにする
    event.preventDefault();
}

///// DRAG and DROP ////////////////////////////////////
////////////////////////////////////////////////////////

function gestateWeekDay(){
    // 妊娠週数・日数の配列を返す
	var lmpTime = lmp().getTime();
	var nowTime = now().getTime();
	var gw = parseInt((nowTime - lmpTime) / (7 * 24 * 3600 * 1000));
	var gd = parseInt((nowTime - lmpTime) % (7 * 24 * 3600 * 1000));
	gd /= parseInt((24 * 3600 * 1000));
    
    var array = new Array();
    array.push(gw);
    array.push(gd);
    return array;
}

function calc(){
    var array = gestateWeekDay();
    var gw = array[0];
    var gd = array[1];
    
    //alert("lmp:"+lmp().getYear()+"/"+(lmp().getMonth())+"/"+lmp().getDate()); //##
    
	var tm = term(lmp());
	var yy = tm.getYear();
	if (yy < 2000) { yy += 1900; }
	var mm = tm.getMonth() + 1;
	if (mm * 1 < 10) mm = "0" + mm;
	var dd = tm.getDate();
	if (dd * 1 < 10) dd = "0" + dd;
	var yymmdd =  yy + "-" + mm + "-" + dd;
    
    setTermDate(yymmdd); // 予定日を記憶
    
    // 予定日の文字列をドラッグ・アンド・ドロップできるようにする
    var td = document.getElementById("result");
	td.innerHTML = "lmp:"+lmpString()+" ("+gw+"w"+gd+"d) Term:"+yymmdd;
    td.setAttribute("draggable", "true"); // HTML5: ドラッグ可能にする
    td.setAttribute("ondragstart", "f_dragstart(event)");
    td.setAttribute("ondragover", "f_dragover(event)");
    
	var lmpTime = lmp().getTime();
	var nowTime = now().getTime();
	calendar(lmpTime, nowTime);
    
    //alert("lmpTime:"+lmpTime+" nowTime"+nowTime); //##
    
    var sp = document.getElementById("printButtonArea");
    var bt = newDIV(sp, "/whiteButton");
    bt.innerHTML = "印刷";
    bt.setAttribute("onclick", "print()");
    bt.style.padding = "5px 16px 2px 16px";
    bt.style.position = "relative";
    bt.style.top = "4px";
    
    
	
	function lmpString(){
		var lmp = document.getElementById("lmp").value;
        var array = lmp.split("-");
        var yyyy = array[0];
		var mm = array[1] * 1;
		if (mm < 10) mm = "0" + mm;
		var dd = array[2] * 1;
		if (dd < 10) dd = "0" + dd;
		return yyyy.substr(2,2) + mm + dd;
	}
}

function print(){
    // 妊娠歴を印刷
	var lmp = document.getElementById("lmp").value;
    var buff = "";
    var records = calendarObject();
    for (row in records){
        var record = records[row];
        var ln = record.join(",");
        buff += ln + ";";
    }
    buff += "分娩予定日は " + termDate() + " と推定されます。;";
    buff += "ただし、これは大体の「めやす」です。;";
    buff += "前後２週間ほどの巾があるとお考えください。;";
    
    //alert(buff); //##
	var url = "./print.php?value="+encodeSTRING(buff);
	var win = window.open(url, "GC", "scrollbars=yes");
	win.document.title = "PRINT GC"; // window title に表示
	win.focus();
}

function dateChanged(){
    var sp = document.getElementById("printButtonArea");
    if (sp) sp.innerHTML = "";
}

function rhHelp(){
	window.open("./rhHelp.html","Help"
				,"width=500,height=700,scrollbars=yes,resizable=yes");
}

function init(){
	var elm = document.getElementById("base");
    elm.style.fontSize = "10pt";
    
    // === HEADER ==================
    var div = newDIV(elm, "tool-header");
    var dv = newDIV(div, "/left-side");
    dv.innerHTML = "妊娠歴";
    var dv = newDIV(div, "/right-side");
	var im = newIMAGE(dv, "", "./Help.png", "?");
	im.setAttribute("onclick", "rhHelp()");
	im.style.height = "17px";
	im.style.position = "relative";
	im.style.top = "2px";
    
    // === 最終月経 =================
    var div = newDIV(elm, "");
    div.style.padding = "10px 0 0 10px";
    var sp = newSPAN(div, "");
    sp.innerHTML = "最終月経";
    sp.style.padding = "0 5px";
    var sp = newSPAN(div, "lmpArea");
	var date = new Date();
	date.setTime(date.getTime() - (5 * 7 * 24 * 3600 * 1000));
	var yy = date.getYear();
	var mm = date.getMonth() + 1;
	var dd = date.getDate();
	if (yy < 2000) { yy += 1900; }
    newDatePopUp(sp, "lmp", "", yy, mm, dd, false, dateChanged);
    
    // === 本日 ====================
    var div = newDIV(elm, "");
    div.style.padding = "0 0 10px 10px";
    var sp = newSPAN(div, "");
    sp.innerHTML = "本日　　";
    sp.style.padding = "0 5px";
    var sp = newSPAN(div, "");
    var dateTime = currentDate();
    var ary = dateTime.split(" ");
    var ary2 = ary[0].split("-");
	var yy = ary2[0];
	var mm = ary2[1];
	var dd = ary2[2];
    newDatePopUp(sp, "today", "", yy, mm, dd, false, dateChanged);
    
    // === 予定日 ====================
    var div = newDIV(elm, "/clearfix");
    div.style.padding = "0 0 10px 10px";
    var bt = newDIV(div, "/whiteButton");
    bt.innerHTML = "予定日";
	bt.setAttribute("onclick", "calc()");
    bt.style.padding = "6px 10px 3px 10px";
    var sp = newSPAN(div, "result", "");
    
    // === FOOTER ====================
    var div = newDIV(elm, "tool-footer");
    var dv = newDIV(div, "/left-side");
    var sp = newSPAN(dv, "printButtonArea");
    var dv = newDIV(div, "/right-side");
    dv.innerHTML = version();
	dv.style.position = "relative";
	dv.style.top = "3px";
    
    // === カレンダー表示エリア =========
    var dv = newDIV(elm, "calendar");
    
    // NOA から起動されていれば妊娠歴を自動設定
    setCalendar();
}

function version(){
    return "Ver.130501";
}
