
function weeks(){
	return ["日","月","火","水","木","金","土"];
}

function setColor(element, color, bgcolor){
	element.style.backgroundColor=bgcolor;
	element.style.color=color;
}

function resetColor(element, color, bgcolor){
	element.style.backgroundColor=bgcolor;
	element.style.color=color;
}

function createXMLHttpRequest(func){
	var xmlHttpObject = null;
	
	if (window.XMLHttpRequest){ // Safari, Firefox
		xmlHttpObject = new XMLHttpRequest();
	} else if (window.ActieXObject){ // IE
		try{
			xmlHttpObject = new ActiveXObject("Msxml2.XMLHTTP"); // IE6
		} catch(e){
			try{
				xmlHttpObject = new ActiveXObject("Microsoft.XMLHTTP"); // IE5
			} catch(e){
				return null;
			}
		}
	}
	
	// xmlHttpObject が生成できたら、状態が変わった時に func が実行される
	if (xmlHttpObject) xmlHttpObject.onreadystatechange = func;
	return xmlHttpObject;
}

function encodeSTRING(value){
	// #, &, +  < > などが URI 送信で化けるため encode して送る
	if (value.length == 0) return value;
	value = convertSTRING(value, "#", "%x0;");
	value = convertSTRING(value, "&", "%x1;");
	value = convertSTRING(value, "+", "%x2;");
	value = convertSTRING(value, "<", "%x3;");
	value = convertSTRING(value, ">", "%x4;");
	value = convertSTRING(value, " ", "%x5;");
	value = convertSTRING(value, "\n", "%x6;");
	value = convertSTRING(value, "\"", "%x7;");
	value = convertSTRING(value, "$", "%x8;");
	/*
	 var array = val.split("#");
	 val = array.join("%x0;");
	 array = val.split("&");
	 val = array.join("%x1;");
	 array = val.split("+");
	 val = array.join("%x2;");
	 array = val.split("<");
	 val = array.join("%x3;");
	 array = val.split(">");
	 val = array.join("%x4;");
	 array = val.split(" ");
	 val = array.join("%x5;");
	 array = val.split("\n");
	 val = array.join("%x6;");
	 array = val.split("\"");
	 val = array.join("%x7;");
	 array = val.split("$");
	 val = array.join("%x8;");
	 //array = val.split('\"');
	 //val = array.join("%x9;");*/
	return value;
}
function decodeSTRING(value){
	// #, &, +  < > などが URI 送信で化けるため encode して送られたものを decode
	value = convertSTRING(value, "%x0;", "#");
	value = convertSTRING(value, "%x1;", "&");
	value = convertSTRING(value, "%x2;", "+");
	value = convertSTRING(value, "%x3;", "<");
	value = convertSTRING(value, "%x4;", ">");
	value = convertSTRING(value, "%x5;", " ");
	value = convertSTRING(value, "%x6;", "\n");
	value = convertSTRING(value, "%x7;", "\"");
	value = convertSTRING(value, "%x8;", "$");
	/*
	 var array = val.split("%x0;");
	 val = array.join("#");
	 var array = val.split("%x1;");
	 val = array.join("&");
	 var array = val.split("%x2;");
	 val = array.join("+");
	 var array = val.split("%x3;");
	 val = array.join("<");
	 var array = val.split("%x4;");
	 val = array.join(">");
	 var array = val.split("%x5;");
	 val = array.join(" ");
	 var array = val.split("%x6;");
	 val = array.join("\n");
	 var array = val.split("%x7;");
	 val = array.join("\"");
	 */
	return value;
}

function isSame(st1, st2){
	return ((st1.length == st2.length) && (st1.indexOf(st2) == 0)) ? 1 : 0;
}

function trim(value){
	// 文字列両端の 空白相当文字 を削除
	for (var i=0, len =value.length; i < len; i++){
		var ch = value.charAt(i);
		if ((ch == " ") || (ch == "　") || (ch == "\n")
			|| (ch == "\r") || (ch == "\t")) continue;
		break;
	}
	value = value.substring(i);
	for (var i=value.length-1; i >= 0; i--){
		var ch = value.charAt(i);
		if ((ch == " ") || (ch == "　") || (ch == "\n")
			|| (ch == "\r") || (ch == "\t")) continue;
		break;
	}
	return value.substr(0, i+1);
}

function trimDoubleQuotation(value){
	if (value.charAt(0) == "\"") value = value.substring(1);
	if (value.charAt(value.length-1) == "\"")
		value = value.substring(0, value.length-1);
	
	return value;
}

function convertSTRING(buff, from, to){
	// buff 中の from 文字すべてを to 文字に変換する
	if (!buff || (buff.length == 0)) return buff;
	buff = buff + ""; // 文字列にしておく必要あり
	if (buff.length == 0) return buff;
	
	var array = buff.split(from);
	if (array.length > 1) buff = array.join(to);
	return buff;
}

var _leftbrackets = "^[^"; // encode 中で使う '('
var _rightbrackets = "^]^"; // encode 中で使う ')'
function encodeObject(obj){
	// obj を "key(value)" の文字列に encode して返す -- NOA format と呼ぶ
	// encode 方法として JSON 形式その他が考えられるが NOA format が最も軽いので採用
	// ### 現状では配列はサポートしていない
	var buff = "";
	for (key in obj){
		var value = obj[key];
		if (typeof(value) == "object"){
			buff += key + "(" + encodeObject(value) +")";
		} else {
			// "(", ")" は特定文字にしておく（ decode する時に元へ戻す）
			value = convertSTRING(value, "(", _leftbrackets);
			value = convertSTRING(value, ")", _rightbrackets);
			
			buff += key + "(" + value +")";
		}
	}
	return buff;
}
function decodeObject(buff){
	// "key(value)" 形式の文字列を OBJECT に decode して返す
	var obj = new Object();
	var len = buff.length, begin, end;
	var key, value;
	for (var p=begin=nest=0; p < len; p++){
		var ch = buff.charAt(p);
		if (ch == '('){
			if (nest == 0){
				key = trim(buff.substring(begin, p)); // key 終端
				begin = p + 1; // value 開始位置
			}
			nest++;
		} else if (ch == ')'){
			if (--nest == 0){
				if (nest == 0){
					value = buff.substring(begin, p); // value 終端:trim しない
					begin = p + 1; // key 開始位置
				}
				
				if (value.indexOf(")") > 0){ // まだ入れ子になっているなら
					obj[key] = decodeObject(value);
				} else {
					// 特定文字を "(", ")" へ戻す
					value = convertSTRING(value, _leftbrackets, "(");
					value = convertSTRING(value, _rightbrackets, ")");
					
					obj[key] = value;
				}
			}
		}
	}
	return obj;
}

function stringWithDate(date){
	// Date() を "2008-05-04 16:35:00" のような文字列にして返す
	var yy = date.getYear();
	var mm = date.getMonth() + 1;
	var dd = date.getDate();
	if (yy < 2000) { yy += 1900; }
	if (mm < 10) { mm = "0" + mm; }
	if (dd < 10) { dd = "0" + dd; }
	hr = date.getHours();
	if (hr < 10) { hr = "0" + hr; }
	mn = date.getMinutes();
	if (mn < 10) { mn = "0" + mn; }
	sc = date.getSeconds();
	if (sc < 10) { sc = "0" + sc; }
	return yy + "-" + mm + "-" + dd + " " + hr + ":" + mn + ":" + sc;
}

function todayAndTime(){
	// 現在の時刻を "2008-05-04 16:35:00" のような文字列にして返す
	return stringWithDate(new Date());
}

function dateTimeArray(dateTime){
    // "2013-01-29 13:43:00" を配列にして返す
    // "2013-01-29" の場合は時刻 "00:00:00" 相当になる
    var results = new Array();
    var array = dateTime.split(" ");
    var date = array[0];
    var ary = date.split("-");
    results.push(ary[0]); // yyyy
    results.push(ary[1]); // mm
    results.push(ary[2]); // dd
    
    if (array.length > 1){
        var time = array[1];
        var ary = time.split(":");
        results.push(ary[0]); // hour
        results.push(ary[1]); // min
        results.push(ary[2]); // sec
    } else {
        results.push("00"); // hour
        results.push("00"); // min
        results.push("00"); // sec
    }
    return results;
}

function dateOfDateTime(datetime){
	// "2010-01-30 17:07:02" のような文字列から "2010-01-30" を返す
	var array = datetime.split(" ");
	return array[0];
}
function yearOfDateTime(datetime){
	// "2010-01-30 17:07:02" のような文字列から "2010" を返す
	var date = dateOfDateTime(datetime);
	var array = date.split("-");
	return array[0] * 1;
}
function monthOfDateTime(datetime){
	// "2010-01-30 17:07:02" のような文字列から 1 を返す
	var date = dateOfDateTime(datetime);
	var array = date.split("-");
	return (array.length > 2) ? array[1] * 1 : 0;
}
function dayOfDateTime(datetime){
	// "2010-01-30 17:07:02" のような文字列から 30 を返す
	var date = dateOfDateTime(datetime);
	var array = date.split("-");
	return (array.length > 2) ? array[2] * 1 : 0;
}
function timeOfDateTime(datetime){
	// "2010-01-30 17:07:02" のような文字列から "17:07:02" を返す
	var array = datetime.split(" ");
	return (array.length > 1) ? array[1] : "00:00:00";
}
function hourOfDateTime(datetime){
	// "2010-01-30 17:07:02" のような文字列から 17 を返す
	var time = timeOfDateTime(datetime);
	var array = time.split(":");
	return array[0];
}
function minutesOfDateTime(datetime){
	// "2010-01-30 17:07:02" のような文字列から 7 を返す
	var time = timeOfDateTime(datetime);
	var array = time.split(":");
	return (array.length > 2) ? array[1] * 1 : 0;
}
function secondOfDateTime(datetime){
	// "2010-01-30 17:07:02" のような文字列から 2 を返す
	var time = timeOfDateTime(datetime);
	var array = time.split(":");
	return (array.length > 2) ? array[2] * 1 : 0;
}

