
/////////////////////////
///// カルテからの継承値 ///

function noa(){
    if (window.opener.name == "noa"){
        return window.opener;
    } else if (window.opener.name == "tools"){
        return window.top.noa;
    } else if (window.top.noa){
        return window.top.noa;
    } else {
        alert("ERROR *** panelEditor: window.opener としての NOA が見つかりません");
        return null;
    }
}

function owner(){
    return noa().owner();
}

function patient_id(){
    return noa().patient_id();
}

function patientKanjiName(){
    return noa().patientKanjiName();
}

function currentDate(){
    return noa().currentDate();
}

function timeLimit(){
    return noa().timeLimit();
}

function setCurrentTag(tag){
    noa().setCurrentTag(tag);
}
function currentTag(){
    return noa().currentTag();
}

///// カルテからの継承値 ///
/////////////////////////


//////////////////////////////////////////////////////
///// EDITOR /////////////////////////////////////////

function open_cellPreference(){
	window.open("cellPreference.php?tag=" + currentTag(), "tools");
    
    // PanelCellEditor を抜けるので editorId を初期化する必要あり
    setCurrentTag(null);
}

function remove_BasicValue(){
    // 編集内容を空にする
    var elm = document.getElementById(currentTag() + ".text");
    elm.value = " ";
    elm.focus();
}

function cleard_basicValue(answer){
    //alert(answer); //##
    var obj = JSON.parse(answer);
    setCurrentTag(null);
    
    //alert("->"+encodeObject(obj)); //##
    
    // カルテを再表示
    noa().open_chart(obj.patientId, patientKanjiName());
}
function clear_basicValue(){
    // 編集内容を削除し前回受診時の記述が透けて見えるようにする
    var obj = new Object();
    obj[currentTag()] = "";
    var limit = timeLimit();
    alert("->"+encodeObject(obj)+"->"+limit); //##
    
    NRPutPage(owner(),patient_id(),currentDate(),limit,obj,cleard_basicValue);
}

function show_map(address){
	// eid のフィールドに表示された住所で Google Maps を開く
	var href = 'http://maps.google.co.jp/?hl=ja&q='+encodeURI(address);
	var win = window.open(href,"maps","scrollbars=yes");
	win.focus();
}

function show_cell_basicValue(date, tag, value){
    // CELL の値を表示：CellEditor からも利用
    var isPast = false;
    if (!value){
        var obj = noa().valueForStructure(date, tag);
        isPast = obj.isPast;
        value = (obj.value) ? htmlForValue(obj.value) : "";
    }
    
    var td = document.getElementById(date + "_" + tag); // 日付_タグ 形式
    td.innerHTML = "";
    // td に直接 value を表示させる型式だと、文字色など td に設定した属性が value
    // 以外にも反映してしまうので、value は span 上に表示させ、そちらに属性を設定
    var span = newSPAN(td, "");
    span.innerHTML = value;
    span.style.padding = "2px 5px";
    if (isPast)
        span.style.backgroundColor = "#eff";
    else
        span.style.backgroundColor = "#fff";
    
    // cell 属性に文字色・背景色があるなら着色
    var obj1 = noa().fieldForTag(tag);
    if (obj1){
        if (obj1.bgcolor) span.style.backgroundColor = obj1.bgcolor;
        if (obj1.color) span.style.color = obj1.color;
    }
    
    // 住所欄ならクリックで Google map を開く
    if (tag == "AddressSection.address"){
        // クリックで「Google maps」を開く
        span.setAttribute("class", "showMapElement");
        span.setAttribute("onclick", "show_map('" + trim(value) + "')");
    }
}

var _tag;
var _jump;
function jump_basic(){
    // 次欄のエディターを開く
    _jump = false;

    var ntag = nextTag(_tag);
    if (ntag){
        setCurrentTag(ntag);
        if (noa().menuForTag(ntag)){ // menu が記憶されていれば直ちに CellEditor を開く
            show_basicEditor(ntag);
        } else { // tag 用 menu が記憶されていなければ DB から取り寄せ CellEditor を開く
            // setCurrentTag() はあくまでも "AddressSection.address"
            if (ntag == "AddressSection.address") ntag = "都道府県";
            
            NRGetMenu(owner(), ntag, got_basicMenu);
        }
    } else {
        noa().showFadeoutInfo("alertArea", _tag + " の次の欄はありません", 800);
        
        // 再度このエディターを開けるようにするため currentTag() を null にしておく
        setCurrentTag(null);
    }
    
    function nextTag(targetTag){
        // targetTag の次の tag を返す
        var found = false;
        var array = noa().layoutArray(_basic);
        
        for (num in array){
            var rec = array[num];
            
            if (rec.hitAndRun * 1 > 0) continue; // 不可視欄はスキップ
            if (found) return rec.tag;
            if (rec.tag == targetTag) found = true;
        }
        return null;
    }
}
function saved_basicEditor(answer){
    // サーバから受け取った更新値で noaStructure() を更新
    
    if (_jump)
        jump_basic(); // ジャンプが指定されていれば次の編集欄へジャンプ
    else
        setCurrentTag(null); // CELL エディターを開けるよう準備
}
function close_and_save_basicEditor(jump){
    // 内容を保存し CELL エディターを閉じ通常表示にする
    var cTag = currentTag();
    _jump = (jump) ? true : false;
    
    // 編集内容が更新されていれば保存
    var obj = noa().valueForStructure(currentDate(), cTag);
    var oldVal = (obj.value) ? obj.value : "";
    var newVal = document.getElementById(cTag + ".text").value; // 文章
    
    if (newVal && (oldVal != newVal)){
        // 編集画面の値が以前の CELL の値と異なるならサーバへ保存
        var msg = "==== save_basicEditor: old<br>"+oldVal+"<br>==== new<br>"+newVal;
        noa()._showAlert(msg);
        
        // value エリアを通常表示にする
        noa().setValueForStructure(currentDate(), cTag, newVal);
        show_cell_basicValue(currentDate(), cTag, newVal);
        
        // 変更内容をサーバへ送る：saved_editor() でサーバから結果を CELL へ書き戻す
        var obj = new Object();
        obj[cTag] = newVal; // 編集されたデータ
        NRPutPage(owner(),patient_id(),currentDate(),timeLimit(),obj,saved_basicEditor);
    } else {
        document.getElementById("_debug").innerHTML = "";
        
        // value エリアを通常表示にする
        show_cell_basicValue(currentDate(), cTag);
        
        if (_jump)
            jump_basic(); // ジャンプが指定されていれば次の編集欄へジャンプ
        else
            setCurrentTag(null); // CELL エディターを開けるよう準備
    }
}

function close_basicEditor(){
    // CELL エディターを閉じて通常表示にする
    show_cell_basicValue(currentDate(), currentTag());
    
    // 再度このエディターを開けるようにするため currentTag() を null にしておく
    setCurrentTag(null);
}

function insert_basicMenuItem(item){
    // メニューの選択内容が変更された
    if (item == "...その他"){
        //        addMenu();
        return;
    }
    
//    _debug("insert_basicMenuItem->"+_tag+" currentTag->"+currentTag()); //##
    
    // フィールドの種類により item をモディファイ
    // ProgressSection.treatment などの場合は年月日をつける
	// ## item 自体を変更すると最後の increment_freq() で
	// ## 新規登録されてしまうので menuItem に名称を変え使用する
    var menuItem = modifyItem(currentTag(), item);
    
	// 選択されたアイテムを文中に挿入
    var elm = document.getElementById(currentTag() + ".text"); // 文章
    var value = elm.value;
    var field = fieldForTag(currentTag());
	if (pureSize(value) == 0){ // 入力先が空欄の場合
		value = menuItem;
	} else {
		switch (field.menuAction * 1){ // insert position
			case _menu_to_tail_: // 0: 文末へ追加
				value = value + " " + menuItem;
				break;
			case _menu_to_last_row_: // 1: 最終行へ追加
				value = value + "\n" + menuItem;
				break;
			default: // 2 _menu_replace_: 置換
				value = menuItem;
				break;
		}
	}
    elm.value = value;
    
    // 使用されたメニュー項目の頻度を increment
    increment_freq(currentTag(), item, "");
    
    // 編集内容を保存しエディターを閉じる
    var field = fieldForTag(currentTag());

    if (field.buttonType * 1 > 0)
        close_and_save_basicEditor(true); // 一回のみ選択なら次 CELL へジャンプ
    else
        close_and_save_basicEditor();
    
    function pureSize(html){
        // HTML をプレーンテキストにした trim サイズ を返す
        var doc = htmlForValue(html); // "<br>" を "\n" へ変換
        doc = convertSTRING(doc, "&nbsp;", "");
        
        return trim(doc).length;
    }
}
function basicPopup_chaged(elm){
    // ポップアップメニューが選択された
    var item = elm.value;
    
    insert_basicMenuItem(item);
}

function date_changed(answer){
    // newDatePopUp() の操作で返される '2012-07-15' のような answer
    var elm = document.getElementById(currentTag() + ".text"); // 文章
    
    // まだ elm が生成されたいないうちに動作することがある
    if (elm) elm.value = answer;
}

function show_basicMenu(menuType){
    // メニューを生成
//    _debug("show_basicMenu->"+currentTag()); //##
    
    var elm = document.getElementById("menuArea");
    var menus = noa().menuForTag(currentTag());
    var tag = currentTag();
    switch (menuType){
        case _address_:
            // ### menus() に挿入すると menus() が変化してしまうのでコピー作成
            var items = new Array();
            for (num in menus) items.push(menus[num]);
            
            var value = document.getElementById(currentTag()+".text").value;
            var addressArray = value.split(" ");
            var prefecture = addressArray[0];
            
            // 都道府県ポップメニュー・エリア
            var span = newSPAN(elm, "addressPopArea");
            span.innerHTML = "";
            var sp = newSPAN(span, "_prefecture");
            var popup = makePopupMenu(sp, "prefPop", items, prefecture);
            // 都道府県 が変更されたら 市区 のメニューを取り寄せる
            popup.setAttribute("onchange", "get_CITY(this)");
            
            // 市区・町村ポップアップメニュー・エリア
            var sp = newSPAN(span, "_shiku");
            var sp = newSPAN(span, "_chouson");
            get_CITY(popup);
            break;
        case _date_:
            var yy = "";
            var mm = "";
            var dd = "";
            var value = document.getElementById(currentTag()+".text").value;
            if (value && value.length){
                var dateArray = value.split("-");
                yy = dateArray[0];
                mm = (dateArray.length > 1) ? dateArray[1] : "";
                dd = (dateArray.length > 2) ? dateArray[2] : "";
            }
            // 年月日ボタン表示エリア
            var sp = newSPAN(elm, "");
            var cid = editorId() + ".hidden"; // 隠しフィールドの ID
            newDatePopUp(sp, cid, "平成", yy, mm, dd, false, date_changed);
            break;
        case _panel_:
            var elm = document.getElementById("panelMenuArea");
            elm.style.fontSize = "9pt";
            elm.style.paddingBottom = "10px";
            for (num in menus){
                var item = menus[num];
                if (item.length == 0) continue;
                
                var sp = newDIV(elm, "/blueButton");
                sp.innerHTML = item;
                sp.setAttribute("onclick", "insert_basicMenuItem('"+item+"')");
            }
            break;
        case _rotary_:
            // ポップアップ・メニュー
            var sp = newSPAN(elm, "menuPopArea");
            sp.style.paddingRight = "3px";
            var pu = makePopupMenu(sp, "menuPop", menus, "");
            pu.setAttribute("onchange", "basicPopup_chaged(this)");
            // 絞り込み
            var fd = newFIELD(elm, "focusF", "", 10, "");
            fd.setAttribute("placeholder", "絞り込み"); // 入力ヒントを表示
            fd.setAttribute("onkeyup", "focusPressed()");
            break;
        case _none_:
        case _calendar_:
        default:
            break;
    }
}

function check_returnKey(tag){
    // CTRL-j が入力されたら saveJumpEditor() を実行
    //alert(window.event.keyCode);
    
    if (! arrowKeyJump()) return;
    
    // 13:return 16:shift 17:ctrl 18:alt
    // 37:left-arrow 38:up-arrow 39:right-arrow 40:down-arrow
    // 74:ctrl-j 78:ctrl-n
    // 91:command-left 93:command-right
    //if (window.event.keyCode == 13){ // return-key 漢字変換で反応してしまう
    if (window.event.ctrlKey){
        if (window.event.keyCode == 74){ // CTRL-J
            close_and_save_basicEditor('jump');
        }
    }
}

function show_basicEditor(tag, value){
    // CELL エディターを生成
    // read-only なら警告表示のみ
    var field = fieldForTag(tag);
    if (field.disabled > 0){
        alert("この欄は参照のみで編集はできません");
        setCurrentTag(null);
        return;
    }
    
    // CELL エディターを開いた時点で _tag を記憶
    _tag = tag;
    
//    _debug("show_basicEditor->"+tag+" _tag->"+_tag+" currentTag->"+currentTag()); //##
    
    // elm: CELL VALUE 表示エレメント
    var elm = document.getElementById(currentDate() + "_" + tag);
    elm.innerHTML = "";

    // === EDITOR の背景を生成 ===============
    var editorBase = newDIV(elm, "");
    editorBase.style.backgroundColor = "#ffd";
    editorBase.style.padding = "5px 5px";
    
    // === HEADER ==========================
    var div = newDIV(editorBase, "/clearfix");
    // === LEFT SIDE ==========
    var dv = newDIV(div, "/left-side", "");
    dv.style.width = "70%";
    // REMOVE ICON
    var sp = newSPAN(dv, "removeFieldTip");
    sp.style.paddingRight = "8px";
    setInfoTip("removeFieldTip", "空欄にする"); // HELP
    var img = newIMAGE(sp, "", "./remove-field.png", "X");
    img.style.height = "12px";
    img.setAttribute("onclick", "remove_BasicValue()");
    // CLEAR ICON
    var sp = newSPAN(dv, "clearFieldTip");
    sp.style.paddingRight = "8px";
    setInfoTip("clearFieldTip", "前回記述が透けて見えるようにする"); // HELP
    var img = newIMAGE(sp, "", "./selection.png", "X");
    img.style.height = "12px";
    img.setAttribute("onclick", "clear_basicValue()");
    
    // === RIGHT SIDE ===========
    var dv = newDIV(div, "/right-side", "");
    // PREFERENCE ICON
    var sp = newSPAN(dv, "fieldPrefTip");
    setInfoTip("fieldPrefTip", "初期設定"); // HELP
    var img = newIMAGE(sp, "", "./hammer.png", "X");
    img.style.height = "12px";
    img.setAttribute("onclick", "open_cellPreference()");
    // HELP ICON
    var sp = newSPAN(dv, "helpTip");
    setInfoTip("helpTip", "HELP"); // HELP
    sp.style.paddingLeft = "2px";
    var img = newIMAGE(sp, "", "./Help.png", "help");
    img.style.height = "16px";
    img.setAttribute("onclick", "cellEditorHelp('" + field.menuType * 1 + "')");
    
    // POPUP MENU
    var dv = newDIV(editorBase, "menuArea");
    var dv = newDIV(editorBase, "panelMenuArea");
    
    // === BODY ==================================
    // value が指定されていなければ tag に対応する値を使う
    if (!value) value = noa().cell_value(currentDate(), tag);
    var dv = newDIV(editorBase, "");
    switch (field.fieldType * 1){
        case 0: // FIELD type
            var fd = newFIELD(dv, tag + ".text", "", 45, value);
            fd.setAttribute("onkeyup", "check_returnKey('" + tag + "')");
            // 文末にカーソルを置く
            fd.focus();
            var sel = window.getSelection();
            sel.collapseToEnd();
            break;
        case 1: // TEXT type
            var fd = newTEXTAREA(dv, tag+".text", 32, 5, value);
            fd.setAttribute("onkeyup", "check_returnKey('" + tag + "')");
            // 入力欄の末尾にカーソル移動
            fd.setSelectionRange(value.length, value.length);
            break;
    }
    
    // FOOTER ====================================
    var div = newDIV(editorBase, "");
    var dv = newDIV(div, "");
    dv.style.textAlign = "right";
    dv.style.paddingTop = "7px";
    dv.style.paddingRight = "5px";
    
    // メニューの確定ボタン
    var bt = newDIV(dv, "/whiteButton");
    bt.innerHTML = "とりやめ";
    bt.setAttribute("onclick", "close_basicEditor()");
    var bt = newDIV(dv, "/whiteButton");
    bt.innerHTML = " 確定 ";
    bt.setAttribute("onclick", "close_and_save_basicEditor()");
    var bt = newDIV(dv, "/whiteButton");
    bt.innerHTML = " 確定し次欄へ ";
    bt.setAttribute("onclick", "close_and_save_basicEditor('jump')");
    
    // セル編集ペーンがスクロール・アウトしないようにする
    var pos = getPosition(bt);
    if (pos.y > window.innerHeight - 50) window.scroll(0, pos.y + 50);
    
    // ポップアップメニューなどを生成
    show_basicMenu(field.menuType * 1);
}

function close_warm_and_open_basic(entryDate, tag){
    // 警告ペーンを閉じて、チェックボックスを「編集可」状態にし CELL エディターを開く
    closeWarm();
    noa().removeCheck(); // 編集不可のチェックをはずす
    
    open_basicEditor(tag);
}

function got_basicMenu(answer){
    // メニュー属性をサーバから受け取り CELL に設定
    // obj=[{"menu":"下腹痛","value":"","public":"","freq":"55","menu":"下腹痛"},,,]
    // obj は freq で降順ソートされている
    // メニューデータ obj は記憶せず使い捨て
    var obj = JSON.parse(answer);
    
    var menus = [""];
    for (num in obj){
        var rec = obj[num];
        if (rec.menu.length)
            menus.push(rec.menu);
    }
    menus.push("...その他");
    
    noa().setMenuForTag(menus, currentTag()); // メニューを記憶
    show_basicEditor(currentTag()); // CellEditor を開く
}

function open_basicEditor(tag, value){
    // CELL EDITOR を開く：value があれば cell.htmlValue でなく value を編集内容とする
    var dateTime = currentDate();
    
//    _debug("open_basicEditor->"+tag+" currentTag()->"+currentTag()); //##
    
    // close_and_save_basicEditor() で null になる前に記憶: まだ _tag に記憶しない
    var cTag = currentTag();
    
    if (currentTag())
        close_and_save_basicEditor(); // 開いていた CELL を閉じ setCurrentTag(null)
    
    if (tag == cTag){
        // いま閉じた CELL と同じ CELL なので、何もせず対象 tag を消去
        setCurrentTag(null);
    } else {
        var el = document.getElementById("_alerm");
        if (el.style.visibility == "visible"){
            // すでに警告パネルが開いているなら警告パネルを閉じるだけで終了
            closeWarm();
            return;
        } else if (noa().isReadOnly()){
            // readOnly モードなら警告パネルを開くだけで終了
            var node = document.getElementById(dateTime+"_"+tag);
            var pos = getPosition(node);
            var y = pos.y + 30;
            openWarm("close_warm_and_open_basic('" + dateTime+"','"+tag + "')", y);
            return;
        }
      
        // いま閉じた CELL が開こうとした CELL と異なるので新たにエディターを開く
        setCurrentTag(tag);
        var field = fieldForTag(tag);
        if (field.menuType * 1 == _none_){
            // メニュー無しなら直ちに CellEditor を開く
            show_basicEditor(tag, value);
        } else if (noa().menuForTag(tag)){
            // menu が記憶されていれば直ちに CellEditor を開く
            show_basicEditor(tag, value);
        } else { // tag 用 menu が記憶されていなければ DB から取り寄せ CellEditor を開く
            // setCurrentTag() はあくまでも "AddressSection.address"
            if (tag == "AddressSection.address") tag = "都道府県";
            NRGetMenu(owner(), tag, got_basicMenu);
        }
    }
}

///// EDITOR /////////////////////////////////////////
//////////////////////////////////////////////////////

function show_basic_page(){
    // 基本情報編集ペーンを開く
    var date = currentDate();
    
    // 年月日ラベルがクリックされ PanelEditor が開かれたら
    // PanelEditor で開いていたエディターがあっても close status にする
    setEditorId(null);
    
    // 編集ペーンを開く
	var elm = document.getElementById("_body");
    elm.innerHTML = "";
    elm.style.backgroundColor = (isSameDate(date, currentDate())) ? "#fff" : "#eee";
	var tbl = newTABLE(elm, "base-table");
    tbl.style.fontSize = "9pt";
    
    // 基本情報
    var array = noa().layoutArray(_basic);
    for (num in array){
        var rec = array[num];
        var label = (rec.label) ? rec.label : rec.tag;
        if (rec.hitAndRun * 1) continue; // 非表示セル
        
        var obj = noa().valueForStructure(date, rec.tag);
        var value = "???"; // DB から読み込んだデータに存在しなかった
        var isPast = false;
        if (obj){
            value = (obj.value) ? obj.value : "";
            isPast = obj.isPast;
        }
        
        // コンテンツのフレームを生成
        var tr = newTR(tbl, "", "");
        tr.style.borderBottom = "thin solid #ccc";
        
        // LABEL
        var td = newTD(tr, "/cellLabel", label);
        td.setAttribute("onclick", "open_basicEditor('"+rec.tag+"')");
        td.style.backgroundColor = "#bfd";

        // VALUE
        var td = newTD(tr, date + "_" + rec.tag, ""); // 日付_タグ 形式
        show_cell_basicValue(date, rec.tag);
    }
}

function initBasicEditor(){
	var elm = document.getElementById("base");
    elm.innerHTML = "";
    
    // === PROBLEM LIST ==================
    var div = newDIV(elm, "tool-header");
    // --- LEFT SIDE ---
    var dv = newDIV(div, "/left-side");
    dv.style.marginTop = "2px";
    // ARROW ICON
    var sp = newSPAN(dv, "arrowArea");
    // TITLE
    var sp = newSPAN(dv, "problemLabel/titleLabel");
    sp.innerHTML = "PROBLEM LIST";
    // --- RIGHT SIDE ---
    var dv = newDIV(div, "/right-side2");
    dv.style.width = "40px";
    // HELP ICON
	var img = newIMAGE(dv, "", "./Help.png", "?");
	img.style.height = "18px";
    img.setAttribute("onclick", "problemListHelp()");
    img.style.position = "relative";
    img.style.top = "2px";
    
    // === problemList area ===
    var div = newDIV(elm, "problemListArea");
    showProblemList("problemListArea"); // problemList.js
    // problemList を表示した後、矢印アイコンに action 設定
    expandProblem();
    
	// === BASIC INFO ======================
	// === HEADER ===
    var div = newDIV(elm, "tool-header");
    // --- LEFT SIDE ---
    var ldv = newDIV(div, "/left-side");
    ldv.style.paddingLeft = "0px";
    ldv.style.width = "85%";
    // 受診日時
    var sp = newSPAN(ldv, "");
    sp.style.paddingLeft = "10px";
    sp.style.color = "#888";
    sp.innerHTML = currentDate();
	// 基本情報・保険情報タブ
    var dv = newDIV(ldv, "/titleLabel");
    dv.innerHTML = "基本情報";
    var dv = newDIV(ldv, "/greenButton");
    dv.innerHTML = "保険情報";
    dv.setAttribute("onclick", "openInsurance()");
    // --- RIGHT SIDE ---
    var rdv = newDIV(div, "/right-side");
    rdv.style.width = "20px";
    rdv.style.position = "relative";
    rdv.style.bottom = "5px";
    // HELP ICON
    var sp = newSPAN(rdv, "");
    sp.style.position = "relative";
    sp.style.top = "4px";
    sp.style.paddingLeft = "10px";
	var img = newIMAGE(sp, "", "./Help.png", "?");
	img.style.height = "18px";
    img.setAttribute("onclick", "panelEditorHelp()");
    
	// === BODY ===
    var div = newDIV(elm, "_body");
    
	// === FOOTER ===
    var div = newDIV(elm, "tool-footer");
    div.innerHTML = " ";
    
	// === MESSAGE ===
    var div = newDIV(elm, "message");
    
    show_basic_page();
}


