
/////////////////////////
///// カルテからの継承値 ///

function noa(){
    if (window.opener.name == "noa"){
        return window.opener;
    } else if (window.opener.name == "tools"){
        return window.opener.top.noa;
    } else if (window.top.noa){
        return window.top.noa;
    } else {
        alert("ERROR *** calendar.js: window.opener としての NOA が見つかりません");
        return null;
    }
}

function patientId(){
	return noa().patient_id();
}

function history(){
    var obj = new Object();
    var array = noa().history();
    for (num in array){
        var dateTime = array[num];

        // 重複した受診日を単一にする
        // NOA にとっては重複した受診日必要
        obj[dateTime] = dateTime;
    }
    
    // 単純な dateTime 配列を返す
    return allKeys(obj);
}

///// カルテからの継承値 ///
/////////////////////////


var _counter;
function setCounter(array){
    // "[...]" 印のあるページの受診日の配列
    _counter = array;
}
function counter(){
    return _counter;
}
function hasCouner(date){
    // _counter に date が含まれれば true を返す
    for (num in _counter){
        var entryDate = _counter[num];
        if (isSameDate(date, entryDate)){
            if (entryDate.indexOf("START") >= 0)
                return 1;
            else
                return 2;
        }
    }
    return 0;
}
function isStartDate(date){
    // _counter に記憶した日付に "START" が入っていれば true を返す
    for (num in _counter){
        var entryDate = _counter[num];
        if (isSameDate(date, entryDate)){
            if (entryDate.indexOf("START") >= 0)
                return true;
        }
    }
    return false;
}

function pageScrollUp(date){
    // ページを画面上端にスクロール
    if (debugMode()){
        var array = history();
        for (num in array){
            var entryDate = array[num];
            if (isSameDate(date, entryDate)){
                if (overFlowHeight()){
                    alert("初期設定で画面スクロール範囲が限定されている場合は " + entryDate +" のページへジャンプできません");
                } else {
                    noa().pageScroll_to(entryDate); // 指定日ヘスクロール
                    noa().openPage(entryDate); // 指定日をアクティブにする
                    return; // 受診歴があったのでそのページにスクロール
                }
            }
        }
    } else {
        var obj = noa().structure();
        for (entryDate in obj){
            if (isSameDate(date, entryDate)){
                noa().pageScrollTo(entryDate);
                return; // 受診歴があったのでそのページにスクロール
            }
        }
    }
    
    // 受診歴がなかった：すなわち予約日
    for (num in _bookingArray){
        var entryDate = _bookingArray[num];
        if (isSameDate(date, entryDate)){
            // 予約年月日に一致した予約日時を得、そのページを追加
            if (confirm("予約日："+entryDate + " のページをカルテに追加しますか")){
                // ## 同じ年月日に２つ以上予約があった場合（それはないはずだが）最初のものをゲット
                noa().addPage(entryDate);
            }
        }
    }
}

function hideCount(date){
    // マウスで指した日付の count を消す
    var array = date.split("-");
    var year = array[0];
    var month = array[1];
    var day = array[2];
    
	var elm = document.getElementById("calMessage"+year+month);
    elm.innerHTML = "";
}
function showCount(date){
    // マウスで指した日付の count を表示
    var array = date.split("-");
    var year = array[0];
    var month = array[1];
    var day = array[2];
	var elm = document.getElementById("calMessage"+year+month);
    elm.style.paddingLeft = "10px";
    
    if (noa().debugMode()){
        var counter = (-1);
        var array = history();
        
        // date から遡って開始日までの日数をカウント
        for (num in array){
            var dt = array[num];
            if (isSameDate(dt, date)) counter = 1; // date のページを１に設定
            if (isSameDate(dt, _markStartDate)){ // 開始日のページでカウント表示
                elm.innerHTML = counter + " 回目";
                return;
            }
            if (counter > 0)
                counter++;
        }
    } else {
        var counter = 0;
        var ct = _counter.length;
        for (var num=ct-1; num >= 0; num--){
            var entryDate = _counter[num];
            if (entryDate.indexOf("START") > 0)
                counter = 1;
            else
                counter++;
            if (isSameDate(date, entryDate)){
                elm.innerHTML = counter + " 回目";
            }
        }
    }
}
function showMonth(year, month){
    // その月のカレンダーを表示
    var cal = document.getElementById(year + "_" + month + ".calendar");
    if (cal && cal.innerHTML.length){
        // すでにカレンダーが開いていれば閉じて終了
        cal.innerHTML = "";
        return;
    }
    
    var div = document.getElementById(year + "_" + month + ".bar");
    div.innerHTML = "";
    
    // div.innerHTML = "" を行うので、年月ラベルを再構築
    makeYearMonthLabel(div, year, month);
    
    // カレンダー本体
    var dv = newDIV(div, year + "_" + month + ".calendar");
    dv.setAttribute("class", "calTableArea");
    
    var tbl = newTABLE(dv, "calendarTable");
    
    // WEEK
    var tr = newTR(tbl, "", "");
    var array = weeks(); // lib.js
    for (num in array){
        var td = newTD(tr, "", array[num]);
        td.style.textAlign = "right";
        td.style.padding = "0px 5px";
    }
    
    // DAY
    var lastDay = getLastDate(year, month);
    var w = 0;
    var isAnotherMonth = false;
    
    if (calendarIsReverse() > 0){
        // 毎月のカレンダーを逆順に表示
        var lastWeek = weekOfDate(year + "-" + month + "-" + lastDay);
        var lastW = lastW(lastWeek);
        var day = lastDay * 1 - lastW * 1;
        var weekBeginDay = day; // 週開始の日付
        
        while (day > -7){
            if (w == 0)
                var tr = newTR(tbl, "", "");
            
            if (day > lastDay){
                var td = newTD(tr, "/dateTip", ""); // 空欄日付を表示
                isAnotherMonth = true;
            } else if (day <= 0){
                var td = newTD(tr, "/dateTip", ""); // 空欄日付を表示
                isAnotherMonth = true;
                day++;
            } else {
                var td = newTD(tr, "/dateTip", "" + day);
                var dd = (day * 1 < 10) ? "0" + day : day;
                var date = year + "-" + month + "-" + dd;
                td.setAttribute("onclick", "pageScrollUp('" + date + "')");
                day++;
            }
            
            // 日付にカラー・マーキング
            if (isVisitDate(date)){ // 受診した日付
                if (td.innerHTML.length == 0){
                    // do nothing
                } else {
                    // 2013-04-22 16:35:00 は 130422 形式で比較しないとうまくいかない
                    if (noa().debugMode()){
                        // 日のエレメントにカウント・マークを設定
                        setMarkAttribute(td, date);
                    } else {
                        var status = hasCouner(date) * 1;
                        if (status == 1){ // カウント開始日
                            td.setAttribute("class", "orangeDateTip");
                            td.setAttribute("onmouseover", "showCount('" + date + "')");
                            td.setAttribute("onmouseout", "hideCount('" + date + "')");
                        } else if (status == 2){ // カウントのある受診日
                            td.setAttribute("class", "yellowDateTip"); //##
                            td.setAttribute("onmouseover", "showCount('" + date + "')");
                            td.setAttribute("onmouseout", "hideCount('" + date + "')");
                        } else { // カウントのない受診日
                            td.setAttribute("class", "greenDateTip");
                        }
                    }
                }
            }
            
            if (!isAnotherMonth && isBookingDate(date))
                td.setAttribute("class", "pinkDateTip");
            
            if (++w == 7){
                if (day <= 8) break;
                
                w = 0;
                day = weekBeginDay - 7;
                weekBeginDay = day;
            }
        }
    } else {
        var firstWeek = weekOfDate(year + "-" + month + "-01");
        var day = 0;

        while (day <= lastDay){
            if (w == 0)
                var tr = newTR(tbl, "", "");
            
            if (day == 0){
                if (firstWeek == weeks()[w]){
                    // 曜日が月初の曜日と一致したなら１日に設定
                    day = 1;
                } else {
                    // そうでなければ空欄日付を表示
                    w++;
                    var td = newTD(tr, "/dateTip", "");
                    continue;
                }
            }
            if (day <= 0) isAnotherMonth = true;
            var st = (isAnotherMonth) ? "" : "" + day;
            
            var td = newTD(tr, "/dateTip", st);
            var dd = (day * 1 < 10) ? "0" + day : day;
            var date = year + "-" + month + "-" + dd;
            td.setAttribute("onclick", "pageScrollUp('" + date + "')");
            
            // 日付にカラー・マーキング
            if (isVisitDate(date)){ // 受診した日付
                if (td.innerHTML.length == 0){
                    // do nothing
                } else {
                    if (noa().debugMode()){
                        // 日のエレメントにカウント・マークを設定
                        setMarkAttribute(td, date);
                    } else {
                        var status = hasCouner(date) * 1;
                        if (status == 1){ // カウント開始日
                            td.setAttribute("class", "orangeDateTip");
                            td.setAttribute("onmouseover", "showCount('" + date + "')");
                            td.setAttribute("onmouseout", "hideCount('" + date + "')");
                        } else if (status == 2){ // カウントのある受診日
                            td.setAttribute("class", "yellowDateTip"); //##
                            td.setAttribute("onmouseover", "showCount('" + date + "')");
                            td.setAttribute("onmouseout", "hideCount('" + date + "')");
                        } else { // カウントのない受診日
                            td.setAttribute("class", "greenDateTip");
                        }
                    }
                }
            }

            if (!isAnotherMonth && isBookingDate(date))
                td.setAttribute("class", "pinkDateTip");
            
            day++;
            if (day > lastDay) break;
            if (++w > 6) w = 0;
        }
    }
    
    // keyCount モードのカウント数を表示するエリア
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "calMessage"+year+month, "");
	td.setAttribute("colspan", "7");
	td.style.color = "#00f"; //blue
    
    
    function setMarkAttribute(td, date){
        // 日のエレメントにカウント・マークを設定
        if (!_markStartDate){
            // カウント開始マークがなければカウントのない受診日
            td.setAttribute("class", "greenDateTip");
            return;
        }
        
        var dt = shortDate(date);
        var sdt = shortDate(_markStartDate);
        var gdt = shortDate(_markGoalDate);
        if (dt == sdt){ // カウント開始日
            td.setAttribute("class", "orangeDateTip");
            td.setAttribute("onmouseover", "showCount('" + date + "')");
            td.setAttribute("onmouseout", "hideCount('" + date + "')");
        } else if ((dt <= gdt) && (dt > sdt)){ // カウントのある受診日
            td.setAttribute("class", "yellowDateTip");
            td.setAttribute("onmouseover", "showCount('" + date + "')");
            td.setAttribute("onmouseout", "hideCount('" + date + "')");
        } else { // カウントのない受診日
            td.setAttribute("class", "greenDateTip");
        }
    }
    
    function isVisitDate(date){
        // year, month, day が受診日なら true を返す
        if (noa().debugMode()){
            var struct = noa().noaStructure();
            var records = struct["ProgressSection"];
            for (num in records){
                var rec = records[num];
                if (isSameDate(date, rec.date)) return true;
            }
        } else {
            var obj = noa().structure();
            for (entryDate in obj){
                if (isSameDate(date, entryDate)) return true;
            }
        }
        return false;
    }
    
    function isBookingDate(date){
        // year, month, day が予約日なら true を返す
        for (num in _bookingArray){
            var entryDate = _bookingArray[num];
            
            if (isSameDate(date, entryDate)) return true;
        }
        return false;
    }
    
    function lastW(weekSt){
        // 曜日に対応する数値を返す
        var array = weeks();
        for (num in array){
            if (array[num] == weekSt)
                return num;
        }
        return 0;
    }
}

function makeYearMonthLabel(div, year, month){
    // 年月 ラベル
    var dv = newDIV(div, "/yearMonthLabel");
    dv.innerHTML = year + "・" + month;
    dv.setAttribute("onclick", "showMonth('"+year+"','"+month+"')");
}

function showMonthlyCalendar(){
    // 各月のカレンダーを表示
	var elm = document.getElementById("contentsArea");
	elm.innerHTML = "";
    
    var calbg = newDIV(elm, ""); // カレンダー背景

    // structure() から受診日の配列を生成
    if (noa().debugMode()){
        var dateArray = history();
    } else {
        var dateArray = new Array();
        var obj = noa().structure();
        for (entryDate in obj){
            dateArray.push(entryDate);
        }
    }
    
    // 予約日があればそれをマージ
    if (_bookingArray){
        dateArray = _bookingArray.concat(dateArray);
    }
    
    if (calendarIsReverse() == 0){
        // 正順にソート
        dateArray = dateArray.reverse();
    }
    
    var year;
    var month;
    for (num in dateArray){
        // rec は ProgressSection と NameSection のデータを保有
        var entryDate = dateArray[num];
        var st = entryDate.substr(0,10);
        var ary = st.split("-");
        
        if ((year != ary[0]) || (month != ary[1])){
            year = ary[0];
            month = ary[1];
            var div = newDIV(calbg, year + "_" + month + ".bar");
            div.setAttribute("class", "yearMonthRow");
            
            // 年月 ラベル
            makeYearMonthLabel(div, year, month); // float:left
 
            // _expandMode か 参照中の受診日と同月なら カレンダーを開く
            if (_expandMode || (isSameMonth(entryDate, noa().currentDate()))){
               showMonth(year, month);
            }
        }
    }
}

var _bookingArray;
function gotBooking(answer){
    // 予約日リストが answer として返される
    //alert("gotBooking->"+answer); //##
    _bookingArray = JSON.parse(answer);
    //alert("gotBooking->"+encodeObject(_bookingArray)); //##
    
    // 各月のカレンダーを表示
    showMonthlyCalendar();
}

var _markStartDate;
var _markGoalDate;
function getCounter(){
    // [candida治療] などの印のついた受診日の配列を返す
    var counter = new Array();
    if (debugMode()){
        var isStarted = true; // とりあえず抽出開始とする
        var records = noa().recordsForTable("ProgressSection");
        
        for (num in records){
            var rec = records[num];
            var entryDate = rec["date"]; // entryDate
            var val = rec["subject"]; // 主訴欄の value
            
            // 暫定ゴール年月日とする
            if (num == 0) _markGoalDate = entryDate;
            
            if (!val) continue; // 前回と同所見でマーク対象日ではないはず
            
            if (val.indexOf(":開始]") >= 0){
                // "[...:開始]" があれば開始年月日とする
                _markStartDate = entryDate;
//                alert("_markStartDate->"+_markStartDate); //##
                break; // 日付を逆順にスキャンしているので「開始」をみつければ終了
            } else if (val.indexOf(":終了]") >= 0){
                // "[...:終了]" があれば暫定ゴール年月日を上書き
                _markGoalDate = entryDate;
//                alert("_markGoalDate->"+_markGoalDate); //##
            }
       }
    } else {
        var obj = noa().structure();
        for (entryDate in obj){
            var fields = obj[entryDate];
            var rec = fields['ProgressSection.subject'];
            var val = rec.trimValue; // 主訴欄の value
            
            if (val.length == 0) continue;
            if (! hasCountForm(val)) continue; // [...] 型式でなければスキップ
            
            if (val.indexOf(":開始]") >= 0)
                // "[...:開始]" があれば起点とする
                counter.push(entryDate + "START");
            else if (val.indexOf(":終了]") >= 0){
                // "[...:終了]" があれば終点とする
                counter.push(entryDate + "END");
            } else {
                counter.push(entryDate);
            }
        }
    }
    
    //_debug("===== counter->"+encodeObject(counter)); //##
    
    return counter;
    
    
    function hasCountForm(buff){
        // buff に "[...]" が含まれれば true を返す
        if (buff == null) return false;
        if (buff.indexOf("[") < 0) return false;
        if (buff.indexOf("]") < 0) return false;
        return true;
    }
    
    function getCountKey(buff){
        // buff 中の "[..." を key として返す
        var array = buff.split("[");
        var st = array[1];
        array = st.split("]");
        st = array[0];
        array = st.split(":");
        
        return "[" + array[0];
    }
}

var _expandMode;
function expandCalendar(){
    // problemList を展開する
	var elm = document.getElementById("arrowArea");
    elm.innerHTML = "";
    elm.setAttribute("onclick", "foldCalendar()");
    elm.style.padding = "0 2px 5px 2px";
	var img = newIMAGE(elm, "", "./arrowDown.png", "?");
	img.style.height = "15px";
    img.setAttribute("class", "expandIcon");
    img.style.position = "relative";
    img.style.top = "4px";
    _expandMode = (_expandMode) ? false : true;
    showMonthlyCalendar();
    
    var label = document.getElementById("calLabel");
    label.style.position = "relative";
    label.style.top = "2px";
}
function foldCalendar(){
    // problemList を折畳む
	var elm = document.getElementById("arrowArea");
    elm.innerHTML = "";
    elm.style.padding = "0 0";
    elm.style.position = "relative";
    elm.style.bottom = "-2px";
    elm.setAttribute("onclick", "expandCalendar()");
	var img = newIMAGE(elm, "", "./arrowLeft.png", "?");
	img.style.height = "8px";
    img.setAttribute("class", "expandIcon");
    img.style.position = "relative";
    img.style.top = "4px";
    _expandMode = (_expandMode) ? false : true;
    showMonthlyCalendar();
    
    var label = document.getElementById("calLabel");
    label.style.position = "relative";
    label.style.top = "6px";
}

function checkReverse(elm){
    // 逆順チェック・ボックスがチェックされた
    setCalendarIsReverse(elm);
    initCalendar();
}

function calendarHelp(){
    // HELP を開く
	// 別途ヘルプをパネル表示
	window.open("./calendarHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initCalendar(){
	var elm = document.getElementById("base");
	elm.innerHTML = "";
    elm.style.backgroundColor = "#cfe";
    
    // HEADER
    var div = newDIV(elm, "tool-header");
    // --- LEFT SIDE ------------
    var dv = newDIV(div, "/left-side");
    // ARROW ICON
    var sp = newDIV(dv, "arrowArea");
    sp.style.display = "inline";
    sp.setAttribute("onclick", "expandCalendar()");
	var img = newIMAGE(sp, "", "./arrowLeft.png", "?");
	img.style.height = "8px";
    img.setAttribute("class", "expandIcon");
    img.style.position = "relative";
    img.style.top = "7px";
    // TITLE
    var sp = newSPAN(dv, "calLabel/titleLabel");
    sp.innerHTML = "CALENDAR";
    sp.style.position = "relative";
    sp.style.top = "5px";
    // --- RIGHT SIDE ----------
    var dv = newDIV(div, "/right-side2");
    var img = newIMAGE(dv, "", "Help.png", "icon");
    img.style.height = "19px";
    img.style.position = "relative";
    img.style.top = "3px";
    img.setAttribute("onclick", "calendarHelp()");
    
    // CONTENTS
    var dv = newDIV(elm, "contentsArea");
    
    // FOOTER
    var div = newDIV(elm, "tool-footer");
    // --- LEFT SIDE ---------------
    var dv = newDIV(div, "left-side");
    var cb = newCHECKBOX(dv, "", "逆順に表示", calendarIsReverse());
    cb.setAttribute("onchange", "checkReverse(this)");
    // --- RIGHT SIDE ---------------
    var dv = newDIV(div, "right-side");
    dv.innerHTML = version();
    dv.style.position = "relative";
    dv.style.top = "2px";

    //_initDebug(true); //##

    // [candida治療] などの印をカウントし配列に記憶
    setCounter(getCounter());
    
    // ### FrontTable の本日以後から、この patientId の予約年月日をスキャン
    // ### そのリストを得た上で showMonthlyCalendar() を実行
    NRGetBooking(patientId(), noa().currentDate(), gotBooking);
}

function version(){
    return "Ver.130508";
}

