
function dateAndId(){
	return document.getElementById("_dateAndId").value;
}

function owner(){
	return document.getElementById("_owner").value;
}

var _entryDate
function entryDate(){
	if (!_entryDate){
		var array = dateAndId().split("^");
		_entryDate = array[0];
	}
	return _entryDate;
}

var _record;
function setRecord(){
	// front.js から entryDate に相当するレコードを得る
	var front = window.opener; // window.parent
	_record = front.recordForEntryDate(dateAndId());
}
function record(){
	return _record;
}

///////////////////////////
/// Ajax による処理 /////////

function closeEditor(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
        //alert("closeEditor->"+value); //##
        
        window.close();
    }
}
function registNewPatient(){
	// 再来患者を登録する
	var patientId = document.getElementById("ed_patientId").value;
	if (patientId.length == 0) return;
	
    xmlHttpObject = createXMLHttpRequest(closeEditor);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var st = "./frontServer.php"
		+ "?command=PUT_PATIENT"
		+ "&value=" + args(patientId);
		//alert(st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
	
	function args(patientId){
		// arguments() という関数名はエラーになる
        var obj = new Object();
        obj.owner = document.getElementById("_owner").value;
        obj.patientId = patientId;
		obj.kanjiName = document.getElementById("ed_patientKanjiName").value;
        obj.entryDate = document.getElementById("ed_entryDate").value;
        obj.userCode = document.getElementById("ed_userCode").value;
        obj.groupCode = document.getElementById("ed_groupCode").value;
        obj.inOut = (document.getElementById("ed_inOut").checked) ? "on" : "";
        obj.newPatient = (document.getElementById("ed_newPatient").checked) ? "on" : "";
        obj.insFee = document.getElementById("ed_insFee").value;
        obj.ownFee = document.getElementById("ed_ownFee").value;
        obj.receive = document.getElementById("ed_receive").value;
        obj.mishuu = document.getElementById("ed_mishuu").value;
        obj.duplicate = ""; // not regist_mode
        
        return encodeObject(obj);
	}
}

/// Ajax による処理 /////////
///////////////////////////


function setEditorValues(){
	// 各フィールドに値をセット
	var rec = record();
	document.getElementById("ed_owner").value = rec.owner;
	document.getElementById("ed_entryDate").value = entryDate();
	document.getElementById("ed_patientId").value = rec.patientId;
	document.getElementById("ed_patientKanjiName").value = rec.kanjiName;
	document.getElementById("ed_groupCode").value = rec.groupCode;
	document.getElementById("ed_insFee").value = rec.insFee;
	document.getElementById("ed_ownFee").value = rec.ownFee;
	document.getElementById("ed_userCode").value = rec.userCode;
	document.getElementById("ed_mishuu").value = rec.mishuu;
	document.getElementById("ed_receive").value = rec.receive;
	var elm = document.getElementById("ed_inOut");
	if (array[5] * 1 > 0) 
		elm.setAttribute("checked", true);
	var elm = document.getElementById("ed_newPatient");
	if (array[6] * 1 > 0) 
		elm.setAttribute("checked", true);
}

function removeOldPatient(){
	window.close();
	window.opener.removePatient(dateAndId()); // front.js
}

function initPatientEditor(){
	// front から該当レコード属性を取得
	setRecord();
	
	//window.moveBy(-100, 200);
	var base = document.getElementById("base");
	var tbl = newTABLE(base, "patientEditor");
	var tr = newTR(tbl,"ed_title","");
	var td = newTD(tr,"","編集パネル");
	td.setAttribute("COLSPAN", 2);
	var isSuperUser = document.getElementById("_isSuperUser").value;
	if (isSuperUser > 0)
		editorField(tbl, "ed_entryDate", "受付時刻", 22, "", false);
	else
		editorField(tbl, "ed_entryDate", "受付時刻", 22, "", true);
	editorField(tbl, "ed_owner", "取扱者", 22, "", true);
	editorField(tbl, "ed_userCode", "ユーザコード", 22, "", true);
	editorField(tbl, "ed_patientId", "カルテID", 22, "", true);
	editorField(tbl, "ed_patientKanjiName", "氏名", 22, "", false);
	editorField(tbl, "ed_groupCode", "保険種別", 22, "", false);
	//alert(record().inOut); //##
	var status = (record().inOut) ? 1 : 0;
	var ip = makeTRCheckBox(tbl, "ed_inOut", "入院/外来", "入院", status, 10);
	var status = (record().newPatient) ? 1 : 0;
	var ip = makeTRCheckBox(tbl, "ed_newPatient", "新患/再来", "新患", status, 10);
	editorField(tbl, "ed_insFee", "一部負担金", 22, "", false);
	editorField(tbl, "ed_ownFee", "自費", 22, "", false);
	editorField(tbl, "ed_mishuu", "未収", 22, "", false);
	editorField(tbl, "ed_receive", "受取額", 22, "", false);

	ip.setAttribute("onchange", "registNewPatient()");
	var tr = newTR(tbl,"ed_control","");
	var td = newTD(tr,"","");
	td.setAttribute("COLSPAN", 2);
	var bt = newBUTTON(td, "", "とりやめ");
	bt.setAttribute("onclick", "window.close()");
	
	if (record()){
		var bt = newBUTTON(td, "", "削除");
		bt.setAttribute("onclick", "removeOldPatient()");
	}
	
	var bt = newBUTTON(td, "", "確定");
	bt.setAttribute("onclick", "registNewPatient()");
	setEditorValues();
	
	function editorField(tbl, id, label, size, val, disabled){
		var tr = newTR(tbl,"",label);
		var td = newTD(tr, "", "");
		var ip = newFIELD(td, id, "", size, val);
		if (disabled) ip.setAttribute("disabled", true);
	}
	
	function makeTRCheckBox(tbl, cellId, label, buttonLabel, status, width){
		var tr = newTR(tbl,"ed_field",label);
		var td = newTD(tr,"","");
		var ip = newCHECKBOX(td, cellId, buttonLabel, status);
		return ip;
	}
}
