
////////////////////////////////////////////////////////////////
///// Ajax /////////////////////////////////////////////////////

var _backupName;
function gotBackupList(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("gotBackupList ===\n"+value);//##
        
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            var array = JSON.parse(array[1]);
            //alert("== gotBackupList ==\n"+array.join("\n"));//##
            
            // バックアップファイルのポップアップを表示
            if (_backupName == "menu")
                showBackupSelector(array);
            else 
                showBackupSubSelector(array);
		} else {
            alert(value);
        }
	}
}
function getBackupList(filename){
    // メニューバーのアーカイブのリストをリクエスト
    xmlHttpObject = createXMLHttpRequest(gotBackupList);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
        array["owner"] = owner();
		array["menu"] = "1";
        array["suffix"] = "txt";
        
        _backupName = filename;
		var st = "./server.php?command=GET_DIR"
		+ "&value=" + encodeObject(array);
		//alert(st); //===
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

var _mode;

function loadedBackupFile(){
    // メイン・メニューが読み込まれた
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
        _debug("loadedBackupFile->"+value); //##
        
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            var obj = decodeObject(array[1]);
            setMenuObj(obj); // mainMenu とソースファイル名の関連に必要
            showBackupMenu(obj);
        }
        
        // 読み込まれたメイン・メニューを main.txt として保存
        var backup = document.getElementById("backupFilePop").value;
        //alert("backup->"+backup); //return; //##
        
        copyBackupFile(backup);
	}
}
function　loadedSubBackupFile(){
    // サブ・メニューが読み込まれた
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
        _debug("loadedSubBackupFile->"+value); //##
        
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            var obj = decodeObject(array[1]);
            showSubBackupMenu(obj);
        }
	} 
}
function loadBackupFile(mode){
    // 現在選択されているバックアップ・ファイルを読込む
    _mode = mode;
    
    //_debug(true); //##
    
    if (mode == "main")
        xmlHttpObject = createXMLHttpRequest(loadedBackupFile);
    else {
        var elm = document.getElementById("backupSubFilePop");
        if (elm){
            document.getElementById("file." + _mainMenu).innerHTML = elm.value;
        }
        xmlHttpObject = createXMLHttpRequest(loadedSubBackupFile);
    }
    
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
        array["owner"] = owner();
		array["menu"] = "1";
        var id = (mode == "main") 
            ? "backupFilePop" : "backupSubFilePop";
        array["filename"] = document.getElementById(id).value;
		
		var st = "./server.php?command=GET_FILE"
		+ "&value=" + encodeObject(array);
        
        //alert("== loadBackupFile-> "+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function copiedBackupFile(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
        //alert("copiedBackupFile->"+value); //##
        
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            alert(array[1]); // 成功・不成功のメッセージ
        }
        // サーバで更新後、ブラウザを再描画
        window.location.reload(true);
	}
}
function copyBackupFile(backup){
    // backup を main にコピー
    if ((backup.length > 16) && isDigit(backup.substr(0,12))){
        // backup.txt を、その行頭からタイムスタンプを削ったファイルへコピー
        var main = backup.substr(12);
        
        //alert("copyBackupFile->"+backup+"->"+main); //##
        
        xmlHttpObject = createXMLHttpRequest(copiedBackupFile);
        if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
            var array = new Array();
            array["owner"] = owner();
            array["from"] = backup;
            array["to"] = main;
            
            var st = "./server.php?command=COPY_FILE"
            + "&value=" + encodeObject(array);
            //alert(st); //===
            
            xmlHttpObject.open("GET", encodeURI(st), true);
            xmlHttpObject.send(null);
        }
    } else {
        alert(backup + " はバックアップファイルではありません");
    }
}

///// Ajax /////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////




function showBackupSelector(filenames){
    // バックアップ・ファイルのリストを選択してファイルをロード
	var elm = document.getElementById("contents");
    elm.innerHTML = "";
	var elm = document.getElementById("optionArea");
    elm.innerHTML = "";
    
    var dv = newDIV(elm, "");
    dv.innerHTML = "MAIN MENU ";
    dv.style.fontSize = "9pt";
    dv.style.padding = "0px 5px";
    dv.style.border = "thin solid #aaa";
    dv.style.backgroundColor = "#ffe";
    dv.style.marginTop = "20px";
    dv.style.padding = "10px";
    
    var items = new Array();
    for (num in filenames){
        var name = filenames[num];
        if (name.indexOf("menu.txt") >= 0)
            items.push(name);
    }
    var pu = newPopupMenu(dv, "backupFilePop", items, "");
    var bt = newBUTTON(dv, "", "読込む");
    bt.setAttribute("onclick", "loadBackupFile('main')");
    var bt = newBUTTON(dv, "", "削除");
    var action = "removeBackupFile('backupFilePop', 'menu', getBackupList)";
    bt.setAttribute("onclick", action);
    var sp = newSPAN(dv, "mainSaveButtonArea");
}
function showBackupSubSelector(filenames){
    // バックアップ・ファイルのリストを選択してファイルをロード：サブメニュー用
	var elm = document.getElementById("pop." + _backupName);
    elm.innerHTML = "";
    
    var dv = newDIV(elm, "");
    dv.style.fontSize = "9pt";
    dv.style.padding = "0px 5px";
    
    // mainMenu に対応する subMenu ソース・ファイル名を取り出す
    var subMenuName = menuObj()[_backupName];
    
    var items = new Array();
    for (num in filenames){
        var name = filenames[num];
        //    if (name.charAt(0) == '.') continue;
        if (name.indexOf(subMenuName) >= 0)
            items.push(name);
    }
    var pu = newPopupMenu(dv, "backupSubFilePop", items, "");
    var bt = newBUTTON(dv, "", "読込む");
    bt.setAttribute("onclick", "loadBackupFile()");
    var bt = newBUTTON(dv, "", "削除");
    var action = "removeBackupFile('backupSubFilePop', _backupName, getBackupList)";
    bt.setAttribute("onclick", action);
    var sp = newSPAN(dv, "saveButtonArea");
}

var _mainMenu;
function loadSubMenu(mainMenu){
    // mainMenu に対するバックアップのリストを表示
    var elm = document.getElementById("pop." + mainMenu);
    if (elm.innerHTML.length){
        // ポップアップ領域をトグル式に開閉
        elm.innerHTML = "";
        return;
    }
    if (_mainMenu){
        // 他メインメニューのポップアップが開いていたら閉じる
        document.getElementById("pop." + _mainMenu).innerHTML = "";
    }
    getBackupList(mainMenu);
    
    _mainMenu = mainMenu;
}

function saveBackupMenu(){
    // メインメニューのバックアップを正式版とする
	var backup = document.getElementById("backupFilePop").value;
    copyBackupFile(backup);
}
function saveSubBackupMenu(){
    // サブメニューのバックアップを正式版とする
	var backup = document.getElementById("backupSubFilePop").value;
    copyBackupFile(backup);
}

function showBackupMenu(obj){
    // mainMenu を表示
	var elm = document.getElementById("contents");
	elm.innerHTML = "";
    var tbl = newTABLE(elm, "mapTable");
    
    // mainMenu を生成
    for (mainMenu in obj){
        var rec = obj[mainMenu]; // subMenu のソース名
        var tr = newTR(tbl, "", "");
        tr.style.border = "thin solid #aaa";
        
        // MAIN MENU
        var td = newTD(tr, "", "");
        td.style.width = "350px";
        td.style.border = "thin solid #888";
        td.style.fontSize = "10pt";
        td.style.verticalAlign = "top";
        // mainMenu 表示エリア
        var sp = newSPAN(td, "/whiteButton");
        sp.innerHTML = mainMenu;
        sp.style.padding = "0px 5px";
        sp.setAttribute("onclick","loadSubMenu('" + mainMenu + "')");
        
        // mainMenu のバックアップ・ファイル名表示エリア
        var sp = newSPAN(td, "file." + mainMenu);
        sp.style.padding = "0px 10px";
        sp.style.fontSize = "9pt";
        sp.style.color = "#ccc";
        sp.innerHTML = rec; // subMenu のソース名
        
        // mainMenu のバックアップ・リスト 表示エリア
        var dv = newDIV(td, "pop." + mainMenu);
        
        // SUB MENU
        var td = newTD(tr, "sub." + mainMenu, "");
    }
    
    // 保存ボタンを表示
    var elm = document.getElementById("mainSaveButtonArea");
    elm.innerHTML = "";
    var bt = newBUTTON(elm, "", "保存");
    bt.setAttribute("onclick", "saveBackupMenu()");
}
function showSubBackupMenu(obj){
    // subMenu を表示
	var elm = document.getElementById("sub." + _mainMenu);
	elm.innerHTML = "";
    var tbl = newTABLE(elm, "mapTable");
    
    // subMenu エリアにデータを表示
    for (subMenu in obj){
        var tr = newTR(tbl, "", "");
        tr.style.border = "thin solid #aaa";
        
        // subMenu を表示
        var td = newTD(tr, "", subMenu);
        td.style.padding = "0px 5px";
        
        // URL を表示
        var sp = newSPAN(td, "");
        var url = obj[subMenu];
        sp.innerHTML = url;
        sp.style.padding = "0px 10px";
        sp.style.fontSize = "9pt";
        sp.style.color = "#00f";
        
        if (trim(url).length == 0){
            // url 無しなら背景色をタイトル色にする
            td.style.backgroundColor = "#aec";
        }
    }
    
    // main の保存ボタンを消す
    var elm = document.getElementById("mainSaveButtonArea");
    elm.innerHTML = "";
    
    // 保存ボタンを表示
    var elm = document.getElementById("saveButtonArea");
    elm.innerHTML = "";
    var bt = newBUTTON(elm, "", "保存");
    bt.setAttribute("onclick", "saveSubBackupMenu()");
}

function openBackup(checkbox){
    // バックアップ編集画面を開く
    
    // EDITOR BUTTON
    var elm = document.getElementById("editorButtonArea");
	elm.innerHTML = "";
    var bt = newDIV(elm, "/gray-tab");
    bt.innerHTML = "EDITOR";
    bt.setAttribute("onclick", "initEditor(this)");
    
    // BACKUP LABEL
    var elm = document.getElementById("backupButtonArea");
	elm.innerHTML = "";
    var bt = newDIV(elm, "/white-tab");
    bt.innerHTML = "BACK UP";

    // mainMenu のバックアップ・ファイルのリストをサーバへリクエスト
    getBackupList("menu");
}

