
/////////////////////////
///// カルテからの継承値 ///

function noa(){
    if (window.opener.name == "noa"){
        return window.opener;
    } else if (window.opener.name == "tools"){
        return window.opener.top.noa;
    } else if (window.top.noa){
        return window.top.noa;
    } else {
        alert("ERROR *** groupMenuEditor.js: window.opener としての NOA が見つかりません");
        return null;
    }
}

// owner(), tag() などは他とカブりエラーになるので noa().owner() のような使い方

///// カルテからの継承値 ///
/////////////////////////

function savedGroupMenuEditor(answer){
    //alert("== savedGroupMenuEditor->"+answer); //##

    // tag 要素を削除しておけば、後の kickCellEditor() で再読込される
    // kickCellEditor() 起動まで他の処理で時間を稼いだ方が良いようだ
    cp_parent().removeMenusForTag(cp_parent().currentTag());

    // エディターを閉じる
    window.top.tools.document.getElementById("base").innerHTML = "";
    
    // CellEditor のポップアップ更新
    cp_parent().kickCellEditor(cp_parent().currentTag()); // Ajax
}
function saveGroupMenuEditor(){
    // 確定ボタン：グループ・メニュ内容ーをサーバへ保存
    _debug("== saveGroupMenuEditor =="); //##
    
    var obj = groupMenuObject();
    var subItems = new Object();
    var menuItem = "";
    for (tag in obj){
        if (tag == noa().currentTag()) menuItem = obj[tag];
        
        // グループメニューを持つ cell も meuItem と重複するがsubItems に取込む
        subItems[tag] = obj[tag];
    }

    if (menuItem.length > 0)
        NRPutGroupMenu(noa().owner(), menuItem, "0", subItems, savedGroupMenuEditor);
    else
        alert("グループ名となる「主訴」が空欄です。やり直してください");
}

function groupMenuObject(){
    // サーバへ書き戻すためのグループメニュー・データ
    var obj = new Object();
    // 選択されているメニュー項目名
    var array = noa().progressTagArray();
    for (num in array){
        var tag = array[num];
        var elm = document.getElementById(tag+"F");
        if (!elm) continue; // pageHeader のフィールドは存在しない
        
        var val = elm.value;
        //alert(tag+" -> "+val); //##
        obj[tag] = val;
    }
    obj['freq'] = document.getElementById("freqF").value;

    _debug("groupMenuObject->"+encodeObject(obj)); //##
    
    return obj;
}

function groupMenuHelp(){
	// ヘルプパネルを表示
    window.open("./groupPrefHelp.html","Help"
                ,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function openGroupMenuEditor(){
    // GROUP MENU EDITOR を生成
    _initDebug(false); //##
    _debug("== openGroupMenuEditor =="); //##
    
    var elm = document.getElementById("groupEditorArea");
    if (elm.innerHTML.length){
        elm.innerHTML = "";
        return;
    }
    
    elm.innerHTML = "";
    var td = newTD(elm, "groupMenuEditorArea", "");
    td.setAttribute("colspan", "2");
    var tbl = newTABLE(td, "/base-table");
    tbl.style.fontSize = "9pt";
    tbl.style.margin = "3px 3px";
    
    var tr = newTR(tbl, "gmenuArea", "");

    // 選択されているメニュー項目名
    var itemElm = document.getElementById("menuItem");
    var selectedItem = (itemElm) ? itemElm.value : "";
    var array = noa().progressTagArray();
    for (num in array){
        var tag = array[num];
        if (tag == "ProgressSection.pageHeader") continue;
        
        var label = noa().cellForTag(tag).label;
        var tr = newTR(tbl, "", "");
        var td = newTD(tr, "", label);
        td.style.verticalAlign = "top";
        var td = newTD(tr, "", "");
        if (tag == noa().currentTag()){
            // 主訴欄：グループ・メニュー名
            var fd = newFIELD(td, tag+"F", "", 40, selectedItem);
            fd.setAttribute("required"); // 入力必須を指定
            _debug("field "+ tag+"F"); //##
            
            // 頻度
            var freq = freqForItem(selectedItem);
            var fd = newFIELD(td, "freqF", "頻度", 5, freq);
        } else {
            var value = "";
            for (n in _menuArray){
                var rec = _menuArray[n];
                if (rec.menu == selectedItem) value = rec[tag];
                if (!value) value = "";
            }
            var fd = newTEXTAREA(td, tag+"F", 40, 4, value);
            _debug("field "+ tag+"F"); //##
            
        }
    }
}

function showGroupMenuEditor(){
    // GROUP MENU の開閉ボタンを表示
    var elm = document.getElementById("groupMenuEditorArea");
    if (!elm) return;
    
    elm.innerHTML = "";
    var tbl = newTABLE(elm, "base-table");
    tbl.style.fontSize = "9pt";
    tbl.style.margin = "3px 3px";
    
    var tr = newTR(tbl, "gmenuArea", "");
}

function closeGroupMenuEditor(){
    var elm = window.top.tools.document.getElementById("base");
	elm.innerHTML = "";
}
function initGroupMenuEditor(){
    _initDebug(true); //##
    // グループメニュー・エディターを単独で開く場合に起動
    // cellPreference から使う場合は initGroupMenuEditor() は使わない
    var elm = window.top.tools.document.getElementById("base");
	elm.innerHTML = "";

    // HEADER =============================
    var div = newDIV(elm, "/yellow-header");
    var dv = newDIV(div, "/left-side");
    dv.style.width = "80%";
    var sp = newSPAN(dv, "");
    sp.style.paddingRight = "5px";
    var im = newIMAGE(sp, "icon", "./close.png", "X");
    im.style.width = "12px";
    im.setAttribute("onclick", "closeGroupMenuEditor()");
    var sp = newSPAN(dv, "");
    sp.innerHTML = "グループ・メニューへ新規メニュー追加";
    var dv = newDIV(div, "/right-side");
	var im = newIMAGE(dv, "", "./help.png", "?");
	im.setAttribute("onclick", "groupMenuHelp()");
	im.style.height = "18px";
	im.style.verticalAlign = "bottom";

    // CONTENTS ==========================
    var div = newDIV(elm, "groupEditorArea");
    div.style.backgroundColor = "#ffe";
    openGroupMenuEditor();
    window.top.tools.document.getElementById(noa().currentTag()+"F").focus();
    
    // FOOTER ==========================
    var div = newDIV(elm, "/yellow-footer");
    var dv = newDIV(div, "/left-side");
    dv.style.width = "80%";
    var bt = newDIV(dv, "/fixButton");
    bt.innerHTML = "グループ・メニュー編集内容を確定";
    bt.setAttribute("onclick", "saveGroupMenuEditor()");
}


