// javascript library

function _clearDebug(){
    // デバッグ・メッセージ領域をクリア
    document.getElementById("_debug").innerHTML = "";
}
function _debug(st){
    // メッセージ領域に st を追加表示
    
    // ### debug message を出さないようにするにはこの行を生かす ###
    //return;
    
    if (st == "_CLEAR_"){
        // メッセージ領域を初期化
        document.getElementById("_debug").innerHTML = "";
    } else {
        var elm = document.getElementById("_debug");
        var buff = elm.innerHTML;
        elm.innerHTML = buff + st + "<br/>";
    }
}

function nengouArray(){
	return ["西暦","平成","昭和","大正","明治"];
}

/*
 else if (st == "日雇一般")
 return "03^日雇特例被保険者（一般療養）";
 else if (st == "日雇特別")
 return "04^日雇特例被保険者（特別療養）";
 else if (st == "結核適正")
 return "10^感染症予防医療法 結核 適正医療";
 else if (st == "結核従禁")
 return "11^感染症予防医療法 結核 従業禁止等";
 else if (st == "生保")
 return "12^生活保護法";
 else if (st == "戦傷療養")
 return "13^戦傷病者特別保護法 療養";
 else if (st == "戦傷更正")
 return "14^戦傷病者特別保護法 更正";
 else if (st == "自立更正")
 return "15^自立支援法 更正医療";
 else if (st == "自立育成")
 return "16^自立支援法 育成医療";
 else if (st == "児童")
 return "17^児童福祉法 療養の給付";
 else if (st == "原爆")
 return "18^原爆被爆者 認定疾病医療費";
 else if (st == "被爆")
 return "19^被爆者医療";
 else if (st == "精神")
 return "20^精神衛生法 措置入院";
 else if (st == "自立")
 return "21^自立支援法 通院医療";
 else if (st == "麻薬")
 return "22^麻薬取締法 措置入院";
 else if (st == "感染一類")
 return "28^感染症予防・医療法 一類感染者の入院";
 else if (st == "感染新")
 return "29^感染症予防・医療法 新感染症患者の入院";
 return "51^特定疾患治療研究";
 else if (st == "小児")
 return "52^小児慢性特定疾患治療研究";
 else if (st == "児童福祉")
 return "53^児童福祉法・精神薄弱福祉法";
 else if (st == "特例退職")
 return "63^特例退職者医療（健保組合）";
 else if (st == "石綿")
 return "66^石綿による健康被害救済の法律";
 else if (st == "国公退職")
 return "72^特例退職者 (国家公務員共済組合)";
 else if (st == "地公退職")
 return "73^特例退職者 (地方公務員等共済組合）";
 else if (st == "警察退職")
 return "74^特例退職者 (警察共済組合)";
 else if (st == "学校退職")
 return "75^特例退職者 (学校共済組合)";
 else if (st == "自費")
 return "OE^自費";
 else if (st == "公費")
 return "PE^公費";
 else if (st == "公害")
 return "PI^公害";
 else if (st == "労災")
 return "LI^労災";
 else if (st == "自賠")
 return "TI^自賠";
 else if (st == "自賠")
 return "TI^自賠";
 else if (st == "公務災害")
 return "PS^公務員災害";
 */

function insTable(){
	// HL7 保険種別（IOB_Insurance）を基準に設定
	return [" :","国保:C0^国民健康保険","国保退職:67^国民健康保険退職者","組合:06^組合管掌健康保険","政府:01^政府管掌健康保険","協会:KY^協会","学校共済:34^学校共済組合","警察共済:33^警察共済組合","国家共済:1^国家公務員共済組合","地方共済:332^地方公務員等共済組合","船員:02^船員保険","後期高齢:KK^後期高齢者","自衛:07^自衛官等","母子:23^母子保健法","老人:27^老人保健法による老人医療","その他:OT^その他"];
}
var _insArray;
function insArray(){
	// (" ","国保","組合"..) のような配列
	if (!_insArray){
		var array = insTable();
		_insArray = new Array();
		for (var i=0,ct=array.length; i < ct; i++){
			var st = array[i];
			var ary = st.split(":");
			_insArray.push(ary[0]);
		}
	}
	return _insArray;
}

function publicInsArray(){
	return [" : ","老人:3","一人親:3","一人親(食):0","一人親(一部 食):1","子:0","障害:3","障害(食):0"];
}
function publicInsItems(){
	// (" ","老人","一人親"..) のような配列
	var array = new publicInsArray();
	var items = new Array();
	for (var i=0,ct=array.length; i < ct; i++){
		var st = array[i];
		var ary = st.split(":");
		items.push(ary[0]);
	}
	return items;
}
function publicInsObjects(){
	// insObj["老人"] = "3" (割)のようなオブジェクト
	var array = new publicInsArray();
	var objects = new Array();
	for (var i=0,ct=array.length; i < ct; i++){
		var st = array[i];
		var ary = st.split(":");
		var item = ary[0];
		objects[item] = (ary.length > 1) ? ary[1] : "3";
	}
	return objects;
}

function setColor(element, color, bgcolor){
	element.style.backgroundColor=bgcolor;
	element.style.color=color;
}

function resetColor(element, color, bgcolor){
	element.style.backgroundColor=bgcolor;
	element.style.color=color;
}

function foldNode(id){
	// id で識別されたノードを開いたり閉じたりする
	var elm = document.getElementById(id);
	if (elm){
		if (elm.style.display == "none")
			elm.style.display = "block"; // 表示する
		else
			elm.style.display = "none"; // 表示しない
	}
}

function currentDateTime(){
	// 現在の時刻を文字列で返す
	date = new Date();
	yy = date.getYear();
	mm = date.getMonth() + 1;
	dd = date.getDate();
	if (yy < 2000) { yy += 1900; }
	if (mm < 10) { mm = "0" + mm; }
	if (dd < 10) { dd = "0" + dd; }
	hr = date.getHours();
	if (hr < 10) { hr = "0" + hr; }
	mn = date.getMinutes();
	if (mn < 10) { mn = "0" + mn; }
	sc = date.getSeconds();
	if (sc < 10) { sc = "0" + sc; }
	return yy + "-" + mm + "-" + dd + " " + hr + ":" + mn + ":" + sc;
}

function isSame(st1, st2){
	return ((st1.length == st2.length) && (st1.indexOf(st2) == 0)) ? 1 : 0
}

function isSameDate(st1, st2){
	// 年月日が同じかどうかをチェック
	var dt1 = dt1.substr(0, 10);
	var dt2 = dt2.substr(0, 10);
	return ((dt1.length == dt2.length) && (dt1.indexOf(dt2) == 0)) ? 1 : 0
}

function trim(value){
	for (var i=0, len =value.length; i < len; i++){
		var ch = value.charAt(i);
		if ((ch == " ") || (ch == "\n") || (ch == "\r") || (ch == "\t")) continue;
		break;
	}
	value = value.substring(i);
	for (var i=value.length-1; i >= 0; i--){
		var ch = value.charAt(i);
		if ((ch == " ") || (ch == "\n") || (ch == "\r") || (ch == "\t")) continue;
		break;
	}
	return value.substr(0, i+1);
}

function trimDoubleQuotation(value){
	if (value.charAt(0) == "\"") value = value.substring(1);
	if (value.charAt(value.length-1) == "\"")
		value = value.substring(0, value.length-1);
	
	return value;
}

function replaceAll(st, regexp, newstring){
	// st 中の regexp に相当する文字をすべて newstring に置換して返す
	while (st.indexOf(regexp) >= 0)
		st = st.replace(regexp, newstring);
	return st;
}

/*
function encodeObject(obj){
	// obj を "key(value)" に encode して返す
	var buff = "";
	for (key in obj){
		var value = obj[key];
		if (typeof(value) == "object"){
			buff += key + "(" + encodeObject(value) +")";
		} else {
			// "(", ")" は特定文字にしておく（ decode する時に元へ戻す）
			var array = value.split("(");
			value = array.join("^[^");
			var array = value.split(")");
			value = array.join("^]^");
			buff += key + "(" + value +")";
		}
	}
	return buff;
}
function decodeObject(buff){
	// "key(value)" 形式を OBJECT に変換して返す
	var obj = new Object();
	var len = buff.length, begin, end;
	var key, value;
	for (var p=begin=nest=0; p < len; p++){
		var ch = buff.charAt(p);
		if (ch == '('){
			if (nest == 0){
				key = trim(buff.substring(begin, p)); // key 終端
				begin = p + 1; // value 開始位置
			}
			nest++;
		} else if (ch == ')'){
			if (--nest == 0){
				if (nest == 0){
					value = trim(buff.substring(begin, p)); // value 終端
					begin = p + 1; // key 開始位置
				}
				
				if (value.indexOf(")") > 0){ // まだ入れ子になっているなら
					obj[key] = decodeObject(value);
				} else {
					// 特定文字を "(", ")" へ戻す
					var array = value.split("^[^");
					value = array.join("(");
					var array = value.split("^]^");
					value = array.join(")");
					
					obj[key] = value;
				}
			}
		}
	}
	return obj;
}
*/
var _leftbrackets = "^[^"; // encode 中で使う '('
var _rightbrackets = "^]^"; // encode 中で使う ')'
function encodeObject(obj){
	// obj を "key(value)" の文字列に encode して返す -- NOA format と呼ぶ
	// encode 方法として JSON 形式その他が考えられるが NOA format が最も軽いので採用
	// ### 現状では配列はサポートしていない
	var buff = "";
	for (key in obj){
		var value = obj[key];
		
		if (typeof(value) == "object"){
			buff += key + "(" + encodeObject(value) +")";
		} else {
			// "(", ")" は特定文字にしておく（ decode する時に元へ戻す）
			/*
			 value = value + ""; // 文字列にしておく
			if (value.indexOf(")") >= 0)
			 alert("hasBranckets ->"+value);
			var array = value.split("(");
			value = array.join(_leftbrackets);
			var array = value.split(")");
			value = array.join(_rightbrackets);
			 */
			
			buff += key + "(" + value +")";
		}
	}
	return buff;
	
	//var buff = "";
	// for (key in obj){
	//buff += key + "_|_" + obj[key] + "_||_";
	//}
	// return buff.substr(0, buff.length - 4);
}
function decodeObject(buff){
	// "key(value)" 形式の文字列を OBJECT に decode して返す
	var obj = new Object();
	var len = buff.length, begin, end;
	var key, value;
	for (var p=begin=nest=0; p < len; p++){
		var ch = buff.charAt(p);
		if (ch == '('){
			if (nest == 0){
				key = trim(buff.substring(begin, p)); // key 終端
				begin = p + 1; // value 開始位置
			}
			nest++;
		} else if (ch == ')'){
			if (--nest == 0){
				if (nest == 0){
					value = trim(buff.substring(begin, p)); // value 終端
					begin = p + 1; // key 開始位置
				}
				
				if (value.indexOf(")") > 0){ // まだ入れ子になっているなら
					obj[key] = decodeObject(value);
				} else {
					// 特定文字を "(", ")" へ戻す
					/*
					var array = value.split(_leftbrackets);
					value = array.join("(");
					var array = value.split(_rightbrackets);
					value = array.join(")");
					 */
					
					obj[key] = value;
				}
			}
		}
	}
	return obj;
}

function object2json(obj){
	// オブジェクトを JSON 形式の文字列にして返す
	var buff = "{";
	for (key in obj){
		var val = obj[key];
		if (typeof(val) == "object"){
			buff += '"' + key + '":' + object2json(val) + ',';
		} else {
			buff += '"' + key + '":"' + val + '",';
		}
	}
	buff = buff.substr(0, buff.length-1) + "}";
	return buff;
}

function encodeSTRING(val){
	// #, &, + などが URI 送信で化けるため encode して送る
	var array = val.split("#");
	val = array.join("%x0;");
	array = val.split("&");
	val = array.join("%x1;");
	array = val.split("+");
	return array.join("%x2;");
}

function decodeArgs(buff){
	return buff.split("_|_");
}

function makeArray(firstItem, count){
	// firstItem から count 数の配列を作成して返す
	var array = new Array();
	for (var i=0; i < count; i++)
		array[i] = firstItem++;
	return array;
}

function seirekiWithWareki(koyomi, yy){
	// 和暦年を西暦年に変換して返す
	yy = yy * 1;
	if (isSame(koyomi,"平成"))
		yy += 1988;
	else if (isSame(koyomi,"昭和"))
		yy += 1925;
	else if (isSame(koyomi,"大正"))
		yy += 1911;
	else if (isSame(koyomi,"明治"))
		yy += 1867;
	return yy;
}

///////////////////////////
/// Ajax による処理 /////////

function _debug(){
	// rowid のレコードをサーバから読込み
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		alert(value);
		document.getElementById("message").innerHTML = value;
	}
	else 
		document.getElementById("message").innerHTML = "Loading...";
}

function createXMLHttpRequest(func){
	var xmlHttpObject = null;
	
	if (window.XMLHttpRequest){ // Safari, Firefox
		xmlHttpObject = new XMLHttpRequest();
	} else if (window.ActieXObject){ // IE
		try{
			xmlHttpObject = new ActiveXObject("Msxml2.XMLHTTP"); // IE6
		} catch(e){
			try{
				xmlHttpObject = new ActiveXObject("Microsoft.XMLHTTP"); // IE5
			} catch(e){
				return null;
			}
		}
	}
	
	// xmlHttpObject が生成できたら、状態が変わった時に func が実行される
	if (xmlHttpObject) xmlHttpObject.onreadystatechange = func;
	return xmlHttpObject;
}

/// Ajax による処理 /////////
///////////////////////////



