
/////////////////////////////////////////////
///// Ajax //////////////////////////////////

function gotPath(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("gotPath ->"+value);//##
        
        setDefaultPath(value);
        
        if (style() == "board")
            showMenu();
        else
            showMap();
        
		hideMessage("_message");
	} 
}
function getPath(){
    // filename をサーバから読み出す
    xmlHttpObject = createXMLHttpRequest(gotPath);
    if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
        var array = new Array();
        array["owner"] = owner();
        // array["menu"] = "1"; -- ここはドキュメントの path なので不要
        
        var st = "./server.php?command=GET_PATH"
        + "&value=" + encodeObject(array);
        //alert("getPath->"+st); //===
        
        xmlHttpObject.open("GET", encodeURI(st), true);
        xmlHttpObject.send(null);
    }
}

function gotFile(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("gotFile ===\n"+value);//##
        
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
			//alert(array[1]);
            var obj = decodeObject(array[1]);
            setMenuObj(obj);
		} else {
            var array = new Array();
            array.push(" メニューが作成されていないので サンプル・メニューを表示します。");
            array.push("適当に編集してください。");
            var msg = array.join("");
            showFadeoutInfo("message", msg, 3000);
        }
        getPath();
		hideMessage("_message");
	} else 
		showMessage("_message", "サーバで処理中です ... ");
}
function getFile(filename){
    // filename をサーバから読み出す
    xmlHttpObject = createXMLHttpRequest(gotFile);
    if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
        var array = new Array();
        array["owner"] = owner();
        array["menu"] = "1";
        array["filename"] = filename;
        
        setFileName(filename);
        
        var st = "./server.php?command=GET_FILE"
        + "&value=" + encodeObject(array);
        //alert("getFile->"+st); //===
        
        xmlHttpObject.open("GET", encodeURI(st), true);
        xmlHttpObject.send(null);
    }
}

var _mainMenu;
function gotSubMenu(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("gotSubMenu ===\n"+value);//##
        
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
			//alert(array[1]); //##
            
            var obj = decodeObject(array[1]);
            setSubMenuObjForMainMenu(obj, _mainMenu);
        }
        if (style() == "board")
            showSubMenuFor(_mainMenu);
        else
            showSubMapFor(_mainMenu);
        
		hideMessage("_message");
	} else 
		showMessage("_message", "サブメニューをリクエストしています ... ");
}
function getSubMenu(mainMenu){
    // SUBMENU をサーバへリクエスト
    xmlHttpObject = createXMLHttpRequest(gotSubMenu);
    if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
        var array = new Array();
        array["owner"] = owner();
        array["menu"] = "1";
        array["filename"] = menuForMainMenu(mainMenu);
        
        _mainMenu = mainMenu;
        
        var st = "./server.php?command=GET_FILE"
        + "&value=" + encodeObject(array);
        //alert(st); //===
        
        xmlHttpObject.open("GET", encodeURI(st), true);
        xmlHttpObject.send(null);
    }
}

///// Ajax //////////////////////////////////
/////////////////////////////////////////////

/////////////////////////
///// localStorage //////

function checkNOA(){
    // NOA から得られた owner を localStorage に記憶
    if (window.opener && (window.opener.name == "noa")){
        window.localStorage["infoBorderOwner"] = window.opener.owner();
    } else if (window.top && (window.top.noa)){
        window.localStorage["infoBorderOwner"] = window.top.noa.owner();
    } else {
        alert("Window opener としての NOA が見つかりません");
    }
}

function setStyle(style){
    window.localStorage["infoBordStyle"] = style;
}
function style(){
    // 表示スタイルを返す
    return window.localStorage["infoBordStyle"];
}

///// localStorage //////
/////////////////////////


var _parents;
function setParentForRow(parent, num){
    if (!_parents) _parents = new Object();
    
    _parents[num] = parent;
}
function parentForRow(num){
    // num は欠番あり
    return _parents[num];
}

var _rows;
function setRows(num){
    _rows = num;
}
function rows(){
    return _rows;
}

var _filename;
function setFileName(name){
    _filename = name;
}
function fileName(){
    return _filename;
}
function isMainMenu(){
    return (_filename == "menu.txt") ? true : false;
}

function openEditor(){
    // Editor を開く
	window.open("./editor.php", "contents");
}

function clickedTitle(row){
    // row 行目のタイトルがクリックされた
    var parent = parentForRow(row);
    var array = parent.children;
    
    for (row in array){
        // 子供 row をトグル式に折畳む
        var elm = document.getElementById("row."+row);
        if (elm.style.display == "none")
            elm.style.display = "block"; // 表示する
        else
            elm.style.display = "none"; // 表示しない
    }
}

var _isShrink;
function shrink(mainMenu, subMenu){
    // subMenu の子供全体を収縮 / その subMenu のみ expand
    // の動作をトグル式に実行
    var isOpen;
    if (_isShrink){
        // 選択された subMenu 所属の URI 行を展開
        var recs = subMenuObjForMainMenu(mainMenu);
        for (sbMenu in recs){
            var uri = trim(recs[sbMenu]);
            
            if (uri.length == 0){ // TITLE only
                isOpen =  (sbMenu == subMenu) ? true : false;
            } else { // TITLE with ANCHOR
                var elm = document.getElementById("row." + sbMenu);
                if (isOpen){
                    elm.style.display = "block"; // 表示する
                }
            }
        }
        _isShrink = false;
    } else {
        // すべての URI 行を収縮
        var recs = subMenuObjForMainMenu(mainMenu);
        for (sbMenu in recs){
            var uri = trim(recs[sbMenu]);
            
            if (uri.length == 0){ // TITLE only
            } else { // TITLE with ANCHOR
                var elm = document.getElementById("row." + sbMenu);
                elm.style.display = "none"; // 表示しない
            }
        }
        _isShrink = true;
    }
}

function showSubMenuFor(mainMenu){
    // mainMenu に所属する subMenu を表示
	var elm = document.getElementById("contents");
	elm.innerHTML = "";
    
    //alert("showSubMenuFor->"+defaultPath()); //##
    
    var recs = subMenuObjForMainMenu(mainMenu);
    for (subMenu in recs){
        var uri = trim(recs[subMenu]);
        var dv = newDIV(elm, "row." + subMenu);
        dv.style.padding = "0px 5px";
        
        if (uri.length == 0){ // TITLE only
            dv.innerHTML = "○ " + subMenu;
            dv.style.backgroundColor = "#cfd";
            dv.style.borderTop = "2px solid #fff";
            dv.setAttribute("class", "subTitle");
            var action = "shrink('"+mainMenu+"','"+subMenu+"')";
            dv.setAttribute("onclick", action);
        } else { // TITLE with ANCHOR
            if (uri.charAt(0) == "*"){
                // * で始まる anchor は * を defaultPath() に読み替える
                // ##### この機能は path としてうまく機能していない #####
                uri = defaultPath() + "/" + uri.substr(1);
            }
            dv.style.padding = "0px 20px";
            
            //if (uri.indexOf("http") < 0)  uri = "../" + uri; // /X/NOA の場合
            
            var a = newA(dv, subMenu, uri, "contents");
        }
        
    }
}
function openSubMenu(elm){
    // mainMenu がクリックされた
    var mainMenu = trim(elm.innerHTML);
    showMainHeader(mainMenu);
    
    // 外部ファイルがなかった場合 default のメニューを表示するため _mainMenu をセット
    _mainMenu = mainMenu;
    
    // 外部ファイルを探しにゆく：外部ファイルがなかったら default を表示
    getSubMenu(mainMenu);
}

////////////////////////////////////////////////////
///// MAP STYLE ////////////////////////////////////

function shrinkMap(mainMenu){
    // mainMenu の子供をトグル式に折畳む
    var elm = document.getElementById("label."+mainMenu);
    if (elm.style.display == "none")
		elm.style.display = "block"; // 表示する
	else
		elm.style.display = "none"; // 表示しない
}

var _mainMenus;
var _mainMenuNumber;
function showSubMapFor(mainMenu){
    // mainMenu に所属する subMenu を表示
	var tbl = document.getElementById("mapTable");
    var tr = newTR(tbl, "", "");
    tr.style.border = "thin solid #aaa";
    
    // MAIN MENU
    var td = newTD(tr, "subMenu", mainMenu);
    td.style.border = "thin solid #aaa";
    td.style.width = "50px";
    
    // SUB MENU AREA
    var td = newTD(tr, "label."+mainMenu, "");
    var obj = subMenuObjForMainMenu(mainMenu);
    for (subMenu in obj){
        // SUB MENU
        var sp = newSPAN(td, "URI");
        var uri = trim(obj[subMenu]);
        if (uri.length){ // ANCHOR 付きの SUB MENU
            if (uri.charAt(0) == "*"){
                // * で始まる anchor は * を defaultPath() に読み替える
                uri = defaultPath() + "/" + uri.substr(1);
            } else {
                // if (uri.indexOf("http") < 0)  uri = "../" + uri; // /X/NOA の場合
            }
            var a = newA(sp, subMenu, uri, "_blank");
        } else { // TITLE としての SUB MENU
            sp.innerHTML = subMenu;
            sp.style.color = "#fff";
            sp.style.backgroundColor = "#396";
        }
    }
    
    // _meinMenus 全てをスキャンするまで再起的にサーバへリクエスト
    if (++_mainMenuNumber < _mainMenus.length)
        getSubMenu(_mainMenus[_mainMenuNumber]);
}

function showMap(){
    // menuObj を map に展開
    var mObj = menuObj();
	var elm = document.getElementById("contents");
	elm.innerHTML = "";
    var tbl = newTABLE(elm, "mapTable");
    
    // mainMenu の配列を生成
    _mainMenus = new Array();
    for (mainMenu in mObj){
        _mainMenus.push(mainMenu);
    }
    // SUBMENU をサーバへリクエスト
    _mainMenuNumber = 0;
    getSubMenu(_mainMenus[_mainMenuNumber]);
}

function openBoard(){
    setStyle("board");
    showHeader();
    getFile("menu.txt");
}
function openMap(){
    setStyle("map");
    showHeader();
    getFile("menu.txt");
}

///// MAP STYLE ////////////////////////////////////
////////////////////////////////////////////////////

function showMenu(){
    // menu を表示する
    showMainHeader();
	
	var elm = document.getElementById("contents");
	elm.innerHTML = "";
    elm.style.clear = "both";

    var recs = menuObj();
    for (mainMenu in recs){
        // subMenu
        var dv = newDIV(elm, "/blueButton");
        dv.innerHTML = mainMenu;
        dv.setAttribute("onclick", "openSubMenu(this)");
    }
}

function showMainHeader(title){
    // ヘッダーの表示を mainMenu / subMenu に応じ変化させる
	var elm = document.getElementById("headerLeft");
    
    if (title && (title.length)){
        elm.innerHTML = "";
        var bt = newDIV(elm, "/white-tab");
        bt.innerHTML = "";

        var img = newIMAGE(bt, "", "./home.png", "home");
        img.style.height = "12px";
        img.style.position = "relative";
        img.style.top = "2px";
        img.setAttribute("onclick", "initMenu()");

        var sp = newSPAN(bt, "");
        sp.style.marginLeft= "10px";
        sp.style.position = "relative";
        sp.style.top = "1px";
        sp.innerHTML = title;
    } else {
        elm.innerHTML = "";
        var bt = newDIV(elm, "/white-tab");
        bt.style.paddingTop = "3px";
        bt.innerHTML = "INFO BOARD";
    }
}

function showHeader(){
    // style によりヘッダーの構成を変える
    var elm = document.getElementById("headerLeft");
    elm.innerHTML = "";
    
    // -- LEFT
    var elm = document.getElementById("styleButtonArea");
    elm.innerHTML = "";
    if (style() == "board"){
        var bt = newDIV(elm, "/gray-tab");
        bt.innerHTML = "INFO MAP";
        bt.setAttribute("onclick", "openMap()");

        // board の場合のみ
        showMainHeader();
    } else {
        var bt = newDIV(elm, "/gray-tab");
        bt.innerHTML = "INFO BOARD";
        bt.setAttribute("onclick", "openBoard()");
        var bt = newDIV(elm, "/white-tab");
        bt.innerHTML = "INFO MAP";
    }
    
    // -- RIGHT
    var elm = document.getElementById("headerRight");
    elm.innerHTML = "";
    var img = newIMAGE(elm, "", "./info.png", "zoom");
    img.style.height = "17px";
    img.setAttribute("onclick","openHelp()");
}

function openHelp(){
	// ヘルプパネルを表示
	var win = window.open("./help.html","Help"
                          ,"width=450,height=700,scrollbars=yes,resizable=yes");
	win.focus();
}

function initMenu(){
    checkNOA();

	var elm = document.getElementById("base");
	elm.innerHTML = "";

    // HEADER
    var div = newDIV(elm, "/tool-header");
    var dv = newDIV(div, "/left-side");
    var spn = newSPAN(dv, "headerLeft");
    var spn = newSPAN(dv, "styleButtonArea");
    var dv = newDIV(div, "/right-side");
    dv.style.width = "100px";
    var spn = newSPAN(dv, "headerRight");
    
    // CONTENTS
    var div = newDIV(elm, "contents");

    // FOOTER
    var div = newDIV(elm, "/tool-footer");
    // -- LEFT
    var dv = newDIV(div, "/left-side");
    var img = newIMAGE(dv, "", "./hammer.png", "pref");
    img.style.height = "15px";
    img.setAttribute("onclick", "openEditor()");
    // -- RIGHT
    var dv = newDIV(div, "/right-side");
    dv.innerHTML = version();

    showHeader();
    getFile("menu.txt");
}

function version(){
    return "Ver.131006";
}

