
/////////////////////////
///// カルテからの継承値 ///

function _noa(){
    // noa() と window.top.noa がバッティングするので _noa() を使う
    if (window.opener && (window.opener.name == "noa")){
        return window.opener;
    } else if (window.opener && (window.opener.name == "tools")){
        return window.opener.top.noa;
    } else if (window.top && window.top.noa){
        return window.top.noa;
    } else {
        //alert("ERROR *** archiveer.js: window.opener としての NOA が見つかりません");
        return null;
    }
}

function patientId(){
    return (_noa()) ? _noa().patientId() : null;
}

function patientName(){
    return (_noa()) ? _noa().patientKanjiName() : null;
}

///// カルテからの継承値 ///
/////////////////////////

///////////////////////////////////
/// localStorage による処理 /////////

var _largeSize = 250;
var _middleSize = 80;
var _smallSize = 30;

function setThumbnailSize(elm){
    // サムネイル・サイズを変更
    if (elm.value == "大")
        window.localStorage["pictureThumbNailSize"] = _largeSize;
    else if (elm.value == "中")
        window.localStorage["pictureThumbNailSize"] = _middleSize;
    else
        window.localStorage["pictureThumbNailSize"] = _smallSize;
    
    // サムネイルを再表示
    getImages();
}

function thumbNailSize(){
    // サムネイル・サイズを返す
    var size = window.localStorage["pictureThumbNailSize"];
    return (size) ? size : _middleSize;
}

function thumbNailSizeName(){
    // サムネイル・サイズの名前を返す
    var size = thumbNailSize() * 1;
    switch(size){
        case _largeSize: return "大";
        case _smallSize: return "小";
        default: return "中";
    }
}

function getWindowSize(){
	// Picture tool のウインドー位置とサイズをサーバへリクエスト
    var size = window.localStorage["pictureToolWindowSize"];
    
	// サーバから得られたサイズにウインドーを調整する
	if (size){
		var args = size.split(",");
		var x = args[0] * 1;
		var y = args[1];
		var w = args[2];
		var h = args[3];
		// resize を先にしておかないと元が大きいサイズだった場合 moveTo しよう
		// としてもウインドー境界の制限で移動できない場合がある
		window.resizeTo(w, h);
		window.moveTo(x, y);
        
        //alert("getWindowSize->"+size); //##
	}
}
function putWindowSize(){
	// Picture tool のウインドー位置とサイズをサーバへ記憶
    if (window.name != "tools"){
        // tool area で開いた場合はサイズを記憶しない
        var x = window.screenLeft;
        var y = window.screenTop - 22;
        var w = window.outerWidth;
        var h = window.outerHeight;
        var array = [x, y, w, h];
        window.localStorage["pictureToolWindowSize"] = array.join(",");
        
        showFadeoutInfo("messageArea", "ウィンドー・サイズを記憶しました", 800);
    }
}

/// localStorage による処理 /////////
///////////////////////////////////



///////////////////////////
/// Ajax による処理 /////////

function gotImages(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("gotImages ===\n"+value);//##
        
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            var obj = JSON.parse(array[1]);
            
            showIconsVertical(obj.path, obj.files);
        }
		hideMessage("_message");
	} else
		showMessage("_message", "サーバで処理中です ...");
}
function getImages(){
    // 画像ファイルのリストをサーバへリクエスト
	xmlHttpObject = createXMLHttpRequest(gotImages);
	if (xmlHttpObject){
        // encodeURI は '&' をエンコードしてくれないのでこちら側でエンコード
        // ### send() に与える文字列:st 全体をエンコードしては駄目 ###
        var st = "key=GET_DIRECTORY";
        st += "&container=" + patientId();
        
        xmlHttpObject.open("POST", "pictServer.php", true);
        xmlHttpObject.setRequestHeader('Content-Type','application/x-www-form-urlencoded; charset=UTF-8');
		//alert("getImages ====\n"+st); //##
        xmlHttpObject.send(st);
	}
}

function removeImage(path, filename){
    // filename を削除
    if (! confirm(filename + "　の画像を削除します")){
        return;
    }
    
	xmlHttpObject = createXMLHttpRequest(gotImages);
	if (xmlHttpObject){
        // encodeURI は '&' をエンコードしてくれないのでこちら側でエンコード
        // ### send() に与える文字列:st 全体をエンコードしては駄目 ###
        var st = "key=REMOVE_IMAGE";
        st += "&container=" + patientId();
        st += "&value=" + path + "/" + filename;
        
        xmlHttpObject.open("POST", "pictServer.php", true);
        xmlHttpObject.setRequestHeader('Content-Type','application/x-www-form-urlencoded; charset=UTF-8');
		//alert("removeImage ====\n"+st); //##
        xmlHttpObject.send(st);
	}
}

/// Ajax による処理 /////////
///////////////////////////


function showIconsVertical(path, files){
	// 添付ファイルをサムネールとして縦横表示
	var div = document.getElementById("thumbNailGallery");
	div.innerHTML = "";
    var ul = newUL(div, "");
    ul.style.margin = "0";
    ul.style.paddingLeft = "8px";
	
	// image ファイル名の配列を生成
	//var path = "/NOA_ARCHIVE/"+patientId()+"/";
	var filename;
	for (num in files){
		filename = files[num];
		if (filename.charAt(0) == ".") continue;

        // image のクリックで別パネルに image 表示
        makeImagePane(ul, path, filename);
	}
}

/*
////////////////////////////////////////////////////////
///// DRAG and DROP ////////////////////////////////////

function f_dragover(event){
    // ドラッグ要素がドロップ要素に重なっている間の処理
    //　dragoverイベントをキャンセルして、ドロップ先の要素がドロップを受け付けるようにする
    event.preventDefault();
}

function f_dragstart(event, value){
    // ドラッグ開始時の処理
    
    // ドラッグするデータのid名をDataTransferオブジェクトにセット
//    event.dataTransfer.setData("text", value);
}

///// DRAG and DROP ////////////////////////////////////
////////////////////////////////////////////////////////
*/

function makeImagePane(ul, path, file){
    // path からイメージを生成し elm へ表示
    var url = path + "/" + file;
    var sfx = suffix(file);
    var height = thumbNailSize();
    
    if ((sfx == "pdf") || (sfx == "PDF")){
        var img = "<IMG SRC=pdf.jpg HEIGHT=" + height + ">";
    } else if (isImageFile(url)){
        var img = "<IMG SRC="+url+" HEIGHT=" + height + ">";
    } else if (isMovieFile(url)){
        var img = "<IMG SRC=movie.jpg HEIGHT=" + height + ">";
    } else if (sfx == "zip"){
        var img = "<IMG SRC=zip.png HEIGHT=" + height + ">";
    } else if (sfx == "txt"){
        var img = "<IMG SRC=text.png HEIGHT=" + height + ">";
    } else {
        var img = "<IMG SRC=file.png HEIGHT=" + height + ">";
    }
    
    // === サムネイルを表示 ========================
    var div = newDIV(ul, "");
    var sp = newSPAN(div, "");
    sp.innerHTML = img;
    sp.setAttribute("onclick", "showContents('"+url+"')");
    sp.setAttribute("class", "thumb-nail"); 
    // カルテに埋め込むためのタグを生成
    //var path = "/NOA_ARCHIVE/"+patientId()+"/";
    var tag = "<IMG:" + url + ">";
    sp.addEventListener("dragstart",
                        function(ev) {
                        var dt = ev.dataTransfer;
                        dt.setData("text/plain", tag);
                        return true;
                        },
                        false);

    // === 画像削除アイコンとファイル名を表示 ==========
    if (height * 1 > 90){
        var dv = newDIV(div, "");
        var sp = newSPAN(dv, "");
        sp.style.paddingLeft = "5px";
    } else { // サムネイルが小さい場合はファイル名を同じ行に表示
        var dv = div;
        var sp = newSPAN(div, "");
        sp.style.paddingLeft = "5px";
    }
    // ファイル名
    var sp = newSPAN(dv, "");
    sp.innerHTML = file;
    sp.style.margin = "0 5px";
    sp.style.fontSize = "9pt";
    /*
    sp.setAttribute("draggable", "true"); // HTML5: ドラッグ可能にする
    var tag = "<IMG:" + url + ">";
    sp.setAttribute("ondragstart", "f_dragstart(event,'" + tag + "')");
    sp.setAttribute("ondragover", "f_dragover(event)");
     */
    // イメージを削除ボタン
    var img = newIMAGE(dv, "", "./remove-field.png", "");
    img.setAttribute("onclick", "removeImage('"+path +"','"+file+"')");
    img.style.height = "12px";
    img.style.position = "relative";
    img.style.bottom = "-3px";
}

function showContents(url){
	// url 内容を別ウインドーに表示
	var sfx = suffix(url);
	if (sfx == "zip"){
		if (!confirm("この圧縮ファイルを、ダウンロード・フォルダーへ解凍しますか")) return;
    }

	window.open(url, url, "width=600,height=600");
}

function file_append(){
	// ファイル選択ボタンを増やす
	var dv = document.getElementById("file");
	var ub = newUploadBUTTON(dv, "", "files[]");
	newBR(dv);
}

function upload(){
    // form を submit
    var submitButton = document.getElementById("uploadForm");
    submitButton.submit();
    
    setTimeout(getImages, 3000);
}

function pictureHelp(){
    // ヘルプを開く
	window.open("./pictureHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function closePicture(){
	var elm = document.getElementById("base");
	elm.innerHTML = "";
}

function initPicture(){
	// テンプレートで FRONT のヘッダー部分を生成
    _initDebug(false); //##
    _debug("== initPicture =="); //##
    
	var elm = document.getElementById("base");
	elm.innerHTML = "";

    var div = newDIV(elm, "messageArea");
    div.style.fontSize = "9pt";

    // ===== HEADER ===================
    var div = newDIV(elm, "/tool-header");
    // === LEFT SIDE ===
    var dv = newDIV(div, "/left-side");
	dv.style.position = "/relative";
	dv.style.top = "4px";
	// カルテID・氏名
    var pid = "";
    var name = "";
    if (patientId()){
        pid = patientId();
        name = patientName();
    }
    var sp = newSPAN(dv, "patientIdArea");
    sp.innerHTML = pid;
    sp.style.paddingRight = "5px";
    var sp = newSPAN(dv, "");
    sp.innerHTML = name;
    // === RIGHT SIDE ===
    var dv = newDIV(div, "/right-side");
    // --- サムネイル・サイズ変更
    var sp = newSPAN(dv, "");
    sp.style.fontSize = "9pt";
    sp.innerHTML = "サムネイル";
    var sp = newSPAN(dv, "");
    sp.style.paddingRIght = "5px";
    var array = ["大","中","小"];
    var pm = newPopupMenu(sp, "", array, thumbNailSizeName());
    pm.setAttribute("onchange", "setThumbnailSize(this)");
    pm.style.position = "relative";
    pm.style.bottom = "2px";
	// --- ヘルプ・アイコン
	var im = newIMAGE(dv, "", "./help.png", "?");
	im.setAttribute("onclick", "pictureHelp()");
	im.style.height = "18px";
	im.style.marginLeft = "5px";
	im.style.position = "relative";
	im.style.top = "4px";
    
    // ===== CONTENTS ===================
    // --- ギャラリーを生成
    var div = newDIV(elm, "formArea");
    if (patientId()){
        var dv = newDIV(div, "");
        _debug("dv->"+dv); //##
        
        // === FORM を生成 =============================
        var fm = newFORM(dv, "pictServer.php"); // submit で起動される URL
        fm.setAttribute("id", "uploadForm");
        // ### iframe を使うにはここがキモ ###
        fm.setAttribute("target", "iframeElement"); // iframe を指定
        
        // === ファイル選択ボタン ========================
        var dv = newDIV(fm, "file");
        var bt = newUploadBUTTON(dv, "imageFile", "files[]");
        bt.setAttribute("onclick", "putWindowSize()");
        // more FILES
        var dv = newDIV(fm, "");
        dv.style.fontSize = "9pt";
        var a = newA(dv, "ファイルをもうひとつ選択", "#", "");
        a.setAttribute("onclick", "file_append()");
        a.style.fontSize = "9pt";

        // === 転送データのコンテナー =====================
        var filename = todayAndTimeId();
        // key
        var fd = newFIELD(fm, "key", "", "", "SAVE_IMAGE");
        fd.setAttribute("NAME", "key"); // form で送られるパラメータ
        fd.setAttribute("type", "hidden");
        // patientId
        var fd = newFIELD(fm, "container", "", "", patientId());
        fd.setAttribute("NAME", "container"); // form で送られるパラメータ
        fd.setAttribute("type", "hidden");
        // imageId
        var fd = newFIELD(fm, "imageId", "", "", filename);
        fd.setAttribute("NAME", "imageId"); // form で送られるパラメータ
        fd.setAttribute("type", "hidden");
        
        // === アップロード・ボタン =======================
        // ### iframe を使うにはここがキモ ###
        // form を見せない形で処理するため submit-button 機能を別に作成
        var dv = newDIV(div, "");
        var bt = newDIV(dv, "/whiteButton");
        bt.innerHTML = "画像読込み";
        bt.setAttribute("onclick", "upload()");
        
        // === データ戻り先として iframe を作成 ===========
        // ### iframe を使うにはここがキモ ###
        var dv = newDIV(div, "");
		dv.style.display = "none"; // 表示しない
        var fr = newIFRAME(dv, "iframeElement");
    } else {
        var dv = newDIV(elm, "");
        dv.innerHTML = "カルテを開いてからやり直してください";
        dv.style.color = "#b86125";
        dv.style.fontSize = "9pt";
        dv.style.paddingLeft = "10px";
        return;
    }

    // === 画像表示エリア ===============
    var div = newDIV(elm, "thumbNailGallery");
    
    var div = newDIV(elm, "/versionArea");
    div.innerHTML = version();

    getWindowSize();

    // 画像ギャラリーを表示
    getImages();
}

function version(){
	return "Ver.1308909";
}


