
/////
///// noa.js は NOA 外郭を司るカルテ・ホルダーのようなもの
///// 個々のカルテ記述は chart.js クラスが司る
/////

//////////////////////////////////////////////////////////////
///// URL で受け取るパラメータ //////////////////////////////////

function suppliedPatientId(){
    // URL で与えられた patientId
    return document.getElementById("_pid").value;
}

function suppliedPatientName(){
    // URL で与えられた patientKanjiName
    return document.getElementById("_pname").value;
}

function addPageFlag(){
    // URL で与えられた「新規ページ追加ステータス」
    return (document.getElementById("_addPage").value)
        ? true : false;
}

///// URL で受け取るパラメータ //////////////////////////////////
//////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////
///// ヘッダー・メニューやツール・メニューから起動される周辺ツール //////

function noaHelp(){
	// NOA の概要 HELP
	window.open("./noaHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function openToolPane(){
    // tools パネルを開く
    window.open("./tools.php", "tools");
}

///// ヘッダー・メニューやツール・メニューから起動される周辺ツール //////
//////////////////////////////////////////////////////////////


/////////////////////////////////////
///// POLLING ///////////////////////

function pollingWORK(){
    // 受付の患者登録を Worker を使い裏プロセスの polling でチェック
    // DB とのやりとりや polling は polling.js で設定
    var obj = new Object();
    obj["dateTime"] = today();
    var noaString = encodeObject(obj);

    var worker = new Worker('./polling.js');
    worker.postMessage(noaString); // ### worker に命令書 noaString を送る ###

    //_initDebug(true); //##

    worker.onmessage = function (event) {
        // ### worker の処理したデータを受け取る ###
        var answer = event.data; // ### worker からの返答 ###
        var array = answer.split("<SEPARATOR>");
        if (array.length > 1){
            var obj = JSON.parse(array[1]);
            var records = obj.records; // 本日の日計表レコード
            var messageArray = obj.message; // メッセージ・オブジェクト
            
            // 他アプリからのメッセージを表示
            if (messageArray && (messageArray.length > 0)){
                //var found = false;
                for (num in messageArray){
                    var rec = messageArray[num];
                    //alert(encodeObject(rec)); //##
                    
                    var ary = rec.receiver.split("@");
                    var receiver = ary[0];
                    var app = ary[1];
                    if ((receiver == owner()) && (app == "NOA")){
                        showMessenger(rec); // neuron.js
                    }
                }
            }
            
            // 本日の「受診者ポップアップ・タグ」を表示
            if (noCheckWaiting() == 0){
                var elm = document.getElementById("pollingArea");
                elm.innerHTML = "";
                var div = newDIV(elm, "");
                var now = today();
                
                for (num in records){
                    var rec = records[num];
                    var etime = rec.endTime; // 診察終了時刻
                    
                    // 本日のものだけをポップアップ表示
                    if (! isSameDate(rec.entryDate, now)) continue;
                    
                    if (rec.entryDate > rec.updateTime){
                        // 登録年月日より以前に更新されていれば予約と判断
                        var sp = newSPAN(div, "/reserved-patient-tab");
                        sp.innerHTML = rec.patientId + " " + rec.kanjiName;
                        // 予約日時で新規ページ追加するかどうか尋ねる
                        if (isAddReservedPage() > 0){ // localStorage.js
                            var action = "openChart('" + rec.patientId + "','" + rec.kanjiName + "','" + rec.reservedDate + "')";
                        } else {
                            var action = "openChart('" + rec.patientId + "','" + rec.kanjiName + "')";
                        }
                        sp.setAttribute("onclick", action);
                    } else if (etime && (etime.toString().length > 0)) {
                        // 診療終了したものは表示しない
                    } else {
                        // 診療終了していないものだけを拾い出す：新規ページを追加
                        var sp = newSPAN(div, "/waiting-patient-tab");
                        sp.innerHTML = rec.patientId + " " + rec.kanjiName;
                        var action = "openChart('" + rec.patientId + "','" + rec.kanjiName + "','addPage')";
                        sp.setAttribute("onclick", action);
                    }
                }
            }
            
            // 待受リストを更新
            refleshWaitingList(records);
        }
    }
}

///// POLLING ///////////////////////
/////////////////////////////////////


/////////////////////////////////////
///// FIND PATIENT //////////////////

function gotPatientList(answer){
	// rowid のレコードをサーバから読込み
	var records = JSON.parse(answer);
    //_debug("== gotPatientList->"+encodeObject(records)); //##
    
    var elm = closeWorkArea();
	var tbl = newTABLE(elm, "/base-table");
    tbl.style.fontSize = "10pt";
    
	var tr = newTR(tbl, "", "");
    tr.style.backgroundColor = "#ddd";
	var td = newTD(tr, "", "");
    td.style.width = "17px";
    var img = newIMAGE(td, "", "close.png", "close");
    img.style.marginLeft = "5px";
    img.style.height = "12px";
    img.setAttribute("onclick", "closeWorkArea()");
	var td = newTD(tr, "", "カルテ番号");
	var td = newTD(tr, "", "氏名");
	var td = newTD(tr, "", "ローマ字");
	var td = newTD(tr, "", "最終受診日");
	
	var patientId, name;
	var count = records.length;
    for (r in records){
		var rec = records[r];
		var kanji = (rec.patientKanjiName) ? rec.patientKanjiName : "";
		patientId = rec.patientId;
        name = kanji;
		var romaji = (rec.patientRomajiName) ? rec.patientRomajiName : "";
		var lvd = (rec.lastVisitDate) ? rec.lastVisitDate : "";
		var tr = newTR(tbl, "/record", "");
		var action = "openChart('" + rec.patientId + "','" + name + "')";
		tr.setAttribute("onclick", action);
        var td = newTD(tr, "", "");
		var td = newTD(tr, "", rec.patientId);
		var td = newTD(tr, "", kanji);
		var td = newTD(tr, "", romaji);
		var td = newTD(tr, "", lvd);
	}
	var tr = newTR(tbl, "", "");
    tr.style.backgroundColor = "#ddd";
    var td = newTD(tr, "", "");
	var td = newTD(tr, "", records.length + " レコード ");
	td.setAttribute("colspan", "4");
    
	if (count == 1){
		// 検索結果が１件のみなら直ちにそのカルテを開く
		openChart(patientId, name);
	}
}
function showPatientList(){
	// 検索キーにマッチしたカルテのリストを表示
    var searchKey = document.getElementById("keyF").value;
    
    if (searchKey.length == 0){
        alert("検索キーが指定されていません");
    } else {
        setStoragedKey(searchKey); // localStorage に記憶
        closeFloatPanel();
        NRGetPatients(searchKey, gotPatientList); // サーバでアクセス・ログに記憶
    }
}

function openSearchPanelHelp(){
    // tools パネルを開く
    var url = "searchPanelHelp.html";
    window.open(url,"Help","width=450,height=700,scrollbars=yes,resizable=yes");
}

function searchPatient(){
    // FRONT の受診者リストを表示
    var w = 250;
	var x = 10; // 表示するx座標
	var y = 30; // 表示するy座標
    var title = "カルテ検索";
    var elm = openSeeThroughPanel("_floatPanel", x, y, w, title, "openSearchPanelHelp()");
    if (!elm){
        alert("_floatPanel がないのでパネルを表示できません"); return;
    }
    elm.style.padding = "8px";
    
    var div = newDIV(elm, "");
    var fd = newFIELD(div, "keyF", "", 30, storagedKey());
    fd.setAttribute("class", "searchField");
    fd.setAttribute("onchange", "showPatientList()");
    fd.focus();
    // 検索ボタン
    var bt = newSPAN(div, "/searchButton");
    bt.innerHTML = "検索";
    bt.setAttribute("onclick", "showPatientList()");
}

///// FIND PATIENT //////////////////
/////////////////////////////////////


/////////////////////////////////////
///// ACCESSS LOG ///////////////////

function opneLogChart(mode, patientId, patientName, addPageFlag){
    // waitingList accessLog から呼ばれる
    //alert("== opneLogChart == "+mode+"->"+patientId+"->"+patientName); //##
    
    if ((mode == 0) && isShiftDown()){ // mode -- 0:履歴 1:待受
        var st = patientId+ " " + patientName + " の行を削除していいですか";
        if (confirm(st)){
            NRRemoveAccessLog(owner(), patientId, gotAccessLog);
        }
    } else {
        closeFloatPanel();
        openChart(patientId, patientName, addPageFlag);
    }
}

var _accessLog;
function sortAccessLog(){
    // 受付日時で逆ソートする
    var status = (accessLogReverse()) ? "" : "1";
    setAccessLogReverse(status);
    
    NRGetAccessLog(owner(), status, gotAccessLog);
}

function gotAccessLog(answer){
    //alert("gotAccessLog->"+answer); //##
    var elm = document.getElementById("_confirm");
    if (!elm){
        alert("_confirm がないのでメッセージを表示できません"); return;
    }
	elm.innerHTML = "";
	elm.style.visibility = "visible";
	elm.style.left = 10; // 表示するx座標
	elm.style.top = 80; // 表示するy座標
	setFloatPanel(elm);
    
    var div = newDIV(elm, "");
    div.style.background = "#999";
    div.style.border = "thin solid #44f";
    
    // TITLE
	var tbl = newTABLE(div, "/base-table");
    var tr = newTR(tbl, "", "");
    tr.style.background = "#555";
    tr.style.fontSize = "9pt";
    var td = newTD(tr, "bookingSortTab/logTitle", "参照年月日");
    td.style.width = "140px";
    td.setAttribute("onclick", "sortAccessLog()");
    var td = newTD(tr, "/logTitle", "カルテID");
    td.style.width = "70px";
    var td = newTD(tr, "/logTitle", "氏名");
    td.style.width = "150px";
    
    var dv = newDIV(div, "");
	dv.style.height = "200px";
	dv.style.overflow = "auto";
    var tbl = newTABLE(dv, "/logTable");
    
    // RECORDS
    var obj = JSON.parse(answer);
    //alert("gotAccessLog->"+encodeObject(obj)); //return; //##
    for (date in obj){
        var rec = obj[date];
        
        var tr = newTR(tbl, "/record", "");
        var action = "opneLogChart(0,'" + rec.pid + "','" + rec.name + "','addPage')"
        tr.setAttribute("onclick", action);
        var td = newTD(tr, "/logColumn", date);
        td.style.width = "140px";
        var td = newTD(tr, "/logColumn", rec.pid + ""); // 数値だと表示されない
        td.style.width = "75px";
        var td = newTD(tr, "/logColumn", rec.name);
        td.style.paddingRight = "20px";
        td.style.width = "150px";
    }
    
    // FOOOTER
    var div = newDIV(div, "");
    div.style.background = "#555";
    div.style.textAlign = "right";
    div.style.padding = "2px 5px";
    var bt = newDIV(div, "/closeButton");
    bt.innerHTML = "X";
    bt.style.color = "#aaa";
    bt.setAttribute("onclick", "closeFloatPanel()");
}
function showAccessLog(){
    // カルテのアクセス・ログを表示
    // status が "1" なら逆順にソート
    var status = (accessLogReverse()) ? "1" : "";
    
    NRGetAccessLog(owner(), status, gotAccessLog);
}

///// ACCESSS LOG ///////////////////
/////////////////////////////////////



function nextTag(tag){
    // NOA 本文内における tag の次の tag を返す：basic ページでは basicPage.js で定義
    var found = false;
    var array = layoutForMode(_progress_);
    for (num in array){
        var layoutObj = array[num];
        if (layoutObj.hitAndRun * 1) continue; // 非表示セルをスキップ
        
        if (found) return layoutObj.tag;
        if (layoutObj.tag == tag) found = true;
    }
    return null;
}

function removeCheck(){
    // 無条件に編集不可のチェックをはずす
    var bid = "pageReadOnlyStatus";
    var bt = newOnButton(bid, "編集可/編集不可", "getOnOff");
}

function closeWorkArea(){
    // workArea の padding を消す
    var elm =document.getElementById("workArea");
    elm.innerHTML = "";
    elm.style.padding = "0";
    
    return elm;
}

function showHeaderIcons(){
    //function showIconBar(){
    // ヘッダーにアイコン・ギャラリーを表示
    var div = document.getElementById("toolIconArea");
    div.innerHTML = "";
    
    var ul = newUL(div, "/listMembers");
    var array = toolMenus();
    for (num in array){
        var cell = array[num];
        
        if (cell.menuType * 1 != _main) continue;
        if (cell.disabled * 1) continue;
        if (cell.subTitle * 1) continue;
        
        // メニュー項目を生成
        var li = newLI(ul, "", cell.id + "/listMemberIcon");
        
        if (cell.url == "search()"){
            // cell.editor に infoTip に表示する内容が入っている
            setInfoTip(cell.id, cell.editor); // HELP
            
            // これだけは特別扱い
            var dv = newDIV(li, "/searchFrame");
            var fd = newFIELD(dv, "searchF", "", 15, "");
            setInfoTip(cell.id, "このカルテ内の文言検索"); // HELP
            fd.setAttribute("class", "searchField");
            fd.setAttribute("onchange", "search()");
            var bt = newSPAN(dv, "/searchButton");
            bt.innerHTML = "検索";
            bt.setAttribute("onclick", "search()");
        } else if (cell.icon){
            // ICON があれば ICON を表示
            // cell.editor に infoTip に表示する内容が入っている
            setInfoTip(cell.id, cell.editor); // HELP
            var img = newIMAGE(li, "", cell.icon, "icon");
            img.style.margin = "0 5px"; // ボタン間隔
            img.style.height = "15px";
            var action = "kickMenuCell('"+cell.url+"','"+cell.window+"',this)";
            img.setAttribute("onclick", action);
            img.setAttribute("class", "expandIcon");
        } else {
            // アンカー表示
            // cell.editor に infoTip に表示する内容が入っている
            setInfoTip(cell.id, cell.editor); // HELP
            var bt = newDIV(li, "/greenButton");
            bt.innerHTML = cell.label;
            bt.style.position = "relative";
            bt.style.bottom = "1px"; // ボタン位置調整
            if (cell.url){
                var action = "kickMenuCell('"+cell.url+"','"+cell.window+"',this)";
                bt.setAttribute("onclick", action);
            }
        }
    }
    
    // HELP
    var li = newLI(ul, "", "noaHelp/listMemberIcon");
    setInfoTip("noaHelp", "HELP"); // HELP
    var img = newIMAGE(li, "", "help.png", "icon");
    img.style.height = "17px";
    img.setAttribute("onclick", "noaHelp()");
    img.setAttribute("class", "expandIcon");
    
    // TOOL MENU
    var li = newLI(ul, "", "gearIcon/listMemberIcon");
    setInfoTip("gearIcon", "Tool Menu"); // HELP
    var img = newIMAGE(li, "", "gear.png", "icon");
    img.style.height = "17px";
    img.setAttribute("onclick", "openToolPane()");
    img.setAttribute("class", "expandIcon");
}

// ###########################################
// ### FireFox 系ブラウザのイベント操作に必要 ######
var _Event = null;
document.onkeyup = function(e){
    　_Event = null;
}
document.onkeydown = function(e){
    　_Event = e;
}
function isShiftDown(){
    // shift が押されていれば true を返す
    var shift;
    
    if (_Event != null){
        shift = _Event.shiftKey;
    } else {
        if (navigator.userAgent.indexOf('Firefox', 0) == -1)
            shift = event.shiftKey;
        else
            shift = false;
    }
    return shift;
}
function eventKeyCode(){
    // keyCode 返す
    if (_Event != null){
        return _Event.keyCode;
    }
    return null;
}
// ### FireFox 系ブラウザのイベント操作に必要 ######
// ###########################################

function test(){
    //_initDebug(true); //##
    //_debug("history->("+history()+")"); //##

    var st = "2013-10-2a";
//    var st = "2013-10-27 08:53:45";
    elmFor("_test").innerText = st + "-> "+ isDate(st);
}

function gotHospitalInfo(answer){
    // HospitalInfo を dataCenter へ記憶
    //alert("gotHospitalInfo->"+answer); //##
    
    var obj = JSON.parse(answer);
    setHospitalInfo(obj);
    
    // DB をチェック：戻値は無し
    NRCheckFrontTable();
    
    // URL に patientId が指定されていればカルテを開く
    var patientId = suppliedPatientId();
    if (patientId.length > 0){
        if (addPageFlag())
            openChart(patientId, suppliedPatientName(), 'addPage');
        else
            openChart(patientId, suppliedPatientName());
    }
}
function gotHeaderIcons(answer){
    // ヘッダー・アイコンを表示
    var obj = JSON.parse(answer);
    setToolMenus(obj);
    
    // ヘッダーにアイコン・ギャラリーを表示
    showHeaderIcons();
    
    // HospitalInfo をサーバへリクエスト
    NRGetHospitalInfo(owner(), hospitalId(), gotHospitalInfo);
}
function gotLayout(answer){
    // NOA のレイアウトを受取り dataCenter へ記憶
    var obj = JSON.parse(answer);
    setLayoutObj(obj);
    
    // ページに表示するアイコン群の情報をリクエスト
    // ## tools.js でもリクエストしているので重複している面はある
    NRGetToolMenu(owner(), gotHeaderIcons);
}
function initNOA() {
    //_initDebug(true); //##
    
    //　dataCenter の記憶を login.js と共有できないので localStorage を
    // 経由して hospitalTable のデータを受け取り dataCenter に記憶
    /*
    hospitalTable = "userCode(all)sectionCode(23)groupCode(doctor)loginName(ohashi)kanjiName(大橋 克洋)identifier(c44f9b64052f12c4e9229fd899c7113b)hospitalId(1304000000077)memo()entryDate(2010-04-29 15:49:06)updateTime(2013-06-23 19:04:20)owner(ohashi)rowid(38)hospitalTable(大橋医院(1304000000077)SEA SIDE CLINIC(03234200))hospitalName(大橋医院)"
     */
    var obj = hospitalTable(); // localStorage.js
    setHospitalObj(obj); // dataCenter.js

    var elm = document.getElementById("base");
    elm.innerHTML = "";
    
    // === HEADER =============================
    var div = newDIV(elm, "/title-bar");
    // --- LEFT SIDE ---------------
    // カルテ検索アイコン
    var dv = newDIV(div, "/left-side");
    dv.style.width = "110px"; //##
    var img = newIMAGE(dv, "addChartIcon", "search.png", "search");
    img.setAttribute("onclick", "searchPatient()");
    img.style.height = "18px";
    img.style.position = "relative";
    img.style.bottom = "2px";
    setInfoTip("addChartIcon", "カルテを検索して開く"); // HELP
    img.setAttribute("class", "expandIcon");
    // patientId
    var pidv = newSPAN(dv, "patientIdArea");
    // --- RIGHT SIDE ---------------
    // 周辺ツール・アイコンを表示するエリア
    var dv = newDIV(div, "/right-side");
    dv.style.paddingRight = "10px";
    var dv = newDIV(dv, "toolIconArea");
    
    // === BODY ==============================
    var div = newDIV(elm, "");
    var tbl = newTABLE(div, "/base-table");
    var tr = newTR(tbl, "", "");
    // CALENDAR AREA -------------------
    var td = newTD(tr, "calendarArea", ""); // width は openCalendar() で設定
    // CHART AREA ----------------------
    var td = newTD(tr, "contents", "");
    td.style.clear = "both";
    td.setAttribute("class", "pastColor");

    // 設定された高さを画面スクロール範囲とする
    var val = overFlowHeight();
    if (val >= 100){
        div.style.height = val + "px";
        div.style.overflow = "auto";
    }
    
    // === FOOTER ============================
    var div = newDIV(elm, "/title-bar");
    // LEFT-SIDE
    var dv = newDIV(div, "/left-side");
    dv.innerHTML = hospitalName() + " ( 取扱者 " + userName() + " )";
    dv.style.width = "500px";
    
    // RIGHT-SIDE
    var dv = newDIV(div, "version/right-side");
    dv.innerHTML = version();
    
    // 初心者用に NOA ヘルプを表示
    if (showHelp() == 0) noaHelp();
    
    // FRONT での新規受付患者をチェック
    pollingWORK();
    
    // NOA のレイアウトをリクエスト：続いて ヘッダー・メニューも
    setCurrentDate(null); // addPage で比較のため使用
    NRGetLayout(owner(), gotLayout);
}

function version() {
	return "Ver.131018";
}
