
var _debug_mode;
function _initDebug(status){
    // デバッグ・メッセージ領域をクリア
    var elm = document.getElementById("_debug");
    if (elm){
        elm.innerHTML = "";
        _debug_mode = (status) ? true : false;
    } else {
        alert("_debug エレメントがありません");
    }
}
function _isDebugMode(){
    return _debug_mode;
}
function _debug(st){
    // メッセージ領域に st を追加表示
    
    // ### debug message を出さないようにするにはこの行を生かす ###
    if (!_debug_mode) return;
    
    if (st == "_CLEAR_"){
        // メッセージ領域を初期化
        document.getElementById("_debug").innerHTML = "";
    } else {
        var elm = document.getElementById("_debug");
        var buff = elm.innerHTML;
        elm.innerHTML = buff + st + "<br/>";
    }
}

function setColor(element, color, bgcolor){
	element.style.backgroundColor=bgcolor;
	element.style.color=color;
}

function resetColor(element, color, bgcolor){
	element.style.backgroundColor=bgcolor;
	element.style.color=color;
}

var _submenuId;
function hideSubmenu(){
	// サブ・メニューを閉じる
	var elm = document.getElementById(_submenuId);
	elm.style.visibility = "hidden";
}
function checkCursorPosition(){
	// カーソル位置が submenu 範囲をはずれたら submenu を閉じる
	var x = event.clientX;
	var y = event.clientY;
	
	var elm = document.getElementById(_submenuId);
	var minX = elm.offsetLeft + elm.offsetParent.offsetLeft;
	var minY = elm.offsetTop + elm.offsetParent.offsetTop;
	var maxX = elm.offsetLeft + elm.offsetWidth + elm.offsetParent.offsetLeft;
	var maxY = elm.offsetTop + elm.offsetHeight + elm.offsetParent.offsetTop;
	
	if ((x <= minX) || (maxX <= x)) hideSubmenu();
	if ((y < minY) || (maxY <= y)) hideSubmenu();
}
function showSubmenu(x, y, id, buff){
	// サブ・メニューを開く　
	alert("showSubmenu:"+buff); //##
	_submenuId = id;
	var elm = document.getElementById(id);
	elm.style.border = "thin solid #aaa";
	elm.style.backgroundColor = "#aaa";
	elm.style.left = x; // 表示するx座標
	elm.style.top = y; // 表示するy座標
	elm.style.padding = "0px 1px";
	elm.style.visibility = "visible";
	elm.setAttribute("onmousemove", "checkCursorPosition()");
	elm.innerHTML = buff;
}

function showMessage(id, msg){
	// メッセージ・タグを開く
	// ## あらかじめ PHP ファイルなどに以下を埋め込んでおくこと ##
	// <SPAN id="_message" STYLE="visibility: hidden; position: absolute;"></SPAN>
	var elm = document.getElementById(id);
	elm.innerHTML = msg;
	elm.style.backgroundColor = "#f55";
	elm.style.color = "#fff";
	//elm.style.borderColor = "#900"; // "solid" の場合
	elm.style.borderWidth = 2;
	elm.style.border = "outset"; // "solid";
	elm.style.padding = "3px 10px";
	elm.style.left = 25; // 表示するx座標
	elm.style.top = 100; // 表示するy座標
	elm.style.visibility = "visible";
	var action = "hideMessage('"+id+"')";
	elm.setAttribute("onmouseover", action);
}
function hideMessage(id){
	// メッセージ・タグを閉じる
	var elm = document.getElementById(id);
	elm.style.visibility = "hidden";
}

var _switchButtonObjects;
function switchButtonClicked(elm){
	// switchButton がクリックされた時の動作
	var selectedRadioNum = 0;
	// elm 以外の兄弟 element の背景色を元来の色に戻す
	var array = elm.parentNode.childNodes;
	for (var i=0,ct=array.length; i < ct; i++){
		var node = array[i];
		if (node == elm)
			selectedRadioNum = i;
		else {
			var obj = _switchButtonObjects[i];
			node.style.backgroundColor = obj.bgcolor;
		}
	}
	
	// 選択された element の背景色を白にする
	elm.style.backgroundColor = "#fff";
	
	// 選択されたオブジェクトの script を実行
	var obj = _switchButtonObjects[selectedRadioNum];
	eval('(' + obj.script + ')');
}
function newSWITCHBUTTON(elm, items){
	// ボタン形式の radio button を生成
	// items={("label"="foo","bgcolor":"#red","script":"alert('hello')"),,}
	_switchButtonObjects = items;
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "");
	tbl.style.width = "100%";
	tbl.style.border = "0px solid #000";
	tbl.style.borderCollapse = "collapse";
	var tr = newTR(tbl, "", "");
	for (var i=0,count=items.length; i < count; i++){
		var obj = items[i]; // "label:bgcolor" 形式
		var td = newTD(tr, "", obj.label);
		td.style.backgroundColor = obj.bgcolor;
		td.style.border = "1px solid #000";
		td.style.padding = "1px 3px";
		td.style.fontSize = "9pt";
		var action = "switchButtonClicked(this)";
		td.setAttribute("onclick", action);
	}
}

function idOfCode(code){
    // code "id/class" から "id" を返す
    if (code && code.length){
        var array = code.split("/");
        return (array[0].length > 0) ? array[0] : null;
    } else {
        return null;
    }
}
function classOfCode(code){
    // code "id.class" から "class" を返す
    if (code && code.length){
        var array = code.split("/");
        if ((array.length > 1) && (array[1].length > 0))
            return array[1];
        else
            return null;
    } else {
        return null;
    }
}

var _offsetX;
var _offsetY;
var _cursorLocked;
function cursorLock(){ // mouse down
	_cursorLocked = true;
}
function cursorUnlock(){ // mouse up
	_cursorLocked = false;
}
var _floatPanel;
function setFloatPanel(panel){
	_floatPanel = panel;
}
function floatPanel(){
	return _floatPanel;
}
function _checkPanel(){
	// カーソル位置が floatPanel 外にあれば floatPanel を閉じる
	if (isOutOfPanel()){
		closeFloatPanel();
	}
	
	function isOutOfPanel(){
		// カーソル位置が floatPanel 上になければ true を返す
		// floatPanel の位置
		var pos = getPosition(floatPanel());
		var x = pos.x;
		var y = pos.y;
		var w = floatPanel().offsetWidth;
		var h = floatPanel().offsetHeight;
		
		//　カーソルがクリックされた位置
		var mx = _clientX;
		var my = _clientY;
		
		// カーソルのクリックされた位置が floatPanel 外なら true を返す
		if (mx < x) return true;
		if (x + w < mx) return true;
		if (my < y) return true;
		if (y + h < my) return true;
		
		return false;
	}
}
function _getCursorMove(evt){
	// マウスでパネルのタイトルを掴み移動させる
	// Firefox ではうまく動作しない
	if (_cursorLocked){ // mouse down
		floatPanel().style.left = evt.clientX - _offsetX; // 表示するx座標
		floatPanel().style.top = evt.clientY - _offsetY; // 表示するy座標
	} else { // mouse up
		// layerX layerY は Firefox のみの独自規格で、他のブラウザーは
		// offsetX offsetY だが、最近は Safari でも layerX layerY が動く
		// Firefox では evt.x evt.y は動かない
		_offsetX = evt.layerX;
		_offsetY = evt.layerY;
	}
	_clientX = evt.clientX;
	_clientY = evt.clientY;
}
function closeFloatPanel(){
	// 確認パネルを閉じる
	floatPanel().innerHTML = "";
	// ## マウス・イベントが横取りされないようワークスペース外に押し出しておく
	floatPanel().style.left = -10000; // 表示するx座標
	window.onmousemove = false; // マウス制御を解除しておく
}
function openFloatPanel(element, x, y, title){
	// 確認パネルを開く
	var elm = element.parentNode; // _panel と同じもの
	elm.style.marginTop = "2%";
	elm.style.marginRight = "2%";
    elm.style.borderRadius = "10px";
    elm.style.backgroundColor = "#ffc";
	setFloatPanel(elm);
	
	// floatPanel の基盤層にパネルを閉じる動作を設定
	var parent = elm.parentNode;
	parent.setAttribute("onclick", "_checkPanel()");
	
	window.onmousemove = _getCursorMove;
	elm.style.left = x; // 表示するx座標
	elm.style.top = y; // 表示するy座標
	elm.style.visibility = "visible";
	elm.style.fontFamily = "arial, Helvetica";
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "float-table");
	
	// TITLE
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "float-header", ""); // NOA の base.css を参照
	var sp = newSPAN(td, "");
	sp.style.padding = "0px 5px";
	var im = newIMAGE(sp, "", "./close.png", "?");
	im.setAttribute("onclick", "closeFloatPanel()");
	im.style.height = "12px";
	var sp = newSPAN(td, "");
    sp.innerHTML = title;
	
	// CONTENTS
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	td.appendChild(element);
}

function openSeeThroughPanel(id, x, y, w, title, helpAction, titleAction){
	// 半透明パネルを開く
	var elm = document.getElementById(id);
	setFloatPanel(elm);
	elm.style.padding = "5px";
    elm.style.border = "thin solid #888"; //##
    elm.style.borderRadius = "10px";
	elm.style.left = x; // 表示するx座標
	elm.style.top = y; // 表示するy座標
	elm.style.width = w;
	elm.style.backgroundColor = "#ddd";
	elm.style.opacity = "0.8";
    elm.style.boxShadow = "2px 2px 10px 2px #555";
	elm.style.visibility = "visible";
	elm.innerHTML = "";
    
    // === HEADER =============
    var div = newDIV(elm, "/clearfix");
	div.setAttribute("onmousedown", "cursorLock(this)"); // マウスで掴み可動にする
	div.setAttribute("onmouseup", "cursorUnlock()"); // マウスで掴み可動にする
    var rightWidth = 20; // RIGHT SIDE WIDTH
    // --- LEFT SIDE
    // CLOSE BUTTON
    var dv = newDIV(div, "/left-side");
    dv.style.width = (w - 20 - 5) + "px";
    dv.style.padding = "0"; // CSS を上書き
    var bt = newDIV(dv, "/closeButton");
    bt.style.fontSize = "10pt";
	bt.style.fontWeight = "bold";
    bt.innerHTML = "x";
	bt.setAttribute("onclick", "closeFloatPanel()");
    // TITLE
    if (title){
        var sp = newSPAN(dv, "seeThroughPanelTitle"); // 外部から取得するための ID
        sp.innerHTML = title;
        sp.style.fontSize = "9pt";
        elm.style.opacity = "1.0";
        
        if (titleAction){
            // タイトルをクリックすると titleAction を実行
            sp.setAttribute("onclick", titleAction);
            sp.setAttribute("class", "record");
            sp.style.padding = "0 10px";
            sp.style.borderRadius = "10px";
        }
    }
    // --- RIGHT SIDE
    var dv = newDIV(div, "/right-side");
    dv.style.width = rightWidth + "px";
    dv.style.padding = "0"; // CSS を上書き
    dv.style.position = "relative";
    dv.style.top = "3px";
    dv.style.padding = "0"; // CSS を上書き
    // HELP
    if (helpAction){
        var img = newIMAGE(dv, "", "help.png", "help");
        img.style.height = "15px";
        img.setAttribute("onclick", helpAction);
        img.setAttribute("class", "expandIcon");
    }
    
    // === CONTENTS ===============
	var contents = newDIV(elm, "");
    contents.style.marginTop = "5px";
    
    return contents;
}

function getPosition(el){
	// エレメント el の左上の座標を返す
	// 使用法: var pos = getPosition(el); var x = pos.x; var y = pos.y;
	// 実現に悩んだ結果、以下を参考にさせて頂きました: Thanks !!
	// http://n-yagi.0r2.net/script/2009/06/post_13.html
	var ex  =   0;
	var ey  =   0;
	do { 
		ex  +=  el.offsetLeft;
		ey  +=  el.offsetTop;
	} while(  el  =   el.offsetParent );
	
	return  {x:ex,y:ey};
}

function newIFRAME(elm, name){
    var el = document.createElement('iframe');
	el.setAttribute("name", name);
	elm.appendChild(el);
	
	return el;
}

function newTABLE(elm, code){
	// elm の下に TABLE を生成して返す
	var tbl = document.createElement('TABLE');
    var id = idOfCode(code);
    var cls = classOfCode(code);
	if (id) tbl.setAttribute("id", id);
	if (cls) tbl.setAttribute("class", cls);
    
	elm.appendChild(tbl);
	return tbl;
}

function newTEXT(elm, value){
	// elm の下に TEXT を生成して返す
	var tx = document.createTextNode(value);
	elm.appendChild(tx); 
	return tx;
}

function newTR(elm, code, label){
	// elm の下に <TR></TR> を生成して返す
	var tr = document.createElement('TR');
    var id = idOfCode(code);
    var cls = classOfCode(code);
	if (id) tr.setAttribute("id", id);
	if (cls) tr.setAttribute("class", cls);
    
	elm.appendChild(tr);
	if (label == null) label = "";
	if (label.length){
		var td = document.createElement('TD');
		tr.appendChild(td);
		var tx = document.createTextNode(label);
		td.appendChild(tx);
	}
	return tr;
}

function newTH(elm, id, label){
	// elm の下に <TD></TD> を生成して返す
	var td = document.createElement('TH');
	if (id.length) td.setAttribute("id", id);
	if (label.length){
		var tx = document.createTextNode(label);
		td.appendChild(tx); 
	}
	elm.appendChild(td); 
	return td;
}	

function newTD(elm, code, label){
	// elm の下に <TD></TD> を生成して返す
	var td = document.createElement('TD');
    var id = idOfCode(code);
    var cls = classOfCode(code);
	if (id) td.setAttribute("id", id);
	if (cls) td.setAttribute("class", cls);
    
	if (label == null) label = "";
	if (label.length){
		var tx = document.createTextNode(label);
		td.appendChild(tx);
	}
	elm.appendChild(td);
	return td;
}

function newBR(elm){
	// elm の下に BR を生成して返す
	var br = document.createElement('BR');
	elm.appendChild(br); 
	return br;
}	

function newDIV(elm, code){
	// elm の下に DIV を生成して返す
	var dv = document.createElement('DIV');
    var id = idOfCode(code);
    var cls = classOfCode(code);
	if (id) dv.setAttribute("id", id);
	if (cls) dv.setAttribute("class", cls);
    
	elm.appendChild(dv);
	return dv;
}

function newSPAN(elm, code){
	// elm の下に span を生成して返す
	var sp = document.createElement('span');
	//if (id.length) sp.setAttribute("id", id);
    var id = idOfCode(code);
    var cls = classOfCode(code);
	if (id) sp.setAttribute("id", id);
	if (cls) sp.setAttribute("class", cls);
    
	elm.appendChild(sp);
	return sp;
}

function newFIELD(elm, id, label, size, value){
	// 入力フィールドを生成
	if (label.length){
		newTEXT(elm, label);
	}
	var ip = document.createElement('INPUT');
	ip.setAttribute("type", "text");
	if (id.length) ip.setAttribute("id", id);
	ip.setAttribute("size", size);
	ip.setAttribute("value", value);
	elm.appendChild(ip); 
	
	return ip;
}

function newBUTTON(elm, id, label){
	// ボタンを生成
	var ip = document.createElement('INPUT');
	ip.setAttribute("type", "button");
	if (id.length) ip.setAttribute("id", id);
	ip.setAttribute("value", label);
	elm.appendChild(ip); 
	
	return ip;
}

function newCHECKBOX(elm, id, label, status){
	var ip = document.createElement('INPUT');
	elm.appendChild(ip);
	ip.setAttribute("TYPE", "checkbox");
	if (id.length > 0) ip.setAttribute("id", id);
	
	// FireFox では ip.setAttribute("checked"); は受け付けない
	if (status) { ip.setAttribute("checked", true); }
	
	if (label.length){
		var tx = document.createTextNode(label);
		elm.appendChild(tx);
	}
	
	return ip;
}

function newTEXTAREA(elm, id, cols, rows, value){
	// TEXTAREAを生成
	var ip = document.createElement('TEXTAREA');
	if (id.length) ip.setAttribute("id", id);
	ip.setAttribute("id", id);
	ip.setAttribute("cols", cols);
	ip.setAttribute("rows", rows);
	elm.appendChild(ip); 
	var tx = document.createTextNode(value);
	ip.appendChild(tx); 
	
	return ip;
}

function newA(elm, label, href, target){
	var a = document.createElement('A');
	elm.appendChild(a); 
	a.href=href;
	if (target.length) a.target=target;
	newTEXT(a, label);
	
	return a;
}

function newIMAGE(elm, id, src, alt){
    var img = document.createElement('IMG');
	elm.appendChild(img); 
	img.setAttribute("id", id);
	img.setAttribute("src", src);
	img.setAttribute("alt", alt);
	
	return img;
}

function newUL(elm, code){
	// elm の下に UL を生成して返す
	var p = document.createElement('UL');
    var id = idOfCode(code);
    var cls = classOfCode(code);
	if (id) p.setAttribute("id", id);
	if (cls) p.setAttribute("class", cls);
    
	elm.appendChild(p);
	return p;
}

function newLI(elm, text, code){
	// elm の下に LI を生成して返す
	var p = document.createElement('LI');
    var id = idOfCode(code);
    var cls = classOfCode(code);
	if (id) p.setAttribute("id", id);
	if (cls) p.setAttribute("class", cls);
    
	elm.appendChild(p);
	if (text) newTEXT(p, text);
	return p;
}

function newDL(elm, code){
	// elm の下に DL を生成して返す
	var p = document.createElement('DL');
    var id = idOfCode(code);
    var cls = classOfCode(code);
	if (id) p.setAttribute("id", id);
	if (cls) p.setAttribute("class", cls);
    
	elm.appendChild(p);
	return p;
}
function newDT(elm, code){
	// elm の下に DT を生成して返す
	var p = document.createElement('DT');
    var id = idOfCode(code);
    var cls = classOfCode(code);
	if (id) p.setAttribute("id", id);
	if (cls) p.setAttribute("class", cls);
    
	elm.appendChild(p);
	return p;
}
function newDD(elm, code){
	// elm の下に DD を生成して返す
	var p = document.createElement('DD');
    var id = idOfCode(code);
    var cls = classOfCode(code);
	if (id) p.setAttribute("id", id);
	if (cls) p.setAttribute("class", cls);
    
	elm.appendChild(p);
	return p;
}

function newPopupMenu(elm, id, array, selectedItem){
	var sl = document.createElement('SELECT');
	sl.setAttribute("id", id);
	elm.appendChild(sl);
    
    //array.push(""); // どういう訳か最後に dummy を付けておかないと最終を自動選択できない
	var count = array.length;
	for (var i=0; i < count; i++){
		var title = array[i];
		var op = document.createElement('OPTION');
		tx = document.createTextNode(title);
		op.appendChild(tx);
		op.setAttribute("value",title);
		if (title == selectedItem){
			// op.setAttribute("selected"); -- FireFox では動かない
			op.setAttribute("selected", true);
		}
        // op 属性すべてを設定してから以下を実行すること
		sl.appendChild(op);
	}
	return sl;
}

function newPopupItem(elm, popupName, id, label){
	var ip = document.createElement('INPUT');
	elm.appendChild(ip); 
	ip.setAttribute("type", "radio");
	ip.setAttribute("id", id);
	ip.setAttribute("name", popupName); // radio button グループの共通名称
	var tx = newTEXT(elm, label);
	return ip;
}

function newUploadBUTTON(elm, id, filename){
	// アプロード・ボタンを生成
	// アップロードされたファイルが filenam 名で送られる
	var ip = document.createElement('INPUT');
	ip.setAttribute("TYPE", "file");
	ip.setAttribute("NAME", filename);
	if (id.length) ip.setAttribute("id", id);
	elm.appendChild(ip);
	return ip;
}
function newSubmitBUTTON(elm, id, label){
	// submit(送信)ボタンを生成
	var ip = document.createElement('INPUT');
	ip.setAttribute("TYPE", "submit");
	ip.setAttribute("VALUE", label);
	if (id.length) ip.setAttribute("id", id);
	elm.appendChild(ip);
	return ip;
}
function newFORM(elm, action){
	// FORM を生成: submitButton で action が実行される
	var fm = document.createElement('FORM');
	fm.setAttribute("METHOD", "POST");
	fm.setAttribute("enctype", "multipart/form-data");
	fm.setAttribute("ACTION", action);
	elm.appendChild(fm);
	return fm;
}

function currentDateFormat(){
	// 年月日ポップアップから西暦年月日を返す
	var elm = document.getElementById("wareki");
	var year = document.getElementById("year").value * 1;
	var month = document.getElementById("month").value;
	var day = document.getElementById("day").value;
	
	if (elm){ // 西暦/和暦ポップアップがある場合
		var koyomi = elm.value;
		if (isSame(koyomi,"平成"))
			year += 1988;
		else if (isSame(koyomi,"昭和"))
			year += 1925;
		else if (isSame(koyomi,"大正"))
			year += 1911;
		else if (isSame(koyomi,"明治"))
			year += 1867;
	}
	
	if (month.length < 2) month = "0"+month;
	if (day.length < 2) day = "0"+day;
	return year + "-" + month + "-" + day + " 00:00:00";
}

function koyomiSelected(id){
	// 暦の選択に応じて年数ポップアップを変化させる
	var value = document.getElementById(id).value;
	var js = document.getElementById("yearBase");
	js.innerHTML = "";
	if (isSame(value, "平成"))
		var anArray = makeArray(1, 40); // lib.js
	else if (isSame(value, "昭和"))
		var anArray = makeArray(1, 64);
	else if (isSame(value, "大正"))
		var anArray = makeArray(1, 15);
	else if (isSame(value, "明治"))
		var anArray = makeArray(1, 45);
	else 
		var anArray = makeArray(1915, 100);
	var sl = newPopupMenu(js, "year", anArray, 1);
}
function makeYYMMDD(elm, status, yy, mm, dd){
	// yy,mm,dd の日付ポップアップメニューを "YYMMDD" node に貼付ける
	if (status.length > 0){
		var anArray = new Array("西暦","平成","昭和","大正","明治");
		var sl = newPopupMenu(elm, "wareki", anArray, "西暦");
		sl.setAttribute("onmouseup", "koyomiSelected('wareki')");
	}
	
	var js = newSPAN(elm, "yearBase");
	var anArray = makeArray(1915, 100);
    var sl = newPopupMenu(js, "year", anArray, yy);
	
	anArray = makeArray(1, 12);
    sl = newPopupMenu(elm, "month", anArray, mm);
	
	anArray = makeArray(1, 31);
    sl = newPopupMenu(elm, "day", anArray, dd);
}

function makeRadioButtons(elm, label, names, selection){
	// グループ名 label、タイトル群 names のラジオボタンを生成
	for (name in names){
		var nm = names[name];
		var status = (isSame(selection, nm)) ? 1 : 0;
		makeRadio(elm, nm, label, status);
	}
	
	function makeRadio(elm, name, label, status){
		// radio ボタンを生成
		//var elm = document.getElementById(id);
		elm.innerHTML = "";
		var ip = document.createElement('INPUT');
		ip.setAttribute("type", "radio");
		ip.setAttribute("id", name);
		ip.setAttribute("name", label); // radio button グループの共通名称
		if (status > 0) { ip.setAttribute("checked", true); }
		elm.appendChild(ip); 
		var tx = document.createTextNode(label);
		elm.appendChild(tx); 
	}
}

