
var _calls;
function setCalls(obj){
    _calls = obj;
}
function calls(){
    // 一括処理オブジェクトを返す
    return _calls;
}

function act_add(array){
    var sum = 0;
    for (num in array){
        sum += array[num] * 1;
    }
    return sum;
}

function call(actor, parameter, receiver){
    // ユーザ操作を記憶するエージェント
    // actor へ parameter を渡し、結果を receiver へ返す
    // actor, parameter, receiver はいずれも文字列で渡される
    // parameter = "red,green,blue" のように "," で区切った文字列
    
    //_initDebug(true); //##
    _debug("actor->"+actor); //##
    _debug("parameter->"+parameter); //##
    if (receiver) _debug("receiver->"+receiver); //##
    
    // ここで actor, parameter, receiver のログをとることができる
    if (parameter){
        var ary = parameter.split(',');
        var array = [];
        for (num in ary){
            array.push("'" + trim(ary[num]) + "'");
        }
        var action = actor + "(" + array.join(',') + ")";
    } else {
        var action = actor + "()";
    }
    
    var result = eval(action);
    if (result) _debug("result->"+result); //##
    
    // receiver が指定されていれば 結果を receiver へ返す
    if (receiver){ 
        var action = receiver + "(" + result + ")";
        eval(action);
    }
    
    return result;
}


function callHelp(){
	// 別途ヘルプをパネル表示
	window.open("./callHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

/////////////////////////////////////////////////////////////////
///// 編集パネル /////////////////////////////////////////////////

function savedCalls(){
    closeFloatPanel();
}
function saveCalls(){
    // 編集された call をサーバへ保存
    var name = elmFor("nameF").value;
    var calls = elmFor("textF").value;
    
    if (name.length == 0){
        alert("名前が設定されていません");
        return;
    } else if (calls.length == 0){
        alert("call が空です");
        return;
    }
    
    NRPutCalls(owner(), name, calls, savedCalls);
}

function removeCalls(){
    // 現在表示されている一括処理を削除
    var name = elmFor("nameF").value;
    if (name.length == 0){
        alert("名前が空なので削除できません");
        return;
    }
    
    // calls が null の場合は削除になる
    NRPutCalls(owner(), name, null, savedCalls);
}

function selectedCallsMenu(elm){
    // 編集パネルのポップアップが選択された
    var menu = elm.value;
    elmFor("nameF").value = menu;
    elmFor("textF").value = (calls()[menu]) ? calls()[menu] : "";
}
function openCallEditor(){
    // call のシナリオを作成するパネルを開く
    var x = 20;
    var y = 20;
    var w = 300;
    var title = "動作一括処理 編集パネル";
    var elm = openSeeThroughPanel("_floatPanel", x, y, w, title, "callHelp()", null);
    if (!elm) return;
    
    var div = newDIV(elm, "");
    var obj = calls();
    var menus = allKeys(obj);
    menus.splice(0, 0, "");
    var pu = newPopupMenu(div, "", menus, "");
    pu.setAttribute("onchange", "selectedCallsMenu(this)");
    
    var div = newDIV(elm, "");
    div.style.fontSize = "10pt";
    var value = "";
    var name = "";
    var fd = newFIELD(div, "nameF", "名前", 30, name);
    fd.setAttribute("placeholder", "この一括処理につける名前"); // 入力ヒントを表示
    fd.focus();
    
    var div = newDIV(elm, "");
    var value = "";
    var ta = newTEXTAREA(div, "textF", 40, 5, value);
    
    var div = newDIV(elm, "");
    div.style.textAlign = "right";
    div.style.padding = "5px";
    var bt = newDIV(div, "/whiteButton");
    bt.innerHTML = "この一括処理を削除";
    bt.setAttribute("onclick", "removeCalls()");
    var bt = newDIV(div, "/fixButton");
    bt.innerHTML = "保存";
    bt.setAttribute("onclick", "saveCalls()");
    
    NRGetCalls(owner(), showCalls);
}

///// 編集パネル /////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////


function selectCallsMenu(elm){
    // メニューが選択された
    var menu = elm.innerText;
    if (menu == "...その他"){
        openCallEditor();
    } else {
        var buff = calls()[menu];
        var array = buff.split("\n");
        for (num in array){
            var st = array[num];
            // call 一括動作は "actor|parameter|receiver" 型式で記述
            var ary = st.split('|');
            var actor = trim(ary[0]);
            var parameter = (ary[1]) ? trim(ary[1]) : null;
            var receiver = (ary[2]) ? trim(ary[2]) : null;
            
            call(actor, parameter, receiver);
        }
        closeFloatPanel();
    }
}

function showCalls(answer){
    // calls のポップアップを表示
    var obj = JSON.parse(answer);
    setCalls(obj);
    
    var menus = allKeys(obj);
    menus.push("...その他");
    
    var elm = elmFor("callsPop");
    elm.innerHTML = "";
    for (num in menus){
        var menu = menus[num];
        
        var div = newDIV(elm, "");
        var bt = newDIV(div, "/blueButton");
        bt.innerHTML = menu;
        bt.setAttribute("onclick", "selectCallsMenu(this)");
    }
}
function openCalls(){
    // call 一括処理のメニューを表示
    //_initDebug(true); //##
    _debug("openCalls"); //##
    
    var x = 20;
    var y = 50;
    var w = 200;
    var title = "動作一括処理";
    var elm = openSeeThroughPanel("_floatPanel", x, y, w, title, "callHelp()", null);
    if (!elm) return;
    
    var div = newDIV(elm, "callsPop");
    div.style.padding = "5px";
    div.style.fontSize = "10pt";
    
    NRGetCalls(owner(), showCalls);
}

