
var _isPrivate = false; //####### 開発者用 #######

// cell.type に与える定数
var _mainPane = 0; // NOA メイン・エリア
var _toolPane = 1; // TOOL エリア

// 診療情報・基本情報・保険情報の各ページを区別するフラッグ
var _progress_ = 0;
var _basic_ = 1;
var _ins_ = 2;

// 以下は cell.id へ設定されるが、第７世代 NOA の cell.id とカブらないよう数値以外とする
var _progress = 'P';
var _basic = 'B';
var _insurance = 'I';

function modeForTag(tag){
    // tag から mode を判定して返す
    var array = tag.split(".");
    var table = array[0];
    if (table == "ProgressSection"){
        return _progress;
    } else if (tag == "FrontTable.plan"){
        return _progress;
    } else if (table.indexOf("Insurance") >= 0){
        return _insurance;
    } else {
        return _basic;
    }
}

///////////////////////////////////////////////////////
///// MENU STRUCTURE //////////////////////////////////

// menuType
var _main = 0;
var _page = 1;
var _tool = 2;

function menuTemplate(){
    // メニュー構造のテンプレート
    var array = new Array();
    
    // メイン・メニュー =========================
    array.push({"menuType":_main,"label":"履歴","url":"showAccessLog()","editor":"カルテの参照履歴"});
    array.push({"menuType":_main,"label":"待受","url":"showBookingList()","editor":"受診待ちリスト"});
    array.push({"menuType":_main,"label":"検索","url":"search()","editor":"カルテ内容を検索","fix":"1"});
    
    if (_isPrivate)
        array.push({"menuType":_main,"label":"周産期管理","url":"../PerinatalManager","editor":"周産期管理","icon":"human.png","window":"1"}); // ### PRIVATE
    
    
    array.push({"menuType":_main,"label":"ProblemList","url":"./problemList.php","editor":"ProblemList","icon":"checkGreen.png"});
    
    
    // ページ・ヘッダー =========================
    array.push({"menuType":_page,"label":"ページ追加","url":"addTodayPage()","editor":"ページ追加", "icon":"add-field.png"});
    array.push({"menuType":_page,"label":"テンプレート・メニュー","url":"openTemplateMenu()","editor":"テンプレート・メニュー", "icon":"menu.png"});
    array.push({"menuType":_page,"label":"文書作成","url":"../DocMaker","editor":"文書作成","window":"1","icon":"docSmall.png"});
    array.push({"menuType":_page,"label":"予約","url":"../Booking","editor":"診療予約","icon":"list.png"});
    array.push({"menuType":_page,"label":"付箋","url":"showPostItForce()","editor":"付箋","fix":"1","icon":"flag.png"});
    array.push({"menuType":_page,"label":"Print","url":"printPDF()","editor":"印刷", "fix":"1","icon":"printer.png"});
    array.push({"menuType":_page,"label":"ページ削除","url":"removeTodayPage()","editor":"ページ削除", "icon":"remove-field.png"});
    
    // ツール・メニュー ==========================
    // 検索 ---------------------
    array.push({"menuType":_tool,"label":"検索","subTitle":"1"});
    array.push({"menuType":_tool,"label":"条件検索","url":"./chartFinder.php"});
    array.push({"menuType":_tool,"label":"受診日検索","url":"./lvdSearch.php"});
    
    if (_isPrivate){
        array.push({"menuType":_tool,"label":"薬剤検索","url":"/Medicine"});
        array.push({"menuType":_tool,"label":"妊婦検索","url":"../PregnantFinder","window":"1"});
        array.push({"menuType":_tool,"label":"SimpleNote","url":"https://simple-note.appspot.com/"});
    }
    
    // 道具 ----------------------
    array.push({"menuType":_tool,"label":"道具","subTitle":"1"});
    array.push({"menuType":_tool,"label":"Pickup","url":"../PickUp"});
    array.push({"menuType":_tool,"label":"リマインダー","url":"../Reminder"});
    array.push({"menuType":_tool,"label":"Draw","url":"../Draw","window":"1"});
    array.push({"menuType":_tool,"label":"画像読込","url":"../Picture"});
    
    if (_isPrivate){
        array.push({"menuType":_tool,"label":"HL7","url":"../HL7","window":"1"}); // ### PRIVATE
    }
    
    array.push({"menuType":_tool,"label":"添付文書","url":"../Prescription"});
    array.push({"menuType":_tool,"label":"年齢計算","url":"../AGE"});
    array.push({"menuType":_tool,"label":"妊娠暦","url":"../ReproductiveHistory"});
    array.push({"menuType":_tool,"label":"診療統計","url":"../Statistics","window":"1"});
    
    // 印刷 -----------------------
    array.push({"menuType":_tool,"label":"印刷","subTitle":"1"});
    array.push({"menuType":_tool,"label":"カルテの全ページ","url":"printAllPages()"});
    array.push({"menuType":_tool,"label":"本日受診の全カルテ","url":"printAllPDF()"});
    
    // 受付 -----------------------
    array.push({"menuType":_tool,"label":"受付","subTitle":"1"});
    array.push({"menuType":_tool,"label":"FRONT","url":"openFRONT()","window":"1"});
    array.push({"menuType":_tool,"label":"FRONTへ伝達","url":"openMessenger()"});
    array.push({"menuType":_tool,"label":"新患登録","url":"./patientRegister.php"});
    array.push({"menuType":_tool,"label":"診療予約","url":"../Booking","window":"1"});
    array.push({"menuType":_tool,"label":"保険証画像","url":"../InsViewer","window":"1"});
    array.push({"menuType":_tool,"label":"月計表","url":"../FRONT/monthlyTable.php"});
    array.push({"menuType":_tool,"label":"待受パネル","url":"showWaitingListPanel()"});
    // array.push({"menuType":_tool,"label":"ORCA接続","url":""});
    
    // 管理 ------------------------
    array.push({"menuType":_tool,"label":"管理","subTitle":"1"});
    array.push({"menuType":_tool,"label":"バックアップ","url":"./archiver.php", "fix":"1"});
    array.push({"menuType":_tool,"label":"NOAManager","url":"../NOAManager", "window":"1"});
    if (_isPrivate){
        array.push({"menuType":_tool,"label":"phpMyAdmin","url":"http://202.17.213.209/phpMyAdmin", "window":"1"});
    }
    
    // 設定 ------------------------
    array.push({"menuType":_tool,"label":"設定","subTitle":"1"});
    array.push({"menuType":_tool,"label":"初期設定","url":"./preference.php", "fix":"1"});
    array.push({"menuType":_tool,"label":"レイアウト設定","url":"./layout.php", "fix":"1"});
    array.push({"menuType":_tool,"label":"PriceList","url":"../NOAManager/priceList.php","window":"1"});
    
    // HELP -----------------------
    array.push({"menuType":_tool,"label":"HELP","subTitle":"1"});
    array.push({"menuType":_tool,"label":"InfoBoard","url":"../InfoBoard", "fix":"1"});
    array.push({"menuType":_tool,"label":"SOURCEFORGE","url":"http://sourceforge.jp/projects/noa-project/", "window":"1"});
    array.push({"menuType":_tool,"label":"NOA Project","url":"https://sites.google.com/site/noawebspace", "window":"1"});
    if (_isPrivate){
        array.push({"menuType":_tool,"label":"TEST","url":"test()"});
    }
    
    return array;
}

var _outputTarget;
function setOutputTarget(status){
    _outputTarget = status;
}
function outputTarget(){
    // ウンど～を外部へ開くか toolArea へ開くかを返す
    return (_outputTarget * 1 > 0) ? "_blank" : "tools";
}

var _clickedElement;
function setClickedElement(elm){
    // ICON ギャラリーの中のクリックされたアイコンを記憶
    _clickedElement = elm;
}
function clickedElement(){
    return _clickedElement;
}
function kickedWindow(answer){
    // NRKickWindow() のレシーバー
    var obj = JSON.parse(answer);
    
    var win = window.open(obj.url, obj.arguments);
    win.focus();
}
function kickMenuCell(url, inWindow, cliickedElement){
    // ToolMenu のクリックによりアクションを起動
    setOutputTarget(inWindow);
    setClickedElement(cliickedElement);
    
    if (url && ((url.indexOf("()") > 0))){
        // 組込み関数を実行
        eval(url);
    } else {
        // URL を実行
        NRKickWindow(url, outputTarget(), kickedWindow);
    }
}

///// MENU STRUCTURE //////////////////////////////////
///////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////
///// CELL STRUCTURE //////////////////////////////////////////

function cellTemplate(){
    // CELL 構造のテンプレート：サーバにデータがない場合使われる default 値
    var obj = new Object();
    
    var num = 0;
    makeCell(obj, num++, _progress, "ProgressSection.pageHeader", "記録", 0, 6);
    makeCell(obj, num++, _progress, "ProgressSection.subject", "主訴", 1, 3, "");
    makeCell(obj, num++, _progress, "ProgressSection.object", "所見", 1);
    makeCell(obj, num++, _progress, "ProgressSection.assessment", "考察", 1);
    makeCell(obj, num++, _progress, "ProgressSection.plan", "予定", 1);
    makeCell(obj, num++, _progress, "FrontTable.plan", "計画", 1);
    makeCell(obj, num++, _progress, "ProgressSection.disease", "病名", 1, 6, "openDisease");
    makeCell(obj, num++, _progress, "ProgressSection.examination", "検査", 1, 6, "openForm");
    makeCell(obj, num++, _progress, "ProgressSection.prescription", "処方", 1, 6, "openPrescriptionEditor");
    makeCell(obj, num++, _progress, "ProgressSection.treatment", "診療", 1, 6, "openVinEditor");
    
    var num = 0;
    makeCell(obj, num++, _basic, "NameSection.patientKanjiName", "氏名", 0, 6);
    makeCell(obj, num++, _basic, "NameSection.patientKanaName", "ふりがな", 0, 6);
    makeCell(obj, num++, _basic, "NameSection.patientRomajiName", "ローマ字", 0, 6);
    makeCell(obj, num++, _basic, "PatientTable.anotherId", "anotherId", 0, 6);
    makeCell(obj, num++, _basic, "PatientTable.receiptId", "receiptId", 0, 6);
    makeCell(obj, num++, _basic, "PatientTable.birthDate", "生年月日", 0, 5);
    makeCell(obj, num++, _basic, "PatientTable.sex", "性別", 0, 4);
    makeCell(obj, num++, _basic, "UniversalSection.introduction", "紹介", 0);
    makeCell(obj, num++, _basic, "AddressSection.email", "E-mail", 0, 6);
    makeCell(obj, num++, _basic, "AddressSection.zip", "郵便番号", 0, 6);
    makeCell(obj, num++, _basic, "AddressSection.address", "住所", 0, 1);
    makeCell(obj, num++, _basic, "AddressSection.phone", "電話", 0, 6);
    makeCell(obj, num++, _basic, "BasicSection.job", "本人職業", 0);
    makeCell(obj, num++, _basic, "MalitalSection.type", "婚姻", 0, 4);
    makeCell(obj, num++, _basic, "MalitalSection.startDate", "結婚日", 0, 5);
    makeCell(obj, num++, _basic, "MalitalSection.partner", "配偶者", 0, 6);
    makeCell(obj, num++, _basic, "MalitalSection.partnersJob", "配偶職業", 0);
    makeCell(obj, num++, _basic, "MalitalSection.partnersOffice", "勤務先", 0);
    makeCell(obj, num++, _basic, "BasicSection.allergy", "アレルギー", 1, 4);
    
    if (_isPrivate){
        makeCell(obj, num++, _basic, "UniversalSection.menstrualCycle", "月経周期", 0); // local
        makeCell(obj, num++, _basic, "UniversalSection.menstruationBlood", "月経血", 0, 4); // local
        makeCell(obj, num++, _basic, "UniversalSection.periodPains", "月経痛", 0, 4); // local
        makeCell(obj, num++, _basic, "UniversalSection.firstMenstrualPeriod", "初潮", 0, 4); // local
        makeCell(obj, num++, _basic, "UniversalSection.KA", "KA", 0, 4); // local
        makeCell(obj, num++, _basic, "UniversalSection.SA", "SA", 0, 4); // local
        makeCell(obj, num++, _basic, "UniversalSection.FG", "FG", 0, 4); // local
        makeCell(obj, num++, _basic, "UniversalSection.NG", "NG", 0, 4); // local
        makeCell(obj, num++, _basic, "UniversalSection.pregnancyRecord", "妊娠履歴", 0); // local
        makeCell(obj, num++, _basic, "UniversalSection.menopause", "閉経", 0, 6); // local
    }
    
    makeCell(obj, num++, _basic, "BasicSection.bloodtype", "血液型", 0, 4);
    makeCell(obj, num++, _basic, "BasicSection.drinking", "飲酒", 0);
    makeCell(obj, num++, _basic, "BasicSection.smoking", "喫煙", 0);
    makeCell(obj, num++, _basic, "BasicSection.history", "既往歴", 0);
    makeCell(obj, num++, _basic, "AddressSection.memo", "メモ", 0);
    
    var num = 0;
    makeCell(obj, num++, _insurance, "HealthInsurance.shubetsu", "種別", 0);
    makeCell(obj, num++, _insurance, "HealthInsurance.kubun", "区分", 0);
    makeCell(obj, num++, _insurance, "HealthInsurance.paymentRatio", "負担割", 0);
    makeCell(obj, num++, _insurance,
             "HealthInsurance.kigou", "記号", 0);
    makeCell(obj, num++, _insurance, "HealthInsurance.bangou", "番号", 0);
    makeCell(obj, num++, _insurance, "HealthInsurance.ownerNumber", "保険番号", 0);
    makeCell(obj, num++, _insurance, "HealthInsurance.ownerName", "保険者名", 0);
    makeCell(obj, num++, _insurance, "HealthInsurance.ownerPhone", "電話", 0);
    makeCell(obj, num++, _insurance, "HealthInsurance.continuedDiseases", "継続療養", 0);
    makeCell(obj, num++, _insurance, "HealthInsurance.discountRatio", "割引％", 0);
    makeCell(obj, num++, _insurance, "HealthInsurance.startDate", "資格取得", 0);
    makeCell(obj, num++, _insurance, "HealthInsurance.expiredDate", "有効期限", 0);
    makeCell(obj, num++, _insurance, "HealthInsurance.confirmation", "証書確認", 0);
    makeCell(obj, num++, _insurance, "PublicInsurance.shubetsu", "公費種別", 0);
    makeCell(obj, num++, _insurance, "PublicInsurance.ownerName", "公費名称", 0);
    makeCell(obj, num++, _insurance, "PublicInsurance.ownerNumber", "負担番号", 0);
    makeCell(obj, num++, _insurance, "PublicInsurance.recipientNumber", "受給番号", 0);
    makeCell(obj, num++, _insurance, "PublicInsurance.paymentRatio", "負担率", 0);
    makeCell(obj, num++, _insurance, "PublicInsurance.payment", "負担額", 0);
    makeCell(obj, num++, _insurance, "PublicInsurance.startDate", "交付日", 0);
    makeCell(obj, num++, _insurance, "PublicInsurance.expiredDate", "有効期限", 0);
    
    return obj;
    
    function makeCell(obj, num, mode, tag, label, fieldType, menuType, editor){
        // CELL 属性を生成
        var cell = new Object();
        // owner
        cell.tag = tag;
        cell.buttonType = 0; // 0:メニュー複数選択 1:単一選択
        // menuType 0:rotary 1:address 2:calendar 3:group 4:panel 5:date 6:none
        cell.menuType = (menuType) ? menuType : 0;
        cell.menuAction = 1; //  0:文末へ追加 1:最終行へ追加 2:置換
        cell.hitAndRun = ""; // 0:表示 1:非表示
        cell.fieldType = fieldType; // 0:field 1:text
        cell.direction = "CELL"; // old NOA 型式との識別用
        cell.disabled = (tag == "PatientTable.birthDate") ? 1 : 0;
        cell.editor = (editor) ? editor : "";
        cell.id = mode;
        cell.script = "";
        cell.bgcolor = "";
        cell.label = label;
        cell.numbering = num; // groupMenu の場合、プロブレム番号自動付加を示す
        cell.study = 0;
        cell.fontSize = "";
        cell.fontFamily = "";
        cell.color = "";
        
        obj[tag] = cell;
    }
}

///// CELL STRUCTURE //////////////////////////////////////////
///////////////////////////////////////////////////////////////


var _hospId;
function setHospId(id){
	_hospId = id;
}
function hospId(){
	return _hospId;
}

var _hospitalObj;
function setHospitalObj(obj){
    _hospitalObj = obj;
}
function hospitalObj(){
    /*
    userCode(all)sectionCode(23)groupCode(doctor)loginName(ohashi)kanjiName(大橋 克洋)identifier(c44f9b64052f12c4e9229fd899c7113b)hospitalId(1304000000077)memo()entryDate(2010-04-29 15:49:06)updateTime(2013-06-23 19:04:20)owner(ohashi)rowid(38)hospitalTable(大橋医院(1304000000077)SEA SIDE CLINIC(03234200))hospitalName(大橋医院)
     */
    return _hospitalObj;
}
function hospitalName(){
    return (_hospitalObj) ? _hospitalObj.hospitalName : null;
}
function hospitalId(){
    return (_hospitalObj) ? _hospitalObj.hospitalId : null;
}
function userCode(){
    return (_hospitalObj) ? _hospitalObj.userCode : null;
}
function isSuperUser(){
    return (_hospitalObj && (_hospitalObj.userCode == "all")) ? true : false;
}
function owner(){
    return (_hospitalObj) ? _hospitalObj.loginName : null;
}
function userName(){
    // 旧バージョンの userKanjiName に相当：漢字氏名を返す
    return (_hospitalObj) ? _hospitalObj.kanjiName : null;
}

var _timeLimit;
function setTimeLimit(val){
	// 編集可能時間を記憶: "3" or ("3:00" or "3:00:00") 形式
	var array = val.split(":");
	switch (array.length){
		case 1: var sec = array[0] * 3600; break;
		case 2: var sec = array[0] * 3600 + array[1] * 60; break;
		default: var sec = array[0] * 3600 + array[1] * 60 + array[2] * 1; break;
	}
	_timeLimit = "" + sec;
}
function timeLimit(){
	return _timeLimit;
}

var _geOpen; // _groupEditorOpen 名称は cellEditor とカブる
function setGroupEditorOpen(status){
    //showToolMessage("setGroupEditorOpen-> "+status);
    _geOpen = status;
}
function groupEditorOpen(){
    // グループ・メニューのサブ・エディターが開いていれば true を返す
    return _geOpen;
}

var _ctag;
function setCurrentTag(tag){
    //document.getElementById("currentTagInfo").innerHTML = tag; //##
    _ctag = tag;
}
function currentTag(){
    return _ctag;
}

var _hospitalInfo;
function setHospitalInfo(obj){
    // obj = 施設名(大橋医院)まるめ係数(5)診療曜日(,月,火,水,木,金,土)保険医療機関コード(0926253)自費係数(20)住所(142-0063 東京都品川区荏原4-4-2)訂正可能時間(24)施設(診療所)診療時間(,,0000,0600,深夜^,,2200,2400,深夜^,日,0000,2400,休日^,,0845,1215,時間内^,,1445,1715,時間内^,,0900,1200,時間内^)電話番号(03-3784-3101)明細書発行体制等加算(yes)都道府県番号(13)点数表番号(1)FAX(03-3784-5215)
    // alert("setHospitalInfo->"+encodeObject(obj)); //##
    _hospitalInfo = obj;
    
    if (obj && obj['訂正可能時間'])
        setTimeLimit(obj['訂正可能時間']);
    else
        setTimeLimit("24");
}
function hospitalInfoForKey(key){
    return _hospitalInfo[key];
}

var _cellArray;
var _layoutObj;
function setLayoutObj(records){
    // NOA のレイアウトを記憶
    //_debug("=== setLayoutObj->"+records+"->"+records.length); //##
    
    var parray = new Array();
    var barray = new Array();
    var harray = new Array();
    _cellArray = new Array();
    
    if (records.length > 0){
        for (num in records){
            var cell = records[num];
            //_debug(cell.tag+"->"+cell.label+"->"+cell.id); //##
            
            switch(cell.id){
                case 'P': parray.push(cell); break;
                case 'B': barray.push(cell); break;
                case 'I': harray.push(cell); break;
            }
            _cellArray.push(cell);
        }
    } else { // DB にレイアウトが記憶されていない場合はテンプレートを使う
        var obj = cellTemplate();
        for (tag in obj){
            var cell = obj[tag];
            //_debug(cell.tag+"->"+cell.label+"->"+cell.id); //##
            
            switch(cell.id){
                case 'P': parray.push(cell); break;
                case 'B': barray.push(cell); break;
                case 'I': harray.push(cell); break;
            }
            _cellArray.push(cell);
        }
    }
    
    _layoutObj = new Object();
    _layoutObj[_progress_] = parray;
    _layoutObj[_basic_] = barray;
    _layoutObj[_ins_] = harray;
}
function layoutForMode(mode){
    // _progress_ _basic_ _ins_ 毎の CELL レイアウトの配列
    if (mode > _ins_){
        return null;
    } else {
        var lo = _layoutObj;
        if (lo && lo[mode] && Object.keys(lo[mode]).length){
            //alert("layoutForMode exist->"+encodeObject(_layoutObj)); //##
            return _layoutObj[mode];
        } else { // DB にレイアウトが記憶されていない場合はテンプレートを使う
            var parray = new Array();
            var barray = new Array();
            var harray = new Array();
            _cellArray = new Array();
            var obj = cellTemplate();
            for (tag in obj){
                var cell = obj[tag];
                switch(cell.id){
                    case 'P': parray.push(cell); break;
                    case 'B': barray.push(cell); break;
                    case 'I': harray.push(cell); break;
                }
                _cellArray.push(cell);
            }
            //alert("layoutForMode ->"+encodeObject(_layoutObj)); //##
            
            _layoutObj = new Object();
            _layoutObj[_progress_] = parray;
            _layoutObj[_basic_] = barray;
            _layoutObj[_ins_] = harray;

            // CELL 属性を保存するとレイアウトの一部だけが DB に保存されるため、
            // レイアウト・テンプレートが読み込まれずページ表示が不完全になる
            // これを防ぐためレイアウト・テンプレートを使ったらそれを DB に記憶
            // ### それ以前のレイアウトやCELL属性の編集結果は上書きされてしまうが
            // ### NOA インストール初期だけに発生する現象なので問題は少ないはず
            NRPostLayout(owner(), encodeObject(_cellArray), NRNoAction);

            return _layoutObj[mode];
        }
    }
}
function cellArray(){
    // CELL の配列を返す
    /* CELL 構造
     tag(ProgressSection.subject)buttonType(1)menuType(3)menuAction(1)hitAndRun(0)fieldType(0)disabled(0)editor()id(P)script()bgcolor()label(主訴)numbering(0)study(1)fontSize(0)fontFamily()color()
     */
    return _cellArray;
}
function cellForTag(tag){
    // tag に対応する CELL を返す
    for (num in _cellArray){
        var cell = _cellArray[num];
        if (cell.tag == tag) return cell;
    }
    return null;
}
function progressTagArray(){
    // ProgressSection の TAG の配列を返す
    var array = new Array();
    for (num in _cellArray){
        var cell = _cellArray[num];
        if (cell.tag.indexOf("ProgressSection") < 0) continue;
        
        array.push(cell.tag);
    }
    return array;
}
function labelForTag(tag){
    // tag に対応する label を返す
    for (num in _cellArray){
        var rec = _cellArray[num];
        if (rec.tag == tag) return rec.label;
    }
    return "";
}

var _toolMenus;
var _isTemplateMenu;
function isTemplateMenu(){
    // TOOL MENU が menuTemplate() から生成されている
    return _isTemplateMenu;
}
function setToolMenus(array){
    // array = 0(window(0)menuType(0)fix(0)subTitle(0)disabled(0)editor(カルテの参照履歴)id(0)url(showAccessLog^[^^]^)label(履歴)icon())1(window(0)menuType(0)fix(0)subTitle(0)disabled(0)editor(受診待ちリスト)id(1)url(showWaitingList^[^^]^)label(待受)icon())
    //alert("setToolMenus->"+encodeObject(array)); //##
    if (array.length){
        _toolMenus = array;
        _isTemplateMenu = false;
    } else {
        _toolMenus = menuTemplate();
        _isTemplateMenu = true;
    }
}
function toolMenus(){
    // [{"id":"1","label":"検索",,,},,,] 形式のメニュー構造を保持
    for (num in _toolMenus){
        var cell = _toolMenus[num];
        
        // menuTemplate() には id がないので num を id として cell に記憶
        // 新たに menuCell が追加される場合は最大 id が振られる
        cell.id = num;
    }
    
    return _toolMenus;
}
/*
function setToolMenus(array){
    // array = 0(window(0)menuType(0)fix(0)subTitle(0)disabled(0)editor(カルテの参照履歴)id(0)url(showAccessLog^[^^]^)label(履歴)icon())1(window(0)menuType(0)fix(0)subTitle(0)disabled(0)editor(受診待ちリスト)id(1)url(showWaitingList^[^^]^)label(待受)icon())
    //alert("setToolMenus->"+encodeObject(array)); //##
    if (array.length){
        _toolMenus = array;
    } else {
        _toolMenus = null;
    }
}
function toolMenus(){
    // [{"id":"1","label":"検索",,,},,,] 形式のメニュー構造を保持
    if (_toolMenus){
        _isTemplateMenu = false;
    } else {
        _toolMenus = menuTemplate();
        
        for (num in _toolMenus){
            var cell = _toolMenus[num];
            
            // menuTemplate() には id がないので num を id として cell に記憶
            // 新たに menuCell が追加される場合は最大 id が振られる
            cell.id = num;
        }
        _isTemplateMenu = true;
    }
    
    return _toolMenus;
}
*/

var _patientId;
function setPatientId(id){
    _patientId = id;
}
function patientId(){
    return _patientId;
}
var _patientName;
function setPatientName(name){
    _patientName = name;
}
function patientName(){
    return _patientName;
}

var _currentDate;
function setCurrentDate(dateTime){
    _currentDate = dateTime;
}
function currentDate(){
    return _currentDate;
}

var _patientTable;
function setPatientTable(obj){
    // ProgressSection のデータを記憶
    // _patientTable = date(2013-06-24 11:19:31)anotherId()receiptId()sex(女)unpaid(2013-06-24 11:20:24,0)birthDate(1941-06-11)lastVisitDate(2013-06-24 11:30:56)
    //_debug("setPatientTable->"+encodeObject(obj)); //##
    _patientTable = obj;
}
function anotherId(){
    return _patientTable.anotherId;
}
function sex(){
    return _patientTable.sex;
}
function unpaid(){
    return _patientTable.unpaid;
}
function birthDate(){
    return _patientTable.birthDate;
}
function lastVisitDate(){
    return _patientTable.lastVisitDate;
}

var _frontObj;
function setFrontObj(obj){
    // FrontTable のデータを記憶
    // obj = "plan(flag(true)val(治療)update(2013-08-12 17:56:20))"
    //alert("setFrontObj->"+encodeObject(obj)); //##
    _frontObj = obj;
}
function frontTableObj(){
    return _frontObj;
}

var _progressObj;
function setProgressObj(obj){
    // ProgressSection のデータを記憶
    //_progressObj = {entryDate:{"entryDate:"",suject:"",object:"",,,,}}
    
    //alert("setProgressObj->"+encodeObject(obj)); //##
    _progressObj = obj;
}
function progressObj(){
    // calendar.js で使われる
    return _progressObj;
}
function history(){
    // 受診日の配列を返す
    var array = new Array();
    for (dateTime in _progressObj){
        if (dateTime == "0000-00-00 00:00:00") continue;
        
        array.push(dateTime);
    }
    return array;
}

var _nameObj;
function setNameObj(obj){
    // currentDate における NameSection のデータを記憶
    // _nameObj = 1989-03-20 00:00:00(patientKanjiName(里野 春)patientKanaName(さとの はる)patientRomajiName(satono haru))
    //_debug("setNameObj->"+encodeObject(obj)); //##
    _nameObj = obj;
}
function patientKanjiName(){
    return (_nameObj) ? _nameObj.patientKanjiName.val : "??";
}

function patientAge(dateTime){
    // dateTime の年令を返す
    var obj = valueForTag("PatientTable.birthDate"); // 1942-03-23 型式
    var birthDate = obj.value;
    return　ageAtDate(birthDate, dateTime);
}

var _addressObj;
function setAddressObj(obj){
    //_debug("setAddressObj ->"+encodeObject(obj)); //##
    _addressObj = obj;
}

var _basicObj;
function setBasicObj(obj){
    _basicObj = obj;
}

var _maritalObj;
function setMaritalObj(obj){
    _maritalObj = obj;
}

var _healthInsObj;
function setHealthInsuranceObj(obj){
    // date(2011-12-03 10:37:29)ownerName(日立物流健保組合)ownerNumber(06135024)ownerPhone(03-5634-0326)shubetsu(組合)kubun(本人)kigou(335)bangou(788421)continuedDiseases()paymentRatio(3)discountRatio(0)confirmation(2011-12-03 10:49:31 ohashi)startDate(2007-04-01)expiredDate(0000-00-00)
    _healthInsObj = obj;
}

var _publicInsObj;
function setPublicInsuranceObj(obj){
    //_debug("setPublicInsuranceObj ->"+encodeObject(obj)); //##
    _publicInsObj = obj;
}

var _univObj;
function setUniversalObj(obj){
    // menstrualCycle(date(28-30)value(28-30)type(0))menstruationBlood(date(中)value(中)type(0))periodPains(date(中)value(中)type(0))firstMenstrualPeriod(date(小学校)value(小学校)type(0))KA(date(0)value(0)type(0))SA(date(1)value(1)type(0))FG(date(0)value(0)type(0))NG(date(2)value(2)type(0))pregnancyRecord(date(h 16.9 NG 神奈川県立足柄病院 3335 gr female h 20.12 NG 神奈川県立足柄病院 3300 gr male)value(h 16.9 NG 神奈川県立足柄病院 3335 gr female h 20.12 NG 神奈川県立足柄病院 3300 gr male)type(0))
    //_debug("setUniversalObj ->"+encodeObject(obj)); //##
    _univObj = obj;
}

var _postItObjects;
function setPostItObjects(array){
    // PostIt オブジェクトの配列を記憶
    // array = '(2013-08-06 07:06:00(value(test)type(0)updateTime(2013-08-07 15:32:05))date(value(..)type(..)updateTime(..)))' 形式
    //alert("setPostItObjects->"+encodeObject(array)); //##
    
    _postItObjects = array;
}
function postItForDate(dateTime){
    // dateTime に相当する postIt オブジェクトを返す
    //alert("postItForDate->"+dateTime); //##
    for (dtime in _postItObjects){
        //alert("dtime->"+dtime); //##
        if (dtime <= dateTime) return _postItObjects[dtime];
    }
    return null;
}

function setValueForTag(tag, dateTime, value){
    // tag, dateTime に対応する value を記憶
    //alert("setValueForTag->"+tag+"->"+value); //##
    var ary = tag.split(".");
    var table = ary[0];
    var field = (ary.length > 1) ? ary[1] : "";
    if (table == "PatientTable"){
        _patientTable[field] = value;
        _patientTable.date = dateTime;
    } else if (table == "NameSection"){
        // _nameObj は存在しても _nameObj[field] が存在しないことがある
        if (!_nameObj[field]) _nameObj[field] = new Array();
        _nameObj[field]['val'] = value;
        _nameObj.update = dateTime;
    } else if (table == "AddressSection"){
        if (!_addressObj[field]) _addressObj[field] = new Array();
        _addressObj[field]['val'] = value;
        _addressObj.update = dateTime;
    } else if (table == "BasicSection"){
        if (!_basicObj[field]) _basicObj[field] = new Array();
        _basicObj[field]['val'] = value;
    } else if (table == "MalitalSection"){
        if (!_maritalObj[field]) _maritalObj[field] = new Array();
        _maritalObj[field]['val'] = value;
        _maritalObj.update = dateTime;
    } else if (table == "HealthInsurance"){
        if (!_healthInsObj[field]) _healthInsObj[field] = new Array();
        _healthInsObj[field]['val'] = value;
        _healthInsObj.update = dateTime;
    } else if (table == "PublicInsurance"){
        if (!_publicInsObj[field]) _publicInsObj[field] = new Array();
        _publicInsObj[field]['val'] = value;
        _publicInsObj.update = dateTime;
    } else if (table == "UniversalSection"){
        if (!_univObj[field]) _univObj[field] = new Array();
        _univObj[field]['value'] = value;
        _univObj.update = dateTime;
    } else if (table == "FrontTable"){
        if (! _frontObj[dateTime])
            _frontObj[dateTime] = new Array(); // FrontTable では必要
        if (! _frontObj[dateTime][field])
            _frontObj[dateTime][field] = new Array();
        _frontObj[dateTime][field]['val'] = value;
        _frontObj[dateTime][field]['update'] = dateTime;
    } else if (table == "ProgressSection"){
        // obj[dateTime] は存在しても obj[dateTime][field] が存在しないことがある
        if (! _progressObj[dateTime][field])
            _progressObj[dateTime][field] = new Array();
        _progressObj[dateTime][field]['val'] = value;
        _progressObj[dateTime][field]['update'] = dateTime;
    }
}
function valueForTag(tag, dateTime){
    // tag に対応する当日の値の入ったオブジェクトを返す
    if (!dateTime) dateTime = currentDate();
    
    var ary = tag.split(".");
    var table = ary[0];
    var field = (ary.length > 1) ? ary[1] : "";
    if (table == "PatientTable"){
        // PatientTable のみは updateTime を持つ必要がないので構造が他と異なる
        var obj = new Object();
        obj.value = _patientTable[field];
        obj.isPast = false;
        return obj;
    } else if (table == "NameSection"){
        var obj = new Object();
        if (_nameObj[field]){
            obj.value = _nameObj[field]['val'];
            var udate = _nameObj[field]['update'];
            obj.isPast = (isSameDate(udate, dateTime)) ? false : true;
        }
        return obj;
    } else if (table == "AddressSection"){
        var obj = new Object();
        if (_addressObj[field]){
            obj.value = _addressObj[field]['val'];
            var udate = _addressObj[field]['update'];
            obj.isPast = (isSameDate(udate, dateTime)) ? false : true;
        }
        return obj;
    } else if (table == "BasicSection"){
        var obj = new Object();
        if (_basicObj[field]){
            obj.value = _basicObj[field]['val'];
            var udate = _basicObj[field]['update'];
            obj.isPast = (isSameDate(udate, dateTime)) ? false : true;
        }
        return obj;
    } else if (table == "MalitalSection"){
        var obj = new Object();
        if (_maritalObj[field]){
            obj.value = _maritalObj[field]['val'];
            var udate = _maritalObj[field]['update'];
            obj.isPast = (isSameDate(udate, dateTime)) ? false : true;
        }
        return obj;
    } else if (table == "HealthInsurance"){
        var obj = new Object();
        if (_healthInsObj[field]){
            obj.value = _healthInsObj[field]['val'];
            var udate = _healthInsObj[field]['update'];
            obj.isPast = (isSameDate(udate, dateTime)) ? false : true;
        }
        return obj;
    } else if (table == "PublicInsurance"){
        var obj = new Object();
        if (_publicInsObj[field]){
            obj.value = _publicInsObj[field]['val'];
            var udate = _publicInsObj[field]['update'];
            obj.isPast = (isSameDate(udate, dateTime)) ? false : true;
        }
        return obj;
    } else if (table == "UniversalSection"){
        var obj = new Object();
        if (_univObj[field]){
            obj.value = _univObj[field]['value'];
            var udate = _univObj[field]['update'];
            obj.isPast = (isSameDate(udate, dateTime)) ? false : true;
        } else {
            obj.value = "";
            obj.isPast = true;
        }
        return obj;
    } else if (table == "FrontTable"){
        var obj = new Object();
        var hasCurrentDate = false;
        obj.value = "";
        obj.isPast = true;
        for (date in _frontObj){
            if (date > dateTime) continue;
            
            var rec = _frontObj[date];
            for (fld in rec){
                if (fld == field){
                    var record = rec[fld];
                    var val = record['val'];
                    if (val && (val.length > 0)){
                        // 当日データは取得炭なので他日データはスキップ
                        // この後で当日データが出てくる可能性あるため return しない
                        // setValueForTag() で追加されたデータは sort されていないため
                        if (! isSameDate(date, dateTime) && hasCurrentDate)
                            continue;

                        obj.value = val;
                        var update = record['update'];
                        obj.isPast = (isSameDate(update, dateTime)) ? false : true;
                        
                        // 当日のデータを取得済みであることを記憶
                        if (isSameDate(date, dateTime)) hasCurrentDate = true;
                    }
                }
            }
        }
        return obj;
    } else if (table == "ProgressSection"){
        // ProgressSection の場合は空データを過去へ遡る動作をこちら：クライアント側で行う
        var obj = new Object();
        obj.value = "";
        obj.isPast = true;
        for (date in _progressObj){
            if (date > dateTime) continue;
            
            var rec = _progressObj[date];
            for (fld in rec){
                if (fld == field){
                    var record = rec[fld];
                    var val = record['val'];
                    if (val && (val.length > 0)){
                        obj.value = val;
                        var update = record['update'];
                        obj.isPast = (isSameDate(update, dateTime)) ? false : true;
                        return obj;
                    }
                }
            }
        }
        return obj;
    }
    
    return null;
}

function tagStrings(){
    // "tag:label,,," 型式のオブジェクトを返す
    var results = new Array();
    
    var array = layoutForMode(_basic_);
    for (num in array){
        var cell = array[num];
        results.push(cell.tag + ":" + cell.label);
    }
    
    var array = layoutForMode(_ins_);
    for (num in array){
        var cell = array[num];
        results.push(cell.tag + ":" + cell.label);
    }
    
    var array = layoutForMode(_progress_);
    for (num in array){
        var cell = array[num];
        results.push(cell.tag + ":" + cell.label);
    }
    
    //alert("tagStrings これで良いか？->"+results.join(",")); //##
    
    return results.join(",");
}


///////////////////////////////////////////////////////
///// 印刷 /////////////////////////////////////////////

function archived(answer){
    // カルテデータがアーカイブされた返事を受け取る
    //alert("archived->"+answer); //##
    hideMessage("_message");
    var msg = patientId()+" "+patientKanjiName()+" のカルテをバックアップしました";
    showFadeoutInfo("alertArea", msg, 1000);
    
    var printImage = 0;
    if (hasImage()){
        if (confirm("添付されている画像も印刷しますか？ （ Alpha channel を持たない画像は印刷できません。その場合はキャンセルを押せば画像なしで印刷されます）。")){
            printImage = 1;
        }
    }
    
	var url = "./printLog.php?patientId="+patientId()
	+ "&entryDate="+currentDate()
	+ "&age="+patientAge(currentDate())
	+ "&owner="+owner()
	+ "&printImage="+printImage
	+ "&isSmallFont="+pagePrintFontSize()
	+ "&isHalfPage="+pagePrintWidth()
	+ "&tags="+tagStrings();
    
	var win = window.open(url, "NOA_PDF", "scrollbars=yes");
	win.document.title = "PRINT"; // window title に "PRINT" 表示
	win.focus();
    
    function hasImage(){
        // このページが image 貼付されているかどうかを返す
        var obj = valueForTag("ProgressSection.object");
        var val = obj.value;
        _debug("val->"+val); //##
        
        return (val && (val.indexOf("<IMG:") >= 0)) ? true : false;
    }
}
function printPDF(){
	// カルテを印刷する
    closeInfoTip(); // 印刷の場合消えないことがるので
    
	if (isSameDate(currentDate(), today()) == 0){
		if (!confirm(currentDate() + " は本日のページではありませんが印刷しますか"))
			return;
	}
    
    // このカルテの全データをアーカイブし保存するようサーバへ依頼
	NRPutArchive(owner(), patientId(), archived);
}
function printPages(){
    // 指定された複数ページを印刷
    // ### TOOL AREA から呼ばれるので NOA に対し呼びかけをする必要あり ###
	var win = window.top.tools;
    //alert("== printPages->"+win); //##
    
    var fromDate = win.document.getElementById("fromDatePopup").value;
    var toDate = win.document.getElementById("toDatePopup").value;
    var noa = window.top.noa;
    
	var url = "./printAllPages.php?"
	+ "owner="+ noa.owner()
    + "&patientId=" + noa.patientId()
	+ "&patientKanjiName="+ noa.patientKanjiName()
	+ "&birthDate="+ noa.birthDate()
    + "&fromDate=" + fromDate
    + "&toDate=" + toDate;
    
	var win = window.open(url, "PRINT ALL PAGES", "scrollbars=yes");
	win.document.title = "PRINT ALL PAGES"; // window title に "PRINT" 表示
	win.focus();
}
function print_AllPages(history, currentDate){
	// このカルテの全ページを印刷する
    // ### print_AllPages() に tools.js から直接アクセスすると history() や currentDate()
    // ### が取得できない。noa() 経由で所得する必要あり。
	var win = window.top.tools;
	var elm = win.document.getElementById("base");
	elm.innerHTML = "";
    
    // === HEADER ===
    var div = newDIV(elm, ""); // 何故か CSS が働かない
    var div = newDIV(elm, "");
    div.style.backgroundColor = "#bfd"
    div.style.fontSize = "10pt";
    div.style.padding = "10px 10px 15px 10px";
    var dv = newDIV(div, "");
    dv.innerHTML = "カルテの指定範囲を印刷";
    dv.style.fontSize = "10pt";
    var dv = newDIV(div, "");
	var items = history;
    
	var item = items[items.length - 1];
	var pu = newPopupMenu(dv, "fromDatePopup", items, item);
    var sp = newSPAN(dv, "");
    sp.style.paddingLeft = "3px";
    sp.innerHTML = "から";
    
    var dv = newDIV(div, "");
	var pu = newPopupMenu(dv, "toDatePopup", items, currentDate);
    var sp = newSPAN(dv, "");
    sp.style.padding = "0px 3px";
    sp.innerHTML = "までのページを";
	var bt = newBUTTON(dv, "", "印刷");
    bt.setAttribute("onclick", "printPages()");
}

function archivedAllItems(answer){
    showFadeoutInfo("_debug", answer, 1000);
}
function print_AllPDF(){
	// 本日の全カルテを印刷する
    var noa = window.top.noa;
    var dateTime = noa.currentDate();

	if (isSameDate(dateTime, today()) == 0){
		if (!confirm(dateTime + " は本日のページではありませんが印刷しますか"))
			return;
	}
	
	var url = "./printLog.php?patientId="
	+ "&entryDate="+dateTime
	+ "&owner="+noa.owner()
	+ "&isSmallFont="+noa.pagePrintFontSize()
	+ "&isHalfPage="+noa.pagePrintWidth()
	+ "&tags="+noa.tagStrings();
    
	var win = window.open(url, "NOA_PDF", "scrollbars=yes");
	win.document.title = "PRINT"; // window title に "PRINT" 表示
	win.focus();
	
	// 当日の全患者のデータをアーカイブし保存するようサーバへ依頼
	showMessage("_message", "本日受診の全カルテをアーカイブします...[ 未完成 ]");
	NRPutAllArchive(noa.owner(), currentDate, archivedAllItems);
}


///////////////////////////////////////////////////////
///// ページ・スクロール /////////////////////////////////

function pageScrollTo(dateTime){
    // entryDate のページを画面上端にスクロール: calendar.js から呼ばれる
    var elm = document.getElementById(dateTime + ".name");
    var pos = getPosition(elm);
    
    // ページ・ヘッダーがきっかり画面の上端だと心理的にその上を見たい気持ちになるので
    // 80px ほどその上の部分も見えるようにする
    window.scroll(0, pos.y - 300);
    
    openPage(dateTime, true);
}

/*
function scrollEditor(dateTime, tag){
    // cellEditor を見える位置にスクロール
    var elm = document.getElementById(dateTime + ".page");
    var pos = getPosition(elm);
    // window.scroll(0, pos.y - 30);
}
 */

///////////////////////////////////////////////////////
///// 周辺ツールから外部参照されるオブジェクト //////////////

var _isReadOnly;
var _readOnlyDate;
function setIsReadOnly(status, date){
    // 書込不可の status を条件により設定
    var pageChanged = (isSameDate(date, _readOnlyDate) == false) ? true : false;
    if (date){
        // 日付が添えてあれば、日付を基に _isReadOnly を設定
        if (isSameDate(today(), date)){
            // date が本日なら無条件に readOnly を否定
            _isReadOnly = false;
        } else if (pageChanged){
            // 今まで開いていたエディターと異なる日付なら
            // 初心に戻り本日以外の日付はすべて readOnly とする
            _isReadOnly = (isSameDate(date, today())) ? false : true;
        } else {
            // すでに開いていたエディターと同じ日付なので readOnly の設定変更せず
            if (!_isReadOnly) _isReadOnly = status;
        }
        _readOnlyDate = date;
    } else {
        // 日付が添えてなければ status を基に _isReadOnly　を設定
        _isReadOnly = status;
    }
}
function isReadOnly(){
    // 編集可能かどうかを返す
    return _isReadOnly;
}
function getOnOff(answer){
    // onOffButton の status を受け取る
    var status = (answer * 1 > 0) ? false : true;
    setIsReadOnly(status);
}

function gotValueFromTool(val, touchAndGo){
    // 周辺ツールから値 val を受け取るための API
    //alert("== gotValueFromTool == "+val+"->"+touchAndGo); //##
    
    // 編集欄の内容を置換
    var elm = editorElementForTag(currentTag()); // tag に相当する 入力欄 エレメント
    elm.innerHTML = val;
    
    // 必要なら内容をサーバへ保存し Editor を閉じる
    if (touchAndGo){
        closeCellEditor('needSave');
        setCurrentTag(null); // closeCellEditor() でやるとタイミングによっては不整合発生
    }
}

function editor_ElementForTag(tag){
    // tag に相当する 入力欄 エレメントを返す
    // ReproductiveHistory から使われる
    var elm = document.getElementById(tag + ".value");
    if (elm)
        return elm;
    else
        return document.getElementById(tag + ".value");
}

///// 周辺ツールから外部参照されるオブジェクト //////////////
///////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////
///// kickMenuCell(url, inWindow, cliickedElement) から呼ばれる

function putValueForTag(val, tag){
    // currentDate(), tag の CELL のエディターを開いて val を書き込む
    //alert("putValueForTag->"+tag+"->"+val); //##
    
    // DocMaker から使われる
    if (currentTag()){
        var label = labelForTag(currentTag());
        alert("「" + label + "」欄を閉じて やり直してください");
    } else {
        openCellEditor(currentDate(), tag, val);
    }
}

function kickedWindow(answer){
    // NRKickWindow() のレシーバー
    var obj = JSON.parse(answer);
    
    //alert(obj.url+"->"+obj.arguments); //##
    
    var win = window.open(obj.url, obj.arguments);
    win.focus();
}

function openFRONT(){
    // FRONT を開く
	var array = new Array();
	array['owner'] = owner();
	array['hospitalId'] = hospitalId();
	array['hospitalName'] = hospitalName();
	var args = encodeObject(array);
	var href = "../FRONT/index.php?value="+encodeSTRING(args);
    
	var win = window.open(href, "FRONT", "_blank");
	win.focus();
}

function openTemplateMenu(){
    // テンプレート・メニューを開く
    var elm = clickedElement(); // クリックされたアイコン
    showGroupTemplatePanel(elm, null, "openTemplateHelp()");
}

function openInsViewer(pid, date){
    // InsViewer を開く
    var url = "../InsViewer?patientId=" + pid + "&currentDate=" + date;
    NRKickWindow(url, "_blank", kickedWindow);
}

function openImage(url){
    // 本文中の Image をクリックした時に呼ばれる
	var win = window.open("imageViewer.php?value=" + url, "ImageViewer"
                          ,"width=1700,height=1700,scrollbars=yes,resizable=yes");
	win.focus();
}

function getPrescription(value, touchAndGo){
	// 処方箋からデータを受け取る標準 API
    //_initDebug(true); //##
    //_debug("== getPrescription == "+value+"->"+touchAndGo); //##
    
	var type = medicalEncodeType(value); // lib.js
	if (type == "NOA"){
		// NOA 形式で受け取る場合 (prescription.js 側も対応の必要あり)
		var obj = decodeObject(value); // value は処方情報のみ
	} else if (type == "HL7"){
		// HL7 形式で受け取る場合 (prescription.js 側も対応の必要あり)
		var obj = HL7ToObject(value); // value は患者基本情報・保険情報・処方情報
	}
	
    var val = objectToShohouText(obj.prescription, obj.isOwn);
    
    _debug("--- val->"+val); //##
    
    // 編集エリアの内容を val へ置換
    gotValueFromTool(val, touchAndGo);
    
	function objectToShohouText(obj, isOwn){
		// object をこの電子カルテの処方表示フォーマットへ変換
        //_debug("-- objectToShohouText->"+encodeObject(obj)); //##
		var buff = "";
        if (isOwn) buff = "=== 自費処方 ===<br>";
		for (key in obj){
			var val = obj[key];
			if (typeof(val) == "object"){
				// グループの中を処理
				buff +=  objectToShohouText(val);
			}
			else {
                //_debug("-- obj->"+encodeObject(obj)); //##
                if (obj.generic && (obj.generic.length > 0))
                    _debug(obj.name+" ->"+obj.generic); //##
                
				// レコードの処理
				if (obj.code > 100) buff += "----- "; // 用法行の場合
				buff += obj.name + "(" + obj.dose + " " + obj.unit + ")";
                // generic 薬剤の場合は行末に以下のマークがつく
                // Vin.js はこれを基に generic 有無を判断する
                if (obj.generic && (obj.generic.length > 0)) buff += "　[般]";
                buff += "<br>";
				return buff;
			}
		}
		return buff;
	}
}
function openPrescriptionEditor(){
	// 処方箋ツールを開く
    // その受診日の 基本情報を 読込んだ後 doOpenPrescriptionEditor を実行
	window.open("../Prescription/prescription.php", "tools");
}

function openVinEditor(){
	// VIN：診療費計算ツールを開く
    window.open("vin.php", "tools");
}

function openForm(){
	// FORM 編集ペーンを開く
    // ### 処方箋ツールからデータ受信 API として gotValueFromTool() をインプリしておくこと
	window.open("form.php", "tools");
}

function openDisease(){
    // 病名記入ツールを開く
	window.open("../Disease", "tools");
}

function showWaitingListPanel(){
    // 待受パネルを別ウインドーで表示する
	window.open("./waitingPanel.php","waitingPanel"
				,"width=500,height=270,scrollbars=yes,dependent=yes");
}

///// kickMenuCell(url, inWindow, cliickedElement) から呼ばれる
/////////////////////////////////////////////////////////////////

