
/////////////////////////////////////////////
///// NOA からの継承値 /////////////////////////

function owner(){
    return parent().owner();
}

function cellText(){
    // CellEditor の入力部分を返す
    var tag = parent().currentTag();
    return parent().document.getElementById(tag + ".value");
}

function cellValue(){
    // 病名欄の内容を返す
    var obj = parent().valueForTag("ProgressSection.disease");
    
    return (obj) ? obj.value : "";
}

///// NOA からの継承値 /////////////////////////
/////////////////////////////////////////////

function clearValue(){
    // 編集内容を削除し前回受診時の記述が透けて見えるようにする
    parent().clearValue(parent().currentTag());
}

function gotSuffixMenu(answer){
    // サーバから接尾語リストを取得
    //alert("gotSuffixMenu->"+answer); //##
    var obj = JSON.parse(answer);
    setSuffixMenus(obj); // 接尾語メニューを記憶
	makeDiseseRow();
}
function gotPrefixMenu(answer){
    // サーバから接頭語リストを取得
    //alert("gotPrefixMenu->"+answer); //##
    var obj = JSON.parse(answer);
    setPrefixMenus(obj); // 接頭語メニューを記憶
    NRGetMenu(owner(), _suffix, gotSuffixMenu);
}
function gotDisesesMenu(answer){
    // サーバから病名リストを取得
    //alert("->"+answer); //##
    var obj = JSON.parse(answer);

    setMenus(obj); // メニューを記憶
    NRGetMenu(owner(), _prefix, gotPrefixMenu);
}

var _prefix = "接頭語";
var _suffix = "接尾語";

var _menus
var _menuObj
function setMenus(obj){
    _menus = [""];
    _menuObj = new Object();
    for (num in obj){
        var rec = obj[num];
        if (rec.menu.length){
            _menus.push(rec.menu);
            _menuObj[rec.menu] = rec.value;
        }
    }
    _menus.push("...その他");
}
function menus(){
    // 病名の配列を返す
    return _menus;
}
function setValueForMenu(val, menu){
    // menu に対応する val を記憶
    alert("setValueForMenu は使わないはず->"+menu+"->"+val); //##
    _menuObj[menu] = val;
}
function valueForMenu(menu){
    // menu に対応する value（ローマ字）を返す
    return _menuObj[menu];
}

var _prefixMenus
function setPrefixMenus(obj){
    //alert("setPrefixMenus->"+encodeObject(obj)); //##
    _prefixMenus = [""];
    for (num in obj){
        var rec = obj[num];
        if (rec.menu.length)
            _prefixMenus.push(rec.menu);
    }
    _prefixMenus.push("...その他");
}
function prefixMenus(){
    // 接頭語メニュー配列を返す
    return _prefixMenus;
}

var _suffixMenus
function setSuffixMenus(obj){
    //alert("setPrefixMenus->"+encodeObject(obj)); //##
    _suffixMenus = [""];
    for (num in obj){
        var rec = obj[num];
        if (rec.menu.length)
            _suffixMenus.push(rec.menu);
    }
    _suffixMenus.push("...その他");
}
function suffixMenus(){
    // 接尾語メニュー配列を返す
    return _suffixMenus;
}

var _diseases;
function setDiseases(buff){
    // buff を日付ごとのオブジェクトに展開して記憶
    _diseases = new Array();
    if (trim(buff).length == 0) return;
    
    var records = buff.split("<br>");
    for (num in records){
        var ln = trim(records[num]); // 開始日 病名 -- 終了日 転帰" 型式
        if (ln.length == 0) continue;
        
        var rec = new Object();
        var array = ln.split("--");
        
        // 開始日と病名
        var leftSide = trim(array[0]); // " -- " の余白を削除
        var cols = leftSide.split(" ");
        if (cols.length < 2){
            alert(leftSide + " には「開始日」か「病名」が欠けています");
            continue; // 開始日・病名 の両方がなければ無視
        }
        
        rec.start = cols[0]; // 開始日
        cols.shift(); // 開始日を削除
        rec.name = cols.join(" "); // 病名
        
        // 終了日と転帰
        rec.end = ""; // 終了日
        rec.conclusion = ""; // 転帰
        if (array.length > 1){
            var rightSide = trim(array[1]); // " -- " の余白を削除
            var cols = rightSide.split(" ");
            rec.end = cols[0]; // 終了日
            rec.conclusion = (cols.length > 1) ? cols[1] : ""; // 転帰
        }
        _diseases.push(rec);
    }
}
function diseases(){
    return _diseases;
}
function diseaseAt(row){
    // row 番目の病名オブジェクトを返す
    if (row < _diseases.length)
        return _diseases[row];
    else
        return null;
}

function diseasesToString(){
    // 病名オブジェクトを NOA 病名欄用の文字列にして返す
    var array = new Array();
    for (row in diseases()){
        var ary = new Array();

        // 一行分のエレメントから ary を生成
        var tr = elmFor(row + ".row");
        var nodes = tr.childNodes;
        for (cols in nodes){
            var txt = nodes[cols].innerText;
            if (cols == 3){ // 転帰
                var node = nodes[cols].childNodes[0];
                ary.push(node.value);
            } else if (cols == 2){ // 終了日
                if (txt.length) ary.push("--");
                ary.push(txt);
            } else {
                ary.push(txt);
            }
        }
        var ln = ary.join(" ");
        array.push(trim(ln));
    }
    //alert("array->"+encodeObject(array)); //##

    return array.join("<br>");
}
function addDisease(){
    // 新規病名行を追加
    var rec = new Object();
    rec.start = shortDate(today());
    rec.name = "";
    rec.end = "";
    rec.conclusion = "";
    _diseases.push(rec);
    
    // リスト内容を更新
    var row = _diseases.length - 1;
    makeDiseseRow();
    
    // 編集パネルが立ち上がる
    openEditor(null, row);
}
function removeDisease(num){
    // num 番目の病名オブジェクトを削除
    var rec = _diseases[num];
    _diseases.splice(num, 1);
    
    // リスト内容を更新
    makeDiseseRow();
}

function changedConclusion(elm, num){
    // 転記ポップアップが変更された
    // 転帰を更新
    _diseases[num].conclusion = elm.value;
    
    //_initDebug(true); //##
    _debug(num+"_diseases[num].conclusion->"+_diseases[num].conclusion); //##

    // 終了日を更新
    if (elm.value.length > 0)
        _diseases[num].end = shortDate(today(), false); // 本日の日付
    else
        _diseases[num].end = ""; // 転帰が無い場合
    elmFor(num+".end").innerText = _diseases[num].end;
}

function removed_disease(answer){
    //alert("removed_disease->"+answer); //##
    document.getElementById("workArea").innerHTML = "";
}
function remove_disease(menu){
    // 病名 menu を MenuTable から削除
    // removeDisease() はメモリー上だけの削除だが、こちらは DB から削除
    if (confirm(menu + " を削除していいですか")){
        var tag = "ProgressSection.disease";
        NRRemoveMenu(owner(), tag, menu, "", removed_disease);
    }
}

////////////////////////////////////////////////////////
///// DRAG and DROP ////////////////////////////////////

function f_dragstart(event){
    // ドラッグ開始時の処理
    // ドラッグするデータのid名をDataTransferオブジェクトにセット
    event.dataTransfer.setData("text", event.target.id);
}

function f_dragover(event){
    // ドラッグ要素がドロップ要素に重なっている間の処理
    //　dragoverイベントをキャンセルして、ドロップ先の要素がドロップを受け付けるようにする
    event.preventDefault();
}

function f_drop(event){
    // ドロップ時の処理
    // ドラッグされたデータのid名をDataTransferオブジェクトから取得
    var id_name = event.dataTransfer.getData("text");
    
    //id名からドラッグされた要素を取得
    var drag_elm = document.getElementById(id_name);
    
    //ドロップ先にドラッグされた要素を追加
    // event.currentTarget.appendChild(drag_elm);
    moveTo(id_name, event.currentTarget);
    
    //エラー回避のため、ドロップ処理の最後にdropイベントをキャンセルしておく
    event.preventDefault();
}
function moveTo(drop_id, target_node){
    // ドロップされたエレメントをドロップされたターゲット・エレメント位置へ移動
    var target_id = target_node.id;
    if (drop_id == target_node.id) return; // 自分自身は無視
    
    //_initDebug(true); //##
    _debug("moveTo->"+drop_id+"->"+target_id); //##
    
    var dropNum = numberOf(drop_id);
    var targetNum = numberOf(target_id);
    _debug(dropNum+"->"+targetNum); //##
    
    // ドロップするオブジェクトを抜かした配列を生成
    var dropRec;
    var anArray = new Array();
    var recs = diseases();
    for (num in recs){
        var rec = recs[num];
        if (num == dropNum){
            dropRec = rec; // ドロップすべきオブジェクトを記憶
            continue;
        }
        anArray.push(rec);
    }
    
    // ドロップすべきオブジェクトをドロップする位置に挿入した配列を生成
    var newRecords = new Array();
    for (num in anArray){
        var rec = anArray[num];
        if (num == targetNum)
            newRecords.push(dropRec);
        newRecords.push(rec);
    }
    if (targetNum >= anArray.length)
        newRecords.push(dropRec);
    
    // レイアウトの mode() に該当する部分だけを newRecords 要素と置換
    _diseases = newRecords;
    
    // レイアウトを再表示
    makeDiseseRow();
    
    function numberOf(id){
        // 2.name のような id から 2 だけを取り出して返す
        var array = id.split('.');
        
        return array[0] * 1;
    }
}

///// DRAG and DROP ////////////////////////////////////
////////////////////////////////////////////////////////

function modifiedDisase(name){
    // 病名をフィルターに通す
    var parts = name.split('$gw');
    if (parts.length > 1){
        var obj = parent().valueForTag("ProgressSection.subject");
        var val = (obj) ? obj.value : null;
        
        if (val){
            // 最終月経から現在の週数を計算
            var array = val.split("lmp:");
            if (array.length > 1){
                // "lmp:120825 (7w2d) ..." から "2012, 08, 25" を取り出し Date() 生成
                var ary = [];
                ary[0] = ("20" + trim(array[1]).substr(0, 2)) * 1; 
                ary[1] = trim(array[1]).substr(2, 2) * 1; 
                ary[2] = trim(array[1]).substr(4, 2) * 1; 
                var lmp = ary.join('-') + " 00:00:00";
                
                // currentDate() から Date() 生成
                var date = parent().currentDate();
                
                // 最終月経から本日までの週数を計算
                var sec = secondsBetween(lmp, date);
                var weeks = Math.floor(sec / (60 * 60 *24) / 7);
                
                //_initDebug(true); //##
                _debug("weeks->"+ weeks); //##
                
                name = parts.join(weeks);
                
                _debug("name->"+ name); //##
            }
        }
    }
    
    return name;
}

function makeRow(row){
    // リストの row 行を生成
    var rec = diseaseAt(row);
    var tr = elmFor(row + ".row");
    tr.innerHTML = "";
    // 開始年月日
    var td = newTD(tr, "/startDate", rec.start);
    // 病名
    var disease = modifiedDisase(rec.name); // 病名をフィルターに通す
    var td = newTD(tr, row+".name/name", disease);
    td.setAttribute("onclick", "openEditor(this,'" + row + "')");
    td.setAttribute("draggable", "true"); // HTML5: ドラッグ可能にする
    td.setAttribute("ondragstart", "f_dragstart(event)");
    td.setAttribute("ondragover", "f_dragover(event)");
    td.setAttribute("ondrop", "f_drop(event)");
    // 終了年月日
    var td = newTD(tr, row+".end/endDate", rec.end);
    // 転帰
    var td = newTD(tr, row + ".conclusionPopArea/conclusion", "");
    var array = ["","治癒","中止"];
    var pu = newPopupMenu(td, "conclusion", array, rec.conclusion);
    pu.setAttribute("onchange", "changedConclusion(this,'" + row +"')");
    // 削除アイコン
    var td = newTD(tr, "/mark", "");
    var img = newIMAGE(td, "", "./remove-field.png", "remove");
    img.style.height = "13px";
    img.setAttribute("onclick", "removeDisease('" + row + "')");
}

function makeDiseseRow(){
    // 病名リストを生成
	var elm = document.getElementById("editorArea");
    elm.innerHTML = "";
    var tbl = newTABLE(elm, "/base-table");
    tbl.style.fontSize = "9pt";
    
    // タイトル
    var tr = newTR(tbl, "disease_header", "");
    var td = newTD(tr, "editorTitle/", "開始日");
    var td = newTD(tr, "editorTitle", "病名");
    var td = newTD(tr, "editorTitle/endDate", "終了日");
    var td = newTD(tr, "editorTitle/conclusion", "転帰");
    var td = newTD(tr, "editorTitle/mark", "");
	var im = newIMAGE(td, "", "./help.png", "?");
	im.setAttribute("onclick", "diseaseHelp()");
	im.style.height = "16px";
	im.style.marginBottom = "2px";
	im.style.marginRight = "4px";
    
    // 病名リスト
    var array = diseases();
    for (row in array){
        // 一行分のエレメントを生成
        var tr = newTR(tbl, row + ".row", "");
        makeRow(row);
    }
    
    // 新規病名追加
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "", "");
    var td = newTD(tr, "/addField", "");
    td.setAttribute("onclick", "addDisease()");
	var im = newIMAGE(td, "", "./add-field.png", "?");
	im.style.height = "14px";
    var sp = newSPAN(td, "");
    sp.innerHTML = "病名を追加";
    sp.style.paddingLeft = "5px";
}

function ok(){
    // 病名記入ツールの編集内容を NOA へ書き戻す
    var status = diseaseTouchAndGo() ? true : false;
    
    parent().gotValueFromTool(diseasesToString(), status);
}

function closeEditor(){
    // 病名記入ツールを閉じ CELL を表示
    parent().closeCellEditor(); 
    parent().setCurrentTag(null);
}

function savedDisease(answer){
    var obj = JSON.parse(answer);
    alert("savedDisease->"+encodeObject(obj)); //##
}
function saveDisease(){
    // 病名記入ツールの編集内容をサーバへ書き戻す
    var value = diseasesToString();
    if (!value || (value.length == 0)) value = " ";
    
    // 編集内容をサーバへ保存
    var pid = parent().patientId();
    var dateTime = parent().currentDate();
    var timeLimit = parent().timeLimit();
    var tag = 'ProgressSection.disease';
    var container = new Object();
    container[tag] = value;
    NRPutPage(owner(), pid, dateTime, timeLimit, container, savedDisease);
        
    // 病名記入ツールを閉じ CELL を表示
    parent().setValueForTag(tag, dateTime, value);
    closeEditor();
}

////////////////////////////////////////////////////////////
///// 病名管理 //////////////////////////////////////////////

function saveMenu(){
    // メニュー構造をサーバへ保存
    var tag = "ProgressSection.disease";
    var freq = "";
    
    //_initDebug(true) //##
    
    for (menu in _changedMenu){
        var value = document.getElementById(menu + ".romaji").innerText;
        
        NRPutMenu(owner(), tag, menu, freq, value, NRNoAction);
    }
    _changedMenu = null; // 変更履歴を初期化
    initDisease();
}

function addNewMenu(){
    // 新規メニューを追加
    var name = prompt("新規病名を入力してください");
    if (name && name.length){
        _menuObj[name] = "";
    }
    document.getElementById("workArea").innerHTML = "";
    showMenuTable();
}

var _changedMenu;
function setEditable(elm, name){
    // 病名に対応する検索キーを編集可能にする
    elm.contentEditable = true; // TEXT を編集可能状態にする
    elm.focus();
    
    // 変更履歴に記憶：重複を避けるため Array ではなく Object を使う
    if (!_changedMenu) _changedMenu = new Object();
    _changedMenu[name] = "dummy";
}

function showMenuTable(){
    // 病名と検索キーの対象テーブルを表示
    var w = 500;
	var x = 5; // 表示するx座標
	var y = 5; // 表示するy座標
    var title = "病名管理：検索キー登録";
    var elm = openSeeThroughPanel("_floatPanel", x, y, w, title);
    if (!elm){
        alert("_floatPanel がないのでパネルを表示できません"); return;
    }
    elm.style.padding = "8px";

    var tbl = newTABLE(elm, "", "/base-table");
    tbl.style.fontSize = "9pt";
    tbl.style.width = "100%";
    
    // HEADER ==============================
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "/titleCol", "病名");
    td.style.width = "120px";
    var td = newTD(tr, "/titleCol", "検索キー（アルファベット）");
    td.style.width = "180px";
    var td = newTD(tr, "/titleCol", "");
    td.style.width = "15px";
	var im = newIMAGE(td, "", "./help.png", "?");
	im.setAttribute("onclick", "aliasHelp()");
	im.style.height = "16px";
    
    // CONTENTS ============================
    for (name in _menuObj){
        var romaji = _menuObj[name];
        var tr = newTR(tbl, "", "");
        var td = newTD(tr, name + ".disease", name);
        var td = newTD(tr, name + ".romaji", romaji);
        td.setAttribute("onclick", "setEditable(this,'" + name + "')");
        var td = newTD(tr, "/mark", "");
        var img = newIMAGE(td, "", "./remove-field.png", "remove");
        img.style.height = "13px";
        img.setAttribute("onclick", "remove_disease('" + name + "')");
    }
    
    // FOOTER ==============================
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "/addField", "");
    td.setAttribute("onclick", "addNewMenu()");
	var im = newIMAGE(td, "", "./add-field.png", "?");
	im.style.height = "14px";
    im.style.position = "relative";
    im.style.top = "3px";
    var sp = newSPAN(td, "");
    sp.innerHTML = "病名を追加";
    sp.style.paddingLeft = "5px";
    var td = newTD(tr, "", "");
    td.style.textAlign = "right";
    var bt = newDIV(td, "/fixButton");
    bt.innerHTML = "確定";
    bt.setAttribute("onclick", "saveMenu()");
}

///// 病名管理 //////////////////////////////////////////////
////////////////////////////////////////////////////////////


function diseaseHelp(){
	// 別途ヘルプをパネル表示
	window.open("./diseaseHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function aliasHelp(){
	// 検索キー登録ヘルプをパネル表示
	window.open("./aliasHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initDisease(){
    // 病名リストを表示するパネルを生成
    //_initDebug(true); //##
    _debug("== initDisease =="); //##
    
	var elm = document.getElementById("base");
    elm.innerHTML = "";
    
	// ===== 編集エリア ==================================
    var div = newDIV(elm, "editorArea");
    var sp = newSPAN(div, "");
    sp.innerHTML = "Loading ...";
    sp.style.padding = "15px";
    sp.style.color = "#f88";
    sp.style.fontSIze = "9pt";
    
    // === FOOTER =======================
    var div = newDIV(elm, "disease_footer/clearfix");
    // --- LEFT SIDE ---
    var dv = newDIV(div, "/left-side");
    dv.style.width = "180px";
    dv.style.position = "relative";
    dv.style.top = "3px";
    // CLEAR ICON
    var sp = newSPAN(dv, "clearFieldTip");
    setInfoTip("clearFieldTip", "前回記述が透けて見えるようにする"); // HELP
    var img = newIMAGE(sp, "", "./selection.png", "X");
    img.setAttribute("onclick", "clearValue()");
    img.setAttribute("class", "expandIcon");
    img.style.height = "15px";
    img.style.position = "relative";
    img.style.top = "3px";
    // チェックボックス
    var sp = newSPAN(dv, "diseaseToolCheck");
    sp.style.marginLeft = "10px";
    setInfoTip("diseaseToolCheck", "チェックをはずすと標準エディターで開くようになる"); // HELP
    var cb = newCHECKBOX(sp, "diseaseToolTip", "病名ツール", diseaseTool()); // localStorage.js
    cb.setAttribute("onchange", "setDiseaseTool(this)");
    // 病名管理 
    var sp = newSPAN(dv, "menuTableUnker");
    sp.style.marginLeft = "10px";
    setInfoTip("menuTableUnker", "病名管理ツールを開く"); // HELP
    var a = newA(sp, "病名管理", "#", "");
    a.setAttribute("onclick", "showMenuTable()");
    a.style.fontSize = "9pt";
    // --- RIGHT SIDE ---
    var dv = newDIV(div, "/right-side");
    // とりやめボタン
    var bt = newDIV(dv, "/whiteButton");
    bt.innerHTML = "とりやめ";
    bt.setAttribute("onclick", "closeEditor()");
    bt.style.fontSize = "9pt";
    // 確定ボタン
    var bt = newDIV(dv, "/fixButton");
    bt.innerHTML = "確定"; // "カルテへ";
    bt.setAttribute("onclick", "saveDisease()");
    bt.style.fontSize = "9pt";
    
    // VERSION =====================
    var div = newDIV(elm, "");
    var sp = newSPAN(div, "");
    sp.innerHTML = di_version();
    sp.style.fontSize = "9pt";
    sp.style.color = "#ccc";
    sp.style.marginLeft = "10px";
    
    // WORK AREA =====================
    var div = newDIV(elm, "workArea");

    var buff = cellValue(); // NOA の CellEditor の内容をサーバから得る
    buff = transferCR(buff); // 改行 "\n" を "<br>" に変換
    
    // NOA の病名欄を読込み、病名リストを表示
    //var buff = cellText().innerHTML; // NOA の CellEditor の内容
    //buff = decodeHTML(buff); // &nbsp; などを空白に戻す
    buff = trim(buff);
    setDiseases(buff);
    
    NRGetMenu(owner(), "ProgressSection.disease", gotDisesesMenu);
} 

function di_version(){
	return "Ver.131126";
}
