
/////////////////////////////////////////////
///// NOA からの継承値 /////////////////////////

// NOA 組込みの場合は patientId() などを直接取得できるが
// 外付けツールにも出来るようあえて以下の仕組みを使う

function _valueForTag(tag, dateTime){
    if (parent()){
        var obj = parent().valueForTag(tag, dateTime);
        return (obj) ? obj.value : "";
    } else {
        return "";
    }
}

///// NOA からの継承値 /////////////////////////
//////////////////////////////////////////////

function get_problems(){
    // problemList を生成
    var problems = new Array();
    
    var records = parent().noaStructure().ProgressSection;
    for (num in records){
        var rec = records[num];
        
        pickupProblems(rec, problems);
    }
    return problems;


    function pickupProblems(rec, problems){
        // subject 欄のデータから problem とその children を抽出し problems に追加し
        // subject 以外の欄から children を抽出し problems に追加
        var dateTime = rec.date; // 受診日
        var val = trim(rec.subject); // subject 欄データ
        if (trim(val).length){
            var array = val.split('\n');
            var objNumber = "";
            if (array.length >= 1){
                for (num in array){
                    var st = trim(array[num]); // subject 欄の各行
                    if (st.length == 0) continue;
                    
                    if (st.charAt(0) == '#'){ // # ではじまる行
                        var pos = st.indexOf(' ');
                        if (pos > 0){
                            objNumber = st.substr(0, pos);
                            
                            if (!problems[objNumber]){
                                var pobj = new Object();
                                pobj.number = objNumber;
                                pobj.problem = st.substr(pos);
                                problems[objNumber] = pobj; // プロブレム・オブジェクト
                            }
                        }
                    } else { // 行頭に # がない行
                        var pobj = problems[objNumber];
                        if (pobj){
                            if (! pobj.child) pobj.child = new Object();
                            if (! pobj.child[dateTime]) pobj.child[dateTime] = st;
                        }
                    }
                }
            }
        }
        // subject 欄以外の欄もスキャン
        problemsInAnotherSection(rec.object, problems);
        problemsInAnotherSection(rec.assessment, problems);
        
        
        function problemsInAnotherSection(val, problems){
            // subject 以外の欄の内容から problem の子コメントをピックアップ
            if (trim(val).length){
                // subject 以外の欄の内容から problem の子コメントをピックアップ
                var array = val.split('\n');
                var st = trim(array[0]); // 一行目のみを取り出す
                if (st.charAt(0) == '#'){ // # ではじまる行
                    var objNumber = "";
                    var pos = st.indexOf(' ');
                    if (pos > 0) objNumber = st.substr(0, pos);
                    var pobj = problems[objNumber];
                    if (pobj){
                        if (! pobj.child) pobj.child = new Object();
                        var ln = st.substr(pos);
                        if (! pobj.child[dateTime]) pobj.child[dateTime] = ln;
                    }
                }
            }
        }
    }
}

function getProblems(){
    // problemList を生成
    //_initDebug(true); //##
    
    var problems = new Array();
    var history = parent().history();
    //_debug("obj->"+encodeObject(obj)); //##

    for (num in history){
        var dateTime = history[num];
        var val = _valueForTag("ProgressSection.subject", dateTime);
        // val すなわち主訴欄の文字列データには '\n' と '<br>' が
        // 混在している可能性があるので、それらをすべて改行に変換しておく
        val = transferToCR(val);
        val = replaceAll(val, '<div>', '\n'); // <div> で改行されている場合がある
        
        _debug("=== "+dateTime+" val->"+val); //##
        
        // subject 欄の内容から problem をピックアップ
        var array = val.split('\n');
        
        var objNumber = "";
        if (array && (array.length >= 1)){
            for (num in array){ // subject 欄の各行をチェック
                var st = trim(array[num]); // subject 欄の各行
                st = htmlToPlain(st); // HTML タグがあればすべて外す
                if (trim(st).length == 0) continue;
                
                _debug(num+" --->"+st); //##
                
                if (st.charAt(0) == '#'){ // # ではじまる行
                    var pos = st.indexOf(' ');
                    if (pos > 0){
                        objNumber = st.substr(0, pos); // problem 番号
                        
                        if (!problems[objNumber]){
                            // problem オブジェクトに「番号」と「プロブレム」を記憶
                            var pobj = new Object();
                            pobj.number = objNumber;
                            pobj.problem = st.substr(pos);
                            
                            // 配列 problems に problem オブジェクトを格納
                            problems[objNumber] = pobj;
                            
                            _debug(objNumber+"=>"+pobj.problem); //##
                        }
                    }
                } else { // 行頭に # がない行
                    var pobj = problems[objNumber];
                    if (pobj){
                        // 親となるプロブレム行が存在するなら
                        if (! pobj.child) pobj.child = new Object();
                        
                        // プロブレム行のその日の子供がまだ存在しないなら
                        // 「その受診日の子供行」を「親」の下に記憶
                        if (! pobj.child[dateTime]){
                        //    st = htmlToPlain(st); // HTML タグがあればすべて外す
                            if (trim(st).length) pobj.child[dateTime] = st;
                            
                            _debug(objNumber+"-->"+st); //##
                        }
                    }
                }
            }
        }
    }

    // subject 以外の欄の内容から problem の子コメントをピックアップ
    var tags = new Array();
    tags.push("ProgressSection.object");
    tags.push("ProgressSection.accessment");
    tags.push("ProgressSection.plan");
    
    for (num in history){
        var dateTime = history[num];
        for (nm in tags){
            var tag = tags[nm];
            var val = _valueForTag(tag, dateTime);
            
            var array = val.split('\n');
            var st = trim(array[0]); // 一行目のみを取り出す
            if (st.charAt(0) == '#'){ // # ではじまる行
                var objNumber = "";
                var pos = st.indexOf(' ');
                if (pos > 0) objNumber = st.substr(0, pos);
                var pobj = problems[objNumber];
                if (pobj){
                    if (! pobj.child) pobj.child = new Object();
                    var ln = st.substr(pos);
                    if (! pobj.child[dateTime]) pobj.child[dateTime] = ln;
                }
            }
        }
    }

    return problems;
}

function foldChild(num){
    // num 番目の child を折畳む
    foldNode(num + ".child");
}

function pageScrollUp(date){
    // ページを画面上端にスクロール
    var array = parent().history();
    for (num in array){
        var entryDate = array[num];
        if (isSameDate(date, entryDate))
            parent().pageScrollTo(entryDate);
    }
}

function expandProblem(){
    // problemList を展開する
	var elm = document.getElementById("titleButtonArea");
    elm.innerHTML = "";

    var bt = newSPAN(elm, "/greenButton");
    bt.innerHTML = "PROBLEM LIST";
    bt.setAttribute("onclick", "foldProblem()");
    
	document.getElementById("contentsArea").style.display = "block"; // 表示
}
function foldProblem(){
    // problemList を折畳む
	var elm = document.getElementById("titleButtonArea");
    elm.innerHTML = "";

    var bt = newSPAN(elm, "/greenButton");
    bt.innerHTML = "PROBLEM LIST";
    bt.setAttribute("onclick", "expandProblem()");
    
	document.getElementById("contentsArea").style.display = "none"; // 非表示
}

function showProblemList(nodeId, expand){
	// problemList を作成し elm に表示
	var elm = document.getElementById(nodeId); 
	elm.innerHTML = "";
    
    showHeader(elm);
    
    // CONTENTS
    var div = newDIV(elm, "contentsArea");
    div.style.padding = "5px";
	var tbl = newTABLE(div, "/base-table");
    tbl.style.fontSize = "9pt";

    var inactives = new Array();
    var records = getProblems();
    
    for (num in records){
        var pobj = records[num];
        var tr = newTR(tbl, "/record", "");
        
        // NUMBER
        var td = newTD(tr, "", pobj.number);
        td.style.verticalAlign = "top";
        td.style.width = "20px";
        
        // PROBLEM
        var td = newTD(tr, "", "");
        var sp = newSPAN(td, "");
        sp.innerHTML = pobj.problem;
        sp.setAttribute("onclick", "foldChild('" + num + "')");
        
        if (pobj.child){
            // CHILD
            var tr = newTR(tbl, num + ".child", "");
            if (! isActiveProblem(pobj.problem)){
                // "(...)" でくくられた active でない node の id を配列に記憶
                inactives.push(num + ".child");
            }
            var td = newTD(tr, "", "");
            var td = newTD(tr, "", "");
            var tbl2 = newTABLE(td, "base-table");
            tbl2.style.fontSize = "9pt";
            
            for (date in pobj.child){
                var tr2 = newTR(tbl2, "", "");
                // DATE
                var td2 = newTD(tr2, "", shortDate(date));
                td2.style.width = "20px";
                td2.style.paddingRight = "5px";
                td2.style.verticalAlign = "top";
                
                // COMMENT
                var td2 = newTD(tr2, "", "");
                var val = pobj.child[date];
                
                // HTML タグが含まれる可能性があるので HTML を除去
                val = val.replace(/<\/?[^>]+>/gi, "");
                if (trim(val).length == 0) continue;
                
           //     alert("val("+val+")"); //##
                
                var a = newA(td2, val, "#", "");
                a.setAttribute("onclick", "pageScrollUp('" + date + "')");
            }
        }
    }

    // inactive なセルを折り畳む
    for (num in inactives){
        foldNode(inactives[num]);
    }
    
    if (expand){
        expandProblem(); // problemList を表示した後、矢印アイコンに action 設定
    }
    

	function isActiveProblem(problem){
		// #num (..) で括られた problem は表示対象外
		// $ln = "#4 problem" なら active
		// $ln = "#4 (problem)" なら inactive
		var begin = problem.indexOf(" ");
		var label = trim(problem.substr(begin + 1));
		if (label.charAt(0) == "("){
			if (label.charAt(label.length-1) == ")")
				return false;
		}
		return true;
	}
}

function problemListHelp(){
	window.open("./problemListHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function showHeader(elm){
    var div = newDIV(elm, "/tool-header");
    // --- LEFT SIDE ---
    var dv = newDIV(div, "/left-side");
    dv.style.paddingTop = "2px";
    var sp = newSPAN(dv, "titleButtonArea");
    sp.style.paddingLeft = "5px";
    
    sp.innerHTML = "PROBLEM LIST";

    // --- RIGHT SIDE ---
    var dv = newDIV(div, "/right-side");
    // HELP ICON
	var img = newIMAGE(dv, "", "./help.png", "?");
	img.style.height = "19px";
	img.setAttribute("onclick", "problemListHelp()");
    img.setAttribute("class", "expandIcon");
}

function initProblemList(){
    // Problem List を表示
    var elm = document.getElementById("base");
    elm.innerHTML = "";
    
    // panelEditor からも使えるよう node-id を指定して開けるようになっている
    // HEADER は showProblemList() の中で生成
    var div = newDIV(elm, "contents");
    showProblemList("contents");
    
    // FOOTER
    var div = newDIV(elm, "/tool-footer");
    var dv = newDIV(div, "/left-side");
    dv.style.position = "relative";
    dv.style.top = "3px";
    dv.style.height = "22px";
    dv.innerHTML = version();
}

function version(){
    return "Ver.131018";
}


