
/////////////////////////////////////////////
///// NOA からの継承値 /////////////////////////

// NOA 組込みの場合は patientId() などを直接取得できるが
// 外付けツールにも出来るようあえて以下の仕組みを使う

function _patientId(){
    return parent().patientId();
}

function _patientKanjiName(){
    return parent().patientName();
}

function _menuTemplate(){
    // neuron.js を直接呼びにいける状態なので menuTemplate() だとカブってしまう
    return parent().menuTemplate();
}

function _currentDate(){
    return parent().currentDate();
}

function _history(){
    return parent().history();
}

function test(){
    return parent().test();
}

///// NOA からの継承値 /////////////////////////
//////////////////////////////////////////////

//////////////////////////////////////////////
///// TOOL MENU から起動するツール //////////////

function printAllPages(){
	// このカルテの全ページを印刷する
    // ### dataCenter.js に printAllPages() を置いても history や currentDate
    // ### が tools.js からアクセスする形になりうまく取得できない：noa() 経由で取得の要あり
    print_AllPages(_history(), _currentDate());
}

function printAllPDF(){
	// 本日の全カルテを印刷する
    // ### dataCenter.js に printAllPages() を置いても currentDate などが
    // ### tools.js からアクセスする形になりうまく取得できない：noa() 経由で取得の要あり
    print_AllPDF();
}

function openMessenger(){
    // メッセンジャーを起動
    // ### tools.js から起動しないと patientId() などがうまく取得できない
    // ### NOA FRONT 両者に同様のものをインプリメントする
    //_initDebug(true); //##
    _debug("== openMessenger"); //##
    
    var obj = new Object();
    obj.sender = "";
    obj.sender = "@FRONT";
    obj.receiver = "@NOA";
    var st = "--- " + _patientId() + " " + _patientKanjiName() + "さん ---\n";
    obj.message = (_patientId()) ? st : "";
    obj.docId = "";
    obj.updateTime = todayAndTime();
    
    _debug("obj->"+encodeObject(obj)); //##

    showMessenger(obj);
}

///// TOOL MENU から起動するツール //////////////
//////////////////////////////////////////////

function showToolMenu(){
    // メニューを表示
    var elm = document.getElementById("menuArea");
    elm.innerHTML = "";
    
    var menuRow;
    var array = toolMenus();
    for (num in array){
        var cell = array[num];
        if (cell.menuType * 1 != _tool) continue;
        if (cell.disabled * 1) continue;
        
        _debug(cell.label+"->"+encodeObject(cell)); //##

        if (cell.subTitle * 1) {
            // グループ行とサブ・タイトルを生成
            // URL AREA
            menuRow = newDIV(elm, "/toolSection");
            var bt = newDIV(menuRow, cell.id);
            bt.innerHTML = cell.label;
            bt.style.float = "left";
            bt.setAttribute("class", "toolLabel");
        } else {
            // メニュー項目を生成
            if (cell.url){
                if (! isSuperUser()){ // dataCenter.js
                    // superUser でなければ実行できないメニューをスキップ
                    if (cell.url.indexOf("layout.php") >= 0) continue;
                }
                
                // url による action を伴う
                if (!menuRow){
                    menuRow = newDIV(elm, "/toolSection");
                    var bt = newDIV(menuRow, cell.id);
                    bt.innerHTML = cell.label;
                    bt.style.float = "left";
                    bt.setAttribute("class", "toolLabel");
                }
                
                // メニュー・ボタン
                var bt = newDIV(menuRow, cell.id);
                bt.innerHTML = cell.label;
                bt.setAttribute("class", "blueButton");
                var action = "kickMenuCell('"+cell.url+"','"+cell.window+"')";
                bt.setAttribute("onclick", action);
                bt.style.float = "left";
            } else {
                // label のみの表示
                var bt = newDIV(menuRow, cell.id);
                bt.innerHTML = cell.label;
                bt.setAttribute("class", "disabledButton");
                bt.innerHTML = cell.label;
            }
        }
    }
}

function toolMenutHelp(){
	window.open("./toolMenuHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function gotTools(answer){
    // TOOL MENU 構造をサーバから受取り記憶
    //_debug("gotTools->"+answer); //##
    var obj = JSON.parse(answer);
    setToolMenus(obj);
    
    showToolMenu();
}
function initTools(){
    //_initDebug(true); //##
    
    //　dataCenter の記憶を login.js と共有できないので localStorage を
    // 経由して hospitalTable のデータを受け取り dataCenter に記憶
	var elm = document.getElementById("base");
	elm.innerHTML = "";
    
    // === HEADER =======================
    var div = newDIV(elm, "/tool-header");
    div.style.height = "20px";
    // --- LEFT SIDE ---
    var dv = newDIV(div, "/left-side");
    var tl = newSPAN(dv, "");
    tl.innerHTML = "TOOL MENU";
    // --- RIGHT SIDE ---
    var dv = newDIV(div, "/right-side");
    // HELP ICON
	var img = newIMAGE(dv, "", "./Help.png", "?");
	img.style.height = "17px";
	img.setAttribute("onclick", "toolMenutHelp()");
    img.setAttribute("class", "expandIcon");
    dv.style.position = "relative";
    dv.style.marginTop = "2px";

    // === CONTENTS =====================
    var dv = newDIV(elm, "menuArea");

    // === FOOTER =======================
    var div = newDIV(elm, "/tool-footer");
    div.style.height = "20px";
    // --- LEFT SIDE ---
    var dv = newDIV(div, "/left-side");
    dv.style.width = "30px";
    // HAMMER ICON
    if (isSuperUser()){
        var img = newIMAGE(dv, "", "./hammer.png", "X");
        img.style.height = "14px";
        img.style.position = "relative";
        img.style.top = "2px";
        img.setAttribute("onclick", "openToolLayout()");
        img.setAttribute("class", "expandIcon");
    }
    // --- RIGHT SIDE ---
    var dv = newSPAN(div, "/right-side");
    dv.innerHTML = version();
    dv.style.position = "relative";
    dv.style.marginTop = "3px";
    
    NRGetToolMenu(owner(), gotTools);
}

function version(){
    return "Ver.130906";
}

