

function owner(){
    return document.getElementById("_owner").value;
}

function patientKanjiName(){
    return document.getElementById("_patientKanjiName").value;
}

function patientId(){
    return document.getElementById("_patientId").value;
}

var _currentDate;
function setCurrentDate(date){
    _currentDate = date;
}
function currentDate(){
    if (_currentDate)
        return _currentDate;
    else
        return document.getElementById("_currentDate").value;
}

var _insImagePath;
function setInsImagePath(st){
    _insImagePath = st;
}
function insImagePath(){
    return _insImagePath;
}
function insImageDate(){
    // '01107501_20130710110813_0.JPG' 型式を '2013-07-10 11:08:13' 型式に変換
    if (_insImagePath.length){
        var array = _insImagePath.split("_");
        
        if ((array.length > 1) && (array[1].length > 0)){
            datetime = array[1];
            var yyyy = datetime.substr(0, 4);
            var mm = datetime.substr(4, 2);
            var dd = datetime.substr(6, 2);
            var hour = datetime.substr(8, 2);
            var min = datetime.substr(10, 2);
            var sec = datetime.substr(12, 2);
            
            return yyyy+"-"+mm+"-"+dd+" "+hour+":"+min+":"+sec;
        } 
    } 
    return "";
}

function tagArray(){
    // 表示するタグの配列を返す
    var array = new Array();
   
    array.push("NameSection.patientKanjiName");
    array.push("NameSection.patientKanaName");
    array.push("AddressSection.address");
    array.push("AddressSection.phone");
    
    array.push("HealthInsurance.shubetsu");
    array.push("HealthInsurance.kubun");
    array.push("HealthInsurance.paymentRatio");
    array.push("HealthInsurance.kigou");
    array.push("HealthInsurance.bangou");
    array.push("HealthInsurance.ownerNumber");
    array.push("HealthInsurance.ownerName");
    
    array.push("ProgressSection.subject");
    array.push("ProgressSection.disease");
    array.push("ProgressSection.prescription");
    array.push("ProgressSection.treatment");
    array.push("ProgressSection.plan");

    return array;
}


///////////////////////////////////
/// localStorage による処理 /////////

function putWindowSize(){
	// DocMaker のウインドー位置とサイズを localStorage へ記憶
    var array = new Array();
	array.push(window.screenLeft); // x
	array.push(window.screenTop - 22); // y
	array.push(window.outerWidth); // w
	array.push(window.outerHeight); // h
    window.localStorage["viewerWindowSize"] = array.join(",");
    
    showFadeoutInfo("_debug", "window のサイズと位置を記憶しました", 800);
}
function getWindowSize(){
	// DocMaker のウインドー位置とサイズを localStorage から取り出す
    var windowStatus = window.localStorage["viewerWindowSize"];
    if (windowStatus){
        var array = windowStatus.split(",");
        var x = array[0];
        var y = array[1];
        var w = array[2];
        var h = array[3];
		// resize を先にしておかないと元が大きいサイズだった場合 moveTo しよう
		// としてもウインドー境界の制限で移動できない場合がある
		window.resizeTo(w, h);
		window.moveTo(x, y);
    }
}

/// localStorage による処理 /////////
///////////////////////////////////


function getInsImage(){
    // 保険証画像の path をリクエスト
    //putWindowSize();
    
    var url = "/NOA_ARCHIVE/" + patientId() + "/Insurance/" + insImagePath();
    
    NRKickWindow(url, "_blank", kickedWindow);
}

function showPage(dateTime){
    // コンテンツを表示
    _debug("== showPage ->"+dateTime); //##
    
	var elm = document.getElementById("base");
    elm.innerHTML = "";
    
    // HEADER ================================
    var div = newDIV(elm, "/tool-header");
    var dv = newDIV(div, "/viewerLabel");
    dv.innerHTML = patientId();
    var dv = newDIV(div, "/viewerValue");
    dv.innerHTML = patientKanjiName();

    // CONTENTS ==============================
    // ROW
    var div = newDIV(elm, "/viewerRow");
    // LABEL
    var dv = newDIV(div, "/viewerLabel");
    dv.innerHTML = "受診年月日";
    // VALUE
    var dv = newDIV(div, "/viewerValue");
    dv.innerHTML = currentDate();

    // tagArray の順序で表示
    var tarray = tagArray();
    for (num in tarray){
        var tag = tarray[num];
        if (tag == "pageStatus") continue; // pageHeader
        if (tag == "NameSection.patientKanjiName") continue;
        if (tag == "NameSection.patientKanaName") continue;
        
        var isInsrance = false;
        if (tag.indexOf("HealthInsurance") >= 0) isInsrance = true;
        if (tag.indexOf("PublicInsurance") >= 0) isInsrance = true;
        
        // ROW
        var div = newDIV(elm, "/viewerRow");
        if (isInsrance) div.style.backgroundColor = "#aec";

        // LABEL
        var dv = newDIV(div, "/viewerLabel");
        dv.innerHTML = labelForTag(tag);
        
        // VALUE
        var dv = newDIV(div, "/viewerValue");
        var obj = valueForTag(tag, dateTime);
        _debug(tag+"->"+dateTime+"->"+obj); //##
        _debug("obj->"+encodeObject(obj)); //##
        
        var val = (obj && obj.value) ? obj.value : "";
        _debug("val->"+val); //##
        
        dv.innerHTML = htmlForValue(val);
    }
    
    // FOOTER ================================
    var div = newDIV(elm, "/tool-footer");
    var dv = newDIV(div, "/left-side");
    dv.style.width = "300px";
    if (insImageDate().length > 0){
        var sp = newSPAN(dv, "");
        sp.innerHTML = "保険証画像 ";
        var sp = newSPAN(dv, "insImageDate/listMember");
        sp.innerHTML = insImageDate();
        sp.style.fontSize = "10pt";
        sp.setAttribute("onclick", "getInsImage()");
        setInfoTip("insImageDate", "保険証画像を開く"); // HELP
    }
    var dv = newDIV(div, "/right-side");
    dv.innerHTML = viewerVersion();
}

function gotInsScanDate(answer){
    // 保険証画像のスキャンされた日付を表示
    //alert("gotInsScanDate->"+answer); //##
    
    var obj = JSON.parse(answer);
    _debug("gotInsScanDate->"+encodeObject(obj)); //##
    
    // obj.files[0] は "02288001_20120412155531.JPG" 形式
    var fileNames = obj.files;
    var idAndDateTime = "";
    for (num in fileNames){
        idAndDateTime = fileNames[num];
        
        var array = idAndDateTime.split("_");
        if (array.length > 2) continue;
        
        // 最新の日付順になっているので最初のレコードを取得
        break;
    }
    _debug("idAndDateTime->"+idAndDateTime); //##
    
    setInsImagePath(idAndDateTime);
    
    showPage(currentDate());
}
function openBasicPage(answer){
    // 基本情報ページを開く
    var obj = JSON.parse(answer);
    setAddressObj(obj.addressSection);
    setBasicObj(obj.basicSection);
    setMaritalObj(obj.maritalSection);
    setHealthInsuranceObj(obj.healthInsurance);
    setPublicInsuranceObj(obj.publicInsurance);
    setUniversalObj(obj.universalSection);
    
    // 保険証画像のスキャンされた日付をリクエスト
    NRGetInsImage(patientId(), gotInsScanDate);
}
function openPages(answer){
    // サーバから得られた ProgressSection データで各ページを生成
    _debug("-- openPages --"); //##
    
    var obj = JSON.parse(answer);
    setPatientTable(obj.patientTable);
    setNameObj(obj.nameSection);
    setProgressObj(obj.progressSection);
    
    // currentDate() を FRONT からもらたものではなく NOA のものにする
    replaceCurrentDate();
    
    NRGetPage(owner(), patientId(), currentDate(), openBasicPage);
    
    function replaceCurrentDate(){
        // currentDate() を FRONT からもらたものではなく NOA のものにする
        var array = history();
        for (num in array){
            var date = array[num];
            if (isSameDate(date, currentDate())){
                setCurrentDate(date);
                break;
            }
        }
    }
}
function startuppedNOA(answer){
    // NOA 初期化に必要なパラメータを受け取る
    _debug("== startuppedNOA"); //##
    _debug("owner->"+owner()); //##
    _debug("patientId->"+patientId()); //##
    
    var obj = JSON.parse(answer);
    
//    setLayoutObj(obj.layout); // FRONT から使うなら FRONT にインプリ必要
    
    NRGetPages(owner(), patientId(), openPages);
}
function initViewer(){
    // FRONT から起動する電子カルテビューア
    //_initDebug(true); //##
    
    // 読込中のメッセージを示す
    var elm = document.getElementById("base");
    var sp = newSPAN(elm, "");
    sp.innerHTML = "サーバへ接続中 ...";
    sp.style.color = "#f00";
    sp.style.fontSize = "10pt";

    window.document.title = patientId();
    
    //getWindowSize();
    
 //   NRGetPages(owner(), patientId(), openPages);
    NRStartupNOA(owner(), startuppedNOA); // owner() -- localStorage.js
}

function viewerVersion(){
    // FRONT から NOA の概要を表示させるためのツール
    return "Ver.130826";
}