
var _infoList; // タグ分けされたデータオブジェクト
var _records; // サーバから返されたデータオブジェクト
var _fileBox;
function setInfoList(results){
    // サーバから得たデータオブジェクトのリストを元に infoSack 構造を生成
    _fileBox = results.fileBox;
    var obj = results.list;
    
    //_initDebug(true); //##
    _debug("setInfoList->"+encodeObject(obj)); //##
    
    if (results.group){
        var array = JSON.parse(results.group);
        setGroupObj(array);
    }
    
    _records = new Object();
    _infoList = new Object();
    for (fid in obj){
        var st = obj[fid]; // JSON が文字列のままで解凍されていない
        var rec = JSON.parse(st);
        _records[rec.id] = rec;
        
        // カテゴリーごとにデータを記憶
        var array = rec.group.split('^');
        for (num in array){
            var tag = array[num];
            if (! _infoList[tag]) _infoList[tag] = new Array();
            _infoList[tag].push(rec);
        }
    }
}
function infoList(){
    // データオブジェクトの塊を返す
    return _infoList;
}
function records(){
    // 全てのレコードを返す
    return _records;
}
function fileBox(){
    // サーバが画像を収納している path を返す
    return _fileBox;
}
function recordForId(fileId){
    // fileId に対応したデータオブジェクトを返す
    return _records[fileId];
}

function showPreference(){
    // 初期設定ペーンを開く
    if (editMode()){
        var elm = elmFor("workArea");
        elm.innerHTML = "";
        var div = newDIV(elm, "");
        div.style.padding = "5px 10px";
        div.style.fontSize = "10pt";
        
        var sp = newSPAN(div, "");
        sp.innerHTML = "初期画面";
        sp.style.marginRight = "5px";
        var cb = newCHECKBOX(div, "", "カテゴリーのみ表示", closeCategory());
        cb.setAttribute("onchange", "setCloseCategory(this)"); // localStorage.js
    } else {
        elmFor("workArea").innerHTML = "";
    }
}

function clickedLabel(filename){
    // データオブジェクトのラベルがクリックされた
    
    // filename から suffix を除去
    var pos = filename.lastIndexOf('.');
    var fileId = (pos > 0) ? filename.substr(0, pos) : filename; 
    var rec = recordForId(fileId);
    
    if (editMode()){
        // 編集パネルを開く
        openEditor(fileId);
    } else {
        var url = (rec.url) ? rec.url : fileBox() + "/"+ filename;
        
        window.open(url, "_blank");
    }
}

var _shrinked;
function shrink(aTag){
    // tag カテゴリーのデータオブジェクトを消滅 / 再現
    if (closeCategory()){ 
        // 初期画面カテゴリー収縮モード：カテゴリーのクリックで子供タグを展開
        var div = elmFor(aTag + ".children");
        if (div.style.display != "none")
            div.style.display = "none";
        else
            div.style.display = "inline";
    } else { 
        // 初期画面カテゴリー展開モード：カテゴリーのクリックで他のカテゴリー全てを消す
        _shrinked = (_shrinked) ? false : true;

        var groups = groupObj();
        for (num in groups){
            var tag = groups[num];
            if (tag == aTag) continue;
            
            var div = elmFor(tag + ".info");
            if (_shrinked)
                div.style.display = "none";
            else
                div.style.display = "inline";
        }
    }
}

var _editMode;
function changeMode(){
    // 編集モード / 閲覧モードを切り替える
    _editMode = (_editMode) ? false : true;

    initInfoSack();
}
function editMode(){
    // 編集モードなら true を返す
    return (_editMode) ? true : false;
}

function showInfoList(){
    // データオブジェクトを表示
    var elm = elmFor("contentsArea");
    elm.innerHTML = "";
    var obj = infoList();
    
    //_initDebug(true); //##
    _debug("infoList->"+encodeObject(obj)); //##
    _debug("groupObj->"+groupObj()); //##
    
    // groupMenu() の順序で表示
    var groups = groupObj();
    for (num in groups){
        var tag = groups[num];
        var row = newDIV(elm, "");
        var div = newDIV(row, tag + ".info");
        div.style.padding = "5px 0";
        var marked = false;
        if (tag == "お気に入り") marked = true;
        
        // サブ・タイトル
        var dv = newDIV(div, "/listMember");
        dv.innerText = tag;
        dv.setAttribute("onclick", "shrink('" + tag + "')");
        
        if (!obj) continue;
        
        // データオブジェクト
        var sp = newSPAN(div, tag + ".children");
        sp.style.display = (closeCategory()) ? "none" : "line";
        
        var array = obj[tag];
        for (num in array){
            var rec = array[num];
            var bt = newDIV(sp, "/blueButton");
            bt.innerText = rec.label;
            if (marked)
                bt.setAttribute("class", "yellowButton");
            var filename = rec.id + '.' + rec.suffix;
            bt.setAttribute("onclick", "clickedLabel('" + filename + "')");
        }
    }
    
    // カテゴリーのないものを表示
    var div = newDIV(row, "未分類.info");
    div.style.padding = "5px 0";
    // サブ・タイトル
    var dv = newDIV(div, "/listMember");
    dv.innerText = "未分類";
    dv.setAttribute("onclick", "shrink('未分類')");

    // データオブジェクト
    var sp = newSPAN(div, "未分類.children");
    sp.style.display = (closeCategory()) ? "none" : "line";
    
    var recs = records();
    for (fid in recs){
        var rec = recs[fid];
        if (rec.group.length == 0){
            var bt = newDIV(sp, "/blueButton");
            bt.innerText = rec.label;
            var filename = rec.id + '.' + rec.suffix;
            bt.setAttribute("onclick", "clickedLabel('" + filename + "')");
        }
    }
}

function gotInfoList(answer){
    // データオブジェクトのリストを受け取る
    var obj = JSON.parse(answer);
    //alert("gotInfoList->"+encodeObject(obj)); //##
    
    setInfoList(obj);
    showInfoList();
}

function showAddIcon(){
    // 追加アイコンを表示
    var div = elmFor("addIconArea");
    div.innerHTML = "";
    
    var sp = newSPAN(div, "/listMember");
    sp.style.padding = "0 15px";
    sp.setAttribute("onclick", "openEditor()");
    var im = newIMAGE(sp, "", "./add-field.png", "+");
    im.setAttribute("onclick", "add()");
    im.style.height = "12px";
    im.setAttribute("class", "expandIcon");
    im.style.position = "relative";
    im.style.top = "1px";
    var sp = newSPAN(sp, "");
    sp.innerHTML = "ファイルを追加";
    sp.style.paddingLeft = "3px";
}

function search(elm){
    // 検索を実行
    var key = elm.value;

    var w = 300;
	var x = 10; // 表示するx座標
	var y = 40; // 表示するy座標
    var elm = openSeeThroughPanel("_floatPanel",x,y,w,"検索結果");
    if (!elm){
        alert("_floatPanel がないのでパネルを表示できません"); 
        return;
    }
    
    var recs = records();
    for (fid in recs){
        var rec = recs[fid];
        if (rec.label.indexOf(key) >= 0){
            var div = newDIV(elm, "");
            div.style.paddingLeft = "5px";
            var bt = newDIV(div, "/yellowButton");
            bt.innerText = rec.label;
            var filename = rec.id + '.' + rec.suffix;
            bt.setAttribute("onclick", "clickedLabel('" + filename + "')");
        }
    }
    var div = newDIV(elm, "");
    div.style.height = "10px";
}

function help(){
	// ヘルプパネルを表示
    window.open("./help.html","Help"
                ,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initInfoSack(){
	var elm = document.getElementById("base");
    elm.innerHTML = "";
    
    // === HEADER ===============
    var div = newDIV(elm, "infoHeader");
    if (editMode()) 
        div.setAttribute("class", "yellow-header"); 
    else
        div.setAttribute("class", "tool-header"); 
    var dv = newDIV(div, "/left-side");
    dv.style.width = "150px";
    var sp = newSPAN(dv, "titleArea");
    sp.innerHTML = "InfoSack";
    var sp = newSPAN(dv, "controlArea");
    sp.style.paddingLeft = "30px";
    var dv = newDIV(div, "/right-side");
    // 検索フィールド
    var fd = newFIELD(dv, "searchF", "", 20, "");
    fd.setAttribute("onchange", "search(this)");
    fd.setAttribute("type", "search");
    fd.style.marginRight = "10px";
    fd.style.borderRadius = "10px";
    // HELP アイコン
	var im = newIMAGE(dv, "", "./help.png", "?");
	im.setAttribute("onclick", "help()");
	im.style.height = "18px";
    im.setAttribute("class", "expandIcon");
    
    // === CONTENTS ===============
    var div = newDIV(elm, "contentsArea");
    div.style.margin = "5px 0 0 10px";
    var div = newDIV(elm, "addIconArea");
    div.style.marginBottom = "3pt";
    // 追加アイコン
    if (editMode()) showAddIcon(); 

    // === FOOTER ===============
    var div = newDIV(elm, "infoFooter");
    if (editMode()) 
        div.setAttribute("class", "yellow-footer"); 
    else
        div.setAttribute("class", "tool-footer"); 
    var dv = newDIV(div, "/left-side");
    dv.style.width = "30%";
    var sp = newSPAN(dv, "");
	var im = newIMAGE(dv, "", "./hammer.png", "?");
	im.setAttribute("onclick", "changeMode()");
	im.style.height = "16px";
    im.setAttribute("class", "expandIcon");
    var dv = newDIV(div, "/right-side");
    dv.innerHTML = version();
    
    showPreference();

    GetInfoList(owner(), gotInfoList);
}

function version(){
    // Since 2013-11-18
    return "Ver.131121";
}