

/////////////////////////////////////////////////////
///// 基準値を判断するためのモジュール 
///// 色々な周辺ツールから利用できるようセンター化した
/////////////////////////////////////////////////////

var _standardList;
function setStandardList(obj){
    //alert("setStandardList->"+encodeObject(obj)); //##
    _standardList = obj;
}
function standardList(){
    /*
     収縮期血圧(owner(ohashi)value(80..120)unit(mmHg)menu(収縮期血圧))
     尿糖(owner(ohashi)value(-)unit()menu(尿糖))
     */
    return _standardList;
}
function standardForName(name){
    // 項目名に対応する基準値を返す
    var obj = _standardList[name];
    return (obj) ? obj : null;
}


/////////////////////////////////////////////////////
///// 基準値判断モジュール

function checkStandard(td, item, value){
    // item の value が基準値に合致するかチェック
//    alert("checkStandard->"+item+"->"+value); //##
    if (trim(value).length == 0) return;
    
    ary = value.split(" "); // 単位名をはずす
    var val = ary[0];
    var obj = standardForName(item);
    if (obj && obj.value){
        // item に相当する基準値があった
        td.style.backgroundColor = "#fff";                                
        var standard = obj.value;
        if (standard.indexOf("..") > 0){
            var ary = standard.split("..");
            var low = ary[0] * 1;
            var high = ary[1] * 1;
            if (low > val * 1){
                td.style.backgroundColor = "#ddf";                                
            } else if (high < val * 1){
                td.style.backgroundColor = "#fee";                                
            }
        } else if (standard.indexOf(",") > 0){
            var ary = standard.split(",");
            var matched = false;
            for (num in ary){
                var st = ary[num];
                if (st == val) matched = true;
            }
            if (!matched) td.style.backgroundColor = "#fee";
        } else if (standard){
            if (standard != val) td.style.backgroundColor = "#fee";
        }
    }
}

/////////////////////////////////////////////////////
///// 設定パネル

function saveStandardList(){
    // 基準値をサーバへ保存
    var item = elmFor("nameF").value; // 診療行為名
    var value = elmFor("standardF").value; // 病名
//    var unit = elmFor("unitF").value; // 病名
    
    if (trim(item).length == 0){
        alert("項目名が空です");
    } else {
        NRPutStandard(owner(), item, value, showStandardEditor);
    }
}
function removeStandard(name){
    // 項目名 name のレコードの削除をサーバへリクエスト
    var item = elmFor("nameF").value; // 診療行為名
    
    if (confirm(name + " を削除していいですか")){
        // value が null だと、サーバ側で削除と判断される
        NRPutStandard(owner(), item, null, showStandardEditor);
    } else {
        showStandardEditor();
    }
}

function openStandard(name){
    // 基準値入力パネルを開く
    var standard = "";
    var unit = "";
    if (name){
        var obj = standardForName(name);
        if (obj){
            standard = (obj.value) ? obj.value : "";
            unit = (obj.unit) ? obj.unit : "";
        }
    } else {
        name = "";
    }
    
    var elm = elmFor("standardTableArea");
    elm.innerHTML = "";
    var base = newDIV(elm, "editorNode");
    base.style.padding = "3px";
    base.style.backgroundColor = "#ffe";
    base.style.borderRadius = "8px";
    base.style.fontSize = "10pt";
    
    // 項目名入力フィールド
    var div = newDIV(base, "");
    var fd = newFIELD(div, "nameF", "項目名 ", 50, name);
    fd.setAttribute("placeholder", "例）収縮期血圧"); // 入力ヒント
    fd.focus();
    
    // 項目名入力フィールド
    var div = newDIV(base, "");
    var fd = newFIELD(div, "standardF", "基準値 ", 50, standard);
    fd.setAttribute("placeholder", "例）80..120"); // 入力ヒント
    
/*    // 単位名入力フィールド
    var div = newDIV(base, "");
    var fd = newFIELD(div, "unitF", "単位名 ", 50, unit);
    fd.setAttribute("placeholder", "例）mmHg"); // 入力ヒント
 */
    
    // 基準値の説明
    var div = newDIV(base, "");
    div.style.fontSize = "9pt";
    div.style.color = "brown";
    var dv = newDIV(div, ""); dv.style.paddingLeft = "10px";
    dv.innerText = "基準値の記述は以下のルールに従ってください";
    var dv = newDIV(div, ""); dv.style.paddingLeft = "20px";
    dv.innerText = "範囲指定：最低..最高（数値を２ドットで挟む）";
    var dv = newDIV(div, ""); dv.style.paddingLeft = "20px";
    dv.innerText = "単一指定：基準値（日本語可）";
    var dv = newDIV(div, ""); dv.style.paddingLeft = "20px";
    dv.innerText = "複数指定：基準値,基準値,基準値（カンマ区切）";

    // 項目名入力フィールド
    var div = newDIV(base, "");
    div.style.marginTop = "10px";
    div.style.marginBottom = "10px";
    div.style.textAlign = "right";
    var bt = newDIV(div, "/flatBUtton");
    bt.innerHTML = "とりやめ";
    bt.setAttribute("onclick", "openStandardCenter()");
    if (name){
        var bt = newDIV(div, "/fixBUtton");
        bt.innerHTML = "削除";
        bt.setAttribute("onclick", "removeStandard('" + name + "')");
    }
    var bt = newDIV(div, "/fixBUtton");
    bt.innerHTML = "確定";
    bt.setAttribute("onclick", "saveStandardList()");
}


function showStandardEditor(answer){
    // 基準値編集パネルを表示
    //_initDebug(true); //##
    _debug("showStandardEditor->"+answer); //##

    var obj = (answer) ? JSON.parse(answer) : standardList();
    if (!obj) obj = new Object();
    setStandardList(obj);
    
    //alert("showStandardEditor->"+encodeObject(obj)); //##
    
    var elm = elmFor("standardTableArea");
    elm.innerHTML = "";
    var tbl = newTABLE(elm, "", "");
    tbl.style.fontSize = "9pt";
    tbl.style.width = "100%";
    
    // HEADER ==============================
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "/yellow-label", "項目名");
    td.style.width = "30%";
    var td = newTD(tr, "/yellow-label", "基準値");
    
    // LIST ================================
    var recs = standardList();
    for (num in recs){
        var rec = recs[num];
        var tr = newTR(tbl, "", "");
        var td = newTD(tr, "/response-yellow-colum", rec.menu);
        td.setAttribute("onclick", "openStandard('" + rec.menu + "')");
        var td = newTD(tr, "", (rec.value) ? rec.value : "");
    }
    
    // FOOTER ==============================
    var tr = newTR(tbl, "", "");
    // 追加ボタン
    var td = newTD(tr, "/add-new-item", "");
    td.setAttribute("onclick", "openStandard()");
	var im = newIMAGE(td, "", "./add-field.png", "?");
	im.style.height = "14px";
	im.style.position = "relative";
	im.style.top = "3px";
    var sp = newSPAN(td, "");
    sp.innerHTML = "追加";
    sp.style.paddingLeft = "5px";
}

function standardHelp(){
	var win = window.open("./standardCenterHelp.html","Help"
						  ,"width=450,height=700,scrollbars=yes,resizable=yes");
	win.focus();
}

function openStandardCenter(){
    // 基準値編集パネルを開く
    var w = 300;
	var x = 15; // 表示するx座標
	var y = 30; // 表示するy座標
    var title = "基準値 設定パネル";
    var elm = openSeeThroughPanel("_floatPanel", x, y, w, title, "standardHelp()");
    if (!elm){
        alert("_floatPanel がないのでパネルを表示できません"); return;
    }
    elm.style.padding = "3px";
    var div = newDIV(elm, "standardTableArea");
    div.style.backgroundColor = "#fff";
    div.style.borderRadius = "5px";
    
    NRGetStandard(owner(), showStandardEditor);
}

