
///////////////////////////////////////////////
///// NOA へリクエストして得る値 //////////////////

var _agent;
function perinatalStartup(){
    // NOA から取得すべきパラメータすべてを一括取得
    _agent = agent();
    
    var elm = elmFor("patientInfoArea");
    elm.innerHTML = patientId() + " " + patientKanjiName();
    
    getWindowSize();
    getInvisibleColumns(); // 非表示カラム番号の配列を localStorage から読込む
    getParentRecords(); // NOA の値をサーバから読み込む
}

function patientId(){
	return _agent.patientId;
}

function patientKanjiName(){
	return _agent.patientKanjiName;
}

function owner(){
	return _agent.owner;
}

function currentDate(){
	return _agent.entryDate;
}

function hospitalId(){
	return _agent.hospitalId;
}

///// NOA へリクエストして得る値 ///////////////////
///////////////////////////////////////////////

var formLabel = "妊婦健診"; // 伝票名

var _rowObject;
function setRowObject(obj){
    _rowObject = obj;
}
function rowObject(){
	// 項目リストの受診日毎の値を入れたオブジェクト
    return _rowObject;
}

var _parentRecords;
function setParentRecs(obj){
    _parentRecords = obj;
}
function pregHistory(){
    // 妊娠履歴を返す
    var rec = _parentRecords["UniversalSection.pregnancyRecord"];

    return (rec && rec.value) ? rec.value : "";
}

function place(){
	// plan フィールドから分娩施設を返す
    var rec = _parentRecords["ProgressSection.plan"];
    var ln = (rec && rec.value) ? rec.value : "";
	var ary = ln.split("分娩予定施設(");
	if (ary.length > 1){
		var st = ary[1];
		for (var i=0,nest=0,len=st.length; i < len; i++){
			var ch = st.charAt(i);
			if (ch == ")")
				nest--;
			else if (ch == "(")
				nest++;
			if (nest < 0)
				return "分娩予定施設： " + st.substr(0, i);
		}
	}
	return "";
}

var _checkedList;
function initCheckedList(){
    // 既に実施した検査のリストを初期化
    _checkedList = new Array();
}
function addToCheckedList(name){
    // 既に実施した検査のリストに検査項目を追加
    var array = name.split(" ");
    for (num in array){
        // 空白で区切られた複数アイテムを個々に配列に記憶
        var item = array[num];
        if (item.length)
            _checkedList.push(item);
    }
}
function isAlreadtChecked(name){
    // name の検査がすでに実施されていれば true を返す
    for (num in _checkedList){
        //alert(name+"->"+_checkedList[num]+"->"+(name == _checkedList[num])); //##
        if (name == _checkedList[num]) return true;
    }
    return false;
}

var _lmp;
function lmp(){
	// subject フィールドから最終月経を返す
    var rec = _parentRecords["ProgressSection.subject"];
    var ln = (rec && rec.value) ? rec.value : "";
	var ary = ln.split("lmp:");
	if (ary.length > 1){
		var ary2 = ary[1].split("(");
		var st = trim(ary2[0]);		// "GS より 080712" 形式
		var lmp = st.substr(0, 6);	// "080712" 形式
		var yy = lmp.substr(0, 2);
		var mm = lmp.substr(2, 2);
		var dd = lmp.substr(4, 2);
		_lmp = "20" + yy + "-" + mm + "-" + dd;
	} else {
		alert("subject欄に lmp: が見つかりません");
		_lmp = "";
	}

	return _lmp;
}

function term(){
	// subject フィールドから分娩予定日を返す
    var rec = _parentRecords["ProgressSection.subject"];
    var ln = (rec && rec.value) ? rec.value : "";
	var ary = ln.split("Term:");
	if (ary.length > 1){
		var st = ary[1];
		if (st.length >= 10)
			return st.substr(0, 10);
	}
	return "";
}

///// parent から URI に添付して転送された値
///////////////////////////////////////////////

var _titles;
function setTitles(array){
	_titles = array;
}
function titles(){
	return _titles;
}

var _standard;
function setStandard(array){
	_standard = array;
}
function standard(){
	return _standard;
}

var _plotKey;
function setPlotKey(val){
	_plotKey = val;
}
function plotKey(){
	// "GS","BPD" などを返す
	return _plotKey;
}

function showValue(){
	// 値を示すチェックが入っているか否か
	return document.getElementById("showValueCB").checked;
}

/*
function createLabels(){
	var labels = new Array();
	var array = new Array("体重","体重",""); labels.push(array);
	var array = new Array("収縮期血圧","収血圧","140..0"); labels.push(array);
	var array = new Array("拡張期血圧","拡血圧","90..0"); labels.push(array);
	var array = new Array("尿蛋白","尿蛋白","-"); labels.push(array);
	var array = new Array("尿糖","尿糖","-"); labels.push(array);
	var array = new Array("浮腫","浮腫","-"); labels.push(array);
	var array = new Array("心拍","心拍","+"); labels.push(array);
	var array = new Array("GS","GS",""); labels.push(array);
	var array = new Array("BPD","BPD",""); labels.push(array);
	var array = new Array("CRL","CRL",""); labels.push(array);
	var array = new Array("FL","FL",""); labels.push(array);
	var array = new Array("EFW","EFW",""); labels.push(array);
	var array = new Array("胎盤位置","胎盤位置","正常"); labels.push(array);
	var array = new Array("心四腔","心四腔","四腔"); labels.push(array);
	var array = new Array("胎位","胎位","頭位"); labels.push(array);
	var array = new Array("胎児数","胎児数","1"); labels.push(array);
	var array = new Array("性別","性別",""); labels.push(array);
	var array = new Array("頸管長","頸管長",""); labels.push(array);
	var array = new Array("検査","検査","* popup *"); labels.push(array);
	var array = new Array("備考","メモ",""); labels.push(array);
	
	// ラベルごとの alias をタイトルとして記憶
	var array = new Array();
	for (var i=0,count=labels.length; i < count; i++){
		var ary = labels[i];
		var label = ary[0];
		var alias = ary[1];
		array[label] = alias;
	}
	setTitles(array);
	
	// ラベルごとの基準値を standard() として記憶する
	var array = new Array();
	for (var i=0,count=labels.length; i < count; i++){
		var ary = labels[i];
		var label = ary[0];
		var standard = ary[2];
		array[label] = standard;
	}
	setStandard(array);
}
 */

///////////////////////////
/// Ajax による処理 /////////

function gotParentRecords(answer){
    var obj = JSON.parse(answer);
    //alert("--- gotParentRecords->"+answer); //##
    _debug("obj->"+encodeObject(obj)); //##
    
    setParentRecs(obj);
    
    var elm = elmFor("argArea");
    elm.innerHTML = pregString();

    getValues(); // Ajax

    function pregString(){
        // 最終月経・予定日・妊娠履歴を返す
        var st = "";
        if (lmp().length > 0) st += "最終月経(" + lmp() + ")";
        if (term().length > 0) st += " 予定日(" + term() + ")";
        
        var preg = pregHistory();
        _debug("preg->"+preg); //##
        
        if (preg.length > 0){
            st += "<br>妊娠履歴：";
            // 改行して表示されるようにする
            var array = preg.split("\n");
            for (num in array){
                var ln = array[num];
                st += "<br>　" + ln;
            }
        }
        var ln = place();
        if (ln.length){
            st += "<br>" + ln;
        }
        return st;
    }
}
function getParentRecords(){
	// 最終月経・予定日・分娩予約・妊娠履歴 などをサーバへリクエスト
    //_initDebug(true); //##
    _debug("=== getParentRecords"); //##
    
    var array = [];
    array.push("UniversalSection.pregnancyRecord");
    array.push("ProgressSection.plan");
    array.push("ProgressSection.subject");
    var tags = array.join(',');
    
    var args = new Object();
    args.owner = owner();
    args.patientId = patientId();
    args.currentDate = currentDate();
    args.hospitalId = hospitalId();
    args.tags = tags; // "table.field,table.field,,," 型式
    NRCall("GET_VALUE_API", args, gotParentRecords);
}

function showHistory(answer){
    var obj = JSON.parse(answer);
    //alert("showHistory->"+encodeObject(obj)); //##
    
    setRowObject(obj);
    
    getForm();
    document.getElementById("message").innerHTML = "";
}
function getValues(key){
	// 項目リストの受診日毎の値をサーバへリクエスト
	if (patientId().length < 8){
		alert("カルテ番号を入力してください");
		return;
	}
    
    // ウインドーのサイズと位置を記憶
    if (key) putWindowSize();

	if (key){
		setPlotKey(key);
        var args = new Object();
		args["patientId"] = patientId();
        
        _callServer("GET_PERINATAL_HISTORY", "perinatalServer.php", args, kickPlotter);
	} else {
        var args = new Object();
		args["patientId"] = patientId();
        
        _callServer("GET_PERINATAL_HISTORY", "perinatalServer.php", args, showHistory);
    }
}

function gotForm(answer){
    //alert("gotForm->"+answer);//==
    if (answer && (answer.length > 0)){
        var array = JSON.parse(answer);
        //_debug("gotForm->"+encodeObject(array));//==
        for (num in array){
            var st = array[num];
            var obj = decodeObject(st);
            
            // オブジェクトでない st をスキップ
            if (!encodeObject(obj)) continue;
            
            //_debug("gotForm->"+encodeObject(obj)); //##
            
            // obj から最初（直近の日付）カラム情報を取得
            setColumns(obj);
            
            showPage();
            
            break; // array から最初のカラム情報を得られたのでループを抜ける
        }
    } else {
        alert("「" + formLabel + "」伝票が作成されていないため、データを表示できません。伝票の設定については、このあと表示される説明を参照してください");
        document.getElementById("message").innerHTML = "";
        window.open("./readMe.html","_blank");
    }
}
function getForm(){
    // "/USers/*user*/FORM/label/" の最新ファイルを読む
    var args = new Object();
    args["owner"] = owner();
    args["label"] = encodeSTRING(formLabel);
    
    _callServer("GET_FORM", "perinatalServer.php", args, gotForm);
}

/// Ajax による処理 /////////
///////////////////////////

///////////////////////////////////
/// localStorage による処理 /////////

function getWindowSize(){
	// DocMaker のウインドー位置とサイズをサーバへリクエスト
    var value = window.localStorage["PerinatalWindowSize"];
    if (!value){
        // window size が localStorage に記憶されていなければ記憶して終了
        //putWindowSize();
        return;
    }
    
    var args = value.split(",");
    var x = args[0];
    var y = args[1];
    var w = args[2];
    var h = args[3];
    // resize を先にしておかないと元が大きいサイズだった場合 moveTo しよう
    // としてもウインドー境界の制限で移動できない場合がある
    window.resizeTo(w, h);
    window.moveTo(x, y);
}
function putWindowSize(){
	// DocMaker のウインドー位置とサイズをサーバへ記憶
	var x = window.screenLeft;
	var y = window.screenTop - 22;
	var w = window.outerWidth;
	var h = window.outerHeight;
    var value = x + "," + y + "," + w+ "," + h;
    window.localStorage["PerinatalWindowSize"] = value;
    
    showFadeoutInfo("messageArea", "ウィンドー・サイズをブラウザーに記憶", 500);
}

function setShowValueCheckBox(elm){
    // 測定値表示チェックボックスの状態を記憶
    var status = (elm.checked) ? 1 :0;
    window.localStorage["showValueCheckBox"] = status;
}
function showValueCheckBox(){
    return (window.localStorage["showValueCheckBox"]) ? 1 : 0;
}

function setInvisibleColumns(array){
    // 非表示項目を記憶
    //_debug("setInvisibleColumns->"+array.join(",")); //##
    window.localStorage["invisibleColumns"] = array.join(",");
}
function getInvisibleColumns(){
    // 非表示項目のラベル番号配列を返す
    var st = window.localStorage["invisibleColumns"];
    _colTypes = new Object(); // st が空の場合に必要

    if (!st) return;
    
    var array = st.split(",");
    for (num in array){
        var colNum = array[num];
        if (colNum.length == 0) continue;
        
        setColTypes(1, colNum);
    }
}

/// localStorage による処理 /////////
///////////////////////////////////


///////////////////////////////
///// カラム属性 ////////////////

var _columns;
function setColumns(obj){
    // 各カラムのオブジェクトを生成
    //_initDebug(true); //##
    //_debug("gotForm->"+encodeObject(obj)); //##
    
    _columns = new Array();
    for (label in obj){
        var rec = obj[label];
        for (key in rec){
            var val = rec[key];
            // カラム・オブジェクトを生成
            //_debug(key+"->"+val); //##
            
            var colObj = new Object();
            colObj.label = key; // ラベル名
            if (val.length > 0){
                var ary = val.split("|");
                if (ary[1] && (ary[1].length > 0))
                    colObj.unit = (ary[1]); // 単位名
                if (ary[2] && (ary[2].length > 0))
                    colObj.standard = (ary[2]); // 基準値
            }
            _columns.push(colObj);
        }
    }
    _debug("setColumns->"+encodeObject(_columns)); //##
}
function columns(){
    return _columns;
}
function columsForInvisible(){
    // 非表示カラムの配列を返す
    var array = Array();
    for (num in _colTypes){
        var status = _colTypes[num];
        if (status == 1) array.push(num);
    }
    
    return array;
}

var _colTypes;
function setColStatus(elm, num){
    // num 番目のカラムの表示・非表示を設定：チェックボックスのクリックで起動
    var status = (elm.checked) ? 1 : 0;
    setColTypes(status, num);
}
function setColTypes(status, num){
    // num 番目のカラムの表示・非表示を設定
    if (!_colTypes) _colTypes = new Object();
    _colTypes[num] = status;
    
    //_debug("- setColTypes->"+num+"->"+status); //##
}
function isInvisible(number){
    // num 番目のカラムが非表示かどうかをチェック
    //_debug("isInvisible->"+number+"->"+_colTypes[number]); //##

    return (_colTypes[number]) ? _colTypes[number] : 0;
}

///// カラム属性 ////////////////
///////////////////////////////


///////////////////////////
/// 児推定体重 //////////////

function calc(){
	// EFW を計算
	//window.open("./weight.png","image","width=450,height=610,left=10,top=30");

	var bpd = document.getElementById("bpd").value;
	var aptd = document.getElementById("aptd").value;
	var ttd = document.getElementById("ttd").value;
	var fl = document.getElementById("fl").value;
	
	var st = "1.07 * "+bpd+"^3 + 3.42 * "+aptd+" * "+ttd+" * "+fl+" = ";
	document.getElementById("formula").innerHTML = st;
	
	var efw = Math.floor((1.07 * bpd*bpd*bpd + 3.42 * aptd * ttd * fl)/1000);
	document.getElementById("efw").value = efw;
	
	var comment = "推定体重は正常範囲";
	var obj = fatalWeightForWeek(gw());
	if (obj){
		var small = obj[0];
		var weight = obj[1];
		var large = obj[2];
		if (efw < small)
			comment = small + " gr に満たない";
		else if (large < efw)
			comment = large + " gr を越えている";
	}
	document.getElementById("comment").innerHTML = comment;
}

function showEFWCalc(){
    // 児推定体重計算パネルを開く
	var elm = document.getElementById("_floatPanel");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "");
	tbl.style.backgroundColor = "#ff0";
	
	// input
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "contents", "");
	var fd = newFIELD(td, "bpd", "BPD", 3, "");
	var fd = newFIELD(td, "aptd", " APTD", 3, "");
	var fd = newFIELD(td, "ttd", " TTD", 3, "");
	var fd = newFIELD(td, "fl", " FL", 3, "");
	fd.setAttribute("onchange", "calc()");
	var bt = newBUTTON(td, "", "計算");
	bt.setAttribute("onclick", "calc()");
   
	var tr = newTR(tbl, "", "");
    newHR(tr);
	
	// result
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "contents", "");
    td.style.textAlign = "right";
	var sp = newSPAN(td, "formula");
	var fd = newFIELD(td, "efw", " EFW", 8, "");
	var tx = newTEXT(td, "gr ");
    
	// comment
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "contents", "");
	var sp = newSPAN(td, "comment");
    
	openFloatPanel(tbl, 20, 120, "児推定体重計算");
}

/// 児推定体重 //////////////
///////////////////////////

function valueForLabelInArgs(args, label){
	// "label(value) .." 形式の文字列から label に該当する vallue を返す
	var ary = args.split(label + "(");
	if (ary.length > 1){
		var st = ary[1];
		var ary2 = st.split(")");
		return ary2[0];
	} else
		return "";
}

function showPage(){
	var tbl = document.getElementById("baseTable");
	tbl.innerHTML = "";
    
	// args() 中に最終月経がある場合は、その処理
	var showInterval = true; // 受診していない間隙も埋める
	var lmpSt = lmp();
    _debug("lmpSt->"+lmpSt); //##
    
	if (lmpSt.length >= 10){
		var st = lmpSt.substr(-10);
		var ary = st.split("-");
		var lmpDate = new Date(ary[0], ary[1] - 1, ary[2], 0, 0, 0);
		var lmpSec = lmpDate.getTime();
	} else
		showInterval = false;
    
	// タイトル
	var tr = newTR(tbl, "header", "");
	var td = newTD(tr, "", "受診日");
	var td = newTD(tr, "", "週数");
    var cols = columns();
    for (num in cols){
        if (isInvisible(num)) continue;
        
        var colObj = cols[num];
        if (colObj.label == "EFW"){
            var td = newTD(tr, "", "");
            var a = newA(td, colObj.label, "#", "");
            a.setAttribute("onclick", "showEFWCalc()");
        } else
            var td = newTD(tr, "", colObj.label);
    }
    
	var oldWeek = 0;
	// obj = {"2009-02-09 18:57:18":["val","val",,,],,,} 形式
    var records = rowObject(); // 項目リストの受診日毎の値を入れたオブジェクト
	for (timeStamp in records){ // 受診日ごとのデータを解析
        _debug(timeStamp+"->"+ln); //##
        
        var ln = records[timeStamp];
        if (!ln) continue; // 妊婦健診が行われていない日はスキップ
        
        var obj = decodeObject(ln); // "妊婦健診(BPD(..)体重(..),,, )"
        var rec = obj[formLabel]; // "BPD(..)体重(..),,, "
        if (!rec) continue; // 妊婦健診が行われていない日はスキップ
        
		var date = shortDate(timeStamp);
		var day = gestateDay(lmpSec, date);
		var week = Math.floor(day / 7);
        if (day < 0) continue; // 分娩終了後の妊娠履歴はスキップ

		if (showInterval){
			// 最終月経が記述されていない場合の処理
			var w = oldWeek - 1;
			while (week < w){
				if (w > 42){ w--; continue};
				var tr = newTR(tbl, "row", "");
				var td = newTD(tr, "datetime", "");
				var td = newTD(tr, "col", (w--) + "w" + 0 + "d");
                td.style.textAlign = "right";
				if (w <= 0) break; // w が０ 以下は表示不要
			}
        }
		if (day <= 0) break; // lmp より前は表示不要
		oldWeek = week;
		if (week > 42) continue;
		
        // 受診日ごとの値を表示
		var tr = newTR(tbl, "row", "");
		var td = newTD(tr, "datetime", date);
		var gd = (lmpSt.length >= 6) ? gd = week + "w" + day % 7 + "d" : "";
		var td = newTD(tr, "col", gd);
        td.style.textAlign = "right";
        for (num in cols){ // カラム毎にデータを埋める
            if (isInvisible(num)) continue;
            
            var colObj = cols[num];
            var label = colObj.label;
            var std = colObj.standard;
            var val = (rec[label]) ? rec[label] : "";
            // 各欄の値を表示
            var colId = (isNormal(val, std)) ? "col" : "abnormalCol";
            var td = newTD(tr, colId, val);
        }
    }
    

	function isNormal(st, standard){
		// st が基準値に該当するかどうかチェック
        if (!standard)
			return true;
        else if (st.length == 0)
			return true;
		else if (standard.length == 0)
			return true;
        
		var array = standard.split("..");
		if (array.length > 1){
			var min = array[0] * 1;
			var max = array[1] * 1;
            // st は "150 mmHg" 型式なので "150" のみとする
            var ary = st.split(" ");
            var val = ary[0] * 1;
            
			return ((max >= val) && (val >= min)) ? true : false;
		} else {
            st = trim(st);
            standard = trim(standard);
			return (isSame(st, standard)) ? true : false;
		}
	}
	
	function gestateDay(lmpSec, visitDate){
		// lmpSec, date から "8w0d" 形式で妊娠週数を返す
		var yy = 2000 + visitDate.substr(0, 2) * 1;
		var mm = visitDate.substr(2, 2) * 1;
		var dd = visitDate.substr(4, 2) * 1;
		var date = new Date(yy, mm - 1, dd, 0, 0, 0);
		var visitSec = date.getTime();
		var diffDay = (visitSec - lmpSec) / (1000*60*60*24);
		return diffDay;
	}
}

function help(html){
	window.open("./help.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initPerinatal(){
	// PerinatalManager の枠組みを生成
    //_initDebug(false); //##
    /*
    alert("initPerinatal->"+window.opener); //##
    alert("name->"+window.opener.top.noa); //##
    alert(window.opener.patientId()); //##
     */
/*
    if (!window.opener){
        // NOA から起動せず直接起動した場合は ReadMe を表示
        window.location.replace("./readMe.html");
        return;
    }
*/    
	var elm = document.getElementById("base");
    
	// 患者情報
    var div = newDIV(elm, "/clearfix");
    var dv = newDIV(div, "/left-side");
    dv.style.fontSize = "10pt";
    dv.style.paddingLeft = "0px";
    dv.style.width = "90%";
    var sp = newSPAN(dv, "patientInfoArea");
    sp.style.paddingRight = "10px";
    var sp = newSPAN(dv, "argArea");
    // HELP
    var dv = newDIV(div, "/right-side");
    dv.style.paddingRight = "8px";
    var img = newIMAGE(dv, "", "help.png", "Help");
    img.style.width = "20px";
    img.setAttribute("onclick","help()");
	
	// コンテンツ表示テーブル
	var tbl = newTABLE(elm, "baseTable/base-table");

	// フッター
	var tbl = newTABLE(elm, "/base-table");
    tbl.style.fontSize = "10pt";
	var tr = newTR(tbl, "footer", "");
	var td = newTD(tr, "colLeft", "");
	var cb = newCHECKBOX(td, "showValueCB", "測定値表示", showValueCheckBox());
    cb.setAttribute("onchange","setShowValueCheckBox(this)");
	var tx = newTEXT(td, " ");
	var a = newA(td, formLabel, "#", "");
	a.setAttribute("onclick", "getValues()");
	var tx = newTEXT(td, " ");
	var a = newA(td, "GS", "#", "");
	a.setAttribute("onclick", "getValues('GS')");
	var tx = newTEXT(td, " ");
	var a = newA(td, "BPD", "#", "");
	a.setAttribute("onclick", "getValues('BPD')");
	var tx = newTEXT(td, " ");
	var a = newA(td, "CRL", "#", "");
	a.setAttribute("onclick", "getValues('CRL')");
	var tx = newTEXT(td, " ");
	var a = newA(td, "EFW", "#", "");
	a.setAttribute("onclick", "getValues('EFW')");
    // version 表示
	var td = newTD(tr, "colRight", version());
    var sp = newSPAN(td, "iconArea");
    sp.style.marginLeft = "10px";
    var img = newIMAGE(sp, "icon", "./gear.png", "option");
	img.setAttribute("onclick", "openPreference()");
    img.style.width = "16px";
    img.style.position = "relative";
    img.style.top = "2px";

    // コメント・エリア
	var div = newDIV(elm, ""); 
    div.innerHTML = "* 最新のものから過去への順で表示しています ";
    div.style.paddingTop = "5px";
    div.style.color = "#888";
    div.style.fontSize = "10pt";

	// メッセージエリア
	var div = newDIV(elm, "message"); // loading message
    div.style.fontSize = "9pt";
    
    // window サイズ記憶メッセージ
	var div = newDIV(elm, "messageArea");
    div.style.fontSize = "9pt";
	
	// 指定されたフィールドの受診日毎のデータを取得
    perinatalStartup();
}

function version(){
	return "Ver.140606";
}

