
var _records;
function setGroupRecords(objct){
    // レコード数が１００を超えるほどになると処理がコケるので
    // なるべく軽くするためオブジェクト形式を配列形式に変換
    _records = objct;
}
function groupRecords(){
	return _records;
}

///////////////////////////
/// Ajax による処理 /////////

function gotTable(answer){
    //alert("gotTable->"+answer); //##
    var obj = JSON.parse(answer);
    obj = pureRecords(obj); // $row の数値添字を取り除く
    setGroupRecords(obj);
    showRecords();
    showMessageBar("");
	
	function pureRecords(objects){
		// $row の数値添字を取り除く
		var recs = new Array();
		for (var i=0,ct=objects.length; i < ct; i++){
			var obj = objects[i];
			var array = new Array();
			for (key in obj){
				if (! isDigit(key)) array[key] = obj[key];
			}
			recs.push(array);
		}
		return recs;
	}
}
function getTable(owner, table, order){
	// table の内容をサーバへリクエスト
    var args = new Object();
    args['owner'] = owner;
    args['table'] = table;
    args['order'] = order;
        
    _callServer("GET_TABLE_SOURCE", "sysServer.php", args, gotTable);
}

function gotArchiveGroup(answer){
    //alert("gotArchiveGroup->"+answer); //##
    var obj = decodeObject(answer);
    _debug("<p>obj->"+encodeObject(obj)+"</p>"); //##
    
    setGroupRecords(obj);
    showRecords();
}
function getArchive(filename){
	// 選択されたユーザのバックアップ・データをサーバへリクエスト
    var args = new Object();
    args['owner'] = document.getElementById("userPopup").value;
    args['tableType'] = "GROUP";
    args['filename'] = filename;
        
    _callServer("GET_ARCHIVE", "sysServer.php", args, gotArchiveGroup);
}

function putArchiveGroupDone(answer){
    alert(answer); //##
}
function putArchive(filename){
	// データ・ソースを文字列ファイルとして保存
    var recs = groupRecords();
    if (! recs){
        alert("データ・ソースが読み込まれていません");
        return;
    }
    
    var array = new Array();
    for (i in recs){
        var obj = recs[i];
        array.push(obj);
    }
    
    var args = new Object();
    args['owner'] = document.getElementById("userPopup2").value;
    args['folder'] = "GROUP_MENU";
    args['filename'] = filename;
    args['value'] = encodeObject(array);
    
    _postServer("PUT_ARCHIVE_FILE", "postServer.php", args, putArchiveGroupDone);
}

function loadedBackupedArchive(answer){
    //alert("loadedBackupedArchive ===\n"+answer);//##
    if (answer && (answer.length > 0)){
        var obj = JSON.parse(answer);
        
        // バックアップファイルのポップアップを表示
        if (obj.length) 
            showBackupSelector(obj);
        else 
            alert("バックアップはありません");
    }
}
function loadBackupedArchive(){
    // バックアップ・ファイル名リストをリクエスト
    var args = new Object();
    args['owner'] = document.getElementById("userPopup").value;
    args['folder'] = "GROUP_MENU";
    
    //alert("GET_ARCHIVED_LIST"); //##
    
    _callServer("GET_ARCHIVED_LIST", "sysServer.php", args, loadedBackupedArchive);
}

function replacedGroupTable(answer){
    //alert("replacedGroupTable ===\n"+answer);//##
    mergeCycle();
}
function replaceGroupTable(){
	// DB の FieldTable を空にしてからデータソースを書込む
    var args = new Object();
    args['owner'] = document.getElementById("userPopup2").value;
    args['table'] = "ProgressSection";
    args['patientId'] = "GroupMenu";
    
    _callServer("CLEAR_TABLE", "sysServer.php", args, replacedGroupTable);
}

function mergedWithGroup(answer){
	// 各テーブルの存在がチェックされた
    if (answer && (answer.length > 0)){
        //showMessage("_message", answer);
        elmFor("messageArea").innerHTML = answer;
    } 
    mergeCycle();
}
function mergeWithGroup(obj){
	// データ・ソースを DB とマージ
    var args = new Object();
    obj.owner = document.getElementById("userPopup2").value;
    args["owner"] = obj.owner;
    
    _callServer("MERGE_GROUP", "sysServer.php", obj, mergedWithGroup);
}

/// Ajax による処理 /////////
///////////////////////////



function showBackupSelector(filenames){
    // バックアップ・ファイルのリストを選択してファイルをロード
    var items = new Array();
    for (num in filenames){
        var name = filenames[num];
        if (name.charAt(0) == '.') continue;
        items.push(name);
    }
    var elm = document.getElementById("fileNamesArea");
    elm.innerHTML = "";
    var pu = newPopupMenu(elm, "filePop", items, "");
    
    // removeButtonArea の操作：バックアップファイルの削除ボタン
    var elm = document.getElementById("removeButtonArea");
    elm.innerHTML = " ";
    var bt = newBUTTON(elm, "", "サーバから削除");
    bt.setAttribute("onclick", "removeBackupFile('GROUP')");
}

function load(){
	// ユーザポップアップとソースポップアップに応じたデータを読込む
    var logname = document.getElementById("userPopup").value;
	var src = document.getElementById("sourcePopup").value;

    if (src == "テンプレート"){
        // バックアップデータを表示
        var filename = "./GROUP.txt";
        showController("テンプレート ( " + filename + " ) ");
        
        getArchive(filename);
    } else if (src == "バックアップ"){
        // 過去ログからピックアップ
        //alert("load->"+logname+"->"+src); //##
        
        var filename = document.getElementById("filePop").value;
        //alert("load->"+filename); //##
        showController(logname + " 用バックアップ ( " + filename + " ) ");
        
        getArchive(filename);
    } else if (src == "データベース"){
        showController(logname + " 用データベース ");
        
		var tableName = "ProgressSection";
		var order = "`subject`";
        getTable(logname, tableName, order);
    }
}

var _num;
function mergeCycle(){
	// Ajax で DB との間でリカーシブルに merge を行う
	var array = groupRecords();
    
    // どういう訳か array.length が undefined になるので、以下の方法で array の数を取得
    var count = 0;
    for (num in array) count++;
    
	if (_num < count){
		var obj = array[_num++];
        mergeWithGroup(obj);
	} else {
        hideMessage("_message");
        
        // DB 内容を再表示
        var logname = document.getElementById("userPopup").value;
		var tableName = "ProgressSection";
		var order = "`subject`";
        getTable(logname, tableName, order);
        
        elmFor("messageArea").innerHTML = "";
		alert("データへの書込み終了しました");
    }
}

function save(){
	// ユーザポップアップとソースポップアップに応じたデータを書込む
    //if (debugMode()) _initDebug(true); else _initDebug(false); //##
    
	var src = document.getElementById("sourcePopup2").value;
	if (src == "バックアップ"){
		putArchive("GROUP");
	} else if (src == "テンプレート"){
		putArchive("./GROUP.txt");
	} else if (src == "データベース"){
		var elm = document.getElementById("isOverWrite");
        var st = (elm.checked)
        ? "ここに表示されたデータによって完全に置換されます"
        : "ここに表示されたデータとマージされます。すでに同じ tag, menu を持つレコードは置換されません。差分のみが追加されます。";
        
        //_initDebug(false); //##
		
		if (confirm("データベースは、" + st)){
			// データ・ソースを DB とマージ
			//showMergeLog(); // マージのログを表示するエリアを用意
			_num = 0; // _num を 0 にセットしてから mergeCycle() を廻す
			if (elm && elm.checked)
				replaceGroupTable();
			else
				mergeCycle();
		}
	}
}

function removeCheckedRecords(){
	// チェックされたレコードをすべて削除
	var array = new Array();
	var recs = groupRecords();
    for (i in recs){
		var elm = document.getElementById("cb."+i);
		if (! elm.checked)
			array.push(recs[i]); // チェックの入らないものだけをピックアップ
	}
	setGroupRecords(array);
    showRecords();
}

function removeRecord(row){
	// row 行レコードを削除
	var array = groupRecords();
	var obj = array[row];
	if (confirm(obj.subject + " を削除していいですか")){
		// array.splice(row, 1) ではどういう訳かエラーになるので以下を実行
        var newArray = new Array();
        for (num in array){
            if (num != row) newArray.push(array[num]);
        }
        setFieldRecords(newArray);
        showRecords();
/*		
		setEditorId("");
		var elm = document.getElementById("directEdit");
		if (elm && elm.checked){
			// 直接データベースの obj を削除
            //if (debugMode()) _initDebug(true); else _initDebug(false); //##
			removeGroupTable(obj);
		} else
			showRecords();
 */
	}
}

function changeRecord(row){
	// row 行レコードを変更
    //_initDebug(true); //##

	var obj = new Object();
	obj.subject = document.getElementById("subject").value;
	obj.object = document.getElementById("object").value;
	obj.examination = document.getElementById("examination").value;
	obj.prescription = document.getElementById("prescription").value;
	obj.disease = document.getElementById("disease").value;
	obj.treatment = document.getElementById("treatment").value;
	obj.assessment = document.getElementById("assessment").value;
	obj.plan = document.getElementById("plan").value;
	obj.freq = document.getElementById("freq").value;
    
    _debug("changeRecord->"+encodeObject(obj)+"<br>"); //##
    
    // 新規レコードの場合もあるので obj は新たに起こしたものを使う
    groupRecords()[row] = obj;

	setEditorId("");
    showRecords();
/*	var elm = document.getElementById("directEdit");
    
	if (elm && elm.checked){
		// 直接データベースの obj を更新
        _debug("check->"+elm.checked); //##
        putGroupTable(obj);
	} else {
		showRecords();
	}*/
}

function showNewEditor(){
	// 新規レコード作成エディターを開く
	// ## 新規レコードボタンに showEditor(row) を action として設定しても
	// ## その時点では row が決まっていない可能性があるため、この機能を独立させる
	var row = groupRecords().length;
    openEditor(row);
}

function openEditor(row){
	// row 行レコードの編集パネルを開く
	var obj = groupRecords()[row];
	if (!obj){
		obj = new Object();
		obj.subject = "新規レコード";
        // obj は「変更」ボタンが押されてから groupRecords に追加される
	}
	
	// 以前開いていたエディターあれば閉じる
	var old_eid = editorId();
	var isClosed = closeEditor();
	
	// 目的エディターが今閉じたエディターなら、閉じただけで終了
	var eid = editorIdForRow(row);
	
	if (isClosed && (eid == old_eid)) return;
	
	// エディターを開く領域を記憶
	setEditorId(eid);
    
    //if (debugMode()) alert(encodeObject(obj)); //##

    // レコード編集ペーンを表示
	var elm = document.getElementById(eid);
	elm.innerHTML = "";
	
    // Editor が見えないことがあるので該当位置へスクロールしておく
    var pos = getPosition(elm);
	window.scroll(0, pos.y - 30);
    
    var div = newDIV(elm, "");
    div.style.padding = "10px 10px";
    div.style.border = "thin solid #aaa";
    div.style.backgroundColor = "#ffc";
	div.style.marginBottom = "10px";
    
	var tbl = newTABLE(div, "subTable");
	tbl.style.textAlign = "left";
	tbl.style.fontSize = "10pt";
	
	// title
	var tr = newTR(tbl, "editor_title", "");
	var td = newTD(tr, "", "");
	td.setAttribute("colspan", "2");
	var img = newIMAGE(td, "icon", "./close.png", "close");
	img.setAttribute("onclick", "closeEditor()");
	var tx = newTEXT(td, "　" + obj.subject + " を編集");
	
	// contents
	makeTextField(tbl, "subject", obj);
	makeTextField(tbl, "object", obj);
	makeTextField(tbl, "examination", obj);
	makeTextField(tbl, "prescription", obj);
	makeTextField(tbl, "disease", obj);
	makeTextField(tbl, "treatment", obj);
	makeTextField(tbl, "assessment", obj);
	makeTextField(tbl, "plan", obj);
	makeField(tbl, "freq", obj, true);
	makeField(tbl, "owner", obj, false);
	makeField(tbl, "entryDate", obj, false);
	makeField(tbl, "updateTime", obj, false);
	
	// comment
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	var td = newTD(tr, "comment", "編集内容はバックアップやデータベースに書込まない限り保存されません ");
    td.style.color = "#a63"; // brown
	
	// footer
	var tr = newTR(tbl, "editor_title", "");
	var td = newTD(tr, "controller", "");
	td.setAttribute("colspan", "2");
	td.style.textAlign = "right";
	var dataSource = document.getElementById("sourcePopup").value;
/*	if (dataSource == "データベース"){
        var owner = document.getElementById("userPopup").value;
		var cb=newCHECKBOX(td,"directEdit",owner + " のデータベースを直接編集 ",false);
	}*/
	var bt = newBUTTON(td, "", "削除");
	var action = "removeRecord('" + row + "')";
	bt.setAttribute("onclick", action);
	var bt = newBUTTON(td, "", "変更");
	var action = "changeRecord('" + row + "')";
	bt.setAttribute("onclick", action);
    

	function makeTextField(tbl, key, obj){
		var tr = newTR(tbl, "", "");
		var td = newTD(tr, "", key);
        td.style.paddingRight = "10px";
        
		var td = newTD(tr, "", "");
		var val = (obj[key]) ? obj[key] : "";
		var fd = newTEXTAREA(td, key, "50", "5", val);
	}
	
	function makeField(tbl, key, obj, status){
		var tr = newTR(tbl, "", "");
        var td = newTD(tr, "", key);
        td.style.paddingRight = "10px";
        
		if (status){
            var td = newTD(tr, "", "");
			var val = (obj[key]) ? obj[key] : "";
			var fd = newFIELD(td, key, "", "70", val);
		} else {
			var td = newTD(tr, "", obj[key]);
		}
	}
}

function checkAll(elm){
	// checkBox の全てにチェックを入れる
	var status = elm.checked;
	var recs = groupRecords();
    for (i in recs){
		var elm = document.getElementById("checkArea."+i);
		elm.innerHTML = "";
		var cb = newCHECKBOX(elm, "cb."+i, "", status);
	}
}

function find(){
	// 検索を実行
	var key = document.getElementById("keyF").value;
	var array = groupRecords();
	var count = 0;
    for (i in array){
		var tr = document.getElementById("row"+i);
		var obj = array[i];
		var found = false;
		if (key.length){
			var st = obj.subject + obj.examination + obj.treatment;
			if (st.indexOf(key) >= 0) found = true;
		}
		
		if (found){ // key が含まれていた行の色を変える
			tr.style.backgroundColor = "#ff0";
			count++;
		} else
			tr.style.backgroundColor = "#fff";
	}
	
	if (count)
		alert(count + " 個の該当レコードを見つけました。黄色い行が該当レコードです。スクロールしてみてください");
	else if (key.length > 0)
		alert(key + " を含むレコードは見つかりませんでした");
}

function showRecords(){
	// レコードを表示する
	var elm = document.getElementById("resultArea");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "/base-table");
	
	// title
	var tr = newTR(tbl, "title-bar", "");
    tr.style.backgroundColor = "#ec9";
	var td = newTD(tr, "", "");
	td.style.width = "10px";
	td.style.paddingLeft = "5px";
	var cb = newCHECKBOX(td, "", "", false);
	cb.setAttribute("onclick", "checkAll(this)");
	var td = newTD(tr, "/list-label", "subject");
	var td = newTD(tr, "/list-label", "examination");
	var td = newTD(tr, "/list-label", "treatment");
	
	// records
	var array = groupRecords();
    for (i in array){
		var obj = array[i];
        _debug(i+"->"+encodeObject(obj));  //##
               
		var tr = newTR(tbl, "row"+i, "");
        tr.style.fontSize = "10pt";
		
		// check box
		var td = newTD(tr, "checkArea."+i, "");
		td.style.width = "10px";
        td.style.paddingLeft = "5px";
		var cb = newCHECKBOX(td, "cb."+i, "", false);

		var td = newTD(tr, "/alias-value", obj.subject);
		td.setAttribute("onclick", "openEditor('"+i+"')");
		
		var td = newTD(tr, "", obj.examination);
		var td = newTD(tr, "", obj.treatment);
		
		// 編集エリアを生成しておく
		var eid = editorIdForRow(i);
		var tr = newTR(tbl, "", "");
		var td = newTD(tr, eid, "");
		td.setAttribute("colspan", "5");
	}
	
	// 編集エリアを生成しておく
	var eid = editorIdForRow(array.length);
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, eid, "");
	td.setAttribute("colspan", "9");
	
	// save ボタンを表示
	showSaveButtons();
}

function initGroupMenu(){
	var elm = document.getElementById("base");
	elm.innerHTML = "";
    
    // HEADER =====================================
    var div = newDIV(elm, "/yellow-header");
    var dv = newDIV(div, "/left-side");
    dv.setAttribute("onclick", "suser()");
    var sp = newSPAN(dv, "markArea");
    var tx = newTEXT(dv, "GroupMenu 編集");
    var dv = newDIV(div, "/right-side");
	var im = newIMAGE(dv, "", "./Help.png", "?");
	im.setAttribute("onclick", "tableHelp()");
	im.style.height = "21px";

	// ロード・エリア ===============================
    var div = newDIV(elm, "loadButtonArea");
    div.style.paddingLeft = "10px";
    div.style.paddingBottom = "5px";
	var sp = newSPAN(div, "userListArea"); // ユーザリストを表示
	var tx = newTEXT(div, " の ");
	var sp = newSPAN(div, "sourceListArea"); // データソースを表示
	var sp = newSPAN(div, "fileNamesArea"); // テンプレートのリストを表示
	var tx = newTEXT(div, " を ");
	var bt = newBUTTON(div, "", "読込む");
	bt.setAttribute("onclick", "load()");
	var sp = newSPAN(div, "removeButtonArea"); // テンプレートのリスト削除ボタン
    
	// セーブ・エリア ===============================
    var div = newDIV(elm, "saveButtonArea");
    div.style.paddingLeft = "10px";
    
    // メッセージ表示エリア
    var div = newDIV(elm, "messageArea");
    div.style.fontsize = "9pt";
    div.style.color = "#f00";
    
	// データ表示エリア =============================
    var div = newDIV(elm, "controlArea");
	
	// FOOTER ======================================
    var div = newDIV(elm, "/yellow-footer");
    var dv = newDIV(div, "/left-side");
	dv.innerHTML = version();
    
	// ユーザ・ポップアップを読込む
	selectUserAndLoadStructure();
}

function version(){
	return "Ver.140627";
}
