
/////////////////////////
///// カルテからの継承値 ///

// owner(), prefTag() などは他とカブりエラーになるので parent().owner() のような使い方
function prefTag(){
    // panelEditor から起動する場合は URL パラメータ渡し
    var val = document.getElementById("_tag").value;
    
    return (val && (val.length > 0)) ? val : parent().currentTag();
}

function cp_owner(){
    return parent().owner();
}

function cp_patientId(){
    return parent().patientId();
}

function cp_currentDate(){
    return parent().currentDate();
}

function cp_currentTag(){
    return parent().currentTag();
}

function cp_currentLabel(){
    return parent().labelForTag(cp_currentTag());
}

function cp_cellForTag(tag){
    return parent().cellForTag(tag);
}

function cp_setEditorTag(tag){
    // EDITOR が閉じたことを記憶しスタンバイ状態にする
    parent().setEditorTag(tag);
}

function cp_openCellEditor(tag){
    parent().openCellEditor(cp_currentDate(), tag);
}

function cp_getGroupMenu(receiver){
    var args = new Object();
    args["owner"] = cp_owner();
    NRCall("GET_GROUP_MENU", args, receiver);
}

var _has_GroupDate;
function cp_setHasGroupDate(val){
    _has_GroupDate = val;
    //console.log("set _has_GroupDate ->", _has_GroupDate); //##
}
function cp_hasGroupDate(){
    // 選択されたグループ・メニュー先頭に日付を挿入するかどうかのフラッグ
    return _has_GroupDate * 1;
}

///// カルテからの継承値 ///
/////////////////////////

function editors(){
    // ### 専用エディターが増えたらここに追加する ###
    return {"病名":"openDisease","伝票":"openForm","処方":"openPrescription","医事計算":"openVin"};
}
function editorNames(){
	// editor の日本語名称の配列を返す
    // return ["","伝票","処方","医事計算"];
    // ### cellEditor.js で for (key in array) を実行すると window 認識がおかしくなる
    var array = allKeys(editors());
    array.splice(0,0,"");
    
    return array;
}
function nameForEditor(editor){
	// editor に対応する日本語名称を返す
    // ### cellEditor.js で for (key in array) を実行すると window 認識がおかしくなる
    return keyForValueIn(editors(), editor);
}
function editorForName(name){
	// 日本語名称に対応する editor を返す
	var editor = editors()[name];
    
	return (editor) ? editor : "";
}


////////////////////////////////
/// neuron.js による処理 /////////

function savedCellEditor(answer){
    // CELL 属性がサーバに保存されたことを返すだけで answer は利用されない
    //alert("savedCellEditor->"+answer); //##
    alert("ブラウザー画面の再読込で変更が反映されます");

    window.top.location.reload(true);
}
function saveCellEditor(){
    // CELL 属性をサーバへ保存：MenuTable の更新は行わない
    var obj = editorObject();

    //_initDebug(true); //##
    //_debug("saveCellEditor-> "+encodeObject(obj)); //return; //##
    
    var args = new Object();
    args["owner"] = cp_owner();
    args["tag"] = obj.tag;
    args["buttonType"] = obj.buttonType, // monoSelection
    args["menuType"] = obj.menuType;
    args["menuAction"] = obj.menuAction;
    args["hitAndRun"] = obj.hitAndRun;
    //args["fieldType"] = obj.fieldType;
    args["disabled"] = obj.disabled;
    args["editor"] = obj.editor;
    args["id"] = obj.id;
    args["script"] = obj.script;
    args["bgcolor"] = obj.bgcolor;
    args["label"] = obj.label;
    args["numbering"] = obj.numbering;
    args["study"] = obj.study;
    args["fontSize"] = obj.fontSize;
    args["fontFamily"] = obj.fontFamily;
    args["color"] = obj.color;
    _debug("saveCellEditor->"+encodeObject(args)); // return; //##
    
    NRCall("SET_CELL_ATTRIBUTES", args, savedCellEditor);
}

function editorObject(){
    // CELL Editor の設定値を入れたオブジェクトを返す
    // tag に相当するレイアウト属性を得ておく
    var cell = cp_cellForTag(prefTag());
    
    var obj = new Object();
    obj.tag = prefTag();
    obj.buttonType = (document.getElementById("monoSelection").checked) ? "1" : "0";
    obj.menuType = menuTypeForItem(document.getElementById("menuType").value);
    obj.menuAction = menuActionForItem(document.getElementById("menuAction").value);
    obj.hitAndRun = cell.hitAndRun; // 表示/非表示：Layout.js で扱う
    //obj.fieldType = fieldTypeForItem(document.getElementById("fieldType").value);
    // direction --- サーバ側で固定値 "CELL" が入る
    obj.disabled = (document.getElementById("disabled").checked) ? "1" : "0";
    obj.editor = document.getElementById("editorF").value;
    obj.id = modeForTag(prefTag()); // 'P','B','I' いずれかを入れなければならない
    obj.script = document.getElementById("scriptArea").innerHTML;
    obj.bgcolor = colorCode('bgcolor');
    obj.label = document.getElementById("labelF").value;
    obj.numbering = cell.numbering; // -- CELL 表示順位：Layout.js で扱う
    obj.study = (document.getElementById("study").checked) ? "1" : "0";
    obj.fontSize = document.getElementById("fontSizeF").value;
    // obj.fontFamily = document.getElementById("fontFamilyF").value;
    obj.color = colorCode('color');

    //alert("editorObject-> "+encodeObject(obj)); //##
    
    return obj;
    
    
    function menuTypeForItem(item){
        // item に対する menuAction 番号を返す
        var types = menuTypes(); // lib.js
        for(num in types){
            if (item == types[num]) return num;
        }
        return 0;
    }
    
    function menuActionForItem(item){
        // メニューを文中に挿入する位置：item に対する menuAction 番号を返す
        var items = menuActions(); // lib.js
        for(num in items){
            if (item == items[num]) return num;
        }
        return 0;
    }

    /*
    function fieldTypeForItem(item){
        // item に対する menuAction 番号を返す
        var types = fieldTypes(); // lib.js
        for(num in types){
            if (item == types[num]) return num;
        }
        return 0;
    }
     */
    
    function colorCode(type){
        var color = "";
        var id = (type == 'color') ? 'colorBox' : 'bgcolorBox';
        if (document.getElementById(id).checked){
            var red = document.getElementById(type+".R").value;
            var green = document.getElementById(type+".G").value;
            var blue = document.getElementById(type+".B").value;
            var color = "#" + red + green + blue;
        }
        
        return (color.length == 4) ? color : "";
    }
}

function setGroupMenuEditor(answer){
    // GROUP MENU 属性を再表示
    //alert(answer); //##
    document.getElementById("freqF").value = answer * 1;
}

function freqAreChanged(elm){
    // 頻度が変更されるとリアルタイムにサーバを更新
    var item = document.getElementById("menuItem").value;
    var freq = elm.value;
    
	// 変更されたメニューの頻度をサーバへ保存：_group_ なら頻度の保存先を換える
    var owner = cp_owner();
    var mtype = document.getElementById("menuType").value;
    
    if (mtype == menuTypes()[_group_])
        put_group_menu(owner, item, freq, [], setGroupMenuEditor);
    else
        put_menu(owner, prefTag(), item, freq, "", openAttributeEditor);
}

function removedMenu(answer){
    var obj = JSON.parse(answer);
    _debug("removedMenu->"+encodeObject(obj)); //##
    
    // メニューを再生成
    var menus = new Array();
    for (num in obj){
        var rec = obj[num];
        menus.push(rec.menu);
    }
    
    // ポップアップ・メニューを再描画
    var sp = document.getElementById("menuItemArea");
    sp.innerHTML = "";
    var pu = newPopupMenu(sp, "menuItem", menus, "");
    pu.setAttribute("onchange", "showMenuFreq()");
    
    showMenuFreq();
    
    // CellEditor も再描画：すでに cellEditor が開いていれば close
    // ### memory 上の menu を削除しておかないと変更が反映されない
    var tag = prefTag();
    parent().setMenus(tag, null);
    cp_openCellEditor(tag);
}
function removeMenu(){
    // メニューが削除されるとリアルタイムにサーバを更新
    //_initDebug(true); //##
    _debug("== removeMenu"); //##

    var type = document.getElementById("menuType").value;
    _debug("type->"+type); //##
    
    if (indexOfArray(menuTypes(), type) == _group_){
        removeGroupMenu();
        return;
    }

    var label = document.getElementById("menuItem").value;
    if (label == "都道府県"){
        var aTag = label;
        var item = document.getElementById(label).value;
    } else if (label == "市区"){
        var aTag = document.getElementById("都道府県").value;
        var item = selectedMenuItem();
    } else if (label == "町村"){
        var aTag = document.getElementById("cityPop").value;
        var item = selectedMenuItem();
    } else {
        var aTag = prefTag();
        var item = document.getElementById("menuItem").value;
    }
    
    if (confirm(item + " を削除しますか")) {
        // remove_menu(cp_owner(), aTag, item, "", "debug");
        remove_menu(cp_owner(), aTag, item, "", removedMenu);
    }
}

function redrawCellEditor(answer){
    // CELL 属性編集パネルのポップアップ更新
    openAttributeEditor(answer);
    
    // CellEditor のポップアップ更新
    parent().kickCellEditor(parent().currentTag()); // Ajax
}
function removedGroupMenu(answer){
    // メニュー項目のポップアップ更新
    
    // tag 要素を削除しておけば、後の kickCellEditor() で再読込される
    // kickCellEditor() 起動まで他の処理で時間を稼いだ方が良いようだ
    parent().removeMenusForTag(parent().currentTag());
    
    // CELL 属性編集パネルのメニュー要素をサーバへリクエスト
    cp_getGroupMenu(redrawCellEditor); // Ajax
}
function removeGroupMenu(){
    // GROUP MENU 項目を削除
    var item = document.getElementById("menuItem").value;
    if (confirm(item + " を削除しますか")) {
        // ３番目の引数 freq が "-1" なら削除になる
        put_group_menu(cp_owner(), item, "-1", [], removedGroupMenu);
    }
}

/// neuron.js による処理 /////////
////////////////////////////////


function showMenuFreq(){
    // メニュー項目が変更されたらその頻度を表示
	var item = document.getElementById("menuItem").value;
	document.getElementById("freqF").value = freqForItem(item);
    
    // グループ編集パネルが開いていたら閉じる
	var elm = document.getElementById("groupEditorArea");
    if (elm) elm.innerHTML = "";
}

function setSampleColor(){
    // 設定された文字色と背景色を表示
    //_initDebug(true); //##
    
    var elm = document.getElementById("tagArea");
    // 文字色
    var code = colorOf('color');
    elm.style.color = (code) ? code : "#000";
    
    _debug("elm->"+elm); //##
    _debug("color code->"+code); //##
    
    // 背景色
    var code = colorOf('bgcolor');
    elm.style.backgroundColor = (code) ? code : "#fff";

    _debug("bgcolor code->"+code); //##

    function colorOf(type){
        // CELL 文字色の設定値を返す
        var id = (type == 'color') ? 'colorBox' : 'bgcolorBox';
        var elm = document.getElementById(id);

        _debug("colorOf->"+type); //##
        _debug(id + " elm->"+elm); //##

        if (elm && elm.checked){
            // colorBox は生成されていても bgcolorBox は生成前のことがある
            var red = document.getElementById(type+".R").value;
            _debug("red->"+document.getElementById(type+".R")+"->"+red); //##

            var green = document.getElementById(type+".G").value;
            var blue = document.getElementById(type+".B").value;
            var color = "#" + red + green + blue;

            _debug("color->"+color); //##

            return (color.length == 4) ? color : null;
        } else
            return null;
    }
}

function showColorPop(elm, type, color){
    // 三原色を設定するポップアップ・メニューを生成
    var colors = ["","0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F"];
    var red = "";
    var green = "";
    var blue = "";
    if (color){
        red = color.substr(1,1);
        green = color.substr(2,1);
        blue = color.substr(3,1);
    }
    elm.innerHTML = "";
    var pu = newPopupMenu(elm, type+".R", colors, red);
    pu.setAttribute("onchange", "setSampleColor()");
    var pu = newPopupMenu(elm, type+".G", colors, green);
    pu.setAttribute("onchange", "setSampleColor()");
    var pu = newPopupMenu(elm, type+".B", colors, blue);
    pu.setAttribute("onchange", "setSampleColor()");
}

function checkedColorBox(elm, color){
    // 着色チェックボックスが変更された
    var sp = document.getElementById("colorPopArea");
    if (elm.checked) 
        showColorPop(sp, 'color', color);
    else 
        sp.innerHTML = "";
    setSampleColor();
}
function checkedBGColorBox(elm, color){
    // 着色チェックボックスが変更された
    var sp = document.getElementById("bgcolorPopArea");
    if (elm.checked) 
        showColorPop(sp, 'bgcolor', color);
    else 
        sp.innerHTML = "";
    setSampleColor();
}

function changedDateCheck(answer){
    // answer には「freq の値」が返ってくるだけなので、ここでは無関係
    // console.log("changedDateCheck", answer); //##
}
function changeDateCheck(elm){
    // 「行頭にタイムスタンプ挿入」チェックボックスが更新された
    var obj = new Object();
    var item = "_date_check_"; // GroupMenu の タイムスタンプ挿入を表すマーク
    obj['ProgressSection.subject'] = item;
    // GroupMenu の場合は note に「タイムスタンプ挿入/非挿入」を指定
    if (elm.checked)
        obj['ProgressSection.note'] = "1";
    else
        obj['ProgressSection.note'] = "0";

    // freq には数値を入れないとレコードが update されないので '0' を指定
    put_group_menu(cp_owner(), item, '0', obj, changedDateCheck);
}

function changedMenuType(){
    // メニュー形式が変更された：グループメニューなら専用エディターを表示
    var type = document.getElementById("menuType").value;
    var elm = document.getElementById("groupEditorButtonArea");
    
    if (!elm){
        return;
    } else if (indexOfArray(menuTypes(), type) == _group_){ // lib.js
        // グループ・メニュー編集ボタンを生成
        elm.innerHTML = "";
        var td = newTD(elm, "", "");
        // 編集ボタン
        var td = newTD(elm, "", "");
        var div = newDIV(td, "");
        // 編集ボタン
        var bt = newBUTTON(div, "", "グループ・メニューを編集");
        bt.setAttribute("onclick", "openGroupMenuEditor()"); // groupMenuEditor.js
        // 日付チェックボックス
        var div = newDIV(td, "");
        var cb = newCHECKBOX(div, "dateCheckBox", "行頭にタイムスタンプ挿入", cp_hasGroupDate());
        cb.setAttribute("onchange", "changeDateCheck(this)");
    } else {
        elm.innerHTML = "";
        // 頻度フィールド
        var td = newTD(elm, "", "");
        var td = newTD(elm, "", "");
        var fd = newFIELD(td, "freqF", "頻度", 3, "");
        fd.setAttribute("onchange", "freqAreChanged(this)");
        showMenuFreq();
    }
}

///////////////////////////////////////////////////////////////
///// 共有メニュー //////////////////////////////////////////////

var _publicMenus;
function savedStatusOfPublic(answer){
    //alert("savedStatusOfPublic->"+answer); //##
    var obj = JSON.parse(answer);
    //alert("savedStatusOfPublic->"+encodeObject(obj)); //##
    
    closeFloatPanel();
    alert("CELL 編集画面を再読込すると反映されます");
}
function saveStatusOfPublic(){
    // 共有メニューの属性変更をサーバへ保存
    var cell = cp_cellForTag(prefTag());
    if (cell.menuType == _group_){
        // グループ・メニューであることをサーバへ伝える
        _publicMenus['GroupMenu'] = true;
    }
    
    // 更新レコードのみサーバへ送るため _publicMenus を使用している
    var args = new Object();
    args["owner"] = cp_owner();
    args["tag"] = prefTag();
    args["publicMenus"] = _publicMenus;
    NRCall("PUT_PUBLIC_MENU", args, savedStatusOfPublic);
}

function changePublic(elm, menu){
    // 共有メニュー表示属性の変更を記憶
    // menuTable.public で 1 はすでに使われていることがあるので非表示には 2 を設定
    _publicMenus[menu] = (elm.checked) ? 2 : 0;
}

function showPublicEditor(){
    // 共有メニュー：pubic menu 設定ペーンを表示
    _publicMenus = new Object();
    
    //_initDebug(true); //##
    var w = 350;
	var x = 10; // 表示するx座標
	var y = 30; // 表示するy座標
    var title = "共有メニュー 表示設定";
    
    _debug("showPublicEditor"); //##
    var elm = openSeeThroughPanel("_floatPanel", x, y, w, title);
    if (!elm) return;
    elm.style.padding = "8px";
    
    var div = newDIV(elm, "");
    div.style.padding = "5px";
    div.style.backgroundColor = "#ffe";
    div.style.fontSize = "10pt";
    div.style.borderRadius = "10px";
    var dv = newDIV(div, "");
    dv.innerHTML = "グレー表示は自分で作成したメニュー。左端にチェックボックスのあるものは";
    dv.innerHTML += "全ユーザで共有されるメニューで、編集や削除はできません。";
    dv.innerHTML += "表示したくない共有メニューはチェックをはずし「確定」";
    dv.innerHTML += "すれば表示されなくなります。";
    dv.style.paddingBottom = "5px";
    dv.style.color = "#833";
    
    // public menu を表示
    var dv = newDIV(div, "");
    for (num in _menuArray){
        var rec = _menuArray[num];
        // 共有メニューを打消すレコードかどうかを示す
        // グループ・メニューでは「共有メニュー非表示 status」は pageHeader に保存されるが
        // サーバから返される時 rec.public に入れて返される
        var denyPublic = (rec.public && (rec.public * 1 > 0)) ? true : false; 
        
        if (rec.owner == 'public'){ // 共有メニューのみ表示
            var ln = newDIV(dv, "");
            var sp = newSPAN(ln, "");
            // public 属性に１が立つものがあればそのメニューは表示されない
            // これにより public メニューをユーザ毎に非表示にできる
            // menuTable.owner = 'public' は共有メニューであることを示し
            // menuTable.public = 1 はそのメニューを非表示にすることを示す
            var status = (rec.public && (rec.public * 1) > 0) ? 0 : 1;
            var cb = newCHECKBOX(sp, "", "", status);
            cb.setAttribute("onchange", "changePublic(this,'" + rec.menu +"')");
            var sp = newSPAN(ln, "");
            sp.innerHTML = rec.menu + " -- " + rec.owner;
        } else if (denyPublic){ // 共有メニューを打消すレコードのみ表示
            var ln = newDIV(dv, "");
            var sp = newSPAN(ln, "");
            var cb = newCHECKBOX(sp, "", "", 0);
            cb.setAttribute("onchange", "changePublic(this,'" + rec.menu +"')");
            var sp = newSPAN(ln, "");
            sp.innerHTML = rec.menu + " -- " + rec.owner;
        } else { //##
            var ln = newDIV(dv, "");
            var sp = newSPAN(ln, "");
            sp.innerHTML = rec.menu + " -- " + rec.owner;
            sp.style.color = "#aaa";
        }
    }
    
    // 検索ボタン
    var dv = newDIV(div, "");
    dv.style.textAlign = "right";
    var bt = newSPAN(dv, "/fixButton");
    bt.innerHTML = "確定";
    bt.setAttribute("onclick", "saveStatusOfPublic()");
}

///// 共有メニュー //////////////////////////////////////////////
///////////////////////////////////////////////////////////////


function editorSelected(elm){
    // Editor 種類のポップアップ・メニューが選択された
    document.getElementById("editorF").value = editorForName(elm.value);
}

var _menuArray;
function closeAttributeEditor(){
	// EDITOR TOOL を閉じる
    var tools = window.top.tools;
    
    tools.closeToolArea();
}
function freqForItem(menuItem){
    // item に対する頻度を返す
    for (num in _menuArray){
        var obj = _menuArray[num];
        
        if (obj.menu == menuItem) return obj.freq;
    }
    return "";
}
function openAttributeEditor(answer){
    // CELL 属性を表示
    _menuArray = JSON.parse(answer);
    //alert("--- openAttributeEditor ->"+encodeObject(_menuArray)); //##
    
    // _menuArray=[{"menu":"下腹痛","value":"","public":"","freq":"55"},,,]
    // _menuArray は freq で降順ソートされている
    var menus = new Array();
    cp_setHasGroupDate('0'); // 選択されたグループ・メニュー先頭に日付を挿入しない
    for (num in _menuArray){
        var rec = _menuArray[num];
        // public メニューの非表示には 2 が設定されている：すでに 1 は使われていることあり
        if ((rec.owner != 'public') && rec.public && (rec.public*1 > 1)) 
            continue; // 共有メニューはスキップ
        
        var subject = rec['ProgressSection.subject'];
        if (subject == "_date_check_"){
            // グループ・メニュー行頭に日付を入れるモードか否かを取得
            var note = rec['ProgressSection.note']
            console.log("== note ->", note); //##
            
            if (note * 1 > 0) cp_setHasGroupDate('1');
            continue;
        }
        
        if (rec.menu.length)
            menus.push(rec.menu);
        _debug(rec.owner+"->"+rec.menu); //##
    }

    var elm = document.getElementById("bodyArea");
    _debug("bodyArea->"+elm); //##
    elm.innerHTML = "";
    
	var tbl = newTABLE(elm, "/base-table");
    tbl.style.backgroundColor = "#ffa";
    tbl.style.fontSize = "10pt";
    
    var obj = cp_cellForTag(prefTag()); // フィールド属性を知るオブジェクト
    //alert(prefTag()+" openAttributeEditor->"+encodeObject(obj)); //##
    
    makeLine(tbl, "ラベル名", obj);
    makeLine(tbl, "tag", prefTag());
    
    makeSUbTitle(tbl, "メニューの設定");
    makeLine(tbl, "形式", obj);
    makeLine(tbl, "メニュー項目", menus);
    
    // Group Menu EDitor 表示エリア
    var tr = newTR(tbl, "groupEditorButtonArea", "");
    var tr = newTR(tbl, "groupEditorArea", "");
    changedMenuType();
    
    makeLine(tbl, "頻度学習", obj);
    makeLine(tbl, "メニュー選択", obj);
    makeLine(tbl, "挿入位置", obj);
    
    makeSUbTitle(tbl, "入力欄の設定");
    makeLine(tbl, "入力欄", obj);
    makeLine(tbl, "Font Size", obj);
    // makeLine(tbl, "Font Family", obj); // 当面サポートせず
    makeLine(tbl, "書込み", obj); // super user がレイアウト設定で行うが、ここに表示はする
    makeLine(tbl, "文字色", obj);
    makeLine(tbl, "背景色", obj);
    
    makeSUbTitle(tbl, "専用エディターの設定");
    makeLine(tbl, "Editor", obj);
    makeLine(tbl, "Script", obj);
    
    makeSUbTitle(tbl, "その他の属性");
    makeLine(tbl, "id", obj);
    makeLine(tbl, "numbering", obj);
    makeLine(tbl, "hitAndRun", obj);

    function makeLine(tbl, label, obj){
        // 一行分のラベル・バリューを生成
        var tr = newTR(tbl, "", "");
        var td = newTD(tr, "", label);
        td.style.width = "110px";
        td.style.paddingLeft = "5px";
        td.style.verticalAlign = "top";
        
        var td = newTD(tr, "", "");
        if (label == "ラベル名"){
            var fd = newFIELD(td, "labelF", "", 20, obj.label);
        } else if (label == "tag"){
            var sp = newSPAN(td, "tagArea");
            sp.innerHTML = obj;
        } else if (label == "形式"){
            var types = menuTypes(); // lib.js
            var mtype = 0;
            if (obj.menuType && (obj.menuType * 1 < types.length)){
                mtype = obj.menuType * 1;
            }
            var pu = newPopupMenu(td, "menuType", types, types[mtype]);
            pu.setAttribute("onchange", "changedMenuType()");
            var sp = newSPAN(td, "");
            sp.innerHTML = " タイプ";
        } else if (label == "メニュー項目"){
            var sp = newSPAN(td, "menuItemArea");
            var pu = newPopupMenu(sp, "menuItem", obj, "");
            pu.setAttribute("onchange", "showMenuFreq()");
            
            // 削除アイコン
            var sp = newSPAN(td, "removeMenuTip");
            sp.style.paddingLeft = "5px";
            sp.setAttribute("onclick", "removeMenu()");
            var img = newIMAGE(sp, "", "./remove-field.png", "X");
            img.style.verticalAlign = "middle";
            img.style.height = "12px";
            setInfoTip("removeMenuTip", "選択されたメニュー項目を削除"); // HELP
            
            // 頻度フィールドかグループ・メニュー編集ボタンを表示
            changedMenuType();
            
            // public menu の可視・不可視の設定
            var tr = newTR(tbl, "publicMenuArea", "");
            var td = newTD(tr, "", "");
            td.style.width = "110px";
            var td = newTD(tr, "", "");
            var a = newA(td, "共有メニュー設定", "#", "");
            a.setAttribute("onclick", "showPublicEditor()");
        } else if (label == "頻度学習"){
            var status = (obj.study * 1) ? 1 : 0;
            var cb = newCHECKBOX(td, "study", "頻度学習をする", status);
        } else if (label == "メニュー選択"){
            var status = (obj.buttonType * 1) ? 1 : 0; // monoSelection
            var cb = newCHECKBOX(td, "monoSelection", "１回のみ選択", status);
        } else if (label == "挿入位置"){ // メニューを文中に挿入する位置
            var items = menuActions(); // lib.js
            var item = items[obj.menuAction]
            newPopupMenu(td, "menuAction", items, item);
        /*} else if (label == "入力欄"){
            var types = fieldTypes(); // lib.js
            var ftype = (obj.fieldType && (obj.fieldType * 1 > 0)) ? 1 : 0;
            var pu = newPopupMenu(td, "fieldType", types, types[ftype]);
            var tx = newTEXT(td, " タイプ");*/
        } else if (label == "Font Size"){
            var font = (obj.fontSize) ? obj.fontSize : "";
            var ip = newFIELD(td, "fontSizeF", "", 3, font);
            var tx = newTEXT(td, " pt");
        /* } else if (label == "Font Family"){
            var fsize = (obj.fontFamily * 1) ? obj.fontFamily : "";
            var ip = newFIELD(td, "fontFamilyF", "", 20, fsize);
         */
        } else if (label == "書込み"){
            var status = (obj.disabled && (obj.disabled * 1 > 0)) ? 1 : 0;
            var cb = newCHECKBOX(td, "disabled", "不可", status);
            // 以下は上の disabled とは別でチェックボックスを操作できないようにする
            // 書込み不可はレイアウト設定で super user のみが実行できる
            // しかしサーバへの書き戻しでこの項目の status が必要なので一応ここに記憶しておく
            cb.setAttribute("disabled","true");
        } else if (label == "文字色"){
            var status = (obj.color && obj.color.length) ? 1 : 0;
            var cb = newCHECKBOX(td, "colorBox", "着色", status);
            cb.setAttribute("onchange", "checkedColorBox(this,'"+obj.color+"')");
            var sp = newSPAN(td, "colorPopArea");
            if (status) {
                showColorPop(sp, 'color', obj.color);
                setSampleColor();
            }
        } else if (label == "背景色"){
            var status = (obj.bgcolor && obj.bgcolor.length) ? 1 : 0;
            var cb = newCHECKBOX(td, "bgcolorBox", "着色", status);
            cb.setAttribute("onchange", "checkedBGColorBox(this,'"+obj.bgcolor+"')");
            var sp = newSPAN(td, "bgcolorPopArea");
            if (status) {
                showColorPop(sp, 'bgcolor', obj.bgcolor);
                setSampleColor();
            }
        } else if (label == "Editor"){
            var editor = (obj.editor) ? obj.editor : "";
            var title = nameForEditor(editor);
            var pu = newPopupMenu(td, "", editorNames(), title);
            pu.setAttribute("onchange", "editorSelected(this)");
            var fd = newFIELD(td, "editorF", "", 20, editor);
        } else if (label == "Script"){
            var sp = newSPAN(td, "scriptArea");
            sp.innerHTML = obj.script;
        } else if (label == "id"){
            var sp = newSPAN(td, "idArea");
            sp.innerHTML = obj.id;
        } else if (label == "numbering"){
            var sp = newSPAN(td, "numberingArea");
            sp.innerHTML = obj.numbering;
        } else if (label == "hitAndRun"){
            var sp = newSPAN(td, "hitAndRunArea");
            sp.innerHTML = obj.hitAndRun;
        }
    }
    
    function makeSUbTitle(tbl, label){
        // サブタイトルを生成
        var tr = newTR(tbl, "/yellow-bar", "");
        var td = newTD(tr, "", label);
        td.setAttribute("colspan", "2");
        td.style.textAlign = "center";
    }
}

function initCellPreference(){
    // CELL の初期設定ツールを開く
    var base = elmFor("base");
	base.innerHTML = "";
    
    //_initDebug(true); //##
    _debug("=== initCellPreference ==="); //##

    // === HEADER ===========================
    var div = newDIV(base, "/yellow-bar");
    // -- LEFT SIDE --
    var dv = newDIV(div, "/left-side");
	var im = newIMAGE(dv, "icon", "./close.png", "?");
    im.style.height = "12px";
	im.setAttribute("onclick", "closeAttributeEditor()");
	var sp = newSPAN(dv, "");
    sp.style.paddingLeft = "5px";
    sp.innerHTML = "CELL 属性編集パネル";
    // -- RIGHT SIDE --
    var dv = newDIV(div, "/right-side");
	var im = newIMAGE(dv, "", "./Help.png", "?");
	im.setAttribute("onclick", "openHelp('./cellPrefHelp.html')");
	im.style.height = "18px";
	im.style.verticalAlign = "bottom";
    
	// body
    var div = newDIV(base, "bodyArea");

    _debug("bodyArea->"+elmFor("bodyArea")); //##

    // === FOOTER ===========================
    var div = newDIV(base, "/yellow-bar");
    // -- LEFT SIDE --
    var dv = newDIV(div, "/left-side");
    dv.innerHTML = cp_version();
    // -- RIGHT SIDE --
    var dv = newDIV(div, "/right-side");
	var bt = newDIV(dv, "/whiteButton");
    bt.innerHTML = "確定";
    bt.setAttribute("onclick", "saveCellEditor()");
    
    var tag = cp_currentTag();
    var cell = cp_cellForTag(tag);

    _debug("bodyArea-->"+elmFor("bodyArea")); //##

    if (cell.menuType == _group_){
        cp_getGroupMenu(openAttributeEditor);
    } else {
        get_menu(cp_owner(), cp_currentTag(), openAttributeEditor);
    }
}

function cp_version(){
    return "Ver.140416";
}