
<?php
    
    function leftBrackets(){
        // $leftBrackets = "\^\[\^" では誤作動
        //	return "\^\[\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        return "^[^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function rightBrackets(){
        return "^]^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        //	return "\^\]\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function decodeObject($buff){
        // "key(value)" 形式の文字列を OBJECT に decode して返す
        $obj = array();
        //	echo "decodeObject ===\n$buff\n"; //##
        for ($p=$begin=$nest=0, $len=strlen($buff); $p < $len; $p++){
            $ch = substr($buff, $p, 1);
            if (strcmp($ch, "(") == 0){
                if ($nest == 0){
                    $key = trim(substr($buff, $begin, $p - $begin)); // key 終端
                    $begin = $p + 1; // value 開始位置
                }
                $nest++;
            } else if (strcmp($ch, ")") == 0){
                if (--$nest == 0){
                    if ($nest == 0){
                        // value 終端 ( trim しない )
                        $value = substr($buff,$begin,$p-$begin);
                        $begin = $p + 1; // key 開始位置
                    }
                    if (ereg(")", $value)){ // まだ入れ子になっているなら
                        $obj[$key] = decodeObject($value);
                    } else {
                        // 特定文字を "(", ")" へ戻す
                        $array = explode(leftBrackets(), $value);
                        $value = join("(", $array);
                        $array = explode(rightBrackets(), $value);
                        $value = join(")", $array);
                        
                        $obj[$key] = $value;
                    }
                    //echo "$key{".$obj[$key]."}\n"; //##
                }
            }
        }
        return $obj;
    }

	function decodeSTRING($val){
		// #, &, +  < > などが URI 送信で化けるため encode して送られたものを decode
		$array = explode("%x0;", $val);
		$val = implode("#", $array);
		$array = explode("%x1;", $val);
		$val = implode("&", $array);
		$array = explode("%x2;", $val);
		$val = implode("+", $array);
		$array = explode("%x3;", $val);
		$val = implode("<", $array);
		$array = explode("%x4;", $val);
		$val = implode(">", $array);
		$array = explode("%x5;", $val);
		$val = implode(" ", $array);
		$array = explode("%x6;", $val);
		$val = implode("\n", $array);
		$array = explode("%x7;", $val);
		$val = implode("\"", $array);
		$array = explode("%x8;", $val);
		$val = implode("$", $array);
		$array = explode("%x9;", $val);
		$val = implode("\'", $array);
		return $val;
	}
	
	
	/*** Basic認証がかかったページにアクセスする方法 ***
	 http://www.phppro.jp/qa/212
	 
	 PEARのHTTP_Requestを使用するのが楽ではないでしょうか？
	 http://pear.php.net/manual/ja/package.http.http-request.basic-auth.php
	 */
    
    /*******************************
     http://pear.php.net 提供のライブラリーを使用
     HTTP/Request.php
     require_once 'PEAR.php';
     require_once 'Net/Socket.php';
     require_once 'Net/URL.php';
     *******************************/
    
    require_once 'HTTP/Request.php';
    
    $command = $_GET['command']; $command=htmlspecialchars($command);
    $value = $_GET['value']; $value=htmlspecialchars($value);
    $value = decodeSTRING($value);
    
    if (strcmp($command,"GET_HTML_WITH_CERTIFICATION") == 0){
        // BASIC 認証を処理しつつ URL の内容を取得
        $args = decodeObject($value); // client 側との約束ごと
        $url = $args['url'];
        $user = $args['user'];
        $pwd = $args['pwd'];
        
        echo "URL($url) user($user) pwd($pwd)\n";
		
        // 認証を処理しつつ URL の内容を表示
		$req = & new HTTP_Request($url);
		$req->setBasicAuth($user, $pwd);
		
		$response = $req->sendRequest();
		
		if (PEAR::isError($response)) {
			echo $response->getMessage();
		} else {
            echo "<SEPARATOR>";
			echo $req->getResponseBody();
		}
    } else {
        echo "*** unknown command: $command ***";
    }
    
?>