<?php
    
    require_once '../TCPDF/tcpdf.php';
    /*
     define('FPDF_FONTPATH','/Applications/MAMP/htdocs/FPDF/fpdf153/font/');
     require('../FPDF/fpdf153/mbfpdf.php');
     */
	require_once 'printLib.php';
	
	class _TCPDF extends TCPDF
//	class _MBFPDF extends MBFPDF
	{
		// MBFPDF のサブクラスとして _MBFPDF を宣言
        // Header() Footer() をカスタマイズして改頁処理を行うために必要
        
        function Header(){
			$headerTopMargin = 15;
			$headerLeftMargin = 10;
			$innerMargin = 8;
			$headerHeight = 18;
			$headerWidth = 160;
            
			// フォント指定
            $this->SetFont('kozminproregular', 'B', 14);
            //			$this->SetFont(KOZMIN,'B', 14);
            
            // docMaker.js から送られた JSON をオブジェクトに decode 
            // class 外で処理した $obj が認識されないのでここで処理
            $value = $_GET['value']; $value = stripslashes($value);
            $value = decodeSTRING($value);
            $obj = json_decode($value, true);
            
			// タイトル '診療情報提供書'
			$x = $headerLeftMargin;
			$y = 2;
			$this->SetXY($x, $y);
			$this->Cell($headerWidth,5,$obj['documentName'],0,0,'C');
            //			$this->Cell($headerWidth,5,convert($obj,'documentName'),0,0,'C');
            
			// 宛先
			$x += $innerMargin;
			$y += 15;
            $this->SetFont('kozminproregular', 'B', 12);
            //			$this->SetFont(KOZMIN,'B', 12);
			$this->SetXY($x, $y);
			$this->Cell($headerWidth, 5, $obj['addressee'], 0, 0, 'L');
            //			$this->Cell($headerWidth, 5,convert($obj,'addressee'), 0, 0, 'L');
            
			// 年月日
            $this->SetFont('kozminproregular', 'B', 10);
            //			$this->SetFont(KOZMIN,'B', 10);
			$this->SetXY($x, $y);
			$this->Cell($headerWidth-15, 5, $obj['timestamp'],0,0,'R');
            //			$this->Cell($headerWidth-15, 5,convert($obj,'timestamp'),0,0,'R');
            
			// コンテンツ記述枠を描画
			$x = $headerLeftMargin;
			$y += 10;
            $this->SetLineWidth(0.3);
			$this->Rect($x, $y, $headerWidth, 200);
            
            $hasPatientInfo = (strlen($obj['hasPatientInfo']) > 0) ? TRUE : FALSE;
            if (($this->PageNo() == 1) && $hasPatientInfo){
				// 氏名不要のページや２ページ目以降ではこのヘッダー部分は表示されない
                
				// 氏名、性別
				$x += $innerMargin;
				$y += 5;
				$this->SetXY($x, $y);
                $name = $obj['patientName'];
                //                $name = convert($obj,'patientName');
                $sex = $obj['sex'];
                //                $sex = convert($obj,'sex');
                $st = "氏名： $name 様 ( $sex )";
                $this->Cell($headerWidth, 5, $st, 0, 0,'L');
                
				// 年令・生年月日
				$rightX = $headerLeftMargin+$headerWidth/2+14;
                $this->SetFont('kozminproregular', 'B', 10);
                //				$this->SetFont(KOZMIN,'B', 10);
				$this->SetXY($rightX, $y);
                $age = $obj['age'];
                $birthDate = $obj['birthDate'];
                $st = "年令：$age 才 ( $birthDate 生 )";
				$this->Cell($headerWidth, 5, $st, 0, 0, 'L');
                
				// 住所
				$y += 6;
				$this->SetXY($x, $y);
                $patientAddress = $obj['patientAddress'];
                //                $patientAddress = convert($obj,'patientAddress');
                $st = "住所：$patientAddress";
                $this->MultiCell(85, 5, $st, 0, 'L');
				
				// 電話
				$this->SetXY($rightX, $y);
                $patientPhone = $obj['patientPhone'];
                //                $patientPhone = convert($obj,'patientPhone');
                $st = "電話：$patientPhone";
				$this->Cell($headerWidth, 5, $st, 0, 0, 'L');
				
				// 患者情報を表示しない場合
				// ヘッダー罫線のみ描画
				$x = $headerLeftMargin;
				$y += 12;
                $this->SetLineWidth(0.2);
				$this->Line($x + 8, $y, $x + $headerWidth - 8, $y);
			}
			
			// Line break
			$this->Ln(15);
            $GLOBALS['y'] = $this->GetY();
		}
        
		function Footer(){
			$footerTopMargin = 15;
			$footerLeftMargin = 10;
			$footerHeight = 22;
			$footerWidth = 160;
			
			// フォント指定
            $this->SetFont('kozminproregular', '', 10);
            //			$this->SetFont(KOZMIN,'B', 10);
			
			//Go to 1.5 cm from bottom
			$this->SetY(-30);
			
            // docMaker.js から送られた JSON をオブジェクトに decode 
            // class 外で処理した $obj が認識されないのでここで処理
            $value = $_GET['value']; $value = stripslashes($value);
            $value = decodeSTRING($value);
            $obj = json_decode($value, true);
            
			// フッター内容 ==================
            // ロゴ画像の URL は相対パスの必要あり
            //$url = '../Users/ohashi/ohashi-clinic.png';
            $w = 0; // ロゴ・イメージの巾
            $url = $obj['hospitalLogo'];
            if (strlen($url) > 0){
                $x = $footerLeftMargin;
                $y = $this->GetY() + 5;
                $w = 15;
                $this->Image($url, $x, $y, $w);
            }
            
            // 施設名
			$x = $footerLeftMargin + $w + 1;
			$y = $this->GetY() + 2;
			$this->SetXY($x, $y);
            $this->SetFont('kozminproregular', '', 12);
            //			$this->SetFont(KOZMIN,'B', 12);
			$this->Cell($footerWidth, 10, $obj['hospitalName'], 0,0,'L');
            //			$this->Cell($footerWidth, 10,convert($obj,'hospitalName'), 0,0,'L');
			$this->SetXY($footerLeftMargin + $footerWidth/2 + 10, $y);
			// 住所
			$y += 6;
            $this->SetFont('kozminproregular', '', 10);
            //			$this->SetFont(KOZMIN,'B', 10);
			$this->SetXY($x, $y);
			$this->Cell($footerWidth,10,$obj['hospitalAddress'],0,0,'L');
            //			$this->Cell($footerWidth,10,convert($obj,'hospitalAddress'),0,0,'L');
			// 電話
			$y += 6;
			$this->SetXY($x, $y);
			$this->Cell(35, 10, "電話：".$obj['hospitalPhone'], 0,0,'L');
			// FAX
            $x = $this->GetX() + 3;
            $this->SetX($x);
			$this->Cell(35, 10, "FAX: ".$obj['hospitalFAX'], 0,0,'L');
            
            
			if ($this->PageNo() == 1){
				// １ページ目のみ「医師サイン」あり
				$x = $footerLeftMargin + $footerWidth/2 + 30;
				$this->SetY(-30);
				$y = $this->GetY() + 2;
				$this->SetXY($x, $y);
                $this->SetFont('kozminproregular', '', 10);
                //				$this->SetFont(KOZMIN,'B', 10);
				$this->Cell(30, 10, "医師サイン", 0,0,'L');
				// ページ数の印字なし
			} else {
				// ２ページ目以降は「医師サイン」なし
				// ページ数を印字
				$this->SetY(-30);
				$y = $this->GetY() + 16;
				$this->SetXY($footerLeftMargin, $y);
                $this->SetFont('kozminproregular', '', 8);
                //				$this->SetFont(KOZMIN,'B', 8);
				$pageNum = 'Page '.$this->PageNo();
				$this->Cell($footerWidth, 5, $pageNum, 0, 0,'R');
			}
		}
	}
    

    
	$pageWidth = 160;			// 左右カラム合わせた外枠全体の幅
	$leftMargin = 10;			// 画面左端からの左カラムまでのマージン
	$innerMargin = 8;			// 枠から文章行頭までのマージン
	$rowHeight = 5;				// １行の高さ
	
    $pdf = new _TCPDF('P', 'mm', array(180, 256)); // B5
    //	$pdf = new _MBFPDF('P', 'mm', array(180, 256)); // B5
	
    // docMaker.js から送られた JSON をオブジェクトに decode 
    // class 外で処理した $obj が認識されないのでここで処理
    $value = $_GET['value']; $value = stripslashes($value);
    $value = decodeSTRING($value);
    $printObj = json_decode($value, true);
    
	// 文書中のフォント設定
    //	$pdf->AddMBFont(KOZMIN ,'SJIS');
	if (strlen($printObj['isSmallFont']) > 0){
        $pdf->SetFont('kozminproregular', '', 9);
        //		$pdf->SetFont(KOZMIN,'B', 9);
		$rowHeight = 4;
	} else {
        $pdf->SetFont('kozminproregular', '', 10);
        //		$pdf->SetFont(KOZMIN,'B', 10);
		$rowHeight = 6;
	}
    
	// header() や footer() はコンテンツ印刷時に自動的に挿入される
	$pdf->SetTopMargin(30);
	$pdf->SetAutoPageBreak(true, 35); // 下端から 35 の距離で改ページ
	
    // default でヘッダー罫線がでることを防止: AddPage() より前に実行
    // $pdf->setPrintHeader(false);
    // $pdf->setPrintFooter(false);
    
	// PDF の印刷
	$pdf->AddPage();
	
	$x = $leftMargin + $innerMargin;
	$pdf->SetX($x);
	$w = $pageWidth - $innerMargin * 2;

    $pdf->SetY($GLOBALS['y']);

	// コンテンツの印刷： Header と Footer は _MBFPDF Class の中で処理
    $pdf->SetX($x);
	$pdf->MultiCell($w, $rowHeight, $printObj['greetings'], 0, 'L');
    //	$pdf->MultiCell($w, $rowHeight, convert($printObj,'greetings'), 0, 'L');
    $pdf->SetX($x);
	$pdf->MultiCell($w, $rowHeight, $printObj['contents'], 0, 'L');
    //	$pdf->MultiCell($w, $rowHeight, convert($printObj,'contents'), 0, 'L');
    
	$pdf->Output(); // $pdf->Output("docMaker.pdf","I"); では具合が悪い
	
?>