
var _checkList;
function setCheckList(obj){
    _checkList = obj;
}
function checkList(){
    // {"name":{"code":40,"disease":"病名"},,} 型式のオブジェクト
    return _checkList;
}
function recordForName(name){
    // 診療行為名に対応する コード・病名 のレコードを返す
    return _checkList[name];
}

var _currentName;
function setCurrentName(name){
    _currentName = name;
}
function currentName(){
    // 選択されている診療行為名を返す
    return _currentName;
}


//////////////////////////////////////////////////////////////////
///// 病名チェック機能 //////////////////////////////////////////////

function putDiseases(count, diseaseCellValue){
    // 本文の病名欄に病名を追加
    // 選択された病名を配列に入れる
    var diseases = new Array();
    for (num=0; num < count; num++){
        var disease = elmFor(num + ".name").value;
        if (disease.length > 0){
            var suffix = elmFor(num + ".suffix").value;
            if (suffix.length > 0) disease += " " + suffix;
            diseases.push(disease); // ポップアップで選択されている値
        }
    }
    if (diseases.length == 0) return; // 追加すべき病名がなかった
    
    // 各病名に年月日をつける
    var array = new Array();
    var yymmdd = shortDate(parent().currentDate());
    for (num in diseases){
        array.push(yymmdd + " " + diseases[num]);
    }
    
    // 「病名欄」内容にこれらの病名を追加
    for (num in array)
        diseaseCellValue += "\n" + array[num];
    
    // diseaseCellValue をサーバの病名欄に収納
    // この後の診療欄保存と contamination を生ずるので worker でマルチスレッド処理
    changedDisease(trim(diseaseCellValue));
}
function showSelectDialog(obj, diseaseCellValue){
    // 選択ダイアログを表示
    var w = 300;
	var x = 10;
	var y = 10;
    var action = "openHelp('./checkerHelp.html')";
    var elm = openSeeThroughPanel("_floatPanel", x, y, w, "病名チェック", action);
    if (!elm) return;
    elm.style.padding = "8px";

    //console.log("showSelectDialog", encodeObject(obj)); //##

    var num = 0;
    for (title in obj){
        var div = newDIV(elm, "");
        div.style.paddingBottom = "5px";
        div.style.backgroundColor = "#fff";
        div.style.borderRadius = "8px";
        div.style.padding = "5px 8px";
        div.style.marginBottom = "8px";
        div.style.fontSize = "9pt";
        
        var dv = newDIV(div, "");
        dv.innerHTML = title + " に対応する病名を選択";

        // 接尾語
        var menus = prefix(); 
        menus.splice(0, 0, "");
        var rowDiv = newDIV(dv, "");
        var sp = newSPAN(rowDiv, "");
        sp.innerHTML = "接頭語";
        sp.style.paddingRight = "5px";
        var pu = newPopupMenu(rowDiv, num + ".prefix", menus, "");

        // 病名
        var rowDiv = newDIV(dv, "");
        var sp = newSPAN(rowDiv, "");
        sp.innerHTML = "病　名";
        sp.style.paddingRight = "5px";
        var menus = obj[title];
        var pu = newPopupMenu(rowDiv, num + ".name", menus, "");
        
        // 接尾語
        var menus = suffix(); 
        menus.splice(0, 0, "");
        var rowDiv = newDIV(dv, "");
        var sp = newSPAN(rowDiv, "");
        sp.innerHTML = "接尾語";
        sp.style.paddingRight = "5px";
        var pu = newPopupMenu(rowDiv, num + ".suffix", menus, "");
        num++;
    }
    
    var div = newDIV(elm, "");
    var dv = newDIV(div, "/left-side");
    dv.innerHTML = vc_version();
    dv.style.fontSize = "9pt";
    dv.style.color = "#888";
    dv.style.width = "40%";
    var dv = newDIV(div, "/right-side");
    dv.style.paddingRight = "0";
    var bt = newDIV(dv, "/fixButton");
    bt.innerHTML = "病名欄に追加";
    bt.setAttribute("onclick", "putDiseases('" + num + "','" + diseaseCellValue + "')");
}

function changedDisease(diseaseCellValue){
    // サーバの病名欄を読込みメモリー上のものを置換するとともに病名欄に表示
    //console.log("changedDisease", diseaseCellValue); //##

    var container = new Object();
    var tag = "ProgressSection.disease";
    container[tag] = encodeSTRING(diseaseCellValue);
    container["owner"] = owner();
    container["patientId"] = parent().patientId();
    container["entryDate"] = parent().currentDate();
    container["timeLimit"] = parent().timeLimit();
    var noaString = encodeObject(container);
    //console.log("noaString", noaString); //##

    var worker = new Worker('./cellEditorWorker.js');
    worker.postMessage(noaString); // ### worker に命令書 noaString を送る ###
    
    worker.onmessage = function (event) {
        // ### worker の処理したデータを受け取る ###
        var answer = event.data; // ### worker からの返答 ###
        //alert("worker.onmessage->"+answer); //##
        
		var array = answer.split("<SEPARATOR>");
		if (array.length > 1){
            // サーバから返されたデータから tag, dateTime, value を取り出す
            var obj = JSON.parse(array[1]);
            
            var dateTime = parent().currentDate();
            if (obj.entryDate)
                dateTime = obj.entryDate;
            else
                alert("kickEditorWorker: obj.entryDate->"+obj.entryDate); //##
            
            var value = "";
            for (key in obj){
                // closeCellEditor() でサーバへ送った key を基に処理
                if (key == "owner") continue;
                else if (key == "patientId") continue;
                else if (key == "timeLimit") continue;
                else if (key == "entryDate") continue; // dateTime = obj[key];
                else {
                    tag = key;
                    value = obj[key];
                    value = convertSTRING(value, '\n', '<br>');
                    //alert(tag+"->"+dateTime+"->"+value);//##
                    
                    parent().showCellValue(value, dateTime, tag);
                }
            }
		}
    }
}
function makeCheckDisease(){
    // 診療行為と病名の突き合わせ処理を実行：チェック・アルゴリズムを生成
    
    // 診療行為をスキャンし、チェックリストに同じ行為がないか探す
    var items = new Array(); // チェック対象となる診療行為の配列
    var array = treatmentArray();
    for (num in array){
        var rec = array[num]; // 診療行為名：rec.name コード：rec.code
        //alert("rec->"+encodeObject(rec)); //##
        if (rec.isOwn * 1 > 0) continue; // 自費はスキップ
        
        for (name in checkList()){
            if (name == rec.name){
                // 診療行為に対応する病名があった
                items.push(name);
                break;
            }
        }
    }
    // 処方欄をスキャンし、チェックリストに同じ薬剤がないか探す
    var obj = parent().valueForTag("ProgressSection.prescription");
    var buff = obj.value;
    if (buff.indexOf("自費") < 0){ // 自費処方はノーチェック
        buff = convertSTRING(buff, "\n", "<br>");
        buff = convertSTRING(buff, "</span>", "<br>");
        var array = buff.split("<br>");
        for (num in array){
            var ln = array[num];
            if (ln.indexOf("---") >=0) continue; // 用法行はスキップ
            var ary = ln.split('('); // "薬剤名(投与量)" 型式以外はスキップ
            if (ary.length == 1) continue; // 薬剤名のみ取り出す
            
            var medicine = trim(ary[0]);
            for (name in checkList()){
                if (name == medicine){
                    // 診療行為に対応する病名があった
                    items.push(name);
                    break;
                }
            }
        }
    }
    if (items.length == 0) return; // 病名チェック不要
    
    // 病名欄で対応病名のいずれかの有無をチェック
    var obj = parent().valueForTag("ProgressSection.disease");
    var diseaseCellValue = obj.value;
    
    var records = new Object(); // 新規追加すべき病名：重複を避けるため配列でなくオブジェクト
    var checks = new Object(); // チェックが必要なオブジェクトを入れる
    var hasNewMenu = false;
    for (num in items){
        var name = items[num]; // 診療行為名
        var rec = recordForName(name);
        var found = false;
        var ary = rec.disease.split(',');
        for (n in ary){
            var disease = ary[n];
            if (diseaseCellValue.indexOf(disease) >= 0)
                found = true; // 病名欄に name に対応する病名があった
        }
        
        // 対応病名がひとつも無ければ対応病名群から選択させる
        if (! found){
            var title = name;
            ary.splice(0, 0, "");
            checks[name] = ary.sort();
            hasNewMenu = true;
        }
    }
    // チェックが必要なものがあればダイアログを開く
    if (hasNewMenu) showSelectDialog(checks, diseaseCellValue);
}

var _prefix;
var _suffixes;
function setPrefix(array){
    _prefix = array;
}
function prefix(){
    // 接頭語の配列を返す
    return _prefix;
}
function setSuffix(array){
    _suffixes = array;
}
function suffix(){
    // 接尾語の配列を返す
    return _suffixes;
}

function gotSuffixMenu(answer){
    // サーバから接尾語リストを取得
    var obj = JSON.parse(answer);
    //console.log("gotSuffixMenu", encodeObject(obj)); //##
    
    var array = new Array();
    for (num in obj){
        var rec = obj[num];
        array.push(rec.menu);
    }
    setSuffix(array);
    //console.log("suffix", suffix()); //##
    
    makeCheckDisease(); // チェック・アルゴリズムを生成
}
function getSuffix(answer){
    // サーバから接頭語リストを取得
    var obj = JSON.parse(answer);
    //console.log("gotSuffixMenu", encodeObject(obj)); //##
    
    var array = new Array();
    for (num in obj){
        var rec = obj[num];
        array.push(rec.menu);
    }
    setPrefix(array);

    parent().get_menu(owner(), "接尾語", gotSuffixMenu);
}
function doCheckDiseases(){
    // サーバから接頭語リストを取得
    parent().get_menu(owner(), "接頭語", getSuffix);
}

///// 病名チェック機能 //////////////////////////////////////////////
//////////////////////////////////////////////////////////////////



function saveCheckList(){
    // 診療行為と病名のセットをサーバへ保存
    var name = elmFor("checkItemPop").value; // 診療行為名
    var disease = elmFor("diseaseF").value; // 病名
    
    // diseases から空アイテムや空文字を除去
    var newArray = Array();
    var array = disease.split(',');
    for (num in array){
        var st = trim(array[num]);
        if (st.length) newArray.push(st);
    }
    disease = newArray.join(',');
    
    var args = new Object();
    args["name"] = name;
    args["disease"] = disease;
    
    NRCall("PUT_DISEASE_TO_PRICELIST", args, showCheckList);
}

function resetCheckList(answer){
    // 病名チェッカーのリストを再読込後、病名チェッカー・パネルを再表示
    var obj = JSON.parse(answer);
    setCheckList(obj); // vinCalcChecker.js
    
    // フィルターを読み込んでおく
    getFiter();
    
    // 病名チェッカーパネルを再表示
    openCalcChecker();
}
function removedCheckList(answer){
    NRCall("GET_DISEASE_FROM_PRICELIST", null, resetCheckList);
}
function removeCheckList(name){
    // 診療行為と病名のセットを削除
    if (confirm(name + " を削除していいですか")){
        var args = new Object();
        args["name"] = name;
        
        NRCall("REMOVE_DISEASE_FROM_PRICELIST", args, removedCheckList);
    }
}

function showDisease(answer){
    // サーバから返された病名を病名欄に表示
    elmFor("diseaseF").value = answer;
}
function selectedCheckItem(elm){
    // 診療行為ポップアップが選択された
    var args = new Object();
    if (elm.value) args["name"] = encodeSTRING(elm.value);
    
    NRCall("GET_DISEASE_FROM_PRICELIST", args, showDisease);
}

function changeDiseaseSource(elm){
    // 過去履歴からの病名リストのチェックボックスが変更された
    if (elm.checked){
        var name = elmFor("checkItemPop").value; // 診療行為名
        
        var elm = elmFor("diseasePopArea");
        elm.innerHTML = "";
        var sp = newSPAN(elm, "");
        sp.innerHTML = "Loading ...";
        sp.style.fontSize = "9pt";
        sp.style.color = "#f00";

        // 過去１年間の全カルテ履歴から name とともに使われた病名を探して返す
        var args = new Object();
        args["name"] = encodeSTRING(name);
        NRCall("GET_DISEASE_FROM_HOSTORY", args, gotDiseseHistory);
    } else {
        get_menu(owner(), "ProgressSection.disease", gotDisesesMenu);
    }
}

function selectedDisease(elm){
    // 病名が選択された
    var ary = elm.value.split('(');
    var disease = ary[0]; // "不全流産($gw w)" を "不全流産" にする
    var ta = elmFor("diseaseF");
    var val = ta.value;
    if (val.length == 0)
        ta.value = disease;
    else
        ta.value = trim(val) + "," + disease;
}

function selectedDiseaseTag(disease){
    // 病名が選択された
    var ta = elmFor("diseaseF");
    var val = ta.value;
    if (val.length == 0)
        ta.value = disease;
    else
        ta.value = trim(val) + "," + disease;
}

function gotDiseseHistory(answer){
    // 過去履歴からの病名リストを表示
    var array = JSON.parse(answer);
    //_initDebug(true); //##
    //alert("gotDiseseHistory->"+encodeObject(array)); //##
    
    // 以下の処理がどうしても PHP 側ではうまくいかないのでこちら側で処理
    var obj = new Object();
    for (num in array){
        var buff = array[num];
        if (! buff) continue;
        if (buff.length == 0) continue;
        _debug("-- "+num+" buff->"+buff); //##

        buff = convertSTRING(buff, '\n', '<br>');
        buff = convertSTRING(buff, '</span>', '<br>');
        var rows = buff.split('<br>');
        for (row in rows){
            var ln = trim(rows[row]); // "131202 切迫流産( w)" 形式
            if (ln.length == 0) continue;
            if (ln.indexOf("style=") >= 0) continue;
            
            var ary = ln.split(' ');
            if (ary.length > 1){
                var st = ary[1]; // "切迫流産( w)" 形式
                var ar = st.split('(');
                obj[ar[0]] = ""; // "切迫流産" 形式
            }
        }
    }
    _debug("obj->"+encodeObject(obj)); //##

    var elm = elmFor("diseasePopArea");
    elm.innerHTML = "";
    // 病名ポップアップ・メニューを生成
    var div = newDIV(elm, "");
    var ul = newUL(div, "");
    ul.setAttribute("class", "listMembers");
    for (key in obj){
        if (key.length == 0) continue;
        
        var li = newLI(ul, key);
        li.setAttribute("class", "blueButton");
        li.setAttribute("onclick", "selectedDiseaseTag('" + key + "')");
    }
}
function gotDisesesMenu(answer){
    var obj = JSON.parse(answer);
    //_initDebug(true); //##
    _debug("gotDisesesMenu->"+encodeObject(obj)); //##
    
    var menus = [""];
    for (num in obj){
        var rec = obj[num];
        if (rec.menu.length){
            menus.push(rec.menu);
        }
    }
    
    var elm = elmFor("diseasePopArea");
    elm.innerHTML = "";
    // 病名ポップアップ・メニューを生成
    var div = newDIV(elm, "");
    var pm = newPopupMenu(div, "diseasePop", menus, "");
    pm.setAttribute("onchange", "selectedDisease(this)");
}

function got_item_meu(){
	// アイテムリストを表示する
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
			// "itemSelectorArea" の上にポップアップメニュー生成
			var obj = JSON.parse(array[1]);
            //alert("got_item_meu->"+encodeObject(obj)); //##
            
			// obj は {"再診料":"saishin",,} のようなオブジェクトの配列
			var items = [""];
			for (title in obj){
                if (title.length == 0) continue;
                
				items.push(title);  // title:"再診料"
			}
            
			// 病名入力エリア
			var elm = document.getElementById("diseaseArea");
			elm.innerHTML = "";
            
			// item 選択ポップアップを表示
			var pu = newPopupMenu(elm, "checkItemPop", items, currentName());
            pu.setAttribute("onchange", "selectedCheckItem(this)");
            
            // コメント
            var sp = newSPAN(elm, "");
            sp.innerHTML = "に対応する病名を以下で選択ください（複数選択可）";
            sp.style.fontSize = "9pt";
            sp.style.color = "brown";
            
            // チェックボックスを生成
            var div = newDIV(elm, "");
            var cb = newCHECKBOX(div, "", "過去履歴から病名を選択", 0);
            cb.setAttribute("onchange", "changeDiseaseSource(this)");
            cb.style.fontSize = "9pt";

            // 病名ポップアップ
            var div = newDIV(elm, "diseasePopArea");
            
            // 対応病名欄
            var div = newDIV(elm, "");
            var value = "";
            var ta = newTEXTAREA(div, "diseaseF", 30, 5, value);
            ta.style.fontSize = "10pt";
            
            if (currentName().length){
                // 診療行為名が指定されているなら対応病名を表示
                var obj = recordForName(currentName());
                ta.value = obj.disease;
            }
            
            get_menu(owner(), "ProgressSection.disease", gotDisesesMenu);
		}
	}
}
function get_item_meu(code){
	// 診療行為マトリックスの選択で起動され、該当アイテムリストをリクエスト
    //alert("GET_CHILD_SELECTOR->"+code); //##

    var args = new Object();
    args["code"] = code;
    NRCallVin("GET_CHILD_SELECTOR", args, got_item_meu);
}

function openCheckEditor(td, name){
    // 行為エディターを開く
    
    // name があれば記憶しておく
    setCurrentName((name) ? name : "");

    var elm = elmFor("contentsArea");
    elm.innerHTML = "";
    var base = newTD(elm, "editorNode", "");

    base.setAttribute("colspan", "2");
    base.style.border = "thin solid #ccc";
    base.style.padding = "3px";
    base.style.backgroundColor = "#ffe";
    
    // 診療行為マトリックスを表示
    // obj = 一括(00) 初診(11) 再診(12) 診他(13) 内服(21) 屯服(22) 外用(23) 薬加(29) 皮注(31) 静注(32) 点滴(33) 処置(41) 処薬(48) 手術(51) 麻酔(52) 手薬(58) 検査(60) 判断(69) 画像(70) 其他(80) 入院(90) 入他(91)
    var div = newDIV(base, "");
    var ul = newUL(base, "");
    ul.setAttribute("class", "listMembers");
    
    var li = newLI(ul, "");
    li.style.display = "inline";
    li.style.paddingRight = "5px";
	var im = newIMAGE(li, "", "./close.png", "X");
	im.style.height = "12px";
    im.setAttribute("class", "expandIcon");
    im.setAttribute("onclick", "openCalcChecker()");

    var obj = medicalActions().itemMatrix; // vin.js
    for (key in obj){
        var code = obj[key];
        if (code * 1 == 0) continue;
        if (code.substr(0, 1) * 1 == 1) continue;
        if (code * 1 == 29) continue;
        if (code * 1 == 48) continue;
        if (code * 1 == 58) continue;
        if (code * 1 == 69) continue;
        if (code * 1 == 80) continue;
        if (code.substr(0, 1) * 1 == 9) continue;
        
        var li = newLI(ul, key);
        li.setAttribute("id", "item:"+code);
        li.setAttribute("class", "yellowButton");
        li.setAttribute("onclick", "get_item_meu('" + code + "')");
    }
    
    // 病名入力エリア
    var div = newDIV(base, "diseaseArea");
    
    var div = newDIV(base, "");
    div.style.marginTop = "10px";
    div.style.marginBottom = "10px";
    div.style.textAlign = "right";
    if (name){
        var bt = newDIV(div, "/fixBUtton");
        bt.innerHTML = "削除";
        bt.setAttribute("onclick", "removeCheckList('" + name + "')");
    }
    var bt = newDIV(div, "/fixBUtton");
    bt.innerHTML = "確定";
    bt.setAttribute("onclick", "saveCheckList()");

    // name があれば name に相当するコントロールを表示
    if (name){
        var obj = recordForName(name);
        get_item_meu(obj.code);        
    }
}

function showCheckList(answer){
    // チェックリストを表示
    if (answer){
        var obj = JSON.parse(answer);
        setCheckList(obj);
    } else {
        var obj = checkList(); // vin.js 立ち上げ時に読み込まれている
    }
    
    //_initDebug(true); //##
    //alert("showCheckList->"+encodeObject(obj)); //##
    
    var elm = elmFor("contentsArea");
    elm.innerHTML = "";
    var tbl = newTABLE(elm, "", "");
    tbl.style.fontSize = "9pt";
    tbl.style.width = "100%";
    
    // HEADER ==============================
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "/checkerTitleLabel", "診療行為");
    td.style.width = "30%";
    var td = newTD(tr, "/checkerTitleLabel", "対応病名");

    // LIST ================================
    for (name in obj){
        var rec = obj[name];
        var disease = rec.disease;
        
        var tr = newTR(tbl, "", "");
        var td = newTD(tr, "/checkerLabel", name);
        td.setAttribute("onclick", "openCheckEditor(this,'" + name + "')");
        var td = newTD(tr, "/checkerValue", disease);
    }

    // FOOTER ==============================
    var tr = newTR(tbl, "", "");
    // 追加ボタン
    var td = newTD(tr, "/checkerLabel", "");
    td.setAttribute("onclick", "openCheckEditor(this)");
	var im = newIMAGE(td, "", "./add-field.png", "?");
	im.style.height = "14px";
	im.style.position = "relative";
	im.style.top = "3px";
    var sp = newSPAN(td, "");
    sp.innerHTML = "追加";
    sp.style.paddingLeft = "5px";
    // チェック・ボックス
    var td = newTD(tr, "/checkerTitleLabel", "");
    var cb = newCHECKBOX(td, "", "診療費計算で病名チェック", checkDiseases());
    cb.setAttribute("onchange", "setCheckDiseases(this)");
    cb.style.fontSize = "9pt";
}

function openCalcChecker(){
    // 診療行為と病名の突合チェッカーを開く
    var w = 320;
	var x = 5; // 表示するx座標
	var y = 5; // 表示するy座標
    var title = "病名チェッカー";
    var action = "openHelp('vinCalcCheckerHelp.html')";
    var elm = openSeeThroughPanel("_floatPanel", x, y, w, title, action);
    if (!elm){
        alert("_floatPanel がないのでパネルを表示できません"); return;
    }
    elm.style.padding = "3px";
    var div = newDIV(elm, "contentsArea");
    div.style.backgroundColor = "#fff";
    div.style.borderRadius = "5px";
    
    showCheckList();
}

function vc_version(){
    return "Ver.140905";
}
