
///////////////////////////////////////
///// NOA へ問い合わせて得る値 /////////////

function patientId(){
    // 外部ウインドーとして Pickup から起動された場合
    //var pid = document.getElementById("_patientId").value;
    //if (pid.length) return pid;
    
    // toolArea で起動された場合
	return parent().patientId();
}

function patientName(){
    //var pname = document.getElementById("_patientName").value;
    //if (pname.length) return pname;
    
	var obj = parent().valueForTag("NameSection.patientKanjiName");
	return obj.value;
}

function owner(){
    //var own = document.getElementById("_owner").value;
    //if (own.length) return own;
    
	return parent().owner();
}

///// NOA へ問い合わせて得る値 /////////////
///////////////////////////////////////


var _separator=',';

var _records;
var _templateNames;
function setRecords(obj){
	// テンプレート object の入った配列を記憶
	//alert("setRecords->"+encodeObject(obj)); //##
    
	_records = obj;
	_templateNames = [""];
	for (menuItem in obj){
		_templateNames.push(menuItem);
	}	
	_debug("setRecords->"+encodeObject(_records)); //##
}
function records(){
    return _records;
}
function recordForKey(menuItem){
	// menuItem に対応するオブジェクトを返す
	// array = [owner, value, public, freq]
    if (!_records) return null;
        
	var obj = _records[menuItem];
	return (obj) ? obj : null;
}
function freqForKey(menuItem){
	// menuItem に対応するオブジェクトを返す
	// array = [owner, value, public, freq]
    if (!_records) return 0;
    
	var obj = _records[menuItem];
	return (obj) ? obj.freq : 0;
}
function templateNames(){
	// テンプレート名の配列を返す
	return _templateNames;
}

var _labels;
function setLabels(value){
	_labels = value.split(",");
}
function labels(){
    // マトリックス表示のタイトルになるラベルの配列
	return _labels;
}

///////////////////////////
/// Ajax による処理 /////////

function savedTemplate(answer){
	//alert("savedTemplate:"+answer);
    
	var obj = JSON.parse(answer);
	//alert(encodeObject(obj)); //##

    closeFloatPanel();
	getTemplates();
}
function saveTemplate(){
	var name = trim(document.getElementById("templateF").value);
	if (name.length == 0){
		alert("テンプレート名が設定されていません");
		return;
	}
	var buff = trim(document.getElementById("labelF").value);
	if (buff.length == 0){
		alert("ラベル名が指定されていません");
		return;
	}
	
	// label 区切りを改行からカンマに変換してサーバに送る
	var array = buff.split('\n');
	var items = array.join(_separator);
    
	// これらの値を DB に記憶
	var freq = freqForKey(name);
    
    //alert("saveTemplate->"+name+"->"+freq+"=>"+items); //##
    
	put_menu(owner(),"PICKUP",name,freq,items,savedTemplate);
}

function setStandard(answer){
    //alert("setStandard->"+answer); //##
    var obj = (answer) ? JSON.parse(answer) : new Object();
    setStandardList(obj); // standardCenter.js
    
	showMenuPopup();
}
function gotTemplates(answer){
	// サーバが返してきた JSON を解析
	var objects = JSON.parse(answer);
    
	var records = new Array();
	var array = objects;
	for (num in array){
		var rec = array[num];
		records[rec.menu] = rec;
	}
	setRecords(records);		// records を記憶
    
    // 基準値を読み込んでおく
    var args = new Object();
    NRCall("GET_STANDARD", args, setStandard);
}
function getTemplates(){
	// メニューをサーバから読み込み
	get_menu(owner(), "PICKUP", gotTemplates);
}

function incrementFrequency(tag, menuItem, value){
	// 選択されたメニューの頻度を１つ増やす
	// ### menuItem が MenuTable に存在しない場合 menuItem の新規登録も行う
	put_menu(owner(),tag,menuItem ,"",value,showFrequency);
}

function removedTemplate(answer){
	// サーバが返してきた JSON を解析
	//alert(answer); //##
	var obj = eval('(' + answer + ')');
	//alert(encodeObject(obj)); //##
    
    closeFloatPanel();
	getTemplates();
}
function removeTemplate(){
	var menuItem = document.getElementById("templatePopup").value;
	if (confirm(menuItem + " のテンプレートを削除していいですか")){
		remove_menu(owner(), "PICKUP", menuItem, null, removedTemplate);
	}
}

/// Ajax による処理 /////////
///////////////////////////


///////////////////////////////////
/// localStorage による処理 /////////

function getWindowSize(windowName){
	// DocMaker のウインドー位置とサイズをサーバへリクエスト
    var st = window.localStorage["pickupWindowSize"];
    if (!st) return;
    
    var array = st.split(",");
    var x = array[0] * 1;
    var y = array[1] * 1;
    var w = array[2] * 1;
    var h = array[3] * 1;
    // resize を先にしておかないと元が大きいサイズだった場合 moveTo しよう
    // としてもウインドー境界の制限で移動できない場合がある
    window.resizeTo(w, h);
    window.moveTo(x, y);
}
function putWindowSize(){
	// DocMaker のウインドー位置とサイズをサーバへ記憶
    
    // ウインドーが TOOL でなく外部ウインドーならサイズを記憶
    // if (window.name == "tools") とやるとどういう訳かエラーになる
    var name = window.name;
    if (name == "tools") return;
    
    var array = new Array();
	array.push(window.screenLeft);
	array.push(window.screenTop - 22);
	array.push(window.outerWidth);
	array.push(window.outerHeight);
    
    window.localStorage["pickupWindowSize"] = array.join(",");
    
    showFadeoutInfo("message", "window サイズと位置を記憶しました", 500);
}

function putSelectedItem(item){
    // 選択された item を localStorage に記憶
    window.localStorage["pickupItem"] = item;
}
function getSelectedItem(){
    return window.localStorage["pickupItem"];
}

/// localStorage による処理 /////////
///////////////////////////////////


var _recObj;
function CSV(){
	// CSV で出力する
	var buff = "";
	
	// タイトル行
	buff += '"' + "受診日" + '"';
	buff += ',"' + "時刻" + '"';
	var array = labels();
	for (var i=0,ct=array.length; i < ct; i++){
		buff += ',"' + array[i] + '"';
	}
	buff += '\n';

	// データ行
	var rows = 0;
	for (date in _recObj){
		var rec = _recObj[date];
		var array = date.split(" "); // "2009-07-27 07:03:45"
		buff += '"' + array[0] + '"'; // "2009-07-27"
		buff += ',"' + array[1] + '"'; // "07:03:45"
		var array = labels();
		for (var i=0,ct=array.length; i < ct; i++){
			var key = array[i] + "(";
			// レコード中に key があるかどうか探す
			var ary = rec.split(key);
			if (ary.length > 1){
				// key にマッチするものがあれば value をピックアップ
				var st = ary[1];
				var ary2 = st.split(")");
				var value = (ary2.length > 1) ? ary2[0] : "";
			} else
				var value = "";
			buff += ',"' + value + '"';
		}
		buff += '\n';
	}
	
	// CSV 表示用ウインドーを開く
	var elm = document.getElementById("_confirm");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "/base-table");
	tbl.style.backgroundColor = "#ffc";
	
	// テンプレート名
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	var fd = newTEXTAREA(td, "", "50", "20", buff);
	
	// テンプレート名
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "＊ この CSV を Exel などで表示してください");
    td.style.fontSize = "10pt";
    td.style.color = "#aaa";
	
	// ### openFloatPanel() の style は opener:NOA のライブラリーが使われる
	openFloatPanel(tbl, 5, 5, "CSV 出力");
}

function showMatrix(obj){
	// 選択されたテンプレートに基づきデータをリストアップ
	_debug("== showMatrix->"+encodeObject(obj)); //##

	var elm = document.getElementById("dataArea");
	elm.innerHTML = "";
	if (!obj) return;
    
	_recObj = obj;
	
	var tbl = newTABLE(elm, "/base-table");
    tbl.style.fontSize = "9pt";
    tbl.style.backgroundColor = "#eff";
    tbl.style.border = "thin solid #aaa";
    
    // タイトル行
	var tr = newTR(tbl, "title", "");
	var td = newTD(tr, "", "受診日");
	var array = labels();
    for (i in array){
		var label = array[i];
		var td = newTD(tr, "", label);
	}
	
	// データ行
	var rows = 0;
	for (date in obj){
		var rec = obj[date];
		var tr = newTR(tbl, "record", ""); rows++;
		var td = newTD(tr, "date", date);
		var array = labels();
        for (i in array){
			var key = array[i] + "(";
			// レコード中に key があるかどうか探す
			var ary = rec.split(key);
			if (ary.length > 1){
				// key にマッチするものがあれば value をピックアップ
				var tailOfLeft = ary[0].substr(ary[0].length - 1);
				if ((tailOfLeft == "(") || (tailOfLeft == ")")){
					// key が全体一致していることが確認された
					var st = ary[1];
					var ary2 = st.split(")");
					var value = (ary2.length > 1) ? ary2[0] : "";
				} else {
					// key の末尾が部分一致している場合はデータなし
					var value = "";
				}
			} else
				var value = "";
			var td = newTD(tr, "data", value);
            // 基準値に合致するかチェック
            checkStandard(td, labels()[i], value);
		}
	}
	if (rows == 0) return;
	
	// コントロール行
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", rows + " records　");
	td.setAttribute("colspan", labels().length + 1);
    td.setAttribute("class", "controls");
	var bt = newDIV(td, "/whiteButton");
    bt.innerHTML = "CSV で出力";
	bt.setAttribute("onclick", "CSV()");
}

var _menuItem;
function gotRecordsForKeys(answer){
	// サーバが返してきた JSON を解析
	//alert(answer); //##
	var obj = JSON.parse(answer);
    
	_debug("gotRecordsForKeys->"+encodeObject(obj)); //##
    
	showMatrix(obj);
}
function clickedTemplate(){
	// テンプレート・ポップアップが選択された
	_menuItem = document.getElementById("itemPop").value;
	if (_menuItem.length == 0){
		showMatrix(null);
		return;
	}
    
    //_initDebug(true); //##
    //_debug("clickedTemplate->"+_menuItem); //##
    
    // 選択された _menuItem を localStorage に記憶
    putSelectedItem(_menuItem);
    
    var div = document.getElementById("dataArea");
    div.innerHTML = "";
    var sp = newSPAN(div, "");
    sp.innerHTML = _menuItem + " のデータを検索中 ...";
    sp.style.padding = "10px";
    sp.style.color = "#f55";
    sp.style.fontSize = "10pt";
    
    // マトリックス表示のタイトルになるラベル配列を記憶
    var rec = recordForKey(_menuItem);
    _debug("clickedTemplate: rec->"+encodeObject(rec)); //##
    
    setLabels(rec.value);
    putWindowSize();
	
	// 選択されたテンプレートに基づきデータをリストアップ
	// keys を含むすべてのレコード:rec.value をサーバへリクエスト
	// keys は配列ではなく文字列のままサーバへ送る
    var args = new Object();
    args["owner"] = owner();
    args["patientId"] = patientId();
    args["keys"] = rec.value;
    
    NRCall("GET_RECORDS_FOR_KEYS", args, gotRecordsForKeys);
}
function showMenuPopup(){
	// テンプレートのポップアップメニューを生成
	var elm = document.getElementById("popupArea");
	elm.innerHTML = "";
    var item = getSelectedItem(); // localStorage に記憶された item
	var pu = newPopupMenu(elm, "itemPop", templateNames(), item);
	pu.setAttribute("onchange", "clickedTemplate()");
    pu.style.position = "relative";
    pu.style.bottom = "5px";
    
    // 選択された item に該当するデータを表示
    clickedTemplate();
}

function help(){
	window.open("./pickupHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function showAnotherPanel(){
    // 別ウインドーに表示する
    var url = "../Pickup?patientId=" + patientId()
        + "&patientName=" + patientName() + "&owner=" + owner();
	window.open(url,"Pickup"
				,"width=900,height=700,scrollbars=yes,resizable=yes");
}

function initPickup(){
    //_initDebug(true); //##
    
	var elm = document.getElementById("base");
	
	// === HEADER ==============================
    var div = newDIV(elm, "/tool-header");
    var dv = newDIV(div, "/left-side");
    dv.innerHTML = "Pickup";
    dv.style.fontSize = "10pt";
    dv.style.width = "40%";
    
    var dv = newDIV(div, "/right-side");
    if (window.name == "tools"){
        // 別ウインドーで開くアイコン
        var img = newIMAGE(dv, "outArrowIcon", "outArrow.png", "out");
        img.setAttribute("onclick", "showAnotherPanel()");
        img.style.height = "12px";
        img.style.marginRight = "10px";
        img.style.position = "relative";
        img.style.bottom = "3px";
        setInfoTip("outArrowIcon", "別ウインドーで開く"); // HELP
    }
	var img = newIMAGE(dv, "helpIcon", "./help.png", "?");
	img.setAttribute("onclick", "help()");
	img.style.height = "18px";
    setInfoTip("helpIcon", "HELP"); // HELP
	
	// === ポップアップ表示エリア ==================
    var div = newDIV(elm, "/clearfix");
    div.style.backgroundColor = "#caecdc"; // "#aec";
    var dv = newDIV(div, "/left-side");
    dv.style.width = "60%";
    dv.style.fontSize = "10pt";
	var sp = newSPAN(dv, "");
	sp.innerHTML = (patientId()) ? patientId() : "* カルテが開いていません *";
    sp.style.paddingRight = "10px";
	var sp = newSPAN(dv, "");
	sp.innerHTML = patientName();
    sp.style.paddingRight = "10px";
    var dv = newDIV(div, "/right-side");
	var sp = newSPAN(dv, "popupArea");
    sp.style.position = "relative";
    sp.style.top = "3px";

	// === データ表示エリア =======================
    var div = newDIV(elm, "dataArea");
	
	// === FOOTER ==============================
    var div = newDIV(elm, "/tool-footer");
    var dv = newDIV(div, "/left-side");
    dv.style.width = "20%";
	var img = newIMAGE(dv, "hammerIcon", "./hammer.png", "?");
	img.setAttribute("onclick", "showEditor()");
	img.style.height = "15px";
    img.style.marginRight = "10px";
    setInfoTip("hammerIcon", "初期設定"); // HELP
    var dv = newDIV(div, "/right-side");
	var sp = newSPAN(dv, "");
    sp.innerHTML = version();
    sp.style.position = "relative";
    sp.style.top = "3px";
    
	// ポップアップメニューを読み込み、カルテデータをセット
	getTemplates();

	// ウインドー・サイズをサーバから読み込みサイズ調整
    getWindowSize();
}

function version(){
	return "Ver.140529";
}
