
var _canvasWidth = 900;
var _canvasHeight = 600;
var _knobWidth = 25;

/////////////////////////////////////////////
///// NOA からの継承値 /////////////////////////

// NOA 組込みの場合は patientId() などを直接取得できるが
// 外付けツールにも出来るようあえて以下の仕組みを使う
var _patientId;
function setPatientId(pid){
    _patientId = pid;
}
function patientId(){
    if (!_patientId){
        var pid = document.getElementById("_pid").value;
        if ((pid !== "undefined") && (pid.length > 0)){
            // URL に添えてパラメータが送られた：FRONT から使われる
            _patientId = pid;
            document.getElementById("keyF").value = _patientId;
        } else {
            // NOA の patientId() を使う
            _patientId = parent().patientId();
        }
    }
    return _patientId;
}

var _patientInfo;
function setPatientInfo(obj){
    _patientInfo = obj;
}

var _kanjiName;
function setPatientKanjiName(name){
    _kanjiName = name;
}
function patientKanjiName(){
    return (_kanjiName) ? _kanjiName : _patientInfo.patientKanjiName;
}

function lastVisitDate(){
    return _patientInfo.lastVisitDate;
    // return (parent()) ? parent().lastVisitDate() : "";
}

///// NOA からの継承値 /////////////////////////
//////////////////////////////////////////////


var _patientInfo;
function setPatientInfo(obj){
    _debug("setPatientInfo->"+encodeObject(obj)); //##
    
    _patientInfo = obj;
}
function patientInfo(pid){
    for (num in _patientInfo){
        var obj = _patientInfo[num];

        if (obj.patientId == pid){
            return obj;
        }
    }
    return null;
}

var _imageObj;
function setImageObj(obj){
    // obj.files から "_" で始まるファイル名を除去
    // "_" で始まるファイル名は削除されたファイルを表す
    var files = obj.files;
    var array = new Array();
    for (num in files){
        var filename = files[num];
        if (filename.charAt(0) != "_")
            array.push(filename);
    }
    obj.files = array;
    _imageObj = obj;
    
    _debug("_imageObj->"+encodeObject(_imageObj)); //##
}
function imagePath(){
    return _imageObj.path;
}
function imageList(){
    return _imageObj.files;
}

var _tagetDate;
function setTargetDate(date){
    // 対象年月を受け取る
    _tagetDate = date;
}
function targetDate(){
    // 検索対象年月日を返す
    return _tagetDate;
}

var _image;
function setImage(img){
    _debug("setImage->"+img); //##
    
    _image = img;
}
function image(){
    return _image;
}

var _imageName;
function setImageName(name){
    _imageName = name;
}
function imageName(){
    return _imageName;
}

///////////////////////////////////
/// localStorage による処理 /////////

function getWindowSize(){
	// DocMaker のウインドー位置とサイズを localStorage から取り出す
    var windowStatus = window.localStorage["InsViewerWindowSize"];
    if (windowStatus){
        var array = windowStatus.split(",");
        var x = array[0];
        var y = array[1];
        var w = array[2];
        var h = array[3];
		// resize を先にしておかないと元が大きいサイズだった場合 moveTo しよう
		// としてもウインドー境界の制限で移動できない場合がある
		window.resizeTo(w, h);
		window.moveTo(x, y);
    }
}

function setInsViewerScale(val){
    // 縮小率の scale を localStorage へ記憶
    window.localStorage["insViewerScale"] = val;
}
function insViewerScale(){
    // 縮小率の scale を返す
    var val = window.localStorage["insViewerScale"];
    return (val) ? val * 1 : 0.5;
}

var _trimWidth;
var _trimHeight;
function setTrimingWidth(val){
    _trimWidth = val;
}
function trimingWidth(){
    // CANVAS の巾を返す
    return (_trimWidth) ? _trimWidth * 1 : _canvasWidth;
}

function setTrimingHeight(val){
    _trimHeight = val;
}
function trimingHeight(){
    // CANVAS の高さを返す
    return (_trimHeight) ? _trimHeight * 1 : _canvasHeight;
}

/// localStorage による処理 /////////
///////////////////////////////////

//////////////////////////////////////////////////////////
///// PREFERENCE /////////////////////////////////////////

function setDefaultScale(){
    var elm = document.getElementById("scaleF");
    var scale = elm.value;
    if (isDigit(scale)){
        setInsViewerScale(scale);
        document.getElementById("preferenceArea").innerHTML = "";
    } else {
        alert("数値を入力してください");
        elm.focus();
    }
}
function preference(){
    // 初期設定を表示
    var elm = document.getElementById("preferenceArea");
    if (elm.innerHTML.length > 0){
        elm.innerHTML = "";
        return;
    }
    elm.innerHTML = "";
    elm.style.fontSize = "9pt";
    var div = newDIV(elm, "");
    div.style.backgroundColor = "#ffe";
    div.style.border = "thin solid #ccc";
    div.style.padding = "10px";
    
    var sp = newSPAN(div, "");
    sp.innerHTML = "初期設定";
    sp.style.paddingRight = "10px";
    // 拡大幅規定値
    var sp = newSPAN(div, "");
    sp.style.padding = "5px 5px";
    var val = insViewerScale();
    var fd = newFIELD(sp, "scaleF", "縮小拡大巾の規定値", 4, val);
    fd.setAttribute("onchange", "setDefaultScale()");
    fd.style.textAlign = "right";
    fd.focus();
}

///// PREFERENCE /////////////////////////////////////////
//////////////////////////////////////////////////////////


////////////////////////////////
/// neuron.js による処理 /////////

function gotPatientList(answer){
    //alert("gotPatientList->"+answer); //##
    
	var obj = JSON.parse(answer);
    if (obj){
        setPatientInfo(obj);
        showIdList(obj);
    }
}
function getPatientList(searchKey){
	// 検索キーにマッチしたカルテのリストを表示
	var elm = document.getElementById("dropArea");
    elm.style.display = "block"; // 表示する

	get_patients(searchKey, gotPatientList);
}

function gotInsurance(answer){
    //alert("gotInsurance->"+answer); //##
	var obj = JSON.parse(answer);
    
    if (obj) showInsurance(obj);
}
function getInsurance(patientId, dateTime){
	// 保険証データをサーバから取得し表示

    // owner() は localStorage.js
    get_page(owner(), patientId, dateTime, gotInsurance);
}

function gotFiles(answer){
    // リクエストした画像を受け取る
    var obj = JSON.parse(answer);
    if (obj){
        //alert("gotFiles->"+answer); //##
        
        setImageObj(obj);
        showImageList();
    }
    
    // 画像保存後、表示されない場合があるので再表示
    redraw();
}
function getFiles(patientId, patientName){
    // patientId の保険証画像のリストをリクエスト
    if (patientId) setPatientId(patientId);
    if (patientName) setPatientKanjiName(patientName);
    
    var args = new Object();
    args["patientId"] = trim(patientId);
    NRCall("GET_INS_IMAGE", args, gotFiles);
}

function changeKouhi(elm){
    // 公費種別ポップアップが変更された時の動作
    var item = elm.value;
    if (isSame(item, " ")){
        // 公費種別：なし で全部をクリアする
        elmFor("shubetsu.pub").value = " ";
        elmFor("ownerName.pub").value = " ";
        elmFor("ownerNumber.pub").value = " ";
        elmFor("recipientNumber.pub").value = " ";
        elmFor("paymentRatio.pub").value = " ";
        elmFor("payment.pub").value = " ";
        
        var dv = elmFor("pubDateArea");
        dv.innerHTML = "";
        inputDate(dv, "交付日", "", "startDate", true);
        inputDate(dv, "有効期限", "", "expiredDate", true);
    } else {
        // 公費種別に伴い、公費名称・負担率を自動入力
        var array = publicInsObjects(); // lib.js
        var ratio = array[item];
        elmFor("ownerName.pub").value = item;
        elmFor("paymentRatio.pub").value = ratio;
    }
}

function savedData(answer){
    if (insViewerSaveAndClose() > 0){ // localStorage.js
        // InsView パネルを閉じる
        window.close();
    } else {
        // データ保存後、画像一覧を表示
        closeControlArea();
        
        // ポップアップ更新とともに再読込
        getFiles(patientId());
    }
}
function savedImage(){
    // 画像保存後、入力された保険情報をサーバへ保存
    
    // 保険情報を object に格納
    var obj = new Object();
    obj = setValue(obj, 'HealthInsurance.shubetsu');
    obj = setValue(obj, 'HealthInsurance.ownerNumber');
    obj = setValue(obj, 'HealthInsurance.ownerName');
    obj = setValue(obj, 'HealthInsurance.ownerPhone');
    obj = setValue(obj, 'HealthInsurance.kigou');
    obj = setValue(obj, 'HealthInsurance.bangou');
    // HealthInsurance.discountRatio
    obj = setValue(obj, 'HealthInsurance.kubun');
    obj = setValue(obj, 'HealthInsurance.paymentRatio');
    obj['HealthInsurance.startDate'] = elmFor("startDate").value;
    obj['HealthInsurance.expiredDate'] = elmFor("expiredDate").value;
    obj['HealthInsurance.confirmation'] = today();
    obj = setValue(obj, 'PublicInsurance.ownerName', true);
    obj = setValue(obj, 'PublicInsurance.ownerNumber', true);
    obj = setValue(obj, 'PublicInsurance.recipientNumber', true);
    obj = setValue(obj, 'PublicInsurance.shubetsu', true);
    obj = setValue(obj, 'PublicInsurance.paymentRatio', true);
    obj = setValue(obj, 'PublicInsurance.payment', true);
    obj['PublicInsurance.startDate'] = elmFor("startDate.pub").value;
    obj['PublicInsurance.expiredDate'] = elmFor("expiredDate.pub").value;
    
    if (!parent()){
        // 親ウインドウを認識できない場合
        alert("このパネルを開きなおしてください");
        window.close();
        return;
    }
    
    // 保険情報を DB に保存
    var currentDate = parent().currentDate();
    put_page(owner(), patientId(), currentDate, "", obj, savedData, true);
    
    function setValue(obj, tag, isPublic){
        // obj へ tag に相当する値を記憶
        var ary = tag.split("."); // tag = "HealthInsurance.shubetsu"
        var fieldName = ary[1];
        var cid = (isPublic) ? fieldName + ".pub" : fieldName;
        var val = elmFor(cid).value;
        obj[tag] = (val.length > 0) ? val : " ";
        return obj;
    }
}
function saveData(filename){
    // 画像をサーバへ名前をつけて保存：保険証アップロード
    if (! patientId()){
        alert("カルテが特定されていません。対象カルテを検索し氏名などを確認してから画像を取り込んでください");
        return;
    }
    
    // Booking のウインドー位置とサイズをサーバへ記憶
    put_windowSize(0, -22, "InsViewerWindowSize");
    
    // encodeURI は '&' をエンコードしてくれないのでこちら側でエンコード
    var can = canvas();
    var ctx = can.getContext("2d");
    var imgData = ctx.getImageData(0,0,trimingWidth(),trimingHeight());
    
    // クリッピングした画像を一時置きする canvas を生成
    var elm = document.getElementById("_tmp");
    elm.innerHTML = "";
    var tmpCan = newCANVAS(elm,"",trimingWidth(),trimingHeight(),null);
    var ctx2 = tmpCan.getContext("2d");
    ctx2.putImageData(imgData, 0, 0);
    
    var imageSrc = tmpCan.toDataURL();
    imageSrc = imageSrc.replace('data:image/png;base64,',''); // 頭の不要部分を削除
    
    var args = new Object();
    args["patientId"] = patientId();
    args["folder"] = "Insurance";
    args["filename"] = filename;
    args["value"] = imageSrc;
    
    _postServer("PUT_IMAGE", "../NOA/postServer.php", args, savedImage);
}

function removedImage(answer){
    // 選択されたファイルが削除された
    showFadeoutInfo("messageArea", answer, 800);
    
    // 画像を一旦消去し
    closeControlArea();
    clearDraw();
    // ポップアップ更新とともに再読込
    getFiles(patientId());
}
function removeImage(){
    // サーバ上の選択されたイメージに削除マークをつける
    var args = new Object();
    args["patientId"] = trim(patientId());
    args["filename"] = document.getElementById("imgPop").value;
    NRCall("REMOVE_INS_IMAGE", args, removedImage);
}

function foundMonthPatient(answer){
    var obj = JSON.parse(answer);
    //alert("->"+encodeObject(obj)); //##
    
    showMonthlyList(obj);
}
function findMonthPatient(){
    // 対象年月のカルテのリストをリクエスト
    var st = targetDate().substr(0, 8); // "2012-01-"
    var args = new Array();
    var fromDateTime = encodeSTRING(st + "01 00:00:00");
    var toDateTime = encodeSTRING(st + "31 23:59:59");

    alert("NRGetVisitor not found"); //##
    NRGetVisitor(fromDateTime, toDateTime, foundMonthPatient);
}

/// neuron.js による処理 /////////
////////////////////////////////


function findPatient(){
    // 検索キーにより NOA データを検索
	var key = document.getElementById("keyF").value;
	if (key.length > 0)
		getPatientList(key);
}

var _path;
function showImage(popup){
    // 保険証イメージを表示
    var filename = imageList()[0];
    if (popup) filename = popup.value;
    var href = imagePath() + "/" + filename;
    
    elmFor("filenameArea").innerHTML = filename;
    ajustKnobPosition();

    var img = document.createElement("img");
    img.src = href;
    setImage(img);
    
    // redraw() による描画は showInsurance() で動作させること
    closeControlArea();
    
    if (popup){
        // popup に該当する日付の情報を開く 
        getInsurance(patientId(), dateTimeOf(filename));
    } else {
        getInsurance(patientId(), todayAndTime());
    }
    
    function dateTimeOf(filename){
        // 画像ファイル名から日付を解析して返す
        var year = filename.substr(9, 4);
        var month = filename.substr(13, 2);
        var day = filename.substr(15, 2);
        var hour = filename.substr(17, 2);
        var min = filename.substr(19, 2);
        var sec = filename.substr(21, 2);
        return year+"-"+month+"-"+day+" "+hour+":"+min+":"+sec;
    }
}

function showImageList(){
    // 保険証イメージのリストを表示
	var elm = document.getElementById("popupArea");
    elm.innerHTML = "";
    var div = newDIV(elm, "/left-side");
    div.style.width = "90%"; //##
    
    var sp = newSPAN(div, "");
    sp.innerHTML = "保険証履歴";
    sp.style.fontSize = "10pt";
    sp.style.paddingRight= "5px";
   
    // canvas の属性を初期値へ戻す
    initCanvasAttributes();
    
    if (imageList() && imageList().length){
        var pu = newPopupMenu(div, "imgPop", imageList(), "");
        pu.setAttribute("onchange", "showImage(this)");
        
        var bt = newDIV(div, "/fixButton");
        bt.innerHTML = "削除";
        bt.setAttribute("onclick", "removeImage()");
        bt.style.marginLeft = "5px";
        showImage(null);
    } else {
        clearDraw();
        var msg = patientId() + " の保険証の画像ファイルはありません";
        var color = "rgb(255,0,0)"; // red
        drawText(10, 20, msg, color);
        getInsurance(patientId(), todayAndTime());
    }
   
    // アップロード・ボタン
    var bt = newDIV(div, "/whiteButton");
    bt.innerHTML = "画像アップロード";
    bt.setAttribute("onclick", "showUploader()");

    // HAMMER ICON
    var div = newDIV(elm, "/right-side");
    var img = newIMAGE(div, "icon", "./hammer.png", "preference");
    img.setAttribute("onclick","preference()");
    img.setAttribute("class", "expandIcon");
    img.style.height = "14px";
    img.style.position = "relative";
    img.style.top = "8px";
}

function setNow(cid){
    // 年月日ポップアップに現在の日時をセット
    var elm = document.getElementById(cid+".datePopArea");
    elm.innerHTML = "";
    
    var dateTime = todayAndTime();
    var ary = arrayWithDateTime(dateTime);
    console.log("setNow", cid, ary[0]*1, ary[1]*1, ary[2]*1); //##

    newDatePopUp(elm, cid, "平成", ary[0]*1, ary[1]*1, ary[2]*1);
}
function showInsurance(obj){
    // 保険情報を表示
    var insObj = obj.healthInsurance;
    var pubObj = obj.publicInsurance;
    
	var elm = document.getElementById("patientInfoArea");
    elm.innerHTML = "";
    
    var dv = newDIV(elm, "");
    dv.style.paddingLeft = "10px";

    // 患者情報
    showData(dv, "ID", patientId());
    showData(dv, "氏名", patientKanjiName(), true);
    showData(dv, "最終受診日", lastVisitDate());
    showData(dv, "保険証確認", valueOf(insObj, "confirmation"));
    
    // NOA に記述された保険証情報
    var div = newDIV(elm, "");
    div.style.border = "thin solid #ccc";
    div.style.backgroundColor = "#caecdc";
    div.style.padding = "5px 10px";
    div.style.margin = "5px 0";
    var dv = newDIV(div, "");

    // 保険者番号の入力と同時に DB からマッチした保険者をリアルタイムに検索
    var fd = newFIELD(dv, "numberKeyF", "", 18, "");
    fd.style.marginRight = "5px";
    fd.setAttribute("placeholder", "保険者番号で検索"); // 入力ヒントを表示
    fd.setAttribute("type", "search");
    fd.setAttribute("onkeyup", "searchIns()");

    inputField(dv, "保険者番号", insObj, "ownerNumber", 15);
    var fd = elmFor("ownerNumber");

    inputPop(dv, "種別", insObj, "shubetsu", shubetuMenu());
    inputField(dv, "保険者名", insObj, "ownerName", 35);

    var dv = newDIV(div, "");
    inputField(dv, "保険者電話", insObj, "ownerPhone", 13);
    inputField(dv, "記号", insObj, "kigou", 10);
    inputField(dv, "番号", insObj, "bangou", 10);
    
    var menus = ["", "本人", "家族"];
    inputPop(dv, "区分", insObj, "kubun", menus);
    var pu = elmFor("kubun");
    if (pu.value.length == 0) pu.value = "3"; // default 値
    
    var menus = ["", "0", "1", "2", "3", "10"];
    inputPop(dv, "負担割合", insObj, "paymentRatio", menus);
    var dv = newDIV(div, "");
    inputDate(dv, "交付日", valueOf(insObj, "startDate"), "startDate");
    inputDate(dv, "有効期限", valueOf(insObj, "expiredDate"), "expiredDate");

    // NOA に記述された保険証情報
    var div = newDIV(elm, "");
    div.style.padding = "2px 10px";
    div.style.margin = "5px 0";
    var dv = newDIV(div, "");
    // 公費種別
    var menus = publicInsItems(); // lib.js
    var pu = inputPop(dv, "公費種別", pubObj, "shubetsu", menus, true);
    pu.setAttribute("onchange", "changeKouhi(this)");
    var menus = ["", "0", "1", "2", "3", "10"];
    inputPop(dv, "負担割合", pubObj, "paymentRatio", menus, true);
    inputField(dv, "負担額", pubObj, "payment", 4, true);
    
    var dv = newDIV(div, "");
    inputField(dv, "公費名称", pubObj, "ownerName", 35, true);
    inputField(dv, "負担番号", pubObj, "ownerNumber", 10, true);
    inputField(dv, "受給番号", pubObj, "recipientNumber", 10, true);

    var dv = newDIV(div, "pubDateArea");
    inputDate(dv, "交付日", valueOf(pubObj, "startDate"), "startDate", true);
    inputDate(dv, "有効期限", valueOf(pubObj, "expiredDate"), "expiredDate", true);

    // canvas へ描画
    if (imageList() && imageList().length){
        showSlider();
        redraw();
    }
    window.scroll(0,0);
    redraw();
    
    
    function valueOf(obj, fieldName){
        var rec = obj[fieldName];
        if (rec){
            return (rec.val) ? rec.val : "";
        }
        return "";
    }
    
    function inputField(dv, label, insObj, alias, size, isPublic){
        // 入力フィールドを生成
        var cid = (isPublic) ? alias+".pub" : alias;
        
        var sp = newSPAN(dv, "");
        sp.innerHTML = label;
        sp.style.paddingRight = "2px";
        sp.style.fontSize = "11pt";
        sp.style.position = "relative";
        sp.style.top = "2px";
        
        var fd = newFIELD(dv, cid, "", size, valueOf(insObj, alias));
        fd.style.marginRight = "5px";
        fd.style.fontSize = "11pt";
    }
        
    function inputPop(dv, label, obj, alias, menus, isPublic){
        // ポップアップ・メニューを生成
        var cid = (isPublic) ? alias+".pub" : alias;
        
        var sp = newSPAN(dv, "");
        sp.innerHTML = label;
        sp.style.paddingRight = "3px";
        sp.style.fontSize = "11pt";
        sp.style.position = "relative";
        sp.style.top = "3px";
        
        var sp = newSPAN(dv, cid + "Area");
        sp.style.marginRight = "5px";
        
        // 健保では負担割合の default を３割とする
        var item = valueOf(obj, alias);
        if (!isPublic && (item == "") && (alias == "paymentRatio"))
            item = "3";
        var pu = newPopupMenu(sp, cid, menus, item);
        
        return pu;
    }
    
    function showData(elm, label, val, bold){
        var div = newSPAN(elm, "");
        div.style.fontSize = "10pt";
        
        var sp = newSPAN(div, "");
        sp.innerHTML = label;
        sp.style.padding = "2px 8px";
        sp.style.backgroundColor = "#dff";
        sp.style.border = "thin solid #ccc";
        sp.style.borderRadius = "10px";

        var sp = newSPAN(div, "");
        sp.innerHTML = val;
        sp.style.paddingLeft = "2px";
        sp.style.paddingRight = "10px";
        if (bold){
            sp.style.fontSize = "12pt";
            sp.style.fontWeight = "bold";
            sp.style.color = "#f0d";
        }
    }
}

function inputDate(dv, label, val, alias, isPublic){
    // 年月日ポップアップ・メニューを生成
    var cid = (isPublic) ? alias+".pub" : alias;
    var sp = newSPAN(dv, "");
    sp.innerHTML = "";
    sp.style.paddingRight = "5px";
    var img = newIMAGE(sp, "", "../NOA/timer-set.png", "time");
    img.style.height = "14px";
    img.setAttribute("onclick", "setNow('" + cid +"')");
    img.style.position = "relative";
    img.style.top = "5px";
    img.setAttribute("class", "expandIcon");
    
    var sp = newSPAN(dv, "");
    sp.innerHTML = label;
    sp.style.paddingRight = "2px";
    sp.style.fontSize = "11pt";
    sp.style.position = "relative";
    sp.style.top = "3px";

    var sp = newSPAN(dv, cid+".datePopArea");
    var array = arrayWithDateTime(val);
    var yyyy = array[0] * 1;
    var mm = array[1] * 1;
    var dd = array[2] * 1;
    
    var pu = newDatePopUp(sp, cid, "平成", yyyy, mm, dd);
    var sp = newSPAN(dv, "");
    sp.style.marginRight = "5px";
}

var _shubetuMenu;
function shubetuMenu(){
    // 保険種別の配列を返す
    if (!_shubetuMenu){
        _shubetuMenu = [];
        var array = insTable(); // lib.js
        for (num in array){
            var st = array[num];
            var ary = st.split(":");
            var name = ary[0];
            _shubetuMenu.push(name);
        }
    }
    return _shubetuMenu;
}

function showSearchResult(answer){
    // サーバから返された保険者番号に相当する "保険者名_|_電話番号" を表示
    var obj = JSON.parse(answer);
    //console.log("showSearchResult", encodeObject(obj)); //##
    
    for (fieldname in obj){
        var value = obj[fieldname];
        
        if (fieldname == "shubetsu"){
            var sp = elmFor("shubetsuArea");
            sp.innerHTML = "";
            var pu = newPopupMenu(sp, "shubetsu", shubetuMenu(), value);
        } else if (fieldname == "ownerNumber"){
            if (value.indexOf("HealthInsurance") >= 0) value = "";
            elmFor("ownerNumber").value = value;
        } else if (fieldname == "ownerName"){
            if (value.indexOf("HealthInsurance") >= 0) value = "";
            elmFor("ownerName").value = value;
        } else if (fieldname == "ownerPhone"){
            if (value.indexOf("HealthInsurance") >= 0) value = "";
            elmFor("ownerPhone").value = value;
        }
    }
}
function searchIns(){
    // 保険者番号に一致する保険者名・電話番号を検索し自動表示
    var key = elmFor("numberKeyF").value;
    
    if (trim(key).length > 0){
        // 保険者番号から該当保険者レコードを検索：insurance.js
        var args = new Object();
        args["HealthInsurance.ownerNumber"] = key;
        NRCall("GET_HEALTHINSURANCE_WITH_KEY", args, showSearchResult);
    }
}

function showIdList(records){
    // 検索結果を表示
	var elm = document.getElementById("patientInfoArea");
    elm.innerHTML = "";
    
    clearDraw();
    
    if (records.length == 1){
        // 該当するものが１件のみの場合は次の処理へ直行
        var obj = records[0];
        setPatientInfo(obj);
        getFiles(obj.patientId);
    } else {
        // 該当するものが複数の場合はリストから選択させる
        var tbl = newTABLE(elm, "baseTable");
        tbl.style.fontSize = "10pt";
        var tr = newTR(tbl, "titleBar", "");
        var td = newTD(tr, "center", "カルテ番号");
        var td = newTD(tr, "center", "氏名");
        var td = newTD(tr, "center", "最終受診日");
        
        var patientIdAndName;
        for (r in records){
            var rec = records[r];
            var kanji = (rec.patientKanjiName) ? rec.patientKanjiName : "";
            var lvd = (rec.lastVisitDate) ? rec.lastVisitDate : "";
            var tr = newTR(tbl, "record", "");
            var action = "getFiles('" + rec.patientId +"','" + kanji + "')";
            tr.setAttribute("onclick", action);
            var td = newTD(tr, "/patientList", rec.patientId);
            var td = newTD(tr, "/patientList", kanji);
            var td = newTD(tr, "/patientList", lvd);
            if (! isVisitThisMonth(rec)) td.style.color = "#aaa";
        }
        var tr = newTR(tbl, "footer", "");
        var td = newTD(tr, "", "");
        var st = records.length + " 件みつかりました（グレー文字は対象月に未受診）";
        var td = newTD(tr, "footer", st);
        td.setAttribute("colspan", "2");
    }
    
    function isVisitThisMonth(rec){
        // 今月受診しているかどうかチェック
        var lvd = rec.lastVisitDate;
        if (!lvd) return false;
        return (lvd.substr(0, 7) >= targetDate().substr(0,7)) ? true : false;
    }
}

function showMonthlyList(records){
    // 検索結果を表示
	document.getElementById("popupArea").innerHTML = "";
	var elm = document.getElementById("dropArea");
    elm.style.display = "none"; // 表示しない

    clearDraw();
    closeSlider();
    hideFooter();
    
	var elm = document.getElementById("patientInfoArea");
    elm.innerHTML = "";

    // 該当するものが複数の場合はリストから選択させる
    var tbl = newTABLE(elm, "baseTable");
    tbl.style.fontSize = "10pt";
    var tr = newTR(tbl, "titleBar", "");
    var td = newTD(tr, "center", "カルテ番号");
    var td = newTD(tr, "center", "氏名");
    var td = newTD(tr, "center", "最終受診日");
    
    var patientIdAndName;
    var count = 0;
    for (pid in records){
        var rec = records[pid];
        
        var tr = newTR(tbl, "record", "");
        var td = newTD(tr, "", pid);
        var action = "getPatientList('" + pid + "')";
        td.setAttribute("onclick", action);
        setChangeColor(td, '#000', '#fff');
        var td = newTD(tr, "", rec.kanjiName);
        var td = newTD(tr, "", rec.entryDate);
        if (rec.hasInsImage * 1 == 0)
            td.style.color = "#aaa";
        count++;
    }
    
    var tr = newTR(tbl, "footer", "");
    var td = newTD(tr, "", "");
    var td = newTD(tr, "footer", count + " 件みつかりました");
    var td = newTD(tr, "", "（グレー文字は保険証の画像なし）");
}

function help(){
	window.open("./help.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function uploadDone(){
    // アップロードが終了した
    getFiles(patientId());
}
function upload(){
    // form を submit
    var form = document.getElementById("uploadForm");
    form.submit();
    
    setTimeout(uploadDone, 1000);
}

function closeControlArea(){
    // 画像アップロード用エリアを閉じる
	document.getElementById("controlArea").innerHTML = "";
}
function showUploader(){
    // ファイルのアップロード用エリアを開く
	var elm = document.getElementById("controlArea");
    if (elm.innerHTML.length > 0){
        closeControlArea();
        return;
    }
    elm.innerHTML = "";
    
    // FORM
    var dv = newDIV(elm, "/clearfix");
    dv.style.backgroundColor = "#eee";
    dv.style.padding = "10px";
	var fm = newFORM(dv, "uploadServer.php"); // submit で起動される URL
    fm.style.margin = 0;
    fm.style.padding = 0;
    // ### iframe を使うにはここがキモ ###
    fm.setAttribute("id", "uploadForm");
    fm.setAttribute("target", "iframeElement"); // iframe を指定

    // patientId
	var fd = newFIELD(fm, "", "", "", patientId());
	fd.setAttribute("NAME", "patientId"); // form で送られるパラメータ
	fd.setAttribute("type", "hidden");

	// ファイル選択ボタン
	var dv = newDIV(fm, "file");
    dv.style.padding = "0px 5px";
	var ub = newUploadBUTTON(dv, "", "files[]");
    
	// ファイル・アップロード・ボタン
	// var sb = newSubmitBUTTON(dv, "", "ファイルをアップロード");
    // ### iframe を使うにはここがキモ ###
    // form を見せない形で処理するため submit-button 機能を別に作成
    var bt = newDIV(dv, "/whiteButton");
    bt.innerHTML = "選択したファイルを読込む";
    bt.setAttribute("onclick", "upload()");

    // === データ戻り先として iframe を作成 ===========
    // ### iframe を使うにはここがキモ ###
    var dv = newDIV(elm, "");
    dv.style.display = "none"; // 表示しない
    var fr = newIFRAME(dv, "iframeElement");
}

var _scale = 1;
var _rotation = 0;
var _imageX = trimingWidth()/2;
var _imageY = trimingHeight()/2;
var _step = 5;
var _bigStep = 30;
function initCanvasAttributes(){
    // 初期値に戻す
    _scale = 1;
    _rotation = 0;
    _imageX = 0;
    _imageY = 0;
}
function rotateRight(){
    // イメージを時計方向へ回転
    _rotation += 90;
    redraw();
}
function rotateLeft(){
    // イメージを反時計方向へ回転
    _rotation -= 90;
    redraw();
}
function adjustScale(){
    // scale を規定値にする
    _scale = insViewerScale();
    document.getElementById("slideValueArea").innerHTML = _scale; // スケールを表示
    redraw();
}
function sliderChenged(elm){
    // スライダーが移動した
    _scale = elm.value;
    document.getElementById("slideValueArea").innerHTML = _scale; // スケールを表示
    
    redraw();
}

function redraw(){
    // _scale _rotation を反映し再描画
    if (image()){
        var can = canvas();
        var ctx = can.getContext("2d");
        
        // 再描画前に今までのイメージを消去
        ctx.clearRect(0, 0, can.width, can.height);  
        
        // クリッピング領域で表示
        ctx.beginPath();
        ctx.moveTo(0,0);
        ctx.lineTo(trimingWidth(), 0);
        ctx.lineTo(trimingWidth(), trimingHeight());
        ctx.lineTo(0, trimingHeight());
        ctx.clip();
        
        ctx.save();
      
        if (angle() != 0){
            // 回転準備として位置を移動
            var cx = trimingWidth()/2;
            var cy = trimingHeight()/2;
            ctx.translate(cx, cy); // x軸方向にcx、y軸方向にcy移動
        }

        // 回転(値はラジアンで指定するため変換を行う)
        var rad = _rotation / 180 * Math.PI;
        ctx.rotate(rad); // 座標(0,0)を中心として時計回りにθ回転

        if (angle() != 0){
            // 回転後に位置を元に戻す
            var cx = -1 * trimingWidth()/2;
            var cy = -1 * trimingHeight()/2;
            ctx.translate(cx, cy); // x軸方向にcx、y軸方向にcy移動
        }

        // Imageオブジェクトを、左上の角が座標(x,y)に来るように描画
        var x = _imageX;
        var y = _imageY;
        var w = image().width * _scale;
        var h = image().height * _scale;
        ctx.drawImage(image(), x, y, w, h);  
        
        ctx.restore();
        
        // キャンバス・サイズ調整用つまみの位置を myCanvas 右下に合わせる
        ajustKnobPosition();
    }
}

function closeSlider(){
    // slider 領域を閉じる
    var elm = document.getElementById("sliderArea");
    elm.innerHTML = "";
    elm.style.display = "none"; // 表示しない
}
function showSlider(isNewImage){
    // 拡大縮小用スライダーを表示
    var elm = document.getElementById("sliderArea");
    elm.innerHTML = "";
    elm.style.display = "block"; // 表示する
    var basediv = newDIV(elm, "/tool-footer");
    basediv.style.backgroundColor = "#caecdc";
    basediv.style.border = "thin solid #ccc";
    basediv.style.paddingBottom = "10px";
    
    // === LEFT SIDE ===========================================
    var div = newDIV(basediv, "/left-side");
    div.style.width = "70%";
    div.style.fontSize = "10pt";
    div.style.padding = "5px 10px";
    
    // SCANNED DATE and TIME
    var popupElm = document.getElementById("imgPop");
    if (!popupElm || isNewImage){
        // ポップアップメニューがない場合は新規の画像なので
        // patientId とタイムスタンプから filename を生成
        var array = imageName().split(".");
        if (array.length <= 1){
            alert("filename: "+imageName+" has no SUFFIX");
            return null;
        }
        var suffix = array[array.length-1];
        var filename = patientId()+"_"+todayAndTimeId()+"."+suffix;
    } else {
        filename = popupElm.value;
    }
        
    var sp = newSPAN(div, "");
    sp.innerHTML = selectedDateTime(filename);
    sp.style.color = "#55f";

    // SCALE SLIDER
    var sp = newSPAN(div, "");
    sp.innerHTML = "サイズ";
    sp.style.paddingLeft = "20px";
    sp.style.paddingRight = "5px";
    sp.style.color = "#888";
    
    // SLIDER
    var action = "sliderChenged(this)";
	var val = "1"; 
    var min = "0.2";
    var max = "3";
    var step = "0.01";
    var sl = newSlider(div, "slider", step, val, max, min, action);
    
    // SCALE
    var sp = newSPAN(div, "slideValueArea");
    sp.style.marginLeft = "5px";
    sp.style.padding = "5px 10px";
    sp.style.borderRadius = "10px";
    sp.style.color = "#fff";
    sp.style.backgroundColor = "#88c";
    sp.innerHTML = "scale";
    sp.setAttribute("onclick", "adjustScale()");

    // A4 サイズ
    var sp = newSPAN(div, "");
    sp.style.padding = "0 10px";
    var status = window.localStorage["InsViewerClipSize"] * 1;
    var bx = newCHECKBOX(sp, "expandBox", "A4サイズ", status);
    bx.setAttribute("onchange", "changeClipSize(this)");

    // ROTATE RIGHT
    var sp = newSPAN(div, "/iconArea");
    sp.style.marginLeft = "10px";
	var img = newIMAGE(sp, "icon", "./turnRight.png", "turnRight");
	img.setAttribute("onclick","rotateRight()");
    img.setAttribute("class", "expandIcon");
	img.style.height = "18px";
	img.style.position = "relative";
    img.style.top = "3px";
    
    // ROTATE LEFT
    var sp = newSPAN(div, "/iconArea");
	sp.setAttribute("onclick","rotateLeft()");
    var img = newIMAGE(sp, "icon", "./turnLeft.png", "turnLeft");
    img.setAttribute("class", "expandIcon");
	img.style.height = "18px";
	img.style.position = "relative";
    img.style.top = "3px";
    
    // RELOAD
    var sp = newSPAN(div, "/listMember");
    sp.innerHTML = "再表示";
    sp.setAttribute("onclick", "redraw()");
        
    // === RIGHT SIDE ===========================================
    var div = newDIV(basediv, "/right-side");
    div.style.paddingRight = "5px";
    var status = insViewerSaveAndClose(); // localStorage.js
    var bx = newCHECKBOX(div, "", "", status);
    bx.setAttribute("onchange", "setInsViewerSaveAndClose(this)");
    bx.style.position = "relative";
    bx.style.top = "8px";
    var sp = newSPAN(div, "");
    sp.innerHTML = "保存し終了";
    sp.style.color = "#aaa";
    sp.style.fontSize = "9pt";
    sp.style.marginRight = "10px";
    sp.style.position = "relative";
    sp.style.top = "8px";
    var bt = newDIV(div, "/fixButton");
    bt.innerHTML = "保存";
    bt.style.position = "relative";
    bt.style.top = "6px";
    bt.setAttribute("onclick", "saveData('" + filename + "')");
    
    function selectedDateTime(filename){
        // 保険証履歴ポップアップの値から dateTime を解析して返す
        var yyyy = filename.substr(9, 4);
        var mm = filename.substr(13, 2);
        var dd = filename.substr(15, 2);
        var hr = filename.substr(17, 2);
        var mn = filename.substr(19, 2);
        var sc = filename.substr(21, 2);
        return yyyy+"-"+mm+"-"+dd+" "+hr+":"+mn+":"+sc;
    }
}

function drawText(x, y, text, color){
    // 文字を描く
    var can = canvas();
    var context = can.getContext("2d");
    context.font = "14px 'Times New Roman'";
    context.fillStyle = (color) ? color : "rgb(0,0,0)";
    context.fillText(text, x, y, 1);
}

//////////////////////////////////////////////////
///// dragAndDrop ////////////////////////////////

var _canvas;
function setCanvas(cv){
    _canvas = cv;
}
function canvas(){
    return _canvas;
}
function FileDrop(e, can){
    // el にドロップされた画像を描画
    var file = e.dataTransfer.files[0];
    if (!file) {
        alert('画像ファイルの実体がないのでドロップできません');
        return; // file の実体がないとドロップできない
    }
    
    if(!file.type.match(/image\/\w+/)){
        alert('画像ファイルしか受けつけられません');
        return;
    }
    
    setImageName(file.name);

    var img = document.createElement("img");
    var reader = new FileReader(); 
    reader.onload = function(e) {
        img.src = e.target.result;
    }
    setImage(img);

    // canvas へ描画
    img.onload = function() {
        _scale = 1;
        _rotation = 0;
        _imageX = 0;
        _imageY = 0;
        clearDraw();
        
        var ctx = can.getContext("2d");
        
        // クリッピング領域で表示
        ctx.beginPath();
        ctx.moveTo(0,0);
        ctx.lineTo(trimingWidth(), 0);
        ctx.lineTo(trimingWidth(), trimingHeight());
        ctx.lineTo(0, trimingHeight());
        ctx.clip();
        
        ctx.drawImage(img, 0, 0);  
    }
    
    reader.readAsDataURL(file);
    
    // 画像アップロード用コントロール・エリアを開く
    showSlider("newImage");
}
function clearDraw(){
    // イメージ画面をクリアー
    var can = canvas();
    var context = can.getContext("2d");
    context.clearRect(0, 0, can.width, can.height);

    return true;
}

///// dragAndDrop ////////////////////////////////
//////////////////////////////////////////////////

////////////////////////////////////////////////////////////////
///// 画像をマウス・ドラッグで移動 //////////////////////////////////

var _cursor_locked;
function cursor_lock(can){
    // マウス・ダウンに反応
	_cursor_locked = true;
}
function cursor_unlock(){
    // マウス・アップに反応
	_cursor_locked = false;
    _knob_locked = false;
}

var _cursorX;
var _cursorY;
var _mouse_down;
function angle(){
    // 画像の回転した角度を返す
    var rot = _rotation;
    while (rot < 0) rot += 360;
    while (rot > 360) rot -= 360;
    
    return rot;
}
function mouse_down(evt){
    // マウス・ダウンに反応
    if (!_mouse_down){
        _mouse_down = true;

        switch (angle()){
            case 90:
                _cursorX = evt.offsetX + _imageY; // 画面上では X 軸
                _cursorY = evt.offsetY - _imageX; // 画面上では Y 軸
                break;
            case 180:
                _cursorX = evt.offsetX + _imageX; // 画面上では Y 軸
                _cursorY = evt.offsetY + _imageY; // 画面上では X 軸
                break;
            case 270:
                _cursorX = evt.offsetX - _imageY; // 画面上では X 軸
                _cursorY = evt.offsetY + _imageX; // 画面上では Y 軸
                break;
            default: // image 上のカーソル位置を記憶
                _cursorX = evt.offsetX - _imageX;
                _cursorY = evt.offsetY - _imageY;
                break;
        }
    }
}
function mouse_up(evt){
    // マウス・アップに反応
    _mouse_down = false;
}
function get_mouseXY(evt){
	// マウスで画像や三角ノブをドラッグ
	// Firefox ではうまく動作しない
	if (_cursor_locked){ // 画像がドラッグされている時
        switch (angle()){
            case 90:
                _imageX = (evt.offsetY - _cursorY); // 画面上では Y 軸
                _imageY = - (evt.offsetX - _cursorX); // 画面上では X 軸
                break;
            case 180:
                _imageX =  - (evt.offsetX - _cursorX); // 画面上では Y 軸
                _imageY =  - (evt.offsetY - _cursorY); // 画面上では X 軸
                break;
            case 270:
                _imageX = - (evt.offsetY - _cursorY); // 画面上では Y 軸
                _imageY = evt.offsetX - _cursorX; // 画面上では X 軸
                break;
            default: 
                // レイヤーの左上端を指定位置へ移動
                _imageX = evt.offsetX - _cursorX; // 表示する X 座標
                _imageY = evt.offsetY - _cursorY; // 表示する Y 座標
                break;
        }
        redraw();
    } else if (_knob_locked){ // 三角ノブがドラッグされている時
        // clientX：イベントが発生したウインドウ上の X 座標
        _knobX = evt.clientX - _knobWidth + 8; // 表示するx座標
        _knobY = evt.clientY - _knobWidth + 8; // 表示するy座標
        
        // キャンバス・サイズ調整用つまみを移動
        var knob = elmFor("knob");
        knob.style.left = _knobX;
        knob.style.top = _knobY;
        
        if (_knob_locked){
            // CABVAS のサイズを knob に追従して変更し再描画
            var cpos = getPosition(canvas());
            var kpos = getPosition(elmFor("knob"));
            
            setTrimingWidth(kpos.x - cpos.x + _knobWidth);
            setTrimingHeight(kpos.y - cpos.y + _knobWidth);
            
            // 設定されたサイズで再描画
            showCanvasArea();
        }
    }
}

///// 画像をマウス・ドラッグで移動 //////////////////////////////////
////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////
///// キャンバス・サイズ調整用つまみ ////////////////////////////////

var _knob_locked;
var _knobX = 0;
var _knobY = 0;

function knob_lock(can){
    // マウス・ダウンに反応：マウス・アップは cursor_unlock() を兼用
	_knob_locked = true;
}

function ajustKnobPosition(){
    // キャンバス・サイズ調整用つまみの位置を myCanvas 右下に合わせる
    var pos = getPosition(canvas());
    var knob = elmFor("knob");
    knob.style.left = pos.x + trimingWidth() - _knobWidth + 1;
    knob.style.top = pos.y + trimingHeight() - _knobWidth;
}

///// キャンバス・サイズ調整用つまみ ////////////////////////////////
////////////////////////////////////////////////////////////////

var _oldTrimingHeight;
var _oldTrimingWidth;
function changeClipSize(elm){
    // 「A4サイズ」チェックボックスが変更された
    window.localStorage["InsViewerClipSize"] = (elm.checked) ? "1" : "0";
    
    // 設定されたサイズで再描画
    showCanvasArea();
}
function getClipSize(){
	// A4 サイズか否かを localStorage から取り出す
    var status = window.localStorage["InsViewerClipSize"];
    if (status * 1 > 0){ // A4サイズ
        _oldTrimingWidth = trimingWidth();
        _oldTrimingHeight = trimingHeight();
        
        setTrimingWidth(_canvasWidth);
        setTrimingHeight(1500);
    } else {
        var width = (_oldTrimingWidth) ? _oldTrimingWidth : trimingWidth();
        var height = (_oldTrimingHeight) ? _oldTrimingHeight : trimingHeight();
        setTrimingWidth(width);
        setTrimingHeight(height);
        
        _oldTrimingWidth = null;
        _oldTrimingHeight = null;
    }
}

function hideFooter(){
    // FOOTER を見えなくする
    var elm = document.getElementById("footerArea");
	elm.style.visibility = "hidden";
}

function showCanvasArea(){
    // キャンバス領域を描画
    var dropArea = elmFor("dropArea");
    dropArea.innerHTML = "";
    // cursor_unlock() は CANVAS を外れても機能するよう基底層に仕掛ける
    dropArea.style.paddingBottom = "1000px"; // cursor_unlock() 受入れゾーンを拡張
    dropArea.setAttribute("onmouseup", "cursor_unlock()"); 

    // トリミング・サイズを設定
    getClipSize();
    
    // CANVAS を生成 ===========================================
    var cv = newCANVAS(dropArea, "myCanvas", trimingWidth(), trimingHeight(), null);
    setCanvas(cv);
    cv.style.border = "thin solid #f00";
    
    // ### dragAndDrop ################
    // CANVAS をマウスで掴み可動にする
    cv.style.position = "absolute";
    cv.setAttribute("onmousedown", "cursor_lock(this)"); 
    //cv.setAttribute("ondblclick", "pullLayer(this)"); // doubleClick
    
    // マウスの位置を取得するようにする
	window.onmousemove = get_mouseXY; // マウスの位置を取得するようにする
	window.onmousedown = mouse_down; // マウスの位置を取得するようにする
	window.onmouseup = mouse_up; // マウスの位置を取得するようにする
    
    cv.ondrop=function(e){
        FileDrop(e, cv);
        e.preventDefault();
    };
    
    cv.ondragover=function(e){
        e.preventDefault();
    };
    // ### dragAndDrop ################
    
    // キャンバス・サイズ調整用つまみを描画 =========================
    var knob = newCANVAS(dropArea, "knob", _knobWidth, _knobWidth, null);
    knob.style.position = "absolute";
    knob.setAttribute("onmousedown", "knob_lock(this)"); 
    // knob.setAttribute("onmouseup", "cursor_unlock()"); // 兼用
    
    // 三角形を描画
    var context = knob.getContext("2d");
    context.strokeStyle = "rgba(255,0,0,0.2)"; // ペン・カラー
    context.beginPath();
    // context.lineWidth = lineWidth;
    var x = 0;
    var y = 0;
    var width = _knobWidth;
    var height = _knobWidth;
    context.moveTo(0, height);
    context.lineTo(width, 0);
    context.lineTo(width, height);
    context.closePath();
    context.stroke();
    context.fillStyle = "rgba(255,0,0,0.2)"; // 背景色
    context.fill();
 
    // イメージを描画
    redraw();
    
    // knob 位置を調整
    ajustKnobPosition();
}

function initInsViewer(){
	var elm = document.getElementById("base");
    elm.innerHTML = "";
    
    // === HEADER ================================
    var div = newDIV(elm, "/tool-header");
    div.style.paddingBottom = "5px";
    // --- LEFT SIDE -------------
    var dv = newDIV(div, "/left-side");
    dv.style.width = "500px";
    // TITLE
    var sp = newSPAN(dv, "");
    sp.innerHTML = "保険証 検索対象";
    // DATE
    var sp = newSPAN(dv, "");
    var ary = today().split("-");
    var y = ary[0];
    var m = ary[1];
    var pu = newDatePopUp(sp, "targetYM", "", y, m, "1", true, setTargetDate);
    var sp = newSPAN(dv, "");
    var fd = newFIELD(sp, "keyF", "", 20, "");
    fd.setAttribute("onchange", "findPatient()");
    fd.focus();
    var bt = newDIV(sp, "/whiteButton");
    bt.innerHTML = "検索";
    bt.setAttribute("onclick", "findPatient()");
    bt.style.marginLeft = "5px";
    //var bt = newDIV(sp, "/whiteButton");
    //bt.innerHTML = "当月";
    //bt.setAttribute("onclick", "findMonthPatient()");
    // --- RIGHT SIDE -------------
    var dv = newDIV(div, "/right-side");
    // VERSION
    var sp = newSPAN(dv, "");
    sp.style.color = "#aaa";
    sp.style.paddingRight = "10px";
    sp.innerHTML = version();
    // HELP ICON
	var img = newIMAGE(dv, "", "./help.png", "?");
	img.setAttribute("onclick", "help()");
    img.setAttribute("class", "expandIcon");
	img.style.height = "18px";
	img.style.position = "relative";
    img.style.top = "4px";
    
    // === 画像ファイル・ポップアップ表示エリア =====
    var div = newDIV(elm, "popupArea/clearfix");
    
    // 初期設定エリア 
    var div = newDIV(elm, "preferenceArea");
    
    // アップロード用コントロール
    var dv = newDIV(elm, "controlArea");
    
    // 保険証情報を表示 ========================
    var dv = newDIV(elm, "patientInfoArea");
    
    // メッセージ・エリア
    var dv = newDIV(elm, "messageArea");
    
    // スライダー・エリア ========================
    var dv = newDIV(elm, "sliderArea");
    var dv = newDIV(elm, "filenameArea");
    
    dv.style.clear = "both"; // ### 必要？ ###
    
    // 保険証画像の表示・ドロップ用エリア =========
    var dv = newDIV(elm, "dropArea");

    showCanvasArea();
    
	// ウインドー・サイズをサーバから読み込みサイズ調整
	getWindowSize();
    
    document.getElementById("keyF").value = patientId();
    getPatientList(patientId());
}

function version(){
	return "Ver.150217";
}
