
var _currentUser;
function setCurrentUser(user){
    _currentUser = user;
}
function currentUser(){
    return _currentUser;
}

var _toolMenuObj;
function setToolMenuObj(obj){
    _toolMenuObj = obj;
}
function toolMenuObj(){
    // ツール・メニュー・オブジェクト
    // [{"id":"0","label":"検索","url":"search^[^^]^",,,},,,]
    if (!_toolMenuObj || (_toolMenuObj.length == 0)){
        // _toolMenuObj が空ならテンプレートを用いる
        _toolMenuObj = menuTemplate();
        
        for (num in _toolMenuObj){
            var cell = _toolMenuObj[num];
            
            // menuTemplate() には id がないので num を id として cell に記憶
            // 新たに menuCell が追加される場合は最大 id が振られる
            cell.id = num;
        }
    }
    
    return _toolMenuObj;
}

var _defaultMenus;
function getDefaultMenus(){
    // default menu の配列を生成しておく
    // dataCenter.js 組込みの menuTemplate() により default が決定される
    var records = menuTemplate(); 
    
    _defaultMenus = new Array();
    for (num in records){
        var rec = records[num];
        _debug("getDefaultMenus->"+rec.label); //##
        
        if (rec.fix == "1") _defaultMenus.push(rec.label);
    }
}
function isDefaultMenu(label){
    // label が default menu なら true を返す
    for (num in _defaultMenus){
        if (label == _defaultMenus[num]) return true;
    }
    return false;
}

//////////////////////////////////
///// Ajax ///////////////////////

function gotToolMenu(answer){
    // 読み込んだデータを toolMenuObj() へセット
    var obj = JSON.parse(answer);    
    setToolMenuObj(obj);
    
    // もし template から生成されたものであればサーバへ記憶
    if (isTemplateMenu())
        saveToolMenu();
    
    showToolLayout();
}
function getToolMenu(user){
    // TOOL MENU 構造をサーバへリクエスト
    var args = new Object();
    args["owner"] = owner();
    NRCall("GET_TOOL_MENU", args, gotToolMenu);
}

function saveToolMenu(){
    // TOOL MENU 構造をサーバへ保存
    var array = new Array();
    // 全ての cell.number を打ち直す：更新 CELL の number が以前と変わらない場合は
    // その CELL だけの更新でもよいのだが、工場出荷状態の場合、更新 CELL 以外の CELL が
    // DB に保存されないという問題があるので常に全部を更新する。
    var records = toolMenuObj();
    for (num in records){
        var oldCell = records[num];
        var newCell = new Object();
        
        // oldCell 属性を newCell にコピー
        for (key in oldCell)
            newCell[key] = oldCell[key];
        
        // 整列順序:number を打ち直す
        // ### 番号を打ち直すことによりサーバ上に不要なレコードが残る可能性あり #####
        newCell.id = num;
        newCell.number = num;
        array[num] = newCell;
    }
    
    var args = new Object();
    args["owner"] = user;
    args["value"] = encodeObject(array);
    
    NRPost("PUT_TOOL_MENU", args, replacedMenuCell);
}

///// Ajax ///////////////////////
//////////////////////////////////


//////////////////////////////////////////////
///// ARCHIVE TOOL MENU //////////////////////

function gotToolMenuArchives(answer){
    var obj = JSON.parse(answer);
    var path = obj.path; // "../Users/ohashi/TOOL_MENU"
    var filenames = obj.files; // ["20120905164838.txt","20120905163836.txt"]
    
    showBackup(filenames);
}
function getToolMenuArchives(){
    // TOOL MENU のアーカイブファイル・リストをサーバへリクエスト
    var elm = document.getElementById("workArea");
    if (elm.innerHTML.length){ // toggle 式に開閉
        elm.innerHTML = "";
        return;
    }
    
    var args = new Object();
    args["owner"] = currentUser();
    args["folder"] = "TOOL_MENU";
    args["filename"] = "";
    
    NRCall("GET_ARCHIVE_FILES", args, gotToolMenuArchives);
}

function gotBackup(answer){
    // 読み込んだアーカイブを toolMenuObj() へセット
    //alert("gotBackup->"+answer); //##
    var obj = JSON.parse(answer);
    setToolMenuObj(obj);
    
    var array = new Array();
    // 全ての cell.number を打ち直す：更新 CELL の number が以前と変わらない場合は
    // その CELL だけの更新でもよいのだが、工場出荷状態の場合、更新 CELL 以外の CELL が
    // DB に保存されないという問題があるので常に全部を更新する。
    
    var records = toolMenuObj();
    for (num in records){
        var oldCell = records[num];
        var newCell = new Object();
        
        // oldCell 属性を newCell にコピー
        for (key in oldCell)
            newCell[key] = oldCell[key];
        
        // 整列順序:number を打ち直す
        newCell.number = num;
        array[num] = newCell;
        _debug(num+"->"+newCell.label); //##
    }
    //alert("gotBackup array->"+array); //##
    
    // バックアップで更新された toolMenuObj() をサーバへ保存
    var args = new Object();
    args["owner"] = currentUser();
    args["value"] = encodeObject(array);
    
    NRPost("PUT_TOOL_MENU", args, replacedMenuCell);
}
function getBackup(){
    // TOOL MENU のアーカイブファイルをサーバへリクエスト
    var filename = document.getElementById("fileNamePop").value;
    var args = new Object();
    args["owner"] = currentUser();
    args["folder"] = "TOOL_MENU";
    args["filename"] = filename;
    
    NRCall("GET_ARCHIVE_FILE", args, gotBackup);
}

function removedArchiveFile(answer){
    //alert(answer); //##
    document.getElementById("workArea").innerHTML = ""; // 削除しないと toggle
    getToolMenuArchives();
}
function removeArchiveFile(){
    // アーカイブ・ファイルを削除
    var filename = document.getElementById("fileNamePop").value;
    if (confirm(filename+" を削除していいですか"))
        remove_archive_file(currentUser(), "TOOL_MENU", filename, removedArchiveFile);
}

function removedScrapFiles(answer){
    //alert(answer);
    var array = JSON.parse(answer);
    
    for (num in array){
        _debug(array[num]); //##
    }
}
function removeScrapFiles(){
    // サーバに残る削除済みファイルを全部削除
    if (confirm("確実にゴミ箱を空にしていいですか")){
        NRRemoveScraps(currentUser(), "TOOL_MENU", removedScrapFiles);
    }
}

function showBackup(filenames){
    // バックアップ操作ペーンを開く
    var elm = document.getElementById("workArea");
    elm.innerHTML = "";
    
    var div = newDIV(elm, "");
    div.style.fontSize = "9pt";
    div.style.fontFamily = "arial, Helvetica";
    div.style.padding = "15px 15px";
    div.style.background = "#ffd";
    div.style.border = "thin solid #833";
    div.style.color = "#833"; // brown
    
    var dv = newDIV(div, "");
    dv.style.marginBottom = "5px";
    var sp = newSPAN(dv, "removeLogIcon");
    sp.style.marginRight = "5px";
    setInfoTip("removeLogIcon", "右で選択されたバックアップ・ファイルを削除"); // HELP
    var img = newIMAGE(sp, "", "./remove-field.png", "X");
    img.style.height = "11px";
    img.setAttribute("onclick", "removeArchiveFile()");
    
    // ファイル名が _ で始まる削除済みファイルを抜いたものをポップアップ表示
    var array = new Array();
    for (num in filenames){
        var name = filenames[num];
        if (name.charAt(0) == "_") continue;
        
        array.push(name);
    }
    var pm = newPopupMenu(dv, "fileNamePop", array, "");
    setInfoTip("fileNamePop", "過去のバックアップ・ファイル"); // HELP
    
    var bt = newBUTTON(dv, "", "から復元");
    bt.setAttribute("onclick", "getBackup()");
    
    var dv = newDIV(div, "");
    dv.style.marginBottom = "5px";
    var sp = newSPAN(dv, "removeAllIcon");
    sp.style.marginRight = "5px";
    setInfoTip("removeAllIcon", "サーバに残る削除済みファイルを全部削除"); // HELP
    var img = newIMAGE(sp, "", "./remove-field.png", "X");
    img.style.height = "11px";
    img.setAttribute("onclick", "removeScrapFiles()");
    var sp = newSPAN(dv, "");
    sp.innerHTML = "削除され不可視状態のファイルを全部削除";
    
    // 工場出荷状態へ戻す
    var dv = newDIV(div, "");
    dv.innerHTML = "ツール・メニューを ";
    var bt = newBUTTON(dv, "", "工場出荷状態に戻す");
    bt.setAttribute("onclick", "originalToolLayout()");
    
    // ページ末尾にジャンプ
    var pos = getPosition(bt.parentNode.parentNode);
    window.scroll(0, pos.y);
}

///// ARCHIVE TOOL MENU //////////////////////
//////////////////////////////////////////////


///////////////////////////
/// Dtag and Drop /////////

function f_dragstart(event){
    // ドラッグ開始時の処理
    // ドラッグするデータのid名をDataTransferオブジェクトにセット
    event.dataTransfer.setData("text", event.target.id);
}

function f_dragover(event){
    // ドラッグ要素がドロップ要素に重なっている間の処理
    //　dragoverイベントをキャンセルして、ドロップ先の要素がドロップを受け付けるようにする
    event.preventDefault();
}

function f_drop(event){
    // ドロップ時の処理
    // ドラッグされたデータのid名をDataTransferオブジェクトから取得
    var movedId = event.dataTransfer.getData("text"); // "5.row" 形式
    var ary = movedId.split(".");
    var fromNum = ary[0];
    var currentId = event.currentTarget.id; // "8.row" 形式
    var ary = currentId.split(".");
    var toNum = ary[0];
    
    // drag された CELL を drop 位置に挿入
    var array = toolMenuObj();
    var cell = array[fromNum];
    if (fromNum < toNum){
        array.splice(toNum, 0, cell); // toNum 番目の要素を挿入
        array.splice(fromNum, 1); // fromNum 番目の要素を削除
    } else {
        array.splice(fromNum, 1); // fromNum 番目の要素を削除
        array.splice(toNum, 0, cell); // toNum 番目の要素を挿入
    }
    
    //エラー回避のため、ドロップ処理の最後にdropイベントをキャンセルしておく
    event.preventDefault();
    
    showToolLayout();
    
    // TOOL MENU 構造をサーバへ保存
    saveToolMenu();
}

/// Dtag and Drop /////////
///////////////////////////


var _currentMenuCell;
function menuCellClicked(type, num){
    // メニュー・カスタマイズ用セルがクリックされた
    if (_currentMenuCell){
        if (_currentMenuCell.num == num){
            // 編集画面を閉じる
            _currentMenuCell = null;
            menuCell(type, num);
        } else {
            alert("他の「編集中メニュー」を閉じてから開いてください");
        }
    } else {
        // menuCell を編集モードにする
        _currentMenuCell = new Object();
        _currentMenuCell.type = type;
        _currentMenuCell.num = num;
        
        menuCell(type, num, true);
    }
}

function addMenuCell(type, num){
    // num の次行に新しい menuCell を挿入
    var newNum = (num * 1) + 1;
    
    // new CELL を toolMenuObj() に登録
    var array = toolMenuObj();
    var cell = new Object();
    cell.menuType = type;
    cell.label = "new label";
    cell.url = "";
    cell.id = maxId(array);
    cell.isNew = true;
    array.splice(newNum, 0, cell);
    setToolMenuObj(array); // toolMenuObj() は 明示的セットの要あり
    
    // toolMenuObj に新しい menuCell を挿入し menuCell 編集画面を再描画
    showToolLayout();
    
    function maxId(array){
        // 現存する cell の最大 id を返す
        var max = 0;
        for (num in array){
            var cell = array[num];
            if (cell.id * 1 > max) max = cell.id * 1;
        }
        return max + 1;
    }
}

function redrawTooLayout(answer){
    // menuLayout を再表示
    var obj = JSON.parse(answer);
    
    _currentMenuCell = null; // 必要？？
    setToolMenus(obj);
    openToolLayout();
}
function removedMenuCell(answer){
    // menuCell レイアウト編集画面を再表示
    console.log("removedMenuCell", answer); // 削除報告
    
    // ToolMenu を再読み込みするためブラウザーをリロード
    window.top.location.reload(true);
}
function removeMenuCell(id, label){
    // type, num の menuCell を削除
    if (confirm(id + ": " + label + "を削除していいですか")){
        // id の menuCell をサーバから削除
        var args = new Object();
        args["owner"] = currentUser();
		args["id"] = id;
		args["label"] = label;
        
        NRCall("REMOVE_TOOL_MENU", args, removedMenuCell, true);
    }
}

function cancelMenuCell(type, num){
    // menuCell 編集パネルを閉じる
    _currentMenuCell = null;
    menuCell(type, num);
}

function replacedMenuCell(answer){
    //alert(answer); return; // ”メニュー構造を保存しました” のメッセージ
    
    // ToolMenu を再読み込みするためブラウザーをリロード
    window.top.location.reload(true);
    
    openToolLayout();
}
function replaceMenuCell(type, num){
    // menuCell の内容を編集したものに置換
    var cell = toolMenuObj()[num];
    //alert("replaceMenuCell ->"+ encodeObject(cell)); //##
    
    // default menu か否かの判定は cell.fix が "1" かどうかでもできるが
    // cell.fix="1" で複製されてしまったメニューの削除ができなくなるので
    // menuTemplate() に登録されたラベルかどうかで判定する
    var isDefault = isDefaultMenu(cell.label);
    if (isDefault){
        alert("これは default メニューなのでラベル名は変更されません");
    } else {
        // 重複したラベル名をチェック
        var label = document.getElementById("labelF").value;
        if (isOverlappedLabel(label)){
            alert(label + " は重複しています。別の名称にしてください。");
            return;
        }
        cell.label = label;
    }
    
    cell.menuType = type * 1;
    cell.url = document.getElementById("urlF").value;
    var elm = document.getElementById("iconF");
    cell.icon = (elm) ? elm.value : "";
    var elm = document.getElementById("infoTipF");
    cell.editor = (elm) ? elm.value : "";
    cell.subTitle = (document.getElementById("isSubTitleCheck").checked) ? "1" : "";
    var elm = document.getElementById("windowCheck");
    cell.window = (elm && elm.checked) ? "1" : "";
    var elm = document.getElementById("disabledCheck");
    cell.disabled = (elm && elm.checked) ? "1" : "";
    cell.id = document.getElementById("idNode").innerHTML;
    cell.number = num;
    
    _debug("<p>Edit CELL ->"+ encodeObject(cell)+"</p>"); //##
    
    var array = new Array();
    // 全ての cell.number を打ち直す：更新 CELL の number が以前と変わらない場合は
    // その CELL だけの更新でもよいのだが、工場出荷状態の場合、更新 CELL 以外の CELL が
    // DB に保存されないという問題があるので常に全部を更新する。
    
    //_initDebug(true); //##
    var records = toolMenuObj();
    for (num in records){
        var oldCell = records[num];
        var newCell = new Object();
        
        // oldCell 属性を newCell にコピー
        for (key in oldCell)
            newCell[key] = oldCell[key];
        
        // 整列順序:number を打ち直す
        newCell.number = num;
        array[num] = newCell;
        _debug(newCell.label+"-> "+encodeObject(newCell)); //##
    }
    
    var args = new Object();
    args["owner"] = currentUser();
    args["value"] = encodeObject(array);
    
    NRPost("PUT_TOOL_MENU", args, replacedMenuCell);
    
    
    function isOverlappedLabel(label){
        // label が既存のものと重複していないかチェック
        // ## すでに toolMenuObj() には新規追加した項目も入っている
        var records = toolMenuObj();
        var count = 0;
        for (num in records){
            var cell = records[num];
            if (cell.label == label){
                if (count > 0) return true;
                count++;
            }
        }
        return false;
    }
}

function menuCell(type, num, isActive){
    // menu 属性入力ペーンを生成
    var cell = toolMenuObj()[num];
    _debug("== menuCell->"+encodeObject(cell)); //##
    
    var isSubTitle = (cell.subTitle && (cell.subTitle * 1)) ? true : false;
    var isDefault = isDefaultMenu(cell.label);
    //var isDefault = (cell.fix && (cell.fix * 1)) ? true : false;
    
    var div = document.getElementById(num + ".row");
    div.innerHTML = "";
    if (isSubTitle)
        div.setAttribute("class", "subMenuType");
    else
        div.setAttribute("class", "menuType");
    
    // サブ・タイトル以外に drag and drop を設定
    var isSubTitle = (cell.subTitle && (cell.subTitle * 1)) ? true : false; //##
    if (isSubTitle){
        // 挿入だけはできるようにする
        div.setAttribute("ondragover", "f_dragover(event)");
        div.setAttribute("ondrop", "f_drop(event)");
    } else {
        div.setAttribute("draggable", "true"); // HTML5: ドラッグ可能にする
        div.setAttribute("ondragstart", "f_dragstart(event)");
        div.setAttribute("ondragover", "f_dragover(event)");
        div.setAttribute("ondrop", "f_drop(event)");
    }
    
    var tbl = newTABLE(div, "/base-table");
    tbl.style.fontSize = "10pt";
    
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "", "");
    td.style.width = "25px";
    td.style.verticalAlign = "top";
    // 追加アイコン
    var sp = newSPAN(td, "addMenuIcon");
    sp.style.paddingLeft = "5px";
    sp.style.paddingRight = "5px";
    var img = newIMAGE(sp, "", "./add-field.png", "add");
    img.style.height = "12px";
    img.setAttribute("onclick", "addMenuCell('"+type+"','"+num+"')");
    
    var td = newTD(tr, "", "");
    var dv = newDIV(td, "");
    
    if (isActive){ // 編集モードの menuCell
        // LABEL
        var sp = newSPAN(dv, "/editorLabel");
        sp.style.paddingRight = "5px";
        sp.innerHTML = "LABEL";
        sp.setAttribute("onclick", "menuCellClicked('"+type+"','"+num+"')");
        var sp = newSPAN(dv, "");
        var fd = newFIELD(sp, "labelF", "", 20, cell.label);
        fd.focus();
        if (! isDefault){
            // 固定メニュー以外なら削除アイコンを表示
            var sp = newSPAN(dv, "removeMenuIcon");
            sp.style.paddingLeft = "5px";
            sp.style.paddingRight = "5px";
            var img = newIMAGE(sp, "", "./remove-field.png", "X");
            img.style.height = "11px";
            var action = "removeMenuCell('"+cell.id+"','"+cell.label+"')";
            img.setAttribute("onclick", action);
        }
        // URL
        var dv = newDIV(td, "");
        var fd = newFIELD(dv, "urlF", "URL", 40, (cell.url) ? cell.url : "");
        // 別ウインドー・アイコン
        if (!isSubTitle){
            // アイコン指定
            var dv = newDIV(td, "");
            var fd = newFIELD(dv, "iconF", "ICON", 30, (cell.icon) ? cell.icon : "");
            // infoTip
            var dv = newDIV(td, "");
            var fd = newFIELD(dv, "infoTipF", "HELP", 40, (cell.editor) ? cell.editor : "");
            // 非表示チェックボックス
            var dv = newDIV(td, "");
            var status = (cell.disabled * 1) ? 1 : 0;
            var cb = newCHECKBOX(dv, "disabledCheck", "非表示", status);
            // 別ウインドー・チェックボックス
            var dv = newDIV(td, "");
            var status = (cell.window * 1) ? 1 : 0;
            var cb = newCHECKBOX(dv, "windowCheck", "別ウインドーとして表示", status);
        }
        // サブ・タイトル か メニューかの設定チェック
        var dv = newDIV(td, "");
        var cb = newCHECKBOX(dv, "isSubTitleCheck", "サブ・タイトル", isSubTitle);
        // default の固定メニュー
        var dv = newDIV(td, "");
        var cb = newCHECKBOX(dv, "defaultCheck", "default menu", (isDefault) ? 1 : 0);
        cb.setAttribute("disabled", "true");
        
        // FOOTER
        var dv = newDIV(td, "");
        dv.style.color = "#888";
        dv.style.textAlign = "right";
        // cell.id
        var sp = newSPAN(dv, "");
        sp.innerHTML = "id: ";
        var sp = newSPAN(dv, "idNode");
        sp.innerHTML = cell.id;
        sp.style.paddingRight = "10px";
        // とりやめボタン
        var bt = newBUTTON(dv, "", "とりやめ");
        bt.setAttribute("onclick", "cancelMenuCell('"+type+"','"+num+"')");
        // 確定ボタン
        var bt = newDIV(dv, "/fixButton");
        bt.innerHTML = "確定";
        bt.setAttribute("onclick", "replaceMenuCell('"+type+"','"+num+"')");
    } else { // 参照モードの menuCell
        _debug("isActive == false"); //##
        
        td.style.color = (cell.disabled * 1) ? "#aaa" : "#000";
        // LABEL
        var sp = newSPAN(dv, "/editorLabel");
        sp.style.paddingRight = "5px";
        sp.innerHTML = cell.label;
        sp.setAttribute("onclick", "menuCellClicked('"+type+"','"+num+"')");
        
        // 削除アイコン
        if (! isDefault){
            // 固定メニュー以外なら削除アイコンを表示
            var sp = newSPAN(dv, "removeMenuIcon2");
            sp.style.paddingLeft = "5px";
            sp.style.paddingRight = "5px";
            setInfoTip("removeMenuIcon2", "このメニューを削除"); // HELP
            var img = newIMAGE(sp, "", "./remove-field.png", "X");
            img.style.height = "11px";
            var action = "removeMenuCell('"+cell.id+"','"+cell.label+"')";
            img.setAttribute("onclick", action);
        }
        // URL
        if (cell.url && !isSubTitle){
            var dv = newDIV(td, "");
            dv.innerHTML = cell.url;
            dv.style.fontSize = "8pt";
        }
    }
}

function originalToolLayout(){
    if (confirm("メニュー構造を工場出荷状態に戻していいですか")){
        var args = new Object();
        args["owner"] = currentUser();
		args["id"] = null;
		args["label"] = null;
        NRCall("REMOVE_TOOL_MENU", args, replacedMenuCell);
    }
}

function showToolLayout(){
    // ツールのレイアウトの編集画面を表示
    _debug("== showToolLayout"); //##
    
	var elm = document.getElementById("base");
	elm.innerHTML = "";
    
    ///// TITLE AREA ////////////////////////////
    var div = newDIV(elm, "/yellow-bar");
    div.style.borderRadius = "15px 15px 0 0";
    var tbl = newTABLE(div, "/base-table");
    tbl.style.fontSize = "10pt";
    tbl.style.color = "#666";
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "/left-side", "");
    var sp = newSPAN(td, "toolEditorInfo");
    sp.innerHTML = "TOOL MENU 編集パネル";
    sp.style.paddingLeft = "15px";
    setInfoTip("toolEditorInfo", "NOA へ周辺ツールを組込むことができます"); // HELP
    var td = newTD(tr, "/right-side", "");
    td.style.width = "20px";
    var img = newIMAGE(td, "", "./help.png", "X");
    img.style.height = "18px";
    img.setAttribute("onclick", "openHelp('toolMenuEditorHelp.html')");
    
    ///// WORK AREA /////////////////////////////
    var div = newDIV(elm, "");
    div.style.fontSize = "10pt";
    
    // MAIN TOOL BAR
    var dv = newDIV(div, "/separate-bar");
    var sp = newDIV(dv, "/separatorLabel");
    sp.style.paddingRight = "3px";
    var img = newIMAGE(sp, "", "add-field.png", "add");
    img.style.height = "12px";
    img.setAttribute("onclick", "addMenuCell('"+_main+"','"+(-1)+"')");
    var sp = newDIV(dv, "/separatorLabel");
    sp.style.paddingLeft = "10px";
    sp.innerHTML = "NOA ヘッダーに組込む";
    
    var obj = toolMenuObj();
    _debug("toolMenuObj->"+obj); //##
    
    for (num in obj){
        var cell = obj[num];
        if (cell.menuType == _main){
            var dv = newDIV(div, num + ".row");
            menuCell(_main, num);
        }
    }
    
    // PAGE TOOL BAR
    var dv = newDIV(div, "/separate-bar");
    var sp = newSPAN(dv, "");
    sp.style.paddingRight = "3px";
    var img = newIMAGE(sp, "", "./add-field.png", "X");
    img.style.height = "12px";
    img.setAttribute("onclick", "addMenuCell('"+_page+"','"+(-1)+"')");
    var sp = newDIV(dv, "/separatorLabel");
    sp.style.paddingLeft = "10px";
    sp.innerHTML = "ページ・ヘッダーに組込む";
    
    for (num in obj){
        var cell = obj[num];
        if (cell.menuType == _page){
            var dv = newDIV(div, num + ".row");
            menuCell(_page, num);
        }
    }
    
    // TOOL BAR
    var dv = newDIV(div, "/separate-bar");
    var sp = newSPAN(dv, "");
    sp.style.paddingRight = "3px";
    var img = newIMAGE(sp, "", "./add-field.png", "X");
    img.style.height = "12px";
    img.setAttribute("onclick", "addMenuCell('"+_tool+"','"+(-1)+"')");
    var sp = newDIV(dv, "/separatorLabel");
    sp.style.paddingLeft = "10px";
    sp.innerHTML = "ツール・エリアの TOOL MENU に組込む";
    
    for (num in obj){
        var cell = obj[num];
        if (cell.menuType == _tool){
            var dv = newDIV(div, num + ".row");
            menuCell(_tool, num);
        }
    }
    
    // FOOTER
    var dv = newDIV(div, "/yellow-bar");
    dv.style.borderRadius = "0 0 15px 15px";
    dv.style.fontSize = "9pt";
    dv.style.textAlign = "right";
    dv.style.paddingRight = "10px";
    var a = newA(dv, "TOOL MENU のバックアップ", "#", "");
    a.setAttribute("onclick", "getToolMenuArchives()");
    
    // WORK AREA
    var dv = newDIV(elm, "workArea");
}

function readToolMenu(){
    // TOOL MENU 構造を読み込む
    var kanjiName = document.getElementById("userPop").value;
    
    for (logName in _userList){
        var kanji = _userList[logName];
        if (kanji == kanjiName){
            user = logName;
            setCurrentUser(user);
            
            // TOOL MENU 構造をサーバへリクエスト
            getToolMenu(user);
            return;
        }
    }
    alert(kanjiName + " が userList に見当たりません");
}

var _userList;
function gotUserList(answer){
    // 初期設定パネルを開く
    _userList = JSON.parse(answer);
    //console.log("gotUserList", encodeObject(_userList)); //##

    // ユーザ名選択ポップアップ
    var elm = document.getElementById("base");
    elm.innerHTML = "";
    var div = newDIV(elm, "/yellow-bar");
    div.style.height = "25px";
    div.style.fontSize = "9pt";
    div.style.padding = "10px";
    var pu = newPopupMenu(div, "userPop", _userList, userName());
    
    var sp = newSPAN(div, "tip-left");
    sp.innerHTML = "の TOOL MENU 設定を";
    
    // LOAD BUTTON
    var bt = newDIV(div, "/whiteButton");
    bt.innerHTML = "読込";
    bt.setAttribute("onclick", "readToolMenu()");
    bt.style.marginLeft = "5px";

    // iFrame なら toggleButton にツール名を表示
    var bt = tools().elmFor("toggleButton");
    if (bt) bt.innerHTML = "TOOL MENU 編集ツール";

    // default menu のリストを生成しておく
    getDefaultMenus();
}
function openToolLayout(){
    // 初期設定パネルを開く前にユーザ・セレクターで対象ユーザを特定
    var args = new Object();
    args["hospitalId"] = parent().hospitalId();

    NRCall("GET_USER_LIST", args, gotUserList);
}

function initToolEditor(){
    openToolLayout();
}



